module CGIConfig where

import IOExts
import System

tmpDir, varDir, imageDir, emailTmpDir, frameDir, persistentDir, persistent2Dir, registryDir, keyFile, pbmPath, catProgram, sendmailProgram :: String

-- |global root for WASH data
globalRoot :: String
globalRoot =
  unsafePerformIO (catch (getEnv "HOME") (\ ioe -> return ""))

-- temporary storage
tmpDir = globalRoot ++ "/tmp/"
-- persistent, mutable storage
varDir = globalRoot ++ "/tmp/"

imageDir 	= tmpDir ++ "Images/"
emailTmpDir 	= tmpDir
frameDir	= tmpDir ++ "Frames/"
persistentDir 	= varDir ++ "Persistent/"
persistent2Dir 	= varDir ++ "Persistent2/"
registryDir	= tmpDir ++ "REGISTRY/"
keyFile		= varDir ++ "KEYFILE"

-- path to PBMplus programs
pbmPath		= "/usr/X11R6/bin/"
-- path of cat program
catProgram	= "/bin/cat"
-- path of sendmail program
sendmailProgram	= "/usr/sbin/sendmail"
