module GuaranteedCGI (
	-- * Basics
	CGI
	, ask, tell, io, run
	, once, forever, callWithCurrentHistory, htell, askOffline
	-- * Links and Images
	, Image, internalImage, externalImage, makeImg, makeRef, makePopupRef, makeA
	, backLink, hlink, popuplink, restart
	-- * Page Templates
	, standardPage, htmlHeader, GuaranteedCGI.html, cssPage, cssHeader
	-- * Forms and Widgets
	, HTMLField
	-- ** Form Creation
	, makeForm, standardQuery
	-- ** Form Submission
	, submit, submit0, defaultSubmit, resetField, activeInputField, activate
	, submitLink, submitLink0, defaultSubmitLink
        , submitx, DTree, dtleaf, dtnode
	-- ** Textual Input 
	, inputField, textInputField, checkedTextInputField, passwordInputField, makeTextarea
	-- ** Checkbox
	, checkboxInputField
	-- ** Button
	, makeButton, RadioGroup, radioGroup, radioButton, radioError
	-- ** Image
	, imageField
	-- ** Selection Box
	, selectMultiple, selectSingle, selectBounded
	-- ** File
	, fileInputField, checkedFileInputField
	-- ** Handle Manipulation
	, InputField, VALID, INVALID, value, InputHandle, HasValue
	, F0 (F0), F1 (F1), F2 (F2), F3 (F3), F4 (F4), F5 (F5), F6 (F6), F8 (F8)
	, FL (FL), FA (FA)
	-- ** Attribute Shortcuts
	, fieldSIZE, fieldMAXLENGTH, fieldVALUE
	-- * Advanced
	-- ** Installing Translators
	, runWithHook, docTranslator, lastTranslator
	-- ** Outputable Stuff
	, CGIOutput, Status(..), Location(..), FreeForm(..), FileReference (..)
	-- ** Predefined Types for Input Fields
	, Text(..), NonEmpty(..), AllDigits(..), Phone(..)
	, EmailAddress(..), CreditCardNumber(..), CreditCardExp(..)
	, Password(..), Optional(..)
	-- ** Lowlevel Options
	, CGIOption (..), CGIOptions, URL (..)
	-- ** Servlets
	, makeServlet, makeServletWithHook
	-- * HTML and Style
	, module HTMLMonad98
	, module Style
	-- * Experimental Stuff
	, FrameSet, FrameLayout(..), FrameSpacing(..), makeFrame, makeFrameset, framesetPage
	) where

import CGITypes
import Fields
import Style
import qualified CGIInternals
import CGI (
  	CGI
	, tell, io, run, once, forever, callWithCurrentHistory
	, Image, internalImage, externalImage
	, HTMLField, RadioGroup, radioGroup, InputField, VALID, INVALID, value
	, InputHandle, HasValue
	, F0 (F0), F1 (F1), F2 (F2), F3 (F3), F4 (F4), F5 (F5), F6 (F6), F8 (F8)
	, FL (FL), FA (FA)
	, DTree, dtleaf, dtnode
	, runWithHook, docTranslator, lastTranslator
	, CGIOutput, Status(..), Location(..), FreeForm(..), FileReference (..)
	, Text(..), NonEmpty(..), AllDigits(..)
	, EmailAddress(..), CreditCardNumber(..), CreditCardExp(..)
	, CGIOption(..), CGIOptions
	, makeServlet, makeServletWithHook
	, FrameSet, FrameLayout(..), FrameSpacing(..),
	, makeFrameset, framesetPage
	, Style(..)
	)

import HTMLMonad98 hiding (html)
import qualified CGI

ask :: WithHTML DOCUMENT CGI a -> CGI ()
ask = CGI.ask
htell :: WithHTML HTML IO () -> CGI a
htell = CGI.htell
askOffline :: WithHTML HTML CGI a -> (Element -> IO ()) -> CGI ()
askOffline = CGI.askOffline
makeImg :: AdmitChildIMG y => Image -> HTMLField IMG y ()
makeImg = CGI.makeImg
makeRef :: (AdmitChildA y, Monad m) => String -> WithHTML A m () -> CGI (WithHTML y m ())
makeRef = CGI.makeRef
makeA :: (AdmitChildA y) => String -> String -> HTMLField A y ()
makeA = CGI.makeA
makePopupRef :: (AdmitChildA y) => String -> String -> HTMLField A y ()
makePopupRef = CGI.makePopupRef
backLink :: (AdmitChildA x, Monad m) => HTMLCons A x m ()
backLink = CGI.backLink
hlink :: (AdmitChildA y, Monad m) => URL -> HTMLCons A y m ()
hlink = CGI.hlink
popuplink :: (AdmitChildA y, Monad m) => String -> URL -> HTMLCons A y m ()
popuplink = CGI.popuplink
restart :: CGI ()
restart = CGI.restart
makeForm :: (AdmitChildFORM y) => WithHTML FORM CGI a -> WithHTML y CGI ()
makeForm = CGI.makeForm
standardQuery :: String -> WithHTML FORM CGI a -> CGI ()
standardQuery = CGI.standardQuery
submit :: (AdmitChildINPUT y, InputHandle h) => h INVALID -> (h VALID -> CGI ()) -> HTMLField INPUT y ()
submit = CGI.submit
submit0 :: (AdmitChildINPUT y) => CGI () -> HTMLField INPUT y ()
submit0 = CGI.submit0
defaultSubmit :: (AdmitChildINPUT y, InputHandle h) => h INVALID -> (h VALID -> CGI ()) -> HTMLField INPUT y ()
defaultSubmit = CGI.defaultSubmit
submitLink :: (AdmitChildA y, InputHandle h) => h INVALID -> (h VALID -> CGI ()) -> HTMLCons A y CGI ()
submitLink = CGI.submitLink
submitLink0 :: (AdmitChildA y) => CGI () -> HTMLCons A y CGI ()
submitLink0 = CGI.submitLink0
defaultSubmitLink :: (AdmitChildA y, InputHandle h) => h INVALID -> (h VALID -> CGI ()) -> HTMLCons A y CGI ()
defaultSubmitLink = CGI.defaultSubmitLink
submitx :: (AdmitChildINPUT y) => DTree INPUT y -> HTMLField INPUT y ()
submitx = CGI.submitx
resetField :: (AdmitChildINPUT y) => HTMLField INPUT y (InputField () INVALID)
resetField = CGI.resetField
activeInputField :: (AdmitChildINPUT y, Reason a, Read a) => (a -> CGI ()) -> HTMLField INPUT y ()
activeInputField = CGI.activeInputField
activate :: (InputHandle (i a), HasValue i, AdmitChildINPUT y) => (a -> CGI ()) -> HTMLField INPUT y (i a INVALID) -> HTMLField INPUT y (i a INVALID)
activate = CGI.activate
inputField :: (AdmitChildINPUT y, Reason a, Read a) => HTMLField INPUT y (InputField a INVALID)
inputField = CGI.inputField
checkedTextInputField :: (AdmitChildINPUT y) => (Maybe String -> Maybe String) -> HTMLField INPUT y (InputField String INVALID)
checkedTextInputField = CGI.checkedTextInputField
textInputField :: (AdmitChildINPUT y) => HTMLField INPUT y (InputField String INVALID)
textInputField = CGI.textInputField
passwordInputField :: (AdmitChildINPUT y, Reason a, Read a) => HTMLField INPUT y (InputField a INVALID)
passwordInputField = CGI.passwordInputField
makeTextarea :: (AdmitChildTEXTAREA y) => String -> HTMLField TEXTAREA y (InputField String INVALID)
makeTextarea = CGI.makeTextarea
checkboxInputField :: (AdmitChildINPUT y) => HTMLField INPUT y (InputField Bool INVALID)
checkboxInputField = CGI.checkboxInputField
makeButton :: (AdmitChildINPUT y) => HTMLField INPUT y (InputField Bool INVALID)
makeButton = CGI.makeButton
radioButton :: (AdmitChildINPUT y, Show a) => RadioGroup a INVALID -> a -> HTMLField INPUT y ()
radioButton = CGI.radioButton
radioError :: (AdmitChildIMG x) => RadioGroup a INVALID -> WithHTML x CGI ()
radioError = CGI.radioError
imageField :: (AdmitChildINPUT y) => Image -> HTMLField INPUT y (InputField (Int, Int) INVALID)
imageField = CGI.imageField
selectMultiple :: (AdmitChildSELECT y, Eq a) => (a -> String) -> [a] -> [a] -> (Int, Int) -> HTMLField SELECT y (InputField [a] INVALID)
selectMultiple = CGI.selectMultiple
selectSingle :: (AdmitChildSELECT y, Eq a) => (a -> String) -> Maybe a -> [a] -> HTMLField SELECT y (InputField a INVALID)
selectSingle = CGI.selectSingle
selectBounded :: (AdmitChildSELECT y, Enum a, Bounded a, Read a, Show a, Eq a) => Maybe a -> HTMLField SELECT y (InputField a INVALID)
selectBounded = CGI.selectBounded
checkedFileInputField :: (AdmitChildINPUT y) => (Maybe FileReference -> Maybe FileReference) -> HTMLField INPUT y (InputField FileReference INVALID)
checkedFileInputField = CGI.checkedFileInputField
fileInputField :: (AdmitChildINPUT y) => HTMLField INPUT y (InputField FileReference INVALID)
fileInputField = CGI.fileInputField

fieldSIZE :: (Monad m, AdmitAttrSIZE e, AttrValueSIZE v) => v -> WithHTML e m ()
fieldSIZE = HTMLMonad98.atSIZE
fieldMAXLENGTH :: (Monad m, AdmitAttrMAXLENGTH e, AttrValueMAXLENGTH v) => v -> WithHTML e m ()
fieldMAXLENGTH = HTMLMonad98.atMAXLENGTH
fieldVALUE :: (Monad m, AdmitAttrVALUE e, AttrValueVALUE v) => v -> WithHTML e m ()
fieldVALUE = HTMLMonad98.atVALUE

-- module HTMLWrapper
standardPage :: (AdmitChildHTML y, Monad m) => String -> WithHTML BODY m a -> WithHTML y m ()
standardPage = CGI.standardPage
htmlHeader :: (AdmitChildHTML y, Monad m) => String -> WithHTML HTML m a -> WithHTML y m ()
htmlHeader = CGI.htmlHeader
html :: (Monad m, AdmitChildHTML y) => WithHTML HTML m a -> WithHTML y m ()
html = CGI.html
cssHeader :: (AdmitChildHTML y, Monad m) => String -> String -> WithHTML HTML m a -> WithHTML y m ()
cssHeader = CGI.cssHeader
cssPage :: (AdmitChildHTML y, Monad m) => String -> String -> WithHTML BODY m a -> WithHTML y m ()
cssPage = CGI.cssPage

-- module Style
using :: (AdmitAttrSTYLE x, Monad m)
	=> Style
	-> (WithHTML x m b -> c)	-- ^a field constructor, typically 'HTMLField'
	-> WithHTML x m b -> c		-- ^styled version of this constructor
using = CGI.using

makeFrame :: WithHTML FRAME IO () -> CGI () -> CGI FrameSet
makeFrame = CGI.makeFrame
