#
# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is Weave code.
#
# The Initial Developer of the Original Code is Mozilla Foundation.
# Portions created by the Initial Developer are Copyright (C) 2008
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#   Dan Mills <thunder@mozilla.com> (original author)
#   Godwin Chan <godwinchan@hotmail.com> (Darwin Universal Binary)
#   Justin Dolske <dolske@mozilla.com>
#   Alexander GQ Gerasiov <gq@debian.org>
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

PLATFORM = Linux

TARGET = WeaveCrypto.so
SOURCES = WeaveCrypto.cpp WeaveCryptoModule.cpp
OBJECTS = $(SOURCES:.cpp=.o)

HEADERS = IWeaveCrypto.h

DESTDIR = ../platform/$(PLATFORM)

ifeq ($(MOZSDKDIR),)
  $(warning No 'MOZSDKDIR' variable given)
  $(warning It should point to the location of the Gecko SDK)
  $(warning For example: "make MOZSDKDIR=/foo/bar/baz")
  $(warning Or set the MOZSDKDIR environment variable to point to it)
  $(error )
endif

CXXFLAGS += -shared -std=gnu++0x
CXXFLAGS += -I$(MOZSDKDIR)/include \
	-I$(MOZSDKDIR)/include/system_wrappers \
	-I$(MOZSDKDIR)/include/nss \
	-I$(MOZSDKDIR)/include/xpcom \
	-I$(MOZSDKDIR)/include/string \
	-I$(MOZSDKDIR)/include/pipnss \
	-I$(MOZSDKDIR)/include/nspr \
	-I$(MOZSDKDIR)/sdk/include

CXXFLAGS += -pipe -Os \
	-fPIC -fno-rtti -fno-exceptions -fno-strict-aliasing \
	-fno-common -pthread \
	-Wall -Wconversion -Wpointer-arith -Woverloaded-virtual -Wsynth \
	-Wno-ctor-dtor-privacy -Wno-non-virtual-dtor -Wcast-align \
	-Wno-long-long \
	-include xpcom-config.h

LIBDIRS := $(MOZSDKDIR)/lib $(MOZSDKDIR)/bin
LIBS := xpcom xpcomglue xpcomglue_s nspr4 crmf nss3 plc4

LDFLAGS += -pthread -pipe -DMOZILLA_STRICT_API \
	-Wl,-dead_strip \
	-Wl,-exported_symbol \
	-Wl,-z,defs -Wl,-h,WeaveCrypto.so \
	-Wl,-rpath-link,$(MOZSDKDIR)/bin \
	$(MOZSDKDIR)/lib/libxpcomglue_s.a

LDFLAGS += $(LIBDIRS:%=-L%)
LDFLAGS += $(LIBS:%=-l%)


.PHONY: all build clean subst

all: build

build: $(SUBST) $(TARGET) $(HEADER)
	mkdir -p $(DESTDIR)/components
	cp -v $(TARGET) $(DESTDIR)/components

clean: 
	rm -f $(TARGET) WeaveCrypto.rc

subst:
	$(substitute) WeaveCrypto.rc.in > WeaveCrypto.rc

$(TARGET): $(SOURCES) $(HEADER)
	$(CXX) $(SOURCES) -o $(TARGET) $(CXXFLAGS) $(LDFLAGS)
