import gconf

from preferencedialog import PreferenceDialog

SERVER_KEY = "/apps/webboard/pastebin"
USER_KEY = "/apps/webboard/user"
MONO_FONT_KEY = "/desktop/gnome/interface/monospace_font_name"

class WebBoardConfig:
    def __init__(self):
        # setup gconf
        self.gconf = gconf.client_get_default()
        # We need to use add_dir for notification to works
        self.gconf.add_dir("/apps/webboard", gconf.CLIENT_PRELOAD_NONE)
        self.gconf.notify_add(SERVER_KEY, self.pastebin_changed)
        self.gconf.notify_add(USER_KEY, self.user_changed)

        self.notifiers=[]

        self.pastebin = self.gconf.get_string(SERVER_KEY)
        if not self.pastebin:
            self.set_pastebin("paste.debian.net")

        self.user = self.gconf.get_string(USER_KEY)
        if not self.user:
            # guess a user name
            self.set_user(self.guess_user())

        self.preference_dialog = None

    def get_mono_font(self):
        return self.gconf.get_string(MONO_FONT_KEY)

    def set_pastebin(self, value):
        self.pastebin = value
        self.gconf.set_string(SERVER_KEY, value)

    def set_user(self, value):
        self.user = value
        self.gconf.set_string(USER_KEY, value)

    def pastebin_is_writable(self):
        return self.gconf.key_is_writable(SERVER_KEY)
        
    def user_is_writable(self):
        return self.gconf.key_is_writable(USER_KEY)

    def remove_notifier(self, func):
        self.notifiers.remove(func)

    def add_notifier(self, func):
        self.notifiers.append(func)

    def user_changed(self, client, cnxn_id, entry, *args):
        if entry.value.type == gconf.VALUE_STRING:
            string = entry.value.to_string()
            self.user = string

    def pastebin_changed(self, client, cnxn_id, entry, *args):
        if entry.value.type == gconf.VALUE_STRING:
            string = entry.value.to_string()
            self.pastebin = string
        for func in self.notifiers:
            if func is not None:
                func()

    def preferences(self, *args):
        if not self.preference_dialog:
            self.preference_dialog = PreferenceDialog(self)

        self.preference_dialog.show()

