/* Webcamoid, webcam capture application.
 * Copyright (C) 2016  Gonzalo Exequiel Pedone
 *
 * Webcamoid is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Webcamoid is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Webcamoid. If not, see <http://www.gnu.org/licenses/>.
 *
 * Web-Site: http://webcamoid.github.io/
 */

#include <QJSEngine>

#include "akqmlplugin.h"
#include "akqml.h"
#include "akelement.h"

void AkQmlPlugin::registerTypes(const char *uri)
{
    // @uri AkQml
    qmlRegisterSingletonType<AkQml>(uri, 1, 0, "Ak", &AkQmlPlugin::akProvider);
    qmlRegisterType<AkElement>(uri, 1, 0, "AkElement");
}

QObject *AkQmlPlugin::akProvider(QQmlEngine *qmlEngine, QJSEngine *jsEngine)
{
    Q_UNUSED(qmlEngine)
    Q_UNUSED(jsEngine)

    return new AkQml();
}

#include "moc_akqmlplugin.cpp"
