/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Article` (
  `linkTitle` char(255) default NULL,
  `linkURL` text,
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  `storageId` char(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Calendar` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) unsigned NOT NULL default '0',
  `defaultDate` enum('current','first','last') default 'current',
  `defaultView` enum('month','week','day','list') default 'month',
  `visitorCacheTimeout` int(11) unsigned default NULL,
  `templateIdMonth` char(22) default 'CalendarMonth000000001',
  `templateIdWeek` char(22) default 'CalendarWeek0000000001',
  `templateIdDay` char(22) default 'CalendarDay00000000001',
  `templateIdEvent` char(22) default 'CalendarEvent000000001',
  `templateIdEventEdit` char(22) default 'CalendarEventEdit00001',
  `templateIdSearch` char(22) default 'CalendarSearch00000001',
  `templateIdPrintMonth` char(22) default 'CalendarPrintMonth0001',
  `templateIdPrintWeek` char(22) default 'CalendarPrintWeek00001',
  `templateIdPrintDay` char(22) default 'CalendarPrintDay000001',
  `templateIdPrintEvent` char(22) default 'CalendarPrintEvent0001',
  `groupIdEventEdit` char(22) default '3',
  `groupIdSubscribed` char(22) default NULL,
  `subscriberNotifyOffset` int(11) default NULL,
  `sortEventsBy` enum('time','sequencenumber') default 'time',
  `listViewPageInterval` bigint(20) default NULL,
  `templateIdList` char(22) default NULL,
  `templateIdPrintList` char(22) default NULL,
  `icalInterval` bigint(20) default NULL,
  `workflowIdCommit` char(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Calendar_feeds` (
  `feedId` char(22) NOT NULL,
  `assetId` char(22) NOT NULL,
  `url` char(255) NOT NULL,
  `lastUpdated` datetime default NULL,
  `lastResult` char(255) default NULL,
  `feedType` char(30) NOT NULL,
  PRIMARY KEY  (`feedId`,`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Collaboration` (
  `assetId` char(22) NOT NULL default '',
  `postGroupId` char(22) NOT NULL default '2',
  `canStartThreadGroupId` char(22) NOT NULL default '2',
  `karmaPerPost` int(11) NOT NULL default '0',
  `collaborationTemplateId` char(22) NOT NULL default '',
  `threadTemplateId` char(22) NOT NULL default '',
  `postFormTemplateId` char(22) NOT NULL default '',
  `searchTemplateId` char(22) NOT NULL default '',
  `notificationTemplateId` char(22) NOT NULL default '',
  `sortBy` char(35) NOT NULL default 'assetData.revisionDate',
  `sortOrder` char(4) NOT NULL default 'desc',
  `usePreview` int(11) NOT NULL default '1',
  `addEditStampToPosts` int(11) NOT NULL default '0',
  `editTimeout` int(11) NOT NULL default '3600',
  `attachmentsPerPost` int(11) NOT NULL default '0',
  `filterCode` char(30) NOT NULL default 'javascript',
  `useContentFilter` int(11) NOT NULL default '1',
  `threads` int(11) NOT NULL default '0',
  `views` int(11) NOT NULL default '0',
  `replies` int(11) NOT NULL default '0',
  `rating` int(11) NOT NULL default '0',
  `lastPostId` char(22) default NULL,
  `lastPostDate` bigint(20) default NULL,
  `archiveAfter` int(11) NOT NULL default '31536000',
  `postsPerPage` int(11) NOT NULL default '10',
  `threadsPerPage` int(11) NOT NULL default '30',
  `subscriptionGroupId` char(22) default NULL,
  `allowReplies` int(11) NOT NULL default '0',
  `displayLastReply` int(11) NOT NULL default '0',
  `richEditor` char(22) NOT NULL default 'PBrichedit000000000002',
  `karmaRatingMultiplier` int(11) NOT NULL default '0',
  `karmaSpentToRate` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `avatarsEnabled` int(11) NOT NULL default '0',
  `approvalWorkflow` char(22) NOT NULL default 'pbworkflow000000000003',
  `threadApprovalWorkflow` char(22) NOT NULL default 'pbworkflow000000000003',
  `defaultKarmaScale` int(11) NOT NULL default '1',
  `mailServer` char(255) default NULL,
  `mailAccount` char(255) default NULL,
  `mailPassword` char(255) default NULL,
  `mailAddress` char(255) default NULL,
  `mailPrefix` char(255) default NULL,
  `getMail` int(11) NOT NULL default '0',
  `getMailInterval` int(11) NOT NULL default '300',
  `getMailCronId` char(22) default NULL,
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  `autoSubscribeToThread` int(11) NOT NULL default '1',
  `requireSubscriptionForEmailPosting` int(11) NOT NULL default '1',
  `thumbnailSize` int(11) NOT NULL default '0',
  `maxImageSize` int(11) NOT NULL default '0',
  `enablePostMetaData` int(11) NOT NULL default '0',
  `useCaptcha` int(11) NOT NULL default '0',
  `groupToEditPost` char(22) NOT NULL,
  `archiveEnabled` int(1) default '1',
  `postReceivedTemplateId` char(22) default 'default_post_received1',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Dashboard` (
  `assetId` char(22) NOT NULL default '',
  `revisionDate` char(22) NOT NULL default '',
  `adminsGroupId` char(22) NOT NULL default '4',
  `usersGroupId` char(22) NOT NULL default '2',
  `templateId` char(22) NOT NULL default 'DashboardViewTmpl00001',
  `isInitialized` tinyint(3) unsigned NOT NULL default '0',
  `assetsToHide` text,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `DataForm` (
  `acknowledgement` text,
  `mailData` int(11) NOT NULL default '1',
  `emailTemplateId` char(22) NOT NULL default '',
  `acknowlegementTemplateId` char(22) NOT NULL default '',
  `listTemplateId` char(22) NOT NULL default '',
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `defaultView` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `groupToViewEntries` char(22) NOT NULL default '7',
  `mailAttachments` int(11) default '0',
  `useCaptcha` int(1) default '0',
  `storeData` int(1) default '1',
  `fieldConfiguration` text,
  `tabConfiguration` text,
  `workflowIdAddEntry` char(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `DataForm_entry` (
  `DataForm_entryId` char(22) NOT NULL default '',
  `userId` char(22) NOT NULL default '',
  `username` char(255) default NULL,
  `ipAddress` char(255) default NULL,
  `assetId` char(22) NOT NULL default '',
  `entryData` mediumtext,
  `submissionDate` datetime default NULL,
  PRIMARY KEY  (`DataForm_entryId`),
  KEY `assetId` (`assetId`),
  KEY `assetId_submissionDate` (`assetId`,`submissionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `DataTable` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `data` longtext,
  `templateId` char(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSBadge` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL default '0',
  `seatsAvailable` int(11) NOT NULL default '100',
  `relatedBadgeGroups` mediumtext,
  `templateId` char(22) NOT NULL,
  `earlyBirdPrice` float NOT NULL default '0',
  `earlyBirdPriceEndDate` bigint(20) default NULL,
  `preRegistrationPrice` float NOT NULL default '0',
  `preRegistrationPriceEndDate` bigint(20) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSBadgeGroup` (
  `badgeGroupId` char(22) NOT NULL,
  `emsAssetId` char(22) NOT NULL,
  `name` char(100) default NULL,
  PRIMARY KEY  (`badgeGroupId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSEventMetaField` (
  `fieldId` char(22) NOT NULL,
  `assetId` char(22) default NULL,
  `label` char(100) default NULL,
  `dataType` char(20) default NULL,
  `visible` tinyint(4) default '0',
  `required` tinyint(4) default '0',
  `possibleValues` text,
  `defaultValues` text,
  `sequenceNumber` int(5) default NULL,
  PRIMARY KEY  (`fieldId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSRegistrant` (
  `badgeId` char(22) NOT NULL,
  `userId` char(22) default NULL,
  `badgeNumber` int(11) NOT NULL auto_increment,
  `badgeAssetId` char(22) NOT NULL,
  `emsAssetId` char(22) NOT NULL,
  `name` char(35) NOT NULL,
  `address1` char(35) default NULL,
  `address2` char(35) default NULL,
  `address3` char(35) default NULL,
  `city` char(35) default NULL,
  `state` char(35) default NULL,
  `zipcode` char(35) default NULL,
  `country` char(35) default NULL,
  `phoneNumber` char(35) default NULL,
  `organization` char(35) default NULL,
  `email` char(255) default NULL,
  `notes` mediumtext,
  `purchaseComplete` tinyint(1) default NULL,
  `hasCheckedIn` tinyint(1) default NULL,
  `transactionItemId` char(22) default NULL,
  PRIMARY KEY  (`badgeId`),
  UNIQUE KEY `badgeNumber` (`badgeNumber`),
  KEY `badgeAssetId_purchaseComplete` (`badgeAssetId`,`purchaseComplete`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSRegistrantRibbon` (
  `badgeId` char(22) NOT NULL,
  `ribbonAssetId` char(22) NOT NULL,
  `transactionItemId` char(22) default NULL,
  PRIMARY KEY  (`badgeId`,`ribbonAssetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSRegistrantTicket` (
  `badgeId` char(22) NOT NULL,
  `ticketAssetId` char(22) NOT NULL,
  `purchaseComplete` tinyint(1) default NULL,
  `transactionItemId` char(22) default NULL,
  PRIMARY KEY  (`badgeId`,`ticketAssetId`),
  KEY `ticketAssetId_purchaseComplete` (`ticketAssetId`,`purchaseComplete`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSRegistrantToken` (
  `badgeId` char(22) NOT NULL,
  `tokenAssetId` char(22) NOT NULL,
  `quantity` int(11) default NULL,
  `transactionItemIds` text character set utf8 collate utf8_bin,
  PRIMARY KEY  (`badgeId`,`tokenAssetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSRibbon` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `percentageDiscount` float NOT NULL default '10',
  `price` float NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSTicket` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL default '0',
  `seatsAvailable` int(11) NOT NULL default '100',
  `startDate` datetime default NULL,
  `duration` float NOT NULL default '1',
  `eventNumber` int(11) default NULL,
  `location` char(100) default NULL,
  `relatedBadgeGroups` mediumtext,
  `relatedRibbons` mediumtext,
  `eventMetaData` mediumtext,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EMSToken` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Event` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) unsigned NOT NULL,
  `feedId` char(22) default NULL,
  `feedUid` char(255) default NULL,
  `startDate` date default NULL,
  `endDate` date default NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `recurId` char(22) default NULL,
  `description` longtext,
  `startTime` time default NULL,
  `endTime` time default NULL,
  `relatedLinks` longtext,
  `location` char(255) default NULL,
  `storageId` char(22) NOT NULL,
  `timeZone` char(255) default 'America/Chicago',
  `sequenceNumber` bigint(20) default NULL,
  `iCalSequenceNumber` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `EventManagementSystem` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupToApproveEvents` char(22) default NULL,
  `timezone` char(30) NOT NULL default 'America/Chicago',
  `templateId` char(22) NOT NULL default '2rC4ErZ3c77OJzJm7O5s3w',
  `badgeBuilderTemplateId` char(22) NOT NULL default 'BMybD3cEnmXVk2wQ_qEsRQ',
  `lookupRegistrantTemplateId` char(22) NOT NULL default 'OOyMH33plAy6oCj_QWrxtg',
  `printBadgeTemplateId` char(22) NOT NULL default 'PsFn7dJt4wMwBa8hiE3hOA',
  `printTicketTemplateId` char(22) NOT NULL default 'yBwydfooiLvhEFawJb0VTQ',
  `badgeInstructions` mediumtext,
  `ribbonInstructions` mediumtext,
  `ticketInstructions` mediumtext,
  `tokenInstructions` mediumtext,
  `registrationStaffGroupId` char(22) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Event_recur` (
  `recurId` char(22) NOT NULL,
  `recurType` char(16) default NULL,
  `pattern` char(255) default NULL,
  `startDate` date default NULL,
  `endDate` char(10) default NULL,
  PRIMARY KEY  (`recurId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Event_relatedlink` (
  `eventlinkId` char(22) NOT NULL,
  `assetId` char(22) NOT NULL,
  `linkURL` tinytext,
  `linktext` char(80) default NULL,
  `groupIdView` char(22) NOT NULL,
  `sequenceNumber` bigint(20) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `FileAsset` (
  `assetId` char(22) NOT NULL default '',
  `storageId` char(22) NOT NULL default '',
  `filename` char(255) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `FlatDiscount` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `templateId` char(22) NOT NULL default '63ix2-hU0FchXGIWkG3tow',
  `mustSpend` float NOT NULL default '0',
  `percentageDiscount` int(3) NOT NULL default '0',
  `priceDiscount` float NOT NULL default '0',
  `thankYouMessage` mediumtext,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Folder` (
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  `sortAlphabetically` int(11) NOT NULL default '0',
  `sortOrder` enum('ASC','DESC') default 'ASC',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Gallery` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupIdAddComment` char(22) default NULL,
  `groupIdAddFile` char(22) default NULL,
  `imageResolutions` text,
  `imageViewSize` int(11) default NULL,
  `imageThumbnailSize` int(11) default NULL,
  `maxSpacePerUser` char(20) default NULL,
  `richEditIdComment` char(22) default NULL,
  `templateIdAddArchive` char(22) default NULL,
  `templateIdDeleteAlbum` char(22) default NULL,
  `templateIdDeleteFile` char(22) default NULL,
  `templateIdEditAlbum` char(22) default NULL,
  `templateIdEditFile` char(22) default NULL,
  `templateIdListAlbums` char(22) default NULL,
  `templateIdListAlbumsRss` char(22) default NULL,
  `templateIdListFilesForUser` char(22) default NULL,
  `templateIdListFilesForUserRss` char(22) default NULL,
  `templateIdMakeShortcut` char(22) default NULL,
  `templateIdSearch` char(22) default NULL,
  `templateIdViewSlideshow` char(22) default NULL,
  `templateIdViewThumbnails` char(22) default NULL,
  `templateIdViewAlbum` char(22) default NULL,
  `templateIdViewAlbumRss` char(22) default NULL,
  `templateIdViewFile` char(22) default NULL,
  `viewAlbumAssetId` char(22) default NULL,
  `viewDefault` enum('album','list') default NULL,
  `viewListOrderBy` char(40) default NULL,
  `viewListOrderDirection` enum('ASC','DESC') default NULL,
  `workflowIdCommit` char(22) default NULL,
  `templateIdEditComment` char(22) default NULL,
  `richEditIdAlbum` char(22) default NULL,
  `richEditIdFile` char(22) default NULL,
  `defaultFilesPerPage` int(11) default NULL,
  `imageDensity` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `GalleryAlbum` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `allowComments` int(11) default NULL,
  `assetIdThumbnail` char(22) default NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `othersCanAdd` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `GalleryFile` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `userDefined1` longtext,
  `userDefined2` longtext,
  `userDefined3` longtext,
  `userDefined4` longtext,
  `userDefined5` longtext,
  `views` bigint(20) default '0',
  `friendsOnly` int(1) default '0',
  `rating` int(1) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `GalleryFile_comment` (
  `assetId` char(22) NOT NULL,
  `commentId` char(22) NOT NULL,
  `userId` char(22) default NULL,
  `visitorIp` char(255) default NULL,
  `creationDate` datetime default NULL,
  `bodyText` longtext,
  PRIMARY KEY  (`assetId`,`commentId`),
  KEY `commentId` (`commentId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `HttpProxy` (
  `proxiedUrl` text,
  `timeout` int(11) default NULL,
  `removeStyle` int(11) default NULL,
  `filterHtml` char(30) default NULL,
  `followExternal` int(11) default NULL,
  `followRedirect` int(11) default NULL,
  `cacheHttp` int(11) default '0',
  `useCache` int(11) default '0',
  `debug` int(11) default '0',
  `rewriteUrls` int(11) default NULL,
  `searchFor` char(255) default NULL,
  `stopAt` char(255) default NULL,
  `cookieJarStorageId` char(22) NOT NULL default '',
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '0',
  `useAmpersand` int(11) NOT NULL default '0',
  `urlPatternFilter` mediumtext,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ITransact_recurringStatus` (
  `gatewayId` char(128) NOT NULL default '',
  `initDate` bigint(20) NOT NULL default '0',
  `lastTransaction` bigint(20) NOT NULL default '0',
  `status` char(10) NOT NULL default '',
  `errorMessage` char(128) default NULL,
  `recipe` char(15) NOT NULL default '',
  PRIMARY KEY  (`gatewayId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ImageAsset` (
  `assetId` char(22) NOT NULL default '',
  `thumbnailSize` int(11) NOT NULL default '50',
  `parameters` text,
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `InOutBoard` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `statusList` text,
  `reportViewerGroup` char(22) NOT NULL default '3',
  `inOutGroup` char(22) NOT NULL default '2',
  `inOutTemplateId` char(22) NOT NULL default 'IOB0000000000000000001',
  `reportTemplateId` char(22) NOT NULL default 'IOB0000000000000000002',
  `paginateAfter` int(11) NOT NULL default '50',
  `reportPaginateAfter` int(11) NOT NULL default '50',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `InOutBoard_delegates` (
  `userId` char(22) NOT NULL,
  `delegateUserId` char(22) NOT NULL,
  `assetId` char(22) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `InOutBoard_status` (
  `assetId` char(22) NOT NULL,
  `userId` char(22) NOT NULL,
  `status` char(255) default NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `InOutBoard_statusLog` (
  `assetId` char(22) NOT NULL,
  `userId` char(22) NOT NULL,
  `status` char(255) default NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text,
  `createdBy` char(22) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Layout` (
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `contentPositions` text,
  `assetsToHide` text,
  `revisionDate` bigint(20) NOT NULL default '0',
  `assetOrder` char(20) default 'asc',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Matrix` (
  `detailTemplateId` char(22) default NULL,
  `compareTemplateId` char(22) default NULL,
  `searchTemplateId` char(22) default NULL,
  `categories` text,
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `maxComparisons` int(11) NOT NULL default '10',
  `maxComparisonsPrivileged` int(11) NOT NULL default '10',
  `defaultSort` char(22) NOT NULL default 'score',
  `compareColorNo` char(22) default '#ffaaaa',
  `compareColorLimited` char(22) NOT NULL default '#ffffaa',
  `compareColorCostsExtra` char(22) NOT NULL default '#ffffaa',
  `compareColorFreeAddOn` char(22) NOT NULL default '#ffffaa',
  `compareColorYes` char(22) NOT NULL default '#aaffaa',
  `submissionApprovalWorkflowId` char(22) NOT NULL,
  `ratingsDuration` int(11) NOT NULL default '7776000',
  `editListingTemplateId` char(22) default NULL,
  `groupToAdd` char(22) default '2',
  `screenshotsConfigTemplateId` char(22) default NULL,
  `screenshotsTemplateId` char(22) default NULL,
  `statisticsCacheTimeout` int(11) NOT NULL default '3600',
  `maxComparisonsGroup` char(22) default NULL,
  `maxComparisonsGroupInt` int(11) default NULL,
  `maxScreenshotWidth` int(11) default NULL,
  `maxScreenshotHeight` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MatrixListing` (
  `assetId` char(22) character set latin1 collate latin1_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `screenshots` char(22) default NULL,
  `description` text,
  `version` char(255) default NULL,
  `views` int(11) default NULL,
  `compares` int(11) default NULL,
  `clicks` int(11) default NULL,
  `viewsLastIp` char(255) default NULL,
  `comparesLastIp` char(255) default NULL,
  `clicksLastIp` char(255) default NULL,
  `lastUpdated` int(11) default NULL,
  `maintainer` char(22) default NULL,
  `manufacturerName` char(255) default NULL,
  `manufacturerURL` char(255) default NULL,
  `productURL` char(255) default NULL,
  `score` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MatrixListing_attribute` (
  `matrixId` char(22) NOT NULL,
  `matrixListingId` char(22) NOT NULL,
  `attributeId` char(22) NOT NULL,
  `value` char(255) default NULL,
  PRIMARY KEY  (`attributeId`,`matrixListingId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MatrixListing_rating` (
  `timeStamp` int(11) NOT NULL default '0',
  `category` char(255) default NULL,
  `rating` int(11) NOT NULL default '1',
  `listingId` char(22) NOT NULL default '',
  `ipAddress` char(15) default NULL,
  `assetId` char(22) NOT NULL default '',
  `userId` char(22) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MatrixListing_ratingSummary` (
  `listingId` char(22) NOT NULL default '',
  `category` char(255) NOT NULL default '',
  `meanValue` decimal(3,2) default NULL,
  `medianValue` int(11) default NULL,
  `countValue` int(11) default NULL,
  `assetId` char(22) NOT NULL default '',
  PRIMARY KEY  (`listingId`,`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Matrix_attribute` (
  `attributeId` char(22) NOT NULL,
  `category` char(255) NOT NULL default '',
  `name` char(255) default NULL,
  `description` text,
  `fieldType` char(255) NOT NULL default 'MatrixCompare',
  `defaultValue` char(255) default NULL,
  `assetId` char(22) NOT NULL default '',
  `options` text,
  PRIMARY KEY  (`attributeId`),
  KEY `categoryIndex` (`category`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MessageBoard` (
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `visitorCacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MultiSearch` (
  `assetId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) unsigned NOT NULL default '0',
  `templateId` char(22) NOT NULL default 'MultiSearchTmpl0000001',
  `predefinedSearches` text,
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Navigation` (
  `assetId` char(22) NOT NULL default '',
  `assetsToInclude` text,
  `startType` char(35) default NULL,
  `startPoint` char(255) default NULL,
  `descendantEndPoint` int(11) NOT NULL default '55',
  `showSystemPages` int(11) NOT NULL default '0',
  `showHiddenPages` int(11) NOT NULL default '0',
  `showUnprivilegedPages` int(11) NOT NULL default '0',
  `templateId` char(22) NOT NULL default '',
  `ancestorEndPoint` int(11) NOT NULL default '55',
  `revisionDate` bigint(20) NOT NULL default '0',
  `mimeType` char(50) default 'text/html',
  `reversePageLoop` tinyint(1) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Newsletter` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `newsletterTemplateId` char(22) NOT NULL default 'newsletter000000000001',
  `mySubscriptionsTemplateId` char(22) NOT NULL default 'newslettersubscrip0001',
  `newsletterHeader` mediumtext,
  `newsletterFooter` mediumtext,
  `newsletterCategories` text,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Newsletter_subscriptions` (
  `assetId` char(22) NOT NULL,
  `userId` char(22) NOT NULL,
  `subscriptions` text,
  `lastTimeSent` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`userId`),
  KEY `lastTimeSent_assetId_userId` (`lastTimeSent`,`assetId`,`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PM_project` (
  `projectId` char(22) NOT NULL,
  `assetId` char(22) default NULL,
  `name` char(255) NOT NULL,
  `description` text,
  `startDate` bigint(20) default NULL,
  `endDate` bigint(20) default NULL,
  `projectManager` char(22) default NULL,
  `durationUnits` enum('hours','days') default 'hours',
  `hoursPerDay` float default NULL,
  `targetBudget` float(15,2) default '0.00',
  `percentComplete` float NOT NULL default '0',
  `parentId` char(22) default NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) NOT NULL,
  `lastUpdatedBy` char(22) NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `projectObserver` char(22) default '7',
  PRIMARY KEY  (`projectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PM_task` (
  `taskId` char(22) NOT NULL,
  `projectId` char(22) NOT NULL,
  `taskName` char(255) NOT NULL,
  `duration` float default NULL,
  `startDate` bigint(20) default NULL,
  `endDate` bigint(20) default NULL,
  `dependants` char(50) default NULL,
  `parentId` char(22) default NULL,
  `percentComplete` float default NULL,
  `sequenceNumber` int(11) NOT NULL default '1',
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) NOT NULL,
  `lastUpdatedBy` char(22) NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `lagTime` bigint(20) default '0',
  `taskType` enum('timed','progressive','milestone') NOT NULL default 'timed',
  PRIMARY KEY  (`taskId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PM_taskResource` (
  `taskResourceId` char(22) NOT NULL,
  `taskId` char(22) NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `resourceKind` enum('user','group') NOT NULL,
  `resourceId` char(22) NOT NULL,
  PRIMARY KEY  (`taskResourceId`),
  UNIQUE KEY `taskId` (`taskId`,`resourceKind`,`resourceId`),
  UNIQUE KEY `taskId_2` (`taskId`,`sequenceNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PM_wobject` (
  `assetId` char(22) NOT NULL,
  `projectDashboardTemplateId` char(22) NOT NULL default 'ProjectManagerTMPL0001',
  `projectDisplayTemplateId` char(22) NOT NULL default 'ProjectManagerTMPL0002',
  `ganttChartTemplateId` char(22) NOT NULL default 'ProjectManagerTMPL0003',
  `editTaskTemplateId` char(22) NOT NULL default 'ProjectManagerTMPL0004',
  `groupToAdd` char(22) NOT NULL default '3',
  `revisionDate` bigint(20) NOT NULL,
  `resourcePopupTemplateId` char(22) NOT NULL default 'ProjectManagerTMPL0005',
  `resourceListTemplateId` char(22) NOT NULL default 'ProjectManagerTMPL0006',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Photo` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `exifData` longtext,
  `location` char(255) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Photo_rating` (
  `assetId` char(22) NOT NULL,
  `userId` char(22) default NULL,
  `visitorIp` char(255) default NULL,
  `rating` int(11) default NULL,
  KEY `assetId` (`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Poll` (
  `active` int(11) NOT NULL default '1',
  `graphWidth` int(11) NOT NULL default '150',
  `voteGroup` char(22) default NULL,
  `question` char(255) default NULL,
  `a1` char(255) default NULL,
  `a2` char(255) default NULL,
  `a3` char(255) default NULL,
  `a4` char(255) default NULL,
  `a5` char(255) default NULL,
  `a6` char(255) default NULL,
  `a7` char(255) default NULL,
  `a8` char(255) default NULL,
  `a9` char(255) default NULL,
  `a10` char(255) default NULL,
  `a11` char(255) default NULL,
  `a12` char(255) default NULL,
  `a13` char(255) default NULL,
  `a14` char(255) default NULL,
  `a15` char(255) default NULL,
  `a16` char(255) default NULL,
  `a17` char(255) default NULL,
  `a18` char(255) default NULL,
  `a19` char(255) default NULL,
  `a20` char(255) default NULL,
  `karmaPerVote` int(11) NOT NULL default '0',
  `randomizeAnswers` int(11) NOT NULL default '0',
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `graphConfiguration` blob,
  `generateGraph` tinyint(1) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Poll_answer` (
  `answer` char(3) default NULL,
  `userId` char(22) NOT NULL default '',
  `ipAddress` char(50) default NULL,
  `assetId` char(22) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Post` (
  `assetId` char(22) NOT NULL default '',
  `threadId` char(22) NOT NULL default '',
  `username` char(30) default NULL,
  `content` mediumtext,
  `views` int(11) NOT NULL default '0',
  `contentType` char(35) NOT NULL default 'mixed',
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `storageId` char(22) NOT NULL default '',
  `rating` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `originalEmail` mediumtext,
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `threadId_rating` (`threadId`,`rating`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Post_rating` (
  `assetId` char(22) NOT NULL default '',
  `userId` char(22) NOT NULL default '',
  `ipAddress` char(15) NOT NULL default '',
  `dateOfRating` bigint(20) default NULL,
  `rating` int(11) NOT NULL default '0',
  KEY `assetId_userId` (`assetId`,`userId`),
  KEY `assetId_ipAddress` (`assetId`,`ipAddress`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Product` (
  `image1` char(255) default NULL,
  `image2` char(255) default NULL,
  `image3` char(255) default NULL,
  `brochure` char(255) default NULL,
  `manual` char(255) default NULL,
  `warranty` char(255) default NULL,
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  `thankYouMessage` mediumtext,
  `accessoryJSON` mediumtext,
  `benefitJSON` mediumtext,
  `featureJSON` mediumtext,
  `relatedJSON` mediumtext,
  `specificationJSON` mediumtext,
  `variantsJSON` mediumtext,
  `isShippingRequired` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RSSCapable` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `rssCapableRssEnabled` int(11) NOT NULL default '1',
  `rssCapableRssTemplateId` char(22) NOT NULL default 'PBtmpl0000000000000142',
  `rssCapableRssFromParentId` char(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RSSFromParent` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RichEdit` (
  `assetId` char(22) NOT NULL default '',
  `askAboutRichEdit` int(11) NOT NULL default '0',
  `preformatted` int(11) NOT NULL default '0',
  `editorWidth` int(11) NOT NULL default '0',
  `editorHeight` int(11) NOT NULL default '0',
  `sourceEditorWidth` int(11) NOT NULL default '0',
  `sourceEditorHeight` int(11) NOT NULL default '0',
  `useBr` int(11) NOT NULL default '0',
  `nowrap` int(11) NOT NULL default '0',
  `removeLineBreaks` int(11) NOT NULL default '0',
  `npwrap` int(11) NOT NULL default '0',
  `directionality` char(3) NOT NULL default 'ltr',
  `toolbarLocation` char(6) NOT NULL default 'bottom',
  `cssFile` char(255) default NULL,
  `validElements` mediumtext,
  `toolbarRow1` text,
  `toolbarRow2` text,
  `toolbarRow3` text,
  `enableContextMenu` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `disableRichEditor` int(11) default '0',
  `inlinePopups` int(11) NOT NULL default '0',
  `allowMedia` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SQLForm_fieldOrder` (
  `assetId` char(22) NOT NULL default '',
  `fieldId` char(22) NOT NULL default '',
  `rank` int(11) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SQLReport` (
  `dbQuery1` text,
  `paginateAfter` int(11) NOT NULL default '50',
  `preprocessMacros1` int(11) default '0',
  `debugMode` int(11) NOT NULL default '0',
  `databaseLinkId1` char(22) NOT NULL default '',
  `placeholderParams1` text,
  `preprocessMacros2` int(11) default '0',
  `dbQuery2` text,
  `placeholderParams2` text,
  `databaseLinkId2` char(22) NOT NULL default '',
  `preprocessMacros3` int(11) default '0',
  `dbQuery3` text,
  `placeholderParams3` text,
  `databaseLinkId3` char(22) NOT NULL default '',
  `preprocessMacros4` int(11) default '0',
  `dbQuery4` text,
  `placeholderParams4` text,
  `databaseLinkId4` char(22) NOT NULL default '',
  `preprocessMacros5` int(11) default '0',
  `dbQuery5` text,
  `placeholderParams5` text,
  `databaseLinkId5` char(22) NOT NULL default '',
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '0',
  `prequeryStatements1` text,
  `prequeryStatements2` text,
  `prequeryStatements3` text,
  `prequeryStatements4` text,
  `prequeryStatements5` text,
  `downloadType` char(255) default NULL,
  `downloadFilename` char(255) default NULL,
  `downloadTemplateId` char(22) default NULL,
  `downloadMimeType` char(255) default NULL,
  `downloadUserGroup` char(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Shelf` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `templateId` char(22) NOT NULL default 'nFen0xjkZn8WkpM93C9ceQ',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Shortcut` (
  `overrideTitle` int(11) NOT NULL default '0',
  `overrideDescription` int(11) NOT NULL default '0',
  `overrideTemplate` int(11) NOT NULL default '0',
  `overrideDisplayTitle` int(11) NOT NULL default '0',
  `overrideTemplateId` char(22) NOT NULL default '',
  `shortcutByCriteria` int(11) NOT NULL default '0',
  `resolveMultiples` char(30) default 'mostRecent',
  `shortcutCriteria` text NOT NULL,
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `shortcutToAssetId` char(22) NOT NULL default '',
  `disableContentLock` int(11) NOT NULL default '0',
  `revisionDate` bigint(20) NOT NULL default '0',
  `prefFieldsToShow` text,
  `prefFieldsToImport` text,
  `showReloadIcon` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Shortcut_overrides` (
  `assetId` char(22) NOT NULL default '',
  `fieldName` char(255) NOT NULL default '',
  `newValue` text,
  PRIMARY KEY  (`assetId`,`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `StockData` (
  `assetId` char(22) NOT NULL,
  `templateId` char(22) NOT NULL default 'StockListTMPL000000001',
  `displayTemplateId` char(22) NOT NULL default 'StockListTMPL000000002',
  `defaultStocks` text,
  `source` char(50) default 'usa',
  `failover` int(11) default '1',
  `revisionDate` int(11) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Subscription` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateId` char(22) NOT NULL default '',
  `thankYouMessage` mediumtext,
  `price` float NOT NULL default '0',
  `subscriptionGroup` char(22) NOT NULL default '2',
  `duration` char(12) NOT NULL default 'Monthly',
  `executeOnSubscription` char(255) default NULL,
  `karma` int(6) default '0',
  `recurringSubscription` tinyint(1) NOT NULL default '1',
  `redeemSubscriptionCodeTemplateId` char(22) NOT NULL default '',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Subscription_code` (
  `code` char(64) NOT NULL,
  `batchId` char(22) NOT NULL,
  `status` char(10) NOT NULL default 'Unused',
  `dateUsed` bigint(20) default NULL,
  `usedBy` char(22) default NULL,
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Subscription_codeBatch` (
  `batchId` char(22) NOT NULL,
  `name` char(255) default NULL,
  `description` mediumtext,
  `subscriptionId` char(22) NOT NULL,
  `expirationDate` bigint(20) NOT NULL,
  `dateCreated` bigint(20) NOT NULL,
  PRIMARY KEY  (`batchId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Survey` (
  `groupToTakeSurvey` char(22) character set utf8 collate utf8_bin NOT NULL default '2',
  `groupToEditSurvey` char(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `groupToViewReports` char(22) character set utf8 collate utf8_bin NOT NULL default '3',
  `responseTemplateId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `overviewTemplateId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `maxResponsesPerUser` int(11) NOT NULL default '1',
  `gradebookTemplateId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `assetId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `templateId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `surveyEditTemplateId` char(22) default NULL,
  `answerEditTemplateId` char(22) default NULL,
  `questionEditTemplateId` char(22) default NULL,
  `sectionEditTemplateId` char(22) default NULL,
  `surveyTakeTemplateId` char(22) default NULL,
  `surveyQuestionsId` char(22) default NULL,
  `exitURL` text,
  `surveyJSON` longtext,
  `timeLimit` mediumint(8) unsigned NOT NULL,
  `showProgress` tinyint(3) unsigned NOT NULL default '0',
  `showTimeLimit` tinyint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Survey_response` (
  `assetId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `Survey_responseId` char(22) character set utf8 collate utf8_bin NOT NULL,
  `userId` char(22) default NULL,
  `username` char(255) default NULL,
  `ipAddress` char(15) default NULL,
  `startDate` bigint(20) NOT NULL default '0',
  `endDate` bigint(20) NOT NULL default '0',
  `isComplete` int(11) NOT NULL default '0',
  `anonId` char(255) default NULL,
  `responseJSON` longtext,
  PRIMARY KEY  (`Survey_responseId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Survey_tempReport` (
  `assetId` char(22) NOT NULL,
  `Survey_responseId` char(22) NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `sectionNumber` smallint(5) unsigned NOT NULL,
  `sectionName` text,
  `questionNumber` smallint(5) unsigned NOT NULL,
  `questionName` text,
  `questionComment` mediumtext,
  `answerNumber` smallint(5) unsigned default NULL,
  `answerValue` mediumtext,
  `answerComment` mediumtext,
  `entryDate` bigint(20) unsigned NOT NULL COMMENT 'UTC Unix Time',
  `isCorrect` tinyint(3) unsigned default NULL,
  `value` int(11) default NULL,
  `fileStoreageId` char(22) default NULL COMMENT 'Not implemented yet',
  PRIMARY KEY  (`assetId`,`Survey_responseId`,`order`),
  KEY `assetId` (`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SyndicatedContent` (
  `rssUrl` text,
  `maxHeadlines` int(11) NOT NULL default '0',
  `assetId` char(22) NOT NULL default '',
  `templateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `hasTerms` char(255) NOT NULL default '',
  `cacheTimeout` int(11) NOT NULL default '3600',
  `processMacroInRssUrl` int(11) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TT_projectList` (
  `projectId` char(22) NOT NULL,
  `assetId` char(22) default NULL,
  `projectName` char(255) NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) NOT NULL,
  `lastUpdatedBy` char(22) NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  PRIMARY KEY  (`projectId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TT_projectResourceList` (
  `projectId` char(22) NOT NULL,
  `resourceId` char(22) NOT NULL default '',
  PRIMARY KEY  (`projectId`,`resourceId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TT_projectTasks` (
  `taskId` char(22) NOT NULL,
  `projectId` char(22) NOT NULL,
  `taskName` char(255) NOT NULL,
  PRIMARY KEY  (`taskId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TT_report` (
  `reportId` char(22) NOT NULL,
  `assetId` char(22) NOT NULL,
  `startDate` char(10) NOT NULL,
  `endDate` char(10) NOT NULL,
  `reportComplete` int(11) NOT NULL default '0',
  `resourceId` char(22) NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) NOT NULL,
  `lastUpdatedBy` char(22) NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TT_timeEntry` (
  `entryId` char(22) NOT NULL,
  `projectId` char(22) NOT NULL,
  `taskId` char(22) NOT NULL,
  `taskDate` char(10) NOT NULL,
  `hours` float default '0',
  `comments` text,
  `reportId` char(22) NOT NULL,
  PRIMARY KEY  (`entryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `TT_wobject` (
  `assetId` char(22) NOT NULL,
  `userViewTemplateId` char(22) NOT NULL default 'TimeTrackingTMPL000001',
  `managerViewTemplateId` char(22) NOT NULL default 'TimeTrackingTMPL000002',
  `timeRowTemplateId` char(22) NOT NULL default 'TimeTrackingTMPL000003',
  `pmAssetId` char(22) default NULL,
  `groupToManage` char(22) NOT NULL default '3',
  `revisionDate` bigint(20) NOT NULL,
  `pmIntegration` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Thingy` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateId` char(22) NOT NULL,
  `defaultThingId` char(22) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Thingy_fields` (
  `assetId` char(22) NOT NULL,
  `thingId` char(22) NOT NULL,
  `fieldId` char(22) NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `dateCreated` bigint(20) NOT NULL,
  `createdBy` char(22) NOT NULL,
  `dateUpdated` bigint(20) NOT NULL,
  `updatedBy` char(22) NOT NULL,
  `label` char(255) NOT NULL,
  `fieldType` char(255) NOT NULL,
  `defaultValue` longtext,
  `possibleValues` text,
  `subtext` char(255) default NULL,
  `status` char(255) NOT NULL,
  `width` int(11) default NULL,
  `height` int(11) default NULL,
  `vertical` smallint(1) default NULL,
  `extras` char(255) default NULL,
  `display` int(11) default NULL,
  `viewScreenTitle` int(11) default NULL,
  `displayInSearch` int(11) default NULL,
  `searchIn` int(11) default NULL,
  `fieldInOtherThingId` char(22) default NULL,
  `size` int(11) default NULL,
  `pretext` char(255) default NULL,
  PRIMARY KEY  (`fieldId`,`thingId`,`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Thingy_things` (
  `assetId` char(22) NOT NULL,
  `thingId` char(22) NOT NULL,
  `label` char(255) NOT NULL,
  `editScreenTitle` char(255) NOT NULL,
  `editInstructions` text,
  `groupIdAdd` char(22) NOT NULL,
  `groupIdEdit` char(22) NOT NULL,
  `saveButtonLabel` char(255) NOT NULL,
  `afterSave` char(255) NOT NULL,
  `editTemplateId` char(22) NOT NULL,
  `onAddWorkflowId` char(22) default NULL,
  `onEditWorkflowId` char(22) default NULL,
  `onDeleteWorkflowId` char(22) default NULL,
  `groupIdView` char(22) NOT NULL,
  `viewTemplateId` char(22) NOT NULL,
  `defaultView` char(255) NOT NULL,
  `searchScreenTitle` char(255) NOT NULL,
  `searchDescription` text,
  `groupIdSearch` char(22) NOT NULL,
  `groupIdImport` char(22) NOT NULL,
  `groupIdExport` char(22) NOT NULL,
  `searchTemplateId` char(22) NOT NULL,
  `thingsPerPage` int(11) NOT NULL default '25',
  `sortBy` char(22) default NULL,
  `display` int(11) default NULL,
  `exportMetaData` int(11) default NULL,
  `maxEntriesPerUser` int(11) default NULL,
  PRIMARY KEY  (`thingId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Thread` (
  `assetId` char(22) NOT NULL default '',
  `replies` int(11) NOT NULL default '0',
  `lastPostId` char(22) NOT NULL default '',
  `lastPostDate` bigint(20) default NULL,
  `isLocked` int(11) NOT NULL default '0',
  `isSticky` int(11) NOT NULL default '0',
  `subscriptionGroupId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `karma` int(11) NOT NULL default '0',
  `karmaScale` int(11) NOT NULL default '1',
  `karmaRank` float(11,6) default NULL,
  `threadRating` int(11) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Thread_read` (
  `threadId` char(22) NOT NULL default '',
  `userId` char(22) NOT NULL default '',
  KEY `threadId_userId` (`threadId`,`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `UserList` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `templateId` char(22) default NULL,
  `showGroupId` char(22) default NULL,
  `hideGroupId` char(22) default NULL,
  `usersPerPage` int(11) default NULL,
  `alphabet` text,
  `alphabetSearchField` char(128) default NULL,
  `showOnlyVisibleAsNamed` int(11) default NULL,
  `sortBy` char(128) default NULL,
  `sortOrder` char(4) default NULL,
  `overridePublicEmail` int(11) default NULL,
  `overridePublicProfile` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WeatherData` (
  `assetId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) unsigned NOT NULL default '0',
  `templateId` char(22) NOT NULL default 'WeatherDataTmpl0000001',
  `locations` text,
  `partnerId` char(100) default NULL,
  `licenseKey` char(100) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WikiMaster` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupToEditPages` char(22) NOT NULL default '2',
  `groupToAdminister` char(22) NOT NULL default '3',
  `richEditor` char(22) NOT NULL default 'PBrichedit000000000002',
  `frontPageTemplateId` char(22) NOT NULL default 'WikiFrontTmpl000000001',
  `pageTemplateId` char(22) NOT NULL default 'WikiPageTmpl0000000001',
  `pageEditTemplateId` char(22) NOT NULL default 'WikiPageEditTmpl000001',
  `recentChangesTemplateId` char(22) NOT NULL default 'WikiRCTmpl000000000001',
  `mostPopularTemplateId` char(22) NOT NULL default 'WikiMPTmpl000000000001',
  `pageHistoryTemplateId` char(22) NOT NULL default 'WikiPHTmpl000000000001',
  `searchTemplateId` char(22) NOT NULL default 'WikiSearchTmpl00000001',
  `recentChangesCount` int(11) NOT NULL default '50',
  `recentChangesCountFront` int(11) NOT NULL default '10',
  `mostPopularCount` int(11) NOT NULL default '50',
  `mostPopularCountFront` int(11) NOT NULL default '10',
  `thumbnailSize` int(11) NOT NULL default '0',
  `maxImageSize` int(11) NOT NULL default '0',
  `approvalWorkflow` char(22) NOT NULL default 'pbworkflow000000000003',
  `useContentFilter` int(11) default '0',
  `filterCode` char(30) default 'javascript',
  `byKeywordTemplateId` char(22) NOT NULL default 'WikiKeyword00000000001',
  `allowAttachments` int(11) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WikiPage` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `content` mediumtext,
  `views` bigint(20) NOT NULL default '0',
  `isProtected` int(11) NOT NULL default '0',
  `actionTaken` char(35) NOT NULL,
  `actionTakenBy` char(22) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Workflow` (
  `workflowId` char(22) NOT NULL,
  `title` char(255) NOT NULL default 'Untitled',
  `description` text,
  `enabled` int(11) NOT NULL default '0',
  `type` char(255) NOT NULL default 'None',
  `mode` char(20) NOT NULL default 'parallel',
  PRIMARY KEY  (`workflowId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WorkflowActivity` (
  `activityId` char(22) NOT NULL,
  `workflowId` char(22) NOT NULL,
  `title` char(255) NOT NULL default 'Untitled',
  `description` text,
  `sequenceNumber` int(11) NOT NULL default '1',
  `className` char(255) default NULL,
  PRIMARY KEY  (`activityId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WorkflowActivityData` (
  `activityId` char(22) NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY  (`activityId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WorkflowInstance` (
  `instanceId` char(22) NOT NULL,
  `workflowId` char(22) NOT NULL,
  `currentActivityId` char(22) NOT NULL,
  `priority` int(11) NOT NULL default '2',
  `className` char(255) default NULL,
  `methodName` char(255) default NULL,
  `parameters` text,
  `runningSince` bigint(20) default NULL,
  `lastUpdate` bigint(20) default NULL,
  `lastStatus` char(15) default NULL,
  `noSession` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`instanceId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WorkflowInstanceScratch` (
  `instanceId` char(22) NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY  (`instanceId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `WorkflowSchedule` (
  `taskId` char(22) NOT NULL,
  `title` char(255) NOT NULL default 'Untitled',
  `enabled` int(11) NOT NULL default '0',
  `runOnce` int(11) NOT NULL default '0',
  `minuteOfHour` char(255) NOT NULL default '0',
  `hourOfDay` char(255) NOT NULL default '*',
  `dayOfMonth` char(255) NOT NULL default '*',
  `monthOfYear` char(255) NOT NULL default '*',
  `dayOfWeek` char(255) NOT NULL default '*',
  `workflowId` char(22) NOT NULL,
  `className` char(255) default NULL,
  `methodName` char(255) default NULL,
  `priority` int(11) NOT NULL default '2',
  `parameters` text,
  PRIMARY KEY  (`taskId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ZipArchiveAsset` (
  `assetId` char(22) NOT NULL,
  `templateId` char(22) NOT NULL default '',
  `showPage` char(255) NOT NULL default 'index.html',
  `revisionDate` bigint(20) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adSpace` (
  `adSpaceId` char(22) NOT NULL,
  `name` char(35) NOT NULL,
  `title` char(255) NOT NULL,
  `description` text,
  `costPerImpression` decimal(11,2) NOT NULL default '0.00',
  `minimumImpressions` int(11) NOT NULL default '1000',
  `costPerClick` decimal(11,2) NOT NULL default '0.00',
  `minimumClicks` int(11) NOT NULL default '1000',
  `width` int(11) NOT NULL default '468',
  `height` int(11) NOT NULL default '60',
  `groupToPurchase` char(22) NOT NULL default '3',
  PRIMARY KEY  (`adSpaceId`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `address` (
  `addressId` char(22) NOT NULL,
  `addressBookId` char(22) NOT NULL,
  `label` char(35) default NULL,
  `firstName` char(35) default NULL,
  `lastName` char(35) default NULL,
  `address1` char(35) default NULL,
  `address2` char(35) default NULL,
  `address3` char(35) default NULL,
  `city` char(35) default NULL,
  `state` char(35) default NULL,
  `country` char(35) default NULL,
  `code` char(35) default NULL,
  `phoneNumber` char(35) default NULL,
  `organization` char(255) default NULL,
  `email` char(255) default NULL,
  PRIMARY KEY  (`addressId`),
  KEY `addressBookId_addressId` (`addressBookId`,`addressId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `addressBook` (
  `addressBookId` char(22) NOT NULL,
  `sessionId` char(22) default NULL,
  `userId` char(22) default NULL,
  `defaultAddressId` char(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`addressBookId`),
  KEY `userId` (`sessionId`),
  KEY `sessionId` (`sessionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `advertisement` (
  `adId` char(22) NOT NULL,
  `adSpaceId` char(22) NOT NULL,
  `ownerUserId` char(22) NOT NULL,
  `isActive` int(11) NOT NULL default '0',
  `title` char(255) NOT NULL,
  `type` char(15) NOT NULL default 'text',
  `storageId` char(22) default NULL,
  `adText` char(255) default NULL,
  `url` text,
  `richMedia` text,
  `borderColor` char(7) NOT NULL default '#000000',
  `textColor` char(7) NOT NULL default '#000000',
  `backgroundColor` char(7) NOT NULL default '#ffffff',
  `clicks` int(11) NOT NULL default '0',
  `clicksBought` int(11) NOT NULL default '0',
  `impressions` int(11) NOT NULL default '0',
  `impressionsBought` int(11) NOT NULL default '0',
  `priority` int(11) NOT NULL default '0',
  `nextInPriority` bigint(20) NOT NULL default '0',
  `renderedAd` text,
  PRIMARY KEY  (`adId`),
  KEY `adSpaceId_isActive` (`adSpaceId`,`isActive`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asset` (
  `assetId` char(22) NOT NULL default '',
  `parentId` char(22) NOT NULL default '',
  `lineage` char(255) NOT NULL default '',
  `state` char(35) NOT NULL default '',
  `className` char(255) NOT NULL default '',
  `creationDate` bigint(20) NOT NULL default '997995720',
  `createdBy` char(22) NOT NULL default '3',
  `stateChanged` char(22) NOT NULL default '997995720',
  `stateChangedBy` char(22) NOT NULL default '3',
  `isLockedBy` char(22) default NULL,
  `isSystem` int(11) NOT NULL default '0',
  `lastExportedAs` char(255) default NULL,
  PRIMARY KEY  (`assetId`),
  UNIQUE KEY `lineage` (`lineage`),
  KEY `parentId` (`parentId`),
  KEY `state_parentId_lineage` (`state`,`parentId`,`lineage`),
  KEY `isPrototype_className_assetId` (`className`,`assetId`),
  KEY `className_assetId_state` (`className`,`assetId`,`state`),
  KEY `state_lineage` (`state`,`lineage`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetAspectComments` (
  `assetId` char(22) character set latin1 collate latin1_bin NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `comments` mediumtext,
  `averageCommentRating` int(11) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetData` (
  `assetId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `revisedBy` char(22) NOT NULL default '',
  `tagId` char(22) NOT NULL default '',
  `status` char(35) NOT NULL default 'pending',
  `title` char(255) NOT NULL default 'untitled',
  `menuTitle` char(255) NOT NULL default 'untitled',
  `url` char(255) NOT NULL default '',
  `ownerUserId` char(22) NOT NULL default '',
  `groupIdView` char(22) NOT NULL default '',
  `groupIdEdit` char(22) NOT NULL default '',
  `synopsis` text,
  `newWindow` int(11) NOT NULL default '0',
  `isHidden` int(11) NOT NULL default '0',
  `isPackage` int(11) NOT NULL default '0',
  `isPrototype` int(11) NOT NULL default '0',
  `encryptPage` int(11) NOT NULL default '0',
  `assetSize` int(11) NOT NULL default '0',
  `extraHeadTags` text,
  `skipNotification` int(11) NOT NULL default '0',
  `isExportable` int(11) NOT NULL default '1',
  `inheritUrlFromParent` int(11) NOT NULL default '0',
  `lastModified` bigint(20) default NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `assetId_url` (`assetId`,`url`),
  KEY `assetId_revisionDate_status_tagId` (`assetId`,`revisionDate`,`status`,`tagId`),
  KEY `url` (`url`),
  KEY `assetId_status_tagId_revisionDate` (`assetId`,`status`,`tagId`,`revisionDate`),
  KEY `assetId_status` (`assetId`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetHistory` (
  `assetId` char(22) NOT NULL default '',
  `userId` char(22) NOT NULL default '',
  `dateStamp` bigint(20) NOT NULL default '0',
  `actionTaken` char(255) NOT NULL default '',
  `url` char(255) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetIndex` (
  `assetId` char(22) NOT NULL,
  `title` char(255) default NULL,
  `synopsis` text,
  `url` char(255) default NULL,
  `creationDate` bigint(20) default NULL,
  `revisionDate` bigint(20) default NULL,
  `ownerUserId` char(22) default NULL,
  `groupIdView` char(22) default NULL,
  `groupIdEdit` char(22) default NULL,
  `className` char(255) default NULL,
  `isPublic` int(11) NOT NULL default '1',
  `keywords` mediumtext,
  `lineage` char(255) default NULL,
  PRIMARY KEY  (`assetId`),
  FULLTEXT KEY `keywords` (`keywords`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetKeyword` (
  `keyword` char(64) NOT NULL,
  `assetId` char(22) NOT NULL,
  PRIMARY KEY  (`keyword`,`assetId`),
  KEY `keyword` (`keyword`),
  KEY `assetId` (`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `assetVersionTag` (
  `tagId` char(22) NOT NULL default '',
  `name` char(255) NOT NULL default '',
  `isCommitted` int(11) NOT NULL default '0',
  `creationDate` bigint(20) NOT NULL default '0',
  `createdBy` char(22) NOT NULL default '',
  `commitDate` bigint(20) NOT NULL default '0',
  `committedBy` char(22) NOT NULL default '',
  `isLocked` int(11) NOT NULL default '0',
  `lockedBy` char(22) NOT NULL default '',
  `groupToUse` char(22) NOT NULL default '',
  `workflowId` char(22) NOT NULL default '',
  `workflowInstanceId` char(22) default NULL,
  `comments` text,
  `startTime` datetime default NULL,
  `endTime` datetime default NULL,
  `isSiteWide` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`tagId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authentication` (
  `userId` char(22) NOT NULL default '',
  `authMethod` char(30) NOT NULL default '',
  `fieldName` char(128) NOT NULL default '',
  `fieldData` text,
  PRIMARY KEY  (`userId`,`authMethod`,`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cache` (
  `namespace` char(128) NOT NULL,
  `cachekey` char(128) NOT NULL,
  `expires` bigint(20) NOT NULL,
  `size` int(11) NOT NULL,
  `content` mediumblob,
  PRIMARY KEY  (`namespace`,`cachekey`),
  KEY `namespace_cachekey_size` (`namespace`,`cachekey`,`expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cart` (
  `cartId` char(22) NOT NULL,
  `sessionId` char(22) NOT NULL,
  `shippingAddressId` char(22) default NULL,
  `shipperId` char(22) default NULL,
  `posUserId` char(22) character set utf8 collate utf8_bin default NULL,
  `creationDate` int(20) default NULL,
  PRIMARY KEY  (`cartId`),
  KEY `sessionId` (`sessionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cartItem` (
  `itemId` char(22) NOT NULL,
  `cartId` char(22) NOT NULL,
  `assetId` char(22) NOT NULL,
  `dateAdded` datetime NOT NULL,
  `options` mediumtext,
  `configuredTitle` char(255) default NULL,
  `shippingAddressId` char(22) default NULL,
  `quantity` int(11) NOT NULL default '1',
  PRIMARY KEY  (`itemId`),
  KEY `cartId_assetId_dateAdded` (`cartId`,`assetId`,`dateAdded`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `databaseLink` (
  `databaseLinkId` char(22) NOT NULL default '',
  `title` char(255) default NULL,
  `DSN` char(255) default NULL,
  `username` char(255) default NULL,
  `identifier` char(255) default NULL,
  `allowedKeywords` text,
  `allowMacroAccess` int(11) NOT NULL default '0',
  `additionalParameters` char(255) NOT NULL default '',
  PRIMARY KEY  (`databaseLinkId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `donation` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `defaultPrice` float NOT NULL default '100',
  `thankYouMessage` mediumtext,
  `templateId` char(22) NOT NULL,
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `friendInvitations` (
  `inviteId` char(22) NOT NULL,
  `inviterId` char(22) NOT NULL,
  `friendId` char(22) NOT NULL,
  `dateSent` datetime NOT NULL,
  `comments` char(255) NOT NULL,
  `messageId` char(22) NOT NULL,
  PRIMARY KEY  (`inviteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groupGroupings` (
  `groupId` char(22) NOT NULL default '',
  `inGroup` char(22) NOT NULL default ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groupings` (
  `groupId` char(22) NOT NULL default '',
  `userId` char(22) NOT NULL default '',
  `expireDate` bigint(20) NOT NULL default '2114402400',
  `groupAdmin` int(11) NOT NULL default '0',
  PRIMARY KEY  (`groupId`,`userId`),
  KEY `userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups` (
  `groupId` char(22) NOT NULL default '',
  `groupName` char(100) default NULL,
  `description` char(255) default NULL,
  `expireOffset` int(11) NOT NULL default '314496000',
  `karmaThreshold` int(11) NOT NULL default '1000000000',
  `ipFilter` text,
  `dateCreated` int(11) NOT NULL default '997938000',
  `lastUpdated` int(11) NOT NULL default '997938000',
  `deleteOffset` int(11) NOT NULL default '14',
  `expireNotifyOffset` int(11) NOT NULL default '-14',
  `expireNotifyMessage` text,
  `expireNotify` int(11) NOT NULL default '0',
  `scratchFilter` text,
  `autoAdd` int(11) NOT NULL default '0',
  `autoDelete` int(11) NOT NULL default '0',
  `databaseLinkId` char(22) NOT NULL default '',
  `groupCacheTimeout` int(11) NOT NULL default '3600',
  `dbQuery` text,
  `isEditable` int(11) NOT NULL default '1',
  `showInForms` int(11) NOT NULL default '1',
  `ldapGroup` char(255) default NULL,
  `ldapGroupProperty` char(255) default NULL,
  `ldapRecursiveProperty` char(255) default NULL,
  `ldapLinkId` char(22) default NULL,
  `ldapRecursiveFilter` mediumtext,
  `isAdHocMailGroup` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`groupId`),
  KEY `groupName` (`groupName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imageColor` (
  `colorId` char(22) NOT NULL,
  `name` char(255) NOT NULL default 'untitled',
  `fillTriplet` char(7) NOT NULL default '#000000',
  `fillAlpha` char(2) NOT NULL default '00',
  `strokeTriplet` char(7) NOT NULL default '#000000',
  `strokeAlpha` char(2) NOT NULL default '00',
  PRIMARY KEY  (`colorId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imageFont` (
  `fontId` char(22) NOT NULL,
  `name` char(255) default NULL,
  `storageId` char(22) default NULL,
  `filename` char(255) default NULL,
  PRIMARY KEY  (`fontId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imagePalette` (
  `paletteId` char(22) NOT NULL,
  `name` char(255) NOT NULL default 'untitled',
  PRIMARY KEY  (`paletteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `imagePaletteColors` (
  `paletteId` char(22) NOT NULL,
  `colorId` char(22) NOT NULL,
  `paletteOrder` int(11) NOT NULL,
  PRIMARY KEY  (`paletteId`,`paletteOrder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inbox` (
  `messageId` char(22) NOT NULL,
  `status` char(15) NOT NULL default 'pending',
  `dateStamp` bigint(20) NOT NULL,
  `completedOn` bigint(20) default NULL,
  `completedBy` char(22) default NULL,
  `userId` char(22) default NULL,
  `groupId` char(22) default NULL,
  `subject` char(255) NOT NULL default 'No Subject',
  `message` mediumtext,
  `sentBy` char(22) NOT NULL default '3',
  PRIMARY KEY  (`messageId`),
  KEY `completedOn_dateStamp` (`completedOn`,`dateStamp`),
  KEY `pb_userId` (`userId`),
  KEY `pb_groupId` (`groupId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inbox_messageState` (
  `messageId` char(22) character set latin1 collate latin1_bin NOT NULL,
  `userId` char(22) character set latin1 collate latin1_bin NOT NULL,
  `isRead` tinyint(4) NOT NULL default '0',
  `repliedTo` tinyint(4) NOT NULL default '0',
  `deleted` tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (`messageId`,`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `incrementer` (
  `incrementerId` char(50) NOT NULL default '',
  `nextValue` int(11) NOT NULL default '1',
  PRIMARY KEY  (`incrementerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `karmaLog` (
  `userId` char(22) NOT NULL default '',
  `amount` int(11) NOT NULL default '1',
  `source` char(255) default NULL,
  `description` text,
  `dateModified` bigint(20) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ldapLink` (
  `ldapLinkId` char(22) NOT NULL default '',
  `ldapLinkName` char(255) NOT NULL default '',
  `ldapUrl` char(255) NOT NULL default '',
  `connectDn` char(255) NOT NULL default '',
  `identifier` char(255) NOT NULL default '',
  `ldapUserRDN` char(255) default NULL,
  `ldapIdentity` char(255) default NULL,
  `ldapIdentityName` char(255) default NULL,
  `ldapPasswordName` char(255) default NULL,
  `ldapSendWelcomeMessage` char(2) default NULL,
  `ldapWelcomeMessage` text,
  `ldapAccountTemplate` char(22) NOT NULL default '',
  `ldapCreateAccountTemplate` char(22) NOT NULL default '',
  `ldapLoginTemplate` char(22) NOT NULL default '',
  `ldapGlobalRecursiveFilter` mediumtext,
  PRIMARY KEY  (`ldapLinkId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mailQueue` (
  `messageId` char(22) NOT NULL,
  `message` mediumtext,
  `toGroup` char(22) default NULL,
  PRIMARY KEY  (`messageId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metaData_properties` (
  `fieldId` char(22) NOT NULL default '',
  `fieldName` char(100) NOT NULL default '',
  `description` mediumtext NOT NULL,
  `fieldType` char(30) default NULL,
  `possibleValues` text,
  `defaultValue` char(255) default NULL,
  PRIMARY KEY  (`fieldId`),
  UNIQUE KEY `field_unique` (`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `metaData_values` (
  `fieldId` char(22) NOT NULL default '',
  `value` char(255) default NULL,
  `assetId` char(22) NOT NULL default '',
  PRIMARY KEY  (`fieldId`,`assetId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `passiveProfileAOI` (
  `userId` char(22) NOT NULL default '',
  `fieldId` char(22) NOT NULL default '',
  `value` char(100) NOT NULL default '',
  `count` int(11) default NULL,
  PRIMARY KEY  (`userId`,`fieldId`,`value`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `passiveProfileLog` (
  `passiveProfileLogId` char(22) NOT NULL default '',
  `userId` char(22) NOT NULL default '',
  `sessionId` char(22) NOT NULL default '',
  `assetId` char(22) NOT NULL default '',
  `dateOfEntry` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`passiveProfileLogId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `paymentGateway` (
  `paymentGatewayId` char(22) NOT NULL,
  `className` char(255) default NULL,
  `options` mediumtext,
  PRIMARY KEY  (`paymentGatewayId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `redirect` (
  `assetId` char(22) NOT NULL default '',
  `redirectUrl` text,
  `revisionDate` bigint(20) NOT NULL default '0',
  `redirectType` int(11) NOT NULL default '302',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `replacements` (
  `replacementId` char(22) NOT NULL default '',
  `searchFor` char(255) default NULL,
  `replaceWith` text,
  PRIMARY KEY  (`replacementId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `search` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL default '0',
  `classLimiter` text,
  `searchRoot` char(22) NOT NULL default 'PBasset000000000000001',
  `templateId` char(22) NOT NULL default 'PBtmpl0000000000000200',
  `useContainers` int(11) NOT NULL default '0',
  `paginateAfter` int(11) NOT NULL default '25',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `name` char(255) NOT NULL default '',
  `value` text,
  PRIMARY KEY  (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipper` (
  `shipperId` char(22) NOT NULL,
  `className` char(255) default NULL,
  `options` mediumtext,
  PRIMARY KEY  (`shipperId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shopCredit` (
  `creditId` char(22) NOT NULL,
  `userId` char(22) NOT NULL,
  `amount` float NOT NULL default '0',
  `comment` text,
  `dateOfAdjustment` datetime default NULL,
  PRIMARY KEY  (`creditId`),
  KEY `userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sku` (
  `assetId` char(22) NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `description` mediumtext,
  `sku` char(35) NOT NULL,
  `vendorId` char(22) NOT NULL default 'defaultvendor000000000',
  `displayTitle` tinyint(1) NOT NULL default '1',
  `overrideTaxRate` tinyint(1) NOT NULL default '0',
  `taxRateOverride` float NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `sku` (`sku`),
  KEY `vendorId` (`vendorId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `snippet` (
  `assetId` char(22) NOT NULL default '',
  `snippet` mediumtext,
  `processAsTemplate` int(11) NOT NULL default '0',
  `mimeType` char(50) NOT NULL default 'text/html',
  `revisionDate` bigint(20) NOT NULL default '0',
  `cacheTimeout` int(11) NOT NULL default '3600',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptionCode` (
  `batchId` char(22) NOT NULL default '',
  `code` char(64) NOT NULL default '',
  `status` char(10) NOT NULL default 'Unused',
  `dateCreated` int(11) NOT NULL default '0',
  `dateUsed` int(11) NOT NULL default '0',
  `expires` int(11) NOT NULL default '0',
  `usedBy` char(22) NOT NULL default '',
  PRIMARY KEY  (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptionCodeBatch` (
  `batchId` char(22) NOT NULL default '',
  `name` char(128) default NULL,
  `description` mediumtext NOT NULL,
  `subscriptionId` char(22) NOT NULL default '',
  PRIMARY KEY  (`batchId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptionCodeSubscriptions` (
  `code` char(64) NOT NULL default '',
  `subscriptionId` char(22) NOT NULL default '',
  UNIQUE KEY `code` (`code`,`subscriptionId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tax` (
  `taxId` char(22) NOT NULL,
  `country` char(100) NOT NULL,
  `state` char(100) default NULL,
  `city` char(100) default NULL,
  `code` char(100) default NULL,
  `taxRate` float NOT NULL default '0',
  PRIMARY KEY  (`taxId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `template` (
  `template` mediumtext,
  `namespace` char(35) NOT NULL default 'Page',
  `isEditable` int(11) NOT NULL default '1',
  `showInForms` int(11) NOT NULL default '1',
  `assetId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  `parser` char(255) NOT NULL default 'WebGUI::Asset::Template::HTMLTemplate',
  `isDefault` int(1) default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`),
  KEY `namespace_showInForms` (`namespace`,`showInForms`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transaction` (
  `transactionId` char(22) NOT NULL,
  `originatingTransactionId` char(22) default NULL,
  `isSuccessful` tinyint(1) NOT NULL default '0',
  `orderNumber` int(11) NOT NULL auto_increment,
  `transactionCode` char(100) default NULL,
  `statusCode` char(35) default NULL,
  `statusMessage` char(255) default NULL,
  `userId` char(22) NOT NULL,
  `username` char(35) NOT NULL,
  `amount` float default NULL,
  `shopCreditDeduction` float default NULL,
  `shippingAddressId` char(22) default NULL,
  `shippingAddressName` char(35) default NULL,
  `shippingAddress1` char(35) default NULL,
  `shippingAddress2` char(35) default NULL,
  `shippingAddress3` char(35) default NULL,
  `shippingCity` char(35) default NULL,
  `shippingState` char(35) default NULL,
  `shippingCountry` char(35) default NULL,
  `shippingCode` char(35) default NULL,
  `shippingPhoneNumber` char(35) default NULL,
  `shippingDriverId` char(22) default NULL,
  `shippingDriverLabel` char(35) default NULL,
  `shippingPrice` float default NULL,
  `paymentAddressId` char(22) default NULL,
  `paymentAddressName` char(35) default NULL,
  `paymentAddress1` char(35) default NULL,
  `paymentAddress2` char(35) default NULL,
  `paymentAddress3` char(35) default NULL,
  `paymentCity` char(35) default NULL,
  `paymentState` char(35) default NULL,
  `paymentCountry` char(35) default NULL,
  `paymentCode` char(35) default NULL,
  `paymentPhoneNumber` char(35) default NULL,
  `paymentDriverId` char(22) default NULL,
  `paymentDriverLabel` char(35) default NULL,
  `taxes` float default NULL,
  `dateOfPurchase` datetime default NULL,
  `isRecurring` tinyint(1) default NULL,
  `notes` mediumtext,
  `cashierUserId` char(22) character set utf8 collate utf8_bin default NULL,
  PRIMARY KEY  (`transactionId`),
  UNIQUE KEY `orderNumber` (`orderNumber`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transactionItem` (
  `itemId` char(22) NOT NULL,
  `transactionId` char(22) NOT NULL,
  `assetId` char(22) default NULL,
  `configuredTitle` char(255) default NULL,
  `options` mediumtext,
  `shippingAddressId` char(22) default NULL,
  `shippingName` char(35) default NULL,
  `shippingAddress1` char(35) default NULL,
  `shippingAddress2` char(35) default NULL,
  `shippingAddress3` char(35) default NULL,
  `shippingCity` char(35) default NULL,
  `shippingState` char(35) default NULL,
  `shippingCountry` char(35) default NULL,
  `shippingCode` char(35) default NULL,
  `shippingPhoneNumber` char(35) default NULL,
  `shippingTrackingNumber` char(255) default NULL,
  `orderStatus` char(35) NOT NULL default 'NotShipped',
  `lastUpdated` datetime default NULL,
  `quantity` int(11) NOT NULL default '1',
  `price` float default NULL,
  `vendorId` char(22) NOT NULL default 'defaultvendor000000000',
  PRIMARY KEY  (`itemId`),
  KEY `transactionId` (`transactionId`),
  KEY `vendorId` (`vendorId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userInvitations` (
  `inviteId` char(22) NOT NULL,
  `userId` char(22) NOT NULL,
  `dateSent` date default NULL,
  `email` char(255) NOT NULL,
  `newUserId` char(22) default NULL,
  `dateCreated` date default NULL,
  PRIMARY KEY  (`inviteId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userLoginLog` (
  `userId` char(22) NOT NULL default '',
  `status` char(30) default NULL,
  `timeStamp` int(11) default NULL,
  `ipAddress` char(128) default NULL,
  `userAgent` text,
  `sessionId` char(22) default NULL,
  `lastPageViewed` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userProfileCategory` (
  `profileCategoryId` char(22) NOT NULL default '',
  `label` char(255) NOT NULL default 'Undefined',
  `shortLabel` char(255) default NULL,
  `sequenceNumber` int(11) NOT NULL default '1',
  `visible` int(11) NOT NULL default '1',
  `editable` int(11) NOT NULL default '1',
  `protected` int(11) NOT NULL default '0',
  PRIMARY KEY  (`profileCategoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userProfileData` (
  `userId` char(22) NOT NULL,
  `email` char(255) default NULL,
  `firstName` char(255) default NULL,
  `middleName` char(255) default NULL,
  `lastName` char(255) default NULL,
  `icq` char(255) default NULL,
  `aim` char(255) default NULL,
  `msnIM` char(255) default NULL,
  `yahooIM` char(255) default NULL,
  `cellPhone` char(255) default NULL,
  `pager` char(255) default NULL,
  `emailToPager` char(255) default NULL,
  `language` char(255) default NULL,
  `homeAddress` char(255) default NULL,
  `homeCity` char(255) default NULL,
  `homeState` char(255) default NULL,
  `homeZip` char(255) default NULL,
  `homeCountry` char(255) default NULL,
  `homePhone` char(255) default NULL,
  `workAddress` char(255) default NULL,
  `workCity` char(255) default NULL,
  `workState` char(255) default NULL,
  `workZip` char(255) default NULL,
  `workCountry` char(255) default NULL,
  `workPhone` char(255) default NULL,
  `gender` char(255) default NULL,
  `birthdate` bigint(20) default NULL,
  `homeURL` char(255) default NULL,
  `workURL` char(255) default NULL,
  `workName` char(255) default NULL,
  `timeZone` char(255) default NULL,
  `dateFormat` char(255) default NULL,
  `timeFormat` char(255) default NULL,
  `discussionLayout` char(255) default NULL,
  `firstDayOfWeek` char(255) default NULL,
  `uiLevel` char(255) default NULL,
  `alias` char(255) default NULL,
  `signature` longtext,
  `publicProfile` char(10) default 'none',
  `toolbar` char(255) default NULL,
  `photo` char(22) default NULL,
  `avatar` char(22) default NULL,
  `department` char(255) default NULL,
  `allowPrivateMessages` text,
  `ableToBeFriend` int(1) default NULL,
  `showMessageOnLoginSeen` bigint(20) default NULL,
  `showOnline` tinyint(1) default NULL,
  `versionTagMode` char(255) default NULL,
  `wg_privacySettings` longtext,
  PRIMARY KEY  (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userProfileField` (
  `fieldName` char(128) NOT NULL default '',
  `label` char(255) NOT NULL default 'Undefined',
  `visible` int(11) NOT NULL default '0',
  `required` int(11) NOT NULL default '0',
  `fieldType` char(128) NOT NULL default 'text',
  `possibleValues` text,
  `dataDefault` text,
  `sequenceNumber` int(11) NOT NULL default '1',
  `profileCategoryId` char(22) NOT NULL default '',
  `protected` int(11) NOT NULL default '0',
  `editable` int(11) NOT NULL default '1',
  `forceImageOnly` int(11) default '1',
  `showAtRegistration` int(11) NOT NULL default '0',
  `requiredForPasswordRecovery` int(11) NOT NULL default '0',
  `extras` text,
  `defaultPrivacySetting` char(128) default NULL,
  PRIMARY KEY  (`fieldName`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userSession` (
  `sessionId` char(22) NOT NULL default '',
  `expires` int(11) default NULL,
  `lastPageView` int(11) default NULL,
  `adminOn` int(11) NOT NULL default '0',
  `lastIP` char(50) default NULL,
  `userId` char(22) NOT NULL default '',
  PRIMARY KEY  (`sessionId`),
  KEY `expires` (`expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `userSessionScratch` (
  `sessionId` char(22) NOT NULL default '',
  `name` char(255) NOT NULL default '',
  `value` text,
  PRIMARY KEY  (`sessionId`,`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `userId` char(22) NOT NULL default '',
  `username` char(100) default NULL,
  `authMethod` char(30) NOT NULL default 'WebGUI',
  `dateCreated` int(11) NOT NULL default '1019867418',
  `lastUpdated` int(11) NOT NULL default '1019867418',
  `karma` int(11) NOT NULL default '0',
  `status` char(35) NOT NULL default 'Active',
  `referringAffiliate` char(22) NOT NULL default '',
  `friendsGroup` char(22) NOT NULL default '',
  PRIMARY KEY  (`userId`),
  UNIQUE KEY `username_unique` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `vendor` (
  `vendorId` char(22) NOT NULL,
  `dateCreated` datetime default NULL,
  `name` char(255) default NULL,
  `userId` char(22) NOT NULL default '3',
  `preferredPaymentType` char(255) default NULL,
  `paymentInformation` text,
  `paymentAddressId` char(22) default NULL,
  `url` text,
  PRIMARY KEY  (`vendorId`),
  KEY `userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `webguiVersion` (
  `webguiVersion` char(10) default NULL,
  `versionType` char(30) default NULL,
  `dateApplied` int(11) default NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `wobject` (
  `displayTitle` int(11) NOT NULL default '1',
  `description` mediumtext,
  `assetId` char(22) NOT NULL default '',
  `styleTemplateId` char(22) NOT NULL default '',
  `printableStyleTemplateId` char(22) NOT NULL default '',
  `revisionDate` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`assetId`,`revisionDate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;
INSERT INTO `Article` VALUES (NULL,NULL,'NK8bqlwVRILJknqeCDPBHg','PBtmpl0000000000000002',1147642515,3600,'0jTuDoyTcQK6ju8cs8a4ew'),(NULL,NULL,'bX5rYxb6tZ9docY6sUhBlw','PBtmpl0000000000000002',1147642514,3600,'r3QdZwvuVK9o9kLb7mpHGQ'),(NULL,NULL,'OhdaFLE7sXOzo_SIP2ZUgA','PBtmpl0000000000000002',1147642513,3600,'GY5wyiuNmZZyLdgFt3zluQ'),(NULL,NULL,'IWFxZDyGhQ3-SLZhELa3qw','PBtmpl0000000000000002',1147642514,3600,'BS9OtDY_8oUnmzStD-wPmg'),(NULL,NULL,'6QuS-0rosuZTdTv11fobig','PBtmpl0000000000000002',1147642515,3600,'qDIYM6Jcmkk_LmWZIqqJ7w'),(NULL,NULL,'ix1p0AbwKAz8QWB-T-HHfg','PBtmpl0000000000000002',1147642516,3600,'gU8kZk0nV6SqcwKqSiojQQ'),(NULL,NULL,'iCYOjohB9SKvAPr6bXElKA','PBtmpl0000000000000002',1147642516,3600,'eTxnooflqjFWIwkyfE0nPQ'),(NULL,NULL,'4Yfz9hqBqM8OYMGuQK8oLw','PBtmpl0000000000000002',1147642516,3600,'x4_4U_yb-MAGELG0jxAqpQ'),(NULL,NULL,'Wl8WZ43g2rK5AYr9o4zY7w','PBtmpl0000000000000002',1147642516,3600,'QlXRvOaqkv9X2kY-eAQXKA'),(NULL,NULL,'LBuiKzg2mWwmOPS9AgV3bg','PBtmpl0000000000000002',1147642517,3600,'UYaT3bhIk9HXmX1io5MdlQ'),(NULL,NULL,'jTNggl7AoVSUc_ZzrvuCmw','PBtmpl0000000000000002',1147642517,3600,'NWhmkoojuu9dA4_zv3a4pg'),(NULL,'http://','FOvmwGC0GtZo5VTxJIL3OA','PBtmpl0000000000000002',1207068851,3600,'WOkKCSUedPrlPkYwsTgEEA'),(NULL,'http://','j_1qEqM6iLfQLiR6VKy0aA','PBtmpl0000000000000002',1215718151,3600,'2k_h890E0bVoT1Jq6s-Edg'),(NULL,'http://','diZvW4bSgZWwyyGP3qXi1g','PBtmpl0000000000000002',1215717972,3600,'kjLi5s-xRSCL63HfE8ArtA');
INSERT INTO `Collaboration` VALUES ('pbproto000000000000002','2','2',0,'PBtmpl0000000000000208','PBtmpl0000000000000209','PBtmpl0000000000000210','','','assetData.revisionDate','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,2592000,10,30,NULL,1,0,'PBrichedit000000000002',0,0,1163019036,0,'pbworkflow000000000003','pbworkflow000000000003',100,NULL,NULL,NULL,NULL,NULL,0,300,'NpRVTSR-NX2sD52LUc520A',3600,1,1,0,0,0,0,'12',1,'default_post_received1');
INSERT INTO `DataForm` VALUES ('Thank you for telling your friends about WebGUI!',1,'PBtmpl0000000000000085','PBtmpl0000000000000104','PBtmpl0000000000000021','Szs5eev3OMssmnsyLRZmWA','PBtmpl0000000000000020',0,1213317790,'7',0,0,1,'[{\"width\":\"0\",\"options\":\"\",\"status\":\"required\",\"tabId\":null,\"name\":\"from\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"Your Email Address\",\"type\":\"Email\",\"defaultValue\":\"\"},{\"width\":\"0\",\"options\":\"\",\"status\":\"required\",\"tabId\":null,\"name\":\"to\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"Your Friends Email Address\",\"type\":\"Email\",\"defaultValue\":\"\"},{\"width\":\"0\",\"options\":null,\"status\":\"hidden\",\"tabId\":null,\"name\":\"cc\",\"rows\":null,\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":null,\"label\":\"Cc\",\"type\":\"Email\",\"defaultValue\":null},{\"width\":\"0\",\"options\":null,\"status\":\"hidden\",\"tabId\":null,\"name\":\"bcc\",\"rows\":null,\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":null,\"label\":\"Bcc\",\"type\":\"Email\",\"defaultValue\":null},{\"width\":\"0\",\"options\":\"\",\"status\":\"hidden\",\"tabId\":null,\"name\":\"subject\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"Subject\",\"type\":\"Text\",\"defaultValue\":\"Cool CMS\"},{\"width\":\"0\",\"options\":\"\",\"status\":\"visible\",\"tabId\":null,\"name\":\"url\",\"rows\":\"0\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"1\",\"subtext\":\"\",\"label\":\"URL\",\"type\":\"Url\",\"defaultValue\":\"http://www.webgui.org\"},{\"width\":\"300\",\"options\":\"\",\"status\":\"required\",\"tabId\":null,\"name\":\"message\",\"rows\":\"100\",\"extras\":null,\"vertical\":\"1\",\"isMailField\":\"0\",\"subtext\":\"\",\"label\":\"Message\",\"type\":\"Textarea\",\"defaultValue\":\"Hey I just wanted to tell you about this great program called WebGUI that I found: http://www.webgui.org\\r\\n\\r\\nYou should really check it out.\"}]','[]',NULL);
INSERT INTO `FileAsset` VALUES ('7-0-style0000000000002','_Vo1Pvl3sPPANyxz-IcCtA','body_bg.jpg','PBtmpl0000000000000088',1147642492,3600),('7-0-style0000000000004','Gemp7cEVjh2_M2IicUYs-g','gui_bottom.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000005','ry-yzLVH-vxn71H9byjGXA','header.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000006','VEPa65fhY3dok6vj-beFCA','main_bg.gif','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000007','Cfay1MNkC-73WKJ7fX_pVw','main_bg.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000008','iEBE--vQb_lxuZd5AP8tuw','nav1_center_on.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000009','XR1Yjf3MkYA53TJlcpRBsw','nav1_off.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000010','sxvAS8na-QAdY_eycd2gKw','nav1_off_center.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000011','2lhmrXW46ZMLvpbaaX2g7Q','nav1_off_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000012','sEoRwhmonl877RBgx2nE1w','nav1_off_right.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000013','AoSfRkPI3fl7vAooT4Fj_A','nav1_on.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000014','MgNDJRsghd_zQZ292hqVMQ','nav1_on_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000015','aUG1FZaIqHaQHlieZ4_Mkg','nav1_on_right.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000016','HyhLnkaJMfr8eJsLIX8XeA','nav2_center_on.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000017','aledEnWoD-JVNURWSklfdg','nav2_off_center.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000018','Ffd33PToWon9X7mcKZqUAQ','nav2_off_left.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000019','B3TTkcOlr-VzcxRwQXZmyg','nav2_off_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000020','RxGSyn-8W4p64SQ-NYzNOg','nav2_on_left.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000021','NciEByP8ssN6qDYyKcoGWw','nav2_on_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000022','9OVg_Nxo0gha5pWZsS_dmw','nav_bg.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000023','VKtJGCmBtsMj8ZeAJ6ePNw','nav_on.jpg','PBtmpl0000000000000088',1147642498,3600),('7-0-style0000000000024','ryQb0A4YeEwYZo9hdgrCcw','orange_left01.jpg','PBtmpl0000000000000088',1147642498,3600),('7-0-style0000000000030','coew3C1i9AORof9ezjWLDg','webgui_btn.jpg','PBtmpl0000000000000088',1147642499,3600),('7-0-style0000000000032','HEySmh0CRxpkI-tjzgkDDw','context_bg.jpg','PBtmpl0000000000000088',1147642500,3600),('7-0-style0000000000034','HPn3mVDaMkn8Iu0GAq7cAw','leftCol_header.jpg','PBtmpl0000000000000088',1147642500,3600),('7-0-style0000000000035','IqaSdxJqqN_8C-7OWeyE2g','leftCol_header02.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000036','M0cIcS1GDFIV8lwAw3U2hA','main_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000037','77rakTqCXGBihEOXoh4ZXQ','nav_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000038','5najYvfJiZBBaiCVxaNkcQ','navbar_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000039','27XAOBKNfJ2euexImD73Aw','navbar_left.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000040','sgd1YdmVKj-n6IyIWJicXg','navbar_right.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000041','i1oJph6lb3hxEsTNu_3Y7g','page_title.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000042','qMwO_tp9KOya_N-kyIHDJQ','page_title_bg.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000043','l5hF84u5R9MoqMvS9gpp6g','pb.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000044','Eh4IRmClOEzDAU1IVn5vHQ','pb_wg.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000045','e8yirsGt9FZEgzfeHLgRiw','pb_wg_bg.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000046','hDmN6gu1w_jtrcxgTRN5OQ','rightCol_bg.jpg','PBtmpl0000000000000088',1147642504,3600),('7-0-style0000000000048','_QhSdbnBeA1zio6iAuGIag','wg.jpg','PBtmpl0000000000000088',1147642504,3600),('7-0-style0000000000052','VRqMCZ_-GgaJiDeOrnwlQg','footer_bg.jpg','PBtmpl0000000000000088',1147642505,3600),('7-0-style0000000000053','baxoDEB4C8eLjZbnENMs9w','footer_right.jpg','PBtmpl0000000000000088',1147642505,3600),('7-0-style0000000000054','FlivcrAW0pKW4q_2fvlVpw','header_bg.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000055','5hgdAMRWeSmHDrRFM_qbBw','header_left.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000056','lV6l3Sctxx8J1JmYlXwSDA','header_right.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000057','FKGH2yiNQoC2E_FqbMYebw','main_bg.jpg','PBtmpl0000000000000088',1147642507,3600),('7-0-style0000000000058','UGtgwjDaqCtCPnEkuLPtIw','main_bottom.jpg','PBtmpl0000000000000088',1147642507,3600),('7-0-style0000000000060','XsuCCMz5vyyfC8Xr89pb1Q','main_top_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000061','is_6p2ROuy6AhCR1eJ8SdQ','nav_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000062','3rpFbJWSV14AWeDZqqPSSw','nav_bg1.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000063','NcTFm_t9rn63ejwtBQnDQw','nav_bg1_on.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000064','XLKBWi6Asbz5CtZdnwzZmg','nav_bg2.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000065','02cdKPH5-SyFEb_Zo_WL8A','nav_bg2_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000066','0QQpTB8bi6JZvFrW74SOWg','nav_bg_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000067','DdhQHfqGq-yC1ukTdlqoEg','pb.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000068','Y4AWquISZVLcwVQLzd_u7w','spacer.gif','PBtmpl0000000000000088',1147642510,3600),('7-0-style0000000000071','mJOrQFemh2R3xn2HYviQlQ','wg.jpg','PBtmpl0000000000000088',1147642511,3600),('m4YJFaqzultnB_sj1Uq0aw','JX9y6tHiSaAv3-Jq6QXHGw','advert01.swf','pbtmpl0000000000000220',1147642514,3600),('Vzv1pWpg_w6R_o-b0rM2qQ','PMKX5QYkNFvrCD15QVo8Tg','Tutorial.swf','pbtmpl0000000000000221',1147642515,3600),('bANo8aiAPA7aY_oQZKxIWw','l0vJttSGYiITS96pOJIh2Q','rss.gif','PBtmpl0000000000000088',1197330678,0),('fdd8tGExyVwHyrB8RBbKXg','H8qvtaTvDkNHOm-h0yfpAg','next.gif','PBtmpl0000000000000088',1197330839,0),('BpisgHl4ZDcSECJp6oib1w','B3fjChKsXh4QFgvs1Gf4BQ','play.gif','PBtmpl0000000000000088',1197330840,0),('zshreRgPAXtnF0DtVbQ1Yg','tYxidtXD9bXmPkEZsinI-A','previous.gif','PBtmpl0000000000000088',1197330840,0),('2ci_v2d4x4uvyjTRlC49OA','QBcmUnAdUKoMQoP9OxDdqA','moveDown.gif','PBtmpl0000000000000088',1209499188,0),('O-EsSzKgAk1KolFT-x_KsA','g8rvEQyyvxfs0sNklPNzsQ','moveUp.gif','PBtmpl0000000000000088',1209499188,0),('POVcY79vIqAHR8OfGt36aw','NGu3NiVKD4TV1Sw4N5YmIg','pagination_button.jpg','PBtmpl0000000000000088',1209499189,0),('hIB-z34r8Xl-vYVYCkKr-w','i1uZztdNddqvW9Tt_JOBzw','bar-btn-r.jpg','PBtmpl0000000000000088',1209499189,0),('-mPUoFlYcjqjPUPRLAlxNQ','X7PA2VUynp_X5b1mHRqvnA','search-field-r.jpg','PBtmpl0000000000000088',1209499189,0),('MDpUOR-N8KMyt1J7Hh_h4w','ed1kbQ8Aed2Uh09gIo5HTQ','bar-btn.jpg','PBtmpl0000000000000088',1209499189,0),('YfXKByTwDZVituMc4h13Dg','SMhIjHLxVLJSjOsSvbLcMA','pagination_bg.jpg','PBtmpl0000000000000088',1209499189,0),('esko_HSU0Gh-uJZ1h3xRmQ','av317NZvdb5ATKy1BctVyg','search-field-l.jpg','PBtmpl0000000000000088',1209499189,0),('oSqpGswzpBG_ErdfYwIO8A','gyukfQn4q_CoHrieNClI3A','top_bg.jpg','PBtmpl0000000000000088',1209499189,0),('MXJklShZvLLB_DSnZQmXrQ','fEBf-KYzxE-cPJYrKkpyHg','title_bg.jpg','PBtmpl0000000000000088',1209499189,0),('BthxD5oJ0idmsyI3ioA2FA','ZzZWC22vEsrgqSbNABaiSw','bar-btn-l.jpg','PBtmpl0000000000000088',1209499189,0),('aZ-1HYQamkRHYXvzAra8WQ','--qeq91xu4bPCfTNHQTN6g','search-field.jpg','PBtmpl0000000000000088',1209499189,0),('eRkb94OYcS5AdcrrerOP5Q','VTYx-kkmpTSFtdKzX9FRcw','rss.gif','PBtmpl0000000000000088',1209499189,0),('TbnkjAJQEASORXIpYqDkcA','rysPVifAyGtsgqtkgS6RTw','blank-image.jpg','PBtmpl0000000000000088',1209499189,0),('er-3faBjY-hhlDcc5aKqdQ','AGRuD_tUqpjUhixhisn8rA','top_bg.jpg','PBtmpl0000000000000088',1209499189,0),('8bFsu2FJUqHRUiHcozcVFw','KQJheWAz7PTd1Gl194tzcg','sub-btn-l.jpg','PBtmpl0000000000000088',1209499189,0),('34Aayx5eA320D8VfhdfDBw','qx70ceBPO3mE5H_ZqhHa3A','sub-btn-r.jpg','PBtmpl0000000000000088',1209499189,0),('TlhKOVmWblZOsAdqmhEpeg','q9zSV7MQt6cwmXLWqoRCHQ','sub-btn.jpg','PBtmpl0000000000000088',1209499189,0),('Nx0ypjO3cN6QdZUBUEE0lA','UX3aGyzXzStKrn0BME9eSQ','pic-title-bg.jpg','PBtmpl0000000000000088',1209499189,0),('CmFZLN7iPS7XXvUEsxKPKA','3rRxsOMTV6hkG8TCywAxQg','row-2.jpg','PBtmpl0000000000000088',1209499190,0),('v_XBgwwZqgW1D5s4y05qfg','SHaZ0680E30gPydYkaxPPQ','addtl-info.gif','PBtmpl0000000000000088',1209499190,0),('4TdAkKoQbSCvI7QWcW889A','JsG1nDZj8IB7zdaEpqxljQ','row-1.jpg','PBtmpl0000000000000088',1209499190,0),('SAgK6eDPCG1cgkJ59WapHQ','blLNHs44P_vzBevRm3EKVg','prev-btn.gif','PBtmpl0000000000000088',1209499190,0),('XJYLuvGy9ubF7JNKyINtpA','7Fb1GdqH0E_1Or-ltSpW5Q','play-btn.gif','PBtmpl0000000000000088',1209499190,0),('RWj7hyv2SpZuXxwj1Wocug','WPuDj1dkyhluxUfsNHnPhg','next-btn.gif','PBtmpl0000000000000088',1209499190,0),('aq8QElnlm3YufAoxRz9Pcg','sDgpNdN1VdgPUQS6h57gVw','data-bg.jpg','PBtmpl0000000000000088',1209499190,0),('_bZJ9LA_KNekZiFPaP2SeQ','RwcPC6VO-WH3HPaMNxQdxQ','shelf-titles.jpg','PBtmpl0000000000000088',1210777868,0),('hQ7z33_jOYkQ8WNX5xy9Sw','HCc0_yDJrhZIoKV__wiUDw','style-button.gif','PBtmpl0000000000000088',1209509455,0),('vWW_DcHiYSrKZOkkIfEfcQ','t_FrH8_ktSJtHQGQLDeudA','row-2.jpg','PBtmpl0000000000000088',1209509433,0),('_bPYzRA87NTAUIKlfrJMHg','EgZoQgSAhCrNP3sXjRDPkw','row-1.jpg','PBtmpl0000000000000088',1209509433,0),('nJjZHRwdDs5MAZYsAyioHw','edb4FERsJ0pU0mmnfsiCig','title-bg.jpg','PBtmpl0000000000000088',1209509433,0),('8hxfkrJPeFVRWF5piCNJ1A','hRM4w6S2cqFdDRPcUP6FIg','field-bg.jpg','PBtmpl0000000000000088',1209509433,0),('Osx7WN52iIKHZFT4vqUBHQ','Wa42mXdBWCT9B9kgqzh9CQ','search-btn.gif','PBtmpl0000000000000088',1209509433,0),('oWff8fGzRdHPyq5VNREe9Q','j-AYUZHpCRd0yYH2Youp4A','top-bg.jpg','PBtmpl0000000000000088',1209509433,0),('uqbkvb1b9443VvfkyRz95w','JXBzB0XDxTHC_KRk0jROGQ','save-button.gif','PBtmpl0000000000000088',1209509433,0),('8YiMkcz32xalkAn3WBLpag','3lttrXIB4qCFnsKxFTJoKw','go-btn.gif','PBtmpl0000000000000088',1210181860,0),('2q5fxatSFLgIhXaUX-oSvg','j5rX358i5J9yPV4DoEHwxg','bottom-left.jpg','PBtmpl0000000000000088',1204149033,0),('_d5WTkKjnwct-_Dk7gZHvQ','tpvHAIwy2uRbYM8spLAfVA','bottom-right.jpg','PBtmpl0000000000000088',1204149033,0),('Iz2mUR3jCPKyemwAea4b2g','7wvz-X76oSFQc4y88amMIA','input_bg.jpg','PBtmpl0000000000000088',1204149033,0),('JU9bjsLRoWj7GVHs__prig','hT-SRTK5QszwKt9YV7bSDg','top-left.jpg','PBtmpl0000000000000088',1204149033,0),('noOlnjQGexHg8c4bGVUo9g','itESNdKblVlX-kLwnt3qVw','top-right.jpg','PBtmpl0000000000000088',1204149033,0),('7-0-style0000000000059','QOhEl8bdecbSrml06V84iw','main_top.jpg','PBtmpl0000000000000088',1213386091,0),('o_pq_e4vRyhMOKFzs61eag','zTRhj1ZmjPc6b4ytLNIdLg','book-covers.jpg','PBtmpl0000000000000088',1215714957,0),('hBpisL-_URyZnh9clR5ohA','IYUoN4EWQWHZHQj-f5ex0g','no_photo.gif','PBtmpl0000000000000088',1227634417,0),('FOBV6KkifreXa4GmEAUU4A','69Zh__B-EI01IWjf9KBDrw','no_photo_sm.gif','PBtmpl0000000000000088',1227634447,0);
INSERT INTO `Folder` VALUES ('PBasset000000000000002','PBtmpl0000000000000078',1124395696,3600,0,'ASC'),('7-0-style0000000000001','PBtmpl0000000000000078',1147642492,3600,0,'ASC'),('7-0-style0000000000031','PBtmpl0000000000000078',1147642500,3600,0,'ASC'),('PBasset000000000000003','PBtmpl0000000000000078',1147642437,3600,0,'ASC'),('nbSrhXZQuxIjhWFaFPSuVA','PBtmpl0000000000000078',1147642465,3600,0,'ASC'),('TvOZs8U1kRXLtwtmyW75pg','PBtmpl0000000000000078',1147642465,3600,0,'ASC'),('GNOAsX98vCsl0JRwfwL-gg','PBtmpl0000000000000078',1147642466,3600,0,'ASC'),('S1A9iAwKcQQ6P20uTqw-Ew','PBtmpl0000000000000078',1147642468,3600,0,'ASC'),('tXwf1zaOXTvsqPn6yu-GSw','PBtmpl0000000000000078',1147642469,3600,0,'ASC'),('GYaFxnMu9UsEG8oanwB6TA','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('N13SD1Fpqk00UgBt1Z8ivQ','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('tPagC0AQErZXjLFZQ6OI1g','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('-WM2dt0ZGpDasuL2wWocxg','PBtmpl0000000000000078',1222803056,3600,0,'ASC'),('3uuBf8cYuj1sew2OJXl9tg','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('2OcUWHVsu_L1sDFzIMWYqw','PBtmpl0000000000000078',1222803070,3600,0,'ASC'),('cj2y4papTVGZRFdwTI-_fw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('bBzO4CWjqU_ile3gf5Iypw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('BFfNj5wA9bDw8H3cnr8pTw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('jEz8iTGNWEt2I05IhVV19Q','PBtmpl0000000000000078',1147642477,3600,0,'ASC'),('VZK3CRgiMb8r4dBjUmCTgQ','PBtmpl0000000000000078',1147642477,3600,0,'ASC'),('f_tn9FfoSfKWX43F83v_3w','PBtmpl0000000000000078',1147642479,3600,0,'ASC'),('Da6KWn805L4B5e4HFgQRQA','PBtmpl0000000000000078',1147642479,3600,0,'ASC'),('bbiA9Zq5Gy2oCFBlILO3QA','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('Efe2W0UgrSRDltNJ87jlfg','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('RrV4aAPnn4dM0ZcU3OXnlw','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('oGfxez5sksyB_PcaAsEm_Q','PBtmpl0000000000000078',1147642482,3600,0,'ASC'),('9wKWdum0_8z-OhhquWLtSQ','PBtmpl0000000000000078',1147642483,3600,0,'ASC'),('CSN-ZON7Uwv8kxf3F1fh5Q','PBtmpl0000000000000078',1147642484,3600,0,'ASC'),('TCtybxdqmdwdvRn555zpCQ','PBtmpl0000000000000078',1147642484,3600,0,'ASC'),('tempspace0000000000000','PBtmpl0000000000000078',1185754574,3600,0,'ASC'),('kaPRSaf8UKiskiGEgJgLAw','PBtmpl0000000000000078',1197330678,3600,0,'ASC'),('Tsg7xmPYv782j6IVz7yHFg','PBtmpl0000000000000078',1213244777,3600,0,'ASC'),('-K8Hj45mbelljN9-0CXZxg','PBtmpl0000000000000078',1209325764,3600,0,'ASC'),('4qh0kIsFUdd4Ox-Iu1JZgg','PBtmpl0000000000000078',1208725439,3600,0,'ASC'),('aNNC62qLAS6TB-0_MCYjsw','PBtmpl0000000000000078',1213283425,3600,0,'ASC'),('TYo2Bwl7aafzTtdHlS-arQ','PBtmpl0000000000000078',1211664878,3600,0,'ASC'),('6tK47xsaIH-ELw0IBo0uRQ','PBtmpl0000000000000078',1210777115,3600,0,'ASC'),('gbnRhcWNk1iQe32LFEB5eQ','PBtmpl0000000000000078',1212086102,3600,0,'ASC'),('6D4Z-oruXPS6OlH_Kx8pBg','PBtmpl0000000000000078',1209509389,3600,0,'ASC'),('C5fPz-Wg85vkYRvCdl-Xqw','PBtmpl0000000000000078',1212160830,3600,0,'ASC'),('aNmgn0cd6tldmC1FpW4KbA','PBtmpl0000000000000078',1213122695,3600,0,'ASC'),('gI_TxK-5S4DNuv42wpImmw','PBtmpl0000000000000078',1213734379,3600,0,'ASC'),('jnYdqDkUR8x7Pv2eGR1qTA','PBtmpl0000000000000078',1216250666,3600,0,'ASC'),('1z9J1O08n_7gVVlBwSRBJQ','PBtmpl0000000000000078',1222803099,3600,0,'ASC'),('zyWi26q9na-iiZqL4yedog','PBtmpl0000000000000078',1222803114,3600,0,'ASC'),('tBL7BWiQRZFed2Y-Zjo9tQ','PBtmpl0000000000000078',1222803200,3600,0,'ASC'),('GdkQpvjRtJqtzOUbwIIQRA','PBtmpl0000000000000078',1222803205,3600,0,'ASC'),('tnc5iYyynX2hfdEs9D3P8w','PBtmpl0000000000000078',1222803213,3600,0,'ASC'),('vgXdBcFTqU7h4wBG1ewdBw','PBtmpl0000000000000078',1222803217,3600,0,'ASC'),('hcFlqnXlsmC1ujN6Id0F0A','PBtmpl0000000000000078',1222803234,3600,0,'ASC'),('eRJR52fvlaxfetv3DQkQYw','PBtmpl0000000000000078',1222803238,3600,0,'ASC'),('5HIDHq5lAWHV5gpYGS0zLg','PBtmpl0000000000000078',1222803244,3600,0,'ASC'),('rYEFwXXo0tkGhQTcbDibvg','PBtmpl0000000000000078',1222803249,3600,0,'ASC'),('V3l5S5TtI7wMm1WpIMhvOA','PBtmpl0000000000000078',1222803253,3600,0,'ASC'),('nqNbSUAhk9Vd1zda2SCz9A','PBtmpl0000000000000078',1222803258,3600,0,'ASC'),('y8XkRdxIperLKkJ3bL5sSQ','PBtmpl0000000000000078',1222803264,3600,0,'ASC'),('vTymIDYL2YqEh6PV50F7ew','PBtmpl0000000000000078',1222803302,3600,0,'ASC'),('lo1ac3BsoJx3ijGQ3gR-bQ','PBtmpl0000000000000078',1222803309,3600,0,'ASC'),('huASapWvFDzqwOSbcN-JFQ','PBtmpl0000000000000078',1222803313,3600,0,'ASC'),('9A-mg2gwWmaYi9o_1C7ArQ','PBtmpl0000000000000078',1222803338,3600,0,'ASC'),('yD1SMHelczihzjEmx6eXBA','PBtmpl0000000000000078',1222803342,3600,0,'ASC'),('pV7GnZdpjR3XpZaSINIoeg','PBtmpl0000000000000078',1222803347,3600,0,'ASC'),('71e17KeduiXgODLMlUxiow','PBtmpl0000000000000078',1222803352,3600,0,'ASC'),('xSmREZO3GNzK3M5PaueOOQ','PBtmpl0000000000000078',1222803378,3600,0,'ASC'),('0bx-xoL8TSXXubFuqKAoVQ','PBtmpl0000000000000078',1222803383,3600,0,'ASC'),('taX2UYkFF21ALpFZY2rhMw','PBtmpl0000000000000078',1222803387,3600,0,'ASC'),('K0q_N885Httqev1VCqUWxg','PBtmpl0000000000000078',1222803391,3600,0,'ASC'),('fq1ZkYhH24R5tb96kuT10Q','PBtmpl0000000000000078',1222803395,3600,0,'ASC'),('oHk7fAFhEEkB7dHzi0QOQA','PBtmpl0000000000000078',1222803399,3600,0,'ASC'),('9M-lrlPQWeeNWfvnDnK_Xg','PBtmpl0000000000000078',1222803405,3600,0,'ASC'),('_gBYAdTcbkiyamnqi2Xskg','PBtmpl0000000000000078',1222803409,3600,0,'ASC'),('Ik9HHky10DIyFTKehUD1dw','PBtmpl0000000000000078',1222803478,3600,0,'ASC'),('NywJYmGWe1f6EBXJnWg9Xg','PBtmpl0000000000000078',1222803638,3600,0,'ASC'),('AgyFhx3eXlfZXNp2MkrsiQ','PBtmpl0000000000000078',1222803665,3600,0,'ASC'),('F7MAQ-cpuvQ1KuC7J4P5zQ','PBtmpl0000000000000078',1222803673,3600,0,'ASC'),('Q4uX_C557arTp6D_jwB1jQ','PBtmpl0000000000000078',1222803760,3600,0,'ASC'),('BmLaN4rmAANkCglXUViEbg','PBtmpl0000000000000078',1222803871,3600,0,'ASC'),('X7DrzUcj8pOKFa_6k9D5iw','PBtmpl0000000000000078',1222804045,3600,0,'ASC'),('UL-ItI4L1Z6-WSuhuXVvsQ','PBtmpl0000000000000078',1225139673,3600,0,'ASC'),('7-0-style0000000000049','PBtmpl0000000000000078',1224117144,3600,0,'ASC'),('QpmlAiYZz6VsKBM-_0wXaw','PBtmpl0000000000000078',1224616691,3600,0,'ASC'),('HPDOcsj4gBme8D4svHodBw','PBtmpl0000000000000078',1225404573,3600,0,'ASC'),('IZkrow_zwvbf4FCH-taVTQ','PBtmpl0000000000000078',1226011853,3600,0,'ASC'),('K0YjxqOqr7RupSo6sIdcAg','PBtmpl0000000000000078',1227074310,3600,0,'ASC'),('_ilRXNR3s8F2vGJ_k9ePcg','PBtmpl0000000000000078',1226643205,3600,0,'ASC'),('AOjPG2NHgfL9Cq6dDJ7mew','PBtmpl0000000000000078',1226659753,3600,0,'ASC'),('qaVcU0FFzzraMX_bzELqzw','PBtmpl0000000000000078',1227074362,3600,0,'ASC'),('5bnNzteN7w3NnK9mF4XiCg','PBtmpl0000000000000078',1227540002,3600,0,'ASC'),('LdiozcIUciWuvt3Z-na5Ww','PBtmpl0000000000000078',1232673968,3600,0,'ASC'),('QHn6T9rU7KsnS3Y70KCNTg','PBtmpl0000000000000078',1233173545,3600,0,'ASC'),('HW-sPoDDZR8wBZ0YgFgPtg','PBtmpl0000000000000078',1227634350,3600,0,'ASC');
INSERT INTO `ImageAsset` VALUES ('7-0-style0000000000002',50,NULL,1147642492),('7-0-style0000000000004',50,NULL,1147642493),('7-0-style0000000000005',50,NULL,1147642493),('7-0-style0000000000006',50,NULL,1147642493),('7-0-style0000000000007',50,NULL,1147642493),('7-0-style0000000000008',50,NULL,1147642494),('7-0-style0000000000009',50,NULL,1147642494),('7-0-style0000000000010',50,NULL,1147642494),('7-0-style0000000000011',50,NULL,1147642495),('7-0-style0000000000012',50,NULL,1147642495),('7-0-style0000000000013',50,NULL,1147642495),('7-0-style0000000000014',50,NULL,1147642495),('7-0-style0000000000015',50,NULL,1147642496),('7-0-style0000000000016',50,NULL,1147642496),('7-0-style0000000000017',50,NULL,1147642496),('7-0-style0000000000018',50,NULL,1147642496),('7-0-style0000000000019',50,NULL,1147642497),('7-0-style0000000000020',50,NULL,1147642497),('7-0-style0000000000021',50,NULL,1147642497),('7-0-style0000000000022',50,NULL,1147642497),('7-0-style0000000000023',50,NULL,1147642498),('7-0-style0000000000024',50,NULL,1147642498),('7-0-style0000000000030',50,NULL,1147642499),('7-0-style0000000000032',50,NULL,1147642500),('7-0-style0000000000034',50,NULL,1147642500),('7-0-style0000000000035',50,NULL,1147642501),('7-0-style0000000000036',50,NULL,1147642501),('7-0-style0000000000037',50,NULL,1147642501),('7-0-style0000000000038',50,NULL,1147642501),('7-0-style0000000000039',50,NULL,1147642502),('7-0-style0000000000040',50,NULL,1147642502),('7-0-style0000000000041',50,NULL,1147642502),('7-0-style0000000000042',50,NULL,1147642502),('7-0-style0000000000043',50,NULL,1147642503),('7-0-style0000000000044',50,NULL,1147642503),('7-0-style0000000000045',50,NULL,1147642503),('7-0-style0000000000046',50,NULL,1147642504),('7-0-style0000000000048',50,NULL,1147642504),('7-0-style0000000000052',50,'style=\"border-style:none;\"',1147642505),('7-0-style0000000000053',50,'style=\"border-style:none;\"',1147642505),('7-0-style0000000000054',50,'style=\"border-style:none;\"',1147642506),('7-0-style0000000000055',50,'style=\"border-style:none;\"',1147642506),('7-0-style0000000000056',50,'style=\"border-style:none;\"',1147642506),('7-0-style0000000000057',50,'style=\"border-style:none;\"',1147642507),('7-0-style0000000000058',50,'style=\"border-style:none;\"',1147642507),('7-0-style0000000000060',50,'style=\"border-style:none;\"',1147642508),('7-0-style0000000000061',50,'style=\"border-style:none;\"',1147642508),('7-0-style0000000000062',50,'style=\"border-style:none;\"',1147642508),('7-0-style0000000000063',50,'style=\"border-style:none;\"',1147642508),('7-0-style0000000000064',50,'style=\"border-style:none;\"',1147642509),('7-0-style0000000000065',50,'style=\"border-style:none;\"',1147642509),('7-0-style0000000000066',50,'style=\"border-style:none;\"',1147642509),('7-0-style0000000000067',50,'style=\"border-style:none;\"',1147642509),('7-0-style0000000000068',50,'style=\"border-style:none;\"',1147642510),('7-0-style0000000000071',50,'style=\"border-style:none;\"',1147642511),('bANo8aiAPA7aY_oQZKxIWw',50,'style=\"border-style:none;\" alt=\"rss.gif\"',1197330678),('fdd8tGExyVwHyrB8RBbKXg',50,'style=\"border-style:none;\" alt=\"next.gif\"',1197330839),('BpisgHl4ZDcSECJp6oib1w',50,'style=\"border-style:none;\" alt=\"play.gif\"',1197330840),('zshreRgPAXtnF0DtVbQ1Yg',50,'style=\"border-style:none;\" alt=\"previous.gif\"',1197330840),('2ci_v2d4x4uvyjTRlC49OA',50,'style=\"border-style:none;\" alt=\"moveDown.gif\"',1209499188),('O-EsSzKgAk1KolFT-x_KsA',50,'style=\"border-style:none;\" alt=\"moveUp.gif\"',1209499188),('POVcY79vIqAHR8OfGt36aw',50,'style=\"border-style:none;\" alt=\"pagination_button.jpg\"',1209499189),('hIB-z34r8Xl-vYVYCkKr-w',50,'style=\"border-style:none;\" alt=\"bar-btn-r.jpg\"',1209499189),('-mPUoFlYcjqjPUPRLAlxNQ',50,'style=\"border-style:none;\" alt=\"search-field-r.jpg\"',1209499189),('MDpUOR-N8KMyt1J7Hh_h4w',50,'style=\"border-style:none;\" alt=\"bar-btn.jpg\"',1209499189),('YfXKByTwDZVituMc4h13Dg',50,'style=\"border-style:none;\" alt=\"pagination_bg.jpg\"',1209499189),('esko_HSU0Gh-uJZ1h3xRmQ',50,'style=\"border-style:none;\" alt=\"search-field-l.jpg\"',1209499189),('oSqpGswzpBG_ErdfYwIO8A',50,'style=\"border-style:none;\" alt=\"top_bg.jpg\"',1209499189),('MXJklShZvLLB_DSnZQmXrQ',50,'style=\"border-style:none;\" alt=\"title_bg.jpg\"',1209499189),('BthxD5oJ0idmsyI3ioA2FA',50,'style=\"border-style:none;\" alt=\"bar-btn-l.jpg\"',1209499189),('aZ-1HYQamkRHYXvzAra8WQ',50,'style=\"border-style:none;\" alt=\"search-field.jpg\"',1209499189),('eRkb94OYcS5AdcrrerOP5Q',50,'style=\"border-style:none;\" alt=\"rss.gif\"',1209499189),('TbnkjAJQEASORXIpYqDkcA',50,'style=\"border-style:none;\" alt=\"blank-image.jpg\"',1209499189),('er-3faBjY-hhlDcc5aKqdQ',50,'style=\"border-style:none;\" alt=\"top_bg.jpg\"',1209499189),('8bFsu2FJUqHRUiHcozcVFw',50,'style=\"border-style:none;\" alt=\"sub-btn-l.jpg\"',1209499189),('34Aayx5eA320D8VfhdfDBw',50,'style=\"border-style:none;\" alt=\"sub-btn-r.jpg\"',1209499189),('TlhKOVmWblZOsAdqmhEpeg',50,'style=\"border-style:none;\" alt=\"sub-btn.jpg\"',1209499189),('Nx0ypjO3cN6QdZUBUEE0lA',50,'style=\"border-style:none;\" alt=\"pic-title-bg.jpg\"',1209499189),('CmFZLN7iPS7XXvUEsxKPKA',50,'style=\"border-style:none;\" alt=\"row-2.jpg\"',1209499190),('v_XBgwwZqgW1D5s4y05qfg',50,'style=\"border-style:none;\" alt=\"addtl-info.gif\"',1209499190),('4TdAkKoQbSCvI7QWcW889A',50,'style=\"border-style:none;\" alt=\"row-1.jpg\"',1209499190),('SAgK6eDPCG1cgkJ59WapHQ',50,'style=\"border-style:none;\" alt=\"prev-btn.gif\"',1209499190),('XJYLuvGy9ubF7JNKyINtpA',50,'style=\"border-style:none;\" alt=\"play-btn.gif\"',1209499190),('RWj7hyv2SpZuXxwj1Wocug',50,'style=\"border-style:none;\" alt=\"next-btn.gif\"',1209499190),('aq8QElnlm3YufAoxRz9Pcg',50,'style=\"border-style:none;\" alt=\"data-bg.jpg\"',1209499190),('_bZJ9LA_KNekZiFPaP2SeQ',50,'style=\"border-style:none;\" alt=\"shelf-titles.jpg\"',1210777868),('hQ7z33_jOYkQ8WNX5xy9Sw',50,'style=\"border-style:none;\" alt=\"style-button.gif\"',1209509455),('vWW_DcHiYSrKZOkkIfEfcQ',50,'style=\"border-style:none;\" alt=\"row-2.jpg\"',1209509433),('_bPYzRA87NTAUIKlfrJMHg',50,'style=\"border-style:none;\" alt=\"row-1.jpg\"',1209509433),('nJjZHRwdDs5MAZYsAyioHw',50,'style=\"border-style:none;\" alt=\"title-bg.jpg\"',1209509433),('8hxfkrJPeFVRWF5piCNJ1A',50,'style=\"border-style:none;\" alt=\"field-bg.jpg\"',1209509433),('Osx7WN52iIKHZFT4vqUBHQ',50,'style=\"border-style:none;\" alt=\"search-btn.gif\"',1209509433),('oWff8fGzRdHPyq5VNREe9Q',50,'style=\"border-style:none;\" alt=\"top-bg.jpg\"',1209509433),('uqbkvb1b9443VvfkyRz95w',50,'style=\"border-style:none;\" alt=\"save-button.gif\"',1209509433),('8YiMkcz32xalkAn3WBLpag',50,'style=\"border-style:none;\" alt=\"go-btn.gif\"',1210181860),('2q5fxatSFLgIhXaUX-oSvg',50,'style=\"border-style:none;\" alt=\"bottom-left.jpg\"',1204149033),('_d5WTkKjnwct-_Dk7gZHvQ',50,'style=\"border-style:none;\" alt=\"bottom-right.jpg\"',1204149033),('Iz2mUR3jCPKyemwAea4b2g',50,'style=\"border-style:none;\" alt=\"input_bg.jpg\"',1204149033),('JU9bjsLRoWj7GVHs__prig',50,'style=\"border-style:none;\" alt=\"top-left.jpg\"',1204149033),('noOlnjQGexHg8c4bGVUo9g',50,'style=\"border-style:none;\" alt=\"top-right.jpg\"',1204149033),('7-0-style0000000000059',50,'alt=\"main_top.jpg\"',1213386091),('o_pq_e4vRyhMOKFzs61eag',50,'style=\"border-style:none;\" alt=\"book-covers.jpg\"',1215714957),('hBpisL-_URyZnh9clR5ohA',50,'style=\"border-style:none;\" alt=\"no_photo.gif\"',1227634417),('FOBV6KkifreXa4GmEAUU4A',50,'style=\"border-style:none;\" alt=\"no_photo_sm.gif\"',1227634447);
INSERT INTO `Layout` VALUES ('68sKwDgf9cGH58-NZcU4lg','PBtmpl0000000000000054','TKzUMeIxRLrZ3NAEez6CXQ,sWVXMZGibxHe2Ekj1DCldA',NULL,1124395696,'asc'),('_iHetEvMQUOoxS-T2CM0sQ','PBtmpl0000000000000054','x_WjMvFmilhX-jvZuIpinw',NULL,1124395696,'asc'),('8Bb8gu-me2mhL3ljFyiWLg','PBtmpl0000000000000094','6QuS-0rosuZTdTv11fobig.FOvmwGC0GtZo5VTxJIL3OA,ix1p0AbwKAz8QWB-T-HHfg,iCYOjohB9SKvAPr6bXElKA.4Yfz9hqBqM8OYMGuQK8oLw,Wl8WZ43g2rK5AYr9o4zY7w,LBuiKzg2mWwmOPS9AgV3bg,jTNggl7AoVSUc_ZzrvuCmw.',NULL,1124395696,'asc'),('2TqQc4OISddWCZmRY1_m8A','PBtmpl0000000000000054','fK-HMSboA3uu0c1KYkYspA',NULL,1124395696,'asc'),('Swf6L8poXKc7hUaNPkBevw','PBtmpl0000000000000054','Szs5eev3OMssmnsyLRZmWA',NULL,1124395696,'asc'),('x3OFY6OJh_qsXkZfPwug4A','PBtmpl0000000000000054','pJd5TLAjfWMVXD6sCRLwUg',NULL,1124395696,'asc'),('mTOiwwk3q4k9g5-XykXhPA','PBtmpl0000000000000054','diZvW4bSgZWwyyGP3qXi1g,o_pq_e4vRyhMOKFzs61eag,j_1qEqM6iLfQLiR6VKy0aA',NULL,1218149728,'asc');
INSERT INTO `Navigation` VALUES ('pJd5TLAjfWMVXD6sCRLwUg','descendants','specificUrl','root',55,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000001','self\nancestors','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000093',55,1124395696,'text/html',0),('PBnav00000000000000014','pedigree','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000015','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000016','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000017','self\nsiblings','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000018','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000019','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000020','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000021','descendants','specificUrl','home',3,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000002','descendants','specificUrl','home',3,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000006','descendants','specificUrl','home',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000007','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000048',55,1124395696,'text/html',0),('PBnav00000000000000008','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000009','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000124',55,1124395696,'text/html',0),('PBnav00000000000000010',NULL,'relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000011','self\ndescendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000130',55,1124395696,'text/html',0),('PBnav00000000000000012','descendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000134',55,1124395696,'text/html',0),('PBnav00000000000000013','self\ndescendants','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000136',55,1124395696,'text/html',0),('7-0-style0000000000025','descendants','relativeToRoot','1',1,0,0,0,'stevenav00000000000001',55,1147642498,'text/html',0),('7-0-style0000000000026','descendants','relativeToRoot','2',1,0,0,0,'PBnav000000style01lvl2',55,1147642499,'text/html',0),('7-0-style0000000000070','descendants','relativeToRoot','1',55,0,0,0,'stevecoolmenu000000001',55,1147642510,'text/html',0),('jVKLVakT_iA2010_oEuAwg','self\ndescendants','specificUrl','department',1,0,0,0,'stevecoolmenu000000001',55,1224116526,'text/html',0),('Vch1Ww7G_JpBhOhXX07RDg','ancestors','relativeToCurrentUrl','0',55,0,1,0,'alraubvBu-YJJ614jAHD5w',1,1235705952,'text/html',0);
INSERT INTO `RSSCapable` VALUES ('pbproto000000000000002',1163019036,0,'PBtmpl0000000000000142',NULL);
INSERT INTO `RichEdit` VALUES ('PBrichedit000000000002',0,0,0,0,0,0,0,0,0,0,'ltr','bottom',NULL,'a[name|href|target|title],strong/b[class],em/i[class],strike[class],u[class],p[dir|class|align],ol,ul,li,br,img[class|src|border=0|alt|title|hspace|vspace|width|height|align],sub,sup,blockquote[dir|style],table[border=0|cellspacing|cellpadding|width|height|class|align],tr[class|rowspan|width|height|align|valign],td[dir|class|colspan|rowspan|width|height|align|valign],div[dir|class|align],span[class|align],pre[class|align],address[class|align],h1[dir|class|align],h2[dir|class|align],h3[dir|class|align],h4[dir|class|align],h5[dir|class|align],h6[dir|class|align],hr','bold\nitalic\nbullist\nnumlist\nlink\nunlink\nemotions',NULL,NULL,0,1124395696,0,0,NULL),('PBrichedit000000000001',0,0,0,0,600,500,0,0,0,0,'ltr','bottom',NULL,'*[*]','bold\nitalic\njustifyleft\njustifyright\njustifycenter\njustifyfull\nindent\noutdent\nsub\nsup\nformatselect\nremoveformat','bullist\nnumlist\nlink\nwgpagetree\nanchor\nunlink\nadvhr\nimage\nwginsertimage\ncharmap\nwgmacro','tablecontrols\nvisualaid\npreview\ncode\ncleanup\nreplace',1,1207240829,0,0,NULL);
INSERT INTO `SyndicatedContent` VALUES ('http://www.plainblack.com/news/news?func=viewRSS',3,'fK-HMSboA3uu0c1KYkYspA','GNvjCFQWjY2AF2uf0aCM8Q',1124395696,'',3600,0);
INSERT INTO `Workflow` VALUES ('pbworkflow000000000001','Daily Maintenance Tasks','This workflow runs daily maintenance tasks such as cleaning up old temporary files and cache.',1,'None','singleton'),('pbworkflow000000000002','Weekly Maintenance Tasks','This workflow runs once per week to perform maintenance tasks like cleaning up log files.',1,'None','singleton'),('pbworkflow000000000004','Hourly Maintenance Tasks','This workflow runs once per hour to perform maintenance tasks like deleting expired user sessions.',1,'None','singleton'),('pbworkflow000000000003','Commit Without Approval','This workflow commits all the assets in this version tag without asking for any approval.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000005','Commit With Approval','This workflow commits all the assets in this version tag after getting approval from content managers.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000006','Unlock Version Tag and Notify Owner','This workflow is used when a version tag approval is denied. It unlocks the version tag, making it available for editing, and notifies the tag owner.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000007','Send Queued Email Messages','Sends all the messages in the mail queue.',1,'None','singleton'),('csworkflow000000000001','Get CS Mail','Retrieves mail from a POP3 account for the given Collaboration System.',1,'WebGUI::Asset::Wobject::Collaboration','singleton'),('AuthLDAPworkflow000001','Synchronize Profile To LDAP','Synchronizes a users LDAP information to their WebGUI User Profile',1,'WebGUI::User','singleton'),('DPWwf20061030000000002','Delete Exported Files','Deletes exported files from an asset being deleted or moved.',1,'None','parallel');
INSERT INTO `WorkflowActivity` VALUES ('pbwfactivity0000000001','pbworkflow000000000001','Delete temp files older than 24 hours',NULL,1,'WebGUI::Workflow::Activity::CleanTempStorage'),('pbwfactivity0000000002','pbworkflow000000000001','Prune file cache larger than 100MB',NULL,3,'WebGUI::Workflow::Activity::CleanFileCache'),('pbwfactivity0000000022','pbworkflow000000000001','Prune database cache larger than 100MB',NULL,4,'WebGUI::Workflow::Activity::CleanDatabaseCache'),('pbwfactivity0000000005','pbworkflow000000000001','Archive old CS threads',NULL,5,'WebGUI::Workflow::Activity::ArchiveOldThreads'),('vtagactivity0000000002','pbworkflow000000000003','Wait Until','This workflow waits until the value chosen in the \"Wait Until\" field has passed and then continues',1,'WebGUI::Workflow::Activity::WaitUntil'),('pbwfactivity0000000007','pbworkflow000000000001','deal with user groupings that have expired',NULL,6,'WebGUI::Workflow::Activity::ExpireGroupings'),('pbwfactivity0000000011','pbworkflow000000000001','Expire old subscription codes',NULL,7,'WebGUI::Workflow::Activity::ExpireSubscriptionCodes'),('pbwfactivity0000000014','pbworkflow000000000001','Summarize Passive Profiling Data',NULL,8,'WebGUI::Workflow::Activity::SummarizePassiveProfileLog'),('pbwfactivity0000000015','pbworkflow000000000001','Sync User Profiles With LDAP',NULL,9,'WebGUI::Workflow::Activity::SyncProfilesToLdap'),('pbwfactivity0000000003','pbworkflow000000000002','Delete login entries older than 90 days',NULL,1,'WebGUI::Workflow::Activity::CleanLoginHistory'),('pbwfactivity0000000004','pbworkflow000000000002','Move clipboard items older than 30 days to trash',NULL,2,'WebGUI::Workflow::Activity::TrashClipboard'),('pbwfactivity0000000008','pbworkflow000000000002','delete asset revisions older than a year from the database',NULL,3,'WebGUI::Workflow::Activity::PurgeOldAssetRevisions'),('pbwfactivity0000000010','pbworkflow000000000002','delete assets from trash that have been sitting around for 30 days',NULL,4,'WebGUI::Workflow::Activity::PurgeOldTrash'),('pbwfactivity0000000009','pbworkflow000000000004','delete expired sessions',NULL,1,'WebGUI::Workflow::Activity::DeleteExpiredSessions'),('pbwfactivity0000000012','pbworkflow000000000004','Get syndicated content',NULL,2,'WebGUI::Workflow::Activity::GetSyndicatedContent'),('vtagactivity0000000001','pbworkflow000000000005','Wait Until','This workflow waits until the value chosen in the \"Wait Until\" field has passed and then continues',2,'WebGUI::Workflow::Activity::WaitUntil'),('pbwfactivity0000000017','pbworkflow000000000005','Get Approval from Content Managers',NULL,1,'WebGUI::Workflow::Activity::RequestApprovalForVersionTag'),('pbwfactivity0000000019','pbworkflow000000000006','Unlock Version Tag',NULL,1,'WebGUI::Workflow::Activity::UnlockVersionTag'),('pbwfactivity0000000020','pbworkflow000000000006','Notify Committer of Denial',NULL,2,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('pbwfactivity0000000021','pbworkflow000000000007','Send Queued Messages',NULL,1,'WebGUI::Workflow::Activity::SendQueuedMailMessages'),('csactivity000000000001','csworkflow000000000001','Get the mail',NULL,1,'WebGUI::Workflow::Activity::GetCsMail'),('Dl_3P-4y1OoOTf3cRwQ7EA','AuthLDAPworkflow000001','Synchronize Profile To LDAP',NULL,1,'WebGUI::Workflow::Activity::SyncProfileToLdap'),('DPWwfa2006103000000002','DPWwf20061030000000002','Delete Exported Files',NULL,1,'WebGUI::Workflow::Activity::DeleteExportedFiles'),('SWHs3shndnc8LuLpmLeeNw','pbworkflow000000000004','Update Calendar Feeds','This activity imports calendar events from calendar feeds',3,'WebGUI::Workflow::Activity::CalendarUpdateFeeds'),('pbwfactivity0000000006','pbworkflow000000000003','Commit Assets',NULL,2,'WebGUI::Workflow::Activity::CommitVersionTag'),('newslettersendactivity','pbworkflow000000000002','Send Newsletters For Newsletter Assets',NULL,5,'WebGUI::Workflow::Activity::SendNewsletters'),('unansweredfriends_____','pbworkflow000000000001','Deny Friend Requests Older Than A Month',NULL,10,'WebGUI::Workflow::Activity::DenyUnansweredFriends'),('pbwfactivity0000000016','pbworkflow000000000005','Commit Assets',NULL,3,'WebGUI::Workflow::Activity::CommitVersionTag'),('pbwfactivity0000000018','pbworkflow000000000005','Notify Committer of Approval',NULL,4,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('Wc6a97RjonqdFdP69tAKWg','pbworkflow000000000001','Remove old carts',NULL,11,'WebGUI::Workflow::Activity::RemoveOldCarts');
INSERT INTO `WorkflowActivityData` VALUES ('pbwfactivity0000000001','storageTimeout','86400'),('pbwfactivity0000000002','sizeLimit','1000000000'),('pbwfactivity0000000022','sizeLimit','1000000000'),('vtagactivity0000000002','type','startTime'),('pbwfactivity0000000003','ageToDelete','7776000'),('pbwfactivity0000000004','trashAfter','2592000'),('pbwfactivity0000000008','purgeAfter','31536000'),('pbwfactivity0000000010','purgeAfter','2592000'),('vtagactivity0000000001','type','startTime'),('pbwfactivity0000000017','message','A new version tag awaits your approval.'),('pbwfactivity0000000017','doOnDeny','pbworkflow000000000006'),('pbwfactivity0000000017','groupToApprove','4'),('pbwfactivity0000000020','message','Your version tag was denied. Please take corrective actions and recommit your changes.'),('pbwfactivity0000000020','who','committer'),('unansweredfriends_____','timeout','2592000'),('pbwfactivity0000000006','trashAfter','2592000'),('pbwfactivity0000000018','who','committer'),('pbwfactivity0000000018','message','Your version tag was approved.');
INSERT INTO `WorkflowSchedule` VALUES ('pbcron0000000000000001','Daily Maintenance',1,0,'30','23','*','*','*','pbworkflow000000000001',NULL,NULL,3,NULL),('pbcron0000000000000002','Weekly Maintenance',1,0,'30','1','*','*','0','pbworkflow000000000002',NULL,NULL,3,NULL),('pbcron0000000000000003','Hourly Maintenance',1,0,'15','*','*','*','*','pbworkflow000000000004',NULL,NULL,3,NULL),('pbcron0000000000000004','Send Queued Email Messages Every 5 Minutes',1,0,'*/5','*','*','*','*','pbworkflow000000000007',NULL,NULL,3,NULL),('NpRVTSR-NX2sD52LUc520A','Request Tracker Mail',0,0,'*/5','*','*','*','*','csworkflow000000000001','WebGUI::Asset::Wobject::Collaboration','new',2,'{\n    \"parameters\" : \"pbproto000000000000002\"\n}');
INSERT INTO `asset` VALUES ('PBasset000000000000001','infinity','000001','published','WebGUI::Asset',1124395696,'3','997995720','3',NULL,1,NULL),('PBasset000000000000002','PBasset000000000000001','000001000001','published','WebGUI::Asset::Wobject::Folder',1124395696,'3','997995720','3',NULL,1,NULL),('68sKwDgf9cGH58-NZcU4lg','PBasset000000000000001','000001000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('iCYOjohB9SKvAPr6bXElKA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000004','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('ix1p0AbwKAz8QWB-T-HHfg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000003','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('_iHetEvMQUOoxS-T2CM0sQ','68sKwDgf9cGH58-NZcU4lg','000001000002000001','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('FOvmwGC0GtZo5VTxJIL3OA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000002','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('8Bb8gu-me2mhL3ljFyiWLg','68sKwDgf9cGH58-NZcU4lg','000001000002000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('m4YJFaqzultnB_sj1Uq0aw','68sKwDgf9cGH58-NZcU4lg','000001000002000008','published','WebGUI::Asset::File',1147642514,'3','997995720','3',NULL,0,NULL),('IWFxZDyGhQ3-SLZhELa3qw','68sKwDgf9cGH58-NZcU4lg','000001000002000009','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('bX5rYxb6tZ9docY6sUhBlw','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000001','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('Vzv1pWpg_w6R_o-b0rM2qQ','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000002','published','WebGUI::Asset::File',1147642515,'3','997995720','3',NULL,0,NULL),('NK8bqlwVRILJknqeCDPBHg','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000003','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('6QuS-0rosuZTdTv11fobig','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000001','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('2TqQc4OISddWCZmRY1_m8A','68sKwDgf9cGH58-NZcU4lg','000001000002000003','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('fK-HMSboA3uu0c1KYkYspA','2TqQc4OISddWCZmRY1_m8A','000001000002000003000001','published','WebGUI::Asset::Wobject::SyndicatedContent',1124395696,'3','997995720','3',NULL,0,NULL),('Swf6L8poXKc7hUaNPkBevw','68sKwDgf9cGH58-NZcU4lg','000001000002000004','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('Szs5eev3OMssmnsyLRZmWA','Swf6L8poXKc7hUaNPkBevw','000001000002000004000001','published','WebGUI::Asset::Wobject::DataForm',1124395696,'3','997995720','3',NULL,0,NULL),('x3OFY6OJh_qsXkZfPwug4A','68sKwDgf9cGH58-NZcU4lg','000001000002000006','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('pJd5TLAjfWMVXD6sCRLwUg','x3OFY6OJh_qsXkZfPwug4A','000001000002000006000001','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000003','7-0-style0000000000001','000001000001000045000002','published','WebGUI::Asset::Snippet',1147642492,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000001','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000009','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000014','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000010','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000015','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000011','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000016','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000012','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000017','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000013','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000018','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000014','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000019','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000015','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000020','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000016','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000021','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000017','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000002','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000018','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000006','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000019','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000007','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000020','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000008','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000021','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000009','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000022','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000010','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000023','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000011','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000024','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000012','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000025','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000013','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000026','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('Wl8WZ43g2rK5AYr9o4zY7w','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000006','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('4Yfz9hqBqM8OYMGuQK8oLw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000005','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000005','7-0-style0000000000001','000001000001000045000004','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000006','7-0-style0000000000001','000001000001000045000005','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000103','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000084','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000002','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000115','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000066','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000080','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000097','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000112','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000121','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000067','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000026','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000128','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000079','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000009','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000083','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000010','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000082','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000011','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000056','TYo2Bwl7aafzTtdHlS-arQ','000001000001000025000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000135','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000131','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000054','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000024','tXwf1zaOXTvsqPn6yu-GSw','000001000001000011000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000088','tPagC0AQErZXjLFZQ6OI1g','000001000001000015000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000078','GYaFxnMu9UsEG8oanwB6TA','000001000001000012000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000125','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000118','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000109','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000094','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000133','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000012','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000065','oGfxez5sksyB_PcaAsEm_Q','000001000001000040000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000055','VZK3CRgiMb8r4dBjUmCTgQ','000001000001000024000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000020','-K8Hj45mbelljN9-0CXZxg','000001000001000008000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000085','-K8Hj45mbelljN9-0CXZxg','000001000001000008000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000104','-K8Hj45mbelljN9-0CXZxg','000001000001000008000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000021','-K8Hj45mbelljN9-0CXZxg','000001000001000008000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000033','N13SD1Fpqk00UgBt1Z8ivQ','000001000001000014000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000047','cj2y4papTVGZRFdwTI-_fw','000001000001000020000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000029','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000013','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000032','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000014','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000027','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000015','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000031','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000016','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('jTNggl7AoVSUc_ZzrvuCmw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000008','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('LBuiKzg2mWwmOPS9AgV3bg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000007','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('GNvjCFQWjY2AF2uf0aCM8Q','oGfxez5sksyB_PcaAsEm_Q','000001000001000040000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000068','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000017','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000099','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000018','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000114','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000019','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000092','V3l5S5TtI7wMm1WpIMhvOA','000001000001000018000009000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000044','V3l5S5TtI7wMm1WpIMhvOA','000001000001000018000009000002','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000059','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000036000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('IZkrow_zwvbf4FCH-taVTQ','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000002','published','WebGUI::Asset::Wobject::Folder',1226011853,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000207','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000007','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('QHn6T9rU7KsnS3Y70KCNTg','PBasset000000000000002','000001000001000001','published','WebGUI::Asset::Wobject::Folder',1227080251,'3','997995720','3',NULL,0,NULL),('HPDOcsj4gBme8D4svHodBw','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000001','published','WebGUI::Asset::Wobject::Folder',1225404573,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000002','TCtybxdqmdwdvRn555zpCQ','000001000001000030000002','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000063','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000062','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000061','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000064','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000116','-K8Hj45mbelljN9-0CXZxg','000001000001000008000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000007','7-0-style0000000000001','000001000001000045000006','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000093','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000048','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000108','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000117','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000124','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000130','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000134','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000077','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000020','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000098','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000021','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000122','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000022','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000136','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000013','9M-lrlPQWeeNWfvnDnK_Xg','000001000001000004000007000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000010','K0q_N885Httqev1VCqUWxg','000001000001000004000004000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000011','fq1ZkYhH24R5tb96kuT10Q','000001000001000004000005000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000014','_gBYAdTcbkiyamnqi2Xskg','000001000001000004000008000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000012','oHk7fAFhEEkB7dHzi0QOQA','000001000001000004000006000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000006','taX2UYkFF21ALpFZY2rhMw','000001000001000004000003000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000004','xSmREZO3GNzK3M5PaueOOQ','000001000001000004000001000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000005','0bx-xoL8TSXXubFuqKAoVQ','000001000001000004000002000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000057','Ik9HHky10DIyFTKehUD1dw','000001000001000028000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000060','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000038000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('pbrobot000000000000001','PBasset000000000000002','000001000001000031','published','WebGUI::Asset::Snippet',1147642511,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000111','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000038000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000137','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000038000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000132','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000038000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000123','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000129','TvOZs8U1kRXLtwtmyW75pg','000001000001000003000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000081','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000023','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000101','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000024','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000065','7-0-style0000000000049','000001000001000047000016','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('OhdaFLE7sXOzo_SIP2ZUgA','68sKwDgf9cGH58-NZcU4lg','000001000002000007','published','WebGUI::Asset::Wobject::Article',1147642513,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000113','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000025','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000037','GdkQpvjRtJqtzOUbwIIQRA','000001000001000018000002000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000038','tnc5iYyynX2hfdEs9D3P8w','000001000001000018000003000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000036','tBL7BWiQRZFed2Y-Zjo9tQ','000001000001000018000001000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000039','vgXdBcFTqU7h4wBG1ewdBw','000001000001000018000004000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000091','vgXdBcFTqU7h4wBG1ewdBw','000001000001000018000004000002','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000107','vgXdBcFTqU7h4wBG1ewdBw','000001000001000018000004000003','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000040','hcFlqnXlsmC1ujN6Id0F0A','000001000001000018000005000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000041','eRJR52fvlaxfetv3DQkQYw','000001000001000018000006000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000042','5HIDHq5lAWHV5gpYGS0zLg','000001000001000018000007000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000045','y8XkRdxIperLKkJ3bL5sSQ','000001000001000018000011000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000043','rYEFwXXo0tkGhQTcbDibvg','000001000001000018000008000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('7-0-style0000000000064','7-0-style0000000000049','000001000001000047000015','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000001','TCtybxdqmdwdvRn555zpCQ','000001000001000030000001','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000053','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000017','published','WebGUI::Asset::Template',1124395696,'3','1222802960','3',NULL,0,NULL),('PBtmpl0000000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000002000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000140','Da6KWn805L4B5e4HFgQRQA','000001000001000035000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000141','-K8Hj45mbelljN9-0CXZxg','000001000001000008000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000066','7-0-style0000000000049','000001000001000047000017','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000062','7-0-style0000000000049','000001000001000047000013','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000060','7-0-style0000000000049','000001000001000047000011','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000061','7-0-style0000000000049','000001000001000047000012','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000057','7-0-style0000000000049','000001000001000047000008','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000058','7-0-style0000000000049','000001000001000047000009','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000059','7-0-style0000000000049','000001000001000047000010','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000056','7-0-style0000000000049','000001000001000047000007','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000052','7-0-style0000000000049','000001000001000047000003','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000053','7-0-style0000000000049','000001000001000047000004','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000054','7-0-style0000000000049','000001000001000047000005','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000055','7-0-style0000000000049','000001000001000047000006','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('stevecoolmenu000000001','7-0-style0000000000049','000001000001000047000001','published','WebGUI::Asset::Template',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000051','7-0-style0000000000049','000001000001000047000002','published','WebGUI::Asset::Snippet',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000049','PBasset000000000000002','000001000001000047','published','WebGUI::Asset::Wobject::Folder',1147642504,'3','997995720','3',NULL,0,NULL),('stevestyle000000000002','7-0-style0000000000031','000001000001000046000016','published','WebGUI::Asset::Template',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000048','7-0-style0000000000031','000001000001000046000017','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000046','7-0-style0000000000031','000001000001000046000015','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000044','7-0-style0000000000031','000001000001000046000013','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000045','7-0-style0000000000031','000001000001000046000014','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000043','7-0-style0000000000031','000001000001000046000012','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000041','7-0-style0000000000031','000001000001000046000010','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000042','7-0-style0000000000031','000001000001000046000011','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000038','7-0-style0000000000031','000001000001000046000007','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000039','7-0-style0000000000031','000001000001000046000008','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000040','7-0-style0000000000031','000001000001000046000009','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000036','7-0-style0000000000031','000001000001000046000005','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000037','7-0-style0000000000031','000001000001000046000006','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000034','7-0-style0000000000031','000001000001000046000003','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000035','7-0-style0000000000031','000001000001000046000004','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000032','7-0-style0000000000031','000001000001000046000001','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000033','7-0-style0000000000031','000001000001000046000002','published','WebGUI::Asset::Snippet',1147642500,'3','997995720','3',NULL,0,NULL),('PBnav000000style01lvl2','7-0-style0000000000001','000001000001000045000028','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000030','7-0-style0000000000001','000001000001000045000029','published','WebGUI::Asset::File::Image',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000031','PBasset000000000000002','000001000001000046','published','WebGUI::Asset::Wobject::Folder',1147642500,'3','997995720','3',NULL,0,NULL),('stevenav00000000000001','7-0-style0000000000001','000001000001000045000027','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000025','7-0-style0000000000001','000001000001000045000024','published','WebGUI::Asset::Wobject::Navigation',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000026','7-0-style0000000000001','000001000001000045000025','published','WebGUI::Asset::Wobject::Navigation',1147642499,'3','997995720','3',NULL,0,NULL),('stevestyle000000000001','7-0-style0000000000001','000001000001000045000026','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000023','7-0-style0000000000001','000001000001000045000022','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000024','7-0-style0000000000001','000001000001000045000023','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000022','7-0-style0000000000001','000001000001000045000021','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000021','7-0-style0000000000001','000001000001000045000020','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000018','7-0-style0000000000001','000001000001000045000017','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000019','7-0-style0000000000001','000001000001000045000018','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000020','7-0-style0000000000001','000001000001000045000019','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000017','7-0-style0000000000001','000001000001000045000016','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000016','7-0-style0000000000001','000001000001000045000015','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000015','7-0-style0000000000001','000001000001000045000014','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000014','7-0-style0000000000001','000001000001000045000013','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000012','7-0-style0000000000001','000001000001000045000011','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000013','7-0-style0000000000001','000001000001000045000012','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000010','7-0-style0000000000001','000001000001000045000009','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000011','7-0-style0000000000001','000001000001000045000010','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000009','7-0-style0000000000001','000001000001000045000008','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000008','7-0-style0000000000001','000001000001000045000007','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000067','7-0-style0000000000049','000001000001000047000018','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBtmplHelp000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000002000002','published','WebGUI::Asset::Template',1124395706,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000001','PBasset000000000000002','000001000001000045','published','WebGUI::Asset::Wobject::Folder',1147642492,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000001','oGfxez5sksyB_PcaAsEm_Q','000001000001000040000003','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000002','oGfxez5sksyB_PcaAsEm_Q','000001000001000040000004','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000003','oGfxez5sksyB_PcaAsEm_Q','000001000001000040000005','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000004','oGfxez5sksyB_PcaAsEm_Q','000001000001000040000006','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000063','7-0-style0000000000049','000001000001000047000014','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000142','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000026','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('stevestyle000000000003','7-0-style0000000000049','000001000001000047000020','published','WebGUI::Asset::Template',1147642510,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000002','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000001','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000001','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000002','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000003','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000003','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000004','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000004','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000005','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000004','7-0-style0000000000001','000001000001000045000003','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000002','3uuBf8cYuj1sew2OJXl9tg','000001000001000016000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000001','3uuBf8cYuj1sew2OJXl9tg','000001000001000016000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('PBtmplBlankStyle000001','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000038000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('DashboardViewTmpl00001','S1A9iAwKcQQ6P20uTqw-Ew','000001000001000007000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('WeatherDataTmpl0000001','9wKWdum0_8z-OhhquWLtSQ','000001000001000044000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000002','Efe2W0UgrSRDltNJ87jlfg','000001000001000037000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000001','Efe2W0UgrSRDltNJ87jlfg','000001000001000037000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('MultiSearchTmpl0000001','bBzO4CWjqU_ile3gf5Iypw','000001000001000021000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000068','7-0-style0000000000049','000001000001000047000019','published','WebGUI::Asset::File::Image',1147642510,'3','997995720','3',NULL,0,NULL),('ZipArchiveTMPL00000001','CSN-ZON7Uwv8kxf3F1fh5Q','000001000001000049000001','published','WebGUI::Asset::Template',1133743240,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000002','7-0-style0000000000001','000001000001000045000001','published','WebGUI::Asset::File::Image',1147642492,'3','997995720','3',NULL,0,NULL),('WVtmpl0000000000000001','nqNbSUAhk9Vd1zda2SCz9A','000001000001000018000010000001','published','WebGUI::Asset::Template',1133743240,'3','1222803175','3',NULL,0,NULL),('2CS-BErrjMmESOtGT90qOg','HPDOcsj4gBme8D4svHodBw','000001000001000001000001000003','published','WebGUI::Asset::Template',1227070888,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000208','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000027','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000209','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000028','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000210','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000029','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0004','yD1SMHelczihzjEmx6eXBA','000001000001000027000002000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0003','pV7GnZdpjR3XpZaSINIoeg','000001000001000027000003000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0002','71e17KeduiXgODLMlUxiow','000001000001000027000004000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0001','9A-mg2gwWmaYi9o_1C7ArQ','000001000001000027000001000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('TimeTrackingTMPL000002','vTymIDYL2YqEh6PV50F7ew','000001000001000042000001000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('TimeTrackingTMPL000003','lo1ac3BsoJx3ijGQ3gR-bQ','000001000001000042000002000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('TimeTrackingTMPL000001','huASapWvFDzqwOSbcN-JFQ','000001000001000042000003000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('PBtmpl0000000000000200','f_tn9FfoSfKWX43F83v_3w','000001000001000032000001','published','WebGUI::Asset::Template',1147642427,'3','997995720','3',NULL,0,NULL),('PBasset000000000000003','PBasset000000000000001','000001000003','published','WebGUI::Asset::Wobject::Folder',1147642437,'3','997995720','3',NULL,1,NULL),('pbproto000000000000002','PBasset000000000000002','000001000001000029','published','WebGUI::Asset::Wobject::Collaboration',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000220','tXwf1zaOXTvsqPn6yu-GSw','000001000001000011000002','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000221','tXwf1zaOXTvsqPn6yu-GSw','000001000001000011000003','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('nbSrhXZQuxIjhWFaFPSuVA','PBasset000000000000002','000001000001000002','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('TvOZs8U1kRXLtwtmyW75pg','PBasset000000000000002','000001000001000003','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('xSmREZO3GNzK3M5PaueOOQ','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000001','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('0bx-xoL8TSXXubFuqKAoVQ','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000002','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('taX2UYkFF21ALpFZY2rhMw','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000003','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('K0q_N885Httqev1VCqUWxg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000004','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('fq1ZkYhH24R5tb96kuT10Q','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000005','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('oHk7fAFhEEkB7dHzi0QOQA','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000006','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('9M-lrlPQWeeNWfvnDnK_Xg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000007','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('_gBYAdTcbkiyamnqi2Xskg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000004000008','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('GNOAsX98vCsl0JRwfwL-gg','PBasset000000000000002','000001000001000006','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('S1A9iAwKcQQ6P20uTqw-Ew','PBasset000000000000002','000001000001000007','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('-K8Hj45mbelljN9-0CXZxg','PBasset000000000000002','000001000001000008','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('tXwf1zaOXTvsqPn6yu-GSw','PBasset000000000000002','000001000001000011','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('GYaFxnMu9UsEG8oanwB6TA','PBasset000000000000002','000001000001000012','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('N13SD1Fpqk00UgBt1Z8ivQ','PBasset000000000000002','000001000001000014','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('tPagC0AQErZXjLFZQ6OI1g','PBasset000000000000002','000001000001000015','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('default_post_received1','GNOAsX98vCsl0JRwfwL-gg','000001000001000006000030','published','WebGUI::Asset::Template',1222708029,'3','1222803001','3',NULL,0,NULL),('3uuBf8cYuj1sew2OJXl9tg','PBasset000000000000002','000001000001000016','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('aNNC62qLAS6TB-0_MCYjsw','PBasset000000000000002','000001000001000017','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('tBL7BWiQRZFed2Y-Zjo9tQ','zyWi26q9na-iiZqL4yedog','000001000001000018000001','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','1222803175','3',NULL,0,NULL),('GdkQpvjRtJqtzOUbwIIQRA','zyWi26q9na-iiZqL4yedog','000001000001000018000002','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','1222803175','3',NULL,0,NULL),('tnc5iYyynX2hfdEs9D3P8w','zyWi26q9na-iiZqL4yedog','000001000001000018000003','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','1222803175','3',NULL,0,NULL),('vgXdBcFTqU7h4wBG1ewdBw','zyWi26q9na-iiZqL4yedog','000001000001000018000004','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','1222803175','3',NULL,0,NULL),('hcFlqnXlsmC1ujN6Id0F0A','zyWi26q9na-iiZqL4yedog','000001000001000018000005','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('eRJR52fvlaxfetv3DQkQYw','zyWi26q9na-iiZqL4yedog','000001000001000018000006','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('5HIDHq5lAWHV5gpYGS0zLg','zyWi26q9na-iiZqL4yedog','000001000001000018000007','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('rYEFwXXo0tkGhQTcbDibvg','zyWi26q9na-iiZqL4yedog','000001000001000018000008','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('V3l5S5TtI7wMm1WpIMhvOA','zyWi26q9na-iiZqL4yedog','000001000001000018000009','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('nqNbSUAhk9Vd1zda2SCz9A','zyWi26q9na-iiZqL4yedog','000001000001000018000010','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','1222803175','3',NULL,0,NULL),('y8XkRdxIperLKkJ3bL5sSQ','zyWi26q9na-iiZqL4yedog','000001000001000018000011','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','1222803175','3',NULL,0,NULL),('LdiozcIUciWuvt3Z-na5Ww','PBasset000000000000002','000001000001000019','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('cj2y4papTVGZRFdwTI-_fw','PBasset000000000000002','000001000001000020','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('bBzO4CWjqU_ile3gf5Iypw','PBasset000000000000002','000001000001000021','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('BFfNj5wA9bDw8H3cnr8pTw','PBasset000000000000002','000001000001000022','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('AgyFhx3eXlfZXNp2MkrsiQ','NywJYmGWe1f6EBXJnWg9Xg','000001000001000026000001','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222803652','3',NULL,0,NULL),('F7MAQ-cpuvQ1KuC7J4P5zQ','NywJYmGWe1f6EBXJnWg9Xg','000001000001000026000002','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222803653','3',NULL,0,NULL),('jEz8iTGNWEt2I05IhVV19Q','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000016','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222802937','3',NULL,0,NULL),('VZK3CRgiMb8r4dBjUmCTgQ','PBasset000000000000002','000001000001000024','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('TYo2Bwl7aafzTtdHlS-arQ','PBasset000000000000002','000001000001000025','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('9A-mg2gwWmaYi9o_1C7ArQ','-WM2dt0ZGpDasuL2wWocxg','000001000001000027000001','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('yD1SMHelczihzjEmx6eXBA','-WM2dt0ZGpDasuL2wWocxg','000001000001000027000002','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('pV7GnZdpjR3XpZaSINIoeg','-WM2dt0ZGpDasuL2wWocxg','000001000001000027000003','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('71e17KeduiXgODLMlUxiow','-WM2dt0ZGpDasuL2wWocxg','000001000001000027000004','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','1222803147','3',NULL,0,NULL),('Ik9HHky10DIyFTKehUD1dw','PBasset000000000000002','000001000001000028','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('f_tn9FfoSfKWX43F83v_3w','PBasset000000000000002','000001000001000032','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('Da6KWn805L4B5e4HFgQRQA','PBasset000000000000002','000001000001000035','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('bbiA9Zq5Gy2oCFBlILO3QA','PBasset000000000000002','000001000001000036','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('Efe2W0UgrSRDltNJ87jlfg','PBasset000000000000002','000001000001000037','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('RrV4aAPnn4dM0ZcU3OXnlw','PBasset000000000000002','000001000001000038','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('5bnNzteN7w3NnK9mF4XiCg','PBasset000000000000002','000001000001000039','published','WebGUI::Asset::Wobject::Folder',1147642481,'3','997995720','3',NULL,0,NULL),('oGfxez5sksyB_PcaAsEm_Q','PBasset000000000000002','000001000001000040','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','997995720','3',NULL,0,NULL),('vTymIDYL2YqEh6PV50F7ew','2OcUWHVsu_L1sDFzIMWYqw','000001000001000042000001','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','1222803153','3',NULL,0,NULL),('lo1ac3BsoJx3ijGQ3gR-bQ','2OcUWHVsu_L1sDFzIMWYqw','000001000001000042000002','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','1222803153','3',NULL,0,NULL),('huASapWvFDzqwOSbcN-JFQ','2OcUWHVsu_L1sDFzIMWYqw','000001000001000042000003','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','1222803153','3',NULL,0,NULL),('9wKWdum0_8z-OhhquWLtSQ','PBasset000000000000002','000001000001000044','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','997995720','3',NULL,0,NULL),('CSN-ZON7Uwv8kxf3F1fh5Q','PBasset000000000000002','000001000001000049','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('TCtybxdqmdwdvRn555zpCQ','PBasset000000000000002','000001000001000030','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000070','7-0-style0000000000049','000001000001000047000021','published','WebGUI::Asset::Wobject::Navigation',1147642510,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000071','7-0-style0000000000049','000001000001000047000022','published','WebGUI::Asset::File::Image',1147642511,'3','997995720','3',NULL,0,NULL),('PBnav00000000000bullet','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000027','published','WebGUI::Asset::Template',1148579524,'3','1222803972','3',NULL,0,NULL),('PBnav00000000indentnav','BFfNj5wA9bDw8H3cnr8pTw','000001000001000022000028','published','WebGUI::Asset::Template',1148579525,'3','1222803972','3',NULL,0,NULL),('PBtmpl00000000table125','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000008','published','WebGUI::Asset::Template',1148579525,'3','1222803981','3',NULL,0,NULL),('PBtmpl00000000table094','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000009','published','WebGUI::Asset::Template',1148579525,'3','1222803982','3',NULL,0,NULL),('PBtmpl00000000table131','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000010','published','WebGUI::Asset::Template',1148579525,'3','1222803982','3',NULL,0,NULL),('PBtmpl00000000table135','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000011','published','WebGUI::Asset::Template',1148579525,'3','1222803982','3',NULL,0,NULL),('PBtmpl00000000table118','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000012','published','WebGUI::Asset::Template',1148579525,'3','1222803982','3',NULL,0,NULL),('PBtmpl000000000table54','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000013','published','WebGUI::Asset::Template',1154535074,'3','1222803982','3',NULL,0,NULL),('PBtmpl00000000table109','aNNC62qLAS6TB-0_MCYjsw','000001000001000017000014','published','WebGUI::Asset::Template',1154535074,'3','1222803982','3',NULL,0,NULL),('BmLaN4rmAANkCglXUViEbg','-WM2dt0ZGpDasuL2wWocxg','000001000001000027000005','published','WebGUI::Asset::Wobject::Folder',1157679165,'3','1222803845','3',NULL,0,NULL),('ProjectManagerTMPL0006','BmLaN4rmAANkCglXUViEbg','000001000001000027000005000001','published','WebGUI::Asset::Template',1157679165,'3','1222803845','3',NULL,0,NULL),('ProjectManagerTMPL0005','BmLaN4rmAANkCglXUViEbg','000001000001000027000005000002','published','WebGUI::Asset::Template',1157679165,'3','1222803845','3',NULL,0,NULL),('Q4uX_C557arTp6D_jwB1jQ','PBasset000000000000002','000001000001000048','published','WebGUI::Asset::Wobject::Folder',1165460175,'3','997995720','3',NULL,0,NULL),('WikiRCTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000001','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiFrontTmpl000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000002','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiSearchTmpl00000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000003','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPHTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000004','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPageTmpl0000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000005','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPageEditTmpl000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000006','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiMPTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000007','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('SQLReportDownload00001','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000036000002','published','WebGUI::Asset::Template',1171466654,'3','1222803962','3',NULL,0,NULL),('X7DrzUcj8pOKFa_6k9D5iw','PBasset000000000000002','000001000001000023','published','WebGUI::Asset::Wobject::Folder',1185754569,'3','997995720','3',NULL,0,NULL),('newsletter000000000001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000023000001','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('newslettercs0000000001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000023000002','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('newslettersubscrip0001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000023000003','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('MBmWlA_YEA2I6D29OMGtRg','HPDOcsj4gBme8D4svHodBw','000001000001000001000001000004','published','WebGUI::Asset::Template',1226542675,'3','997995720','3',NULL,0,NULL),('FJbUTvZ2nUTn65LpW6gjsA','HPDOcsj4gBme8D4svHodBw','000001000001000001000001000001','published','WebGUI::Asset::Template',1227070381,'3','997995720','3',NULL,0,NULL),('WikiKeyword00000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000048000008','published','WebGUI::Asset::Template',1185754571,'3','1222803956','3',NULL,0,NULL),('tempspace0000000000000','PBasset000000000000001','000001000004','published','WebGUI::Asset::Wobject::Folder',1185754574,'3','997995720','3',NULL,1,NULL),('75CmQgpcCSkdsL-oawdn3Q','HPDOcsj4gBme8D4svHodBw','000001000001000001000001000002','published','WebGUI::Asset::Template',1227052575,'3','997995720','3',NULL,0,NULL),('gI_TxK-5S4DNuv42wpImmw','PBasset000000000000002','000001000001000013','published','WebGUI::Asset::Wobject::Folder',1197330678,'3','997995720','3',NULL,0,NULL),('jME5BEDYVDlBZ8jIQA9-jQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000001','published','WebGUI::Asset::Template',1197927169,'3','997995720','3',NULL,0,NULL),('azCqD0IjdQSlM3ar29k5Sg','gI_TxK-5S4DNuv42wpImmw','000001000001000013000002','published','WebGUI::Asset::Template',1197881748,'3','997995720','3',NULL,0,NULL),('05FpjceLYhq4csF1Kww1KQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000003','published','WebGUI::Asset::Template',1197879361,'3','997995720','3',NULL,0,NULL),('q5O62aH4pjUXsrQR3Pq4lw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000004','published','WebGUI::Asset::Template',1197825772,'3','997995720','3',NULL,0,NULL),('KAMdiUdJykjN02CPHpyZOw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000005','published','WebGUI::Asset::Template',1197825787,'3','997995720','3',NULL,0,NULL),('OkphOEdaSGTXnFGhK4GT5A','gI_TxK-5S4DNuv42wpImmw','000001000001000013000006','published','WebGUI::Asset::Template',1197825794,'3','997995720','3',NULL,0,NULL),('TEId5V-jEvUULsZA0wuRuA','gI_TxK-5S4DNuv42wpImmw','000001000001000013000007','published','WebGUI::Asset::Template',1197989443,'3','997995720','3',NULL,0,NULL),('6X-7Twabn5KKO_AbgK3PEw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000008','published','WebGUI::Asset::Template',1197987780,'3','997995720','3',NULL,0,NULL),('7JCTAiu1U_bT9ldr655Blw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000009','published','WebGUI::Asset::Template',1197825824,'3','997995720','3',NULL,0,NULL),('0X4Q3tBWUb_thsVbsYz9xQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000010','published','WebGUI::Asset::Template',1197987372,'3','997995720','3',NULL,0,NULL),('m3IbBavqzuKDd2PGGhKPlA','gI_TxK-5S4DNuv42wpImmw','000001000001000013000011','published','WebGUI::Asset::Template',1197825845,'3','997995720','3',NULL,0,NULL),('UTNFeV7B_aSCRmmaFCq4Vw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000012','published','WebGUI::Asset::Template',1197825856,'3','997995720','3',NULL,0,NULL),('zcX-wIUct0S_np14xxOA-A','gI_TxK-5S4DNuv42wpImmw','000001000001000013000013','published','WebGUI::Asset::Template',1197825866,'3','997995720','3',NULL,0,NULL),('MBZK_LPVzqhb4TV4mMRTJg','gI_TxK-5S4DNuv42wpImmw','000001000001000013000014','published','WebGUI::Asset::Snippet',1197330678,'3','997995720','3',NULL,0,NULL),('_hELmIJfgbAyXFNqPyApxQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000015','published','WebGUI::Asset::Snippet',1197330678,'3','997995720','3',NULL,0,NULL),('_9_eiaPgxzF_x_upt6-PNQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000016','published','WebGUI::Asset::Snippet',1197988920,'3','997995720','3',NULL,0,NULL),('kaPRSaf8UKiskiGEgJgLAw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000017','published','WebGUI::Asset::Wobject::Folder',1197330678,'3','997995720','3',NULL,0,NULL),('bANo8aiAPA7aY_oQZKxIWw','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000001','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('2ci_v2d4x4uvyjTRlC49OA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000002','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('O-EsSzKgAk1KolFT-x_KsA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000003','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('fdd8tGExyVwHyrB8RBbKXg','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000004','published','WebGUI::Asset::File::Image',1197330839,'3','997995720','3',NULL,0,NULL),('BpisgHl4ZDcSECJp6oib1w','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000005','published','WebGUI::Asset::File::Image',1197330840,'3','997995720','3',NULL,0,NULL),('zshreRgPAXtnF0DtVbQ1Yg','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000006','published','WebGUI::Asset::File::Image',1197330840,'3','997995720','3',NULL,0,NULL),('mM3bjP_iG9sv5nQb4S17tQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000018','published','WebGUI::Asset::Template',1197879662,'3','997995720','3',NULL,0,NULL),('ilu5BrM-VGaOsec9Lm7M6Q','gI_TxK-5S4DNuv42wpImmw','000001000001000013000019','published','WebGUI::Asset::Template',1197878780,'3','997995720','3',NULL,0,NULL),('-ANLpoTEP-n4POAdRxCzRw','gI_TxK-5S4DNuv42wpImmw','000001000001000013000020','published','WebGUI::Asset::Template',1197880641,'3','997995720','3',NULL,0,NULL),('OxJWQgnGsgyGohP2L3zJPQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000021','published','WebGUI::Asset::Template',1204663962,'3','997995720','3',NULL,0,NULL),('Tsg7xmPYv782j6IVz7yHFg','PBasset000000000000002','000001000001000005','published','WebGUI::Asset::Wobject::Folder',1204890713,'3','997995720','3',NULL,0,NULL),('kj3b-X3i6zRKnhLb4ZiCLw','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000001','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('uRL9qtk7Rb0YRJ41LmHOJw','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000002','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarWeek0000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000003','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarDay00000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000004','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarEvent000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000005','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarEventEdit00001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000006','published','WebGUI::Asset::Template',1205160982,'3','997995720','3',NULL,0,NULL),('CalendarMonth000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000007','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarSearch00000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000008','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarPrintEvent0001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000009','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintMonth0001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000010','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintWeek00001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000011','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintDay000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000005000012','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('jnYdqDkUR8x7Pv2eGR1qTA','PBasset000000000000002','000001000001000041','published','WebGUI::Asset::Wobject::Folder',1205431513,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000001','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000001','published','WebGUI::Asset::Template',1205003608,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000002','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000002','published','WebGUI::Asset::Template',1205003676,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000003','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000003','published','WebGUI::Asset::Template',1205003711,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000004','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000004','published','WebGUI::Asset::Template',1205158717,'3','997995720','3',NULL,0,NULL),('7fE8md51vTCcuJFOvxNaGA','gI_TxK-5S4DNuv42wpImmw','000001000001000013000022','published','WebGUI::Asset::Snippet',1205443600,'3','997995720','3',NULL,0,NULL),('1oGhfj00KkCzP1ez01AfKA','gI_TxK-5S4DNuv42wpImmw','000001000001000013000023','published','WebGUI::Asset::Snippet',1205635970,'3','997995720','3',NULL,0,NULL),('3qiVYhNTXMVC5hfsumVHgg','gI_TxK-5S4DNuv42wpImmw','000001000001000013000024','published','WebGUI::Asset::Snippet',1206743306,'3','997995720','3',NULL,0,NULL),('vrKXEtluIhbmAS9xmPukDA','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000010','published','WebGUI::Asset::Template',1212092352,'3','1222802925','3',NULL,0,NULL),('4qh0kIsFUdd4Ox-Iu1JZgg','PBasset000000000000002','000001000001000010','published','WebGUI::Asset::Wobject::Folder',1208725439,'3','997995720','3',NULL,0,NULL),('BMybD3cEnmXVk2wQ_qEsRQ','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000010000001','published','WebGUI::Asset::Template',1208530113,'3','997995720','3',NULL,0,NULL),('OOyMH33plAy6oCj_QWrxtg','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000010000002','published','WebGUI::Asset::Template',1207951375,'3','997995720','3',NULL,0,NULL),('2rC4ErZ3c77OJzJm7O5s3w','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000010000003','published','WebGUI::Asset::Template',1208721232,'3','997995720','3',NULL,0,NULL),('PsFn7dJt4wMwBa8hiE3hOA','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000010000004','published','WebGUI::Asset::Template',1208558071,'3','997995720','3',NULL,0,NULL),('yBwydfooiLvhEFawJb0VTQ','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000010000005','published','WebGUI::Asset::Template',1208629936,'3','997995720','3',NULL,0,NULL),('63ix2-hU0FchXGIWkG3tow','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000011','published','WebGUI::Asset::Template',1209588387,'3','1222802925','3',NULL,0,NULL),('POVcY79vIqAHR8OfGt36aw','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000007','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('hIB-z34r8Xl-vYVYCkKr-w','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000008','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('-mPUoFlYcjqjPUPRLAlxNQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000009','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('MDpUOR-N8KMyt1J7Hh_h4w','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000010','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('YfXKByTwDZVituMc4h13Dg','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000011','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('esko_HSU0Gh-uJZ1h3xRmQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000012','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('oSqpGswzpBG_ErdfYwIO8A','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000013','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('MXJklShZvLLB_DSnZQmXrQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000014','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('BthxD5oJ0idmsyI3ioA2FA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000015','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('aZ-1HYQamkRHYXvzAra8WQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000016','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('eRkb94OYcS5AdcrrerOP5Q','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000017','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('TbnkjAJQEASORXIpYqDkcA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000018','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('er-3faBjY-hhlDcc5aKqdQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000019','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('8bFsu2FJUqHRUiHcozcVFw','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000020','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('34Aayx5eA320D8VfhdfDBw','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000021','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('TlhKOVmWblZOsAdqmhEpeg','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000022','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('Nx0ypjO3cN6QdZUBUEE0lA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000023','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('CmFZLN7iPS7XXvUEsxKPKA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000024','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('v_XBgwwZqgW1D5s4y05qfg','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000025','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('4TdAkKoQbSCvI7QWcW889A','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000026','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('SAgK6eDPCG1cgkJ59WapHQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000027','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('XJYLuvGy9ubF7JNKyINtpA','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000028','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('RWj7hyv2SpZuXxwj1Wocug','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000029','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('aq8QElnlm3YufAoxRz9Pcg','kaPRSaf8UKiskiGEgJgLAw','000001000001000013000017000030','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('gbnRhcWNk1iQe32LFEB5eQ','PBasset000000000000002','000001000001000033','published','WebGUI::Asset::Wobject::Folder',1210779723,'3','997995720','3',NULL,0,NULL),('6tK47xsaIH-ELw0IBo0uRQ','gbnRhcWNk1iQe32LFEB5eQ','000001000001000033000001','published','WebGUI::Asset::Wobject::Folder',1210777115,'3','997995720','3',NULL,0,NULL),('_bZJ9LA_KNekZiFPaP2SeQ','6tK47xsaIH-ELw0IBo0uRQ','000001000001000033000001000001','published','WebGUI::Asset::File::Image',1210777868,'3','997995720','3',NULL,0,NULL),('nFen0xjkZn8WkpM93C9ceQ','gbnRhcWNk1iQe32LFEB5eQ','000001000001000033000002','published','WebGUI::Asset::Template',1210779326,'3','997995720','3',NULL,0,NULL),('1XOJDcg_ITRYwVM-QnIcPw','gbnRhcWNk1iQe32LFEB5eQ','000001000001000033000003','published','WebGUI::Asset::Snippet',1210779441,'3','997995720','3',NULL,0,NULL),('4e-_rNs6mSWedZhQ_V5kJA','gbnRhcWNk1iQe32LFEB5eQ','000001000001000033000004','published','WebGUI::Asset::Snippet',1210779672,'3','997995720','3',NULL,0,NULL),('eqb9sWjFEVq0yHunGV8IGw','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000012','published','WebGUI::Asset::Template',1213182595,'3','1222802925','3',NULL,0,NULL),('6D4Z-oruXPS6OlH_Kx8pBg','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000005','published','WebGUI::Asset::Wobject::Folder',1209509389,'3','997995720','3',NULL,0,NULL),('hQ7z33_jOYkQ8WNX5xy9Sw','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000001','published','WebGUI::Asset::File::Image',1209509455,'3','997995720','3',NULL,0,NULL),('vWW_DcHiYSrKZOkkIfEfcQ','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000002','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('_bPYzRA87NTAUIKlfrJMHg','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000003','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('nJjZHRwdDs5MAZYsAyioHw','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000004','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('8hxfkrJPeFVRWF5piCNJ1A','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000005','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('Osx7WN52iIKHZFT4vqUBHQ','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000006','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('oWff8fGzRdHPyq5VNREe9Q','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000007','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('uqbkvb1b9443VvfkyRz95w','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000008','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('8YiMkcz32xalkAn3WBLpag','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000041000005000009','published','WebGUI::Asset::File::Image',1210181860,'3','997995720','3',NULL,0,NULL),('3n3H85BsdeRQ0I08WmvlOg','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000006','published','WebGUI::Asset::Snippet',1212091492,'3','997995720','3',NULL,0,NULL),('5m5I7__l40C4hhv4ydqAHQ','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000041000007','published','WebGUI::Asset::Snippet',1210181698,'3','997995720','3',NULL,0,NULL),('C5fPz-Wg85vkYRvCdl-Xqw','PBasset000000000000002','000001000001000043','published','WebGUI::Asset::Wobject::Folder',1212160830,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000001','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000043000001','published','WebGUI::Asset::Template',1212159641,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000002','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000043000002','published','WebGUI::Asset::Template',1212000800,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000003','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000043000003','published','WebGUI::Asset::Template',1212001437,'3','997995720','3',NULL,0,NULL),('usuxw9V3jN4d4pujRiEYxg','7-0-style0000000000049','000001000001000047000023','published','WebGUI::Asset::Snippet',1209494150,'3','997995720','3',NULL,0,NULL),('aNmgn0cd6tldmC1FpW4KbA','PBasset000000000000002','000001000001000034','published','WebGUI::Asset::Wobject::Folder',1213122695,'3','997995720','3',NULL,0,NULL),('2q5fxatSFLgIhXaUX-oSvg','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000001','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('_d5WTkKjnwct-_Dk7gZHvQ','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000002','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('Iz2mUR3jCPKyemwAea4b2g','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000003','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('JU9bjsLRoWj7GVHs__prig','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000004','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('noOlnjQGexHg8c4bGVUo9g','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000005','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('aIpCmr9Hi__vgdZnDTz1jw','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000006','published','WebGUI::Asset::Template',1209921197,'3','997995720','3',NULL,0,NULL),('XNd7a_g_cTvJVYrVHcx2Mw','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000007','published','WebGUI::Asset::Template',1212099009,'3','997995720','3',NULL,0,NULL),('2gtFt7c0qAFNU3BG_uvNvg','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000008','published','WebGUI::Asset::Template',1211824430,'3','997995720','3',NULL,0,NULL),('bPz1yk6Y9uwMDMBcmMsSCg','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000009','published','WebGUI::Asset::Template',1211829604,'3','997995720','3',NULL,0,NULL),('3womoo7Teyy2YKFa25-MZg','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000013','published','WebGUI::Asset::Template',1212098997,'3','1222802925','3',NULL,0,NULL),('EBlxJpZQ9o-8VBOaGQbChA','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000014','published','WebGUI::Asset::Template',1212093746,'3','1222802925','3',NULL,0,NULL),('g8W53Pd71uHB9pxaXhWf_A','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000015','published','WebGUI::Asset::Template',1213184121,'3','1222802925','3',NULL,0,NULL),('mTOiwwk3q4k9g5-XykXhPA','68sKwDgf9cGH58-NZcU4lg','000001000002000005','published','WebGUI::Asset::Wobject::Layout',1215717999,'3','1215733893','3',NULL,0,NULL),('j_1qEqM6iLfQLiR6VKy0aA','mTOiwwk3q4k9g5-XykXhPA','000001000002000005000001','published','WebGUI::Asset::Wobject::Article',1215718151,'3','1215733893','3',NULL,0,NULL),('o_pq_e4vRyhMOKFzs61eag','mTOiwwk3q4k9g5-XykXhPA','000001000002000005000002','published','WebGUI::Asset::File::Image',1215714957,'3','1215733893','3',NULL,0,NULL),('diZvW4bSgZWwyyGP3qXi1g','mTOiwwk3q4k9g5-XykXhPA','000001000002000005000003','published','WebGUI::Asset::Wobject::Article',1215717972,'3','1215733893','3',NULL,0,NULL),('PBEmsBadgeTemplate0000','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000010000006','published','WebGUI::Asset::Template',1221077977,'3','1222802972','3',NULL,0,NULL),('-WM2dt0ZGpDasuL2wWocxg','PBasset000000000000002','000001000001000027','published','WebGUI::Asset::Wobject::Folder',1222803056,'3','997995720','3',NULL,0,NULL),('2OcUWHVsu_L1sDFzIMWYqw','PBasset000000000000002','000001000001000042','published','WebGUI::Asset::Wobject::Folder',1222803070,'3','997995720','3',NULL,0,NULL),('1z9J1O08n_7gVVlBwSRBJQ','PBasset000000000000002','000001000001000004','published','WebGUI::Asset::Wobject::Folder',1222803099,'3','997995720','3',NULL,0,NULL),('zyWi26q9na-iiZqL4yedog','PBasset000000000000002','000001000001000018','published','WebGUI::Asset::Wobject::Folder',1222803114,'3','997995720','3',NULL,0,NULL),('NywJYmGWe1f6EBXJnWg9Xg','PBasset000000000000002','000001000001000026','published','WebGUI::Asset::Wobject::Folder',1222803606,'3','997995720','3',NULL,0,NULL),('UL-ItI4L1Z6-WSuhuXVvsQ','PBasset000000000000002','000001000001000009','published','WebGUI::Asset::Wobject::Folder',1225139673,'3','997995720','3',NULL,0,NULL),('3rjnBVJRO6ZSkxlFkYh_ug','UL-ItI4L1Z6-WSuhuXVvsQ','000001000001000009000001','published','WebGUI::Asset::Template',1225139643,'3','997995720','3',NULL,0,NULL),('TuYPpHx7TUyk08639Pc8Bg','UL-ItI4L1Z6-WSuhuXVvsQ','000001000001000009000002','published','WebGUI::Asset::Template',1225139643,'3','997995720','3',NULL,0,NULL),('THQhn1C-ooj-TLlEP7aIJQ','gI_TxK-5S4DNuv42wpImmw','000001000001000013000025','published','WebGUI::Asset::Snippet',1225313951,'3','1234301624','3',NULL,0,NULL),('jVKLVakT_iA2010_oEuAwg','7-0-style0000000000049','000001000001000047000024','published','WebGUI::Asset::Wobject::Navigation',1224116526,'3','997995720','3',NULL,0,NULL),('QpmlAiYZz6VsKBM-_0wXaw','zyWi26q9na-iiZqL4yedog','000001000001000018000012','published','WebGUI::Asset::Wobject::Folder',1224616691,'3','1234301591','3',NULL,0,NULL),('h_T2xtOxGRQ9QJOR6ebLpQ','QpmlAiYZz6VsKBM-_0wXaw','000001000001000018000012000001','published','WebGUI::Asset::Template',1224616545,'3','1234301591','3',NULL,0,NULL),('4Ekp0kJoJllRRRo_J1Rj6w','QpmlAiYZz6VsKBM-_0wXaw','000001000001000018000012000002','published','WebGUI::Asset::Template',1224616672,'3','1234301591','3',NULL,0,NULL),('gfZOwaTWYjbSoVaQtHBBEw','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000001','published','WebGUI::Asset::Template',1226974679,'3','997995720','3',NULL,0,NULL),('c8xrwVuu5QE0XtF9DiVzLw','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000002','published','WebGUI::Asset::Template',1226894351,'3','997995720','3',NULL,0,NULL),('0n4HtbXaWa_XJHkFjetnLQ','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000003','published','WebGUI::Asset::Template',1226894994,'3','997995720','3',NULL,0,NULL),('ErEzulFiEKDkaCDVmxUavw','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000004','published','WebGUI::Asset::Template',1226895484,'3','997995720','3',NULL,0,NULL),('6uQEULvXFgCYlRWnYzZsuA','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000005','published','WebGUI::Asset::Template',1226896682,'3','997995720','3',NULL,0,NULL),('DUoxlTBXhVS-Zl3CFDpt9g','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000006','published','WebGUI::Asset::Template',1226896802,'3','997995720','3',NULL,0,NULL),('1Q4Je3hKCJzeo0ZBB5YB8g','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000007','published','WebGUI::Asset::Template',1226898445,'3','997995720','3',NULL,0,NULL),('5A8Hd9zXvByTDy4x-H28qw','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000008','published','WebGUI::Asset::Template',1226899462,'3','997995720','3',NULL,0,NULL),('VBkY05f-E3WJS50WpdKd1Q','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000009','published','WebGUI::Asset::Template',1226899241,'3','997995720','3',NULL,0,NULL),('XgcsoDrbC0duVla7N7JAdw','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000010','published','WebGUI::Asset::Template',1226973330,'3','997995720','3',NULL,0,NULL),('cR0UFm7I1qUI2Wbpj--08Q','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000011','published','WebGUI::Asset::Template',1226964738,'3','997995720','3',NULL,0,NULL),('SVIhz68689hwUGgcDM-gWw','IZkrow_zwvbf4FCH-taVTQ','000001000001000001000002000012','published','WebGUI::Asset::Template',1226973314,'3','997995720','3',NULL,0,NULL),('K0YjxqOqr7RupSo6sIdcAg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000003','published','WebGUI::Asset::Wobject::Folder',1227074310,'3','997995720','3',NULL,0,NULL),('zrNpGbT3odfIkg6nFSUy8Q','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000001','published','WebGUI::Asset::Template',1226994016,'3','997995720','3',NULL,0,NULL),('1Yn_zE_dSiNuaBGNLPbxtw','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000002','published','WebGUI::Asset::Template',1226994422,'3','997995720','3',NULL,0,NULL),('AZFU33p0jpPJ-E6qLSWZng','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000003','published','WebGUI::Asset::Template',1226994865,'3','997995720','3',NULL,0,NULL),('AGJBGviWGAwjnwziiPjvDg','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000004','published','WebGUI::Asset::Template',1226995497,'3','997995720','3',NULL,0,NULL),('7Ijdd8SW32lVgg2H8R-Aqw','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000005','published','WebGUI::Asset::Template',1226995714,'3','997995720','3',NULL,0,NULL),('K8F0j_cq_jgo8dvWY_26Ag','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000006','published','WebGUI::Asset::Template',1226995643,'3','997995720','3',NULL,0,NULL),('G5V6neXIDiFXN05oL-U3AQ','K0YjxqOqr7RupSo6sIdcAg','000001000001000001000003000007','published','WebGUI::Asset::Template',1226995768,'3','997995720','3',NULL,0,NULL),('_ilRXNR3s8F2vGJ_k9ePcg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000004','published','WebGUI::Asset::Wobject::Folder',1226643205,'3','997995720','3',NULL,0,NULL),('9ThW278DWLV0-Svf68ljFQ','_ilRXNR3s8F2vGJ_k9ePcg','000001000001000001000004000001','published','WebGUI::Asset::Template',1226647187,'3','997995720','3',NULL,0,NULL),('AOjPG2NHgfL9Cq6dDJ7mew','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000005','published','WebGUI::Asset::Wobject::Folder',1226659753,'3','997995720','3',NULL,0,NULL),('aUDsJ-vB9RgP-AYvPOy8FQ','AOjPG2NHgfL9Cq6dDJ7mew','000001000001000001000005000001','published','WebGUI::Asset::Template',1226660439,'3','997995720','3',NULL,0,NULL),('qaVcU0FFzzraMX_bzELqzw','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000006','published','WebGUI::Asset::Wobject::Folder',1227074362,'3','997995720','3',NULL,0,NULL),('b4n3VyUIsAHyIvT-W-jziA','qaVcU0FFzzraMX_bzELqzw','000001000001000001000006000001','published','WebGUI::Asset::Template',1227074747,'3','997995720','3',NULL,0,NULL),('1IzRpX0tgW7iuCfaU2Kk0A','qaVcU0FFzzraMX_bzELqzw','000001000001000001000006000002','published','WebGUI::Asset::Template',1227079721,'3','997995720','3',NULL,0,NULL),('N716tpSna0iIQTKxS4gTWA','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000007','published','WebGUI::Asset::Template',1226604666,'3','997995720','3',NULL,0,NULL),('GRUNFctldUgop-qRLuo_DA','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000005','published','WebGUI::Asset::Template',1227254010,'3','997995720','3',NULL,0,NULL),('d8jMMMRddSQ7twP4l1ZSIw','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000006','published','WebGUI::Asset::Template',1227248175,'3','997995720','3',NULL,0,NULL),('CxMpE_UPauZA3p8jdrOABw','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000007','published','WebGUI::Asset::Template',1227556536,'3','997995720','3',NULL,0,NULL),('1oBRscNIcFOI-pETrCOspA','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000008','published','WebGUI::Asset::Template',1226009642,'3','997995720','3',NULL,0,NULL),('wAc4azJViVTpo-2NYOXWvg','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000009','published','WebGUI::Asset::Template',1226009650,'3','997995720','3',NULL,0,NULL),('AjhlNO3wZvN5k4i4qioWcg','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000010','published','WebGUI::Asset::Template',1226009658,'3','997995720','3',NULL,0,NULL),('itransact_credentials1','aNmgn0cd6tldmC1FpW4KbA','000001000001000034000018','published','WebGUI::Asset::Template',1228953856,'3','1234301682','3',NULL,0,NULL),('hkj6WeChxFyqfP85UlRP8w','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000006','published','WebGUI::Asset::Snippet',1232664229,'3','997995720','3',NULL,0,NULL),('kJf77eCr9GAMiEzWrzsBTA','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000007','published','WebGUI::Asset::Snippet',1229639255,'3','997995720','3',NULL,0,NULL),('4LQT4-bGW4FkiEQLSY5gvQ','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000008','published','WebGUI::Asset::Snippet',1232400287,'3','997995720','3',NULL,0,NULL),('alraubvBu-YJJ614jAHD5w','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000009','published','WebGUI::Asset::Template',1232664015,'3','997995720','3',NULL,0,NULL),('Vch1Ww7G_JpBhOhXX07RDg','LdiozcIUciWuvt3Z-na5Ww','000001000001000019000010','published','WebGUI::Asset::Wobject::Navigation',1232664082,'3','997995720','3',NULL,0,NULL),('_XfvgNH__bY1ykMiKYSobQ','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000008','published','WebGUI::Asset::Snippet',1233168041,'3','997995720','3',NULL,0,NULL),('HW-sPoDDZR8wBZ0YgFgPtg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000001000009','published','WebGUI::Asset::Wobject::Folder',1227634350,'3','997995720','3',NULL,0,NULL),('hBpisL-_URyZnh9clR5ohA','HW-sPoDDZR8wBZ0YgFgPtg','000001000001000001000009000001','published','WebGUI::Asset::File::Image',1227634417,'3','997995720','3',NULL,0,NULL),('FOBV6KkifreXa4GmEAUU4A','HW-sPoDDZR8wBZ0YgFgPtg','000001000001000001000009000002','published','WebGUI::Asset::File::Image',1227634447,'3','997995720','3',NULL,0,NULL),('qsG6B24a0SC5KrhQjmdZBw','5bnNzteN7w3NnK9mF4XiCg','000001000001000039000011','published','WebGUI::Asset::Snippet',1233860274,'3','1234301655','3',NULL,0,NULL),('wrq7hMxb1ewQqZ46xmd8Gg','PBasset000000000000002','000001000001000050','published','WebGUI::Asset::Snippet',1235706620,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000007','PBasset000000000000002','000001000001000051','published','WebGUI::Asset::Template',1236594030,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000006','PBasset000000000000002','000001000001000052','published','WebGUI::Asset::Template',1236713222,'3','997995720','3',NULL,0,NULL),('F2CZVJtKtTs67DWwqDI96g','PBasset000000000000002','000001000001000053','published','WebGUI::Asset::Snippet',1244584987,'3','997995720','3',NULL,0,NULL);
INSERT INTO `assetData` VALUES ('PBasset000000000000001',1124395696,'3','pbversion0000000000001','approved','Root','Root','root','3','7','3',NULL,0,1,0,0,0,142,NULL,0,1,0,1124395696),('PBasset000000000000002',1124395696,'3','pbversion0000000000001','approved','Import Node','Import','root/import','3','7','12',NULL,0,1,0,0,0,269,NULL,0,1,0,1124395696),('68sKwDgf9cGH58-NZcU4lg',1124395696,'3','pbversion0000000000001','approved','Home','Home','home','3','7','3',NULL,0,0,0,0,0,299,NULL,0,1,0,1124395696),('_iHetEvMQUOoxS-T2CM0sQ',1124395696,'3','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started','3','7','3',NULL,0,0,0,0,0,315,NULL,0,1,0,1124395696),('8Bb8gu-me2mhL3ljFyiWLg',1124395696,'3','pbversion0000000000001','approved','What should you do next?','Your Next Step','your_next_step','3','7','3',NULL,0,0,0,0,0,484,NULL,0,1,0,1124395696),('Vzv1pWpg_w6R_o-b0rM2qQ',1147642515,'3','pbversion0000000000001','approved','Ad','Ad','home/ad2','3','7','4',NULL,0,1,0,0,0,2155177,NULL,0,1,0,1147642515),('NK8bqlwVRILJknqeCDPBHg',1147642515,'3','pbversion0000000000001','approved','Getting Started (part 2)','Getting Started (part 2)','getting_started/getting-started-part2','3','7','4',NULL,0,1,0,0,0,1660,NULL,0,1,0,1147642515),('6QuS-0rosuZTdTv11fobig',1147642515,'3','pbversion0000000000001','approved','Talk to the Experts','Talk to the Experts','yns/experts','3','7','4',NULL,0,1,0,0,0,670,NULL,0,1,0,1147642515),('ix1p0AbwKAz8QWB-T-HHfg',1147642516,'3','pbversion0000000000001','approved','Get Support','Get Support','yns/support','3','7','4',NULL,0,1,0,0,0,706,NULL,0,1,0,1147642516),('iCYOjohB9SKvAPr6bXElKA',1147642516,'3','pbversion0000000000001','approved','Get Hosting','Get Hosting','yns/hosting','3','7','4',NULL,0,1,0,0,0,662,NULL,0,1,0,1147642516),('4Yfz9hqBqM8OYMGuQK8oLw',1147642516,'3','pbversion0000000000001','approved','Get Features','Get Features','yns/features','3','7','4',NULL,0,1,0,0,0,739,NULL,0,1,0,1147642516),('Wl8WZ43g2rK5AYr9o4zY7w',1147642516,'3','pbversion0000000000001','approved','Get Style','Get Style','yns/style','3','7','4',NULL,0,1,0,0,0,572,NULL,0,1,0,1147642516),('LBuiKzg2mWwmOPS9AgV3bg',1147642517,'3','pbversion0000000000001','approved','Get Translated','Get Translated','yns/translated','3','7','4',NULL,0,1,0,0,0,695,NULL,0,1,0,1147642517),('jTNggl7AoVSUc_ZzrvuCmw',1147642517,'3','pbversion0000000000001','approved','Get Promoted','Get Promoted','yns/promotion','3','7','4',NULL,0,1,0,0,0,688,NULL,0,1,0,1147642517),('2TqQc4OISddWCZmRY1_m8A',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news','3','7','3',NULL,0,0,0,0,0,315,NULL,0,1,0,1124395696),('fK-HMSboA3uu0c1KYkYspA',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news/the_latest_news','3','7','3',NULL,0,1,0,0,0,481,NULL,0,1,0,1124395696),('Swf6L8poXKc7hUaNPkBevw',1124395696,'3','pbversion0000000000001','approved','Tell A Friend','Tell A Friend','tell_a_friend','3','7','3',NULL,0,0,0,0,0,309,NULL,0,1,0,1124395696),('x3OFY6OJh_qsXkZfPwug4A',1124395696,'3','pbversion0000000000001','approved','Site Map','Site Map','site_map','3','7','3',NULL,0,0,0,0,0,294,NULL,0,1,0,1124395696),('pJd5TLAjfWMVXD6sCRLwUg',1124395696,'3','pbversion0000000000001','approved','Site Map','Site Map','site_map/site_map','3','7','3',NULL,0,1,0,0,0,331,NULL,0,1,0,1124395696),('7-0-style0000000000003',1147642492,'3','pbversion0000000000001','approved','css01.css','css01.css','style1/css01.css','3','7','12',NULL,0,0,0,0,0,4896,NULL,0,1,0,1147642492),('PBnav00000000000000001',1124395696,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail','3','7','12',NULL,0,1,0,0,0,516,NULL,0,1,0,1124395696),('PBnav00000000000000014',1124395696,'3','pbversion0000000000001','approved','FlexMenu','FlexMenu','flexmenu','3','7','12',NULL,0,1,0,0,0,498,NULL,0,1,0,1124395696),('PBnav00000000000000015',1124395696,'3','pbversion0000000000001','approved','currentMenuVertical','currentMenuVertical','currentmenuvertical','3','7','12',NULL,0,1,0,0,0,539,NULL,0,1,0,1124395696),('PBnav00000000000000016',1124395696,'3','pbversion0000000000001','approved','currentMenuHorizontal','currentMenuHorizontal','currentmenuhorizontal','3','7','12',NULL,0,1,0,0,0,545,NULL,0,1,0,1124395696),('PBnav00000000000000017',1124395696,'3','pbversion0000000000001','approved','PreviousDropMenu','PreviousDropMenu','previousdropmenu','3','7','12',NULL,0,1,0,0,0,533,NULL,0,1,0,1124395696),('PBnav00000000000000018',1124395696,'3','pbversion0000000000001','approved','previousMenuVertical','previousMenuVertical','previousmenuvertical','3','7','12',NULL,0,1,0,0,0,543,NULL,0,1,0,1124395696),('PBnav00000000000000019',1124395696,'3','pbversion0000000000001','approved','previousMenuHorizontal','previousMenuHorizontal','previousmenuhorizontal','3','7','12',NULL,0,1,0,0,0,549,NULL,0,1,0,1124395696),('PBnav00000000000000020',1124395696,'3','pbversion0000000000001','approved','rootmenu','rootmenu','rootmenu','3','7','12',NULL,0,1,0,0,0,500,NULL,0,1,0,1124395696),('PBnav00000000000000021',1124395696,'3','pbversion0000000000001','approved','SpecificDropMenu','SpecificDropMenu','specificdropmenu','3','7','12',NULL,0,1,0,0,0,524,NULL,0,1,0,1124395696),('PBnav00000000000000002',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuVertical','SpecificSubMenuVertical','specificsubmenuvertical','3','7','12',NULL,0,1,0,0,0,545,NULL,0,1,0,1124395696),('PBnav00000000000000006',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal','specificsubmenuhorizontal','3','7','12',NULL,0,1,0,0,0,551,NULL,0,1,0,1124395696),('PBnav00000000000000007',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuVertical','TopLevelMenuVertical','toplevelmenuvertical','3','7','12',NULL,0,1,0,0,0,536,NULL,0,1,0,1124395696),('PBnav00000000000000008',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuHorizontal','TopLevelMenuHorizontal','toplevelmenuhorizontal','3','7','12',NULL,0,1,0,0,0,542,NULL,0,1,0,1124395696),('PBnav00000000000000009',1124395696,'3','pbversion0000000000001','approved','RootTab','RootTab','roottab','3','7','12',NULL,0,1,0,0,0,497,NULL,0,1,0,1124395696),('PBnav00000000000000010',1124395696,'3','pbversion0000000000001','approved','TopDropMenu','TopDropMenu','topdropmenu','3','7','12',NULL,0,1,0,0,0,483,NULL,0,1,0,1124395696),('PBnav00000000000000011',1124395696,'3','pbversion0000000000001','approved','dtree','dtree','dtree','3','7','12',NULL,0,1,0,0,0,497,NULL,0,1,0,1124395696),('PBnav00000000000000012',1124395696,'3','pbversion0000000000001','approved','coolmenu','coolmenu','coolmenu','3','7','12',NULL,0,1,0,0,0,501,NULL,0,1,0,1124395696),('PBnav00000000000000013',1124395696,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis','3','7','12',NULL,0,1,0,0,0,512,NULL,0,1,0,1124395696),('7-0-style0000000000006',1147642493,'3','pbversion0000000000001','approved','main_bg.gif','main_bg.gif','style1/main_bg.gif','3','7','12',NULL,0,0,0,0,0,1990,NULL,0,1,0,1147642493),('PBrichedit000000000002',1124395696,'3','pbversion0000000000001','approved','Forum Rich Edit','Forum Rich Edit','forum_rich_edit','3','7','12',NULL,0,0,0,0,0,246,NULL,0,1,0,1124395696),('7-0-style0000000000068',1147642510,'3','pbversion0000000000001','approved','spacer.gif','spacer.gif','style3/spacer.gif','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1147642510),('7-0-style0000000000066',1147642509,'3','pbversion0000000000001','approved','nav_bg_on.jpg','nav_bg_on.jpg','style3/nav_bg_on.jpg','3','7','12',NULL,0,0,0,0,0,647,NULL,0,1,0,1147642509),('7-0-style0000000000067',1147642509,'3','pbversion0000000000001','approved','pb.jpg','pb.jpg','style3/pb.jpg','3','7','12',NULL,0,0,0,0,0,24970,NULL,0,1,0,1147642509),('7-0-style0000000000062',1147642508,'3','pbversion0000000000001','approved','nav_bg1.jpg','nav_bg1.jpg','style3/nav_bg1.jpg','3','7','12',NULL,0,0,0,0,0,661,NULL,0,1,0,1147642508),('7-0-style0000000000063',1147642508,'3','pbversion0000000000001','approved','nav_bg1_on.jpg','nav_bg1_on.jpg','style3/nav_bg1_on.jpg','3','7','12',NULL,0,0,0,0,0,672,NULL,0,1,0,1147642508),('7-0-style0000000000064',1147642509,'3','pbversion0000000000001','approved','nav_bg2.jpg','nav_bg2.jpg','style3/nav_bg2.jpg','3','7','12',NULL,0,0,0,0,0,664,NULL,0,1,0,1147642509),('7-0-style0000000000065',1147642509,'3','pbversion0000000000001','approved','nav_bg2_on.jpg','nav_bg2_on.jpg','style3/nav_bg2_on.jpg','3','7','12',NULL,0,0,0,0,0,677,NULL,0,1,0,1147642509),('7-0-style0000000000061',1147642508,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style3/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,658,NULL,0,1,0,1147642508),('7-0-style0000000000057',1147642507,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style3/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,628,NULL,0,1,0,1147642507),('7-0-style0000000000058',1147642507,'3','pbversion0000000000001','approved','main_bottom.jpg','main_bottom.jpg','style3/main_bottom.jpg','3','7','12',NULL,0,0,0,0,0,2619,NULL,0,1,0,1147642507),('7-0-style0000000000060',1147642508,'3','pbversion0000000000001','approved','main_top_bg.jpg','main_top_bg.jpg','style3/main_top_bg.jpg','3','7','12',NULL,0,0,0,0,0,676,NULL,0,1,0,1147642508),('7-0-style0000000000054',1147642506,'3','pbversion0000000000001','approved','header_bg.jpg','header_bg.jpg','style3/header_bg.jpg','3','7','12',NULL,0,0,0,0,0,704,NULL,0,1,0,1147642506),('7-0-style0000000000055',1147642506,'3','pbversion0000000000001','approved','header_left.jpg','header_left.jpg','style3/header_left.jpg','3','7','12',NULL,0,0,0,0,0,23972,NULL,0,1,0,1147642506),('7-0-style0000000000056',1147642506,'3','pbversion0000000000001','approved','header_right.jpg','header_right.jpg','style3/header_right.jpg','3','7','12',NULL,0,0,0,0,0,24746,NULL,0,1,0,1147642506),('7-0-style0000000000053',1147642505,'3','pbversion0000000000001','approved','footer_right.jpg','footer_right.jpg','style3/footer_right.jpg','3','7','12',NULL,0,0,0,0,0,2875,NULL,0,1,0,1147642505),('7-0-style0000000000052',1147642505,'3','pbversion0000000000001','approved','footer_bg.jpg','footer_bg.jpg','style3/footer_bg.jpg','3','7','12',NULL,0,0,0,0,0,669,NULL,0,1,0,1147642505),('7-0-style0000000000048',1147642504,'3','pbversion0000000000001','approved','wg.jpg','wg.jpg','style2/wg.jpg','3','7','12',NULL,0,0,0,0,0,41300,NULL,0,1,0,1147642504),('7-0-style0000000000046',1147642504,'3','pbversion0000000000001','approved','rightCol_bg.jpg','rightCol_bg.jpg','style2/rightcol_bg.jpg','3','7','12',NULL,0,0,0,0,0,1118,NULL,0,1,0,1147642504),('7-0-style0000000000043',1147642503,'3','pbversion0000000000001','approved','pb.jpg','pb.jpg','style2/pb.jpg','3','7','12',NULL,0,0,0,0,0,45606,NULL,0,1,0,1147642503),('7-0-style0000000000044',1147642503,'3','pbversion0000000000001','approved','pb_wg.jpg','pb_wg.jpg','style2/pb_wg.jpg','3','7','12',NULL,0,0,0,0,0,5140,NULL,0,1,0,1147642503),('7-0-style0000000000040',1147642502,'3','pbversion0000000000001','approved','navbar_right.jpg','navbar_right.jpg','style2/navbar_right.jpg','3','7','12',NULL,0,0,0,0,0,1594,NULL,0,1,0,1147642502),('7-0-style0000000000041',1147642502,'3','pbversion0000000000001','approved','page_title.jpg','page_title.jpg','style2/page_title.jpg','3','7','12',NULL,0,0,0,0,0,49390,NULL,0,1,0,1147642502),('7-0-style0000000000042',1147642502,'3','pbversion0000000000001','approved','page_title_bg.jpg','page_title_bg.jpg','style2/page_title_bg.jpg','3','7','12',NULL,0,0,0,0,0,1110,NULL,0,1,0,1147642502),('7-0-style0000000000038',1147642501,'3','pbversion0000000000001','approved','navbar_bg.jpg','navbar_bg.jpg','style2/navbar_bg.jpg','3','7','12',NULL,0,0,0,0,0,936,NULL,0,1,0,1147642501),('7-0-style0000000000039',1147642502,'3','pbversion0000000000001','approved','navbar_left.jpg','navbar_left.jpg','style2/navbar_left.jpg','3','7','12',NULL,0,0,0,0,0,1004,NULL,0,1,0,1147642502),('7-0-style0000000000036',1147642501,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style2/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,1222,NULL,0,1,0,1147642501),('7-0-style0000000000037',1147642501,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style2/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,902,NULL,0,1,0,1147642501),('7-0-style0000000000033',1147642500,'3','pbversion0000000000001','approved','css02.css','css02.css','style2/css02.css','3','7','12',NULL,0,0,0,0,0,3061,NULL,0,1,0,1147642500),('7-0-style0000000000034',1147642500,'3','pbversion0000000000001','approved','leftCol_header.jpg','leftCol_header.jpg','style2/leftcol_header.jpg','3','7','12',NULL,0,0,0,0,0,21636,NULL,0,1,0,1147642500),('7-0-style0000000000035',1147642501,'3','pbversion0000000000001','approved','leftCol_header02.jpg','leftCol_header02.jpg','style2/leftcol_header02.jpg','3','7','12',NULL,0,0,0,0,0,8868,NULL,0,1,0,1147642501),('7-0-style0000000000030',1147642499,'3','pbversion0000000000001','approved','webgui_btn.jpg','webgui_btn.jpg','style1/webgui_btn.jpg','3','7','12',NULL,0,0,0,0,0,10040,NULL,0,1,0,1147642499),('7-0-style0000000000031',1147642500,'3','pbversion0000000000001','approved','WebGUI 7 Style 2','WebGUI 7 Style 2','root/import/webgui-7-style-2','3','7','12',NULL,0,0,0,0,0,287,NULL,0,1,0,1147642500),('7-0-style0000000000032',1147642500,'3','pbversion0000000000001','approved','context_bg.jpg','context_bg.jpg','style2/context_bg.jpg','3','7','12',NULL,0,0,0,0,0,1004,NULL,0,1,0,1147642500),('PBnav000000style01lvl2',1147642499,'3','pbversion0000000000001','approved','Style 01 Nav lvl2','untitled','style1_nav_lvl2','3','7','12',NULL,0,0,0,0,0,1015,NULL,0,1,0,1228264382),('7-0-style0000000000026',1147642499,'3','pbversion0000000000001','approved','RootTab Level 1','RootTab Level 1','roottab_level1','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1147642499),('stevenav00000000000001',1147642499,'3','pbversion0000000000001','approved','Style 01 Nav','Style 01 Nav','style1_nav','3','7','12',NULL,0,0,0,0,0,994,NULL,0,1,0,1228264382),('7-0-style0000000000025',1147642498,'3','pbversion0000000000001','approved','RootTab Level 0','RootTab Level 0','roottab_level0','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1147642498),('7-0-style0000000000022',1147642497,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style1/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,1914,NULL,0,1,0,1147642497),('7-0-style0000000000023',1147642498,'3','pbversion0000000000001','approved','nav_on.jpg','nav_on.jpg','style1/nav_on.jpg','3','7','12',NULL,0,0,0,0,0,1536,NULL,0,1,0,1147642498),('7-0-style0000000000024',1147642498,'3','pbversion0000000000001','approved','orange_left01.jpg','orange_left01.jpg','style1/orange_left01.jpg','3','7','12',NULL,0,0,0,0,0,5810,NULL,0,1,0,1147642498),('7-0-style0000000000018',1147642496,'3','pbversion0000000000001','approved','nav2_off_left.jpg','nav2_off_left.jpg','style1/nav2_off_left.jpg','3','7','12',NULL,0,0,0,0,0,1174,NULL,0,1,0,1147642496),('7-0-style0000000000019',1147642497,'3','pbversion0000000000001','approved','nav2_off_right.jpg','nav2_off_right.jpg','style1/nav2_off_right.jpg','3','7','12',NULL,0,0,0,0,0,1162,NULL,0,1,0,1147642497),('7-0-style0000000000017',1147642496,'3','pbversion0000000000001','approved','nav2_off_center.jpg','nav2_off_center.jpg','style1/nav2_off_center.jpg','3','7','12',NULL,0,0,0,0,0,1336,NULL,0,1,0,1147642496),('7-0-style0000000000015',1147642496,'3','pbversion0000000000001','approved','nav1_on_right.jpg','nav1_on_right.jpg','style1/nav1_on_right.jpg','3','7','12',NULL,0,0,0,0,0,1936,NULL,0,1,0,1147642496),('7-0-style0000000000014',1147642495,'3','pbversion0000000000001','approved','nav1_on_left.jpg','nav1_on_left.jpg','style1/nav1_on_left.jpg','3','7','12',NULL,0,0,0,0,0,2062,NULL,0,1,0,1147642495),('7-0-style0000000000013',1147642495,'3','pbversion0000000000001','approved','nav1_on.jpg','nav1_on.jpg','style1/nav1_on.jpg','3','7','12',NULL,0,0,0,0,0,4544,NULL,0,1,0,1147642495),('7-0-style0000000000011',1147642495,'3','pbversion0000000000001','approved','nav1_off_left.jpg','nav1_off_left.jpg','style1/nav1_off_left.jpg','3','7','12',NULL,0,0,0,0,0,2128,NULL,0,1,0,1147642495),('7-0-style0000000000012',1147642495,'3','pbversion0000000000001','approved','nav1_off_right.jpg','nav1_off_right.jpg','style1/nav1_off_right.jpg','3','7','12',NULL,0,0,0,0,0,2020,NULL,0,1,0,1147642495),('7-0-style0000000000010',1147642494,'3','pbversion0000000000001','approved','nav1_off_center.jpg','nav1_off_center.jpg','style1/nav1_off_center.jpg','3','7','12',NULL,0,0,0,0,0,2596,NULL,0,1,0,1147642494),('7-0-style0000000000009',1147642494,'3','pbversion0000000000001','approved','nav1_off.jpg','nav1_off.jpg','style1/nav1_off.jpg','3','7','12',NULL,0,0,0,0,0,4870,NULL,0,1,0,1147642494),('7-0-style0000000000007',1147642493,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style1/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,1752,NULL,0,1,0,1147642493),('7-0-style0000000000001',1147642492,'3','pbversion0000000000001','approved','WebGUI 7 Style 1','WebGUI 7 Style 1','root/import/webgui-7-style-1','3','7','12',NULL,0,0,0,0,0,287,NULL,0,1,0,1147642492),('SynConXSLT000000000001',1124395707,'3','pbversion0000000000001','approved','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT','xslt/rss0.9.xsl','3','7','12',NULL,0,0,0,0,0,2646,NULL,0,1,0,1124395707),('SynConXSLT000000000002',1124395707,'3','pbversion0000000000001','approved','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT','xslt/rss0.91.xsl','3','7','12',NULL,0,0,0,0,0,2485,NULL,0,1,0,1124395707),('SynConXSLT000000000003',1124395707,'3','pbversion0000000000001','approved','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT','xslt/rss1.0.xsl','3','7','12',NULL,0,0,0,0,0,2718,NULL,0,1,0,1124395707),('SynConXSLT000000000004',1124395707,'3','pbversion0000000000001','approved','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT','xslt/rss2.0.xsl','3','7','12',NULL,0,0,0,0,0,2551,NULL,0,1,0,1124395707),('PBtmpl0000000000000036',1129049186,'3','pbversion0000000000001','approved','Default Admin Toggle Macro','Default Admin Toggle Macro','default_admin_toggle_macro','3','7','12',NULL,0,1,0,0,0,388,NULL,0,1,0,1228264382),('PBtmpl0000000000000037',1129049186,'3','pbversion0000000000001','approved','Default Account Macro','Default Account Macro','default_account_macro','3','7','12',NULL,0,1,0,0,0,395,NULL,0,1,0,1228264382),('PBtmpl0000000000000038',1129049186,'3','pbversion0000000000001','approved','Default Editable Toggle Macro','Default Editable Toggle Macro','default_editable_toggle_macro','3','7','12',NULL,0,1,0,0,0,400,NULL,0,1,0,1228264382),('PBtmpl0000000000000040',1129049186,'3','pbversion0000000000001','approved','Default Group Add Macro','Default Group Add Macro','default_group_add_macro','3','7','12',NULL,0,1,0,0,0,374,NULL,0,1,0,1228264382),('PBtmpl0000000000000041',1129049186,'3','pbversion0000000000001','approved','Default Group Delete Macro','Default Group Delete Macro','default_group_delete_macro','3','7','12',NULL,0,1,0,0,0,386,NULL,0,1,0,1228264382),('PBtmpl0000000000000042',1129049186,'3','pbversion0000000000001','approved','Default Homelink','Default Homelink','default_homelink','3','7','12',NULL,0,1,0,0,0,378,NULL,0,1,0,1228264382),('PBtmpl0000000000000043',1129049186,'3','pbversion0000000000001','approved','Default LoginToggle','Default LoginToggle','default_logintoggle','3','7','12',NULL,0,1,0,0,0,391,NULL,0,1,0,1228264382),('PBtmpl0000000000000045',1129049186,'3','pbversion0000000000001','approved','Default Make Printable','Default Make Printable','default_make_printable','3','7','12',NULL,0,1,0,0,0,408,NULL,0,1,0,1228264382),('PBtmpl0000000000000208',1147642410,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-template','3','7','12',NULL,0,0,0,0,0,3992,'\n<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n\n',0,1,0,1228264382),('PBtmpl0000000000000091',1129049189,'3','pbversion0000000000001','approved','File no icon','File no icon','file_no_icon','3','7','12',NULL,0,1,0,0,0,335,NULL,0,1,0,1228264382),('PBtmpl0000000000000132',1129049190,'3','pbversion0000000000001','approved','Empty','Empty','empty','3','7','12',NULL,0,1,0,0,0,271,NULL,0,1,0,1228264382),('PBtmpl0000000000000140',1129573244,'3','pbversion0000000000001','approved','Default Shortcut','Default Shortcut','pbtmpl0000000000000140','3','7','12',NULL,0,1,0,0,0,1020,NULL,0,1,0,1228264382),('PBtmplHelp000000000001',1147642410,'3','pbversion0000000000001','approved','Help','Help','help','3','7','12',NULL,0,0,0,0,0,1388,'<style type=\"text/css\">\ndd {\n	margin-bottom: 15px;\n}\n\ndt {\n	font-weight: bold;	\n}\n</style>\n\n',0,1,0,1228264382),('ProjectManagerTMPL0004',1222574693,'3','pbversion0000000000001','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,5258,'<style type=\"text/css\">\r\n.PM_small {\r\n	font-size:8pt;\r\n}\r\ntr.clearNoBG a {\r\n	text-decoration:none;\r\n	color:navy;\r\n}\r\n</style>\r\n',0,1,0,1228264384),('7-0-style0000000000071',1147642511,'3','pbversion0000000000001','approved','wg.jpg','wg.jpg','style3/wg.jpg','3','7','12',NULL,0,0,0,0,0,27488,NULL,0,1,0,1147642511),('7-0-style0000000000070',1147642510,'3','pbversion0000000000001','approved','Style3 Coolmenu','Style3 Coolmenu','style3_coolmenu','3','7','12',NULL,0,0,0,0,0,344,NULL,0,1,0,1147642510),('7-0-style0000000000004',1147642493,'3','pbversion0000000000001','approved','gui_bottom.jpg','gui_bottom.jpg','style1/gui_bottom.jpg','3','7','12',NULL,0,0,0,0,0,21700,NULL,0,1,0,1147642493),('7-0-style0000000000002',1147642492,'3','pbversion0000000000001','approved','body_bg.jpg','body_bg.jpg','style1/body_bg.jpg','3','7','12',NULL,0,0,0,0,0,890,NULL,0,1,0,1147642492),('PBtmpl0000000000000128',1147642411,'3','pbversion0000000000001','approved','Classifieds','Classifieds','classifieds','3','7','12',NULL,0,1,0,0,0,2007,'<style type=\"text/css\">\n.ad {\n	border: 1px dotted #aaaaaa;\n	padding: 10px;\n	margin: 0px;\n	float: left;\n	width: 140px;\n	font-size: 12px;\n	height: 175px;\n	overflow: hidden;\n}\n</style>\n\n',0,1,0,1228264382),('PBtmpl0000000000000093',1147642412,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail2','3','7','12',NULL,0,1,0,0,0,767,NULL,0,1,0,1228264382),('PBtmpl0000000000000104',1147642412,'3','pbversion0000000000001','approved','Default Acknowledgement','Default Acknowledgement','default_acknowledgement','3','7','12',NULL,0,1,0,0,0,1207,'<style type=\"text/css\">\n.acknowledgement\n{\n	margin-top:5px;\n}\n.acknowledgement td\n{\n	font-size:9pt;\n	font-family:arial;\n}\n\na.blackLabel\n{\n	color:#29587E;\n}\n\n</style>',0,1,0,1228264382),('PBtmpl0000000000000031',1147642413,'3','pbversion0000000000001','approved','Default Forum Search','Default Forum Search','default_forum_search','3','7','12',NULL,0,1,0,0,0,2682,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n}\n.searchResults{\n	border:solid silver 1px;\n	margin-top:5px;\n}\n.searchResults td{\n	font-family:arial;\n	font-size:9pt;\n}\n.searchResults td a{\n	color:#29587E;\n}\n.searchResults td.odd{\n	background-color:#DADADA;\n}\n.searchResults td.tableHeader{\n	background-color:gray;\n	color:white;\n	border-bottom:double solid silver 3px;\n	font-weight:bold;\n}\n.pagination\n{\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.postControls a\n{\n	color:white;\n}\n\n</style>',0,1,0,1228264382),('PBtmpl0000000000000006',1147642414,'3','pbversion0000000000001','approved','Default LDAP Login Template','Default LDAP Login Template','default_ldap_login_template','3','7','12',NULL,0,1,0,0,0,1180,NULL,0,1,0,1228264382),('PBtmpl0000000000000047',1147642414,'3','pbversion0000000000001','approved','Default Message Board','Default Message Board','default_message_board','3','7','12',NULL,0,1,0,0,0,3535,'<style type=\"text/css\">\n.defaultMessageBoard {\n\n}\n.defaultMessageBoard .tableHeader{\n	font-weight:bold;\n	border-bottom:solid gray 3px;\n	text-align:center;\n}\n.defaultMessageBoard td {\n	font-family:arial;\n	font-size:9pt;\n	border-bottom:solid gray 1px;\n}\n.defaultMessageBoard td a {\n	color:#29587E;\n}\n.defaultMessageBoard td.even {\n	background-color:#DADADA;\n	border-bottom:solid gray 1px;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n</style>',0,1,0,1228264382),('TimeTrackingTMPL000002',1147642417,'3','pbversion0000000000001','approved','Default Time Tracking Manager View','Default Time Tracking Manager View','default-tt-template-manager','3','7','12',NULL,0,0,0,0,0,381,'	',0,1,0,1228264382),('PBtmpl0000000000000066',1147642417,'3','pbversion0000000000001','approved','Default USS','Default USS','default_uss','3','7','12',NULL,0,1,0,0,0,3063,'<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n\n</style>\n\n\n',0,1,0,1228264382),('PBtmpl0000000000000013',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Login Template','Default WebGUI Login Template','default_webgui_login_template','3','7','12',NULL,0,1,0,0,0,1334,NULL,0,1,0,1228264382),('PBtmpl0000000000000012',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template','default_webgui_password_reset_template','3','7','12',NULL,0,1,0,0,0,1274,NULL,0,1,0,1228264382),('PBtmpl0000000000000057',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt','default_webgui_yes/no_prompt','3','7','12',NULL,0,1,0,0,0,561,NULL,0,1,0,1228264382),('PBtmpl0000000000000060',1147642419,'3','pbversion0000000000001','approved','Fail Safe','Fail Safe','fail_safe','3','7','12',NULL,0,1,0,0,0,1246,NULL,0,1,0,1228264382),('PBtmpl0000000000000024',1147642420,'3','pbversion0000000000001','approved','File','File','file','3','7','12',NULL,0,1,0,0,0,477,NULL,0,1,0,1228264382),('PBtmpl0000000000000078',1147642420,'3','pbversion0000000000001','approved','File Folder','File Folder','file_folder','3','7','12','',0,1,0,0,0,1954,NULL,0,1,0,1228264382),('PBtmpl0000000000000107',1147642420,'3','pbversion0000000000001','approved','File with size','File with size','file_with_size','3','7','12',NULL,0,1,0,0,0,473,NULL,0,1,0,1228264382),('PBtmpl0000000000000108',1147642421,'3','pbversion0000000000001','approved','horizontalMenu','horizontalMenu','horizontalmenu','3','7','12',NULL,0,1,0,0,0,785,NULL,0,1,0,1228264382),('PBtmpl0000000000000088',1147642421,'3','pbversion0000000000001','approved','Image','Image','image','3','7','12',NULL,0,1,0,0,0,400,NULL,0,1,0,1228264382),('PBtmpl0000000000000123',1147642421,'3','pbversion0000000000001','approved','Item','Item','item','3','7','12',NULL,0,1,0,0,0,897,NULL,0,1,0,1228264382),('PBtmpl0000000000000129',1147642422,'3','pbversion0000000000001','approved','Item w/pop-up Links','Item w/pop-up Links','item_w/pop-up_links','3','7','12',NULL,0,1,0,0,0,970,NULL,0,1,0,1228264382),('PBtmpl0000000000000077',1147642422,'3','pbversion0000000000001','approved','Job Listing','Job Listing','job_listing','3','7','12',NULL,0,1,0,0,0,2925,'<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n',0,1,0,1228264382),('WVtmpl0000000000000001',1147642426,'3','pbversion0000000000001','approved','Random Thread Macro Default Template','Random Thread Macro Default Template','randomthread-template','3','7','12',NULL,0,0,0,0,0,4783,NULL,0,1,0,1228264382),('PBtmpl0000000000000136',1147642428,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis2','3','7','12',NULL,0,1,0,0,0,852,NULL,0,1,0,1228264382),('PBtmpl0000000000000124',1147642429,'3','pbversion0000000000001','approved','Tabs','Tabs','tabs','3','7','12',NULL,0,1,0,0,0,777,NULL,0,1,0,1228264382),('PBtmpl0000000000000048',1147642431,'3','pbversion0000000000001','approved','verticalMenu','verticalMenu','verticalmenu','3','7','12',NULL,0,1,0,0,0,789,NULL,0,1,0,1228264382),('PBtmplBlankStyle000001',1147642431,'3','pbversion0000000000001','approved','WebGUI 6 Blank Style','WebGUI 6 Blank Style','pbtmplblankstyle000001','3','7','12',NULL,0,1,0,0,0,860,NULL,0,1,0,1228264382),('5A8Hd9zXvByTDy4x-H28qw',1227566395,'3','pbversion0000000000001','approved','Default Invitation Confirmation Template','Default Invitation Confirmation Template','root/import/account/inbox/default-invitation-confirmation-template','3','7','12',NULL,0,1,0,0,0,1000,NULL,0,1,0,1234301430),('7-0-style0000000000005',1147642493,'3','pbversion0000000000001','approved','header.jpg','header.jpg','style1/header.jpg','3','7','12',NULL,0,0,0,0,0,89722,NULL,0,1,0,1147642493),('7-0-style0000000000008',1147642494,'3','pbversion0000000000001','approved','nav1_center_on.jpg','nav1_center_on.jpg','style1/nav1_center_on.jpg','3','7','12',NULL,0,0,0,0,0,2428,NULL,0,1,0,1147642494),('pbrobot000000000000001',1147642511,'3','pbversion0000000000001','approved','robots.txt','robots.txt','robots.txt','3','7','12',NULL,0,0,0,0,0,292,NULL,0,1,0,1147642511),('bX5rYxb6tZ9docY6sUhBlw',1147642514,'3','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started/getting-started','3','7','4',NULL,0,1,0,0,0,646,NULL,0,1,0,1147642514),('IWFxZDyGhQ3-SLZhELa3qw',1147642514,'3','pbversion0000000000001','approved','Key Benefits','Key Benefits','home/key-benefits','3','7','4',NULL,0,1,0,0,0,2019,NULL,0,1,0,1147642514),('m4YJFaqzultnB_sj1Uq0aw',1147642514,'3','pbversion0000000000001','approved','Ad','Ad','home/ad','3','7','4',NULL,0,1,0,0,0,92365,NULL,0,1,0,1147642514),('7-0-style0000000000045',1147642503,'3','pbversion0000000000001','approved','pb_wg_bg.jpg','pb_wg_bg.jpg','style2/pb_wg_bg.jpg','3','7','12',NULL,0,0,0,0,0,43126,NULL,0,1,0,1147642503),('7-0-style0000000000021',1147642497,'3','pbversion0000000000001','approved','nav2_on_right.jpg','nav2_on_right.jpg','style1/nav2_on_right.jpg','3','7','12',NULL,0,0,0,0,0,1110,NULL,0,1,0,1147642497),('7-0-style0000000000020',1147642497,'3','pbversion0000000000001','approved','nav2_on_left.jpg','nav2_on_left.jpg','style1/nav2_on_left.jpg','3','7','12',NULL,0,0,0,0,0,1138,NULL,0,1,0,1147642497),('7-0-style0000000000016',1147642496,'3','pbversion0000000000001','approved','nav2_center_on.jpg','nav2_center_on.jpg','style1/nav2_center_on.jpg','3','7','12',NULL,0,0,0,0,0,1280,NULL,0,1,0,1147642496),('PBasset000000000000003',1147642437,'3','pbversion0000000000001','approved','Media','Media','media','3','7','12',NULL,0,0,0,0,0,258,NULL,0,1,0,1147642437),('OhdaFLE7sXOzo_SIP2ZUgA',1147642513,'3','pbversion0000000000001','approved','Welcome','Welcome','home/welcome','3','7','4',NULL,0,1,0,0,0,1830,NULL,0,1,0,1147642513),('pbtmpl0000000000000221',1147642465,'3','pbversion0000000000001','approved','Flash Tutorial Template','Flash Tutorial Template','flash-tutorial-template','3','7','12',NULL,0,0,0,0,0,975,NULL,0,1,0,1228264382),('nbSrhXZQuxIjhWFaFPSuVA',1147642465,'3','pbversion0000000000001','approved','AdminConsole','AdminConsole','root/import/adminconsole','3','7','12',NULL,0,0,0,0,0,275,NULL,0,1,0,1147642465),('TvOZs8U1kRXLtwtmyW75pg',1147642465,'3','pbversion0000000000001','approved','Article','Article','root/import/article','3','7','12',NULL,0,0,0,0,0,260,NULL,0,1,0,1147642465),('GNOAsX98vCsl0JRwfwL-gg',1147642466,'3','pbversion0000000000001','approved','Collaboration','Collaboration','root/import/collaboration','3','7','12',NULL,0,0,0,0,0,302,NULL,0,1,0,1147642466),('S1A9iAwKcQQ6P20uTqw-Ew',1147642468,'3','pbversion0000000000001','approved','Dashboard','Dashboard','root/import/dashboard','3','7','12',NULL,0,0,0,0,0,266,NULL,0,1,0,1147642468),('71e17KeduiXgODLMlUxiow',1222803352,'3','pbversion0000000000001','approved','project','project','root/import/projectmanager/project','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1222803352),('tXwf1zaOXTvsqPn6yu-GSw',1147642469,'3','pbversion0000000000001','approved','FileAsset','FileAsset','root/import/fileasset','3','7','12',NULL,0,0,0,0,0,266,NULL,0,1,0,1147642469),('GYaFxnMu9UsEG8oanwB6TA',1147642470,'3','pbversion0000000000001','approved','Folder','Folder','root/import/folder','3','7','12',NULL,0,0,0,0,0,257,NULL,0,1,0,1147642470),('N13SD1Fpqk00UgBt1Z8ivQ',1147642470,'3','pbversion0000000000001','approved','HttpProxy','HttpProxy','root/import/httpproxy','3','7','12',NULL,0,0,0,0,0,266,NULL,0,1,0,1147642470),('tPagC0AQErZXjLFZQ6OI1g',1147642470,'3','pbversion0000000000001','approved','ImageAsset','ImageAsset','root/import/imageasset','3','7','12',NULL,0,0,0,0,0,269,NULL,0,1,0,1147642470),('3uuBf8cYuj1sew2OJXl9tg',1147642470,'3','pbversion0000000000001','approved','InOutBoard','InOutBoard','root/import/inoutboard','3','7','12',NULL,0,0,0,0,0,269,NULL,0,1,0,1147642470),('ProjectManagerTMPL0002',1222574693,'3','pbversion0000000000001','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,10531,'<style type=\"text/css\">\r\n	body, html {\r\n		margin:0px;\r\n		padding:0px;\r\n	}\r\n	.project {\r\n		position:relative;\r\n		margin-top:5px;\r\n		margin-left:5px;\r\n	}\r\n	.project td {\r\n		border:solid silver 1px;\r\n		border-bottom:solid gray 1px;\r\n		font-size:9pt;\r\n		font-family:arial;		\r\n	}\r\n	.project a {\r\n	    color:#000000;\r\n		font-weight: normal;\r\n		font-size: 9pt;\r\n		text-decoration: none;\r\n	}\r\n	\r\n	.project a:hover {\r\n	    color:#7AB7E9;\r\n		font-weight: normal;\r\n		font-size: 9pt;\r\n		text-decoration: none;\r\n	}\r\n	\r\n	.taskname {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 295px;\r\n    }\r\n	.taskduration {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 25px;\r\n	}\r\n	.taskdate {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 68px;\r\n	}\r\n	.taskdependant {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 20px;\r\n	}\r\n	tr.monthNames td {		\r\n		text-align:center;		\r\n	}\r\n	tr.dates td {\r\n		width:16px;\r\n	}\r\n	div.scroller {		\r\n		overflow:scroll;		\r\n		position:relative;\r\n		width:400px;		\r\n	}\r\n	\r\n	* html div.scroller {\r\n		overflow-x:scroll;\r\n	}\r\n	\r\n	td.empty {\r\n		background-color:transparent;\r\n		border-style:none;\r\n		height:20px;\r\n	}\r\n	\r\n	div.barPositions {\r\n		position:relative;\r\n	}\r\n	div.projectBar {\r\n		position:absolute;\r\n		height:10px;\r\n		z-index:2;\r\n		padding:0px;\r\n		margin:0px;\r\n		font-size:1pt;\r\n	}\r\n	div.statusBar {	\r\n		background-color:#000;\r\n		position:absolute;	\r\n		height:5px;\r\n		z-index:3;\r\n		padding:0px;\r\n		top:2px;\r\n		margin:0px;		\r\n		font-size:1pt;		\r\n	}\r\n	\r\n	div.projectLineH {		\r\n		background: url(\'images/dot.gif\') top repeat-x;		\r\n		font-size:1pt;\r\n		text-align:right;\r\n		position:absolute;\r\n	}		\r\n	div.projectLineV {\r\n		width:1px;\r\n		background-color:black;\r\n		position:relative;\r\n		font-size:1pt;	\r\n		height:100%;\r\n		float:right;\r\n	}\r\n	\r\n	div.projectLabel {\r\n		position:absolute;\r\n		margin-top:-3px;\r\n		white-space:nowrap;\r\n		font-family: verdana;\r\n		font-size:8px;\r\n	}\r\n	\r\n	div.milestone {\r\n		color:#000000;\r\n		position:absolute;\r\n		z-index:4;\r\n		margin:0px;\r\n		padding:0px;		\r\n		margin-top:-3px;\r\n		font-size: 10px;\r\n		font-family: times;\r\n	}\r\n	\r\n	#links {\r\n		margin-top:7px;\r\n		margin-left:5px;\r\n		font-family:arial;\r\n		font-size:9pt;\r\n	}\r\n	\r\n	#links a {\r\n		color:#7AB7E9;\r\n	}\r\n</style>\r\n\r\n<style>\r\n.popUp {\r\n			width:100%;\r\n			border:solid black 0px;\r\n			background-color:#F5F5F5;\r\n		}\r\n		.popUp td {\r\n			font-size:9pt;	\r\n			font-family:arial;\r\n			border-top:solid #E0E0E0 1px;\r\n		}	\r\n		.popUp tr.clear td {\r\n			border-style:none;\r\n			background-color:#F0F0F0;\r\n		}\r\n		.popUp tr.clearNoBG td {\r\n			border-style:none;\r\n		}\r\n		.popUp td.header {\r\n			font-weight:bold;\r\n		}\r\n		.popUp td span.header {\r\n			font-weight:bold;\r\n		}\r\n		a.saveBtn {\r\n			width:40px;\r\n			height:15px;\r\n			background-color:silver;\r\n			padding:1px;\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:white;\r\n			border:solid gray 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;\r\n			display:block;\r\n			float:right;\r\n			text-align:center;\r\n		}\r\n		a.saveBtn:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n</style>\r\n',0,1,0,1228264384),('cj2y4papTVGZRFdwTI-_fw',1147642475,'3','pbversion0000000000001','approved','MessageBoard','MessageBoard','root/import/messageboard','3','7','12',NULL,0,0,0,0,0,275,NULL,0,1,0,1147642475),('bBzO4CWjqU_ile3gf5Iypw',1147642475,'3','pbversion0000000000001','approved','MultiSearch','MultiSearch','root/import/multisearch','3','7','12',NULL,0,0,0,0,0,272,NULL,0,1,0,1147642475),('BFfNj5wA9bDw8H3cnr8pTw',1147642475,'3','pbversion0000000000001','approved','Navigation','Navigation','root/import/navigation','3','7','12',NULL,0,0,0,0,0,269,NULL,0,1,0,1147642475),('jEz8iTGNWEt2I05IhVV19Q',1147642477,'3','pbversion0000000000001','approved','Operation/RedeemSubscription','Operation/RedeemSubscription','root/import/operation/redeemsubscription','3','7','12',NULL,0,0,0,0,0,323,NULL,0,1,0,1147642477),('VZK3CRgiMb8r4dBjUmCTgQ',1147642477,'3','pbversion0000000000001','approved','Poll','Poll','root/import/poll','3','7','12',NULL,0,0,0,0,0,251,NULL,0,1,0,1147642477),('f_tn9FfoSfKWX43F83v_3w',1147642479,'3','pbversion0000000000001','approved','Search','Search','root/import/search','3','7','12',NULL,0,0,0,0,0,257,NULL,0,1,0,1147642479),('Da6KWn805L4B5e4HFgQRQA',1147642479,'3','pbversion0000000000001','approved','Shortcut','Shortcut','root/import/shortcut','3','7','12',NULL,0,0,0,0,0,263,NULL,0,1,0,1147642479),('bbiA9Zq5Gy2oCFBlILO3QA',1147642480,'3','pbversion0000000000001','approved','SQLReport','SQLReport','root/import/sqlreport','3','7','12',NULL,0,0,0,0,0,266,NULL,0,1,0,1147642480),('Efe2W0UgrSRDltNJ87jlfg',1147642480,'3','pbversion0000000000001','approved','StockData','StockData','root/import/stockdata','3','7','12',NULL,0,0,0,0,0,266,NULL,0,1,0,1147642480),('RrV4aAPnn4dM0ZcU3OXnlw',1147642480,'3','pbversion0000000000001','approved','style','style','root/import/style','3','7','12',NULL,0,0,0,0,0,254,NULL,0,1,0,1147642480),('oGfxez5sksyB_PcaAsEm_Q',1147642482,'3','pbversion0000000000001','approved','SyndicatedContent','SyndicatedContent','root/import/syndicatedcontent','3','7','12',NULL,0,0,0,0,0,290,NULL,0,1,0,1147642482),('9wKWdum0_8z-OhhquWLtSQ',1147642483,'3','pbversion0000000000001','approved','WeatherData','WeatherData','root/import/weatherdata','3','7','12',NULL,0,0,0,0,0,272,NULL,0,1,0,1147642483),('ErEzulFiEKDkaCDVmxUavw',1227566394,'3','pbversion0000000000001','approved','Default Inbox Error Template','Default Inbox Error Template','root/import/account/inbox/default-inbox-error-template','3','7','12',NULL,0,1,0,0,0,549,NULL,0,1,0,1234301430),('CSN-ZON7Uwv8kxf3F1fh5Q',1147642484,'3','pbversion0000000000001','approved','ZipArchiveAsset','ZipArchiveAsset','root/import/ziparchiveasset','3','7','12',NULL,0,0,0,0,0,284,NULL,0,1,0,1147642484),('TCtybxdqmdwdvRn555zpCQ',1147642484,'3','pbversion0000000000001','approved','RichEdit','RichEdit','root/import/richedit','3','7','12',NULL,0,0,0,0,0,263,NULL,0,1,0,1147642484),('PBtmpl0000000000000044',1148579524,'3','pbversion0000000000001','approved','Default Login Box','Default Login Box','default_login_box','3','7','12',NULL,0,1,0,0,0,1157,NULL,0,1,0,1228264382),('PBtmpl0000000000000092',1148579524,'3','pbversion0000000000001','approved','Horizontal Login Box','Horizontal Login Box','horizontal_login_box','3','7','12',NULL,0,1,0,0,0,1243,NULL,0,1,0,1228264382),('PBnav00000000000bullet',1148579524,'3','pbversion0000000000001','approved','Bulleted List','Bulleted List','bulleted_list','3','7','12',NULL,0,0,0,0,0,1488,'<style type=\"text/css\">\r\nul.bulletList li, ul.bulletList ul {\r\n	margin-left:7px;\r\n	padding-left:0px;\r\n	font-size:9px;	\r\n}\r\n\n.bulletList .level0 {\n	font-size:13px;\n}\n\r\n.bulletList .level1 {\r\n	font-size:11px;\r\n}\r\n</style>\n\n',0,1,0,1228264382),('pbtmpl0000000000000220',1148579525,'3','pbversion0000000000001','approved','Flash Template','Flash Template','flash-template','3','7','12',NULL,0,0,0,0,0,596,NULL,0,1,0,1228264382),('PBtmpl0000000000000133',1149286278,'3','pbversion0000000000001','approved','Guest Book','Guest Book','guest_book','3','7','12',NULL,0,1,0,0,0,1599,NULL,0,1,0,1228264382),('PBtmpl0000000000000083',1149286278,'3','pbversion0000000000001','approved','Link List','Link List','link_list','3','7','12',NULL,0,1,0,0,0,2046,NULL,0,1,0,1228264383),('PBtmpl0000000000000101',1149286278,'3','pbversion0000000000001','approved','Ordered List','Ordered List','ordered_list','3','7','12',NULL,0,1,0,0,0,2094,NULL,0,1,0,1228264383),('PBtmpl0000000000000121',1149286279,'3','pbversion0000000000001','approved','Photo Gallery','Photo Gallery','photo_gallery','3','7','12',NULL,0,1,0,0,0,2029,'<style type=\"text/css\">\n.picture {\r\n	padding: 0px;\r\n	margin: 10px;\r\n	float: left;\r\n	font-size: 12px;\r\n	width: 150px;\r\n	height: 100px;\r\n}\r\n\r\nhtml > body .picture {\r\nheight:auto;\r\nmin-height:150px;\r\nwidth:auto;\r\nmin-width:100px;\r\n}\n</style>\n\n',0,1,0,1228264383),('PBtmpl0000000000000079',1149286279,'3','pbversion0000000000001','approved','Topics','Topics','topics','3','7','12',NULL,0,1,0,0,0,3517,'<style type=\"text/css\">\n.postControls\n{\n	background:#676767;\n	color:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.postControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a\n{\n	color:white;\n	font-size:8pt;\n}\n.pagination a:hover {\n	text-decoration:none;\n}\n.topicsTitle\n{\n	-moz-box-sizing:border-box;\n	width:95%;\n	border-bottom:solid silver 1px;\n	margin-bottom:3px;\n	font-family:arial;\n}\n\n.topicContent\n{\n	-moz-box-sizing:border-box;\n	font-family:arial;\n	font-size:9pt;\n	width:95%;\n	display:block;\n	border:solid silver 1px;\n	padding:3px;\n}\n\n</style>\n',0,1,0,1228264383),('PBtmpl0000000000000082',1149286279,'3','pbversion0000000000001','approved','Unordered List','Unordered List','unordered_list','3','7','12',NULL,0,1,0,0,0,2985,'<style type=\"text/css\">\n.pagination {\r\n	-moz-box-sizing:border-box;\r\n	background:#676767;\n	color:#C0C0C0;\r\n	width:100%;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n}\r\n.pagination a {\r\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\r\n}\r\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n.unorderedList\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1228264383),('PBtmpl0000000000000112',1149286279,'3','pbversion0000000000001','approved','Weblog','Weblog','weblog','3','7','12',NULL,0,1,0,0,0,3490,'<style type=\"text/css\">\n.pagination {\r\n	-moz-box-sizing:border-box;\r\n	background:#676767;\n	color:#C0C0C0;\r\n	width:100%;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n}\r\n.pagination a {\r\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\r\n}\r\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n.weblogTitleBar {\n	font-weight: bold;\n	font-size: 14px;\n	font-family:arial;\n}\n\n.weblogLegend {\n	font-size: 9px;\n	color: #999999;\n	font-family:arial;\n}\n\n.weblogLegend a\n{\n	color:#29587E;\n}\n\n.weblogReadMore {\n	text-align: right;\n	font-size: 9px;\n	width: 100%;\n	font-family:arial;\n}\n\n.weblogSynopsis {\n	border: 1px solid #bbbbbb;\n	font-size: 13px;\n	padding: 5px;\n	-moz-border-radius: 6px;\n	font-family:arial;\n}\n</style>',0,1,0,1228264383),('PBtmpl0000000000000039',1154535073,'3','pbversion0000000000001','approved','Default File Macro','Default File Macro','default_file_macro','3','7','12',NULL,0,1,0,0,0,464,NULL,0,1,0,1228264383),('PBtmpl0000000000000055',1154535073,'3','pbversion0000000000001','approved','Default Poll','Default Poll','default_poll','3','7','12',NULL,0,1,0,0,0,2001,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.pollQuestion {\n	border-bottom:solid gray 1px;\n	font-family:arial;\n	font-size:10pt;\n	font-weight:bold;				\n}\n.pollColor {\n	background-color:gray;\n}\n</style>\n',0,1,0,1228264383),('Szs5eev3OMssmnsyLRZmWA',1213317790,'3','pbversion0000000000001','approved','Tell A Friend','Tell A Friend','tell_a_friend/tell_a_friend','3','7','3',NULL,0,1,0,0,0,2029,NULL,0,1,0,1213317790),('PBtmpl0000000000000111',1154535074,'3','pbversion0000000000001','approved','Make Page Printable','Make Page Printable','make_page_printable','3','7','12',NULL,0,1,0,0,0,2027,NULL,0,1,0,1228264383),('PBtmpl0000000000000053',1154535074,'3','pbversion0000000000001','approved','Subscription code redemption','Subscription code redemption','subscription_code_redemption','3','7','12',NULL,0,1,0,0,0,460,NULL,0,1,0,1228264383),('WikiPageEditTmpl000001',1221692341,'3','pbversion0000000000001','approved','Default Wiki Page Edit','Default Wiki Page Edit','default-wiki-page-edit','3','7','12',NULL,0,0,0,0,0,1316,'\n',0,1,0,1228264384),('PBtmpl0000000000000097',1154535074,'3','pbversion0000000000001','approved','Traditional with Thumbnails','Traditional with Thumbnails','traditional_with_thumbnails','3','7','12',NULL,0,1,0,0,0,4463,'<style type=\"text/css\">\n.forumHead {\n	background-color: #DADADA;\n	border: 2px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n	font-family:arial;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;	\n	font-family:arial;\n}\n.forumHead a\n{\n	color:#29587E;\n}\n.oddThread a\n{\n	color:#29587E;\n}\n.evenThread a\n{\n	color:#29587E;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n	background-color:#EEEEEE;\n	font-family:arial;\n}\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.pagination a:hover {\n	text-decoration:none;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1228264383),('PBnav00000000indentnav',1154535074,'3','pbversion0000000000001','approved','Indent Nav','Indent Nav','indent_nav','3','7','12',NULL,0,0,0,0,0,1560,'<style type=\"text/css\">\n.mainNav {\n\n}\n.mainNav a {\n\n}\na.navOn {\n\n}\na.anAncestor {\n\n}\ndiv.level0 a {\n	margin-left:0px;\n	display:block;\n}\ndiv.level1 a {\n	margin-left:15px;\n	display:block;	\n}\ndiv.level2 a {\n	margin-left:30px;\n	display:block;\n}\ndiv.level3 a {\n	margin-left:45px;\n	display:block;\n}\ndiv.level4 a {\n	margin-left:60px;\n	display:block;\n}\n</style>\n',0,1,0,1228264383),('ProjectManagerTMPL0006',1157679165,'3','pbversion0000000000001','approved','Default Resource List','Default Resource List','default-pm-resource-list','3','7','12',NULL,0,0,0,0,0,1100,NULL,0,1,0,1228264383),('PBtmpl0000000000000002',1159989349,'3','pbversion0000000000001','approved','Default Article','Default Article','default_article','3','7','12',NULL,0,1,0,0,0,1507,NULL,0,1,0,1228264383),('ProjectManagerTMPL0003',1159989349,'3','pbversion0000000000001','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,2137,NULL,0,1,0,1228264383),('pbproto000000000000002',1163019036,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-prototype','3','7','12',NULL,0,0,0,1,0,488,NULL,0,1,0,1163019036),('WikiPHTmpl000000000001',1165460175,'3','pbversion0000000000001','approved','Default Page History','Default Page History','default-wiki-page-history','3','7','12',NULL,0,0,0,0,0,486,NULL,0,1,0,1228264383),('WikiMPTmpl000000000001',1165460175,'3','pbversion0000000000001','approved','Default Most Popular','Default Most Popular','default-wiki-most-popular','3','7','12',NULL,0,0,0,0,0,675,NULL,0,1,0,1228264383),('IOB0000000000000000002',1166019641,'3','pbversion0000000000001','approved','Default InOutBoard Report Template','Default InOutBoard Report Template','iob-report-template','3','7','12',NULL,0,0,0,0,0,2116,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob a {\n	color:#29587E;\n}\n.iob .formDescription {\n	background-color:#DADADA;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}\n</style>',0,1,0,1228264383),('WikiSearchTmpl00000001',1168480840,'3','pbversion0000000000001','approved','Default Wiki Search','Default Wiki Search','default-wiki-search','3','7','12',NULL,0,0,0,0,0,1393,'\n\n',0,1,0,1228264383),('WikiRCTmpl000000000001',1169092823,'3','pbversion0000000000001','approved','Default Recent Changes','Default Recent Changes','default-wiki-recent-changes','3','7','12',NULL,0,0,0,0,0,1004,NULL,0,1,0,1228264383),('ZipArchiveTMPL00000001',1169738426,'3','pbversion0000000000001','approved','Default Zip Archive Template','Default Zip Archive Template','zip-archive-template','3','7','12',NULL,0,0,0,0,0,706,NULL,0,1,0,1228264383),('IOB0000000000000000001',1169795123,'3','pbversion0000000000001','approved','Default InOutBoard Template','Default InOutBoard Template','iob-template','3','7','12',NULL,0,0,0,0,0,2715,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob {\n			\n}	\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob td.odd {\n	background-color:#DADADA;\n}\n.iob td.noBorder {\n	border:none;\n}	\n.iob a {\n	color:#29587E;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}   \n\n</style>',0,1,0,1228264383),('PBtmpl0000000000000142',1171466654,'3','pbversion0000000000001','approved','Default RSS','Default RSS','pbtmpl0000000000000142','3','7','12',NULL,0,1,0,0,0,731,NULL,0,1,0,1228264383),('PBtmpl0000000000000080',1171466654,'3','pbversion0000000000001','approved','FAQ','FAQ','faqtemplate','3','7','12',NULL,0,1,0,0,0,2167,NULL,0,1,0,1228264383),('SQLReportDownload00001',1171466654,'3','pbversion0000000000001','approved','SQLReport Download Default Template','untitled','SQLReportDownload0001','3','7','12',NULL,0,0,0,0,0,3664,NULL,0,1,0,1228264383),('newsletter000000000001',1185754569,'3','pbversion0000000000001','approved',' Summary Newsletter (default)',' Summary Newsletter','newsletterdefaulttemplate','3','7','3',NULL,0,0,0,0,0,498,NULL,0,1,0,1228264383),('PBtmpl0000000000000026',1185754569,'3','pbversion0000000000001','approved','Default Forum','Default Forum','default_forum','3','7','12',NULL,0,1,0,0,0,4871,'<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n',0,1,0,1228264383),('PBtmpl0000000000000010',1227026287,'3','pbversion0000000000001','approved','Default WebGUI Account Display Template','Default WebGUI Account Display Template','default_webgui_account_display_template','3','7','12',NULL,0,1,0,0,0,1616,NULL,0,1,0,1239804541),('PBtmpl0000000000000014',1227218041,'3','pbversion0000000000001','approved','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template','default_webgui_password_recovery_template','3','7','12',NULL,0,1,0,0,0,1741,NULL,0,1,0,1228264385),('PBtmpl0000000000000004',1227026214,'3','pbversion0000000000001','approved','Default LDAP Account Display Template','Default LDAP Account Display Template','default_ldap_account_display_template','3','7','12',NULL,0,1,0,0,0,898,NULL,0,1,0,1239804541),('WikiKeyword00000000001',1185754571,'3','pbversion0000000000001','approved',' Wiki Pages By Keyword (default)',' Wiki Pages By Keyword','wiki-master-by-keyword-template.tmpl','3','7','3',NULL,0,0,0,0,0,474,NULL,0,1,0,1228264383),('WikiFrontTmpl000000001',1185754572,'3','pbversion0000000000001','approved','Default Wiki Front Page','Default Wiki Front Page','default-wiki-front-page','3','7','12',NULL,0,0,0,0,0,1322,NULL,0,1,0,1228264383),('tempspace0000000000000',1185754574,'3','pbversion0000000000001','approved','Tempspace','Tempspace','tempspace','3','7','3',NULL,0,0,0,0,0,270,NULL,0,1,0,1185754574),('MBZK_LPVzqhb4TV4mMRTJg',1197330678,'3','pbversion0000000000001','approved','admin_ie7.css','admin_ie7.css','root/import/gallery-templates/admin_ie7.css','3','7','3',NULL,0,1,0,0,0,330,NULL,0,1,0,1244573916),('kaPRSaf8UKiskiGEgJgLAw',1197330678,'3','pbversion0000000000001','approved','images','images','root/import/gallery-templates/images','3','7','3',NULL,0,0,0,0,0,317,NULL,0,1,0,1244573916),('bANo8aiAPA7aY_oQZKxIWw',1197330678,'3','pbversion0000000000001','approved','rss.gif','rss.gif','root/import/gallery-templates/images/rss.gif','3','7','3',NULL,0,1,0,0,0,1388,NULL,0,1,0,1244573916),('fdd8tGExyVwHyrB8RBbKXg',1197330839,'3','pbversion0000000000001','approved','next.gif','next.gif','root/import/gallery-templates/images/next.gif','3','7','3',NULL,0,1,0,0,0,1675,NULL,0,1,0,1244573916),('BpisgHl4ZDcSECJp6oib1w',1197330840,'3','pbversion0000000000001','approved','play.gif','play.gif','root/import/gallery-templates/images/play.gif','3','7','3',NULL,0,1,0,0,0,2112,NULL,0,1,0,1244573916),('zshreRgPAXtnF0DtVbQ1Yg',1197330840,'3','pbversion0000000000001','approved','previous.gif','previous.gif','root/import/gallery-templates/images/previous.gif','3','7','3',NULL,0,1,0,0,0,1681,NULL,0,1,0,1244573916),('TimeTrackingTMPL000001',1201205738,'3','pbversion0000000000001','approved','Default Time Tracking User View','Default Time Tracking User View','default-tt-template-user','3','7','12',NULL,0,0,0,0,0,10402,'\n	<style type=\"text/css\">\n		.timeTracking02 {			\n			width:850px;\n		}\n		.timeTracking02 td {\n			border:solid silver 1px;\n			border-bottom:solid gray 1px;\n			font-size:9pt;\n			font-family:arial;			\n		}\n		tr.tt_title td {\n			font-weight:bold;			\n			background-color:#F0F0F0;\n			border-style:none;\n			font-size:11pt;\n		}\n		tr.tt_header td {\n			font-weight:bold;\n			text-align:center;		\n		}\n		tr.tt_empty td {\n			border-style:none;\n		}\n		\n		a.PM_blueLink {\n			color:#29587E;\n			text-decoration:none;\n			font-weight:bold;\n		}\n		a.PM_blueLink:hover {\n			text-decoration:underline;\n		}	\n		\n		.pt-select {\n	       font-weight: normal;\n	       color: black;\n  	       width: 175px;\n        }\n		.date-select {\n		   font-weight: normal;\n	           color: black;\n  	           width: 110px;\n		}\n	</style>\n',0,1,0,1228264383),('PBtmpl0000000000000085',1202884864,'3','pbversion0000000000001','approved','Default Email','Default Email','default_email','3','7','12',NULL,0,1,0,0,0,1175,NULL,0,1,0,1228264383),('CalendarPrintMonth0001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Month','Default Calendar Print Month','root/import/calendar-templates/default-calendar-print-month','3','7','12',NULL,0,0,0,0,0,2151,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1228264383),('CalendarPrintWeek00001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Week','Default Calendar Print Week','root/import/calendar-templates/default-calendar-print-week','3','7','12',NULL,0,0,0,0,0,2249,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1228264383),('CalendarPrintDay000001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Day','Default Calendar Print Day','root/import/calendar-templates/default-calendar-print-day','3','7','12',NULL,0,0,0,0,0,2117,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1228264383),('PBtmpl0000000000000067',1206998733,'3','pbversion0000000000001','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,14012,'<style type=\"text/css\">\r\n.defaultSubmissionDetails\r\n{\r\n	float: right; 		\r\n	padding: 2px; \r\n	margin: 2px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-bottom:20px;\r\n}\r\n\r\n.defaultSubmissionDetails a\r\n{\r\n	color:#29587E;\r\n}\r\n\r\n.postBorder {\r\n	border: 1px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postBorderCurrent {\r\n	border: 3px dotted black;\r\n	margin-bottom: 10px;\r\n}\r\n.postSubject {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-weight: bold;\r\n	padding: 3px;\r\n	font-family:arial;\r\n}\r\n.postData {\r\n	border-bottom: 1px solid #cccccc;\r\n	background-color: #eeeeee;\r\n	padding: 3px;\r\n}\r\n.postData td {\r\n	font-size: 9pt;\r\n	color: black;\r\n	font-family:arial;\r\n}\r\n.postControls {\r\n	border-top: 1px solid #cccccc;\r\n	background-color: #676767;\r\n	color: black;\r\n	padding: 3px;\r\n	font-family:arial;\r\n	clear:both;\r\n	width:100%;\r\n	display:block;\r\n	-moz-box-sizing:border-box;\r\n	text-align:right;\r\n	margin-top:1px;\r\n}\r\n.postControls a:link, .postControls a:visited\r\n{\r\n	text-decoration:underline;\r\n	color:white;\r\n}\r\n.postControls a:hover {\r\n	text-decoration:none;\r\n}\r\n.postMessage {\r\n	padding: 3px;\r\n}\r\n.currentThread {\r\n	background-color: #eeeeee;\r\n}\r\n.threadHead {\r\n	font-weight: bold;\r\n	border-bottom: 1px solid #cccccc;\r\n	font-size: 9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n	font-family:arial;\r\n}\r\n.threadData {\r\n	font-size: 11px;\r\n	padding: 3px;\r\n	font-family:arial;\r\n}\r\n\r\n\r\n.collaborationThreadContent\r\n{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n\r\n</style>\r\n',0,1,0,1228264383),('PBtmpl0000000000000032',1206998756,'3','pbversion0000000000001','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,7847,'<style type=\"text/css\">\r\n	.postBorder {\r\n		border: 1px solid #cccccc;\r\n		margin-bottom: 10px;\r\n	}\r\n 	.postBorderCurrent {\r\n		border: 3px dotted black;\r\n		margin-bottom: 10px;\r\n	}\r\n	.postSubject {\r\n		border-bottom: 1px solid #cccccc;\r\n		font-weight: bold;\r\n		padding: 3px;\r\n	}\r\n	.postData {\r\n		border-bottom: 1px solid #cccccc;\r\n		font-size: 9pt;\r\n		background-color: #eeeeee;\r\n		color: black;\r\n		padding: 3px;\r\n	}\r\n	.postData a {\r\n		color:#29587E;\r\n		text-decoration:underline;\r\n	}\r\n	.postData a:hover {\r\n		text-decoration:none;\r\n	}\r\n	.postControls {\r\n		border-top: 1px solid #cccccc;\r\n		background-color: #676767;\r\n		color: black;\r\n		padding: 3px;\r\n		text-align:right;\r\n	}\r\n	.postControls a:link, .postControls a:visited {\r\n		color:white;\r\n		text-decoration:underline;\r\n	}\r\n	.postControls a:hover {\r\n		text-decoration:none;\r\n	}\r\n	.bottomControls {\r\n		background-color:#676767;\r\n		padding: 3px;\r\n		text-align:right;\r\n	}\r\n	.bottomControls a:link, .bottomControls a:visited {\r\n		color:white;\r\n		text-decoration:underline;\r\n	}	\r\n	.bottomControls a:hover {\r\n		text-decoration:none;\r\n	}\r\n	.postMessage {\r\n		padding: 3px;\r\n	}\r\n	.currentThread {\r\n		background-color: #eeeeee;\r\n	}\r\n	.threadHead {\r\n		font-weight: bold;\r\n		border-bottom: 1px solid #cccccc;\r\n		font-size: 9pt;\r\n		background-color: #eeeeee;\r\n		color: black;\r\n		padding: 3px;\r\n	}\r\n	.threadData {\r\n		font-size: 11px;\r\n		padding: 3px;\r\n	}\r\n</style>\r\n',0,1,0,1228264383),('PBtmpl0000000000000209',1206998862,'3','pbversion0000000000001','approved','Request Tracker Thread','Request Tracker Thread','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,14030,'<style type=\"text/css\">\r\n.defaultSubmissionDetails\r\n{\r\n	float: right; 		\r\n	padding: 2px; \r\n	margin: 2px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-bottom:20px;\r\n}\r\n\r\n.defaultSubmissionDetails a\r\n{\r\n	color:#29587E;\r\n}\r\n\r\n.postBorder {\r\n	border: 1px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postBorderCurrent {\r\n	border: 3px dotted black;\r\n	margin-bottom: 10px;\r\n}\r\n.postSubject {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-weight: bold;\r\n	padding: 3px;\r\n	font-family:arial;\r\n}\r\n.postData {\r\n	border-bottom: 1px solid #cccccc;\r\n	background-color: #eeeeee;\r\n	padding: 3px;\r\n}\r\n.postData td {\r\n	font-size: 9pt;\r\n	color: black;\r\n	font-family:arial;\r\n}\r\n.postControls {\r\n	border-top: 1px solid #cccccc;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n	font-family:arial;\r\n	clear:both;\r\n	width:100%;\r\ndisplay:block;\r\n	-moz-box-sizing:border-box;\r\n}\r\n.postMessage {\r\n	padding: 3px;\r\n}\r\n.currentThread {\r\n	background-color: #eeeeee;\r\n}\r\n.threadHead {\r\n	font-weight: bold;\r\n	border-bottom: 1px solid #cccccc;\r\n	font-size: 9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n	font-family:arial;\r\n}\r\n.threadData {\r\n	font-size: 11px;\r\n	padding: 3px;\r\n	font-family:arial;\r\n}\r\n\r\n.postControls\r\n{\r\n	background:#676767;\r\n	display:block;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-top: 1px;	\r\n}\r\n.postControls a:link, .postControls a:visited\r\n{\r\n	color:white;\r\n	text-decoration:underline;\r\n}\r\n.postControls a:hover {\r\n	text-decoration:none;\r\n}\r\n.collaborationThreadContent\r\n{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n</style>\r\n',0,1,0,1228264383),('FOvmwGC0GtZo5VTxJIL3OA',1207068851,'3','pbversion0000000000001','approved','Get Documentation','Get Documentation','yns/docs','3','7','4',NULL,0,1,0,0,0,595,NULL,0,1,0,1207068851),('PBrichedit000000000001',1207240829,'3','pbversion0000000000001','approved','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit','content_managers_rich_edit','3','7','12',NULL,0,0,0,0,0,538,NULL,0,1,0,1207240829),('3qiVYhNTXMVC5hfsumVHgg',1206743306,'3','pbversion0000000000001','approved','browserdetect.js','browserdetect.js','root/import/gallery-templates/browserdetect.js','3','7','3',NULL,0,1,0,0,0,2691,NULL,0,1,0,1244573917),('F7MAQ-cpuvQ1KuC7J4P5zQ',1222803673,'3','pbversion0000000000001','approved','View','View','root/import/profile/view','3','7','12',NULL,0,0,0,0,0,294,NULL,0,1,0,1222803673),('Tsg7xmPYv782j6IVz7yHFg',1213244777,'3','pbversion0000000000001','approved','Calendar Templates','Calendar Templates','root/import/calendar-templates','3','7','12',NULL,0,1,0,0,0,317,NULL,0,1,0,1213244777),('-K8Hj45mbelljN9-0CXZxg',1209325764,'3','pbversion0000000000001','approved','DataForm','DataForm','root/import/dataform','3','7','12',NULL,0,0,0,0,0,300,NULL,0,1,0,1209325764),('Q4uX_C557arTp6D_jwB1jQ',1222803760,'3','pbversion0000000000001','approved','Wiki','Wiki','root/import/wiki','3','12','12',NULL,0,0,0,0,0,280,NULL,0,1,0,1222803760),('4qh0kIsFUdd4Ox-Iu1JZgg',1208725439,'3','pbversion0000000000001','approved','EMS','EMS','root/import/ems','3','7','12',NULL,0,1,0,0,0,285,NULL,0,1,0,1208725439),('PsFn7dJt4wMwBa8hiE3hOA',1208558071,'3','pbversion0000000000001','approved','Print Badge (Default)','Print Badge (Default)','root/import/ems/print-badge-default','3','7','12',NULL,0,1,0,0,0,1417,NULL,0,1,0,1228264384),('yBwydfooiLvhEFawJb0VTQ',1208629936,'3','pbversion0000000000001','approved','Print Ticket (Default)','Print Ticket (Default)','root/import/ems/print-ticket-default','3','7','12',NULL,0,1,0,0,0,1449,NULL,0,1,0,1228264384),('aNNC62qLAS6TB-0_MCYjsw',1213283425,'3','pbversion0000000000001','approved','Layout','Layout','root/import/layout','3','7','12',NULL,0,0,0,0,0,281,NULL,0,1,0,1213283425),('NywJYmGWe1f6EBXJnWg9Xg',1222803638,'3','pbversion0000000000001','approved','Profile','Profile','root/import/profile','3','7','12',NULL,0,1,0,0,0,288,NULL,0,1,0,1222803638),('AgyFhx3eXlfZXNp2MkrsiQ',1222803665,'3','pbversion0000000000001','approved','Edit','Edit','root/import/profile/edit','3','7','12',NULL,0,0,0,0,0,294,NULL,0,1,0,1222803665),('_hELmIJfgbAyXFNqPyApxQ',1213309523,'3','pbversion0000000000001','approved','admin.css','admin.css','root/import/gallery-templates/admin.css','3','7','3',NULL,0,1,0,0,0,2041,NULL,0,1,0,1244573916),('2ci_v2d4x4uvyjTRlC49OA',1209499188,'3','pbversion0000000000001','approved','moveDown.gif','moveDown.gif','root/import/gallery-templates/images/movedown.gif','3','7','3',NULL,0,1,0,0,0,783,NULL,0,1,0,1244573916),('O-EsSzKgAk1KolFT-x_KsA',1209499188,'3','pbversion0000000000001','approved','moveUp.gif','moveUp.gif','root/import/gallery-templates/images/moveup.gif','3','7','3',NULL,0,1,0,0,0,771,NULL,0,1,0,1244573916),('POVcY79vIqAHR8OfGt36aw',1209499189,'3','pbversion0000000000001','approved','pagination_button.jpg','pagination_button.jpg','root/import/gallery-templates/images/pagination_button.jpg','3','7','12',NULL,0,1,0,0,0,1049,NULL,0,0,0,1244573916),('hIB-z34r8Xl-vYVYCkKr-w',1209499189,'3','pbversion0000000000001','approved','bar-btn-r.jpg','bar-btn-r.jpg','root/import/gallery-templates/images/bar-btn-r.jpg','3','7','12',NULL,0,1,0,0,0,829,NULL,0,0,0,1244573916),('-mPUoFlYcjqjPUPRLAlxNQ',1209499189,'3','pbversion0000000000001','approved','search-field-r.jpg','search-field-r.jpg','root/import/gallery-templates/images/search-field-r.jpg','3','7','12',NULL,0,1,0,0,0,847,NULL,0,0,0,1244573916),('MDpUOR-N8KMyt1J7Hh_h4w',1209499189,'3','pbversion0000000000001','approved','bar-btn.jpg','bar-btn.jpg','root/import/gallery-templates/images/bar-btn.jpg','3','7','12',NULL,0,1,0,0,0,707,NULL,0,0,0,1244573916),('YfXKByTwDZVituMc4h13Dg',1209499189,'3','pbversion0000000000001','approved','pagination_bg.jpg','pagination_bg.jpg','root/import/gallery-templates/images/pagination_bg.jpg','3','7','12',NULL,0,1,0,0,0,1130,NULL,0,0,0,1244573916),('esko_HSU0Gh-uJZ1h3xRmQ',1209499189,'3','pbversion0000000000001','approved','search-field-l.jpg','search-field-l.jpg','root/import/gallery-templates/images/search-field-l.jpg','3','7','12',NULL,0,1,0,0,0,873,NULL,0,0,0,1244573916),('oSqpGswzpBG_ErdfYwIO8A',1209499189,'3','pbversion0000000000001','approved','top_bg.jpg','top_bg.jpg','root/import/gallery-templates/images/top_bg.jpg','3','7','12',NULL,0,1,0,0,0,691,NULL,0,0,0,1244573916),('MXJklShZvLLB_DSnZQmXrQ',1209499189,'3','pbversion0000000000001','approved','title_bg.jpg','title_bg.jpg','root/import/gallery-templates/images/title_bg.jpg','3','7','12',NULL,0,1,0,0,0,1657,NULL,0,0,0,1244573916),('BthxD5oJ0idmsyI3ioA2FA',1209499189,'3','pbversion0000000000001','approved','bar-btn-l.jpg','bar-btn-l.jpg','root/import/gallery-templates/images/bar-btn-l.jpg','3','7','12',NULL,0,1,0,0,0,844,NULL,0,0,0,1244573916),('aZ-1HYQamkRHYXvzAra8WQ',1209499189,'3','pbversion0000000000001','approved','search-field.jpg','search-field.jpg','root/import/gallery-templates/images/search-field.jpg','3','7','12',NULL,0,1,0,0,0,749,NULL,0,0,0,1244573916),('eRkb94OYcS5AdcrrerOP5Q',1209499189,'3','pbversion0000000000001','approved','rss.gif','rss.gif','root/import/gallery-templates/images/rss2.gif','3','7','12',NULL,0,1,0,0,0,1390,NULL,0,0,0,1244573916),('TbnkjAJQEASORXIpYqDkcA',1209499189,'3','pbversion0000000000001','approved','blank-image.jpg','blank-image.jpg','root/import/gallery-templates/images/blank-image.jpg','3','7','12',NULL,0,1,0,0,0,3083,NULL,0,0,0,1244573916),('er-3faBjY-hhlDcc5aKqdQ',1209499189,'3','pbversion0000000000001','approved','top_bg.jpg','top_bg.jpg','root/import/gallery-templates/images/top_bg2.jpg','3','7','12',NULL,0,1,0,0,0,692,NULL,0,0,0,1244573916),('8bFsu2FJUqHRUiHcozcVFw',1209499189,'3','pbversion0000000000001','approved','sub-btn-l.jpg','sub-btn-l.jpg','root/import/gallery-templates/images/sub-btn-l.jpg','3','7','12',NULL,0,1,0,0,0,843,NULL,0,0,0,1244573916),('34Aayx5eA320D8VfhdfDBw',1209499189,'3','pbversion0000000000001','approved','sub-btn-r.jpg','sub-btn-r.jpg','root/import/gallery-templates/images/sub-btn-r.jpg','3','7','12',NULL,0,1,0,0,0,823,NULL,0,0,0,1244573916),('TlhKOVmWblZOsAdqmhEpeg',1209499189,'3','pbversion0000000000001','approved','sub-btn.jpg','sub-btn.jpg','root/import/gallery-templates/images/sub-btn.jpg','3','7','12',NULL,0,1,0,0,0,701,NULL,0,0,0,1244573916),('Nx0ypjO3cN6QdZUBUEE0lA',1209499189,'3','pbversion0000000000001','approved','pic-title-bg.jpg','pic-title-bg.jpg','root/import/gallery-templates/images/pic-title-bg.jpg','3','7','12',NULL,0,1,0,0,0,864,NULL,0,0,0,1244573916),('CmFZLN7iPS7XXvUEsxKPKA',1209499190,'3','pbversion0000000000001','approved','row-2.jpg','row-2.jpg','root/import/gallery-templates/images/row-2.jpg','3','7','12',NULL,0,1,0,0,0,805,NULL,0,0,0,1244573916),('v_XBgwwZqgW1D5s4y05qfg',1209499190,'3','pbversion0000000000001','approved','addtl-info.gif','addtl-info.gif','root/import/gallery-templates/images/addtl-info.gif','3','7','12',NULL,0,1,0,0,0,913,NULL,0,0,0,1244573917),('4TdAkKoQbSCvI7QWcW889A',1209499190,'3','pbversion0000000000001','approved','row-1.jpg','row-1.jpg','root/import/gallery-templates/images/row-1.jpg','3','7','12',NULL,0,1,0,0,0,790,NULL,0,0,0,1244573917),('SAgK6eDPCG1cgkJ59WapHQ',1209499190,'3','pbversion0000000000001','approved','prev-btn.gif','prev-btn.gif','root/import/gallery-templates/images/prev-btn.gif','3','7','12',NULL,0,1,0,0,0,2014,NULL,0,0,0,1244573917),('XJYLuvGy9ubF7JNKyINtpA',1209499190,'3','pbversion0000000000001','approved','play-btn.gif','play-btn.gif','root/import/gallery-templates/images/play-btn.gif','3','7','12',NULL,0,1,0,0,0,2542,NULL,0,0,0,1244573917),('RWj7hyv2SpZuXxwj1Wocug',1209499190,'3','pbversion0000000000001','approved','next-btn.gif','next-btn.gif','root/import/gallery-templates/images/next-btn.gif','3','7','12',NULL,0,1,0,0,0,2044,NULL,0,0,0,1244573917),('aq8QElnlm3YufAoxRz9Pcg',1209499190,'3','pbversion0000000000001','approved','data-bg.jpg','data-bg.jpg','root/import/gallery-templates/images/data-bg.jpg','3','7','12',NULL,0,1,0,0,0,820,NULL,0,0,0,1244573917),('7fE8md51vTCcuJFOvxNaGA',1209503742,'3','pbversion0000000000001','approved','thumbnails.js','thumbnails.js','root/import/gallery-templates/thumbnails.js','3','7','3',NULL,0,1,0,0,0,3943,NULL,0,1,0,1244573917),('mTOiwwk3q4k9g5-XykXhPA',1218149728,'3','pbversion0000000000001','approved','Documentation','Documentation','documentation','3','7','3',NULL,0,0,0,0,0,506,NULL,0,1,0,1218149728),('TYo2Bwl7aafzTtdHlS-arQ',1211664878,'3','pbversion0000000000001','approved','Product','Product','root/import/product','3','7','12',NULL,0,0,0,0,0,284,NULL,0,1,0,1211664878),('gbnRhcWNk1iQe32LFEB5eQ',1212086102,'3','pbversion0000000000001','approved','Shelf','Shelf','root/import/shelf2','3','7','12',NULL,0,1,0,0,0,279,NULL,0,1,0,1212086102),('6tK47xsaIH-ELw0IBo0uRQ',1210777115,'3','pbversion0000000000001','approved','images','images','root/import/shelf2/images','3','7','12',NULL,0,1,0,0,0,294,NULL,0,1,0,1210777115),('_bZJ9LA_KNekZiFPaP2SeQ',1210777868,'3','pbversion0000000000001','approved','shelf-titles.jpg','shelf-titles.jpg','root/import/shelf2/images/shelf-titles.jpg','3','7','12',NULL,0,1,0,0,0,1027,NULL,0,0,0,1210777868),('4e-_rNs6mSWedZhQ_V5kJA',1210779672,'3','pbversion0000000000001','approved','shelf-ie.css','shelf-ie.css','root/import/shelf2/shelf-ie.css','3','7','12',NULL,0,1,0,0,0,693,NULL,0,1,0,1210779672),('6D4Z-oruXPS6OlH_Kx8pBg',1209509389,'3','pbversion0000000000001','approved','images','images','root/import/thingy-templates/images','3','7','12',NULL,0,1,0,0,0,304,NULL,0,1,0,1209509389),('hQ7z33_jOYkQ8WNX5xy9Sw',1209509455,'3','pbversion0000000000001','approved','style-button.gif','style-button.gif','root/import/thingy-templates/images/style-button.gif','3','7','12',NULL,0,1,0,0,0,912,NULL,0,0,0,1209509455),('vWW_DcHiYSrKZOkkIfEfcQ',1209509433,'3','pbversion0000000000001','approved','row-2.jpg','row-2.jpg','root/import/thingy-templates/images/row-2.jpg','3','7','12',NULL,0,1,0,0,0,794,NULL,0,0,0,1209509433),('_bPYzRA87NTAUIKlfrJMHg',1209509433,'3','pbversion0000000000001','approved','row-1.jpg','row-1.jpg','root/import/thingy-templates/images/row-1.jpg','3','7','12',NULL,0,1,0,0,0,779,NULL,0,0,0,1209509433),('nJjZHRwdDs5MAZYsAyioHw',1209509433,'3','pbversion0000000000001','approved','title-bg.jpg','title-bg.jpg','root/import/thingy-templates/images/title-bg.jpg','3','7','12',NULL,0,1,0,0,0,1094,NULL,0,0,0,1209509433),('8hxfkrJPeFVRWF5piCNJ1A',1209509433,'3','pbversion0000000000001','approved','field-bg.jpg','field-bg.jpg','root/import/thingy-templates/images/field-bg.jpg','3','7','12',NULL,0,1,0,0,0,710,NULL,0,0,0,1209509433),('Osx7WN52iIKHZFT4vqUBHQ',1209509433,'3','pbversion0000000000001','approved','search-btn.gif','search-btn.gif','root/import/thingy-templates/images/search-btn.gif','3','7','12',NULL,0,1,0,0,0,1252,NULL,0,0,0,1209509433),('oWff8fGzRdHPyq5VNREe9Q',1209509433,'3','pbversion0000000000001','approved','top-bg.jpg','top-bg.jpg','root/import/thingy-templates/images/top-bg.jpg','3','7','12',NULL,0,1,0,0,0,680,NULL,0,0,0,1209509433),('uqbkvb1b9443VvfkyRz95w',1209509433,'3','pbversion0000000000001','approved','save-button.gif','save-button.gif','root/import/thingy-templates/images/save-button.gif','3','7','12',NULL,0,1,0,0,0,1260,NULL,0,0,0,1209509433),('8YiMkcz32xalkAn3WBLpag',1210181860,'3','pbversion0000000000001','approved','go-btn.gif','go-btn.gif','root/import/thingy-templates/images/go-btn.gif','3','7','12',NULL,0,1,0,0,0,419,NULL,0,0,0,1210181860),('C5fPz-Wg85vkYRvCdl-Xqw',1212160830,'3','pbversion0000000000001','approved','UserList','UserList','root/import/userlist','3','7','12',NULL,0,1,0,0,0,287,NULL,0,1,0,1212160830),('usuxw9V3jN4d4pujRiEYxg',1209494150,'3','pbversion0000000000001','approved','css03-ie.css','css03-ie.css','style3/css03-ie.css','3','7','12',NULL,0,0,0,0,0,287,NULL,0,1,0,1209494150),('aNmgn0cd6tldmC1FpW4KbA',1213122695,'3','pbversion0000000000001','approved','Shop','Shop','shopping-cart-collateral-items','3','7','3',NULL,0,1,0,0,0,288,NULL,0,0,0,1213122695),('2q5fxatSFLgIhXaUX-oSvg',1204149033,'3','pbversion0000000000001','approved','bottom-left.jpg','bottom-left.jpg','shopping-cart-collateral-items/bottom-left.jpg','3','7','3',NULL,0,1,0,0,0,32243,NULL,0,0,0,1204149033),('_d5WTkKjnwct-_Dk7gZHvQ',1204149033,'3','pbversion0000000000001','approved','bottom-right.jpg','bottom-right.jpg','shopping-cart-collateral-items/bottom-right.jpg','3','7','3',NULL,0,1,0,0,0,32247,NULL,0,0,0,1204149033),('Iz2mUR3jCPKyemwAea4b2g',1204149033,'3','pbversion0000000000001','approved','input_bg.jpg','input_bg.jpg','shopping-cart-collateral-items/input_bg.jpg','3','7','3',NULL,0,1,0,0,0,30065,NULL,0,0,0,1204149033),('JU9bjsLRoWj7GVHs__prig',1204149033,'3','pbversion0000000000001','approved','top-left.jpg','top-left.jpg','shopping-cart-collateral-items/top-left.jpg','3','7','3',NULL,0,1,0,0,0,32196,NULL,0,0,0,1204149033),('noOlnjQGexHg8c4bGVUo9g',1204149033,'3','pbversion0000000000001','approved','top-right.jpg','top-right.jpg','shopping-cart-collateral-items/top-right.jpg','3','7','3',NULL,0,1,0,0,0,32234,NULL,0,0,0,1204149033),('bPz1yk6Y9uwMDMBcmMsSCg',1211829604,'3','pbversion0000000000001','approved','Email Receipt (Default)','Email Receipt (Default)','shopping-cart-collateral-items/email-receipt-default','3','7','3',NULL,0,1,0,0,0,2895,NULL,0,1,0,1228264384),('EBlxJpZQ9o-8VBOaGQbChA',1212093746,'3','pbversion0000000000001','approved','MiniCart','MiniCart','shopping-cart-collateral-items/minicart','3','7','3',NULL,0,1,0,0,0,2295,'<style>\r\n	.wgMiniCart * a:link,\r\n	.wgMiniCart * a:visited {\r\n		color:black;\r\n	}\r\n	.wgMiniCart{\r\n		background:#f1f1f1;\r\n		border:solid #e0e0e0 1px;\r\n		-moz-border-radius:15px;\r\n	}\r\n	.wgMiniCart h2.title {\r\n		background-color:#e0e0e0;\r\n		margin:0px;\r\n		-moz-border-radius-topLeft:15px;\r\n		-moz-border-radius-topRight:15px;\r\n		padding:3px;\r\n		border-bottom:solid white 1px;\r\n	}\r\n	.wgMiniCart .items {\r\n		border-top:solid #e0e0e0 1px;\r\n	}\r\n	.wgMiniCart .item {\r\n		border-bottom:solid #e0e0e0 1px;\r\n		border-top:solid #fff 1px;\r\n		padding:3px 0px 3px 15px;\r\n	}\r\n	.wgMiniCart .total {\r\n		padding:3px 0px 3px 15px;\r\n		border-top:solid white 1px;\r\n	}\r\n	.wgMiniCart .cart {\r\n		background-color:white;\r\n		-moz-border-radius-bottomLeft:15px;\r\n		-moz-border-radius-bottomRight:15px;\r\n		padding:3px;\r\n		margin-top:10px;\r\n	}\r\n</style>',0,1,0,1228264384),('WeatherDataTmpl0000001',1210711353,'3','pbversion0000000000001','approved','WeatherData Default View','WeatherData Default View','weatherdatatmpl0000001','3','7','12',NULL,0,1,0,0,0,5190,'<script type=\"text/javascript\" src=\"^Extras(/yui/build/yahoo/yahoo-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(/yui/build/event/event-min.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\n// correctly handle PNG transparency in Win IE 5.5 or higher.\r\n    var correctPNG = function() {\r\n        if (YAHOO.util.Event.isIE) {\r\n            for(var i=0; i<document.images.length; i++) {\r\n                var img = document.images[i]\r\n                var imgName = img.src.toUpperCase()\r\n                if (imgName.substring(imgName.length-3, imgName.length) == \"PNG\") {\r\n                    var imgID = (img.id) ? \"id=\'\" + img.id + \"\' \" : \"\"\r\n                    var imgClass = (img.className) ? \"class=\'\" + img.className + \"\' \" : \"\"\r\n                    var imgTitle = (img.title) ? \"title=\'\" + img.title + \"\' \" : \"title=\'\" + img.alt + \"\' \"\r\n                    var imgStyle = \"display:inline-block;\" + img.style.cssText\r\n                    if (img.align == \"left\") imgStyle = \"float:left;\" + imgStyle\r\n                    if (img.align == \"right\") imgStyle = \"float:right;\" + imgStyle\r\n                    if (img.parentElement.href) imgStyle = \"cursor:hand;\" + imgStyle\r\n                    var strNewHTML = \"<span \" + imgID + imgClass + imgTitle\r\n                        + \" style=\\\"\" + \"width:\" + img.width + \"px; height:\" + img.height + \"px;\" + imgStyle + \";\"\r\n                        + \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"\r\n                        + \"(src=\\\'\" + img.src + \"\\\', sizingMethod=\'scale\');\\\"></span>\"\r\n                    img.outerHTML = strNewHTML\r\n                    i = i-1\r\n                }\r\n            }\r\n        }\r\n    }\r\n    YAHOO.util.Event.onDOMReady(correctPNG);\r\n</script>',0,1,0,1228264384),('Ik9HHky10DIyFTKehUD1dw',1222803478,'3','pbversion0000000000001','approved','Prompt','Prompt','root/import/prompt','3','7','12',NULL,0,0,0,0,0,285,NULL,0,1,0,1222803478),('gI_TxK-5S4DNuv42wpImmw',1213734379,'3','pbversion0000000000001','approved','Gallery Templates','Gallery Templates','root/import/gallery-templates','3','7','3',NULL,0,0,0,0,0,339,NULL,0,1,0,1244573916),('BmLaN4rmAANkCglXUViEbg',1222803871,'3','pbversion0000000000001','approved','Resource','Resource','root/import/projectmanager/resource','3','12','12',NULL,0,0,0,0,0,314,NULL,0,1,0,1222803871),('X7DrzUcj8pOKFa_6k9D5iw',1222804045,'3','pbversion0000000000001','approved','Newsletter','Newsletter','root/import/newsletter','3','12','3',NULL,0,0,0,0,0,297,NULL,0,1,0,1222804045),('7-0-style0000000000059',1213386091,'3','pbversion0000000000001','approved','main_top.jpg','main_top.jpg','style3/main_top.jpg','3','7','12',NULL,0,0,0,0,0,3583,NULL,0,1,0,1213386091),('CalendarPrintEvent0001',1215396964,'3','pbversion0000000000001','approved','Default Calendar Print Event','Default Calendar Print Event','root/import/calendar-templates/default-calendar-print-event','3','7','12',NULL,0,0,0,0,0,3079,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1228264384),('_gBYAdTcbkiyamnqi2Xskg',1222803409,'3','pbversion0000000000001','approved','WebGUI/Recovery','WebGUI/Recovery','root/import/auth/webgui/recovery','3','7','12',NULL,0,0,0,0,0,324,NULL,0,1,0,1222803409),('j_1qEqM6iLfQLiR6VKy0aA',1215718151,'3','pbversion0000000000001','approved','Free Documentation','Free Documentation','documentation/free-documentation','3','7','3',NULL,0,1,0,0,0,1382,NULL,0,1,0,1215718151),('o_pq_e4vRyhMOKFzs61eag',1215714957,'3','pbversion0000000000001','approved','book-covers.jpg','book-covers.jpg','documentation/book-covers.jpg','3','7','3',NULL,0,1,0,0,0,106067,NULL,0,0,0,1215714957),('diZvW4bSgZWwyyGP3qXi1g',1215717972,'3','pbversion0000000000001','approved','Commercial Documentation','Commercial Documentation','documentation/commercial-documentation','3','7','3',NULL,0,1,0,0,0,1077,NULL,0,1,0,1215717972),('oHk7fAFhEEkB7dHzi0QOQA',1222803399,'3','pbversion0000000000001','approved','WebGUI/Expired','WebGUI/Expired','root/import/auth/webgui/expired','3','7','12',NULL,0,0,0,0,0,321,NULL,0,1,0,1222803399),('fq1ZkYhH24R5tb96kuT10Q',1222803395,'3','pbversion0000000000001','approved','WebGUI/Create','WebGUI/Create','root/import/auth/webgui/create','3','7','12',NULL,0,0,0,0,0,318,NULL,0,1,0,1222803395),('63ix2-hU0FchXGIWkG3tow',1216169693,'3','pbversion0000000000001','approved','Flat Discount (Default)','Flat Discount (Default)','root/import/flat-discount-default','3','7','12',NULL,0,1,0,0,0,811,NULL,0,1,0,1228264384),('K0q_N885Httqev1VCqUWxg',1222803391,'3','pbversion0000000000001','approved','WebGUI/Account','WebGUI/Account','root/import/auth/webgui/account','3','7','12',NULL,0,0,0,0,0,321,NULL,0,1,0,1222803391),('jnYdqDkUR8x7Pv2eGR1qTA',1216250666,'3','pbversion0000000000001','approved','Thingy Templates','Thingy Templates','root/import/thingy-templates','3','7','12',NULL,0,1,0,0,0,312,NULL,0,1,0,1216250666),('taX2UYkFF21ALpFZY2rhMw',1222803387,'3','pbversion0000000000001','approved','LDAP/Login','LDAP/Login','root/import/auth/ldap/login','3','7','12',NULL,0,0,0,0,0,309,NULL,0,1,0,1222803387),('3n3H85BsdeRQ0I08WmvlOg',1216227244,'3','pbversion0000000000001','approved','thingy.css','thingy.css','root/import/thingy-templates/thingy.css','3','7','12',NULL,0,1,0,0,0,2768,NULL,0,1,0,1216227244),('5m5I7__l40C4hhv4ydqAHQ',1216227786,'3','pbversion0000000000001','approved','thingy-ie.css','thingy-ie.css','root/import/thingy-templates/thingy-ie.css','3','7','12',NULL,0,1,0,0,0,830,NULL,0,1,0,1216227786),('9M-lrlPQWeeNWfvnDnK_Xg',1222803405,'3','pbversion0000000000001','approved','WebGUI/Login','WebGUI/Login','root/import/auth/webgui/login','3','7','12',NULL,0,0,0,0,0,315,NULL,0,1,0,1222803405),('xSmREZO3GNzK3M5PaueOOQ',1222803378,'3','pbversion0000000000001','approved','LDAP/Account','LDAP/Account','root/import/auth/ldap/account','3','7','12',NULL,0,0,0,0,0,315,NULL,0,1,0,1222803378),('0bx-xoL8TSXXubFuqKAoVQ',1222803383,'3','pbversion0000000000001','approved','LDAP/Create','LDAP/Create','root/import/auth/ldap/create','3','7','12',NULL,0,0,0,0,0,312,NULL,0,1,0,1222803383),('1oGhfj00KkCzP1ez01AfKA',1218582812,'3','pbversion0000000000001','approved','slideshow.js','slideshow.js','root/import/gallery-templates/slideshow.js','3','7','3',NULL,0,1,0,0,0,8717,NULL,0,1,0,1244573917),('PBtmpl0000000000000130',1219072470,'3','pbversion0000000000001','approved','Tree Navigation','Tree Navigation','root/import/navigation/tree-navigation','3','7','12',NULL,0,1,0,0,0,2512,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts-min.css);\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/treeview/assets/skins/sam/treeview.css);\" />\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/treeview/treeview-min.js);\"></script>',0,1,0,1228264384),('pV7GnZdpjR3XpZaSINIoeg',1222803347,'3','pbversion0000000000001','approved','gantt','gantt','root/import/projectmanager/gantt','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1222803347),('9A-mg2gwWmaYi9o_1C7ArQ',1222803338,'3','pbversion0000000000001','approved','dashboard','dashboard','root/import/projectmanager/dashboard','3','7','12',NULL,0,0,0,0,0,316,NULL,0,1,0,1222803338),('PBtmpl0000000000000054',1220655703,'3','pbversion0000000000001','approved','Default Page','Default Page','default_page','3','7','12',NULL,0,1,0,0,0,1193,NULL,0,1,0,1228264384),('PBtmpl000000000table54',1220655704,'3','pbversion0000000000001','approved','Default Page (Table)','Default Page (Table)','default_page_table','3','7','12',NULL,0,0,0,0,0,1258,NULL,0,1,0,1228264384),('yD1SMHelczihzjEmx6eXBA',1222803342,'3','pbversion0000000000001','approved','editTask','editTask','root/import/projectmanager/edittask','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1222803342),('PBtmpl0000000000000125',1220655703,'3','pbversion0000000000001','approved','Left Column','Left Column','left_column','3','7','12',NULL,0,1,0,0,0,2407,'<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 33%;\n}\n.secondColumn {\n        float: left;\n        width: auto;\n        max-width: 65%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n\n',0,1,0,1228264384),('PBtmpl00000000table125',1220655705,'3','pbversion0000000000001','approved','Left Column (Table)','Left Column (Table)','left_column_table','3','7','12',NULL,0,0,0,0,0,2419,'<style type=\"text/css\">\r.firstColumn {\r  width: 35%;\r}\r.secondColumn {\r        max-width: 65%;\r}\r</style>\n',0,1,0,1228264384),('PBtmpl00000000table094',1220655704,'3','pbversion0000000000001','approved','News (Table)','News (Table)','news_table','3','7','12',NULL,0,0,0,0,0,3604,'<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 50%;\r\n}\r\n.secondColumn {\r\n	width: 50%;\r\n}\r\n</style>\r\n',0,1,0,1228264384),('PBtmpl0000000000000109',1220655703,'3','pbversion0000000000001','approved','One Over Three','One Over Three','one_over_three','3','7','12',NULL,0,1,0,0,0,3851,'<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 33%;\n}\n.secondColumn {\n        float: left;\n        width: 33%;\n}\n.thirdColumn {\n        float: left;\n        width: auto;\n        max-width: 33%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n',0,1,0,1228264384),('PBtmpl00000000table109',1220655705,'3','pbversion0000000000001','approved','One Over Three (Table)','One Over Three (Table)','one_over_three_table','3','7','12',NULL,0,0,0,0,0,3921,'<style type=\"text/css\">\n.firstColumn {\n	width: 33%;\n}\n.secondColumn {\n    width: 33%;\n}\n.thirdColumn {\n    width: 33%;\n}\n</style>\n\n',0,1,0,1228264384),('PBtmpl0000000000000094',1220655703,'3','pbversion0000000000001','approved','News','News','plainblacknews','3','7','12',NULL,0,1,0,0,0,3564,'<style type=\"text/css\">\r\n.firstColumn {\r\n	float: left;\r\n	width: 50%;\r\n}\r\n.secondColumn {\r\n	float: left;\r\n	width: auto;\r\n	max-width: 50%;\r\n}\r\n.endFloat {\r\n	clear: both;\r\n}\r\n</style>\r\n\r\n\r\n',0,1,0,1228264384),('PBtmpl0000000000000131',1220655704,'3','pbversion0000000000001','approved','Right Column','Right Column','right_column','3','7','12',NULL,0,1,0,0,0,2421,'<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 65%;\n}\n.secondColumn {\n        float: left;\n        width: auto;\n        max-width: 33%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n\n',0,1,0,1228264384),('PBtmpl00000000table131',1220655705,'3','pbversion0000000000001','approved','Right Column (Table)','Right Column (Table)','right_column_table','3','7','12',NULL,0,0,0,0,0,2415,'<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 65%;\r\n}\r\n.secondColumn {\r\n    width: 35%;\r\n}\r\n</style>\n',0,1,0,1228264384),('1XOJDcg_ITRYwVM-QnIcPw',1219175575,'3','pbversion0000000000001','approved','shelf.css','shelf.css','root/import/shelf2/shelf.css','3','7','12',NULL,0,1,0,0,0,1486,NULL,0,1,0,1219175575),('PBtmpl00000000table135',1220655706,'3','pbversion0000000000001','approved','Side By Side (Table)','Side By Side (Table)','side_by_side_table','3','7','12',NULL,0,0,0,0,0,2277,'<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 50%;\r\n}\r\n\r\n.secondColumn {	\r\n	width:50%;\r\n}\r\n</style>\r\n',0,1,0,1228264384),('PBtmpl0000000000000118',1220655703,'3','pbversion0000000000001','approved','Three Over One','Three Over One','three_over_one','3','7','12',NULL,0,1,0,0,0,3814,'<style type=\"text/css\">\n.firstColumn {\n  float: left;\n  width: 33%;\n}\n.secondColumn {\n        float: left;\n        width: 33%;\n}\n.thirdColumn {\n        float: left;\n        width: auto;\n        max-width: 33%;\n}\n.endFloat {\n clear: both;\n}\n</style>\n\n\n',0,1,0,1228264384),('PBtmpl00000000table118',1220655705,'3','pbversion0000000000001','approved','Three Over One (Table)','Three Over One (Table)','three_over_one_table','3','7','12',NULL,0,0,0,0,0,3936,'<style type=\"text/css\">\r\n.firstColumn {\r\n	width: 33%;\r\n}\r\n.secondColumn {\r\n    width: 33%;\r\n}\r\n.thirdColumn {\r\n	width: 33%;\r\n}\r\n</style>\r\n',0,1,0,1228264384),('huASapWvFDzqwOSbcN-JFQ',1222803313,'3','pbversion0000000000001','approved','user','user','root/import/timetracking/user','3','7','12',NULL,0,0,0,0,0,299,NULL,0,1,0,1222803313),('lo1ac3BsoJx3ijGQ3gR-bQ',1222803309,'3','pbversion0000000000001','approved','row','row','root/import/timetracking/row','3','7','12',NULL,0,0,0,0,0,296,NULL,0,1,0,1222803309),('1z9J1O08n_7gVVlBwSRBJQ',1222803099,'3','pbversion0000000000001','approved','Auth','Auth','root/import/auth','3','7','12',NULL,0,1,0,0,0,279,NULL,0,1,0,1222803099),('zyWi26q9na-iiZqL4yedog',1222803114,'3','pbversion0000000000001','approved','Macro','Macro','root/import/macro','3','7','12',NULL,0,1,0,0,0,282,NULL,0,1,0,1222803114),('tBL7BWiQRZFed2Y-Zjo9tQ',1222803200,'3','pbversion0000000000001','approved','AdminToggle','AdminToggle','root/import/macro/admintoggle','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1222803200),('GdkQpvjRtJqtzOUbwIIQRA',1222803205,'3','pbversion0000000000001','approved','a_account','a_account','root/import/macro/a_account','3','7','12',NULL,0,0,0,0,0,307,NULL,0,1,0,1222803205),('tnc5iYyynX2hfdEs9D3P8w',1222803213,'3','pbversion0000000000001','approved','EditableToggle','EditableToggle','root/import/macro/editabletoggle','3','7','12',NULL,0,0,0,0,0,322,NULL,0,1,0,1222803213),('vgXdBcFTqU7h4wBG1ewdBw',1222803217,'3','pbversion0000000000001','approved','File','File','root/import/macro/file','3','7','12',NULL,0,0,0,0,0,292,NULL,0,1,0,1222803217),('hcFlqnXlsmC1ujN6Id0F0A',1222803234,'3','pbversion0000000000001','approved','GroupAdd','GroupAdd','root/import/macro/groupadd','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1222803234),('eRJR52fvlaxfetv3DQkQYw',1222803238,'3','pbversion0000000000001','approved','GroupDelete','GroupDelete','root/import/macro/groupdelete','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1222803238),('5HIDHq5lAWHV5gpYGS0zLg',1222803244,'3','pbversion0000000000001','approved','H_homeLink','H_homeLink','root/import/macro/h_homelink','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1222803244),('rYEFwXXo0tkGhQTcbDibvg',1222803249,'3','pbversion0000000000001','approved','LoginToggle','LoginToggle','root/import/macro/logintoggle','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1222803249),('-WM2dt0ZGpDasuL2wWocxg',1222803056,'3','pbversion0000000000001','approved','ProjectManager','ProjectManager','root/import/projectmanager','3','7','12',NULL,0,1,0,0,0,309,NULL,0,1,0,1222803056),('2OcUWHVsu_L1sDFzIMWYqw',1222803070,'3','pbversion0000000000001','approved','TimeTracking','TimeTracking','root/import/timetracking','3','7','12',NULL,0,1,0,0,0,303,NULL,0,1,0,1222803070),('vTymIDYL2YqEh6PV50F7ew',1222803302,'3','pbversion0000000000001','approved','manager','manager','root/import/timetracking/manager','3','7','12',NULL,0,0,0,0,0,308,NULL,0,1,0,1222803302),('nqNbSUAhk9Vd1zda2SCz9A',1222803258,'3','pbversion0000000000001','approved','RandomThread','RandomThread','root/import/macro/randomthread','3','7','12',NULL,0,0,0,0,0,316,NULL,0,1,0,1222803258),('y8XkRdxIperLKkJ3bL5sSQ',1222803264,'3','pbversion0000000000001','approved','r_printable','r_printable','root/import/macro/r_printable','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1222803264),('V3l5S5TtI7wMm1WpIMhvOA',1222803253,'3','pbversion0000000000001','approved','L_loginBox','L_loginBox','root/import/macro/l_loginbox','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1222803253),('aIpCmr9Hi__vgdZnDTz1jw',1227539574,'3','pbversion0000000000001','approved','Cart (Default)','Cart (Default)','default-shopping-cart-template','3','7','3',NULL,0,1,0,0,0,8125,'	<style type=\"text/css\">\r\n			#shoppingCart {\r\n				font-family:arial;\r\n				font-size:12px;\r\n			}\r\n\r\n			#shoppingCart tr.header td {\r\n				font-weight:bold;\r\n				text-align:right;\r\n				padding:3px 5px;\r\n			}\r\n\r\n			#shoppingCart tr.data td {\r\n				text-align:right;\r\n				padding:3px 5px;\r\n			}\r\n\r\n			#chooseAddressButton, #checkoutButton {\r\n				color: white;\r\n				background-color: green;					\r\n			}\r\n			#shoppingCart tr.alt td {\r\n				background-color:#F0F0F0;\r\n			}\r\n			#shoppingCart tr.alt td.delete {\r\n				padding-left:10px;\r\n				-moz-border-radius-topLeft:10px;\r\n				-moz-border-radius-bottomLeft:10px;\r\n				border-top-left-radius:10px;\r\n				border-bottom-left-radius:10px;\r\n			}\r\n			#shoppingCart tr.alt td.shipping {\r\n				padding-right:10px;\r\n				-moz-border-radius-topRight:10px;\r\n				-moz-border-radius-bottomRight:10px;\r\n				border-top-right-radius:10px;\r\n				border-bottom-right-radius:10px;\r\n			}\r\n			#shoppingCart tr.topLine td {\r\n				margin-top:10px;\r\n				border-top:solid silver 1px;\r\n			}\r\n			#shoppingCart tr.summary td {\r\n				background-color: #f3f3f3;\r\n				padding:5px 10px 5px 10px;\r\n			}\r\n			#shoppingCart .summary .empty {\r\n				background-color: transparent;\r\n				border-style:none;\r\n			}\r\n			#shoppingCart .summary .topLeft {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\r\n			}\r\n			#shoppingCart .summary .topRight {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\r\n			}\r\n			#shoppingCart .summary .bottomLeft {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\r\n			}\r\n			#shoppingCart .summary .bottomRight {\r\n				background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\r\n			}\r\n			#shoppingCart .summary select {\r\n				padding-right:0px;\r\n				text-align:left;\r\n			}\r\n			#shoppingCart tr.bottomLine td {\r\n				border-bottom: solid 1px silver;\r\n			}\r\n			#shoppingCart tr.topLine td {\r\n				border-top: solid 1px #fff;\r\n			}\r\n		</style>',0,1,0,1228264384),('PBEmsBadgeTemplate0000',1221692339,'3','pbversion0000000000001','approved','Default EMS Badge Template','Default EMS Badge Template','default_emsbadge','3','7','4',NULL,0,0,0,0,0,1456,NULL,0,1,0,1228264384),('PBtmpl0000000000000005',1221612327,'3','pbversion0000000000001','approved','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template','default_ldap_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,5808,'<style type=\"text/css\">\r\n    .submitData {\r\n        text-align:right;\r\n        border-top:solid gray 1px;\r\n    }\r\n    .authfield_required_off {\r\n        background-color: #FFFFFF;\r\n    }\r\n    .authfield_required {\r\n        background-color: #FFFFBB;\r\n    }\r\n    .authfield_error {\r\n        background-color: #FF9494;\r\n    }\r\n</style>\r\n<script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\r\n<script type=\"text/javascript\">\r\n   YAHOO.util.Event.onDOMReady(function () {\r\n        var setFieldColor = function ( evt, obj ) {\r\n            var field     = obj.field;\r\n            var hasError  = obj.hasError;\r\n            var origClass = field.className;\r\n            YAHOO.util.Dom.removeClass(field,origClass);\r\n            if(field.value == \"\") {\r\n                var newClass  = hasError?\"authfield_error\":\"authfield_required\";\r\n                YAHOO.util.Dom.replaceClass(field,origClass,newClass);\r\n            }\r\n            else {\r\n                YAHOO.util.Dom.replaceClass(field,origClass,\"authfield_required_off\");\r\n            }\r\n        }\r\n\r\n        var rFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");\r\n        var eFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");\r\n        var oFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");\r\n\r\n        for (var i = 0; i < rFields.length; i++) {\r\n            YAHOO.util.Event.addListener(rFields[i],\"change\",setFieldColor, {\r\n                field   : rFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < eFields.length; i++) {\r\n            YAHOO.util.Event.addListener(eFields[i],\"change\",setFieldColor, {\r\n                field   : eFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < oFields.length; i++) {\r\n            YAHOO.util.Event.addListener(oFields[i],\"change\",setFieldColor, {\r\n                field   : oFields[i],\r\n                hasError: (oFields.length > 0)\r\n            });\r\n        }\r\n       \r\n   });\r\n</script>',0,1,0,1228264384),('PBtmpl0000000000000200',1222383245,'3','pbversion0000000000001','approved','Default Search','Default Search','default_search2','3','7','12',NULL,0,0,0,0,0,1042,NULL,0,1,0,1228264384),('PBtmpl0000000000000011',1221612288,'3','pbversion0000000000001','approved','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template','default_webgui_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,4059,'<style type=\"text/css\">\r\n    .submitData {\r\n        text-align:right;\r\n        border-top:solid gray 1px;\r\n    }\r\n    .authfield_required_off {\r\n        background-color: #FFFFFF;\r\n    }\r\n    .authfield_required {\r\n        background-color: #FFFFBB;\r\n    }\r\n    .authfield_error {\r\n        background-color: #FF9494;\r\n    }\r\n</style>\r\n<script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\r\n<script type=\"text/javascript\">\r\n   YAHOO.util.Event.onDOMReady(function () {\r\n        var setFieldColor = function ( evt, obj ) {\r\n            var field     = obj.field;\r\n            var hasError  = obj.hasError;\r\n            var origClass = field.className;\r\n            YAHOO.util.Dom.removeClass(field,origClass);\r\n            if(field.value == \"\") {\r\n                var newClass  = hasError?\"authfield_error\":\"authfield_required\";\r\n                YAHOO.util.Dom.replaceClass(field,origClass,newClass);\r\n            }\r\n            else {\r\n                YAHOO.util.Dom.replaceClass(field,origClass,\"authfield_required_off\");\r\n            }\r\n        }\r\n\r\n        var rFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");\r\n        var eFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");\r\n        var oFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");\r\n\r\n        for (var i = 0; i < rFields.length; i++) {\r\n            YAHOO.util.Event.addListener(rFields[i],\"change\",setFieldColor, {\r\n                field   : rFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < eFields.length; i++) {\r\n            YAHOO.util.Event.addListener(eFields[i],\"change\",setFieldColor, {\r\n                field   : eFields[i],\r\n                hasError: (eFields.length > 0)\r\n            });\r\n        }\r\n\r\n        for (var i = 0; i < oFields.length; i++) {\r\n            YAHOO.util.Event.addListener(oFields[i],\"change\",setFieldColor, {\r\n                field   : oFields[i],\r\n                hasError: (oFields.length > 0)\r\n            });\r\n        }\r\n       \r\n   });\r\n</script>',0,1,0,1239804541),('PBtmpl0000000000000134',1222574692,'3','pbversion0000000000001','approved','Hierarchical Top Nav','Hierarchical Top Nav','import/hierarchical-top-nav','3','7','12',NULL,0,1,0,0,0,2993,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\r\n<!-- Page-specific script -->\r\n<script type=\"text/javascript\">\r\n    YAHOO.util.Event.onAvailable(\"webguinavigation\", function() {\r\n        var wgMenuBar = new YAHOO.widget.MenuBar(\"webguinavigation\", {\r\n            autosubmenudisplay : true,\r\n            showdelay          : 250,\r\n            hidedelay          : 750,\r\n            lazyload           : true\r\n        });\r\n        wgMenuBar.render();\r\n    });\r\n</script>\n',0,1,0,1228264384),('PBtmpl0000000000000020',1221692340,'3','pbversion0000000000001','approved','Mail Form','Mail Form','mail_form','3','7','12',NULL,0,1,0,0,0,3147,'<style type=\"text/css\">\r\nh2{\r\n	font-family:arial;\r\n	margin-top:3px;\r\n	margin-bottom:3px;\r\n}\r\n.fontSettings{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.mailForm td{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.dataControls\r\n{\r\n	-moz-box-sizing:border-box;\r\n	background:#676767;\r\n	color:#C0C0C0;\r\n	width:100%;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-bottom:5px;\r\n}\r\n.dataControls a\r\n{\r\n	color:white;\r\n	font-size:8pt;\r\n	text-decoration:underline;\r\n}\r\n.dataControls a:hover {\r\n	text-decoration:none;\r\n}\r\n</style>\n',0,1,0,1228264384),('newslettersubscrip0001',1221692339,'3','pbversion0000000000001','approved','My Subscriptions (default)',' My Subscriptions','newslettermysubscriptionstemplate','3','7','3',NULL,0,0,0,0,0,778,NULL,0,1,0,1228264384),('PBtmpl0000000000000141',1221692340,'3','pbversion0000000000001','approved','Default DataForm','Default DataForm','pbtmpl0000000000000141','3','7','12',NULL,0,1,0,0,0,4343,'<style type=\"text/css\">\r\nh2{\r\n	font-family:arial;\r\n	margin-top:3px;\r\n	margin-bottom:3px;\r\n}\r\n.errors{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.defaultData td{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.dataControls\r\n{\r\n	-moz-box-sizing:border-box;\r\n	background:#676767;\r\n	color:#C0C0C0;\r\n	width:100%;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-bottom:5px;\r\n}\r\n.dataControls a\r\n{\r\n	color:white;\r\n	font-size:8pt;\r\n	text-decoration:underline;\r\n}\r\n.dataControls a:hover {\r\n	text-decoration:none;\r\n}\r\n</style>\r\n',0,1,0,1228264384),('eqb9sWjFEVq0yHunGV8IGw',1222574693,'3','pbversion0000000000001','approved','Subscription (Default)','Subscription (Default)','root/import/subscription-default','3','7','12',NULL,0,1,0,0,0,2113,'<style type=\"text/css\">\r\n	.wgSubscription {\r\n\r\n	}\r\n	.wgSubscription .controls {\r\n		background-color:black;\r\n		padding:3px 10px;\r\n		color:white;\r\n		margin:5px 0px;\r\n	}\r\n	.wgSubscription h3.title {\r\n		margin-bottom:3px;\r\n	}\r\n	.wgSubscription .description * {\r\n		margin-top:0px;\r\n	}\r\n	.wgSubscription .controls a {\r\n		color:white;\r\n	}\r\n	.wgSubscription .smaller {\r\n		font-size:10px;\r\n		margin-bottom:10px;\r\n	}\r\n</style>\n',0,1,0,1228264384),('2gtFt7c0qAFNU3BG_uvNvg',1222574694,'3','pbversion0000000000001','approved','My Purchases (Default)','My Purchases (Default)','shopping-cart-collateral-items/my-purchases-default','3','7','3',NULL,0,1,0,0,0,2535,'<style type=\"text/css\">\r\n	.wgPurchase h3.title {\r\n		margin-bottom:0px;\r\n	}\r\n	.wgPurchase .transactionItems {\r\n		clear:both;\r\n		width:98%;\r\n		margin-top:15px;\r\n	}\r\n	.wgPurchase .transactionItems th {\r\n		background-color:#E0E0E0;\r\n		padding:3px;\r\n		text-align:left;\r\n		border-left:solid #AAAAAA 1px;\r\n		border-right:solid #f1f1f1 1px;\r\n	}\r\n	.wgPurchase .transactionItems th:first-child {\r\n		-moz-border-radius-topLeft: 15px;\r\n		border-left-style:none;\r\n	}\r\n	.wgPurchase .transactionItems th:last-child {\r\n		-moz-border-radius-topRight: 15px;\r\n		border-right-style:none;\r\n	}\r\n	.wgPurchase .transactionItems td {\r\n		background-color:#F1F1F1;\r\n		border-bottom:solid #E0E0E0 1PX;\r\n		border-top:solid #fff 1px;\r\n		border-left:solid #e0e0e0 1px;\r\n		border-right:solid white 1px;\r\n		padding:3px;		\r\n	}\r\n</style>\n',0,1,0,1228264384),('g8W53Pd71uHB9pxaXhWf_A',1222574693,'3','pbversion0000000000001','approved','My Purchases Detail (Default)','My Purchases Detail (Default)','shopping-cart-collateral-items/my-purchases-detail-default','3','7','3',NULL,0,1,0,0,0,6039,'<style type=\"text/css\">\r\n	.wgPurchase {\r\n\r\n	}\r\n\r\n	.wgPurchase h3.title {\r\n		font-size:14px;\r\n		background-color:black;\r\n		color:white;\r\n		padding:3px;\r\n	}\r\n\r\n	.wgPurchase ul.dataList,\r\n	.wgPurchase ul.dataList li {\r\n		margin:0px;\r\n		padding:0px;\r\n		list-style-type:none;\r\n		font-size:10px;\r\n	}\r\n	.wgPurchase ul.dataList li {\r\n		background-color:#F1F1F1;\r\n		margin:6px;\r\n		line-height:20px;\r\n	}\r\n	.wgPurchase ul.dataList span {\r\n		background-color:#E0E0E0;\r\n		font-weight:bold;\r\n		width:200px;\r\n		display:block;\r\n		float:left;\r\n		margin-right:5px;\r\n		padding-right:5px;\r\n		text-align:right;\r\n		border-right:solid white 1px;\r\n	}\r\n	.wgPurchase .address {\r\n		float:left;\r\n		margin:6px;\r\n	}\r\n	.wgPurchase .address {\r\n		background-color:#f1f1f1;\r\n		-moz-border-radius:15px;\r\n		width:48%;\r\n	}\r\n	.wgPurchase .address div:first-child {\r\n		font-weight:bold;\r\n		background-color:#E0E0E0;\r\n		-moz-border-radius-topLeft:15px;\r\n		-moz-border-radius-topRight:15px;\r\n		padding:5px;\r\n	}\r\n	.wgPurchase .address div:last-child {\r\n		padding:10px;\r\n	}\r\n\r\n	.wgPurchase .transactionItems {\r\n		clear:both;\r\n		width:98%;\r\n		margin-top:15px;\r\n	}\r\n	.wgPurchase .transactionItems th {\r\n		background-color:#E0E0E0;\r\n		padding:3px;\r\n		text-align:left;\r\n		border-left:solid #AAAAAA 1px;\r\n		border-right:solid #f1f1f1 1px;\r\n	}\r\n	.wgPurchase .transactionItems th:first-child {\r\n		-moz-border-radius-topLeft: 15px;\r\n		border-left-style:none;\r\n	}\r\n	.wgPurchase .transactionItems th:last-child {\r\n		-moz-border-radius-topRight: 15px;\r\n		border-right-style:none;\r\n	}\r\n	.wgPurchase .transactionItems td {\r\n		background-color:#F1F1F1;\r\n		border-bottom:solid #E0E0E0 1PX;\r\n		border-top:solid #fff 1px;\r\n		border-left:solid #e0e0e0 1px;\r\n		border-right:solid white 1px;\r\n		padding:3px;		\r\n	}\r\n</style>\n',0,1,0,1228264384),('stevestyle000000000001',1222383245,'3','pbversion0000000000001','approved','Style 01','Style 01','style_01','3','7','12',NULL,0,0,0,0,0,1618,NULL,0,1,0,1228264384),('stevestyle000000000002',1222383245,'3','pbversion0000000000001','approved','Style 02','Style 02','style_02','3','7','12',NULL,0,0,0,0,0,2603,NULL,0,1,0,1228264384),('PBtmpl0000000000000116',1221692340,'3','pbversion0000000000001','approved','Tab Form','Tab Form','tab_form','3','7','12',NULL,0,1,0,0,0,3847,'<style type=\"text/css\">\r\nh2{\r\n	font-family:arial;\r\n	margin-top:3px;\r\n	margin-bottom:3px;\r\n}\r\n.fontSettings{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.tabForm td{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.dataControls\r\n{\r\n	-moz-box-sizing:border-box;\r\n	background:#676767;\r\n	color:#C0C0C0;\r\n	width:100%;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-bottom:5px;\r\n}\r\n.dataControls a\r\n{\r\n	color:white;\r\n	font-size:8pt;\r\n	text-decoration:underline;\r\n}\r\n.dataControls a:hover {\r\n	text-decoration:none;\r\n}\r\n</style>\n',0,1,0,1228264384),('ThingyTmpl000000000002',1222574693,'3','pbversion0000000000001','approved','Default Thingy View Thing','Default Thingy View Thing','templates/thingy-default-view-thing','3','7','12',NULL,0,0,0,0,0,2859,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\n',0,1,0,1228264384),('UL-ItI4L1Z6-WSuhuXVvsQ',1225139673,'3','pbversion0000000000001','approved','DataTable','DataTable','root/import/datatable','3','7','3',NULL,0,0,0,0,0,302,NULL,0,1,0,1239804542),('2rC4ErZ3c77OJzJm7O5s3w',1224723218,'3','pbversion0000000000001','approved','EMS Badge Listing (default)','EMS Badge Listing (default)','root/import/ems/ems-badge-listing-default','3','7','12',NULL,0,1,0,0,0,7157,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n\r\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n\r\n		<style type=\"text/css\">\r\n		.badgeDescription {\r\n		background-color: white;\r\n		max-width: 400px;\r\n		border:1px solid #000;\r\n		padding:10px;\r\n		}\r\n		.forwardButton {\r\n			background-color: green;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		.backwardButton {\r\n			background-color: red;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		</style>\r\n',0,1,0,1228264385),('OOyMH33plAy6oCj_QWrxtg',1224724790,'3','pbversion0000000000001','approved','Lookup Registrant (Default)','Lookup Registrant (Default)','root/import/ems/lookup-registrant-default','3','7','12',NULL,0,1,0,0,0,5159,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n\r\n\r\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\r\n\r\n<style type=\"text/css\">\r\ndiv.search, p {\r\n	text-align: left;\r\n}\r\n\r\n</style>\r\n',0,1,0,1228264385),('THQhn1C-ooj-TLlEP7aIJQ',1225313951,'3','pbversion0000000000001','approved','gallery-ie.css','gallery-ie.css','root/import/gallery-templates/gallery-ie.css','3','7','3',NULL,0,1,0,0,0,457,NULL,0,1,0,1244573917),('7-0-style0000000000049',1224117144,'3','pbversion0000000000001','approved','WebGUI 7 Style 3','WebGUI 7 Style 3','root/import/webgui-7-style-3','3','7','12',NULL,0,0,0,0,0,315,NULL,0,1,0,1224117144),('stevecoolmenu000000001',1224116942,'3','pbversion0000000000001','approved','Site Nav','Site Nav','webgui7/style3/hierarchical-top-nav','3','7','12',NULL,0,0,0,0,0,2566,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\r\n',0,1,0,1228264385),('7-0-style0000000000051',1224117026,'3','pbversion0000000000001','approved','css03.css','css03.css','style3/css03.css','3','7','12',NULL,0,0,0,0,0,3683,NULL,0,1,0,1224117026),('jVKLVakT_iA2010_oEuAwg',1224116526,'3','pbversion0000000000001','approved','Style3 Coolmenu','Style3 Coolmenu','department_nav','3','7','12',NULL,0,0,0,0,0,354,NULL,0,1,0,1224116526),('XNd7a_g_cTvJVYrVHcx2Mw',1224606020,'3','pbversion0000000000001','approved','Address (Default)','Address (Default)','shopping-cart-collateral-items/address-default','3','7','3',NULL,0,1,0,0,0,3231,'<style type=\"text/css\">\r\n	.wgAddress h2.title {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgAddress table {\r\n		margin-top:15px;\r\n	}\r\n\r\n	.wgAddress .label {\r\n		background:#000;\r\n		color:white;\r\n		font-weight:bold;\r\n		padding-left:5px;\r\n	}\r\n	.wgAddress input, .wgAddress select {\r\n		border:solid #555 1px;\r\n	}\r\n</style>\r\n',0,1,0,1228264385),('stevestyle000000000003',1224795533,'3','pbversion0000000000001','approved','Style 03','Style 03','style_03','3','7','12',NULL,0,0,0,0,0,1716,NULL,0,1,0,1239804542),('ThingyTmpl000000000003',1224518002,'3','pbversion0000000000001','approved','Default Thingy Edit Thing','Default Thingy Edit Thing','templates/thingy-default-edit-thing','3','7','12',NULL,0,0,0,0,0,3654,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\r\n\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/thingy-templates/thingy-ie.css););\r\n	</style>\r\n<![endif]-->\r\n',0,1,0,1239804542),('QpmlAiYZz6VsKBM-_0wXaw',1224616691,'3','pbversion0000000000001','approved','UsersOnline Macro','UsersOnline Macro','users-online-macro-templates','3','7','3',NULL,0,0,0,0,0,345,NULL,0,1,0,1239804542),('h_T2xtOxGRQ9QJOR6ebLpQ',1224616545,'3','pbversion0000000000001','approved','UsersOnline Default View','UsersOnline Default View','users-online-macro-templates/usersonline-default-view','3','7','3',NULL,0,1,0,0,0,1728,'<style type=\"text/css\">\r\n.UsersOnlineTable { \r\n	border-collapse: collapse;\r\n}\r\n\r\n.UsersOnlineTable th, .UsersOnlineTable td {\r\n	text-align: left;\r\n	border: 2px ridge;\r\n}\r\n\r\n.UsersOnlineTable img {\r\n	max-width: 3em;\r\n	max-height: 3em;\r\n	float: left;\r\n}\r\n</style>\r\n\r\n',0,1,0,1228264385),('4Ekp0kJoJllRRRo_J1Rj6w',1224616672,'3','pbversion0000000000001','approved','UsersOnline Detailed View','UsersOnline Detailed View','users-online-macro-templates/usersonline-detailed-view','3','7','3',NULL,0,1,0,0,0,2706,'<style type=\"text/css\">\r\n.UsersOnlineTable { \r\n	border-collapse: collapse;\r\n}\r\n\r\n.UsersOnlineTable th, .UsersOnlineTable td {\r\n	text-align: left;\r\n	border: 2px ridge;\r\n}\r\n\r\n.UsersOnlineTable img {\r\n	max-width: 3em;\r\n	max-height: 3em;\r\n	float: left;\r\n}\r\n</style>\r\n\r\n',0,1,0,1228264385),('PBtmpl0000000000000065',1226457084,'3','pbversion0000000000001','approved','Default Syndicated Content','Default Syndicated Content','default_syndicated_content','3','7','12',NULL,0,1,0,0,0,1041,NULL,0,1,0,1228264385),('newslettercs0000000001',1226896423,'3','pbversion0000000000001','approved','Newsletter Manager (default)',' Newsletter Manager','newslettercstemplate','3','7','3',NULL,0,0,0,0,0,1886,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n</style>\n',0,1,0,1228264385),('HPDOcsj4gBme8D4svHodBw',1225404573,'3','pbversion0000000000001','approved','Profile','Profile','root/import/account/profile','3','7','12',NULL,0,1,0,0,0,311,NULL,0,1,0,1234301429),('IZkrow_zwvbf4FCH-taVTQ',1226011853,'3','pbversion0000000000001','approved','Inbox','Inbox','root/import/account/inbox','3','7','12',NULL,0,1,0,0,0,305,NULL,0,1,0,1234301429),('DUoxlTBXhVS-Zl3CFDpt9g',1226896802,'3','pbversion0000000000001','approved','Default Message Confirm Template','Default Message Confirm Template','root/import/account/inbox/default-message-confirm-template','3','7','12',NULL,0,1,0,0,0,582,NULL,0,1,0,1234301430),('SVIhz68689hwUGgcDM-gWw',1226973314,'3','pbversion0000000000001','approved','Default Invite User Confirm Template','Default Invite User Confirm Template','root/import/account/inbox/default-invite-user-confirm-template','3','7','12',NULL,0,1,0,0,0,610,NULL,0,1,0,1234301430),('K0YjxqOqr7RupSo6sIdcAg',1227074310,'3','pbversion0000000000001','approved','Friends','Friends','root/import/account/friends','3','7','12',NULL,0,1,0,0,0,311,NULL,0,1,0,1234301429),('7Ijdd8SW32lVgg2H8R-Aqw',1226995714,'3','pbversion0000000000001','approved','Default Friends Error Template','Default Friends Error Template','root/import/account/friends/default-friends-error-template','3','7','12',NULL,0,1,0,0,0,585,NULL,0,1,0,1234301430),('K8F0j_cq_jgo8dvWY_26Ag',1226995643,'3','pbversion0000000000001','approved','Default Friends Confirmation Template','Default Friends Confirmation Template','root/import/account/friends/default-friends-confirmation-template','3','7','12',NULL,0,1,0,0,0,678,NULL,0,1,0,1234301430),('G5V6neXIDiFXN05oL-U3AQ',1226995768,'3','pbversion0000000000001','approved','Default Remove Friends Confirmation Template','Default Remove Friends Confirmation Template','root/import/account/friends/default-remove-friends-confirmation-template','3','7','12',NULL,0,1,0,0,0,813,NULL,0,1,0,1234301430),('_ilRXNR3s8F2vGJ_k9ePcg',1226643205,'3','pbversion0000000000001','approved','User','User','root/import/account/user','3','7','12',NULL,0,1,0,0,0,302,NULL,0,1,0,1234301429),('AOjPG2NHgfL9Cq6dDJ7mew',1226659753,'3','pbversion0000000000001','approved','Shop','Shop','root/import/account/shop','3','7','12',NULL,0,1,0,0,0,302,NULL,0,1,0,1234301429),('qaVcU0FFzzraMX_bzELqzw',1227074362,'3','pbversion0000000000001','approved','Contributions','Contributions','root/import/account/contributions','3','7','12',NULL,0,1,0,0,0,329,NULL,0,1,0,1234301429),('vrKXEtluIhbmAS9xmPukDA',1226698051,'3','pbversion0000000000001','approved','Donation (Default)','Donation (Default)','root/import/default-donation-template','3','7','12',NULL,0,1,0,0,0,1876,'<style type=\"text/css\">\r\n	.wgDonation h3.title {\r\n		background: #000;\r\n		height:42px;\r\n		color:white;\r\n		font-size:18px;\r\n		font-weight:bold;\r\n		letter-spacing:1px;			\r\n		line-height:42px;\r\n		padding-left:15px;\r\n		margin-bottom:0px;\r\n	}\r\n	.wgDonation .cart {\r\n		margin:15px 0px 15px 25px;\r\n	}\r\n	.wgDonation #price_formId {\r\n		background-color:white;\r\n		border:solid black 1px;\r\n	}\r\n</style>\r\n',0,0,0,1228264385),('5bnNzteN7w3NnK9mF4XiCg',1227540002,'3','pbversion0000000000001','approved','Survey','Survey','root/import/survey','3','7','12',NULL,0,0,0,0,0,295,NULL,0,1,0,1227556681),('PBtmpl0000000000000061',1227252733,'3','pbversion0000000000001','approved','Default Survey','Default Survey','default_survey','3','7','12',NULL,0,1,0,0,0,1340,NULL,0,1,0,1228264385),('PBtmpl0000000000000064',1226009610,'3','pbversion0000000000001','approved','Default Response','Default Response','default_response','3','7','12',NULL,0,1,0,0,0,1981,NULL,0,1,0,1228264385),('3womoo7Teyy2YKFa25-MZg',1226703362,'3','pbversion0000000000001','approved','Address Book (Default)','Address Book (Default)','shopping-cart-collateral-items/address-book-default','3','7','3',NULL,0,1,0,0,0,2603,'<style>\r\n	.wgAddressBook .item {\r\n		float:left;\r\n		margin:15px;\r\n		width:210px;\r\n		background-color:white;\r\n		border:solid black 1px;\r\n	}\r\n	.wgAddressBook .default {\r\n		border:double black 3px;\r\n	}\r\n	.wgAddressBook .use input {\r\n		width:210px;\r\n		background-color:white;\r\n		font-size:10px;\r\n		cursor:pointer;\r\n		border:gray outset 2px;\r\n		font-weight:bold;\r\n		margin-bottom:10px;\r\n		color:green;\r\n	}\r\n	.wgAddressBook .label {\r\n		text-align:center;\r\n		font-size:15px;\r\n		font-weight:bold;\r\n	}\r\n	.wgAddressBook .address {\r\n		padding:5px;\r\n		margin-bottom:15px;\r\n	}\r\n	.wgAddressBook .delete input,\r\n	.wgAddressBook .edit input {\r\n		float:left;\r\n		width:70px;\r\n		font-size:10px;\r\n		border:gray outset 1px;\r\n		background-color:white;\r\n		cursor:pointer;\r\n	}\r\n	.wgAddressBook .delete input {\r\n		color:red;\r\n	}\r\n	.wgAddressBook * input:hover {\r\n		background-color:#FFFFEC;\r\n	}\r\n</style>\r\n',0,1,0,1228264385),('ThingyTmpl000000000004',1227044214,'3','pbversion0000000000001','approved','Default Thingy Search Thing','Default Thingy Search Thing','templates/thingy-default-search-thing','3','7','12',NULL,0,0,0,0,0,5396,'<script type=\"text/javascript\">\r\n	var timer;\r\n	var tempThing;\r\n	function showHide(tempThingId) {	\r\n			tempThing = document.getElementById(tempThingId);\r\n			var tempVis = tempThing.style.display;			\r\n			tempChildren = tempThing.childNodes;			\r\n			for(i=0;i<tempThing.childNodes.length;i++) {\r\n				if(tempThing.childNodes[i].tagName == \"A\") {					\r\n					tempThing.childNodes[i].onmouseout = mouseOutHide;\r\n					tempThing.childNodes[i].onmouseover = cancelTimer;\r\n				}\r\n			}			\r\n			if(tempVis == \"block\")\r\n				tempThing.style.display = \"none\";\r\n			else\r\n				tempThing.style.display = \"block\";\r\n	}\r\n\r\n	function mouseOutHide() {					\r\n		var parentVis = this.parentNode.style.display;		\r\n		timer = setTimeout(\"tempThing.style.display = \'none\'\", 125);			\r\n\r\n	}\r\n	function cancelTimer() {						\r\n		clearTimeout(timer);\r\n	}	\r\n</script>\r\n\r\n<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\r\n\r\n<!--[if IE]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/thingy-templates/thingy-ie.css););\r\n	</style>\r\n<![endif]-->\r\n',0,1,0,1239804542),('XgcsoDrbC0duVla7N7JAdw',1227566394,'3','pbversion0000000000001','approved','Default Invite User Email Template','Default Invite User Email Template','root/import/account/inbox/default-invite-user-email-template','3','7','12',NULL,0,1,0,0,0,442,NULL,0,1,0,1234301430),('UserListTmpl0000000001',1228125743,'3','pbversion0000000000001','approved','Default UserList','Default UserList','root/import/userlist/default-userlist','3','7','12',NULL,0,1,0,0,0,2816,NULL,0,1,0,1239804542),('UserListTmpl0000000003',1228125758,'3','pbversion0000000000001','approved','UserList with multiple search keywords','UserList with multiple search keywords','root/import/userlist/userlist-with-multiple-search-keywords','3','7','12',NULL,0,1,0,0,0,2997,NULL,0,1,0,1239804542),('UserListTmpl0000000002',1228125752,'3','pbversion0000000000001','approved','UserList with search field selection','UserList with search field selection','root/import/userlist/userlist-with-search-field-selection','3','7','12',NULL,0,1,0,0,0,2803,NULL,0,1,0,1239804542),('ThingyTmpl000000000001',1227753116,'3','pbversion0000000000001','approved','Default Thingy','Default Thingy','templates/thingy-default','3','7','12',NULL,0,0,0,0,0,1442,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>',0,1,0,1228264387),('matrixtmpl000000000004',1228834590,'3','pbversion0000000000001','approved','Matrix Default Edit Listing','Matrix Default Edit Listing','default-matrix-edit-listing-template','3','7','12',NULL,0,0,0,0,0,430,NULL,0,1,0,1233158077),('PBtmpl0000000000000207',1229100306,'3','pbversion0000000000001','approved','Article with Files','Article with Files','article-with-files','3','7','12',NULL,0,0,0,0,0,1232,NULL,0,1,0,1229459611),('PBtmpl0000000000000084',1229100305,'3','pbversion0000000000001','approved','Center Image','Center Image','center_image','3','7','12',NULL,0,1,0,0,0,1329,NULL,0,1,0,1229459611),('TimeTrackingTMPL000003',1229311434,'3','pbversion0000000000001','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,3170,NULL,0,1,0,1229459611),('PBtmpl0000000000000056',1228934532,'3','pbversion0000000000001','approved','Default Product','Default Product','default_product','3','7','12',NULL,0,1,0,0,0,7505,'<style type=\"text/css\">\r\n	.wgProduct {\r\n\r\n	}\r\n	.wgProduct h3.title {\r\n		margin-bottom:2px;\r\n		padding-bottom:0px;\r\n	}\r\n	.wgProduct .images {\r\n		float:left;\r\n		min-width:1%;\r\n		margin:10px;\r\n	}\r\n	.wgProduct .images ul, \r\n	.wgProduct .images li {\r\n		padding:0px;\r\n		margin:0px;\r\n		margin-left:15px;\r\n		color:#787878;\r\n	}	\r\n	.wgProduct .images .controls .title {\r\n		background-color:#E0E0E0;\r\n		padding:2px;\r\n		font-weight:bold;\r\n		margin-bottom:5px;\r\n	}	\r\n	.wgProduct .images .controls {\r\n		margin-top:10px;\r\n		display:block;\r\n		background-color:#F1F1F1;\r\n		padding-bottom:5px;\r\n		border:1px ridge #E0E0E0;		\r\n	}\r\n	.wgProduct .images .controls a {\r\n		font-size:10px;\r\n		letter-spacing:0px;\r\n		display:block;\r\n		padding:0px 3px;\r\n		color:#787878;\r\n	}	\r\n	.wgProduct .images .buttons {\r\n		margin:10px 0px;\r\n	}\r\n	.wgProduct .images .buttons a {\r\n		background-color:#F1F1F1;\r\n		padding:2px 5px;\r\n		color:#787878;\r\n		text-decoration:none;\r\n		border:1px ridge #E0E0E0;\r\n		font-size:10px;\r\n		display:block;\r\n		margin:1px 0px;\r\n	}\r\n	\r\n	\r\n	\r\n	\r\n	.wgProduct .product {\r\n		float:left;\r\n		margin-left:40px;\r\n		padding:0px 10px 10px 0px;\r\n	}\r\n	.wgProduct .product .description {\r\n		margin-left:-20px;\r\n	}\r\n	.wgProduct .product form {\r\n		margin:20px 0px;\r\n	}	\r\n	.wgProduct .product ul,\r\n	.wgProduct .product li {\r\n		margin:0px;\r\n		padding:0px;\r\n	}\r\n	.wgProduct .product ul {\r\n		margin-bottom:15px;\r\n	}\r\n	.wgProduct .product li {\r\n		margin-left:15px;\r\n	}\r\n\r\n.hoverbox {\r\n	cursor: default;\r\n	list-style: none;\r\n}\r\n\r\n.hoverbox a {\r\n	cursor: default;\r\n}\r\n\r\n.hoverbox a .bigImage {\r\n	display: none;\r\n}\r\n\r\n.hoverbox a:hover .bigImage {\r\n	display: block;\r\n	position: absolute;\r\n	top: -33px;\r\n	left: -45px;\r\n	z-index: 1;\r\n}\r\n\r\n.hoverbox img {\r\n	background: #fff;\r\n	border: 1px solid #000000;\r\n	color: inherit;\r\n	padding: 2px;\r\n	vertical-align: top;\r\n}\r\n\r\n.hoverbox li\r\n{\r\n	background: #eee;\r\n	border: 1px solid #000000;\r\n	color: inherit;\r\n	display: inline;\r\n	float: left;\r\n	margin: 3px;\r\n	padding: 5px;\r\n	position: relative;\r\n}\r\n\r\n\r\n\r\n.hoverbox .bigImage {\r\n	border-color: #000;\r\n	max-width: 600px;\r\n	max-height: 480px;\r\n}		\r\n</style>\r\n\r\n',0,1,0,1229459611),('PBtmpl0000000000000103',1229100306,'3','pbversion0000000000001','approved','Left Align Image','Left Align Image','left_align_image','3','7','12',NULL,0,1,0,0,0,1514,NULL,0,1,0,1229459611),('PBtmpl0000000000000115',1229100306,'3','pbversion0000000000001','approved','Linked Image with Caption','Linked Image with Caption','linked_image_with_caption','3','7','12',NULL,0,1,0,0,0,1700,NULL,0,1,0,1229459611),('uRL9qtk7Rb0YRJ41LmHOJw',1229311072,'3','pbversion0000000000001','approved','Default Calendar Print List View','Default Calendar Print List View','root/import/calendar-templates/default-calendar-print-list-view','3','7','3',NULL,0,1,0,0,0,1080,NULL,0,1,0,1229459611),('nFen0xjkZn8WkpM93C9ceQ',1229117831,'3','pbversion0000000000001','approved','Shelf (Default)','Shelf (Default)','root/import/shelf-default','3','7','12',NULL,0,1,0,0,0,2282,'<style type=\"text/css\">\r\n	@import url(^/(root/import/shelf2/shelf.css););\r\n</style>\r\n<!--[if IE]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/shelf2/shelf-ie.css););\r\n	</style>\r\n<![endif]-->',0,1,0,1229459611),('StockDataTMPL000000001',1229453697,'3','pbversion0000000000001','approved','StockData Default View','StockData Default View','stockdatatmpl000000001','3','7','12',NULL,0,1,0,0,0,5126,'\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras;wobject/StockData/tools.css\" />',0,1,0,1229459611),('DashboardViewTmpl00001',1230358389,'3','pbversion0000000000001','approved','Dashboard Default View','Dashboard Default View','dashboard-default-view-template','3','7','12',NULL,0,0,0,0,0,7665,'<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/draggable.css);\"; </style>\r\n<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/dashboard.css);\"; </style>\r\n<script src=\"^Extras(wobject/Dashboard/draggable.js);\" type=\"text/javascript\"></script>\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\ndiv.dragTitle\r\n{\r\n	overflow-x:hidden;\r\n}\r\n</style>\r\n<![endif]-->',0,1,0,1231494252),('PBtmpl0000000000000021',1230269962,'3','pbversion0000000000001','approved','Data List','Data List','data_list','3','7','12',NULL,0,1,0,0,0,2218,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.errors{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultData td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>',0,1,0,1231494252),('ProjectManagerTMPL0005',1229579830,'3','pbversion0000000000001','approved','Default Resource Popup','Default Resource Popup','default-pm-resource-popup','3','7','12',NULL,0,0,0,0,0,1989,NULL,0,1,0,1231494253),('ProjectManagerTMPL0001',1229579830,'3','pbversion0000000000001','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,3820,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\n.projectView td {\n	border:solid silver 1px;\n	border-bottom:solid gray 1px;\n	font-size:9pt;\n	font-family:arial;\n}\n.projectView a {\n	color:#3391DD;\n}\ntr.header td {\n	font-weight:bold;\n}\ntd.projectNames {\n	white-space:nowrap;\n}\ntd.projectNames a {\n	display:block;\n	color:#3391DD;\n}\ntd.projectNames a.level1 {\n	margin:0 10px;\n}\ntd.projectNames a.level2 {\n	margin:0px 10px 0px 20px;\n}\ntd.projectNames a.level3 {\n	margin:0px 10px 0px 30px;\n}\ntd.projectNames a.level4 {\n	margin:0px 10px 0px 40px;\n}\ntd.projectNames a.level5 {\n	margin:0px 10px 0px 50px;\n}\ntr.alt td {\n	background-color:#F0F0F0;\n}\ndiv.completeContainer {\n	position:relative;\n	z-index:0;\n	background: #000;\n	color:white;\n	text-align:center;\n}\ndiv.completeBar {\n	position:absolute;\n	height:100%;\n	top:0px;\n	left:0px;\n	background: #7AB7E9;\n	z-index:1;\n}\ndiv.completeText {\n	position:relative;\n	height:100%;\n	top:0px;\n	left:0px;\n	z-index:2;\n}\n</style>',0,1,0,1231494253),('WikiPageTmpl0000000001',1229706257,'3','pbversion0000000000001','approved','Default Wiki Page','Default Wiki Page','default-wiki-page','3','7','12',NULL,0,0,0,0,0,3565,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview.css);\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview-core.css);\" />\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/connection/connection-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\r\n\r\n<style type=\"text/css\">\r\n#wikipage.yui-navset .yui-nav li a {\r\n    border:1px solid #000;  /* label and content borders */\r\n}\r\n\r\n#wikipage.yui-navset .yui-content {\r\n        border-top: 1px solid #000;\r\n        border-bottom: 1px solid #000;\r\n}\r\n\r\n\r\n#wikipage.yui-navset .yui-nav .selected a {\r\n    background-color:black; /* active tab, tab hover, and content bgcolor */\r\n        color: white;\r\n    border-bottom-width:0; /* no bottom border for active tab */\r\n    padding-bottom:1px; /* to match height of other tabs */\r\n}\r\n\r\n#wikipage.yui-navset-top .yui-nav .selected a {\r\n    border-bottom:0; /* no bottom border for active tab */\r\n    padding-bottom:1px; /* to match height of other tabs */\r\n}\r\n\r\n#wikipage.yui-navset-top .yui-content {\r\n    margin-top:-1px; /* for active tab overlap */\r\n}\r\n\r\n#wikipage .yui-content {\r\n    padding-top:1em; \r\n    padding-bottom:1em; \r\n}\r\n#wikipage .loading {\r\n    background-image:url(^Extras(yui/examples/tabview/img/loading.gif););\r\n    background-position:center center;\r\n    background-repeat:no-repeat;\r\n}\r\n\r\n#wikipage .loading * {\r\n    display:none;\r\n}\r\n\r\n</style>\r\n',0,1,0,1239804542),('PBtmpl0000000000000027',1230159257,'3','pbversion0000000000001','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,1743,NULL,0,1,0,1231494252),('PBtmpl0000000000000033',1230159454,'3','pbversion0000000000001','approved','Default HTTP Proxy','Default HTTP Proxy','default_http_proxy','3','7','12',NULL,0,1,0,0,0,1269,NULL,0,1,0,1231494253),('default_post_received1',1230356300,'3','pbversion0000000000001','approved','Default Post Received','Default Post Received','default_post_received','3','7','4',NULL,0,0,0,0,0,429,NULL,0,1,0,1231494252),('PBtmpl0000000000000059',1229907401,'3','pbversion0000000000001','approved','Default SQL Report','Default SQL Report','default_sql_report','3','7','12',NULL,0,1,0,0,0,4341,NULL,0,1,0,1231494253),('PBtmpl0000000000000117',1229581394,'3','pbversion0000000000001','approved','DropMenu','DropMenu','dropmenu','3','7','12',NULL,0,1,0,0,0,1076,NULL,0,1,0,1231494253),('PBtmpl0000000000000098',1229907401,'3','pbversion0000000000001','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,11222,'<style type=\"text/css\">\r\n.postBorder {\r\n	border: 1px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postBorderCurrent {\r\n	border: 3px dotted black;\r\n	margin-bottom: 10px;\r\n}\r\n.postSubject {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-weight: bold;\r\n	padding: 3px;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.postData {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.postControls\r\n{\r\n	background:#676767;\r\n	display:block;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-top: 1px;	\r\n}\r\n.postControls a:link, .postControls a:visited\r\n{\r\n	color:white;\r\n	text-decoration:underline;\r\n}\r\n.postControls a:hover {\r\n	text-decoration:none;\r\n}\r\n.postMessage {\r\n	padding: 3px;\r\n}\r\n.currentThread {\r\n	background-color: #eeeeee;\r\n}\r\n.threadHead {\r\n	font-weight: bold;\r\n	border-bottom: 1px solid #cccccc;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.threadData {\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	padding: 3px;\r\n}\r\n\r\n.tableHeader\r\n{\r\n	width:20%;\r\n	background-color:#DADADA;\r\n	font-family:arial;\r\n	font-size:9pt;	\r\n}\r\n\r\n.tableData\r\n{\r\n	width:80%;\r\n	border:solid #DADADA 1px;\r\n	font-family:arial;\r\n	font-size:9pt;	\r\n}\r\n</style>',0,1,0,1231494252),('PBtmpl0000000000000113',1229581394,'3','pbversion0000000000001','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,10612,'<style type=\"text/css\">\r\n.postBorder {\r\n	border: 1px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postBorderCurrent {\r\n	border: 3px dotted black;\r\n	margin-bottom: 10px;\r\n}\r\n.postSubject {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-weight: bold;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	padding: 3px;\r\n}\r\n.postData {\r\n	border-bottom: 1px solid #cccccc;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.postControls\r\n{\r\n	background:#676767;\r\n	display:block;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n	margin-top: 1px;	\r\n}\r\n.postControls a:link, .postControls a:visited\r\n{\r\n	color:white;\r\n	text-decoration:underline;\r\n}\r\n.postControls a:hover {\r\n	text-decoration:none;\r\n}\r\n.postMessage {\r\n	padding: 3px;\r\n}\r\n.currentThread {\r\n	background-color: #eeeeee;\r\n}\r\n.threadHead {\r\n	font-weight: bold;\r\n	border-bottom: 1px solid #cccccc;\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	background-color: #eeeeee;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.threadData {\r\n	font-family:arial;\r\n	font-size:9pt;\r\n	padding: 3px;\r\n}\r\n.linkContent\r\n{\r\n	font-family:arial;\r\n	font-size:9pt;\r\n}\r\n.linkContent a\r\n{\r\n	color:#29587E;\r\n}\r\nh2\r\n{\r\n	font-family:arial;\r\n}\r\n</style>',0,1,0,1231494252),('MultiSearchTmpl0000001',1230269962,'3','pbversion0000000000001','approved','MultiSearch Default Display','MultiSearch Default Display','multisearchtmpl0000001','3','7','12',NULL,0,1,0,0,0,1963,'<style type=\"text/css\">\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.multiSearch {\n	background-color:#DADADA;\n	border:solid gray 1px;	\n}\n</style>',0,1,0,1231494253),('CalendarDay00000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Day','Default Calendar Day','root/import/calendar-templates/default-calendar-day','3','7','12',NULL,0,0,0,0,0,8702,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n            }\r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n        }\r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n            }\r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n                        -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n                        background-color:#E9ECF3;\r\n            width:400px;\r\n            position:relative;\r\n                    vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n                        -moz-border-radius-bottomLeft:8px;\r\n            border:solid #CCD2E3 1px;\r\n        }\r\n        #mCAL .curDay {\r\n            background-color:#FFE4B3;\r\n            border-color:orange;\r\n        }\r\n                    #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n                margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n\r\n                                    #mCAL span.border {\r\n                        text-align:center;\r\n            padding:5px;\r\n            font-weight:bold;\r\n            -moz-border-radius-bottomRight:5px;\r\n            -moz-border-radius-topLeft:5px;\r\n                        color:black;\r\n            border-right:solid #CCD2E3 1px;\r\n            border-bottom: solid #CCD2E3 1px;\r\n            background-color:#ABB7D1;\r\n            -moz-box-sizing:border-box;\r\n            top:5px;\r\n            position:relative;\r\n            \r\n        }\r\n        #mCAL .curDay span.border {\r\n            background-color:orange;\r\n            color:black;\r\n            border-color:orange;\r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n                        font-weight:bold;\r\n        }\r\n        #mCAL .event a {\r\n            color:#4F4F4F;\r\n            text-decoration:none;\r\n            font-size:9px;\r\n        }\r\n        #mCAL .moreButton {\r\n            border-style:none;\r\n            z-index:5;\r\n            position:absolute;\r\n            bottom:0px;\r\n            width:100%;\r\n            height:9px;\r\n                background-color:#517AC8;\r\n            font-size:5px;\r\n            text-align:center;\r\n        }\r\n        #mCAL .moreButton:hover {\r\n            background-color:orange;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n                        background-color:#DFE3EE;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n                        text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n                        background-color:#fff;\r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:center;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>',0,1,0,1231494252),('CalendarEvent000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Event','Default Calendar Event','root/import/calendar-templates/default-calendar-event','3','7','12',NULL,0,0,0,0,0,7414,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        body * {\r\n            margin:0px;\r\n        }   \r\n        #mCAL {\r\n            \r\n        }\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n        }   \r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n        }   \r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n        }   \r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n            -moz-border-radius-topRight:8px;            \r\n        }\r\n        #mCAL .day {\r\n            background-color:#E9ECF3;           \r\n            width:400px;\r\n            position:relative;\r\n            vertical-align:top;     \r\n            -moz-border-radius-topLeft:8px;\r\n            -moz-border-radius-bottomLeft:8px;          \r\n            border:solid #CCD2E3 1px;\r\n        }\r\n\r\n        \r\n        #mCAL .months {\r\n            text-align:center;\r\n            background-color:#DFE3EE;   \r\n            color:#3E4D75;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n            text-decoration:none;           \r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n        }   \r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n            background-color:#fff;          \r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:center;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n\r\n        #mCAL .searchField {\r\n            margin: 2px 10px;\r\n            border:solid #ABB7D1 1px;\r\n        }\r\n        #mCAL .searchBtn {\r\n            background-color: #ABB7D1;\r\n            border:solid #CCD2E3 1px;\r\n            color:white;\r\n            font-weight:bold;\r\n            cursor:pointer;\r\n        }\r\n        \r\n        #mCAL .eventWrapper {\r\n            margin:2px 10px;\r\n        }\r\n    </style>',0,1,0,1241566703),('CalendarMonth000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Month','Default Calendar Month','root/import/calendar-templates/default-calendar-month','3','7','12',NULL,0,0,0,0,0,10690,'<style type=\"text/css\">\r\n		#mCAL * {\r\n			margin:0px;			\r\n		}\r\n		#mCAL td {\r\n			font-size:10px;\r\n			font-family:arial;\r\n		}\r\n		#mCAL .tab {\r\n\r\n			border-bottom-style: none;\r\n			font-weight: bold;\r\n			padding: 2px 15px 0px 15px;\r\n			text-align: center;\r\n			background-color: #E9ECF3;\r\n			-moz-border-radius-topLeft: 10px;\r\n			-moz-border-radius-topRight: 10px;\r\n			color: #7588B5;\r\n			text-decoration: none;\r\n			font-size: 10pt;\r\n			display: block;\r\n			float: left;\r\n			margin-right: 5px;\r\n		}\r\n		#mCAL .tab:hover {\r\n			color:black;\r\n		}	\r\n		#mCAL .active {\r\n			background-color:#DFE3EE;\r\n			color:#404F77;\r\n			border-bottom:solid #DFE3EE 1px;\r\n		}	\r\n		#mCAL .controls {\r\n			float:right;\r\n			vertical-align:bottom;\r\n		}\r\n		#mCAL a {\r\n			font-size:11px;\r\n			color:#517AC8;\r\n		}	\r\n		#mCAL .months {\r\n			text-align:center;\r\n			background-color:#DFE3EE;			\r\n		}\r\n		#mCAL .months a {\r\n			color:#517AC8;\r\n			text-decoration:none;\r\n		}\r\n		#mCAL .months .monthLink {\r\n			text-decoration:none;			\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:#AAB8D5;\r\n			font-size:12px;\r\n			font-weight:bold;\r\n		}	\r\n\r\n		#mCAL .months .current, #mCAL .months .monthLink:hover {\r\n			font-weight:bold;\r\n			color:#517AC8;\r\n			background-color:#fff;			\r\n			-moz-border-radius:5px;\r\n		}\r\n		#mCAL .curMonth {\r\n			text-align:center;\r\n			margin: 2px 0px;\r\n			background-color:#517AC8;\r\n			color:white;\r\n			font-size:14px;\r\n			font-weight:bold;\r\n		}\r\n\r\n\r\n\r\n/**** Month view ****/\r\n/* Table */\r\n#mCAL table#month\r\n{\r\n\r\n}\r\n\r\n#mCAL table#month *\r\n{\r\n	padding:		0px;\r\n	margin:			0px;\r\n}\r\n\r\n#mCAL table#month a\r\n{\r\n	text-decoration:	none;\r\n}\r\n\r\n#mCAL table#month th\r\n{\r\n	-moz-box-sizing:border-box;\r\n	width:			85px;\r\n	background-color:	#517AC8;\r\n	text-align:		center;\r\n	font-weight:		bold;\r\n	color:			white;	\r\n}\r\n\r\n#mCAL table#month div\r\n{\r\n	position:		relative;\r\n	width:			85px;\r\n	height:			85px;\r\n	margin:			0px;\r\n	background-color:	#E9ECF3;\r\n}\r\n\r\n#mCAL table#month ul \r\n{	\r\n	overflow:		hidden;\r\n}\r\n\r\n#mCAL table#month .active \r\n{\r\n	-moz-border-radius-topLeft:	8px;\r\n	-moz-border-radius-bottomLeft:	8px;\r\n	-moz-border-radius-bottomRight:	8px;\r\n	vertical-align:		top;		\r\n	background-color:	#CCD2E3;\r\n	border:			solid #CCD2E3 1px;\r\n}\r\n\r\n#mCAL table#month .current \r\n{\r\n	background-color:	#FFE4B3;\r\n	border-color:		orange;\r\n}\r\n\r\n#mCAL table#month .number \r\n{\r\n	-moz-border-radius-bottomLeft:5px;\r\n	display:		block;\r\n	position:		absolute;\r\n	top:			0px;\r\n	right:			0px;\r\n	height:			10px;\r\n	width:			10px;\r\n	background-color:	#516BA4;\r\n	color:			white;\r\n	text-align:		center;\r\n	vertical-align:		middle;\r\n	padding:		0px 3px 2px 2px;\r\n	font-weight:		bold;\r\n}\r\n\r\n#mCAL table#month .current .number\r\n{\r\n	background-color:	orange;\r\n	color:			black;\r\n}\r\n\r\n#mCAL table#month .events \r\n{\r\n	padding:		3px;\r\n	padding-top:		8px;\r\n	font-weight:		bold;			\r\n}\r\n\r\n#mCAL table#month .events a \r\n{\r\n	color:			#4F4F4F;\r\n	text-decoration:	none;\r\n	font-size:		9px;\r\n}\r\n\r\n#mCAL table#month .moreButton \r\n{\r\n	border-style:		none;\r\n	position:		absolute;\r\n	bottom:			0px;\r\n	width:			100%;\r\n	height:			9px;\r\n	background-color:	#517AC8;	\r\n	font-size:		5px;\r\n	text-align:		center;\r\n	-moz-border-radius-bottomLeft:	8px;\r\n	-moz-border-radius-bottomRight:	8px;\r\n}\r\n\r\n#mCAL table#month .moreButton img\r\n{\r\n	border:			none;\r\n}\r\n\r\n\r\n/* MORE STYLES */\r\n\r\n.moreDisplay \r\n{\r\n	position: 		absolute;\r\n	border:			solid orange 1px;\r\n	border-top:		solid orange 2px;\r\n	font-family:		arial;\r\n	font-size:		10px;\r\n	width:			300px;\r\n	height: 		auto;\r\n	padding:		2px;\r\n	background-color:	#FFD3A8;\r\n	color:			black;\r\n	display:        none;\r\n	z-index: 		100;\r\n}\r\n\r\n.moreDisplay a {\r\n   color: black;\r\n}\r\n\r\n* html body table#month td { position: relative; z-index: 1; }\r\n</style>\r\n\r\n<script type=\"text/javascript\" src=\'^Extras;yui/build/yahoo/yahoo.js\'></script>\r\n<script type=\"text/javascript\" src=\'^Extras;yui/build/event/event.js\' ></script>\r\n\r\n<script>\r\n<!--\r\n//<![CDATA[\r\n	\r\n   //-----------------------------------------------------------------------------------   	\r\n   function isSelfOrChildOf(parent,node) {\r\n      if(parent == node) return true;\r\n	  if(parent == null || node == null) return false;\r\n	  var childLen = parent.childNodes.length;\r\n      for (var i = 0; i < childLen; i++) {\r\n         var child = parent.childNodes[i];\r\n	     if(child.nodeType != 1) continue; //Skip text and attribute nodes\r\n	     if(isSelfOrChildOf (child,node)) {\r\n	        return true;\r\n	     }\r\n      }\r\n      return false;\r\n   }	\r\n   \r\n   //-----------------------------------------------------------------------------------   \r\n   function findParentNodeFromChild (node,tagName) {\r\n      if(node == null) return node;\r\n	  var parent = node.parentNode;\r\n	  if(parent == null) return node;\r\n	  if(parent.tagName == tagName) {\r\n	     return parent;\r\n	  }\r\n	  return findParentNodeFromChild (parent,tagName);\r\n   }\r\n   \r\n   \r\n   //-----------------------------------------------------------------------------------   \r\n   function showEvents(eventId) {\r\n	  var evt = YAHOO.util.Event.getEvent();\r\n      var targ = YAHOO.util.Event.getTarget(evt);\r\n	  \r\n	  var elem = document.getElementById(eventId);\r\n	  var td;\r\n      var pPagex;\r\n      var pPagey;\r\n          \r\n      //IE is stupid\r\n      var isIE = navigator.userAgent.indexOf(\"MSIE\") > -1;\r\n      var isIE7 = navigator.userAgent.indexOf(\"MSIE 7\") > -1;\r\n      if(isIE && !isIE7) {\r\n         //IE 6 and below don\'t register offsetTop or offsetLeft for the div\r\n         td = findParentNodeFromChild(targ,\"TD\");\r\n         pPagex = td.offsetTop;\r\n         pPagey = td.offsetLeft;\r\n      } else {\r\n         var cDiv = findParentNodeFromChild(targ,\"DIV\");\r\n	     pPagex = cDiv.offsetTop;\r\n	     pPagey = cDiv.offsetLeft;\r\n         td = findParentNodeFromChild(cDiv,\"TD\");\r\n      }\r\n      \r\n      var tdHeight = td.offsetHeight;\r\n\r\n	  var eventX = tdHeight + pPagex;\r\n	  var eventY = pPagey;\r\n		  \r\n	  elem.style.top = eventX + \'px\';\r\n	  elem.style.left = eventY + \'px\';\r\n	  elem.style.display = \"block\";\r\n      \r\n	  //Register listener\r\n	  YAHOO.util.Event.addListener(document.body,\"mousemove\",hideEvents,{ \"targ\":targ, \"elem\": elem, \"td\": td })\r\n	  return false;\r\n   }\r\n   \r\n   //-----------------------------------------------------------------------------------   \r\n   function hideEvents(e, el) {\r\n	  if(!e || !el) return;\r\n	  \r\n	  var elem = el.elem;\r\n	  var td = el.td;\r\n	  var targ = el.targ;\r\n	  \r\n	  var evtTarg = YAHOO.util.Event.getTarget(e);\r\n	  \r\n	  var inDiv = isSelfOrChildOf(elem,evtTarg);\r\n      var inTd = isSelfOrChildOf(td,evtTarg);\r\n	  var inTarget = isSelfOrChildOf(targ,evtTarg);\r\n	  \r\n	  if(inDiv || inTd || inTarget) {\r\n	     //do nothing\r\n	  } else {\r\n	     elem.style.display = \"none\";\r\n		 YAHOO.util.Event.removeListener (document.body,\"mousemove\",hideEvents);    \r\n	  }\r\n	  return false;\r\n   }\r\n   \r\n//]]>\r\n-->      \r\n</script>',0,1,0,1231494252),('CalendarSearch00000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Search','Default Calendar Search','root/import/calendar-templates/default-calendar-search','3','7','12',NULL,0,0,0,0,0,9346,'    <style type=\"text/css\">\r\n        body * {\r\n            margin:0px;\r\n            }\r\n        #mCAL {\r\n            \r\n        }\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n            }\r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n        }\r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n            }\r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n                        -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n                        background-color:#E9ECF3;\r\n            width:400px;\r\n            position:relative;\r\n                    vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n                        -moz-border-radius-bottomLeft:8px;\r\n            border:solid #CCD2E3 1px;\r\n        }\r\n        #mCAL .curDay {\r\n            background-color:#FFE4B3;\r\n            border-color:orange;\r\n        }\r\n                    #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n                margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n\r\n                                    #mCAL span.border {\r\n                        text-align:center;\r\n            padding:5px;\r\n            font-weight:bold;\r\n            -moz-border-radius-bottomRight:5px;\r\n            -moz-border-radius-topLeft:5px;\r\n                        color:black;\r\n            border-right:solid #CCD2E3 1px;\r\n            border-bottom: solid #CCD2E3 1px;\r\n            background-color:#ABB7D1;\r\n            -moz-box-sizing:border-box;\r\n            top:5px;\r\n            position:relative;\r\n            \r\n        }\r\n        #mCAL .curDay span.border {\r\n            background-color:orange;\r\n            color:black;\r\n            border-color:orange;\r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n                        font-weight:bold;\r\n        }\r\n        #mCAL .event a {\r\n            color:#4F4F4F;\r\n            text-decoration:none;\r\n            font-size:9px;\r\n        }\r\n        #mCAL .moreButton {\r\n            border-style:none;\r\n            z-index:5;\r\n            position:absolute;\r\n            bottom:0px;\r\n            width:100%;\r\n            height:9px;\r\n                background-color:#517AC8;\r\n            font-size:5px;\r\n            text-align:center;\r\n        }\r\n        #mCAL .moreButton:hover {\r\n            background-color:orange;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n                        background-color:#DFE3EE;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n                        text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n                        background-color:#fff;\r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:left;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>',0,1,0,1231494252),('CalendarWeek0000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Week','Default Calendar Week','root/import/calendar-templates/default-calendar-week','3','7','12',NULL,0,0,0,0,0,7189,'<style type=\"text/css\">\r\n		#mCAL * {\r\n			/*margin:0px;*/\r\n		}\r\n		#mCAL td {\r\n			font-size:10px;\r\n			font-family:arial;\r\n		}\r\n		#mCAL .tab {\r\n\r\n			border-bottom-style:none;\r\n			font-weight:bold;\r\n			padding: 2px 15px 0px 15px;\r\n			text-align;center;\r\n			background-color:#E9ECF3;\r\n			-moz-border-radius-topLeft:10px;\r\n			-moz-border-radius-topRight:10px;\r\n			color:#7588B5;\r\n			text-decoration:none;\r\n			font-size:10pt;\r\n			display:block;\r\n			float:left;\r\n			margin-right:5px;\r\n		}\r\n		#mCAL .tab:hover {\r\n			color:black;\r\n		}	\r\n		#mCAL .active {\r\n			background-color:#DFE3EE;\r\n			color:#404F77;\r\n			border-bottom:solid #DFE3EE 1px;\r\n		}	\r\n		#mCAL .controls {\r\n			float:right;\r\n			vertical-align:bottom;\r\n		}\r\n		#mCAL a {\r\n			font-size:11px;\r\n			color:#517AC8;\r\n		}	\r\n		#mCAL .heading {\r\n			width:200px;\r\n			-moz-box-sizing:border-box;\r\n			background-color:#ABB7D1;\r\n			text-align:center;\r\n			font-weight:bold;\r\n			color:#374664;\r\n			font-size:9px;\r\n			letter-spacing:1px;\r\n			text-transform:uppercase;\r\n			text-align:right;\r\n			vertical-align:top;\r\n			-moz-border-radius-bottomRight:8px;\r\n			-moz-border-radius-topRight:8px;			\r\n		}\r\n		#mCAL .day {\r\n			background-color:#E9ECF3;			\r\n			width:400px;\r\n			position:relative;\r\n			vertical-align:top;		\r\n			-moz-border-radius-topLeft:8px;\r\n			-moz-border-radius-bottomLeft:8px;			\r\n			border:solid #CCD2E3 1px;\r\n		}\r\n		#mCAL .curDay {\r\n			background-color:#FFE4B3;\r\n			border-color:orange;\r\n		}\r\n		#mCAL .dayWrapper {			\r\n			height:100%;\r\n			width:100%;\r\n			position:relative;\r\n			z-index:0;\r\n			margin:0px;	\r\n			padding:0px 0px 2px 5px;;\r\n			-moz-box-sizing:border-box;\r\n		}\r\n		html > body #mCAL .dayWrapper {\r\n			height:auto;\r\n			min-height:100%;\r\n		}\r\n		#mCAL .dayNum {\r\n			width:100%;\r\n			text-align:right;\r\n			\r\n		}\r\n\r\n		#mCAL span.border {							\r\n			text-align:center;			\r\n			padding:5px;\r\n			font-weight:bold;\r\n			-moz-border-radius-bottomRight:5px;\r\n			-moz-border-radius-topLeft:5px;\r\n			color:black;			\r\n			border-right:solid #CCD2E3 1px;\r\n			border-bottom: solid #CCD2E3 1px;\r\n			background-color:#ABB7D1;\r\n			-moz-box-sizing:border-box;\r\n			top:5px;\r\n			position:relative;\r\n			\r\n		}\r\n		#mCAL .curDay span.border {\r\n			background-color:orange;\r\n			color:black;\r\n			border-color:orange;\r\n		}\r\n		#mCAL .event {\r\n			padding:3px;\r\n			padding-top:8px;\r\n			clear:left;\r\n			font-weight:bold;			\r\n		}\r\n		#mCAL .event a {\r\n			color:#4F4F4F;\r\n			text-decoration:none;\r\n			font-size:9px;\r\n		}\r\n		#mCAL .moreButton {\r\n			border-style:none;\r\n			z-index:5;\r\n			position:absolute;\r\n			bottom:0px;\r\n			width:100%;\r\n			height:9px;\r\n			background-color:#517AC8;	\r\n			font-size:5px;\r\n			text-align:center;\r\n		}\r\n		#mCAL .moreButton:hover {\r\n			background-color:orange;\r\n		}\r\n		#mCAL .empty {\r\n			border-style:none;\r\n			background-color:#CCD2E3;\r\n			-moz-border-radius:10px;\r\n			\r\n		}\r\n		#mCAL .months {\r\n			text-align:center;\r\n			background-color:#DFE3EE;			\r\n		}\r\n		#mCAL .months a {\r\n			color:#517AC8;\r\n			text-decoration:none;\r\n		}\r\n		#mCAL .months .monthLink {\r\n			text-decoration:none;			\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:#AAB8D5;\r\n			font-size:12px;\r\n			font-weight:bold;\r\n		}	\r\n		#mCAL .months .current {\r\n			color:#517AC8;\r\n		}\r\n		#mCAL .current {\r\n			font-weight:bold;\r\n			color:#517AC8;\r\n			background-color:#fff;			\r\n			-moz-border-radius:5px;\r\n		}\r\n		#mCAL .curMonth {\r\n			text-align:center;\r\n			margin: 2px 0px;\r\n			background-color:#517AC8;\r\n			color:white;\r\n			font-size:14px;\r\n			font-weight:bold;\r\n		}\r\n		\r\n		/* MORE STYLES */\r\n		#more1 {\r\n			position:absolute;\r\n			top:170px;\r\n			left:10px;			\r\n			\r\n		}\r\n		* html #more1 {\r\n			top:158px;\r\n			left:12px;\r\n\r\n		}\r\n		.moreDisplay {\r\n			border:solid orange 1px;\r\n			border-top:solid orange 2px;\r\n			font-family:arial;\r\n			font-size:10px;\r\n			width:300px;\r\n			padding:2px;\r\n			background-color:#FFD3A8;\r\n			z-index:10;			\r\n		}\r\n		ul.eventList {\r\n			margin:0px;\r\n			padding:0px;\r\n			margin-left:50px;\r\n			color:#526896;\r\n		}\r\n\r\n\r\n</style>',0,1,0,1231494252),('0X4Q3tBWUb_thsVbsYz9xQ',1230581176,'3','pbversion0000000000001','approved','Default Gallery Add Archive','Default Gallery Add Archive','root/import/gallery-templates/default-gallery-add-archive','3','7','3',NULL,0,1,0,0,0,1857,'	<link href=\"^/(root/import/gallery-templates/admin.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n\r\n	<!--[if IE 7]>\r\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n	<![endif]-->',0,1,0,1244573916),('mM3bjP_iG9sv5nQb4S17tQ',1230581176,'3','pbversion0000000000001','approved','Default Gallery View Album RSS','Default Gallery View Album RSS','root/import/gallery-templates/default-gallery-album-rss','3','7','3',NULL,0,1,0,0,0,818,NULL,0,1,0,1244573917),('ilu5BrM-VGaOsec9Lm7M6Q',1230581176,'3','pbversion0000000000001','approved','Default Gallery List Albums RSS','Default Gallery List Albums RSS','root/import/gallery-templates/default-gallery-list-albums-rss','3','7','3',NULL,0,1,0,0,0,827,NULL,0,1,0,1244573917),('-ANLpoTEP-n4POAdRxCzRw',1230581176,'3','pbversion0000000000001','approved','Default Gallery List Files For User RSS','Default Gallery List Files For User RSS','root/import/gallery-templates/default-gallery-list-files-for-user-rss','3','7','3',NULL,0,1,0,0,0,858,NULL,0,1,0,1244573917),('KAMdiUdJykjN02CPHpyZOw',1230581176,'3','pbversion0000000000001','approved','Default Gallery View Album Slideshow','Default Gallery View Album Slideshow','root/import/gallery-templates/default-gallery-view-album-slideshow','3','7','3',NULL,0,1,0,0,0,4310,'<style type=\"text/css\">\r\n	@import url(^/(root/import/gallery-templates/gallery.css););\r\n</style>\r\n	\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n	</style>\r\n<![endif]-->\r\n\r\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script> \r\n<script src=\"^Extras(yui/build/event/event-min.js);\"></script>  \r\n<script src=\"^Extras(yui/build/dom/dom-min.js);\"></script>  \r\n<script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/slideshow.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\n	var ss  = new WebGUI.Slideshow();\r\n</script>',0,1,0,1244573916),('_9_eiaPgxzF_x_upt6-PNQ',1230702602,'3','pbversion0000000000001','approved','gallery.css','gallery.css','root/import/gallery-templates/gallery.css','3','7','3',NULL,0,1,0,0,0,10868,NULL,0,1,0,1244573916),('itransact_credentials1',1228953856,'3','pbversion0000000000001','approved','ITransact Credentials (Default)','ITransact Credentials (Default)','shopping-cart-collateral-items/itransact-credentials','3','7','4',NULL,0,0,0,0,0,3037,'<style type=\"text/css\">\r\n	.wgAddress h2.title {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgAddress table {\r\n		margin-top:15px;\r\n	}\r\n\r\n	.wgAddress .label {\r\n		background:#000;\r\n		color:white;\r\n		font-weight:bold;\r\n		padding-left:5px;\r\n	}\r\n	.wgAddress input, .wgAddress select {\r\n		border:solid #555 1px;\r\n	}\r\n</style>\n',0,1,0,1231494253),('StockDataTMPL000000002',1229494994,'3','pbversion0000000000001','approved','StockData Default Display','StockData Default Display','stockdatatmpl000000002','3','7','12',NULL,0,1,0,0,0,11239,NULL,0,1,0,1231494253),('GNvjCFQWjY2AF2uf0aCM8Q',1230356300,'3','pbversion0000000000001','approved','Syndicated Articles','Syndicated Articles','syndicated_articles','3','7','12',NULL,0,1,0,0,0,1063,NULL,0,1,0,1231494253),('LdiozcIUciWuvt3Z-na5Ww',1232673968,'3','pbversion0000000000001','approved','Matrix','Matrix','root/import/matrix','3','7','12',NULL,0,0,0,0,0,294,NULL,0,1,0,1239804541),('kJf77eCr9GAMiEzWrzsBTA',1229639255,'3','pbversion0000000000001','approved','matrix-ie.css','matrix-ie.css','new-matrix/matrix-ie.css','3','7','12',NULL,0,1,0,0,0,527,NULL,0,1,0,1233158079),('4LQT4-bGW4FkiEQLSY5gvQ',1232400287,'3','pbversion0000000000001','approved','show-hide.js','show-hide.js','new-matrix/show-hide.js','3','7','12',NULL,0,1,0,0,0,659,NULL,0,1,0,1233158079),('1oBRscNIcFOI-pETrCOspA',1232648656,'3','pbversion0000000000001','approved','Default Section Edit','Default Section Edit','root/import/survey/default-section-edit','3','7','12',NULL,0,1,0,0,0,5674,NULL,0,1,0,1239804541),('PBtmpl0000000000000062',1232981641,'3','pbversion0000000000001','approved','Default Gradebook Report','Default Gradebook Report','root/import/survey/default_gradebook_report','3','7','12',NULL,0,1,0,0,0,1931,NULL,0,1,0,1239804541),('PBtmpl0000000000000063',1233156264,'3','pbversion0000000000001','approved','Default Overview Report','Default Overview Report','root/import/survey/default_overview_report','3','7','12',NULL,0,1,0,0,0,3267,NULL,0,1,0,1239804541),('QHn6T9rU7KsnS3Y70KCNTg',1233173545,'3','pbversion0000000000001','approved','Account','Account','root/import/account','3','7','12',NULL,0,1,0,0,0,297,NULL,0,1,0,1239804542),('FJbUTvZ2nUTn65LpW6gjsA',1232735095,'3','pbversion0000000000001','approved','Profile Account Layout','Profile Account Layout','root/import/account/profile/profile-account-layout','3','7','12',NULL,0,1,0,0,0,2441,'<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">',0,1,0,1234301433),('75CmQgpcCSkdsL-oawdn3Q',1232561177,'3','pbversion0000000000001','approved','Default Edit Profile Template','Default Edit Profile Template','root/import/account/profile/default-edit-profile-template','3','7','12',NULL,0,1,0,0,0,2079,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-beta-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\nYAHOO.util.Event.onDOMReady(function() {\r\n    var tabView = new YAHOO.widget.TabView(\'wgAccountTabs\');\r\n});\r\n</script>',0,1,0,1234301433),('MBmWlA_YEA2I6D29OMGtRg',1228753307,'3','pbversion0000000000001','approved','Default Profile Error Template','Default Profile Error Template','root/import/account/profile/default-profile-error-template','3','7','12',NULL,0,1,0,0,0,858,NULL,0,1,0,1234301433),('gfZOwaTWYjbSoVaQtHBBEw',1232735116,'3','pbversion0000000000001','approved','Inbox Account Layout','Inbox Account Layout','root/import/account/inbox-account-layout','3','7','12',NULL,0,1,0,0,0,1906,'<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">',0,1,0,1234301433),('0n4HtbXaWa_XJHkFjetnLQ',1233168324,'3','pbversion0000000000001','approved','Default Inbox View Message Template','Default Inbox View Message Template','root/import/account/inbox/default-inbox-view-message-template','3','7','12',NULL,0,1,0,0,0,3193,NULL,0,1,0,1234301433),('1Q4Je3hKCJzeo0ZBB5YB8g',1232753312,'3','pbversion0000000000001','approved','Default Manage Invitations Template','Default Manage Invitations Template','root/import/account/inbox/default-manage-invitations-template','3','7','12',NULL,0,1,0,0,0,6052,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\nYAHOO.util.Event.onDOMReady(function(){\r\n   function isMessageCheckBox( element ) {\r\n      if(element.name == \"inviteId\") return true;\r\n      return false;\r\n   }\r\n   \r\n   function toggleAllChecked(evt) {\r\n      var allBox     = YAHOO.util.Dom.get(\"check_all\");\r\n      var checkBoxes = YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"inboxTbl\");\r\n      for (var i = 0; i < checkBoxes.length; i++) {\r\n         checkBoxes[i].checked = allBox.checked;\r\n      }\r\n   }\r\n   \r\n   YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked);\r\n});\r\n</script>',0,1,0,1234301434),('VBkY05f-E3WJS50WpdKd1Q',1233168685,'3','pbversion0000000000001','approved','Default View Invitation Template','Default View Invitation Template','root/import/account/inbox/default-view-invitation-template','3','7','12',NULL,0,1,0,0,0,2473,NULL,0,1,0,1234301434),('cR0UFm7I1qUI2Wbpj--08Q',1232464762,'3','pbversion0000000000001','approved','Default Invite User Form Template','Default Invite User Form Template','root/import/account/inbox/default-invite-user-form-template','3','7','12',NULL,0,1,0,0,0,2642,NULL,0,1,0,1234301434),('zrNpGbT3odfIkg6nFSUy8Q',1232735138,'3','pbversion0000000000001','approved','Friends Layout Template','Friends Layout Template','root/import/account/friends/friends-layout-template','3','7','12',NULL,0,1,0,0,0,1584,'<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">\r\n',0,1,0,1234301434),('1Yn_zE_dSiNuaBGNLPbxtw',1232952380,'3','pbversion0000000000001','approved','Default Friends View Template','Default Friends View Template','root/import/account/friends/default-friends-view-template','3','7','12',NULL,0,1,0,0,0,5030,NULL,0,1,0,1234301434),('AGJBGviWGAwjnwziiPjvDg',1232569232,'3','pbversion0000000000001','approved','Default Send Request Template','Default Send Request Template','root/import/account/friends/default-send-request-template','3','7','12',NULL,0,1,0,0,0,1908,NULL,0,1,0,1234301434),('9ThW278DWLV0-Svf68ljFQ',1232735163,'3','pbversion0000000000001','approved','Account Layout','Account Layout','root/import/account/user/account-layout','3','7','12',NULL,0,1,0,0,0,1101,'<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">\r\n',0,1,0,1234301434),('aUDsJ-vB9RgP-AYvPOy8FQ',1232735191,'3','pbversion0000000000001','approved','Shop Account Layout','Shop Account Layout','root/import/account/shop/shop-account-layout','3','7','12',NULL,0,1,0,0,0,1459,'<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">\r\n',0,1,0,1234301434),('b4n3VyUIsAHyIvT-W-jziA',1232735307,'3','pbversion0000000000001','approved','Contributions Layout','Contributions Layout','root/import/account/contributions/contributions-layout','3','7','12',NULL,0,1,0,0,0,1127,'<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">\r\n',0,1,0,1234301434),('N716tpSna0iIQTKxS4gTWA',1232734726,'3','pbversion0000000000001','approved','Default Account Layout','Default Account Layout','root/import/account/default-account-layout2','3','7','12',NULL,0,1,0,0,0,1008,'<link rel=\"stylesheet\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" type=\"text/css\">\r\n<link rel=\"stylesheet\" href=\"/root/import/account/account.css\" type=\"text/css\">\r\n<link rel=\"stylesheet\" href=\"^Extras(account/account.css);\" type=\"text/css\" />',0,1,0,1234301434),('HW-sPoDDZR8wBZ0YgFgPtg',1227634350,'3','pbversion0000000000001','approved','images','images','root/import/account/images','3','7','12',NULL,0,1,0,0,0,309,NULL,0,1,0,1234301434),('hBpisL-_URyZnh9clR5ohA',1227634417,'3','pbversion0000000000001','approved','no_photo.gif','no_photo.gif','root/import/account/images/no_photo.gif','3','7','12',NULL,0,1,0,0,0,2564,NULL,0,1,0,1234301434),('FOBV6KkifreXa4GmEAUU4A',1227634447,'3','pbversion0000000000001','approved','no_photo_sm.gif','no_photo_sm.gif','root/import/account/images/no_photo_sm.gif','3','7','12',NULL,0,1,0,0,0,1580,NULL,0,1,0,1234301434),('6uQEULvXFgCYlRWnYzZsuA',1233874321,'3','pbversion0000000000001','approved','Default Inbox Send Message Template','Default Inbox Send Message Template','root/import/account/inbox/default-inbox-send-message-template','3','7','12',NULL,0,1,0,0,0,5533,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras;yui/build/container/assets/skins/sam/container.css\" />\n\n<script>\n   var removeText = \'^International(remove text,Account_Inbox);\';\n</script>\n<script type=\"text/javascript\" src=\"^Extras;yui/build/yahoo-dom-event/yahoo-dom-event.js\"></script>\n<script type=\"text/javascript\" src=\"^Extras;yui/build/container/container-min.js\"></script>\n<script type=\"text/javascript\" src=\"^Extras;account/inbox.js\"></script>',0,1,0,1234301433),('CalendarEventEdit00001',1233698348,'3','pbversion0000000000001','approved','Default Calendar Event Edit','Default Calendar Event Edit','root/import/calendar-templates/default-calendar-event-edit','3','7','12',NULL,0,0,0,0,0,10149,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/dom/dom.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/dragdrop/dragdrop.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/logger/logger.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(textFix.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script>\r\n    <style type=\"text/css\">\r\n        body * {\r\n            margin:0px;\r\n        }\r\n        table td {\r\n            font-family:Arial;\r\n            font-size:10px;\r\n        }\r\n        #tabs a {\r\n            border:solid #F0F0F0 1px;\r\n            -moz-border-radius-topLeft: 20px;\r\n            -moz-border-radius-topRight: 20px;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#FBFBFB;\r\n            border-top:solid #F0F0F0 2px;\r\n            color:#b0b0b0;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #tabs a:hover {\r\n            color:black;\r\n        }\r\n        #tabs .active {\r\n            background-color:#F0F0F0;\r\n            color:#404040;\r\n        }\r\n        table a {\r\n            font-size:11px;\r\n            color:#447BFD;\r\n        }\r\n        input, select {\r\n            font-size:10px;\r\n            border:gray solid 1px;\r\n            background-color:#F0F0F0;\r\n            cursor:pointer;\r\n        }\r\n    </style>\r\n\r\n',0,1,0,1234301433),('TuYPpHx7TUyk08639Pc8Bg',1233861621,'3','pbversion0000000000001','approved','Default DataTable Template (HTML)','Default DataTable Template (HTML)','root/import/datatable/default-datatable-template-html','3','7','3',NULL,0,1,0,0,0,919,NULL,0,1,0,1234301433),('3rjnBVJRO6ZSkxlFkYh_ug',1233861835,'3','pbversion0000000000001','approved','Default DataTable Template (YUI)','Default DataTable Template (YUI)','root/import/datatable/default-datatable-template-yui','3','7','3',NULL,0,1,0,0,0,732,NULL,0,1,0,1234301433),('6X-7Twabn5KKO_AbgK3PEw',1233872216,'3','pbversion0000000000001','approved','Default Gallery Edit Album','Default Gallery Edit Album','root/import/gallery-templates/default-gallery-edit-album','3','7','3',NULL,0,1,0,0,0,3434,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1244573916),('7JCTAiu1U_bT9ldr655Blw',1233872075,'3','pbversion0000000000001','approved','Default Gallery Edit Photo','Default Gallery Edit Photo','root/import/gallery-templates/default-gallery-edit-photo','3','7','3',NULL,0,1,0,0,0,3993,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1244573916),('m3IbBavqzuKDd2PGGhKPlA',1233871747,'3','pbversion0000000000001','approved','Default Gallery Make Shortcut','Default Gallery Make Shortcut','root/import/gallery-templates/default-gallery-make-shortcut','3','7','3',NULL,0,1,0,0,0,2798,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1244573916),('AjhlNO3wZvN5k4i4qioWcg',1233874172,'3','pbversion0000000000001','approved','Default Answer Edit','Default Answer Edit','root/import/survey/default-answer-edit','3','7','12',NULL,0,1,0,0,0,3859,NULL,0,1,0,1239804541),('wAc4azJViVTpo-2NYOXWvg',1233872588,'3','pbversion0000000000001','approved','Default Question Edit','Default Question Edit','root/import/survey/default-question-edit','3','7','12',NULL,0,1,0,0,0,5042,NULL,0,1,0,1239804541),('d8jMMMRddSQ7twP4l1ZSIw',1234040817,'3','pbversion0000000000001','approved','Default Survey Take','Default Survey Take','root/import/survey/default-survey-take','3','7','12',NULL,0,1,0,0,0,1041,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts-min.css);\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/assets/skins/sam/skin.css);\" />\r\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/survey.css\" />\r\n\r\n',0,1,0,1234301433),('qsG6B24a0SC5KrhQjmdZBw',1233860274,'3','pbversion0000000000001','approved','survey.css','survey.css','survey.css','3','7','12',NULL,0,1,0,0,0,3074,NULL,0,1,0,1234301434),('PBtmpl0000000000000029',1234392043,'3','pbversion0000000000001','approved','Default Post Form','Default Post Form','default_post_form','3','7','12',NULL,0,1,0,0,0,2293,'<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1234926437),('PBtmpl0000000000000068',1234393332,'3','pbversion0000000000001','approved','Default Submission Form','Default Submission Form','default_submission_form','3','7','12',NULL,0,1,0,0,0,2787,'<style type=\"text/css\">\ntable.defaultSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1234926437),('PBtmpl0000000000000099',1234393376,'3','pbversion0000000000001','approved','FAQ Submission Form','FAQ Submission Form','faq_submission_form','3','7','12',NULL,0,1,0,0,0,2392,'<style type=\"text/css\">\ntable.faqSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.faqSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1234926437),('PBtmpl0000000000000122',1234393411,'3','pbversion0000000000001','approved','Job Submission Form','Job Submission Form','job_submission_form','3','7','12',NULL,0,1,0,0,0,3321,'<style type=\"text/css\">\ntable.jobSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.jobSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1234926437),('PBtmpl0000000000000114',1234393441,'3','pbversion0000000000001','approved','Link List Submission Form','Link List Submission Form','link_list_submission_form','3','7','12',NULL,0,1,0,0,0,3000,'<style type=\"text/css\">\ntable.linkSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.linkSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1234926437),('PBtmpl0000000000000210',1234393614,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,3204,'<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n\n\n',0,1,0,1234926437),('_XfvgNH__bY1ykMiKYSobQ',1234924781,'3','pbversion0000000000001','approved','account.css','account.css','root/import/account/account.css','3','7','12',NULL,0,1,0,0,0,23272,NULL,0,1,0,1234926436),('1IzRpX0tgW7iuCfaU2Kk0A',1234924646,'3','pbversion0000000000001','approved','Default Contributions View','Default Contributions View','root/import/account/contributions/default-contributions-view','3','7','12',NULL,0,1,0,0,0,4697,'<link rel=\"stylesheet\" href=\"root/import/account/account.css\" type=\"text/css\">\n',0,1,0,1234926436),('zcX-wIUct0S_np14xxOA-A',1234568742,'3','pbversion0000000000001','approved','Default Gallery Delete File','Default Gallery Delete File','root/import/gallery-templates/default-gallery-delete-file','3','7','3',NULL,0,1,0,0,0,2625,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1244573916),('OxJWQgnGsgyGohP2L3zJPQ',1234564647,'3','pbversion0000000000001','approved','Default Gallery Edit Comment','Default Gallery Edit Comment','root/import/gallery-templates/default-gallery-edit-comment','3','7','3',NULL,0,1,0,0,0,2977,'<link rel=\"stylesheet\" href=\"^/(root/import/gallery-templates/gallery.css);\" type=\"text/css\" />',0,1,0,1244573917),('azCqD0IjdQSlM3ar29k5Sg',1234561066,'3','pbversion0000000000001','approved','Default Gallery List Albums View','Default Gallery List Albums View','root/import/gallery-templates/default-gallery-list-albums-view','3','7','3',NULL,0,1,0,0,0,3308,'	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery.css););\r\n	</style>\r\n	\r\n	<!--[if IE ]>\r\n		<style type=\"text/css\">\r\n			@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n		</style>\r\n	<![endif]-->',0,1,0,1244573916),('OkphOEdaSGTXnFGhK4GT5A',1234560760,'3','pbversion0000000000001','approved','Default Gallery List Files For User','Default Gallery List Files For User','root/import/gallery-templates/default-gallery-list-files-for-user','3','7','3',NULL,0,1,0,0,0,4248,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1244573916),('jME5BEDYVDlBZ8jIQA9-jQ',1234565056,'3','pbversion0000000000001','approved','Default Gallery Search','Default Gallery Search','root/import/gallery-templates/default-gallery-search','3','7','3',NULL,0,1,0,0,0,5946,'\n<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n	\n<!--[if IE]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1244573916),('q5O62aH4pjUXsrQR3Pq4lw',1234568087,'3','pbversion0000000000001','approved','Default Gallery View Album Thumbnails','Default Gallery View Album Thumbnails','root/import/gallery-templates/default-gallery-view-album-thumbnails','3','7','3',NULL,0,1,0,0,0,4316,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/dom/dom-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/event/event-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/browserdetect.js);\"></script>\n<script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/thumbnails.js);\"></script>',0,1,0,1244573916),('TEId5V-jEvUULsZA0wuRuA',1234568469,'3','pbversion0000000000001','approved','Default Gallery View Photo','Default Gallery View Photo','root/import/gallery-templates/default-gallery-view-photo','3','7','3',NULL,0,1,0,0,0,6760,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<script type=\"text/javascript\">\nfunction toggleView( link, first, second, eid ) {\n	var e = document.getElementById( eid );\n	if ( e.style.display == \"none\" ) {\n		e.style.display = \"block\";\n		link.innerHTML = second;\n	}\n	else {\n		e.style.display = \"none\";\n		link.innerHTML = first;\n	}\n}\n</script>',0,1,0,1244573916),('wrq7hMxb1ewQqZ46xmd8Gg',1235706620,'3','pbversion0000000000001','approved','equal-cols.js','equal-cols.js','matrix/equal-cols.js','3','7','12',NULL,0,1,0,0,0,582,NULL,0,1,0,1236110744),('alraubvBu-YJJ614jAHD5w',1235706026,'3','pbversion0000000000001','approved','matrix-nav-tmpl','matrix-nav-tmpl','new-matrix/matrix-nav-tmpl','3','7','12',NULL,0,1,0,0,0,480,NULL,0,1,0,1236110744),('Vch1Ww7G_JpBhOhXX07RDg',1235705952,'3','pbversion0000000000001','approved','matrx-nav','matrix-nav','new-matrix/matrix-nav','3','7','12',NULL,0,1,0,0,0,353,NULL,0,1,0,1236110744),('matrixtmpl000000000006',1236713222,'3','pbversion0000000000001','approved','Matrix Default Screenshots','Matrix Default Screenshots','matrix-default-screenshots','3','7','12',NULL,0,0,0,0,0,1700,NULL,0,1,0,1236714637),('05FpjceLYhq4csF1Kww1KQ',1236641791,'3','pbversion0000000000001','approved','Default Gallery View Album','Default Gallery View Album','root/import/gallery-templates/default-gallery-view-album','3','7','3',NULL,0,1,0,0,0,4235,'	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery.css););\n	</style>\n	\n	<!--[if IE ]>\n		<style type=\"text/css\">\n			@import url(^/(root/import/gallery-templates/gallery-ie.css););\n		</style>\n	<![endif]-->',0,1,0,1244573916),('PBtmpl0000000000000137',1236787780,'3','pbversion0000000000001','approved','Admin Console Style','Admin Console','admin_console','3','7','12',NULL,0,1,0,0,0,788,NULL,0,1,0,1237326296),('PBtmpl0000000000000001',1236787921,'3','pbversion0000000000001','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,3179,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" />\r\n<script src=\"^Extras(adminConsole/adminConsole.js);\" type=\"text/javascript\"></script>',0,1,0,1237326296),('CxMpE_UPauZA3p8jdrOABw',1237313307,'3','pbversion0000000000001','approved','Default Questions','Default Questions','root/import/survey/default-questions','3','7','12',NULL,0,1,0,0,0,9363,NULL,0,1,0,1237326297),('matrixtmpl000000000003',1239120696,'3','pbversion0000000000001','approved','Matrix Default Detailed Listing','Matrix Default Detailed Listing','matrix-default-detailed-listing','3','7','12',NULL,0,0,0,0,0,4738,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script>\r\n\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix.css););\r\n</style>\r\n\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix-ie.css););\r\n</style>\r\n<![endif]-->',0,1,0,1239141874),('matrixtmpl000000000001',1239568582,'3','pbversion0000000000001','approved','Matrix Default View','Matrix Default View','matrix-default-view-template','3','7','12',NULL,0,0,0,0,0,6467,'<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix.css););\r\n</style>\r\n\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix-ie.css););\r\n</style>\r\n<![endif]-->\r\n\r\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\r\n\r\n\r\n',0,1,0,1239804543),('matrixtmpl000000000005',1239392846,'3','pbversion0000000000001','approved','Matrix Default Search','Matrix Default Search','matrix-search-template','3','7','12',NULL,0,0,0,0,0,2538,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix.css););\r\n</style>\r\n\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix-ie.css););\r\n</style>\r\n<![endif]-->',0,1,0,1239804543),('hkj6WeChxFyqfP85UlRP8w',1239898573,'3','pbversion0000000000001','approved','matrix.css','matrix.css','new-matrix/matrix.css','3','7','12',NULL,0,1,0,0,0,9088,NULL,0,1,0,1240417915),('matrixtmpl000000000002',1240947312,'3','pbversion0000000000001','approved','Matrix Default Compare','Matrix Default Compare','matrix-default-compare-template','3','7','12',NULL,0,0,0,0,0,2860,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\r\n\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix.css););\r\n</style>\r\n\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\n@import url(^/(new-matrix/matrix-ie.css););\r\n</style>\r\n<![endif]-->\r\n\r\n',0,1,0,1241566704),('matrixtmpl000000000007',1242662148,'3','pbversion0000000000001','approved','Matrix Default Screenshots Config','Matrix Default Screenshots Config','matrix-default-screenshots-config','3','7','12',NULL,0,0,0,0,0,2346,NULL,0,1,0,1242753929),('BMybD3cEnmXVk2wQ_qEsRQ',1242239790,'3','pbversion0000000000001','approved','Badge Builder (Default)','Badge Builder (Default)','root/import/ems/badge-builder-default','3','7','12',NULL,0,1,0,0,0,20634,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n\r\n\r\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui-webgui/build/string/string.js);\" type=\"text/javascript\"></script>\r\n\r\n<style type=\"text/css\">\r\n		.skuDescription {\r\n		background-color: white;\r\n		max-width: 400px;\r\n		border:1px solid #000;\r\n		padding:10px;\r\n		}\r\n		.forwardButton {\r\n			background-color: green;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		.backwardButton {\r\n			background-color: red;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		#emstickets p, #emsribbons p, #emstokens p { text-align: left; padding: 5px; }\r\n		#badge {\r\n			font-size: 15px;\r\n			-moz-border-radius: 10px;\r\n			-webkit-border-radius: 10px;\r\n			border-radius: 10px;\r\n			border: 3px solid #2647a0;\r\n		}\r\n		#badgeHolderName {\r\n			background-color: #2647a0;\r\n			width: 100%;\r\n			color: white;\r\n			font-family: bold;\r\n			font-size: 25px;\r\n			padding: 5px 0px 5px 0px;\r\n			margin: 5px 0px 5px 0px;\r\n			margin-bottom: 5px;\r\n		}\r\n		#badgeTicketList div , #badgeRibbonList div , #badgeTokenList div {\r\n			border-top: 1px solid #808080;\r\n			width: 100%;\r\n			font-size: 13px;\r\n			padding: 5px 0px 5px 0px;\r\n			margin-top: 5px;\r\n		}\r\n</style>\r\n\r\n',0,1,0,1244573909),('kj3b-X3i6zRKnhLb4ZiCLw',1243445504,'3','pbversion0000000000001','approved','Default Calendar List View','Default Calendar List View','root/import/calendar-templates/default-calendar-list-view','3','7','3',NULL,0,1,0,0,0,3193,'<style type=\"text/css\">\n	#wgListView * {\n		padding:0px;\n		margin:0px;\n	}	\n	#wgListView a:link,\n	#wgListView a:visited {			\n		font-weight:bold;\n	}\n	#wgListView .newUnit {\n		font-weight:bold;\n	}\n	#wgListView .allEvents {\n		padding-left:20px;\n	}\n	#wgListView .controls {\n		margin-top:20px;\n	}	\n	#wgListView .tab:link,\n	#wgListView .tab:visited {;\n		font-weight: bold;\n		padding: 2px 15px 0px 15px;\n		text-align: center;\n		font-size: 15px;\n		line-height:15px;\n		margin-right: 5px;		\n	}\n	#wgListView .bar {\n		text-align:right;\n	}\n	* html #wgListView .bar {\n		height:1%;\n	}\n	#wgListView .bar a:hover {\n		text-decoration:underline;\n	}\n	#wgListView .allEvents {\n		padding:15px;\n	}\n	#wgListView .event {\n		margin:10px 0px;\n	}\n	#wgListView .event .wgDate {\n		font-size:9px;\n		font-style:italic;\n	}\n	#wgListView h3 a:link,\n	#wgListView h3 a:visited {\n		font-size:16px;\n		margin-bottom:2px;\n	}\n</style>\n',0,1,0,1244573909),('F2CZVJtKtTs67DWwqDI96g',1244584987,'3','pbversion0000000000001','approved','surveyedit.css','surveyedit.css','root/import/survey/surveyedit.css','3','7','12',NULL,0,1,0,0,0,3189,NULL,0,1,0,1244573917),('UTNFeV7B_aSCRmmaFCq4Vw',1244073447,'3','pbversion0000000000001','approved','Default Gallery Delete Album','Default Gallery Delete Album','root/import/gallery-templates/default-gallery-delete-album','3','7','3',NULL,0,1,0,0,0,2618,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1244573917),('AZFU33p0jpPJ-E6qLSWZng',1244523565,'3','pbversion0000000000001','approved','Default Friends Edit Template','Default Friends Edit Template','root/import/account/friends/default-friends-edit-template','3','7','12',NULL,0,1,0,0,0,6382,NULL,0,1,0,1244573917),('2CS-BErrjMmESOtGT90qOg',1244053736,'3','pbversion0000000000001','approved','Default View Profile Template','Default View Profile Template','root/import/account/profile/default-view-profile-template','3','7','12',NULL,0,1,0,0,0,4667,NULL,0,1,0,1244573917),('c8xrwVuu5QE0XtF9DiVzLw',1244345626,'3','pbversion0000000000001','approved','Default Inbox View Template','Default Inbox View Template','root/import/account/inbox/default-inbox-view-template','3','7','12',NULL,0,1,0,0,0,6187,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function(){\n   function isMessageCheckBox( element ) {\n      if(element.name == \"message\") return true;\n      return false;\n   }\n   \n   function toggleAllChecked(evt) {\n      var allBox     = YAHOO.util.Dom.get(\"check_all\");\n      var checkBoxes = YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"WGinboxTbl\");\n      for (var i = 0; i < checkBoxes.length; i++) {\n         checkBoxes[i].checked = allBox.checked;\n      }\n   }\n   \n   YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked);\n});\n</script>',0,1,0,1244573917),('PBtmpl0000000000000135',1244554456,'3','pbversion0000000000001','approved','Side By Side','Side By Side','side_by_side','3','7','12',NULL,0,1,0,0,0,2186,'<style type=\"text/css\">\r\n.firstColumn {\r\n	float: left;\r\n	width: 50%;\r\n}\r\n\r\n.secondColumn {\r\n	float: left;\r\n	width: auto;\r\n	max-width: 50%;\r\n}\r\n\r\n.endFloat, .content {\r\n	clear: both;\r\n}\r\n</style>\r\n\r\n',0,1,0,1244573917),('GRUNFctldUgop-qRLuo_DA',1244584580,'3','pbversion0000000000001','approved','Default Survey Edit','Default Survey Edit','root/import/survey/default-survey-edit','3','7','12',NULL,0,1,0,0,0,3551,NULL,0,1,0,1244573917),('PBtmpl0000000000000081',1244679535,'3','pbversion0000000000001','approved','Q and A','Q and A','q_and_a','3','7','12',NULL,0,1,0,0,0,2568,'<style type=\"text/css\">\r\n.collab-qa { position: relative; }\r\n.collab-qa .dropcap { position: absolute; left: -1.5em; top: 0px; width: 1.4em; text-align: center; } \r\n.collab-qa dt, .collab-qa dd { margin-left: 1.5em; padding-left: 0.5em; position: relative; }\r\n.collab-qa dt, .collab-qa dt .dropcap { font-weight: bold; background-color: #ccc; line-height: 2em; height: 2em; vertical-align: bottom; }\r\n.collab-qa dt p { /* stupid controls */ margin: 0; vertical-align: top !important; }\r\n</style>\r\n',0,1,0,1244724902);
INSERT INTO `assetIndex` VALUES ('PBasset000000000000003','Media','Media Media  media ','media',1147642437,1147642437,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Media\'\'Media\'\'media','000001000003'),('PBtmpl0000000000000112','Weblog','Weblog Weblog  weblog ','weblog',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Weblog\'\'Weblog\'\'weblog Collaboration','000001000001000006000004'),('PBtmplBlankStyle000001','WebGUI 6 Blank Style','WebGUI 6 Blank Style WebGUI 6 Blank Style  pbtmplblankstyle000001 ','pbtmplblankstyle000001',1133743239,1147642431,'3','7','12','WebGUI::Asset::Template',1,'WebGUI\'\'6\'\'Blank\'\'Style\'\'WebGUI\'\'6\'\'Blank\'\'Style\'\'pbtmplblankstyle000001 style','000001000001000038000005'),('PBtmpl0000000000000048','verticalMenu','verticalMenu verticalMenu  verticalmenu ','verticalmenu',1124395696,1147642431,'3','7','12','WebGUI::Asset::Template',1,'verticalMenu\'\'verticalMenu\'\'verticalmenu Navigation','000001000001000022000002'),('PBtmpl0000000000000079','Topics','Topics Topics  topics ','topics',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Topics\'\'Topics\'\'topics Collaboration','000001000001000006000009'),('PBtmpl0000000000000097','Traditional with Thumbnails','Traditional with Thumbnails Traditional with Thumbnails  traditional with thumbnails ','traditional_with_thumbnails',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Traditional\'\'with\'\'Thumbnails\'\'Traditional\'\'with\'\'Thumbnails\'\'traditional\'\'with\'\'thumbnails Collaboration','000001000001000006000003'),('PBtmpl0000000000000082','Unordered List','Unordered List Unordered List  unordered list ','unordered_list',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Unordered\'\'List\'\'Unordered\'\'List\'\'unordered\'\'list Collaboration','000001000001000006000011'),('PBtmpl0000000000000118','Three Over One','Three Over One Three Over One  three over one ','three_over_one',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',1,'Three\'\'Over\'\'One\'\'Three\'\'Over\'\'One\'\'three\'\'over\'\'one Layout','000001000001000017000005'),('PBtmpl0000000000000124','Tabs','Tabs Tabs  tabs ','tabs',1124395696,1147642429,'3','7','12','WebGUI::Asset::Template',1,'Tabs\'\'Tabs\'\'tabs Navigation','000001000001000022000005'),('GNvjCFQWjY2AF2uf0aCM8Q','Syndicated Articles','Syndicated Articles Syndicated Articles  syndicated articles ','syndicated_articles',1124395696,1230356300,'3','7','12','WebGUI::Asset::Template',1,'Syndicated\'\'Articles\'\'Syndicated\'\'Articles\'\'syndicated\'\'articles SyndicatedContent','000001000001000040000002'),('PBtmpl0000000000000136','Synopsis','Synopsis Synopsis  synopsis2 ','synopsis2',1124395696,1147642428,'3','7','12','WebGUI::Asset::Template',1,'Synopsis\'\'Synopsis\'\'synopsis2 Navigation','000001000001000022000008'),('PBtmpl0000000000000116','Tab Form','Tab Form Tab Form  tab form ','tab_form',1124395696,1221692340,'3','7','12','WebGUI::Asset::Template',1,'Tab\'\'Form\'\'Tab\'\'Form\'\'tab\'\'form DataForm','000001000001000008000005'),('GRUNFctldUgop-qRLuo_DA','Default Survey Edit','Default Survey Edit Default Survey Edit  root import survey default survey edit ','root/import/survey/default-survey-edit',1227254010,1244584580,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Survey\'\'Edit\'\'Default\'\'Survey\'\'Edit\'\'root\'\'import\'\'survey\'\'default\'\'survey\'\'edit Survey\'\'/\'\'Edit','000001000001000039000005'),('ProjectManagerTMPL0004','Default Project Manager Edit Task','Default Project Manager Edit Task Default Project Manager Edit Task  default pm template edit task ','default-pm-template-edit-task',1147642415,1222574693,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Manager\'\'Edit\'\'Task\'\'Default\'\'Project\'\'Manager\'\'Edit\'\'Task\'\'default\'\'pm\'\'template\'\'edit\'\'task ProjectManager_editTask','000001000001000027000002000001'),('ProjectManagerTMPL0002','Default Project Display','Default Project Display Default Project Display  default pm template project display ','default-pm-template-project-display',1147642415,1222574693,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Display\'\'Default\'\'Project\'\'Display\'\'default\'\'pm\'\'template\'\'project\'\'display ProjectManager_project','000001000001000027000004000001'),('PBtmpl0000000000000137','Admin Console Style','Admin Console Style Admin Console  admin console ','admin_console',1124395696,1236787780,'3','7','12','WebGUI::Asset::Template',1,'Admin\'\'Console\'\'Style\'\'Admin\'\'Console\'\'admin\'\'console style','000001000001000038000003'),('StockDataTMPL000000001','StockData Default View','StockData Default View StockData Default View  stockdatatmpl000000001 ','stockdatatmpl000000001',1133743239,1229453697,'3','7','12','WebGUI::Asset::Template',1,'StockData\'\'Default\'\'View\'\'StockData\'\'Default\'\'View\'\'stockdatatmpl000000001 StockData','000001000001000037000002'),('PBtmpl0000000000000135','Side By Side','Side By Side Side By Side  side by side ','side_by_side',1124395696,1244554456,'3','7','12','WebGUI::Asset::Template',1,'Side\'\'By\'\'Side\'\'Side\'\'By\'\'Side\'\'side\'\'by\'\'side Layout','000001000001000017000001'),('PBtmpl0000000000000200','Default Search','Default Search Default Search  default search2 ','default_search2',1147642427,1222383245,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Search\'\'Default\'\'Search\'\'default\'\'search2 Search','000001000001000032000001'),('PBtmpl0000000000000101','Ordered List','Ordered List Ordered List  ordered list ','ordered_list',1124395696,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Ordered\'\'List\'\'Ordered\'\'List\'\'ordered\'\'list Collaboration','000001000001000006000024'),('PBtmpl0000000000000121','Photo Gallery','Photo Gallery Photo Gallery  photo gallery ','photo_gallery',1124395696,1149286279,'3','7','12','WebGUI::Asset::Template',1,'Photo\'\'Gallery\'\'Photo\'\'Gallery\'\'photo\'\'gallery Collaboration','000001000001000006000005'),('PBtmpl0000000000000081','Q and A','Q and A Q and A  q and a ','q_and_a',1124395696,1244679535,'3','7','12','WebGUI::Asset::Template',1,'Q\'\'and\'\'A\'\'Q\'\'and\'\'A\'\'q\'\'and\'\'a Collaboration','000001000001000006000023'),('WVtmpl0000000000000001','Random Thread Macro Default Template','Random Thread Macro Default Template Random Thread Macro Default Template  randomthread template ','randomthread-template',1133743240,1147642426,'3','7','12','WebGUI::Asset::Template',1,'Random\'\'Thread\'\'Macro\'\'Default\'\'Template\'\'Random\'\'Thread\'\'Macro\'\'Default\'\'Template\'\'randomthread\'\'template Macro\'\'/\'\'RandomThread','000001000001000018000010000001'),('PBtmpl0000000000000131','Right Column','Right Column Right Column  right column ','right_column',1124395696,1220655704,'3','7','12','WebGUI::Asset::Template',1,'Right\'\'Column\'\'Right\'\'Column\'\'right\'\'column Layout','000001000001000017000002'),('PBtmpl0000000000000094','News','News News  plainblacknews ','plainblacknews',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',1,'News\'\'News\'\'plainblacknews Layout','000001000001000017000007'),('matrixtmpl000000000005','Matrix Default Search','Matrix Default Search Matrix Default Search  matrix search template ','matrix-search-template',1133743239,1239392846,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Search\'\'Matrix\'\'Default\'\'Search\'\'matrix\'\'search\'\'template Matrix\'\'/\'\'Search','000001000001000019000005'),('MultiSearchTmpl0000001','MultiSearch Default Display','MultiSearch Default Display MultiSearch Default Display  multisearchtmpl0000001 ','multisearchtmpl0000001',1133743239,1230269962,'3','7','12','WebGUI::Asset::Template',1,'MultiSearch\'\'Default\'\'Display\'\'MultiSearch\'\'Default\'\'Display\'\'multisearchtmpl0000001 MultiSearch','000001000001000021000001'),('matrixtmpl000000000001','Matrix Default View','Matrix Default View Matrix Default View  matrix default view template ','matrix-default-view-template',1133743238,1239568582,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'View\'\'Matrix\'\'Default\'\'View\'\'matrix\'\'default\'\'view\'\'template Matrix','000001000001000019000002'),('matrixtmpl000000000003','Matrix Default Detailed Listing','Matrix Default Detailed Listing Matrix Default Detailed Listing  matrix default detailed listing ','matrix-default-detailed-listing',1133743238,1239120696,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Detailed\'\'Listing\'\'Matrix\'\'Default\'\'Detailed\'\'Listing\'\'matrix\'\'default\'\'detailed\'\'listing Matrix\'\'/\'\'Detail','000001000001000019000003'),('matrixtmpl000000000002','Matrix Default Compare','Matrix Default Compare Matrix Default Compare  matrix default compare template ','matrix-default-compare-template',1133743238,1240947312,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Compare\'\'Matrix\'\'Default\'\'Compare\'\'matrix\'\'default\'\'compare\'\'template Matrix\'\'/\'\'Compare','000001000001000019000001'),('PBtmpl0000000000000111','Make Page Printable','Make Page Printable Make Page Printable  make page printable ','make_page_printable',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Make\'\'Page\'\'Printable\'\'Make\'\'Page\'\'Printable\'\'make\'\'page\'\'printable style','000001000001000038000002'),('PBtmpl0000000000000020','Mail Form','Mail Form Mail Form  mail form ','mail_form',1124395696,1221692340,'3','7','12','WebGUI::Asset::Template',1,'Mail\'\'Form\'\'Mail\'\'Form\'\'mail\'\'form DataForm','000001000001000008000001'),('PBtmpl0000000000000113','Link','Link Link  link ','link',1124395696,1229581394,'3','7','12','WebGUI::Asset::Template',1,'Link\'\'Link\'\'link Collaboration\'\'/\'\'Thread','000001000001000006000025'),('PBtmpl0000000000000083','Link List','Link List Link List  link list ','link_list',1124395696,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Link\'\'List\'\'Link\'\'List\'\'link\'\'list Collaboration','000001000001000006000010'),('PBtmpl0000000000000114','Link List Submission Form','Link List Submission Form Link List Submission Form  link list submission form ','link_list_submission_form',1124395696,1234393441,'3','7','12','WebGUI::Asset::Template',1,'Link\'\'List\'\'Submission\'\'Form\'\'Link\'\'List\'\'Submission\'\'Form\'\'link\'\'list\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000006000019'),('PBtmpl0000000000000115','Linked Image with Caption','Linked Image with Caption Linked Image with Caption  linked image with caption ','linked_image_with_caption',1124395696,1229100306,'3','7','12','WebGUI::Asset::Template',1,'Linked\'\'Image\'\'with\'\'Caption\'\'Linked\'\'Image\'\'with\'\'Caption\'\'linked\'\'image\'\'with\'\'caption Article','000001000001000003000004'),('PBtmpl0000000000000129','Item w/pop-up Links','Item w/pop-up Links Item w/pop-up Links  item w pop up links ','item_w/pop-up_links',1124395696,1147642422,'3','7','12','WebGUI::Asset::Template',1,'Item\'\'w\'\'/\'\'pop\'\'-\'\'up\'\'Links\'\'Item\'\'w\'\'/\'\'pop\'\'-\'\'up\'\'Links\'\'item\'\'w\'\'pop\'\'up\'\'links Article','000001000001000003000006'),('PBtmpl0000000000000098','Job','Job Job  job ','job',1124395696,1229907401,'3','7','12','WebGUI::Asset::Template',1,'Job\'\'Job\'\'job Collaboration\'\'/\'\'Thread','000001000001000006000021'),('PBtmpl0000000000000077','Job Listing','Job Listing Job Listing  job listing ','job_listing',1124395696,1147642422,'3','7','12','WebGUI::Asset::Template',1,'Job\'\'Listing\'\'Job\'\'Listing\'\'job\'\'listing Collaboration','000001000001000006000020'),('PBtmpl0000000000000122','Job Submission Form','Job Submission Form Job Submission Form  job submission form ','job_submission_form',1124395696,1234393411,'3','7','12','WebGUI::Asset::Template',1,'Job\'\'Submission\'\'Form\'\'Job\'\'Submission\'\'Form\'\'job\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000006000022'),('PBtmpl0000000000000103','Left Align Image','Left Align Image Left Align Image  left align image ','left_align_image',1124395696,1229100306,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Align\'\'Image\'\'Left\'\'Align\'\'Image\'\'left\'\'align\'\'image Article','000001000001000003000001'),('PBtmpl0000000000000092','Horizontal Login Box','Horizontal Login Box Horizontal Login Box  horizontal login box ','horizontal_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Horizontal\'\'Login\'\'Box\'\'Horizontal\'\'Login\'\'Box\'\'horizontal\'\'login\'\'box Macro\'\'/\'\'L_loginBox','000001000001000018000009000001'),('PBtmpl0000000000000108','horizontalMenu','horizontalMenu horizontalMenu  horizontalmenu ','horizontalmenu',1124395696,1147642421,'3','7','12','WebGUI::Asset::Template',1,'horizontalMenu\'\'horizontalMenu\'\'horizontalmenu Navigation','000001000001000022000003'),('PBtmpl0000000000000088','Image','Image Image  image ','image',1124395696,1147642421,'3','7','12','WebGUI::Asset::Template',1,'Image\'\'Image\'\'image ImageAsset','000001000001000015000001'),('IOB0000000000000000002','Default InOutBoard Report Template','Default InOutBoard Report Template Default InOutBoard Report Template  iob report template ','iob-report-template',1133743239,1166019641,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'InOutBoard\'\'Report\'\'Template\'\'Default\'\'InOutBoard\'\'Report\'\'Template\'\'iob\'\'report\'\'template InOutBoard\'\'/\'\'Report','000001000001000016000001'),('IOB0000000000000000001','Default InOutBoard Template','Default InOutBoard Template Default InOutBoard Template  iob template ','iob-template',1133743239,1169795123,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'InOutBoard\'\'Template\'\'Default\'\'InOutBoard\'\'Template\'\'iob\'\'template InOutBoard','000001000001000016000002'),('PBtmpl0000000000000123','Item','Item Item  item ','item',1124395696,1147642421,'3','7','12','WebGUI::Asset::Template',1,'Item\'\'Item\'\'item Article','000001000001000003000005'),('PBtmpl0000000000000024','File','File File  file ','file',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'File\'\'File\'\'file FileAsset','000001000001000011000001'),('PBtmpl0000000000000078','File Folder','File Folder File Folder  file folder ','file_folder',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'File\'\'Folder\'\'File\'\'Folder\'\'file\'\'folder Folder','000001000001000012000001'),('PBtmpl0000000000000107','File with size','File with size File with size  file with size ','file_with_size',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',1,'File\'\'with\'\'size\'\'File\'\'with\'\'size\'\'file\'\'with\'\'size Macro\'\'/\'\'File','000001000001000018000004000003'),('PBtmpl0000000000000133','Guest Book','Guest Book Guest Book  guest book ','guest_book',1124395696,1149286278,'3','7','12','WebGUI::Asset::Template',1,'Guest\'\'Book\'\'Guest\'\'Book\'\'guest\'\'book Collaboration','000001000001000006000012'),('PBtmpl0000000000000117','DropMenu','DropMenu DropMenu  dropmenu ','dropmenu',1124395696,1229581394,'3','7','12','WebGUI::Asset::Template',1,'DropMenu\'\'DropMenu\'\'dropmenu Navigation','000001000001000022000004'),('PBtmpl0000000000000130','Tree Navigation','Tree Navigation Tree Navigation  root import navigation tree navigation ','root/import/navigation/tree-navigation',1124395696,1219072470,'3','7','12','WebGUI::Asset::Template',1,'Tree\'\'Navigation\'\'Tree\'\'Navigation\'\'root\'\'import\'\'navigation\'\'tree\'\'navigation Navigation','000001000001000022000006'),('PBtmpl0000000000000060','Fail Safe','Fail Safe Fail Safe  fail safe ','fail_safe',1124395696,1147642419,'3','7','12','WebGUI::Asset::Template',1,'Fail\'\'Safe\'\'Fail\'\'Safe\'\'fail\'\'safe style','000001000001000038000001'),('PBtmpl0000000000000080','FAQ','FAQ FAQ  faqtemplate ','faqtemplate',1124395696,1171466654,'3','7','12','WebGUI::Asset::Template',1,'FAQ\'\'FAQ\'\'faqtemplate Collaboration','000001000001000006000002'),('PBtmpl0000000000000099','FAQ Submission Form','FAQ Submission Form FAQ Submission Form  faq submission form ','faq_submission_form',1124395696,1234393376,'3','7','12','WebGUI::Asset::Template',1,'FAQ\'\'Submission\'\'Form\'\'FAQ\'\'Submission\'\'Form\'\'faq\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000006000018'),('PBtmpl0000000000000010','Default WebGUI Account Display Template','Default WebGUI Account Display Template Default WebGUI Account Display Template  default webgui account display template ','default_webgui_account_display_template',1124395696,1227026287,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Account\'\'Display\'\'Template\'\'Default\'\'WebGUI\'\'Account\'\'Display\'\'Template\'\'default\'\'webgui\'\'account\'\'display\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Account','000001000001000004000004000001'),('PBtmpl0000000000000013','Default WebGUI Login Template','Default WebGUI Login Template Default WebGUI Login Template  default webgui login template ','default_webgui_login_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Login\'\'Template\'\'Default\'\'WebGUI\'\'Login\'\'Template\'\'default\'\'webgui\'\'login\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Login','000001000001000004000007000001'),('PBtmpl0000000000000012','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template Default WebGUI Password Reset Template  default webgui password reset template ','default_webgui_password_reset_template',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Password\'\'Reset\'\'Template\'\'Default\'\'WebGUI\'\'Password\'\'Reset\'\'Template\'\'default\'\'webgui\'\'password\'\'reset\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Expired','000001000001000004000006000001'),('PBtmpl0000000000000057','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt Default WebGUI Yes/No Prompt  default webgui yes no prompt ','default_webgui_yes/no_prompt',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Yes\'\'/\'\'No\'\'Prompt\'\'Default\'\'WebGUI\'\'Yes\'\'/\'\'No\'\'Prompt\'\'default\'\'webgui\'\'yes\'\'no\'\'prompt prompt','000001000001000028000001'),('PBtmpl0000000000000066','Default USS','Default USS Default USS  default uss ','default_uss',1124395696,1147642417,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'USS\'\'Default\'\'USS\'\'default\'\'uss Collaboration','000001000001000006000001'),('TimeTrackingTMPL000001','Default Time Tracking User View','Default Time Tracking User View Default Time Tracking User View  default tt template user ','default-tt-template-user',1147642417,1201205738,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Time\'\'Tracking\'\'User\'\'View\'\'Default\'\'Time\'\'Tracking\'\'User\'\'View\'\'default\'\'tt\'\'template\'\'user TimeTracking_user','000001000001000042000003000001'),('TimeTrackingTMPL000003','Default Time Tracking Row Template','Default Time Tracking Row Template Default Time Tracking Row Template  default tt template row ','default-tt-template-row',1147642417,1229311434,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Time\'\'Tracking\'\'Row\'\'Template\'\'Default\'\'Time\'\'Tracking\'\'Row\'\'Template\'\'default\'\'tt\'\'template\'\'row TimeTracking_row','000001000001000042000002000001'),('TimeTrackingTMPL000002','Default Time Tracking Manager View','Default Time Tracking Manager View Default Time Tracking Manager View  default tt template manager ','default-tt-template-manager',1147642417,1147642417,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Time\'\'Tracking\'\'Manager\'\'View\'\'Default\'\'Time\'\'Tracking\'\'Manager\'\'View\'\'default\'\'tt\'\'template\'\'manager TimeTracking_manager','000001000001000042000001000001'),('X7DrzUcj8pOKFa_6k9D5iw','Newsletter','Newsletter Newsletter  root import newsletter ','root/import/newsletter',1185754569,1222804045,'3','12','3','WebGUI::Asset::Wobject::Folder',1,'Newsletter\'\'Newsletter\'\'root\'\'import\'\'newsletter','000001000001000023'),('PBtmpl0000000000000065','Default Syndicated Content','Default Syndicated Content Default Syndicated Content  default syndicated content ','default_syndicated_content',1124395696,1226457084,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Syndicated\'\'Content\'\'Default\'\'Syndicated\'\'Content\'\'default\'\'syndicated\'\'content SyndicatedContent','000001000001000040000001'),('CxMpE_UPauZA3p8jdrOABw','Default Questions','Default Questions Default Questions  root import survey default questions ','root/import/survey/default-questions',1227556536,1237313307,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Questions\'\'Default\'\'Questions\'\'root\'\'import\'\'survey\'\'default\'\'questions Survey\'\'/\'\'Take','000001000001000039000007'),('PBtmpl0000000000000064','Default Response','Default Response Default Response  default response ','default_response',1124395696,1226009610,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Response\'\'Default\'\'Response\'\'default\'\'response Survey\'\'/\'\'Response','000001000001000039000004'),('PBtmpl0000000000000059','Default SQL Report','Default SQL Report Default SQL Report  default sql report ','default_sql_report',1124395696,1229907401,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'SQL\'\'Report\'\'Default\'\'SQL\'\'Report\'\'default\'\'sql\'\'report SQLReport','000001000001000036000001'),('PBtmpl0000000000000067','Default Submission','Default Submission Default Submission  default submission ','default_submission',1124395696,1206998733,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Submission\'\'Default\'\'Submission\'\'default\'\'submission Collaboration\'\'/\'\'Thread','000001000001000006000006'),('PBtmpl0000000000000068','Default Submission Form','Default Submission Form Default Submission Form  default submission form ','default_submission_form',1124395696,1234393332,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Submission\'\'Form\'\'Default\'\'Submission\'\'Form\'\'default\'\'submission\'\'form Collaboration\'\'/\'\'PostForm','000001000001000006000017'),('PBtmpl0000000000000061','Default Survey','Default Survey Default Survey  default survey ','default_survey',1124395696,1227252733,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Survey\'\'Default\'\'Survey\'\'default\'\'survey Survey','000001000001000039000003'),('ProjectManagerTMPL0003','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart Default Project Manager Gantt Chart  default pm template gantt chart ','default-pm-template-gantt-chart',1147642415,1159989349,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Manager\'\'Gantt\'\'Chart\'\'Default\'\'Project\'\'Manager\'\'Gantt\'\'Chart\'\'default\'\'pm\'\'template\'\'gantt\'\'chart ProjectManager_gantt','000001000001000027000003000001'),('ProjectManagerTMPL0001','Default Project Management System Dashboard','Default Project Management System Dashboard Default Project Management System Dashboard  default pm template dashboard ','default-pm-template-dashboard',1147642415,1229579830,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Project\'\'Management\'\'System\'\'Dashboard\'\'Default\'\'Project\'\'Management\'\'System\'\'Dashboard\'\'default\'\'pm\'\'template\'\'dashboard ProjectManager_dashboard','000001000001000027000001000001'),('PBtmpl0000000000000055','Default Poll','Default Poll Default Poll  default poll ','default_poll',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Poll\'\'Default\'\'Poll\'\'default\'\'poll Poll','000001000001000024000001'),('PBtmpl0000000000000029','Default Post Form','Default Post Form Default Post Form  default post form ','default_post_form',1124395696,1234392043,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Post\'\'Form\'\'Default\'\'Post\'\'Form\'\'default\'\'post\'\'form Collaboration\'\'/\'\'PostForm','000001000001000006000013'),('PBtmpl0000000000000056','Default Product','Default Product Default Product  default product ','default_product',1124395696,1228934532,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Product\'\'Default\'\'Product\'\'default\'\'product Product','000001000001000025000001'),('PBtmpl0000000000000033','Default HTTP Proxy','Default HTTP Proxy Default HTTP Proxy  default http proxy ','default_http_proxy',1124395696,1230159454,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'HTTP\'\'Proxy\'\'Default\'\'HTTP\'\'Proxy\'\'default\'\'http\'\'proxy HttpProxy','000001000001000014000001'),('PBtmpl0000000000000004','Default LDAP Account Display Template','Default LDAP Account Display Template Default LDAP Account Display Template  default ldap account display template ','default_ldap_account_display_template',1124395696,1227026214,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LDAP\'\'Account\'\'Display\'\'Template\'\'Default\'\'LDAP\'\'Account\'\'Display\'\'Template\'\'default\'\'ldap\'\'account\'\'display\'\'template Auth\'\'/\'\'LDAP\'\'/\'\'Account','000001000001000004000001000001'),('PBtmpl0000000000000006','Default LDAP Login Template','Default LDAP Login Template Default LDAP Login Template  default ldap login template ','default_ldap_login_template',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LDAP\'\'Login\'\'Template\'\'Default\'\'LDAP\'\'Login\'\'Template\'\'default\'\'ldap\'\'login\'\'template Auth\'\'/\'\'LDAP\'\'/\'\'Login','000001000001000004000003000001'),('PBtmpl0000000000000044','Default Login Box','Default Login Box Default Login Box  default login box ','default_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Login\'\'Box\'\'Default\'\'Login\'\'Box\'\'default\'\'login\'\'box Macro\'\'/\'\'L_loginBox','000001000001000018000009000002'),('PBtmpl0000000000000047','Default Message Board','Default Message Board Default Message Board  default message board ','default_message_board',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Message\'\'Board\'\'Default\'\'Message\'\'Board\'\'default\'\'message\'\'board MessageBoard','000001000001000020000001'),('PBtmpl0000000000000054','Default Page','Default Page Default Page  default page ','default_page',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Page\'\'Default\'\'Page\'\'default\'\'page Layout','000001000001000017000003'),('Q4uX_C557arTp6D_jwB1jQ','Wiki','Wiki Wiki  root import wiki ','root/import/wiki',1165460175,1222803760,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'Wiki\'\'Wiki\'\'root\'\'import\'\'wiki','000001000001000048'),('BmLaN4rmAANkCglXUViEbg','Resource','Resource Resource  root import projectmanager resource ','root/import/projectmanager/resource',1157679165,1222803871,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'Resource\'\'Resource\'\'root\'\'import\'\'projectmanager\'\'resource','000001000001000027000005'),('PBtmpl0000000000000039','Default File Macro','Default File Macro Default File Macro  default file macro ','default_file_macro',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'File\'\'Macro\'\'Default\'\'File\'\'Macro\'\'default\'\'file\'\'macro Macro\'\'/\'\'File','000001000001000018000004000001'),('PBtmpl0000000000000026','Default Forum','Default Forum Default Forum  default forum ','default_forum',1124395696,1185754569,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Forum\'\'Default\'\'Forum\'\'default\'\'forum Collaboration','000001000001000006000007'),('PBtmpl0000000000000031','Default Forum Search','Default Forum Search Default Forum Search  default forum search ','default_forum_search',1124395696,1147642413,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Forum\'\'Search\'\'Default\'\'Forum\'\'Search\'\'default\'\'forum\'\'search Collaboration\'\'/\'\'Search','000001000001000006000016'),('PBtmpl0000000000000093','crumbTrail','crumbTrail crumbTrail  crumbtrail2 ','crumbtrail2',1124395696,1147642412,'3','7','12','WebGUI::Asset::Template',1,'crumbTrail\'\'crumbTrail\'\'crumbtrail2 Navigation','000001000001000022000001'),('DashboardViewTmpl00001','Dashboard Default View','Dashboard Default View Dashboard Default View  dashboard default view template ','dashboard-default-view-template',1133743239,1230358389,'3','7','12','WebGUI::Asset::Template',1,'Dashboard\'\'Default\'\'View\'\'Dashboard\'\'Default\'\'View\'\'dashboard\'\'default\'\'view\'\'template Dashboard','000001000001000007000001'),('PBtmpl0000000000000021','Data List','Data List Data List  data list ','data_list',1124395696,1230269962,'3','7','12','WebGUI::Asset::Template',1,'Data\'\'List\'\'Data\'\'List\'\'data\'\'list DataForm\'\'/\'\'List','000001000001000008000004'),('PBtmpl0000000000000104','Default Acknowledgement','Default Acknowledgement Default Acknowledgement  default acknowledgement ','default_acknowledgement',1124395696,1147642412,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Acknowledgement\'\'Default\'\'Acknowledgement\'\'default\'\'acknowledgement DataForm','000001000001000008000003'),('PBtmpl0000000000000002','Default Article','Default Article Default Article  default article ','default_article',1124395696,1159989349,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Article\'\'Default\'\'Article\'\'default\'\'article Article','000001000001000003000003'),('PBtmpl0000000000000141','Default DataForm','Default DataForm Default DataForm  pbtmpl0000000000000141 ','pbtmpl0000000000000141',1124395696,1221692340,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'DataForm\'\'Default\'\'DataForm\'\'pbtmpl0000000000000141 DataForm','000001000001000008000006'),('WikiRCTmpl000000000001','Default Recent Changes','Default Recent Changes Default Recent Changes  default wiki recent changes ','default-wiki-recent-changes',1165460175,1169092823,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Recent\'\'Changes\'\'Default\'\'Recent\'\'Changes\'\'default\'\'wiki\'\'recent\'\'changes WikiMaster_recentChanges','000001000001000048000001'),('PBtmpl0000000000000084','Center Image','Center Image Center Image  center image ','center_image',1124395696,1229100305,'3','7','12','WebGUI::Asset::Template',1,'Center\'\'Image\'\'Center\'\'Image\'\'center\'\'image Article','000001000001000003000002'),('PBtmpl0000000000000128','Classifieds','Classifieds Classifieds  classifieds ','classifieds',1124395696,1147642411,'3','7','12','WebGUI::Asset::Template',1,'Classifieds\'\'Classifieds\'\'classifieds Collaboration','000001000001000006000008'),('PBtmpl0000000000000134','Hierarchical Top Nav','Hierarchical Top Nav Hierarchical Top Nav  import hierarchical top nav ','import/hierarchical-top-nav',1124395696,1222574692,'3','7','12','WebGUI::Asset::Template',1,'Hierarchical\'\'Top\'\'Nav\'\'Hierarchical\'\'Top\'\'Nav\'\'import\'\'hierarchical\'\'top\'\'nav Navigation','000001000001000022000007'),('PBtmplHelp000000000001','Help','Help Help  help ','help',1124395706,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Help\'\'Help\'\'help AdminConsole','000001000001000002000002'),('PBtmpl0000000000000208','Request Tracker','Request Tracker Request Tracker  request tracker template ','request-tracker-template',1147642410,1147642410,'3','7','12','WebGUI::Asset::Template',1,'Request\'\'Tracker\'\'Request\'\'Tracker\'\'request\'\'tracker\'\'template Collaboration','000001000001000006000027'),('wAc4azJViVTpo-2NYOXWvg','Default Question Edit','Default Question Edit Default Question Edit  root import survey default question edit ','root/import/survey/default-question-edit',1226009650,1233872588,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Question\'\'Edit\'\'Default\'\'Question\'\'Edit\'\'root\'\'import\'\'survey\'\'default\'\'question\'\'edit Survey\'\'/\'\'Edit','000001000001000039000009'),('1z9J1O08n_7gVVlBwSRBJQ','Auth','Auth Auth  root import auth ','root/import/auth',1222803099,1222803099,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth\'\'Auth\'\'root\'\'import\'\'auth','000001000001000004'),('zyWi26q9na-iiZqL4yedog','Macro','Macro Macro  root import macro ','root/import/macro',1222803114,1222803114,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro\'\'Macro\'\'root\'\'import\'\'macro','000001000001000018'),('PBtmpl0000000000000207','Article with Files','Article with Files Article with Files  article with files ','article-with-files',1147642410,1229100306,'3','7','12','WebGUI::Asset::Template',1,'Article\'\'with\'\'Files\'\'Article\'\'with\'\'Files\'\'article\'\'with\'\'files Article','000001000001000003000007'),('PBtmpl0000000000000209','Request Tracker Thread','Request Tracker Thread Request Tracker Thread  request tracker post template ','request-tracker-post-template',1147642410,1206998862,'3','7','12','WebGUI::Asset::Template',1,'Request\'\'Tracker\'\'Thread\'\'Request\'\'Tracker\'\'Thread\'\'request\'\'tracker\'\'post\'\'template Collaboration\'\'/\'\'Thread','000001000001000006000028'),('PBtmpl0000000000000210','Request Tracker','Request Tracker Request Tracker  request tracker template2 ','request-tracker-template2',1147642410,1234393614,'3','7','12','WebGUI::Asset::Template',1,'Request\'\'Tracker\'\'Request\'\'Tracker\'\'request\'\'tracker\'\'template2 Collaboration\'\'/\'\'PostForm','000001000001000006000029'),('PBtmpl0000000000000109','One Over Three','One Over Three One Over Three  one over three ','one_over_three',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',1,'One\'\'Over\'\'Three\'\'One\'\'Over\'\'Three\'\'one\'\'over\'\'three Layout','000001000001000017000006'),('PBtmpl0000000000000001','Admin Console','Admin Console Admin Console  admin console2 ','admin_console2',1124395696,1236787921,'3','7','12','WebGUI::Asset::Template',1,'Admin\'\'Console\'\'Admin\'\'Console\'\'admin\'\'console2 AdminConsole','000001000001000002000001'),('LBuiKzg2mWwmOPS9AgV3bg','Get Translated','Let our team of professional translators bring your site to new customers by translating your content into additional languages. Our translation services are never machine automated. They\'re always done by professional translators that have years of exper','yns/translated',1147642517,1147642517,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Translated\'\'Get\'\'Translated\'\'yns\'\'translated\'\'Let\'\'our\'\'team\'\'of\'\'professional\'\'translators\'\'bring\'\'your\'\'site\'\'to\'\'new\'\'customers\'\'by\'\'translating\'\'your\'\'content\'\'into\'\'additional\'\'languages\'\'.\'\'Our\'\'translation\'\'services\'\'are\'\'never\'\'machine\'\'automated\'\'.\'\'They\'\'\'\'\'re\'\'always\'\'done\'\'by\'\'professional\'\'translators\'\'that\'\'have\'\'years\'\'of\'\'experience\'\'reading\'\',\'\'writing\'\',\'\'and\'\'speaking\'\'many\'\'languages\'\'.  ','000001000002000002000007'),('jTNggl7AoVSUc_ZzrvuCmw','Get Promoted','Now that you have a brilliant WebGUI site, you need to get people to visit it. We can help there too. Our marketing specialists can work with you to develop and execute the right combination of search engine placement, advertising buys, and affilliate pro','yns/promotion',1147642517,1147642517,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Promoted\'\'Get\'\'Promoted\'\'yns\'\'promotion\'\'Now\'\'that\'\'you\'\'have\'\'a\'\'brilliant\'\'WebGUI\'\'site\'\',\'\'you\'\'need\'\'to\'\'get\'\'people\'\'to\'\'visit\'\'it\'\'.\'\'We\'\'can\'\'help\'\'there\'\'too\'\'.\'\'Our\'\'marketing\'\'specialists\'\'can\'\'work\'\'with\'\'you\'\'to\'\'develop\'\'and\'\'execute\'\'the\'\'right\'\'combination\'\'of\'\'search\'\'engine\'\'placement\'\',\'\'advertising\'\'buys\'\',\'\'and\'\'affilliate\'\'programs\'\'to\'\'ensure\'\'your\'\'site\'\'gets\'\'the\'\'traffic\'\'it\'\'needs\'\'.  ','000001000002000002000008'),('Wl8WZ43g2rK5AYr9o4zY7w','Get Style','Not a designer? No problem! Plain Black\'s professional design team can make your site look great. Our team is fast, easy to work with, and can even migrate your existing content into your new WebGUI site. ','yns/style',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Style\'\'Get\'\'Style\'\'yns\'\'style\'\'Not\'\'a\'\'designer\'\'?\'\'No\'\'problem\'\'!\'\'Plain\'\'Black\'\'\'\'\'s\'\'professional\'\'design\'\'team\'\'can\'\'make\'\'your\'\'site\'\'look\'\'great\'\'.\'\'Our\'\'team\'\'is\'\'fast\'\',\'\'easy\'\'to\'\'work\'\'with\'\',\'\'and\'\'can\'\'even\'\'migrate\'\'your\'\'existing\'\'content\'\'into\'\'your\'\'new\'\'WebGUI\'\'site\'\'.  ','000001000002000002000006'),('ix1p0AbwKAz8QWB-T-HHfg','Get Support','Plain Black provides support packages to fit any budget or need. Start out with online support which costs only $500 per year! And grow support as your needs grow. We build custom support packages to match our client\'s needs. And no matter what level of s','yns/support',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Support\'\'Get\'\'Support\'\'yns\'\'support\'\'Plain\'\'Black\'\'provides\'\'support\'\'packages\'\'to\'\'fit\'\'any\'\'budget\'\'or\'\'need\'\'.\'\'Start\'\'out\'\'with\'\'online\'\'support\'\'which\'\'costs\'\'only\'\'$\'\'500\'\'per\'\'year\'\'!\'\'And\'\'grow\'\'support\'\'as\'\'your\'\'needs\'\'grow\'\'.\'\'We\'\'build\'\'custom\'\'support\'\'packages\'\'to\'\'match\'\'our\'\'client\'\'\'\'\'s\'\'needs\'\'.\'\'And\'\'no\'\'matter\'\'what\'\'level\'\'of\'\'support\'\'you\'\'purchase\'\',\'\'you\'\'get\'\'WebGUI\'\'Documentation\'\'included\'\'in\'\'your\'\'purchase\'\'.  ','000001000002000002000003'),('iCYOjohB9SKvAPr6bXElKA','Get Hosting','Who better to host your WebGUI sites than Plain Black. Let us deal with upgrades, security, and server management. Doing so lets you focus on building your WebGUI site, which is where your time and expertise should be spent. And when you sign up with host','yns/hosting',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Hosting\'\'Get\'\'Hosting\'\'yns\'\'hosting\'\'Who\'\'better\'\'to\'\'host\'\'your\'\'WebGUI\'\'sites\'\'than\'\'Plain\'\'Black\'\'.\'\'Let\'\'us\'\'deal\'\'with\'\'upgrades\'\',\'\'security\'\',\'\'and\'\'server\'\'management\'\'.\'\'Doing\'\'so\'\'lets\'\'you\'\'focus\'\'on\'\'building\'\'your\'\'WebGUI\'\'site\'\',\'\'which\'\'is\'\'where\'\'your\'\'time\'\'and\'\'expertise\'\'should\'\'be\'\'spent\'\'.\'\'And\'\'when\'\'you\'\'sign\'\'up\'\'with\'\'hosting\'\',\'\'online\'\'support\'\'is\'\'included\'\'!  ','000001000002000002000004'),('4Yfz9hqBqM8OYMGuQK8oLw','Get Features','What\'s that you say? WebGUI\'s thousands of features are still missing some important ones? No problem, our professional development team can add any features you need for your site. We\'ve built hundreds of custom apps for people. From simple macros, to cu','yns/features',1147642516,1147642516,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Features\'\'Get\'\'Features\'\'yns\'\'features\'\'What\'\'\'\'\'s\'\'that\'\'you\'\'say\'\'?\'\'WebGUI\'\'\'\'\'s\'\'thousands\'\'of\'\'features\'\'are\'\'still\'\'missing\'\'some\'\'important\'\'ones\'\'?\'\'No\'\'problem\'\',\'\'our\'\'professional\'\'development\'\'team\'\'can\'\'add\'\'any\'\'features\'\'you\'\'need\'\'for\'\'your\'\'site\'\'.\'\'We\'\'\'\'\'ve\'\'built\'\'hundreds\'\'of\'\'custom\'\'apps\'\'for\'\'people\'\'.\'\'From\'\'simple\'\'macros\'\',\'\'to\'\'custom\'\'single\'\'sign\'\'on\'\'systems\'\',\'\'to\'\'applications\'\'that\'\'will\'\'manage\'\'your\'\'entire\'\'company\'\',\'\'our\'\'team\'\'can\'\'do\'\'it\'\'.  ','000001000002000002000005'),('Vzv1pWpg_w6R_o-b0rM2qQ','Ad','Ad Ad  home ad2 ','home/ad2',1147642515,1147642515,'3','7','4','WebGUI::Asset::File',1,'Ad\'\'Ad\'\'home\'\'ad2','000001000002000001000002'),('FOvmwGC0GtZo5VTxJIL3OA','Get Documentation','WebGUI Documentation is the ultimate compendium to WebGUI. This is a must for anyone working in WebGUI, and Plain Black offers vast bulk discounts so you can give it to everyone in your organization. ','yns/docs',1147642515,1207068851,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get\'\'Documentation\'\'Get\'\'Documentation\'\'yns\'\'docs\'\'WebGUI\'\'Documentation\'\'is\'\'the\'\'ultimate\'\'compendium\'\'to\'\'WebGUI\'\'.\'\'This\'\'is\'\'a\'\'must\'\'for\'\'anyone\'\'working\'\'in\'\'WebGUI\'\',\'\'and\'\'Plain\'\'Black\'\'offers\'\'vast\'\'bulk\'\'discounts\'\'so\'\'you\'\'can\'\'give\'\'it\'\'to\'\'everyone\'\'in\'\'your\'\'organization\'\'.  ','000001000002000002000002'),('6QuS-0rosuZTdTv11fobig','Talk to the Experts','Plain Black&reg; created the WebGUI Content Engine&reg; and is here to answer your questions and provide you with services to make sure your WebGUI implementation is entirely successful. We bend over backwards to make sure you\'re a success. Contact us tod','yns/experts',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Talk\'\'to\'\'the\'\'Experts\'\'Talk\'\'to\'\'the\'\'Experts\'\'yns\'\'experts\'\'Plain\'\'Black\'\'&\'\'reg\'\';\'\'created\'\'the\'\'WebGUI\'\'Content\'\'Engine\'\'&\'\'reg\'\';\'\'and\'\'is\'\'here\'\'to\'\'answer\'\'your\'\'questions\'\'and\'\'provide\'\'you\'\'with\'\'services\'\'to\'\'make\'\'sure\'\'your\'\'WebGUI\'\'implementation\'\'is\'\'entirely\'\'successful\'\'.\'\'We\'\'bend\'\'over\'\'backwards\'\'to\'\'make\'\'sure\'\'you\'\'\'\'\'re\'\'a\'\'success\'\'.\'\'Contact\'\'us\'\'today\'\'to\'\'see\'\'how\'\'we\'\'can\'\'help\'\'you\'\'.  ','000001000002000002000001'),('NK8bqlwVRILJknqeCDPBHg','Getting Started (part 2)','\n\nNow you should log in and go into admin mode. The default username is \"admin\" and the default password is \"123qwe\", but you probably customized both of those when you visited this site for the very first time.\n \n\nNow that you\'re logged in, we recommend ','getting_started/getting-started-part2',1147642515,1147642515,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting\'\'Started\'\'(\'\'part\'\'2\'\')\'\'Getting\'\'Started\'\'(\'\'part\'\'2\'\')\'\'getting\'\'started\'\'getting\'\'started\'\'part2\'\'Now\'\'you\'\'should\'\'log\'\'in\'\'and\'\'go\'\'into\'\'admin\'\'mode\'\'.\'\'The\'\'default\'\'username\'\'is\'\'\"\'\'admin\'\'\"\'\'and\'\'the\'\'default\'\'password\'\'is\'\'\"\'\'123qwe\'\'\"\'\',\'\'but\'\'you\'\'probably\'\'customized\'\'both\'\'of\'\'those\'\'when\'\'you\'\'visited\'\'this\'\'site\'\'for\'\'the\'\'very\'\'first\'\'time\'\'.\'\'Now\'\'that\'\'you\'\'\'\'\'re\'\'logged\'\'in\'\',\'\'we\'\'recommend\'\'that\'\'you\'\'add\'\'a\'\'new\'\'user\'\'for\'\'yourself\'\'with\'\'admin\'\'privileges\'\'just\'\'in\'\'case\'\'you\'\'forget\'\'the\'\'login\'\'information\'\'for\'\'your\'\'primary\'\'admin\'\'account\'\'.\'\'Don\'\'\'\'\'t\'\'worry\'\'if\'\'you\'\'lock\'\'yourself\'\'out\'\',\'\'you\'\'can\'\'always\'\'contact\'\'Plain\'\'Black\'\'&\'\'reg\'\';\'\'support\'\'to\'\'get\'\'instructions\'\'to\'\'get\'\'back\'\'in\'\'.\'\'NOTE\'\':\'\'If\'\'you\'\'appear\'\'to\'\'be\'\'get\'\'logged\'\'out\'\'while\'\'moving\'\'between\'\'pages\'\',\'\'this\'\'is\'\'most\'\'likely\'\'your\'\'browser\'\'displaying\'\'a\'\'cached\'\'version\'\'of\'\'the\'\'page\'\'.\'\'Click\'\'on\'\'your\'\'browser\'\'\'\'\'s\'\'refresh\'\'button\'\'to\'\'correct\'\'the\'\'problem\'\'.\'\'No\'\'doubt\'\'after\'\'you\'\'enabled\'\'admin\'\'mode\'\'you\'\'saw\'\'a\'\'menu\'\'along\'\'the\'\'left\'\'side\'\'of\'\'the\'\'screen\'\',\'\'that\'\'\'\'\'s\'\'called\'\'the\'\'Admin\'\'Bar\'\'.\'\'Use\'\'that\'\'to\'\'add\'\'content\'\'and\'\'access\'\'administrative\'\'functions\'\'.\'\'You\'\'\'\'\'re\'\'now\'\'ready\'\'to\'\'begin\'\'exploring\'\'your\'\'new\'\'WebGUI\'\'site\'\'.\'\'For\'\'more\'\'information\'\'about\'\'services\'\'related\'\'to\'\'WebGUI\'\'click\'\'here\'\'.\'\'Enjoy\'\'your\'\'new\'\'WebGUI\'\'site\'\'!  ','000001000002000001000003'),('m4YJFaqzultnB_sj1Uq0aw','Ad','Ad Ad  home ad ','home/ad',1147642514,1147642514,'3','7','4','WebGUI::Asset::File',1,'Ad\'\'Ad\'\'home\'\'ad','000001000002000008'),('IWFxZDyGhQ3-SLZhELa3qw','Key Benefits','\n\nEasy To Use - WebGUI is absolutely easy to use. WebGUI 7 has a completely revamped user interface to make it even easier to use. There are lots of visual cues, consistent icons, helper apps, and a huge repository of built-in help files.\n \n\nWorkflow &amp','home/key-benefits',1147642514,1147642514,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Key\'\'Benefits\'\'Key\'\'Benefits\'\'home\'\'key\'\'benefits\'\'Easy\'\'To\'\'Use\'\'-\'\'WebGUI\'\'is\'\'absolutely\'\'easy\'\'to\'\'use\'\'.\'\'WebGUI\'\'7\'\'has\'\'a\'\'completely\'\'revamped\'\'user\'\'interface\'\'to\'\'make\'\'it\'\'even\'\'easier\'\'to\'\'use\'\'.\'\'There\'\'are\'\'lots\'\'of\'\'visual\'\'cues\'\',\'\'consistent\'\'icons\'\',\'\'helper\'\'apps\'\',\'\'and\'\'a\'\'huge\'\'repository\'\'of\'\'built\'\'-\'\'in\'\'help\'\'files\'\'.\'\'Workflow\'\'&\'\'amp\'\';\'\'Versioning\'\'-\'\'Never\'\'again\'\'worry\'\'about\'\'content\'\'getting\'\'put\'\'on\'\'your\'\'site\'\'that\'\'you\'\'don\'\'\'\'\'t\'\'want\'\'there\'\'.\'\'Never\'\'again\'\'lose\'\'your\'\'old\'\'content\'\'after\'\'making\'\'an\'\'edit\'\'.\'\'And\'\'never\'\'again\'\'push\'\'out\'\'new\'\'changes\'\'until\'\'you\'\'\'\'\'re\'\'absolutely\'\'ready\'\'to\'\'release\'\'them\'\'.\'\'WebGUI\'\'\'\'\'s\'\'workflow\'\'and\'\'versioning\'\'system\'\'is\'\'fast\'\',\'\'flexible\'\',\'\'powerful\'\',\'\'and\'\'easy\'\'to\'\'use\'\'.\'\'Everything\'\'\'\'\'s\'\'a\'\'Template\'\'-\'\'Worry\'\'nevermore\'\'about\'\'your\'\'CMS\'\'forcing\'\'you\'\'into\'\'a\'\'mould\'\'that\'\'doesn\'\'\'\'\'t\'\'suit\'\'you\'\'.\'\'With\'\'WebGUI\'\'everything\'\'a\'\'site\'\'visitor\'\'can\'\'see\'\'is\'\'a\'\'customizable\'\'template\'\',\'\'so\'\'you\'\'can\'\'make\'\'it\'\'look\'\'exactly\'\'how\'\'you\'\'want\'\'.\'\'Moreover\'\'if\'\'you\'\'\'\'\'re\'\'the\'\'type\'\'that\'\'strives\'\'for\'\'excellence\'\'rest\'\'in\'\'the\'\'knowledge\'\'that\'\'all\'\'the\'\'templates\'\'that\'\'come\'\'with\'\'WebGUI\'\'are\'\'XHTML\'\'1\'\'.\'\'0\'\'strict\'\'compliant\'\'.\'\'Localization\'\'-\'\'WebGUI\'\'\'\'\'s\'\'entire\'\'user\'\'interface\'\'is\'\'set\'\'up\'\'to\'\'be\'\'internationalized\'\'.\'\'Visit\'\'one\'\'of\'\'the\'\'WebGUI\'\'Worldwide\'\'member\'\'sites\'\'to\'\'get\'\'translations\'\'for\'\'your\'\'language\'\'.\'\'Stay\'\'there\'\'to\'\'get\'\'support\'\'and\'\'services\'\'in\'\'your\'\'native\'\'language\'\'.\'\'Feel\'\'confident\'\'in\'\'the\'\'knowledge\'\'that\'\'WebGUI\'\'will\'\'work\'\'with\'\'your\'\'native\'\'characters\'\'because\'\'it\'\'\'\'\'s\'\'UTF\'\'-\'\'8\'\'compliant\'\'.\'\'On\'\'top\'\'of\'\'that\'\'WebGUI\'\'allows\'\'you\'\'to\'\'customize\'\'dates\'\',\'\'currency\'\',\'\'and\'\'weights\'\'to\'\'match\'\'your\'\'locale\'\'.\'\'Pluggable\'\'By\'\'Design\'\'-\'\'With\'\'WebGUI\'\'7\'\'you\'\'have\'\'many\'\'plug\'\'-\'\'in\'\'points\'\'to\'\'add\'\'your\'\'own\'\'functionality\'\'.\'\'And\'\'best\'\'of\'\'all\'\',\'\'the\'\'API\'\'is\'\'stable\'\'and\'\'standardized\'\'.\'\'Write\'\'it\'\'today\'\'and\'\'it\'\'will\'\'still\'\'work\'\'years\'\'from\'\'now\'\'and\'\'survive\'\'all\'\'upgrades\'\'.  ','000001000002000009'),('bX5rYxb6tZ9docY6sUhBlw','Getting Started','\n\nIf you\'re reading this message that means you\'ve successfully installed and configured the WebGUI Content Engine&reg;. Great job! To get started with managing content, watch the short instructional video below.\n \nNOTE: Click on the green start icon on t','getting_started/getting-started',1147642514,1147642514,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting\'\'Started\'\'Getting\'\'Started\'\'getting\'\'started\'\'getting\'\'started\'\'If\'\'you\'\'\'\'\'re\'\'reading\'\'this\'\'message\'\'that\'\'means\'\'you\'\'\'\'\'ve\'\'successfully\'\'installed\'\'and\'\'configured\'\'the\'\'WebGUI\'\'Content\'\'Engine\'\'&\'\'reg\'\';\'\'.\'\'Great\'\'job\'\'!\'\'To\'\'get\'\'started\'\'with\'\'managing\'\'content\'\',\'\'watch\'\'the\'\'short\'\'instructional\'\'video\'\'below\'\'.\'\'NOTE\'\':\'\'Click\'\'on\'\'the\'\'green\'\'start\'\'icon\'\'on\'\'the\'\'video\'\'to\'\'begin\'\'your\'\'tutorial\'\'.  ','000001000002000001000001'),('Szs5eev3OMssmnsyLRZmWA','Tell A Friend','Tell a friend about WebGUI.','tell_a_friend/tell_a_friend',1124395696,1213317790,'3','7','3','WebGUI::Asset::Wobject::DataForm',1,'Tell\'\'A\'\'Friend\'\'Tell\'\'A\'\'Friend\'\'tell\'\'a\'\'friend\'\'tell\'\'a\'\'friend\'\'Tell\'\'a\'\'friend\'\'about\'\'WebGUI\'\'.','000001000002000004000001'),('OhdaFLE7sXOzo_SIP2ZUgA','Welcome','The WebGUI Content Engine&reg; is a powerful and easy to use system for managing web sites, and building web applications. It provides thousands of features out of the box, and lots of plug-in points so you can extend it to match your needs. It\'s easy eno','home/welcome',1147642513,1147642513,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Welcome\'\'Welcome\'\'home\'\'welcome\'\'The\'\'WebGUI\'\'Content\'\'Engine\'\'&\'\'reg\'\';\'\'is\'\'a\'\'powerful\'\'and\'\'easy\'\'to\'\'use\'\'system\'\'for\'\'managing\'\'web\'\'sites\'\',\'\'and\'\'building\'\'web\'\'applications\'\'.\'\'It\'\'provides\'\'thousands\'\'of\'\'features\'\'out\'\'of\'\'the\'\'box\'\',\'\'and\'\'lots\'\'of\'\'plug\'\'-\'\'in\'\'points\'\'so\'\'you\'\'can\'\'extend\'\'it\'\'to\'\'match\'\'your\'\'needs\'\'.\'\'It\'\'\'\'\'s\'\'easy\'\'enough\'\'for\'\'the\'\'average\'\'business\'\'user\'\',\'\'but\'\'powerful\'\'enough\'\'for\'\'any\'\'large\'\'enterprise\'\'.\'\'There\'\'are\'\'thousands\'\'of\'\'small\'\'and\'\'large\'\'businesses\'\',\'\'schools\'\',\'\'universities\'\',\'\'governments\'\',\'\'associations\'\',\'\'clubs\'\',\'\'churches\'\',\'\'projects\'\',\'\'and\'\'communities\'\'using\'\'WebGUI\'\'all\'\'over\'\'the\'\'world\'\'today\'\'.\'\'A\'\'brief\'\'list\'\'of\'\'some\'\'of\'\'them\'\'can\'\'be\'\'found\'\'here\'\'.\'\'Your\'\'site\'\'should\'\'be\'\'on\'\'that\'\'list\'\'.\'\'If\'\'you\'\'\'\'\'re\'\'new\'\'to\'\'WebGUI\'\',\'\'click\'\'here\'\'to\'\'learn\'\'how\'\'to\'\'get\'\'started\'\'.\'\'If\'\'you\'\'\'\'\'re\'\'getting\'\'up\'\'to\'\'speed\'\',\'\'check\'\'out\'\'some\'\'ways\'\'you\'\'can\'\'do\'\'more\'\'faster\'\'.\'\'If\'\'this\'\'is\'\'all\'\'old\'\'hat\'\'to\'\'you\'\',\'\'then\'\'check\'\'out\'\'the\'\'latest\'\'news\'\'.\'\'No\'\'matter\'\'what\'\'level\'\'you\'\'\'\'\'re\'\'at\'\'tell\'\'your\'\'friends\'\'about\'\'WebGUI\'\'.  ','000001000002000007'),('pbrobot000000000000001','robots.txt','robots.txt robots.txt  robots.txt ','robots.txt',1147642511,1147642511,'3','7','12','WebGUI::Asset::Snippet',1,'robots\'\'.\'\'txt\'\'robots\'\'.\'\'txt\'\'robots\'\'.\'\'txt User\'\'-\'\'agent\'\':\'\'googlebot\'\'Disallow\'\':\'\'*\'\'?\'\'op\'\'=\'\'displayLogin\'\'Disallow\'\':\'\'*\'\'?\'\'op\'\'=\'\'makePrintable','000001000001000031'),('7-0-style0000000000071','wg.jpg','wg.jpg wg.jpg  style3 wg.jpg ','style3/wg.jpg',1147642511,1147642511,'3','7','12','WebGUI::Asset::File::Image',1,'wg\'\'.\'\'jpg\'\'wg\'\'.\'\'jpg\'\'style3\'\'wg\'\'.\'\'jpg','000001000001000047000022'),('7-0-style0000000000068','spacer.gif','spacer.gif spacer.gif  style3 spacer.gif ','style3/spacer.gif',1147642510,1147642510,'3','7','12','WebGUI::Asset::File::Image',1,'spacer\'\'.\'\'gif\'\'spacer\'\'.\'\'gif\'\'style3\'\'spacer\'\'.\'\'gif','000001000001000047000019'),('7-0-style0000000000070','Style3 Coolmenu','Style3 Coolmenu Style3 Coolmenu  style3 coolmenu ','style3_coolmenu',1147642510,1147642510,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3\'\'Coolmenu\'\'Style3\'\'Coolmenu\'\'style3\'\'coolmenu','000001000001000047000021'),('7-0-style0000000000066','nav_bg_on.jpg','nav_bg_on.jpg nav_bg_on.jpg  style3 nav bg on.jpg ','style3/nav_bg_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg_on\'\'.\'\'jpg\'\'nav_bg_on\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg\'\'on\'\'.\'\'jpg','000001000001000047000017'),('7-0-style0000000000064','nav_bg2.jpg','nav_bg2.jpg nav_bg2.jpg  style3 nav bg2.jpg ','style3/nav_bg2.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2\'\'.\'\'jpg\'\'nav_bg2\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg2\'\'.\'\'jpg','000001000001000047000015'),('7-0-style0000000000065','nav_bg2_on.jpg','nav_bg2_on.jpg nav_bg2_on.jpg  style3 nav bg2 on.jpg ','style3/nav_bg2_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2_on\'\'.\'\'jpg\'\'nav_bg2_on\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg2\'\'on\'\'.\'\'jpg','000001000001000047000016'),('7-0-style0000000000067','pb.jpg','pb.jpg pb.jpg  style3 pb.jpg ','style3/pb.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'pb\'\'.\'\'jpg\'\'pb\'\'.\'\'jpg\'\'style3\'\'pb\'\'.\'\'jpg','000001000001000047000018'),('7-0-style0000000000063','nav_bg1_on.jpg','nav_bg1_on.jpg nav_bg1_on.jpg  style3 nav bg1 on.jpg ','style3/nav_bg1_on.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1_on\'\'.\'\'jpg\'\'nav_bg1_on\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg1\'\'on\'\'.\'\'jpg','000001000001000047000014'),('7-0-style0000000000060','main_top_bg.jpg','main_top_bg.jpg main_top_bg.jpg  style3 main top bg.jpg ','style3/main_top_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'main_top_bg\'\'.\'\'jpg\'\'main_top_bg\'\'.\'\'jpg\'\'style3\'\'main\'\'top\'\'bg\'\'.\'\'jpg','000001000001000047000011'),('7-0-style0000000000062','nav_bg1.jpg','nav_bg1.jpg nav_bg1.jpg  style3 nav bg1.jpg ','style3/nav_bg1.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1\'\'.\'\'jpg\'\'nav_bg1\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg1\'\'.\'\'jpg','000001000001000047000013'),('7-0-style0000000000061','nav_bg.jpg','nav_bg.jpg nav_bg.jpg  style3 nav bg.jpg ','style3/nav_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg\'\'.\'\'jpg\'\'nav_bg\'\'.\'\'jpg\'\'style3\'\'nav\'\'bg\'\'.\'\'jpg','000001000001000047000012'),('7-0-style0000000000059','main_top.jpg','main_top.jpg main_top.jpg  style3 main top.jpg ','style3/main_top.jpg',1147642507,1213386091,'3','7','12','WebGUI::Asset::File::Image',1,'main_top\'\'.\'\'jpg\'\'main_top\'\'.\'\'jpg\'\'style3\'\'main\'\'top\'\'.\'\'jpg','000001000001000047000010'),('7-0-style0000000000057','main_bg.jpg','main_bg.jpg main_bg.jpg  style3 main bg.jpg ','style3/main_bg.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'jpg\'\'main_bg\'\'.\'\'jpg\'\'style3\'\'main\'\'bg\'\'.\'\'jpg','000001000001000047000008'),('7-0-style0000000000058','main_bottom.jpg','main_bottom.jpg main_bottom.jpg  style3 main bottom.jpg ','style3/main_bottom.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bottom\'\'.\'\'jpg\'\'main_bottom\'\'.\'\'jpg\'\'style3\'\'main\'\'bottom\'\'.\'\'jpg','000001000001000047000009'),('7-0-style0000000000055','header_left.jpg','header_left.jpg header_left.jpg  style3 header left.jpg ','style3/header_left.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_left\'\'.\'\'jpg\'\'header_left\'\'.\'\'jpg\'\'style3\'\'header\'\'left\'\'.\'\'jpg','000001000001000047000006'),('7-0-style0000000000056','header_right.jpg','header_right.jpg header_right.jpg  style3 header right.jpg ','style3/header_right.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_right\'\'.\'\'jpg\'\'header_right\'\'.\'\'jpg\'\'style3\'\'header\'\'right\'\'.\'\'jpg','000001000001000047000007'),('7-0-style0000000000054','header_bg.jpg','header_bg.jpg header_bg.jpg  style3 header bg.jpg ','style3/header_bg.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_bg\'\'.\'\'jpg\'\'header_bg\'\'.\'\'jpg\'\'style3\'\'header\'\'bg\'\'.\'\'jpg','000001000001000047000005'),('7-0-style0000000000052','footer_bg.jpg','footer_bg.jpg footer_bg.jpg  style3 footer bg.jpg ','style3/footer_bg.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_bg\'\'.\'\'jpg\'\'footer_bg\'\'.\'\'jpg\'\'style3\'\'footer\'\'bg\'\'.\'\'jpg','000001000001000047000003'),('7-0-style0000000000053','footer_right.jpg','footer_right.jpg footer_right.jpg  style3 footer right.jpg ','style3/footer_right.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_right\'\'.\'\'jpg\'\'footer_right\'\'.\'\'jpg\'\'style3\'\'footer\'\'right\'\'.\'\'jpg','000001000001000047000004'),('7-0-style0000000000046','rightCol_bg.jpg','rightCol_bg.jpg rightCol_bg.jpg  style2 rightcol bg.jpg ','style2/rightcol_bg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'rightCol_bg\'\'.\'\'jpg\'\'rightCol_bg\'\'.\'\'jpg\'\'style2\'\'rightcol\'\'bg\'\'.\'\'jpg','000001000001000046000015'),('stevestyle000000000002','Style 02','Style 02 Style 02  style 02 ','style_02',1147642504,1222383245,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'02\'\'Style\'\'02\'\'style\'\'02 style','000001000001000046000016'),('7-0-style0000000000049','WebGUI 7 Style 3','WebGUI 7 Style 3 WebGUI 7 Style 3  root import webgui 7 style 3 ','root/import/webgui-7-style-3',1147642504,1224117144,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'7\'\'Style\'\'3\'\'WebGUI\'\'7\'\'Style\'\'3\'\'root\'\'import\'\'webgui\'\'7\'\'style\'\'3','000001000001000047'),('7-0-style0000000000048','wg.jpg','wg.jpg wg.jpg  style2 wg.jpg ','style2/wg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'wg\'\'.\'\'jpg\'\'wg\'\'.\'\'jpg\'\'style2\'\'wg\'\'.\'\'jpg','000001000001000046000017'),('7-0-style0000000000045','pb_wg_bg.jpg','pb_wg_bg.jpg pb_wg_bg.jpg  style2 pb wg bg.jpg ','style2/pb_wg_bg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg_bg\'\'.\'\'jpg\'\'pb_wg_bg\'\'.\'\'jpg\'\'style2\'\'pb\'\'wg\'\'bg\'\'.\'\'jpg','000001000001000046000014'),('7-0-style0000000000044','pb_wg.jpg','pb_wg.jpg pb_wg.jpg  style2 pb wg.jpg ','style2/pb_wg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg\'\'.\'\'jpg\'\'pb_wg\'\'.\'\'jpg\'\'style2\'\'pb\'\'wg\'\'.\'\'jpg','000001000001000046000013'),('7-0-style0000000000043','pb.jpg','pb.jpg pb.jpg  style2 pb.jpg ','style2/pb.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb\'\'.\'\'jpg\'\'pb\'\'.\'\'jpg\'\'style2\'\'pb\'\'.\'\'jpg','000001000001000046000012'),('7-0-style0000000000042','page_title_bg.jpg','page_title_bg.jpg page_title_bg.jpg  style2 page title bg.jpg ','style2/page_title_bg.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title_bg\'\'.\'\'jpg\'\'page_title_bg\'\'.\'\'jpg\'\'style2\'\'page\'\'title\'\'bg\'\'.\'\'jpg','000001000001000046000011'),('7-0-style0000000000041','page_title.jpg','page_title.jpg page_title.jpg  style2 page title.jpg ','style2/page_title.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title\'\'.\'\'jpg\'\'page_title\'\'.\'\'jpg\'\'style2\'\'page\'\'title\'\'.\'\'jpg','000001000001000046000010'),('7-0-style0000000000040','navbar_right.jpg','navbar_right.jpg navbar_right.jpg  style2 navbar right.jpg ','style2/navbar_right.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_right\'\'.\'\'jpg\'\'navbar_right\'\'.\'\'jpg\'\'style2\'\'navbar\'\'right\'\'.\'\'jpg','000001000001000046000009'),('7-0-style0000000000039','navbar_left.jpg','navbar_left.jpg navbar_left.jpg  style2 navbar left.jpg ','style2/navbar_left.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_left\'\'.\'\'jpg\'\'navbar_left\'\'.\'\'jpg\'\'style2\'\'navbar\'\'left\'\'.\'\'jpg','000001000001000046000008'),('7-0-style0000000000036','main_bg.jpg','main_bg.jpg main_bg.jpg  style2 main bg.jpg ','style2/main_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'jpg\'\'main_bg\'\'.\'\'jpg\'\'style2\'\'main\'\'bg\'\'.\'\'jpg','000001000001000046000005'),('7-0-style0000000000038','navbar_bg.jpg','navbar_bg.jpg navbar_bg.jpg  style2 navbar bg.jpg ','style2/navbar_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_bg\'\'.\'\'jpg\'\'navbar_bg\'\'.\'\'jpg\'\'style2\'\'navbar\'\'bg\'\'.\'\'jpg','000001000001000046000007'),('7-0-style0000000000035','leftCol_header02.jpg','leftCol_header02.jpg leftCol_header02.jpg  style2 leftcol header02.jpg ','style2/leftcol_header02.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header02\'\'.\'\'jpg\'\'leftCol_header02\'\'.\'\'jpg\'\'style2\'\'leftcol\'\'header02\'\'.\'\'jpg','000001000001000046000004'),('7-0-style0000000000037','nav_bg.jpg','nav_bg.jpg nav_bg.jpg  style2 nav bg.jpg ','style2/nav_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg\'\'.\'\'jpg\'\'nav_bg\'\'.\'\'jpg\'\'style2\'\'nav\'\'bg\'\'.\'\'jpg','000001000001000046000006'),('7-0-style0000000000032','context_bg.jpg','context_bg.jpg context_bg.jpg  style2 context bg.jpg ','style2/context_bg.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'context_bg\'\'.\'\'jpg\'\'context_bg\'\'.\'\'jpg\'\'style2\'\'context\'\'bg\'\'.\'\'jpg','000001000001000046000001'),('7-0-style0000000000031','WebGUI 7 Style 2','WebGUI 7 Style 2 WebGUI 7 Style 2  root import webgui 7 style 2 ','root/import/webgui-7-style-2',1147642500,1147642500,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'7\'\'Style\'\'2\'\'WebGUI\'\'7\'\'Style\'\'2\'\'root\'\'import\'\'webgui\'\'7\'\'style\'\'2','000001000001000046'),('7-0-style0000000000033','css02.css','css02.css css02.css  style2 css02.css ','style2/css02.css',1147642500,1147642500,'3','7','12','WebGUI::Asset::Snippet',1,'css02\'\'.\'\'css\'\'css02\'\'.\'\'css\'\'style2\'\'css02\'\'.\'\'css body\'\',\'\'html\'\'{\'\'height\'\':\'\'100\'\'%\'\';\'\'}\'\'body\'\'{\'\'background\'\':\'\'#\'\'7c9ab0\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'main_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'.\'\'rightColumn\'\'{\'\'width\'\':\'\'20\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'background\'\':\'\'#\'\'eeeeee\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'rightCol_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'pb_wg_bg\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'pb_wg_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'pb_wg\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'pb_wg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'left\'\'no\'\'-\'\'repeat\'\';\'\'height\'\':\'\'53px\'\';\'\'}\'\'.\'\'leftColumn\'\'{\'\'width\'\':\'\'80\'\'%\'\';\'\'background\'\':\'\'white\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'context_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'background\'\':\'\'#\'\'7c9ab0\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'leftCol_header\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'right\'\'no\'\'-\'\'repeat\'\';\'\'height\'\':\'\'86px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title\'\',\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title_bg\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'36pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'variant\'\':\'\'small\'\'-\'\'caps\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'12px\'\';\'\'top\'\':\'\'15px\'\';\'\'left\'\':\'\'5px\'\';\'\'position\'\':\'\'absolute\'\';\'\'z\'\'-\'\'index\'\':\'\'10\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'header\'\'#\'\'title_bg\'\'{\'\'color\'\':\'\'black\'\';\'\'z\'\'-\'\'index\'\':\'\'5\'\';\'\'top\'\':\'\'17px\'\';\'\'left\'\':\'\'7px\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'context\'\'{\'\'/\'\'*\'\'background\'\':\'\'#\'\'fff\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'context_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\'right\'\';\'\'*\'\'/\'\'width\'\':\'\'95\'\'%\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'color\'\':\'\'#\'\'242424\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'position\'\':\'\'relative\'\';\'\'padding\'\'-\'\'left\'\':\'\'1\'\'%\'\';\'\'padding\'\'-\'\'right\'\':\'\'1\'\'%\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'15px\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'context\'\'a\'\'{\'\'color\'\':\'\'#\'\'7C9AB0\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'context\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'pageTitleBG\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'page_title_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'pageTitleBG\'\'#\'\'pageTitle\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'page_title\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'right\'\'no\'\'-\'\'repeat\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'50px\'\';\'\'}\'\'.\'\'leftColumn\'\'#\'\'pageTitleBG\'\'#\'\'pageTitle\'\'h2\'\'{\'\'font\'\'-\'\'size\'\':\'\'14pt\'\';\'\'color\'\':\'\'#\'\'696969\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\'-\'\'top\'\':\'\'2px\'\';\'\'padding\'\'-\'\'left\'\':\'\'25px\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'3px\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'nav\'\'{\'\'width\'\':\'\'85\'\'%\'\';\'\'background\'\':\'\'#\'\'b5b5b5\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style2\'\'/\'\'nav_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'#\'\'848484\'\'1px\'\';\'\'margin\'\'-\'\'left\'\':\'\'auto\'\';\'\'margin\'\'-\'\'right\'\':\'\'auto\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'padding\'\'-\'\'left\'\':\'\'3px\'\';\'\'padding\'\'-\'\'top\'\':\'\'7px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'7px\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'nav\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'line\'\'-\'\'height\'\':\'\'8pt\'\';\'\'}\'\'.\'\'rightColumn\'\'#\'\'nav\'\'.\'\'selectedMenuItem\'\'{\'\'color\'\':\'\'yellow\'\';\'\'}\'\'#\'\'loginStyles\'\'{\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'25px\'\';\'\'}\'\'#\'\'loginStyles\'\'a\'\'{\'\'color\'\':\'\'#\'\'89ACCF\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'transparent\'\'2px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'loginStyles\'\'a\'\':\'\'hover\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'dotted\'\'#\'\'B2C9D9\'\'2px\'\';\'\'}\'\'.\'\'copyright\'\'{\'\'border\'\'-\'\'top\'\':\'\'solid\'\'silver\'\'3px\'\';\'\'background\'\'-\'\'color\'\':\'\'gray\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'color\'\':\'\'silver\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}','000001000001000046000002'),('7-0-style0000000000034','leftCol_header.jpg','leftCol_header.jpg leftCol_header.jpg  style2 leftcol header.jpg ','style2/leftcol_header.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header\'\'.\'\'jpg\'\'leftCol_header\'\'.\'\'jpg\'\'style2\'\'leftcol\'\'header\'\'.\'\'jpg','000001000001000046000003'),('stevenav00000000000001','Style 01 Nav','Style 01 Nav Style 01 Nav  style1 nav ','style1_nav',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'01\'\'Nav\'\'Style\'\'01\'\'Nav\'\'style1\'\'nav Navigation','000001000001000045000027'),('PBnav000000style01lvl2','Style 01 Nav lvl2','Style 01 Nav lvl2 untitled  style1 nav lvl2 ','style1_nav_lvl2',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'01\'\'Nav\'\'lvl2\'\'untitled\'\'style1\'\'nav\'\'lvl2 Navigation','000001000001000045000028'),('7-0-style0000000000030','webgui_btn.jpg','webgui_btn.jpg webgui_btn.jpg  style1 webgui btn.jpg ','style1/webgui_btn.jpg',1147642499,1147642499,'3','7','12','WebGUI::Asset::File::Image',1,'webgui_btn\'\'.\'\'jpg\'\'webgui_btn\'\'.\'\'jpg\'\'style1\'\'webgui\'\'btn\'\'.\'\'jpg','000001000001000045000029'),('stevestyle000000000001','Style 01','Style 01 Style 01  style 01 ','style_01',1147642499,1222383245,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'01\'\'Style\'\'01\'\'style\'\'01 style','000001000001000045000026'),('7-0-style0000000000026','RootTab Level 1','RootTab Level 1 RootTab Level 1  roottab level1 ','roottab_level1',1147642499,1147642499,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab\'\'Level\'\'1\'\'RootTab\'\'Level\'\'1\'\'roottab\'\'level1','000001000001000045000025'),('7-0-style0000000000024','orange_left01.jpg','orange_left01.jpg orange_left01.jpg  style1 orange left01.jpg ','style1/orange_left01.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'orange_left01\'\'.\'\'jpg\'\'orange_left01\'\'.\'\'jpg\'\'style1\'\'orange\'\'left01\'\'.\'\'jpg','000001000001000045000023'),('7-0-style0000000000023','nav_on.jpg','nav_on.jpg nav_on.jpg  style1 nav on.jpg ','style1/nav_on.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'nav_on\'\'.\'\'jpg\'\'nav_on\'\'.\'\'jpg\'\'style1\'\'nav\'\'on\'\'.\'\'jpg','000001000001000045000022'),('7-0-style0000000000025','RootTab Level 0','RootTab Level 0 RootTab Level 0  roottab level0 ','roottab_level0',1147642498,1147642498,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab\'\'Level\'\'0\'\'RootTab\'\'Level\'\'0\'\'roottab\'\'level0','000001000001000045000024'),('7-0-style0000000000019','nav2_off_right.jpg','nav2_off_right.jpg nav2_off_right.jpg  style1 nav2 off right.jpg ','style1/nav2_off_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_right\'\'.\'\'jpg\'\'nav2_off_right\'\'.\'\'jpg\'\'style1\'\'nav2\'\'off\'\'right\'\'.\'\'jpg','000001000001000045000018'),('7-0-style0000000000020','nav2_on_left.jpg','nav2_on_left.jpg nav2_on_left.jpg  style1 nav2 on left.jpg ','style1/nav2_on_left.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_left\'\'.\'\'jpg\'\'nav2_on_left\'\'.\'\'jpg\'\'style1\'\'nav2\'\'on\'\'left\'\'.\'\'jpg','000001000001000045000019'),('7-0-style0000000000022','nav_bg.jpg','nav_bg.jpg nav_bg.jpg  style1 nav bg.jpg ','style1/nav_bg.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg\'\'.\'\'jpg\'\'nav_bg\'\'.\'\'jpg\'\'style1\'\'nav\'\'bg\'\'.\'\'jpg','000001000001000045000021'),('7-0-style0000000000021','nav2_on_right.jpg','nav2_on_right.jpg nav2_on_right.jpg  style1 nav2 on right.jpg ','style1/nav2_on_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_right\'\'.\'\'jpg\'\'nav2_on_right\'\'.\'\'jpg\'\'style1\'\'nav2\'\'on\'\'right\'\'.\'\'jpg','000001000001000045000020'),('7-0-style0000000000017','nav2_off_center.jpg','nav2_off_center.jpg nav2_off_center.jpg  style1 nav2 off center.jpg ','style1/nav2_off_center.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_center\'\'.\'\'jpg\'\'nav2_off_center\'\'.\'\'jpg\'\'style1\'\'nav2\'\'off\'\'center\'\'.\'\'jpg','000001000001000045000016'),('7-0-style0000000000016','nav2_center_on.jpg','nav2_center_on.jpg nav2_center_on.jpg  style1 nav2 center on.jpg ','style1/nav2_center_on.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_center_on\'\'.\'\'jpg\'\'nav2_center_on\'\'.\'\'jpg\'\'style1\'\'nav2\'\'center\'\'on\'\'.\'\'jpg','000001000001000045000015'),('7-0-style0000000000018','nav2_off_left.jpg','nav2_off_left.jpg nav2_off_left.jpg  style1 nav2 off left.jpg ','style1/nav2_off_left.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_left\'\'.\'\'jpg\'\'nav2_off_left\'\'.\'\'jpg\'\'style1\'\'nav2\'\'off\'\'left\'\'.\'\'jpg','000001000001000045000017'),('7-0-style0000000000015','nav1_on_right.jpg','nav1_on_right.jpg nav1_on_right.jpg  style1 nav1 on right.jpg ','style1/nav1_on_right.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_right\'\'.\'\'jpg\'\'nav1_on_right\'\'.\'\'jpg\'\'style1\'\'nav1\'\'on\'\'right\'\'.\'\'jpg','000001000001000045000014'),('7-0-style0000000000014','nav1_on_left.jpg','nav1_on_left.jpg nav1_on_left.jpg  style1 nav1 on left.jpg ','style1/nav1_on_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_left\'\'.\'\'jpg\'\'nav1_on_left\'\'.\'\'jpg\'\'style1\'\'nav1\'\'on\'\'left\'\'.\'\'jpg','000001000001000045000013'),('7-0-style0000000000013','nav1_on.jpg','nav1_on.jpg nav1_on.jpg  style1 nav1 on.jpg ','style1/nav1_on.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on\'\'.\'\'jpg\'\'nav1_on\'\'.\'\'jpg\'\'style1\'\'nav1\'\'on\'\'.\'\'jpg','000001000001000045000012'),('7-0-style0000000000011','nav1_off_left.jpg','nav1_off_left.jpg nav1_off_left.jpg  style1 nav1 off left.jpg ','style1/nav1_off_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_left\'\'.\'\'jpg\'\'nav1_off_left\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'left\'\'.\'\'jpg','000001000001000045000010'),('7-0-style0000000000012','nav1_off_right.jpg','nav1_off_right.jpg nav1_off_right.jpg  style1 nav1 off right.jpg ','style1/nav1_off_right.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_right\'\'.\'\'jpg\'\'nav1_off_right\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'right\'\'.\'\'jpg','000001000001000045000011'),('7-0-style0000000000009','nav1_off.jpg','nav1_off.jpg nav1_off.jpg  style1 nav1 off.jpg ','style1/nav1_off.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off\'\'.\'\'jpg\'\'nav1_off\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'.\'\'jpg','000001000001000045000008'),('7-0-style0000000000010','nav1_off_center.jpg','nav1_off_center.jpg nav1_off_center.jpg  style1 nav1 off center.jpg ','style1/nav1_off_center.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_center\'\'.\'\'jpg\'\'nav1_off_center\'\'.\'\'jpg\'\'style1\'\'nav1\'\'off\'\'center\'\'.\'\'jpg','000001000001000045000009'),('7-0-style0000000000008','nav1_center_on.jpg','nav1_center_on.jpg nav1_center_on.jpg  style1 nav1 center on.jpg ','style1/nav1_center_on.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_center_on\'\'.\'\'jpg\'\'nav1_center_on\'\'.\'\'jpg\'\'style1\'\'nav1\'\'center\'\'on\'\'.\'\'jpg','000001000001000045000007'),('7-0-style0000000000006','main_bg.gif','main_bg.gif main_bg.gif  style1 main bg.gif ','style1/main_bg.gif',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'gif\'\'main_bg\'\'.\'\'gif\'\'style1\'\'main\'\'bg\'\'.\'\'gif','000001000001000045000005'),('7-0-style0000000000007','main_bg.jpg','main_bg.jpg main_bg.jpg  style1 main bg.jpg ','style1/main_bg.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg\'\'.\'\'jpg\'\'main_bg\'\'.\'\'jpg\'\'style1\'\'main\'\'bg\'\'.\'\'jpg','000001000001000045000006'),('7-0-style0000000000004','gui_bottom.jpg','gui_bottom.jpg gui_bottom.jpg  style1 gui bottom.jpg ','style1/gui_bottom.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'gui_bottom\'\'.\'\'jpg\'\'gui_bottom\'\'.\'\'jpg\'\'style1\'\'gui\'\'bottom\'\'.\'\'jpg','000001000001000045000003'),('7-0-style0000000000005','header.jpg','header.jpg header.jpg  style1 header.jpg ','style1/header.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'header\'\'.\'\'jpg\'\'header\'\'.\'\'jpg\'\'style1\'\'header\'\'.\'\'jpg','000001000001000045000004'),('7-0-style0000000000001','WebGUI 7 Style 1','WebGUI 7 Style 1 WebGUI 7 Style 1  root import webgui 7 style 1 ','root/import/webgui-7-style-1',1147642492,1147642492,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'7\'\'Style\'\'1\'\'WebGUI\'\'7\'\'Style\'\'1\'\'root\'\'import\'\'webgui\'\'7\'\'style\'\'1','000001000001000045'),('7-0-style0000000000002','body_bg.jpg','body_bg.jpg body_bg.jpg  style1 body bg.jpg ','style1/body_bg.jpg',1147642492,1147642492,'3','7','12','WebGUI::Asset::File::Image',1,'body_bg\'\'.\'\'jpg\'\'body_bg\'\'.\'\'jpg\'\'style1\'\'body\'\'bg\'\'.\'\'jpg','000001000001000045000001'),('7-0-style0000000000003','css01.css','css01.css css01.css  style1 css01.css ','style1/css01.css',1147642492,1147642492,'3','7','12','WebGUI::Asset::Snippet',1,'css01\'\'.\'\'css\'\'css01\'\'.\'\'css\'\'style1\'\'css01\'\'.\'\'css body\'\',\'\'html\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'494949\'\';\'\'}\'\'#\'\'main\'\'{\'\'width\'\':\'\'800px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'main_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'y\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'margin\'\'-\'\'left\'\':\'\'auto\'\';\'\'margin\'\'-\'\'right\'\':\'\'auto\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'body\'\'>\'\'#\'\'main\'\'{\'\'height\'\':\'\'auto\'\';\'\'min\'\'-\'\'height\'\':\'\'100\'\'%\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainHeader\'\'{\'\'width\'\':\'\'800px\'\';\'\'height\'\':\'\'133px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'header\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'top\'\'left\'\'no\'\'-\'\'repeat\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainHeader\'\'#\'\'title\'\'{\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'23px\'\';\'\'left\'\':\'\'145px\'\';\'\'font\'\'-\'\'size\'\':\'\'32pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainHeader\'\'#\'\'title\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainContent\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'orange_left01\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'left\'\'top\'\'no\'\'-\'\'repeat\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'border\'\':\'\'solid\'\'red\'\'0px\'\';\'\'}\'\'#\'\'main\'\'>\'\'#\'\'mainContent\'\'{\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'min\'\'-\'\'height\'\':\'\'500px\'\';\'\'}\'\'#\'\'main\'\'>\'\'#\'\'mainContent\'\'>\'\'p\'\'{\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainContent\'\'#\'\'mainText\'\'a\'\':\'\'link\'\'{\'\'color\'\':\'\'#\'\'FF7F23\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainContent\'\'#\'\'mainText\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'#\'\'D25900\'\';\'\'}\'\'/\'\'*\'\'LEVEL\'\'1\'\'AND\'\'2\'\'NAVIGATION\'\'*\'\'/\'\'#\'\'main\'\'.\'\'mainNav_1\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'dashed\'\'#\'\'DADADA\'\'1px\'\';\'\'width\'\':\'\'621px\'\';\'\'height\'\':\'\'25px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'position\'\':\'\'relative\'\';\'\'margin\'\'-\'\'left\'\':\'\'137px\'\';\'\'clear\'\':\'\'both\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_1\'\'a\'\':\'\'visited\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'top\'\':\'\'5px\'\';\'\'position\'\':\'\'relative\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'a\'\':\'\'hover\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'a\'\':\'\'hover\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'left\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'left\'\'{\'\'width\'\':\'\'12px\'\';\'\'height\'\':\'\'25px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_off_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'left\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_off_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'center\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'center\'\'{\'\'height\'\':\'\'25px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_off_center\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\',\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'center\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_off_center\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'right\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'right\'\'{\'\'width\'\':\'\'10px\'\';\'\'height\'\':\'\'25px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_off_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'right\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_off_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'.\'\'left\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_on_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'.\'\'center\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_center_on\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'.\'\'right\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav1_on_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'.\'\'left\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_on_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'.\'\'center\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_center_on\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'.\'\'right\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style1\'\'/\'\'nav2_on_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'left\'\';\'\'}\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_1\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'visited\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'link\'\',\'\'#\'\'main\'\'.\'\'mainNav_2\'\'div\'\'.\'\'navOn\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'/\'\'*\'\'ENDOF\'\'LEVEL\'\'1\'\'AND\'\'2\'\'NAVIGATION\'\'*\'\'/\'\'#\'\'main\'\'#\'\'crumbTrail\'\'{\'\'margin\'\'-\'\'left\'\':\'\'177px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'color\'\':\'\'gray\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'main\'\'#\'\'crumbTrail\'\'a\'\'.\'\'crumbTrail\'\':\'\'visited\'\',\'\'#\'\'main\'\'#\'\'crumbTrail\'\'a\'\'.\'\'crumbTrail\'\':\'\'link\'\'{\'\'color\'\':\'\'silver\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'}\'\'#\'\'main\'\'#\'\'crumbTrail\'\'a\'\'.\'\'crumbTrail\'\':\'\'hover\'\'{\'\'color\'\':\'\'gray\'\';\'\'}\'\'#\'\'main\'\'#\'\'mainText\'\'{\'\'padding\'\'-\'\'left\'\':\'\'150px\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'width\'\':\'\'600px\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'{\'\'bottom\'\':\'\'0px\'\';\'\'left\'\':\'\'0px\'\';\'\'position\'\':\'\'absolute\'\';\'\'width\'\':\'\'135px\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'color\'\':\'\'black\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'.\'\'loginBox\'\'{\'\'padding\'\'-\'\'right\'\':\'\'12px\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'width\'\':\'\'100px\'\';\'\'float\'\':\'\'right\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'10px\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'.\'\'loginBox\'\'.\'\'loginBoxField\'\'{\'\'width\'\':\'\'75px\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'.\'\'loginBox\'\'.\'\'loginBoxButton\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'D65501\'\';\'\'color\'\':\'\'white\'\';\'\'border\'\':\'\'solid\'\'white\'\'2px\'\';\'\'margin\'\'-\'\'top\'\':\'\'4px\'\';\'\'font\'\'-\'\'variant\'\':\'\'small\'\'-\'\'caps\'\';\'\'}\'\'#\'\'main\'\'#\'\'gui\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'}\'\'#\'\'copyright\'\'{\'\'color\'\':\'\'#\'\'fff\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'110px\'\';\'\'right\'\':\'\'40px\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'2D2D2D\'\';\'\'opacity\'\':\'\'0\'\'.\'\'4\'\';\'\'-\'\'moz\'\'-\'\'opacity\'\':\'\'0\'\'.\'\'4\'\';\'\'-\'\'khtml\'\'-\'\'opacity\'\':\'\'0\'\'.\'\'4\'\';\'\'padding\'\':\'\'2px\'\';\'\'}\'\'*\'\'html\'\'#\'\'copyright\'\'{\'\'background\'\':\'\'transparent\'\';\'\'}','000001000001000045000002'),('CSN-ZON7Uwv8kxf3F1fh5Q','ZipArchiveAsset','ZipArchiveAsset ZipArchiveAsset  root import ziparchiveasset ','root/import/ziparchiveasset',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ZipArchiveAsset\'\'ZipArchiveAsset\'\'root\'\'import\'\'ziparchiveasset','000001000001000049'),('TCtybxdqmdwdvRn555zpCQ','RichEdit','RichEdit RichEdit  root import richedit ','root/import/richedit',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RichEdit\'\'RichEdit\'\'root\'\'import\'\'richedit','000001000001000030'),('NywJYmGWe1f6EBXJnWg9Xg','Profile','Profile Profile  root import profile ','root/import/profile',1222803606,1222803638,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Profile\'\'Profile\'\'root\'\'import\'\'profile','000001000001000026'),('9wKWdum0_8z-OhhquWLtSQ','WeatherData','WeatherData WeatherData  root import weatherdata ','root/import/weatherdata',1147642483,1147642483,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WeatherData\'\'WeatherData\'\'root\'\'import\'\'weatherdata','000001000001000044'),('AgyFhx3eXlfZXNp2MkrsiQ','Edit','Edit Edit  root import profile edit ','root/import/profile/edit',1147642477,1222803665,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Edit\'\'Edit\'\'root\'\'import\'\'profile\'\'edit','000001000001000026000001'),('F7MAQ-cpuvQ1KuC7J4P5zQ','View','View View  root import profile view ','root/import/profile/view',1147642477,1222803673,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'View\'\'View\'\'root\'\'import\'\'profile\'\'view','000001000001000026000002'),('oGfxez5sksyB_PcaAsEm_Q','SyndicatedContent','SyndicatedContent SyndicatedContent  root import syndicatedcontent ','root/import/syndicatedcontent',1147642482,1147642482,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SyndicatedContent\'\'SyndicatedContent\'\'root\'\'import\'\'syndicatedcontent','000001000001000040'),('5bnNzteN7w3NnK9mF4XiCg','Survey','Survey Survey  root import survey ','root/import/survey',1147642481,1227540002,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Survey\'\'Survey\'\'root\'\'import\'\'survey','000001000001000039'),('Efe2W0UgrSRDltNJ87jlfg','StockData','StockData StockData  root import stockdata ','root/import/stockdata',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'StockData\'\'StockData\'\'root\'\'import\'\'stockdata','000001000001000037'),('bbiA9Zq5Gy2oCFBlILO3QA','SQLReport','SQLReport SQLReport  root import sqlreport ','root/import/sqlreport',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SQLReport\'\'SQLReport\'\'root\'\'import\'\'sqlreport','000001000001000036'),('RrV4aAPnn4dM0ZcU3OXnlw','style','style style  root import style ','root/import/style',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'style\'\'style\'\'root\'\'import\'\'style','000001000001000038'),('Ik9HHky10DIyFTKehUD1dw','Prompt','Prompt Prompt  root import prompt ','root/import/prompt',1147642479,1222803478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Prompt\'\'Prompt\'\'root\'\'import\'\'prompt','000001000001000028'),('f_tn9FfoSfKWX43F83v_3w','Search','Search Search  root import search ','root/import/search',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Search\'\'Search\'\'root\'\'import\'\'search','000001000001000032'),('Da6KWn805L4B5e4HFgQRQA','Shortcut','Shortcut Shortcut  root import shortcut ','root/import/shortcut',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shortcut\'\'Shortcut\'\'root\'\'import\'\'shortcut','000001000001000035'),('TYo2Bwl7aafzTtdHlS-arQ','Product','Product Product  root import product ','root/import/product',1147642478,1211664878,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Product\'\'Product\'\'root\'\'import\'\'product','000001000001000025'),('VZK3CRgiMb8r4dBjUmCTgQ','Poll','Poll Poll  root import poll ','root/import/poll',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Poll\'\'Poll\'\'root\'\'import\'\'poll','000001000001000024'),('jEz8iTGNWEt2I05IhVV19Q','Operation/RedeemSubscription','Operation/RedeemSubscription Operation/RedeemSubscription  root import operation redeemsubscription ','root/import/operation/redeemsubscription',1147642477,1147642477,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Operation\'\'/\'\'RedeemSubscription\'\'Operation\'\'/\'\'RedeemSubscription\'\'root\'\'import\'\'operation\'\'redeemsubscription','000001000001000034000016'),('BFfNj5wA9bDw8H3cnr8pTw','Navigation','Navigation Navigation  root import navigation ','root/import/navigation',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Navigation\'\'Navigation\'\'root\'\'import\'\'navigation','000001000001000022'),('bBzO4CWjqU_ile3gf5Iypw','MultiSearch','MultiSearch MultiSearch  root import multisearch ','root/import/multisearch',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MultiSearch\'\'MultiSearch\'\'root\'\'import\'\'multisearch','000001000001000021'),('cj2y4papTVGZRFdwTI-_fw','MessageBoard','MessageBoard MessageBoard  root import messageboard ','root/import/messageboard',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MessageBoard\'\'MessageBoard\'\'root\'\'import\'\'messageboard','000001000001000020'),('3womoo7Teyy2YKFa25-MZg','Address Book (Default)','Address Book (Default) Address Book (Default)  shopping cart collateral items address book default ','shopping-cart-collateral-items/address-book-default',1212098997,1226703362,'3','7','3','WebGUI::Asset::Template',1,'Address\'\'Book\'\'(\'\'Default\'\')\'\'Address\'\'Book\'\'(\'\'Default\'\')\'\'shopping\'\'cart\'\'collateral\'\'items\'\'address\'\'book\'\'default Shop\'\'/\'\'AddressBook','000001000001000034000013'),('g8W53Pd71uHB9pxaXhWf_A','My Purchases Detail (Default)','My Purchases Detail (Default) My Purchases Detail (Default)  shopping cart collateral items my purchases detail default ','shopping-cart-collateral-items/my-purchases-detail-default',1213184121,1222574693,'3','7','3','WebGUI::Asset::Template',1,'My\'\'Purchases\'\'Detail\'\'(\'\'Default\'\')\'\'My\'\'Purchases\'\'Detail\'\'(\'\'Default\'\')\'\'shopping\'\'cart\'\'collateral\'\'items\'\'my\'\'purchases\'\'detail\'\'default Shop\'\'/\'\'MyPurchasesDetail','000001000001000034000015'),('-WM2dt0ZGpDasuL2wWocxg','ProjectManager','ProjectManager ProjectManager  root import projectmanager ','root/import/projectmanager',1222803056,1222803056,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager\'\'ProjectManager\'\'root\'\'import\'\'projectmanager','000001000001000027'),('LdiozcIUciWuvt3Z-na5Ww','Matrix','Matrix Matrix  root import matrix ','root/import/matrix',1147642474,1232673968,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Matrix\'\'Matrix\'\'root\'\'import\'\'matrix','000001000001000019'),('default_post_received1','Default Post Received','Default Post Received Default Post Received  default post received ','default_post_received',1222708029,1230356300,'3','7','4','WebGUI::Asset::Template',1,'Default\'\'Post\'\'Received\'\'Default\'\'Post\'\'Received\'\'default\'\'post\'\'received Collaboration\'\'/\'\'PostReceived','000001000001000006000030'),('aNNC62qLAS6TB-0_MCYjsw','Layout','Layout Layout  root import layout ','root/import/layout',1147642471,1213283425,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Layout\'\'Layout\'\'root\'\'import\'\'layout','000001000001000017'),('GYaFxnMu9UsEG8oanwB6TA','Folder','Folder Folder  root import folder ','root/import/folder',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Folder\'\'Folder\'\'root\'\'import\'\'folder','000001000001000012'),('N13SD1Fpqk00UgBt1Z8ivQ','HttpProxy','HttpProxy HttpProxy  root import httpproxy ','root/import/httpproxy',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'HttpProxy\'\'HttpProxy\'\'root\'\'import\'\'httpproxy','000001000001000014'),('tPagC0AQErZXjLFZQ6OI1g','ImageAsset','ImageAsset ImageAsset  root import imageasset ','root/import/imageasset',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ImageAsset\'\'ImageAsset\'\'root\'\'import\'\'imageasset','000001000001000015'),('3uuBf8cYuj1sew2OJXl9tg','InOutBoard','InOutBoard InOutBoard  root import inoutboard ','root/import/inoutboard',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'InOutBoard\'\'InOutBoard\'\'root\'\'import\'\'inoutboard','000001000001000016'),('PBtmpl0000000000000005','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template Default LDAP Anonymous Registration Template  default ldap anonymous registration template ','default_ldap_anonymous_registration_template',1124395696,1221612327,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LDAP\'\'Anonymous\'\'Registration\'\'Template\'\'Default\'\'LDAP\'\'Anonymous\'\'Registration\'\'Template\'\'default\'\'ldap\'\'anonymous\'\'registration\'\'template Auth\'\'/\'\'LDAP\'\'/\'\'Create','000001000001000004000002000001'),('PBtmpl0000000000000011','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template Default WebGUI Anonymous Registration Template  default webgui anonymous registration template ','default_webgui_anonymous_registration_template',1124395696,1221612288,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Anonymous\'\'Registration\'\'Template\'\'Default\'\'WebGUI\'\'Anonymous\'\'Registration\'\'Template\'\'default\'\'webgui\'\'anonymous\'\'registration\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Create','000001000001000004000005000001'),('tXwf1zaOXTvsqPn6yu-GSw','FileAsset','FileAsset FileAsset  root import fileasset ','root/import/fileasset',1147642469,1147642469,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'FileAsset\'\'FileAsset\'\'root\'\'import\'\'fileasset','000001000001000011'),('S1A9iAwKcQQ6P20uTqw-Ew','Dashboard','Dashboard Dashboard  root import dashboard ','root/import/dashboard',1147642468,1147642468,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Dashboard\'\'Dashboard\'\'root\'\'import\'\'dashboard','000001000001000007'),('-K8Hj45mbelljN9-0CXZxg','DataForm','  ','root/import/dataform',1147642468,1209325764,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'DataForm\'\'DataForm\'\'root\'\'import\'\'dataform','000001000001000008'),('GNOAsX98vCsl0JRwfwL-gg','Collaboration','Collaboration Collaboration  root import collaboration ','root/import/collaboration',1147642466,1147642466,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Collaboration\'\'Collaboration\'\'root\'\'import\'\'collaboration','000001000001000006'),('pbproto000000000000002','Request Tracker','Request Tracker Request Tracker  request tracker prototype ','request-tracker-prototype',1147642465,1163019036,'3','7','12','WebGUI::Asset::Wobject::Collaboration',1,'Request\'\'Tracker\'\'Request\'\'Tracker\'\'request\'\'tracker\'\'prototype','000001000001000029'),('pbtmpl0000000000000220','Flash Template','Flash Template Flash Template  flash template ','flash-template',1147642465,1148579525,'3','7','12','WebGUI::Asset::Template',1,'Flash\'\'Template\'\'Flash\'\'Template\'\'flash\'\'template FileAsset','000001000001000011000002'),('pbtmpl0000000000000221','Flash Tutorial Template','Flash Tutorial Template Flash Tutorial Template  flash tutorial template ','flash-tutorial-template',1147642465,1147642465,'3','7','12','WebGUI::Asset::Template',1,'Flash\'\'Tutorial\'\'Template\'\'Flash\'\'Tutorial\'\'Template\'\'flash\'\'tutorial\'\'template FileAsset','000001000001000011000003'),('nbSrhXZQuxIjhWFaFPSuVA','AdminConsole','AdminConsole AdminConsole  root import adminconsole ','root/import/adminconsole',1147642465,1147642465,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminConsole\'\'AdminConsole\'\'root\'\'import\'\'adminconsole','000001000001000002'),('TvOZs8U1kRXLtwtmyW75pg','Article','Article Article  root import article ','root/import/article',1147642465,1147642465,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Article\'\'Article\'\'root\'\'import\'\'article','000001000001000003'),('PBtmpl0000000000000027','Default Forum Notification','Default Forum Notification Default Forum Notification  default forum notification ','default_forum_notification',1124395696,1230159257,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Forum\'\'Notification\'\'Default\'\'Forum\'\'Notification\'\'default\'\'forum\'\'notification Collaboration\'\'/\'\'Notification','000001000001000006000015'),('PBtmpl00000000table118','Three Over One (Table)','Three Over One (Table) Three Over One (Table)  three over one table ','three_over_one_table',1148579525,1220655705,'3','7','12','WebGUI::Asset::Template',1,'Three\'\'Over\'\'One\'\'(\'\'Table\'\')\'\'Three\'\'Over\'\'One\'\'(\'\'Table\'\')\'\'three\'\'over\'\'one\'\'table Layout','000001000001000017000012'),('PBtmpl00000000table135','Side By Side (Table)','Side By Side (Table) Side By Side (Table)  side by side table ','side_by_side_table',1148579525,1220655706,'3','7','12','WebGUI::Asset::Template',1,'Side\'\'By\'\'Side\'\'(\'\'Table\'\')\'\'Side\'\'By\'\'Side\'\'(\'\'Table\'\')\'\'side\'\'by\'\'side\'\'table Layout','000001000001000017000011'),('PBtmpl00000000table131','Right Column (Table)','Right Column (Table) Right Column (Table)  right column table ','right_column_table',1148579525,1220655705,'3','7','12','WebGUI::Asset::Template',1,'Right\'\'Column\'\'(\'\'Table\'\')\'\'Right\'\'Column\'\'(\'\'Table\'\')\'\'right\'\'column\'\'table Layout','000001000001000017000010'),('PBtmpl00000000table094','News (Table)','News (Table) News (Table)  news table ','news_table',1148579525,1220655704,'3','7','12','WebGUI::Asset::Template',1,'News\'\'(\'\'Table\'\')\'\'News\'\'(\'\'Table\'\')\'\'news\'\'table Layout','000001000001000017000009'),('PBtmpl00000000table125','Left Column (Table)','Left Column (Table) Left Column (Table)  left column table ','left_column_table',1148579525,1220655705,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Column\'\'(\'\'Table\'\')\'\'Left\'\'Column\'\'(\'\'Table\'\')\'\'left\'\'column\'\'table Layout','000001000001000017000008'),('PBnav00000000indentnav','Indent Nav','Indent Nav Indent Nav  indent nav ','indent_nav',1148579525,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Indent\'\'Nav\'\'Indent\'\'Nav\'\'indent\'\'nav Navigation','000001000001000022000028'),('PBtmpl0000000000000085','Default Email','Default Email Default Email  default email ','default_email',1124395696,1202884864,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Email\'\'Default\'\'Email\'\'default\'\'email DataForm','000001000001000008000002'),('PBnav00000000000bullet','Bulleted List','Bulleted List Bulleted List  bulleted list ','bulleted_list',1148579524,1148579524,'3','7','12','WebGUI::Asset::Template',1,'Bulleted\'\'List\'\'Bulleted\'\'List\'\'bulleted\'\'list Navigation','000001000001000022000027'),('StockDataTMPL000000002','StockData Default Display','StockData Default Display StockData Default Display  stockdatatmpl000000002 ','stockdatatmpl000000002',1133743239,1229494994,'3','7','12','WebGUI::Asset::Template',1,'StockData\'\'Default\'\'Display\'\'StockData\'\'Default\'\'Display\'\'stockdatatmpl000000002 StockData\'\'/\'\'Display','000001000001000037000001'),('2OcUWHVsu_L1sDFzIMWYqw','TimeTracking','TimeTracking TimeTracking  root import timetracking ','root/import/timetracking',1222803070,1222803070,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'TimeTracking\'\'TimeTracking\'\'root\'\'import\'\'timetracking','000001000001000042'),('PBtmpl000000000table54','Default Page (Table)','Default Page (Table) Default Page (Table)  default page table ','default_page_table',1154535074,1220655704,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Page\'\'(\'\'Table\'\')\'\'Default\'\'Page\'\'(\'\'Table\'\')\'\'default\'\'page\'\'table Layout','000001000001000017000013'),('PBtmpl00000000table109','One Over Three (Table)','One Over Three (Table) One Over Three (Table)  one over three table ','one_over_three_table',1154535074,1220655705,'3','7','12','WebGUI::Asset::Template',1,'One\'\'Over\'\'Three\'\'(\'\'Table\'\')\'\'One\'\'Over\'\'Three\'\'(\'\'Table\'\')\'\'one\'\'over\'\'three\'\'table Layout','000001000001000017000014'),('PBtmpl0000000000000014','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template Default WebGUI Password Recovery Template  default webgui password recovery template ','default_webgui_password_recovery_template',1124395696,1227218041,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'WebGUI\'\'Password\'\'Recovery\'\'Template\'\'Default\'\'WebGUI\'\'Password\'\'Recovery\'\'Template\'\'default\'\'webgui\'\'password\'\'recovery\'\'template Auth\'\'/\'\'WebGUI\'\'/\'\'Recovery2','000001000001000004000008000001'),('ProjectManagerTMPL0006','Default Resource List','Default Resource List Default Resource List  default pm resource list ','default-pm-resource-list',1157679165,1157679165,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Resource\'\'List\'\'Default\'\'Resource\'\'List\'\'default\'\'pm\'\'resource\'\'list ProjectManager_resourceList','000001000001000027000005000001'),('ProjectManagerTMPL0005','Default Resource Popup','Default Resource Popup Default Resource Popup  default pm resource popup ','default-pm-resource-popup',1157679165,1229579830,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Resource\'\'Popup\'\'Default\'\'Resource\'\'Popup\'\'default\'\'pm\'\'resource\'\'popup ProjectManager_resourcePopup','000001000001000027000005000002'),('PBtmpl0000000000000032','Default Thread','Default Thread Default Thread  default thread ','default_thread',1124395696,1206998756,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Thread\'\'Default\'\'Thread\'\'default\'\'thread Collaboration\'\'/\'\'Thread','000001000001000006000014'),('WeatherDataTmpl0000001','WeatherData Default View','WeatherData Default View WeatherData Default View  weatherdatatmpl0000001 ','weatherdatatmpl0000001',1133743239,1210711353,'3','7','12','WebGUI::Asset::Template',1,'WeatherData\'\'Default\'\'View\'\'WeatherData\'\'Default\'\'View\'\'weatherdatatmpl0000001 WeatherData','000001000001000044000001'),('PBasset000000000000001','Root','Root Root  root ','root',1124395696,1124395696,'3','7','3','WebGUI::Asset',1,'Root\'\'Root\'\'root','000001'),('PBrichedit000000000001','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit Content Manager\'s Rich Edit  content managers rich edit ','content_managers_rich_edit',1124395696,1207240829,'3','7','12','WebGUI::Asset::RichEdit',1,'Content\'\'Manager\'\'\'\'\'s\'\'Rich\'\'Edit\'\'Content\'\'Manager\'\'\'\'\'s\'\'Rich\'\'Edit\'\'content\'\'managers\'\'rich\'\'edit','000001000001000030000001'),('PBrichedit000000000002','Forum Rich Edit','Forum Rich Edit Forum Rich Edit  forum rich edit ','forum_rich_edit',1124395696,1124395696,'3','7','12','WebGUI::Asset::RichEdit',1,'Forum\'\'Rich\'\'Edit\'\'Forum\'\'Rich\'\'Edit\'\'forum\'\'rich\'\'edit','000001000001000030000002'),('SynConXSLT000000000001','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT Stylesheet RSS 0.9 XSLT  xslt rss0.9.xsl ','xslt/rss0.9.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'0\'\'.\'\'9\'\'XSLT\'\'Stylesheet\'\'RSS\'\'0\'\'.\'\'9\'\'XSLT\'\'xslt\'\'rss0\'\'.\'\'9\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'0\'\'.\'\'9\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.','000001000001000040000003'),('SynConXSLT000000000002','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT Stylesheet RSS 0.91 XSLT  xslt rss0.91.xsl ','xslt/rss0.91.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'0\'\'.\'\'91\'\'XSLT\'\'Stylesheet\'\'RSS\'\'0\'\'.\'\'91\'\'XSLT\'\'xslt\'\'rss0\'\'.\'\'91\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'0\'\'.\'\'91\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.','000001000001000040000004'),('SynConXSLT000000000003','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT Stylesheet RSS 1.0 XSLT  xslt rss1.0.xsl ','xslt/rss1.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'1\'\'.\'\'0\'\'XSLT\'\'Stylesheet\'\'RSS\'\'1\'\'.\'\'0\'\'XSLT\'\'xslt\'\'rss1\'\'.\'\'0\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'1\'\'.\'\'0\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.\'\'(\'\')','000001000001000040000005'),('SynConXSLT000000000004','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT Stylesheet RSS 2.0 XSLT  xslt rss2.0.xsl ','xslt/rss2.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',1,'RSS\'\'2\'\'.\'\'0\'\'XSLT\'\'Stylesheet\'\'RSS\'\'2\'\'.\'\'0\'\'XSLT\'\'xslt\'\'rss2\'\'.\'\'0\'\'.\'\'xsl You\'\'\'\'\'re\'\'viewing\'\'an\'\'RSS\'\'version\'\'2\'\'.\'\'0\'\'feed\'\'.\'\'Please\'\'use\'\'an\'\'RSS\'\'feed\'\'reader\'\'to\'\'view\'\'this\'\'content\'\'as\'\'intended\'\'.\'\'(\'\')','000001000001000040000006'),('vrKXEtluIhbmAS9xmPukDA','Donation (Default)','Donation (Default) Donation (Default)  root import default donation template ','root/import/default-donation-template',1212092352,1226698051,'3','7','12','WebGUI::Asset::Template',1,'Donation\'\'(\'\'Default\'\')\'\'Donation\'\'(\'\'Default\'\')\'\'root\'\'import\'\'default\'\'donation\'\'template Donation','000001000001000034000010'),('eqb9sWjFEVq0yHunGV8IGw','Subscription (Default)','Subscription (Default) Subscription (Default)  root import subscription default ','root/import/subscription-default',1213182595,1222574693,'3','7','12','WebGUI::Asset::Template',1,'Subscription\'\'(\'\'Default\'\')\'\'Subscription\'\'(\'\'Default\'\')\'\'root\'\'import\'\'subscription\'\'default Subscription','000001000001000034000012'),('PBtmpl0000000000000036','Default Admin Toggle Macro','Default Admin Toggle Macro Default Admin Toggle Macro  default admin toggle macro ','default_admin_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Admin\'\'Toggle\'\'Macro\'\'Default\'\'Admin\'\'Toggle\'\'Macro\'\'default\'\'admin\'\'toggle\'\'macro Macro\'\'/\'\'AdminToggle','000001000001000018000001000001'),('PBtmpl0000000000000037','Default Account Macro','Default Account Macro Default Account Macro  default account macro ','default_account_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Account\'\'Macro\'\'Default\'\'Account\'\'Macro\'\'default\'\'account\'\'macro Macro\'\'/\'\'a_account','000001000001000018000002000001'),('PBtmpl0000000000000038','Default Editable Toggle Macro','Default Editable Toggle Macro Default Editable Toggle Macro  default editable toggle macro ','default_editable_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Editable\'\'Toggle\'\'Macro\'\'Default\'\'Editable\'\'Toggle\'\'Macro\'\'default\'\'editable\'\'toggle\'\'macro Macro\'\'/\'\'EditableToggle','000001000001000018000003000001'),('PBtmpl0000000000000040','Default Group Add Macro','Default Group Add Macro Default Group Add Macro  default group add macro ','default_group_add_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Group\'\'Add\'\'Macro\'\'Default\'\'Group\'\'Add\'\'Macro\'\'default\'\'group\'\'add\'\'macro Macro\'\'/\'\'GroupAdd','000001000001000018000005000001'),('PBtmpl0000000000000041','Default Group Delete Macro','Default Group Delete Macro Default Group Delete Macro  default group delete macro ','default_group_delete_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Group\'\'Delete\'\'Macro\'\'Default\'\'Group\'\'Delete\'\'Macro\'\'default\'\'group\'\'delete\'\'macro Macro\'\'/\'\'GroupDelete','000001000001000018000006000001'),('PBtmpl0000000000000042','Default Homelink','Default Homelink Default Homelink  default homelink ','default_homelink',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Homelink\'\'Default\'\'Homelink\'\'default\'\'homelink Macro\'\'/\'\'H_homeLink','000001000001000018000007000001'),('PBtmpl0000000000000043','Default LoginToggle','Default LoginToggle Default LoginToggle  default logintoggle ','default_logintoggle',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'LoginToggle\'\'Default\'\'LoginToggle\'\'default\'\'logintoggle Macro\'\'/\'\'LoginToggle','000001000001000018000008000001'),('PBtmpl0000000000000045','Default Make Printable','Default Make Printable Default Make Printable  default make printable ','default_make_printable',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Make\'\'Printable\'\'Default\'\'Make\'\'Printable\'\'default\'\'make\'\'printable Macro\'\'/\'\'r_printable','000001000001000018000011000001'),('PBtmpl0000000000000091','File no icon','File no icon File no icon  file no icon ','file_no_icon',1124395696,1129049189,'3','7','12','WebGUI::Asset::Template',1,'File\'\'no\'\'icon\'\'File\'\'no\'\'icon\'\'file\'\'no\'\'icon Macro\'\'/\'\'File','000001000001000018000004000002'),('PBtmpl0000000000000125','Left Column','Left Column Left Column  left column ','left_column',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',1,'Left\'\'Column\'\'Left\'\'Column\'\'left\'\'column Layout','000001000001000017000004'),('PBtmpl0000000000000132','Empty','Empty Empty  empty ','empty',1124395696,1129049190,'3','7','12','WebGUI::Asset::Template',1,'Empty\'\'Empty\'\'empty style','000001000001000038000004'),('PBtmpl0000000000000140','Default Shortcut','Default Shortcut Default Shortcut  pbtmpl0000000000000140 ','pbtmpl0000000000000140',1124395696,1129573244,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Shortcut\'\'Default\'\'Shortcut\'\'pbtmpl0000000000000140 Shortcut','000001000001000035000001'),('PBtmpl0000000000000142','Default RSS','Default RSS Default RSS  pbtmpl0000000000000142 ','pbtmpl0000000000000142',1133743238,1171466654,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'RSS\'\'Default\'\'RSS\'\'pbtmpl0000000000000142 RSSCapable\'\'/\'\'RSS','000001000001000006000026'),('ZipArchiveTMPL00000001','Default Zip Archive Template','Default Zip Archive Template Default Zip Archive Template  zip archive template ','zip-archive-template',1133743240,1169738426,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Zip\'\'Archive\'\'Template\'\'Default\'\'Zip\'\'Archive\'\'Template\'\'zip\'\'archive\'\'template ZipArchiveAsset','000001000001000049000001'),('PBasset000000000000002','Import Node','Import Node Import  root import ','root/import',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Import\'\'Node\'\'Import\'\'root\'\'import','000001000001'),('2TqQc4OISddWCZmRY1_m8A','The Latest News','The Latest News The Latest News  the latest news ','the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'The\'\'Latest\'\'News\'\'The\'\'Latest\'\'News\'\'the\'\'latest\'\'news','000001000002000003'),('68sKwDgf9cGH58-NZcU4lg','Home','Home Home  home ','home',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Home\'\'Home\'\'home','000001000002'),('8Bb8gu-me2mhL3ljFyiWLg','What should you do next?','What should you do next? Your Next Step  your next step ','your_next_step',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'What\'\'should\'\'you\'\'do\'\'next\'\'?\'\'Your\'\'Next\'\'Step\'\'your\'\'next\'\'step','000001000002000002'),('Swf6L8poXKc7hUaNPkBevw','Tell A Friend','Tell A Friend Tell A Friend  tell a friend ','tell_a_friend',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Tell\'\'A\'\'Friend\'\'Tell\'\'A\'\'Friend\'\'tell\'\'a\'\'friend','000001000002000004'),('_iHetEvMQUOoxS-T2CM0sQ','Getting Started','Getting Started Getting Started  getting started ','getting_started',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Getting\'\'Started\'\'Getting\'\'Started\'\'getting\'\'started','000001000002000001'),('x3OFY6OJh_qsXkZfPwug4A','Site Map','Site Map Site Map  site map ','site_map',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Site\'\'Map\'\'Site\'\'Map\'\'site\'\'map','000001000002000006'),('PBnav00000000000000001','crumbTrail','crumbTrail crumbTrail  crumbtrail ','crumbtrail',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'crumbTrail\'\'crumbTrail\'\'crumbtrail','000001000001000022000009'),('PBnav00000000000000002','SpecificSubMenuVertical','SpecificSubMenuVertical SpecificSubMenuVertical  specificsubmenuvertical ','specificsubmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuVertical\'\'SpecificSubMenuVertical\'\'specificsubmenuvertical','000001000001000022000018'),('PBnav00000000000000006','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal SpecificSubMenuHorizontal  specificsubmenuhorizontal ','specificsubmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuHorizontal\'\'SpecificSubMenuHorizontal\'\'specificsubmenuhorizontal','000001000001000022000019'),('PBnav00000000000000007','TopLevelMenuVertical','TopLevelMenuVertical TopLevelMenuVertical  toplevelmenuvertical ','toplevelmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuVertical\'\'TopLevelMenuVertical\'\'toplevelmenuvertical','000001000001000022000020'),('PBnav00000000000000008','TopLevelMenuHorizontal','TopLevelMenuHorizontal TopLevelMenuHorizontal  toplevelmenuhorizontal ','toplevelmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuHorizontal\'\'TopLevelMenuHorizontal\'\'toplevelmenuhorizontal','000001000001000022000021'),('PBnav00000000000000009','RootTab','RootTab RootTab  roottab ','roottab',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab\'\'RootTab\'\'roottab','000001000001000022000022'),('PBnav00000000000000010','TopDropMenu','TopDropMenu TopDropMenu  topdropmenu ','topdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopDropMenu\'\'TopDropMenu\'\'topdropmenu','000001000001000022000023'),('PBnav00000000000000011','dtree','dtree dtree  dtree ','dtree',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'dtree\'\'dtree\'\'dtree','000001000001000022000024'),('PBnav00000000000000012','coolmenu','coolmenu coolmenu  coolmenu ','coolmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'coolmenu\'\'coolmenu\'\'coolmenu','000001000001000022000025'),('PBnav00000000000000013','Synopsis','Synopsis Synopsis  synopsis ','synopsis',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Synopsis\'\'Synopsis\'\'synopsis','000001000001000022000026'),('PBnav00000000000000014','FlexMenu','FlexMenu FlexMenu  flexmenu ','flexmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'FlexMenu\'\'FlexMenu\'\'flexmenu','000001000001000022000010'),('PBnav00000000000000015','currentMenuVertical','currentMenuVertical currentMenuVertical  currentmenuvertical ','currentmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuVertical\'\'currentMenuVertical\'\'currentmenuvertical','000001000001000022000011'),('PBnav00000000000000016','currentMenuHorizontal','currentMenuHorizontal currentMenuHorizontal  currentmenuhorizontal ','currentmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuHorizontal\'\'currentMenuHorizontal\'\'currentmenuhorizontal','000001000001000022000012'),('PBnav00000000000000017','PreviousDropMenu','PreviousDropMenu PreviousDropMenu  previousdropmenu ','previousdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'PreviousDropMenu\'\'PreviousDropMenu\'\'previousdropmenu','000001000001000022000013'),('PBnav00000000000000018','previousMenuVertical','previousMenuVertical previousMenuVertical  previousmenuvertical ','previousmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuVertical\'\'previousMenuVertical\'\'previousmenuvertical','000001000001000022000014'),('PBnav00000000000000019','previousMenuHorizontal','previousMenuHorizontal previousMenuHorizontal  previousmenuhorizontal ','previousmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuHorizontal\'\'previousMenuHorizontal\'\'previousmenuhorizontal','000001000001000022000015'),('PBnav00000000000000020','rootmenu','rootmenu rootmenu  rootmenu ','rootmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'rootmenu\'\'rootmenu\'\'rootmenu','000001000001000022000016'),('PBnav00000000000000021','SpecificDropMenu','SpecificDropMenu SpecificDropMenu  specificdropmenu ','specificdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificDropMenu\'\'SpecificDropMenu\'\'specificdropmenu','000001000001000022000017'),('pJd5TLAjfWMVXD6sCRLwUg','Site Map','Site Map Site Map  site map site map ','site_map/site_map',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'Site\'\'Map\'\'Site\'\'Map\'\'site\'\'map\'\'site\'\'map','000001000002000006000001'),('fK-HMSboA3uu0c1KYkYspA','The Latest News','This is the latest news from Plain Black and WebGUI pulled directly from the site every hour.','the_latest_news/the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::SyndicatedContent',1,'The\'\'Latest\'\'News\'\'The\'\'Latest\'\'News\'\'the\'\'latest\'\'news\'\'the\'\'latest\'\'news\'\'This\'\'is\'\'the\'\'latest\'\'news\'\'from\'\'Plain\'\'Black\'\'and\'\'WebGUI\'\'pulled\'\'directly\'\'from\'\'the\'\'site\'\'every\'\'hour\'\'.','000001000002000003000001'),('WikiFrontTmpl000000001','Default Wiki Front Page','Default Wiki Front Page Default Wiki Front Page  default wiki front page ','default-wiki-front-page',1165460175,1185754572,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Front\'\'Page\'\'Default\'\'Wiki\'\'Front\'\'Page\'\'default\'\'wiki\'\'front\'\'page WikiMaster_front','000001000001000048000002'),('WikiSearchTmpl00000001','Default Wiki Search','Default Wiki Search Default Wiki Search  default wiki search ','default-wiki-search',1165460175,1168480840,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Search\'\'Default\'\'Wiki\'\'Search\'\'default\'\'wiki\'\'search WikiMaster_search','000001000001000048000003'),('WikiPHTmpl000000000001','Default Page History','Default Page History Default Page History  default wiki page history ','default-wiki-page-history',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Page\'\'History\'\'Default\'\'Page\'\'History\'\'default\'\'wiki\'\'page\'\'history WikiPage_pageHistory','000001000001000048000004'),('WikiPageTmpl0000000001','Default Wiki Page','Default Wiki Page Default Wiki Page  default wiki page ','default-wiki-page',1165460175,1229706257,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Page\'\'Default\'\'Wiki\'\'Page\'\'default\'\'wiki\'\'page WikiPage','000001000001000048000005'),('WikiPageEditTmpl000001','Default Wiki Page Edit','Default Wiki Page Edit Default Wiki Page Edit  default wiki page edit ','default-wiki-page-edit',1165460175,1221692341,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Wiki\'\'Page\'\'Edit\'\'Default\'\'Wiki\'\'Page\'\'Edit\'\'default\'\'wiki\'\'page\'\'edit WikiPage_edit','000001000001000048000006'),('WikiMPTmpl000000000001','Default Most Popular','Default Most Popular Default Most Popular  default wiki most popular ','default-wiki-most-popular',1165460175,1165460175,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Most\'\'Popular\'\'Default\'\'Most\'\'Popular\'\'default\'\'wiki\'\'most\'\'popular WikiMaster_mostPopular','000001000001000048000007'),('SQLReportDownload00001','SQLReport Download Default Template','SQLReport Download Default Template untitled  SQLReportDownload0001 ','SQLReportDownload0001',1171466654,1171466654,'3','7','12','WebGUI::Asset::Template',1,'SQLReport\'\'Download\'\'Default\'\'Template\'\'untitled\'\'SQLReportDownload0001 SQLReport\'\'/\'\'Download','000001000001000036000002'),('newsletter000000000001',' Summary Newsletter (default)',' Summary Newsletter (default)  Summary Newsletter  newsletterdefaulttemplate ','newsletterdefaulttemplate',1185754569,1185754569,'3','7','3','WebGUI::Asset::Template',1,'Summary\'\'Newsletter\'\'(\'\'default\'\')\'\'Summary\'\'Newsletter\'\'newsletterdefaulttemplate newsletter','000001000001000023000001'),('newslettercs0000000001','Newsletter Manager (default)','Newsletter Manager (default)  Newsletter Manager  newslettercstemplate ','newslettercstemplate',1185754569,1226896423,'3','7','3','WebGUI::Asset::Template',1,'Newsletter\'\'Manager\'\'(\'\'default\'\')\'\'Newsletter\'\'Manager\'\'newslettercstemplate newsletter','000001000001000023000002'),('newslettersubscrip0001','My Subscriptions (default)','My Subscriptions (default)  My Subscriptions  newslettermysubscriptionstemplate ','newslettermysubscriptionstemplate',1185754569,1221692339,'3','7','3','WebGUI::Asset::Template',1,'My\'\'Subscriptions\'\'(\'\'default\'\')\'\'My\'\'Subscriptions\'\'newslettermysubscriptionstemplate newsletter\'\'/\'\'mysubscriptions','000001000001000023000003'),('AjhlNO3wZvN5k4i4qioWcg','Default Answer Edit','Default Answer Edit Default Answer Edit  root import survey default answer edit ','root/import/survey/default-answer-edit',1226009658,1233874172,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Answer\'\'Edit\'\'Default\'\'Answer\'\'Edit\'\'root\'\'import\'\'survey\'\'default\'\'answer\'\'edit Survey\'\'/\'\'Edit','000001000001000039000010'),('QHn6T9rU7KsnS3Y70KCNTg','Account','Account Account  root import account ','root/import/account',1227080251,1233173545,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Account\'\'Account\'\'root\'\'import\'\'account','000001000001000001'),('HPDOcsj4gBme8D4svHodBw','Profile','Profile Profile  root import account profile ','root/import/account/profile',1225404573,1225404573,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Profile\'\'Profile\'\'root\'\'import\'\'account\'\'profile','000001000001000001000001'),('d8jMMMRddSQ7twP4l1ZSIw','Default Survey Take','Default Survey Take Default Survey Take  root import survey default survey take ','root/import/survey/default-survey-take',1227248175,1234040817,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Survey\'\'Take\'\'Default\'\'Survey\'\'Take\'\'root\'\'import\'\'survey\'\'default\'\'survey\'\'take Survey\'\'/\'\'Take','000001000001000039000006'),('WikiKeyword00000000001',' Wiki Pages By Keyword (default)',' Wiki Pages By Keyword (default)  Wiki Pages By Keyword  wiki master by keyword template.tmpl ','wiki-master-by-keyword-template.tmpl',1185754571,1185754571,'3','7','3','WebGUI::Asset::Template',1,'Wiki\'\'Pages\'\'By\'\'Keyword\'\'(\'\'default\'\')\'\'Wiki\'\'Pages\'\'By\'\'Keyword\'\'wiki\'\'master\'\'by\'\'keyword\'\'template\'\'.\'\'tmpl WikiMaster_byKeyword','000001000001000048000008'),('tempspace0000000000000','Tempspace','Tempspace Tempspace  tempspace ','tempspace',1185754574,1185754574,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Tempspace\'\'Tempspace\'\'tempspace','000001000004'),('QpmlAiYZz6VsKBM-_0wXaw','UsersOnline Macro','  ','users-online-macro-templates',1224616691,1224616691,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'UsersOnline\'\'Macro\'\'UsersOnline\'\'Macro\'\'users\'\'online\'\'macro\'\'templates','000001000001000018000012'),('h_T2xtOxGRQ9QJOR6ebLpQ','UsersOnline Default View','UsersOnline Default View UsersOnline Default View  users online macro templates usersonline default view ','users-online-macro-templates/usersonline-default-view',1224616545,1224616545,'3','7','3','WebGUI::Asset::Template',1,'UsersOnline\'\'Default\'\'View\'\'UsersOnline\'\'Default\'\'View\'\'users\'\'online\'\'macro\'\'templates\'\'usersonline\'\'default\'\'view Macro\'\'/\'\'UsersOnline','000001000001000018000012000001'),('4Ekp0kJoJllRRRo_J1Rj6w','UsersOnline Detailed View','UsersOnline Detailed View UsersOnline Detailed View  users online macro templates usersonline detailed view ','users-online-macro-templates/usersonline-detailed-view',1224616672,1224616672,'3','7','3','WebGUI::Asset::Template',1,'UsersOnline\'\'Detailed\'\'View\'\'UsersOnline\'\'Detailed\'\'View\'\'users\'\'online\'\'macro\'\'templates\'\'usersonline\'\'detailed\'\'view Macro\'\'/\'\'UsersOnline','000001000001000018000012000002'),('THQhn1C-ooj-TLlEP7aIJQ','gallery-ie.css','gallery-ie.css gallery-ie.css  root import gallery templates gallery ie.css ','root/import/gallery-templates/gallery-ie.css',1225313951,1225313951,'3','7','3','WebGUI::Asset::Snippet',1,'gallery\'\'-\'\'ie\'\'.\'\'css\'\'gallery\'\'-\'\'ie\'\'.\'\'css\'\'root\'\'import\'\'gallery\'\'templates\'\'gallery\'\'ie\'\'.\'\'css .\'\'wgPicture\'\'{\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgAlbum\'\'{\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgGallery\'\'.\'\'pagination\'\'li\'\',\'\'.\'\'wgGallery\'\'.\'\'pagination\'\'a\'\'{\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgGallery\'\'.\'\'container\'\'{\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'}','000001000001000013000025'),('qsG6B24a0SC5KrhQjmdZBw','survey.css','survey.css survey.css  survey.css ','survey.css',1233860274,1233860274,'3','7','12','WebGUI::Asset::Snippet',1,'survey\'\'.\'\'css\'\'survey\'\'.\'\'css\'\'survey\'\'.\'\'css body\'\'{\'\'margin\'\':\'\'0\'\';\'\'background\'\'-\'\'repeat\'\':\'\'repeat\'\'-\'\'y\'\';\'\'background\'\'-\'\'position\'\':\'\'0px\'\'0px\'\';\'\'}\'\'.\'\'survey\'\'-\'\'header\'\'{\'\'width\'\':\'\'80\'\'%\'\';\'\'height\'\':\'\'20px\'\';\'\'margin\'\'-\'\'left\'\':\'\'80px\'\';\'\'}\'\'#\'\'survey\'\'{\'\'margin\'\'-\'\'left\'\':\'\'80px\'\';\'\'width\'\':\'\'85\'\'%\'\';\'\'}\'\'div\'\'.\'\'dateanswer\'\'{\'\'min\'\'-\'\'height\'\':\'\'250px\'\';\'\'}\'\'div\'\'.\'\'slider\'\'-\'\'bg\'\'{\'\'position\'\':\'\'relative\'\';\'\'background\'\':\'\'url\'\'(\'\'/\'\'extras\'\'/\'\'wobject\'\'/\'\'Survey\'\'/\'\'bg\'\'-\'\'fader\'\'-\'\'500\'\'.\'\'gif\'\')\'\'5px\'\'0\'\'no\'\'-\'\'repeat\'\';\'\'height\'\':\'\'68px\'\';\'\'width\'\':\'\'529px\'\';\'\'}\'\'div\'\'.\'\'slider\'\'-\'\'thumb\'\'{\'\'cursor\'\':\'\'default\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'30px\'\';\'\'left\'\':\'\'4px\'\';\'\'}\'\'div\'\'.\'\'slider\'\'-\'\'min\'\'-\'\'thumb\'\'{\'\'cursor\'\':\'\'default\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'4px\'\';\'\'}\'\'div\'\'.\'\'slider\'\'-\'\'max\'\'-\'\'thumb\'\'{\'\'cursor\'\':\'\'default\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'4px\'\';\'\'}\'\'#\'\'headertitle\'\'{\'\'display\'\':\'\'none\'\';\'\'}\'\'#\'\'headertext\'\'{\'\'display\'\':\'\'none\'\';\'\'}\'\'#\'\'questions\'\'{\'\'display\'\':\'\'none\'\';\'\'}\'\'input\'\'.\'\'mcbutton\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'CCCCCC\'\';\'\'background\'\'-\'\'repeat\'\':\'\'repeat\'\'-\'\'x\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'display\'\':\'\'block\'\';\'\'margin\'\':\'\'0\'\'.\'\'5em\'\';\'\'padding\'\':\'\'.\'\'8em\'\';\'\'width\'\':\'\'60px\'\';\'\'font\'\'-\'\'family\'\':\'\'Verdana\'\',\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'color\'\':\'\'#\'\'000000\'\';\'\'background\'\'-\'\'image\'\':\'\'url\'\'(\'\'/\'\'extras\'\'/\'\'wobject\'\'/\'\'Survey\'\'/\'\'gradient\'\'-\'\'glossy\'\'.\'\'png\'\')\'\';\'\'}\'\'input\'\'.\'\'mcbutton\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'B6D2F1\'\';\'\'font\'\'-\'\'family\'\':\'\'Verdana\'\',\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'color\'\':\'\'#\'\'000000\'\';\'\'}\'\'input\'\'.\'\'mcbutton\'\'-\'\'selected\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'172D9D\'\';\'\'background\'\'-\'\'repeat\'\':\'\'repeat\'\'-\'\'x\'\';\'\'color\'\':\'\'#\'\'FFFFFF\'\';\'\'font\'\'-\'\'family\'\':\'\'Verdana\'\',\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'margin\'\':\'\'0\'\'.\'\'5em\'\';\'\'padding\'\':\'\'.\'\'8em\'\';\'\'width\'\':\'\'60px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'display\'\':\'\'block\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'background\'\'-\'\'image\'\':\'\'url\'\'(\'\'/\'\'extras\'\'/\'\'wobject\'\'/\'\'Survey\'\'/\'\'gradient\'\'-\'\'glossy\'\'.\'\'png\'\')\'\';\'\'background\'\'-\'\'position\'\':\'\'0px\'\'0px\'\';\'\'}\'\'/\'\'*\'\'By\'\'default\'\'the\'\'marker\'\'for\'\'invalid\'\'(\'\'required\'\')\'\'fields\'\'is\'\'a\'\'red\'\'\'\'\'*\'\'\'\'\'*\'\'/\'\'.\'\'survey\'\'-\'\'invalid\'\'-\'\'marker\'\'{\'\'color\'\':\'\'#\'\'FF0000\'\';\'\'}\'\'#\'\'survey\'\'{\'\'font\'\'-\'\'family\'\':\'\'Verdana\'\',\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'border\'\':\'\'3px\'\'solid\'\'#\'\'1e1e1e\'\';\'\'}\'\'#\'\'survey\'\'#\'\'survey\'\'-\'\'header\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'cfcfcf\'\';\'\'padding\'\'-\'\'top\'\':\'\'1px\'\';\'\'}\'\'#\'\'survey\'\'#\'\'headertitle\'\'{\'\'padding\'\'-\'\'left\'\':\'\'5px\'\';\'\'}\'\'#\'\'survey\'\'#\'\'progress\'\'{\'\'position\'\':\'\'relative\'\';\'\'top\'\':\'\'-\'\'26px\'\';\'\'right\'\':\'\'5px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'font\'\'-\'\'style\'\':\'\'italic\'\';\'\'}\'\'#\'\'survey\'\'#\'\'progress\'\':\'\'before\'\'{\'\'content\'\':\'\'\"\'\'Progress\'\':\'\'\"\'\';\'\'}\'\'#\'\'survey\'\'#\'\'headertext\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'2px\'\'solid\'\'#\'\'1e1e1e\'\';\'\'padding\'\':\'\'5px\'\';\'\'position\'\':\'\'relative\'\';\'\'top\'\':\'\'-\'\'20px\'\';\'\'}\'\'#\'\'survey\'\'#\'\'questions\'\'{\'\'position\'\':\'\'relative\'\';\'\'top\'\':\'\'-\'\'20px\'\';\'\'}\'\'#\'\'survey\'\'.\'\'question\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'dfdfdf\'\';\'\'padding\'\':\'\'10px\'\'5px\'\'10px\'\'5px\'\';\'\'}\'\'#\'\'survey\'\'.\'\'question\'\'p\'\':\'\'before\'\'{\'\'content\'\':\'\'\"\'\'Q\'\':\'\'\"\'\';\'\'}\'\'#\'\'survey\'\'.\'\'scale\'\':\'\'before\'\'{\'\'content\'\':\'\'\"\'\'A\'\':\'\'\"\'\';\'\'}\'\'#\'\'survey\'\'#\'\'submitbutton\'\'{\'\'margin\'\'-\'\'left\'\':\'\'5px\'\';\'\'}','000001000001000039000011'),('itransact_credentials1','ITransact Credentials (Default)','ITransact Credentials (Default) ITransact Credentials (Default)  shopping cart collateral items itransact credentials ','shopping-cart-collateral-items/itransact-credentials',1228953856,1228953856,'3','7','4','WebGUI::Asset::Template',1,'ITransact\'\'Credentials\'\'(\'\'Default\'\')\'\'ITransact\'\'Credentials\'\'(\'\'Default\'\')\'\'shopping\'\'cart\'\'collateral\'\'items\'\'itransact\'\'credentials Shop\'\'/\'\'Credentials','000001000001000034000018'),('1oBRscNIcFOI-pETrCOspA','Default Section Edit','Default Section Edit Default Section Edit  root import survey default section edit ','root/import/survey/default-section-edit',1226009642,1232648656,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Section\'\'Edit\'\'Default\'\'Section\'\'Edit\'\'root\'\'import\'\'survey\'\'default\'\'section\'\'edit Survey\'\'/\'\'Edit','000001000001000039000008'),('gI_TxK-5S4DNuv42wpImmw','Gallery Templates','  ','root/import/gallery-templates',1197330678,1213734379,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Gallery\'\'Templates\'\'Gallery\'\'Templates\'\'root\'\'import\'\'gallery\'\'templates','000001000001000013'),('jME5BEDYVDlBZ8jIQA9-jQ','Default Gallery Search','Default Gallery Search Default Gallery Search  root import gallery templates default gallery search ','root/import/gallery-templates/default-gallery-search',1197927169,1234565056,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Search\'\'Default\'\'Gallery\'\'Search\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'search Gallery\'\'/\'\'Search','000001000001000013000001'),('azCqD0IjdQSlM3ar29k5Sg','Default Gallery List Albums View','Default Gallery List Albums View Default Gallery List Albums View  root import gallery templates default gallery list albums view ','root/import/gallery-templates/default-gallery-list-albums-view',1197881748,1234561066,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'List\'\'Albums\'\'View\'\'Default\'\'Gallery\'\'List\'\'Albums\'\'View\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'list\'\'albums\'\'view Gallery\'\'/\'\'ListAlbums','000001000001000013000002'),('05FpjceLYhq4csF1Kww1KQ','Default Gallery View Album','Default Gallery View Album Default Gallery View Album  root import gallery templates default gallery view album ','root/import/gallery-templates/default-gallery-view-album',1197879361,1236641791,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'View\'\'Album\'\'Default\'\'Gallery\'\'View\'\'Album\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'view\'\'album GalleryAlbum\'\'/\'\'View','000001000001000013000003'),('q5O62aH4pjUXsrQR3Pq4lw','Default Gallery View Album Thumbnails','Default Gallery View Album Thumbnails Default Gallery View Album Thumbnails  root import gallery templates default gallery view album thumbnails ','root/import/gallery-templates/default-gallery-view-album-thumbnails',1197825772,1234568087,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'View\'\'Album\'\'Thumbnails\'\'Default\'\'Gallery\'\'View\'\'Album\'\'Thumbnails\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'view\'\'album\'\'thumbnails GalleryAlbum\'\'/\'\'ViewThumbnails','000001000001000013000004'),('KAMdiUdJykjN02CPHpyZOw','Default Gallery View Album Slideshow','Default Gallery View Album Slideshow Default Gallery View Album Slideshow  root import gallery templates default gallery view album slideshow ','root/import/gallery-templates/default-gallery-view-album-slideshow',1197825787,1230581176,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'View\'\'Album\'\'Slideshow\'\'Default\'\'Gallery\'\'View\'\'Album\'\'Slideshow\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'view\'\'album\'\'slideshow GalleryAlbum\'\'/\'\'ViewSlideshow','000001000001000013000005'),('OkphOEdaSGTXnFGhK4GT5A','Default Gallery List Files For User','Default Gallery List Files For User Default Gallery List Files For User  root import gallery templates default gallery list files for user ','root/import/gallery-templates/default-gallery-list-files-for-user',1197825794,1234560760,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'List\'\'Files\'\'For\'\'User\'\'Default\'\'Gallery\'\'List\'\'Files\'\'For\'\'User\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'list\'\'files\'\'for\'\'user Gallery\'\'/\'\'ListFilesForUser','000001000001000013000006'),('TEId5V-jEvUULsZA0wuRuA','Default Gallery View Photo','Default Gallery View Photo Default Gallery View Photo  root import gallery templates default gallery view photo ','root/import/gallery-templates/default-gallery-view-photo',1197989443,1234568469,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'View\'\'Photo\'\'Default\'\'Gallery\'\'View\'\'Photo\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'view\'\'photo GalleryFile\'\'/\'\'View','000001000001000013000007'),('6X-7Twabn5KKO_AbgK3PEw','Default Gallery Edit Album','Default Gallery Edit Album Default Gallery Edit Album  root import gallery templates default gallery edit album ','root/import/gallery-templates/default-gallery-edit-album',1197987780,1233872216,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Edit\'\'Album\'\'Default\'\'Gallery\'\'Edit\'\'Album\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'edit\'\'album GalleryAlbum\'\'/\'\'Edit','000001000001000013000008'),('7JCTAiu1U_bT9ldr655Blw','Default Gallery Edit Photo','Default Gallery Edit Photo Default Gallery Edit Photo  root import gallery templates default gallery edit photo ','root/import/gallery-templates/default-gallery-edit-photo',1197825824,1233872075,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Edit\'\'Photo\'\'Default\'\'Gallery\'\'Edit\'\'Photo\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'edit\'\'photo GalleryFile\'\'/\'\'Edit','000001000001000013000009'),('0X4Q3tBWUb_thsVbsYz9xQ','Default Gallery Add Archive','Default Gallery Add Archive Default Gallery Add Archive  root import gallery templates default gallery add archive ','root/import/gallery-templates/default-gallery-add-archive',1197987372,1230581176,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Add\'\'Archive\'\'Default\'\'Gallery\'\'Add\'\'Archive\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'add\'\'archive GalleryAlbum\'\'/\'\'AddArchive','000001000001000013000010'),('m3IbBavqzuKDd2PGGhKPlA','Default Gallery Make Shortcut','Default Gallery Make Shortcut Default Gallery Make Shortcut  root import gallery templates default gallery make shortcut ','root/import/gallery-templates/default-gallery-make-shortcut',1197825845,1233871747,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Make\'\'Shortcut\'\'Default\'\'Gallery\'\'Make\'\'Shortcut\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'make\'\'shortcut GalleryFile\'\'/\'\'MakeShortcut','000001000001000013000011'),('UTNFeV7B_aSCRmmaFCq4Vw','Default Gallery Delete Album','Default Gallery Delete Album Default Gallery Delete Album  root import gallery templates default gallery delete album ','root/import/gallery-templates/default-gallery-delete-album',1197825856,1244073447,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Delete\'\'Album\'\'Default\'\'Gallery\'\'Delete\'\'Album\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'delete\'\'album GalleryAlbum\'\'/\'\'Delete','000001000001000013000012'),('zcX-wIUct0S_np14xxOA-A','Default Gallery Delete File','Default Gallery Delete File Default Gallery Delete File  root import gallery templates default gallery delete file ','root/import/gallery-templates/default-gallery-delete-file',1197825866,1234568742,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Delete\'\'File\'\'Default\'\'Gallery\'\'Delete\'\'File\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'delete\'\'file GalleryFile\'\'/\'\'Delete','000001000001000013000013'),('MBZK_LPVzqhb4TV4mMRTJg','admin_ie7.css','admin_ie7.css admin_ie7.css  root import gallery templates admin ie7.css ','root/import/gallery-templates/admin_ie7.css',1197330678,1197330678,'3','7','3','WebGUI::Asset::Snippet',1,'admin_ie7\'\'.\'\'css\'\'admin_ie7\'\'.\'\'css\'\'root\'\'import\'\'gallery\'\'templates\'\'admin\'\'ie7\'\'.\'\'css input\'\'.\'\'captionEnter\'\'{\'\'margin\'\'-\'\'left\'\':\'\'-\'\'5px\'\';\'\'width\'\':\'\'92px\'\';\'\'}','000001000001000013000014'),('_hELmIJfgbAyXFNqPyApxQ','admin.css','admin.css admin.css  root import gallery templates admin.css ','root/import/gallery-templates/admin.css',1197330678,1213309523,'3','7','3','WebGUI::Asset::Snippet',1,'admin\'\'.\'\'css\'\'admin\'\'.\'\'css\'\'root\'\'import\'\'gallery\'\'templates\'\'admin\'\'.\'\'css #\'\'adminWrapper\'\'{\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'position\'\':\'\'relative\'\';\'\'z\'\'-\'\'index\'\':\'\'2\'\';\'\'}\'\'h2\'\'{\'\'font\'\'-\'\'size\'\':\'\'15px\'\';\'\'}\'\'.\'\'messageStyle\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'8px\'\';\'\'}\'\'.\'\'adminButton\'\'{\'\'border\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'e0e0e0\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'color\'\':\'\'#\'\'333\'\';\'\'cursor\'\':\'\'pointer\'\';\'\'padding\'\':\'\'0\'\'.\'\'5em\'\'1em\'\';\'\'}\'\'.\'\'adminTable\'\'{\'\'border\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'F0F0F0\'\';\'\'color\'\':\'\'black\'\';\'\'width\'\':\'\'320px\'\';\'\'padding\'\':\'\'5px\'\';\'\'}\'\'.\'\'adminTable\'\'select\'\',\'\'.\'\'adminTable\'\'input\'\',\'\'.\'\'adminTable\'\'textarea\'\'{\'\'border\'\':\'\'solid\'\'gray\'\'1px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'padding\'\'-\'\'left\'\':\'\'5px\'\';\'\'}\'\'.\'\'label\'\'{\'\'white\'\'-\'\'space\'\':\'\'nowrap\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'padding\'\'-\'\'right\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'width\'\':\'\'1px\'\';\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'}\'\'.\'\'galleryOrg\'\'{\'\'position\'\':\'\'relative\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'padding\'\'-\'\'top\'\':\'\'0px\'\';\'\'margin\'\'-\'\'left\'\':\'\'5px\'\';\'\'border\'\':\'\'gray\'\'solid\'\'1px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'margin\'\'-\'\'top\'\':\'\'3px\'\';\'\'width\'\':\'\'95\'\'%\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'DEDEDE\'\'}\'\'.\'\'galleryOrg\'\'.\'\'left\'\'{\'\'float\'\':\'\'left\'\';\'\'width\'\':\'\'36\'\'%\'\';\'\'}\'\'.\'\'galleryOrg\'\'.\'\'right\'\'{\'\'width\'\':\'\'63\'\'%\'\';\'\'}\'\'.\'\'galleryOrg\'\'img\'\'{\'\'display\'\':\'\'block\'\';\'\'height\'\':\'\'150px\'\';\'\'margin\'\':\'\'0px\'\'auto\'\';\'\'}\'\'.\'\'promote\'\'{\'\'margin\'\'-\'\'left\'\':\'\'3px\'\';\'\'}\'\'.\'\'promote\'\'img\'\'{\'\'height\'\':\'\'14px\'\';\'\'width\'\':\'\'16px\'\';\'\'}\'\'.\'\'demote\'\'{\'\'margin\'\'-\'\'right\'\':\'\'3px\'\';\'\'}\'\'.\'\'demote\'\'img\'\'{\'\'height\'\':\'\'14px\'\';\'\'width\'\':\'\'16px\'\';\'\'}\'\'.\'\'delete\'\'img\'\'{\'\'height\'\':\'\'14px\'\';\'\'}\'\'.\'\'numbering\'\'{\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'0px\'\';\'\'left\'\':\'\'0px\'\';\'\'padding\'\':\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'black\'\';\'\'color\'\':\'\'white\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'bottomRight\'\':\'\'5px\'\'}\'\'input\'\'.\'\'captionEnter\'\'{\'\'width\'\':\'\'93px\'\';\'\'clear\'\':\'\'both\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'3px\'\'}\'\'.\'\'galleryOrg\'\'button\'\'{\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'background\'\':\'\'none\'\';\'\'}\'\'.\'\'galleryOrg\'\'button\'\'img\'\'{\'\'width\'\':\'\'16px\'\';\'\'height\'\':\'\'auto\'\';\'\'}\'\'.\'\'galleryOrg\'\'.\'\'synopsis\'\'input\'\'{\'\'width\'\':\'\'80px\'\';\'\'}','000001000001000013000015'),('kaPRSaf8UKiskiGEgJgLAw','images','images images  root import gallery templates images ','root/import/gallery-templates/images',1197330678,1197330678,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'images\'\'images\'\'root\'\'import\'\'gallery\'\'templates\'\'images','000001000001000013000017'),('bANo8aiAPA7aY_oQZKxIWw','rss.gif','rss.gif rss.gif  root import gallery templates images rss.gif ','root/import/gallery-templates/images/rss.gif',1197330678,1197330678,'3','7','3','WebGUI::Asset::File::Image',1,'rss\'\'.\'\'gif\'\'rss\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'rss\'\'.\'\'gif','000001000001000013000017000001'),('2ci_v2d4x4uvyjTRlC49OA','moveDown.gif','moveDown.gif moveDown.gif  root import gallery templates images movedown.gif ','root/import/gallery-templates/images/movedown.gif',1197330678,1209499188,'3','7','3','WebGUI::Asset::File::Image',1,'moveDown\'\'.\'\'gif\'\'moveDown\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'movedown\'\'.\'\'gif','000001000001000013000017000002'),('O-EsSzKgAk1KolFT-x_KsA','moveUp.gif','moveUp.gif moveUp.gif  root import gallery templates images moveup.gif ','root/import/gallery-templates/images/moveup.gif',1197330678,1209499188,'3','7','3','WebGUI::Asset::File::Image',1,'moveUp\'\'.\'\'gif\'\'moveUp\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'moveup\'\'.\'\'gif','000001000001000013000017000003'),('fdd8tGExyVwHyrB8RBbKXg','next.gif','next.gif next.gif  root import gallery templates images next.gif ','root/import/gallery-templates/images/next.gif',1197330839,1197330839,'3','7','3','WebGUI::Asset::File::Image',1,'next\'\'.\'\'gif\'\'next\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'next\'\'.\'\'gif','000001000001000013000017000004'),('BpisgHl4ZDcSECJp6oib1w','play.gif','play.gif play.gif  root import gallery templates images play.gif ','root/import/gallery-templates/images/play.gif',1197330840,1197330840,'3','7','3','WebGUI::Asset::File::Image',1,'play\'\'.\'\'gif\'\'play\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'play\'\'.\'\'gif','000001000001000013000017000005'),('zshreRgPAXtnF0DtVbQ1Yg','previous.gif','previous.gif previous.gif  root import gallery templates images previous.gif ','root/import/gallery-templates/images/previous.gif',1197330840,1197330840,'3','7','3','WebGUI::Asset::File::Image',1,'previous\'\'.\'\'gif\'\'previous\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'previous\'\'.\'\'gif','000001000001000013000017000006'),('mM3bjP_iG9sv5nQb4S17tQ','Default Gallery View Album RSS','Default Gallery View Album RSS Default Gallery View Album RSS  root import gallery templates default gallery album rss ','root/import/gallery-templates/default-gallery-album-rss',1197879662,1230581176,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'View\'\'Album\'\'RSS\'\'Default\'\'Gallery\'\'View\'\'Album\'\'RSS\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'album\'\'rss GalleryAlbum\'\'/\'\'ViewRss','000001000001000013000018'),('ilu5BrM-VGaOsec9Lm7M6Q','Default Gallery List Albums RSS','Default Gallery List Albums RSS Default Gallery List Albums RSS  root import gallery templates default gallery list albums rss ','root/import/gallery-templates/default-gallery-list-albums-rss',1197878780,1230581176,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'List\'\'Albums\'\'RSS\'\'Default\'\'Gallery\'\'List\'\'Albums\'\'RSS\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'list\'\'albums\'\'rss Gallery\'\'/\'\'ListAlbumsRss','000001000001000013000019'),('-ANLpoTEP-n4POAdRxCzRw','Default Gallery List Files For User RSS','Default Gallery List Files For User RSS Default Gallery List Files For User RSS  root import gallery templates default gallery list files for user rss ','root/import/gallery-templates/default-gallery-list-files-for-user-rss',1197880641,1230581176,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'List\'\'Files\'\'For\'\'User\'\'RSS\'\'Default\'\'Gallery\'\'List\'\'Files\'\'For\'\'User\'\'RSS\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'list\'\'files\'\'for\'\'user\'\'rss Gallery\'\'/\'\'ListFilesForUserRss','000001000001000013000020'),('OxJWQgnGsgyGohP2L3zJPQ','Default Gallery Edit Comment','Default Gallery Edit Comment Default Gallery Edit Comment  root import gallery templates default gallery edit comment ','root/import/gallery-templates/default-gallery-edit-comment',1204663962,1234564647,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Gallery\'\'Edit\'\'Comment\'\'Default\'\'Gallery\'\'Edit\'\'Comment\'\'root\'\'import\'\'gallery\'\'templates\'\'default\'\'gallery\'\'edit\'\'comment GalleryFile\'\'/\'\'EditComment','000001000001000013000021'),('Tsg7xmPYv782j6IVz7yHFg','Calendar Templates','Calendar Templates Calendar Templates  root import calendar templates ','root/import/calendar-templates',1204890713,1213244777,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Calendar\'\'Templates\'\'Calendar\'\'Templates\'\'root\'\'import\'\'calendar\'\'templates','000001000001000005'),('kj3b-X3i6zRKnhLb4ZiCLw','Default Calendar List View','Default Calendar List View Default Calendar List View  root import calendar templates default calendar list view ','root/import/calendar-templates/default-calendar-list-view',1204890713,1243445504,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'List\'\'View\'\'Default\'\'Calendar\'\'List\'\'View\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'list\'\'view Calendar\'\'/\'\'List','000001000001000005000001'),('uRL9qtk7Rb0YRJ41LmHOJw','Default Calendar Print List View','Default Calendar Print List View Default Calendar Print List View  root import calendar templates default calendar print list view ','root/import/calendar-templates/default-calendar-print-list-view',1204890713,1229311072,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'List\'\'View\'\'Default\'\'Calendar\'\'Print\'\'List\'\'View\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'print\'\'list\'\'view Calendar\'\'/\'\'Print\'\'/\'\'List','000001000001000005000002'),('CalendarWeek0000000001','Default Calendar Week','Default Calendar Week Default Calendar Week  root import calendar templates default calendar week ','root/import/calendar-templates/default-calendar-week',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Week\'\'Default\'\'Calendar\'\'Week\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'week Calendar\'\'/\'\'Week','000001000001000005000003'),('CalendarDay00000000001','Default Calendar Day','Default Calendar Day Default Calendar Day  root import calendar templates default calendar day ','root/import/calendar-templates/default-calendar-day',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Day\'\'Default\'\'Calendar\'\'Day\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'day Calendar\'\'/\'\'Day','000001000001000005000004'),('CalendarEvent000000001','Default Calendar Event','Default Calendar Event Default Calendar Event  root import calendar templates default calendar event ','root/import/calendar-templates/default-calendar-event',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Event\'\'Default\'\'Calendar\'\'Event\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'event Calendar\'\'/\'\'Event','000001000001000005000005'),('CalendarEventEdit00001','Default Calendar Event Edit','Default Calendar Event Edit Default Calendar Event Edit  root import calendar templates default calendar event edit ','root/import/calendar-templates/default-calendar-event-edit',1205160982,1233698348,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Event\'\'Edit\'\'Default\'\'Calendar\'\'Event\'\'Edit\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'event\'\'edit Calendar\'\'/\'\'EventEdit','000001000001000005000006'),('CalendarMonth000000001','Default Calendar Month','Default Calendar Month Default Calendar Month  root import calendar templates default calendar month ','root/import/calendar-templates/default-calendar-month',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Month\'\'Default\'\'Calendar\'\'Month\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'month Calendar\'\'/\'\'Month','000001000001000005000007'),('CalendarSearch00000001','Default Calendar Search','Default Calendar Search Default Calendar Search  root import calendar templates default calendar search ','root/import/calendar-templates/default-calendar-search',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Search\'\'Default\'\'Calendar\'\'Search\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'search Calendar\'\'/\'\'Search','000001000001000005000008'),('CalendarPrintEvent0001','Default Calendar Print Event','Default Calendar Print Event Default Calendar Print Event  root import calendar templates default calendar print event ','root/import/calendar-templates/default-calendar-print-event',1204890714,1215396964,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Event\'\'Default\'\'Calendar\'\'Print\'\'Event\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'print\'\'event Calendar\'\'/\'\'Print\'\'/\'\'Event','000001000001000005000009'),('CalendarPrintMonth0001','Default Calendar Print Month','Default Calendar Print Month Default Calendar Print Month  root import calendar templates default calendar print month ','root/import/calendar-templates/default-calendar-print-month',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Month\'\'Default\'\'Calendar\'\'Print\'\'Month\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'print\'\'month Calendar\'\'/\'\'Print\'\'/\'\'Month','000001000001000005000010'),('CalendarPrintWeek00001','Default Calendar Print Week','Default Calendar Print Week Default Calendar Print Week  root import calendar templates default calendar print week ','root/import/calendar-templates/default-calendar-print-week',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Week\'\'Default\'\'Calendar\'\'Print\'\'Week\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'print\'\'week Calendar\'\'/\'\'Print\'\'/\'\'Week','000001000001000005000011'),('CalendarPrintDay000001','Default Calendar Print Day','Default Calendar Print Day Default Calendar Print Day  root import calendar templates default calendar print day ','root/import/calendar-templates/default-calendar-print-day',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Calendar\'\'Print\'\'Day\'\'Default\'\'Calendar\'\'Print\'\'Day\'\'root\'\'import\'\'calendar\'\'templates\'\'default\'\'calendar\'\'print\'\'day Calendar\'\'/\'\'Print\'\'/\'\'Day','000001000001000005000012'),('jnYdqDkUR8x7Pv2eGR1qTA','Thingy Templates','Thingy Templates Thingy Templates  root import thingy templates ','root/import/thingy-templates',1205431513,1216250666,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Thingy\'\'Templates\'\'Thingy\'\'Templates\'\'root\'\'import\'\'thingy\'\'templates','000001000001000041'),('ThingyTmpl000000000001','Default Thingy','Default Thingy Default Thingy  templates thingy default ','templates/thingy-default',1205003608,1227753116,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Thingy\'\'Default\'\'Thingy\'\'templates\'\'thingy\'\'default Thingy','000001000001000041000001'),('ThingyTmpl000000000002','Default Thingy View Thing','Default Thingy View Thing Default Thingy View Thing  templates thingy default view thing ','templates/thingy-default-view-thing',1205003676,1222574693,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Thingy\'\'View\'\'Thing\'\'Default\'\'Thingy\'\'View\'\'Thing\'\'templates\'\'thingy\'\'default\'\'view\'\'thing Thingy\'\'/\'\'ViewThing','000001000001000041000002'),('ThingyTmpl000000000003','Default Thingy Edit Thing','Default Thingy Edit Thing Default Thingy Edit Thing  templates thingy default edit thing ','templates/thingy-default-edit-thing',1205003711,1224518002,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Thingy\'\'Edit\'\'Thing\'\'Default\'\'Thingy\'\'Edit\'\'Thing\'\'templates\'\'thingy\'\'default\'\'edit\'\'thing Thingy\'\'/\'\'EditThing','000001000001000041000003'),('ThingyTmpl000000000004','Default Thingy Search Thing','Default Thingy Search Thing Default Thingy Search Thing  templates thingy default search thing ','templates/thingy-default-search-thing',1205158717,1227044214,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Thingy\'\'Search\'\'Thing\'\'Default\'\'Thingy\'\'Search\'\'Thing\'\'templates\'\'thingy\'\'default\'\'search\'\'thing Thingy\'\'/\'\'SearchThing','000001000001000041000004'),('7fE8md51vTCcuJFOvxNaGA','thumbnails.js','thumbnails.js thumbnails.js  root import gallery templates thumbnails.js ','root/import/gallery-templates/thumbnails.js',1205443600,1209503742,'3','7','3','WebGUI::Asset::Snippet',1,'thumbnails\'\'.\'\'js\'\'thumbnails\'\'.\'\'js\'\'root\'\'import\'\'gallery\'\'templates\'\'thumbnails\'\'.\'\'js /\'\'/\'\'Depends\'\'on\'\'BrowserDetect\'\'.\'\'js\'\'/\'\'/\'\'Make\'\'the\'\'thumbnails\'\'a\'\'little\'\'bigger\'\'while\'\'the\'\'mouse\'\'is\'\'over\'\'them\'\'function\'\'scaleThumbUp\'\'(\'\'e\'\',\'\'anchor\'\')\'\'{\'\'/\'\'/\'\'IE6\'\'doesn\'\'\'\'\'t\'\'like\'\'to\'\'do\'\'the\'\'right\'\'thing\'\'with\'\'the\'\'CSS\'\'stuff\'\'below\'\',\'\'exclude\'\'it\'\'if\'\'(\'\'BrowserDetect\'\')\'\'{\'\'if\'\'(\'\'BrowserDetect\'\'.\'\'browser\'\'=\'\'=\'\'\"\'\'Explorer\'\'\"\'\'&\'\'&\'\'BrowserDetect\'\'.\'\'version\'\'<\'\'7\'\')\'\'{\'\'return\'\';\'\'}\'\'}\'\'/\'\'/\'\'Make\'\'a\'\'new\'\'image\'\'with\'\'the\'\'same\'\'image\'\'src\'\'as\'\'the\'\'anchor\'\'var\'\'oldImage\'\'=\'\'anchor\'\'.\'\'getElementsByTagName\'\'(\'\'\"\'\'img\'\'\"\'\')\'\'[0]\'\';\'\'var\'\'newContainer\'\'=\'\'document\'\'.\'\'createElement\'\'(\'\'\"\'\'div\'\'\"\'\')\'\';\'\'newContainer\'\'.\'\'className\'\'=\'\'\"\'\'thumb\'\'-\'\'popup\'\'\"\'\';\'\'newContainer\'\'.\'\'style\'\'.\'\'position\'\'=\'\'\"\'\'absolute\'\'\"\'\';\'\'newContainer\'\'.\'\'style\'\'.\'\'zIndex\'\'=\'\'\"\'\'1\'\'\"\'\';\'\'var\'\'newWidth\'\'=\'\'oldImage\'\'.\'\'offsetWidth\'\'*\'\'3\'\';\'\'var\'\'newHeight\'\'=\'\'oldImage\'\'.\'\'offsetHeight\'\'*\'\'3\'\';\'\'var\'\'newLeft\'\'=\'\'(\'\'(\'\'anchor\'\'.\'\'offsetLeft\'\'+\'\'(\'\'anchor\'\'.\'\'offsetWidth\'\'/\'\'2\'\')\'\')\'\'-\'\'(\'\'newWidth\'\'/\'\'2\'\')\'\')\'\';\'\'var\'\'newTop\'\'=\'\'(\'\'(\'\'anchor\'\'.\'\'offsetTop\'\'+\'\'(\'\'anchor\'\'.\'\'offsetHeight\'\'/\'\'2\'\')\'\')\'\'-\'\'(\'\'newHeight\'\'/\'\'2\'\')\'\')\'\';\'\'newContainer\'\'.\'\'style\'\'.\'\'left\'\'=\'\'newLeft\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newContainer\'\'.\'\'style\'\'.\'\'top\'\'=\'\'newTop\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newContainer\'\'.\'\'style\'\'.\'\'width\'\'=\'\'newWidth\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newContainer\'\'.\'\'style\'\'.\'\'height\'\'=\'\'newHeight\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'var\'\'newImage\'\'=\'\'document\'\'.\'\'createElement\'\'(\'\'\"\'\'img\'\'\"\'\')\'\';\'\'newImage\'\'.\'\'src\'\'=\'\'oldImage\'\'.\'\'src\'\';\'\'newImage\'\'.\'\'style\'\'.\'\'width\'\'=\'\'\"\'\'100\'\'%\'\'\"\'\';\'\'newImage\'\'.\'\'style\'\'.\'\'height\'\'=\'\'\"\'\'100\'\'%\'\'\"\'\';\'\'newContainer\'\'.\'\'appendChild\'\'(\'\'newImage\'\')\'\';\'\'/\'\'/\'\'Make\'\'some\'\'text\'\'for\'\'the\'\'caption\'\'var\'\'caption\'\'=\'\'document\'\'.\'\'createElement\'\'(\'\'\"\'\'div\'\'\"\'\')\'\';\'\'caption\'\'.\'\'appendChild\'\'(\'\'document\'\'.\'\'createTextNode\'\'(\'\'anchor\'\'.\'\'title\'\')\'\')\'\';\'\'caption\'\'.\'\'className\'\'=\'\'\"\'\'caption\'\'\"\'\';\'\'newContainer\'\'.\'\'appendChild\'\'(\'\'caption\'\')\'\';\'\'var\'\'newBox\'\'=\'\'document\'\'.\'\'createElement\'\'(\'\'\"\'\'a\'\'\"\'\')\'\';\'\'newBox\'\'.\'\'href\'\'=\'\'anchor\'\'.\'\'href\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'block\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'position\'\'=\'\'\"\'\'absolute\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'zIndex\'\'=\'\'\"\'\'10\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'left\'\'=\'\'(\'\'anchor\'\'.\'\'offsetLeft\'\')\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'top\'\'=\'\'(\'\'anchor\'\'.\'\'offsetTop\'\')\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'height\'\'=\'\'(\'\'anchor\'\'.\'\'offsetHeight\'\')\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'width\'\'=\'\'(\'\'anchor\'\'.\'\'offsetWidth\'\')\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'newBox\'\'.\'\'style\'\'.\'\'border\'\'=\'\'\"\'\'1px\'\'solid\'\'transparent\'\'\"\'\';\'\'anchor\'\'.\'\'parentNode\'\'.\'\'appendChild\'\'(\'\'newContainer\'\')\'\';\'\'anchor\'\'.\'\'parentNode\'\'.\'\'appendChild\'\'(\'\'newBox\'\')\'\';\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'newBox\'\',\'\'\"\'\'click\'\'\"\'\',\'\'function\'\'(\'\')\'\'{\'\'window\'\'.\'\'location\'\'.\'\'href\'\'=\'\'anchor\'\'.\'\'href\'\'}\'\')\'\';\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'newContainer\'\',\'\'\"\'\'mouseout\'\'\"\'\',\'\'scaleThumbDown\'\',\'\'[\'\'newBox\'\',\'\'newContainer\'\',\'\'caption\'\']\'\')\'\';\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'newBox\'\',\'\'\"\'\'mouseout\'\'\"\'\',\'\'scaleThumbDown\'\',\'\'[\'\'newBox\'\',\'\'newContainer\'\',\'\'caption\'\']\'\')\'\';\'\'}\'\'function\'\'scaleThumbDown\'\'(\'\'e\'\',\'\'elements\'\')\'\'{\'\'for\'\'(\'\'var\'\'i\'\'=\'\'0\'\';\'\'i\'\'<\'\'elements\'\'.\'\'length\'\';\'\'i\'\'+\'\'+\'\')\'\'{\'\'elements[i]\'\'.\'\'parentNode\'\'.\'\'removeChild\'\'(\'\'elements[i]\'\')\'\';\'\'}\'\'}\'\'var\'\'anchorTimeout\'\';\'\'function\'\'enterAnchor\'\'(\'\'e\'\',\'\'anchor\'\')\'\'{\'\'if\'\'(\'\'typeof\'\'anchorTimeout\'\'!\'\'=\'\'\"\'\'undefined\'\'\"\'\')\'\'{\'\'clearTimeout\'\'(\'\'anchorTimeout\'\')\'\';\'\'}\'\'anchorTimeout\'\'=\'\'setTimeout\'\'(\'\'function\'\'(\'\')\'\'{\'\'scaleThumbUp\'\'(\'\'e\'\',\'\'anchor\'\')\'\';\'\'}\'\',\'\'150\'\')\'\';\'\'}\'\'function\'\'leaveAnchor\'\'(\'\'e\'\',\'\'anchor\'\')\'\'{\'\'if\'\'(\'\'typeof\'\'anchorTimeout\'\'!\'\'=\'\'\"\'\'undefined\'\'\"\'\')\'\'{\'\'clearTimeout\'\'(\'\'anchorTimeout\'\')\'\';\'\'}\'\'}\'\'function\'\'initThumb\'\'(\'\')\'\'{\'\'var\'\'anchors\'\'=\'\'YAHOO\'\'.\'\'util\'\'.\'\'Dom\'\'.\'\'getElementsByClassName\'\'(\'\'\"\'\'thumb\'\'\"\'\')\'\';\'\'for\'\'(\'\'var\'\'i\'\'=\'\'0\'\';\'\'i\'\'<\'\'anchors\'\'.\'\'length\'\';\'\'i\'\'+\'\'+\'\')\'\'{\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'anchors[i]\'\',\'\'\"\'\'mouseover\'\'\"\'\',\'\'enterAnchor\'\',\'\'anchors[i]\'\')\'\';\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'anchors[i]\'\',\'\'\"\'\'mouseout\'\'\"\'\',\'\'leaveAnchor\'\',\'\'anchors[i]\'\')\'\';\'\'}\'\'}\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'onDOMReady\'\'(\'\'initThumb\'\')\'\';','000001000001000013000022'),('1oGhfj00KkCzP1ez01AfKA','slideshow.js','slideshow.js slideshow.js  root import gallery templates slideshow.js ','root/import/gallery-templates/slideshow.js',1205635970,1218582812,'3','7','3','WebGUI::Asset::Snippet',1,'slideshow\'\'.\'\'js\'\'slideshow\'\'.\'\'js\'\'root\'\'import\'\'gallery\'\'templates\'\'slideshow\'\'.\'\'js if\'\'(\'\'typeof\'\'WebGUI\'\'=\'\'=\'\'\"\'\'undefined\'\'\"\'\')\'\'{\'\'WebGUI\'\'=\'\'{\'\'}\'\';\'\'}\'\'/\'\'*\'\'*\'\'WebGUI\'\'.\'\'Slideshow\'\'(\'\'config\'\')\'\'Configure\'\'and\'\'return\'\'a\'\'new\'\'Slideshow\'\'object\'\'.\'\'config\'\'is\'\'an\'\'object\'\'with\'\'the\'\'following\'\'properties\'\':\'\'containerId\'\'-\'\'The\'\'ID\'\'of\'\'the\'\'element\'\'that\'\'contains\'\'the\'\'Slideshow\'\'items\'\'.\'\'Defaults\'\'to\'\'\"\'\'slideshow\'\'-\'\'container\'\'\"\'\'currentIndex\'\'-\'\'The\'\'index\'\'of\'\'the\'\'first\'\'item\'\'in\'\'the\'\'Slideshow\'\'.\'\'Defaults\'\'to\'\'0\'\'isPlaying\'\'-\'\'If\'\'true\'\',\'\'the\'\'slideshow\'\'will\'\'begin\'\'immediately\'\'itemClassName\'\'-\'\'The\'\'class\'\'name\'\'of\'\'the\'\'slideshow\'\'items\'\'.\'\'Defaults\'\'to\'\'\"\'\'slideshow\'\'-\'\'item\'\'\"\'\'nextButtonId\'\'-\'\'The\'\'id\'\'of\'\'the\'\'button\'\'to\'\'go\'\'to\'\'the\'\'next\'\'item\'\'pauseImageSrc\'\'-\'\'The\'\'URL\'\'to\'\'the\'\'pause\'\'button\'\'image\'\'playDelay\'\'-\'\'The\'\'delay\'\'(\'\'in\'\'milliseconds\'\')\'\'between\'\'slides\'\'.\'\'Defaults\'\'to\'\'5000\'\'playImageSrc\'\'-\'\'The\'\'URL\'\'to\'\'the\'\'play\'\'button\'\'image\'\'playPauseButtonId\'\'-\'\'The\'\'id\'\'of\'\'the\'\'button\'\'to\'\'toggle\'\'between\'\'play\'\'and\'\'pause\'\'previousButtonId\'\'-\'\'The\'\'id\'\'of\'\'the\'\'button\'\'to\'\'go\'\'to\'\'the\'\'previous\'\'item\'\'wrap\'\'-\'\'If\'\'true\'\',\'\'the\'\'slideshow\'\'will\'\'wrap\'\'around\'\'*\'\'*\'\'*\'\'Control\'\'the\'\'slideshow\'\'To\'\'control\'\'the\'\'slideshow\'\',\'\'you\'\'can\'\'use\'\'the\'\'following\'\'methods\'\':\'\'next\'\'(\'\')\'\'-\'\'Pause\'\'the\'\'slideshow\'\'and\'\'go\'\'to\'\'the\'\'next\'\'slide\'\'previous\'\'(\'\')\'\'-\'\'Pause\'\'the\'\'slideshow\'\'and\'\'go\'\'to\'\'the\'\'previous\'\'slide\'\'play\'\'(\'\')\'\'-\'\'Play\'\'the\'\'slideshow\'\'pause\'\'(\'\')\'\'-\'\'Pause\'\'the\'\'slideshow\'\'togglePlay\'\'(\'\')\'\'-\'\'If\'\'it\'\'\'\'\'s\'\'playing\'\',\'\'pause\'\'it\'\'.\'\'If\'\'it\'\'\'\'\'s\'\'paused\'\',\'\'play\'\'it\'\'.\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'=\'\'function\'\'(\'\'config\'\')\'\'{\'\'this\'\'.\'\'containerId\'\'=\'\'config\'\'&\'\'&\'\'config\'\'.\'\'containerId\'\'?\'\'config\'\'.\'\'containerId\'\':\'\'\"\'\'slideshow\'\'-\'\'container\'\'\"\'\';\'\'this\'\'.\'\'currentIndex\'\'=\'\'config\'\'&\'\'&\'\'config\'\'.\'\'currentIndex\'\'?\'\'config\'\'.\'\'currentIndex\'\':\'\'0\'\';\'\'this\'\'.\'\'isPlaying\'\'=\'\'config\'\'&\'\'&\'\'config\'\'.\'\'isPlaying\'\'?\'\'config\'\'.\'\'isPlaying\'\':\'\'false\'\';\'\'this\'\'.\'\'itemClassName\'\'=\'\'config\'\'&\'\'&\'\'config\'\'.\'\'itemClassName\'\'?\'\'config\'\'.\'\'itemClassName\'\':\'\'\"\'\'slideshow\'\'-\'\'item\'\'\"\'\';\'\'this\'\'.\'\'nextButtonId\'\'=\'\'config\'\'?\'\'config\'\'.\'\'nextButtonId\'\':\'\'undefined\'\';\'\'this\'\'.\'\'pauseImageSrc\'\'=\'\'config\'\'?\'\'config\'\'.\'\'pauseImageSrc\'\':\'\'undefined\'\';\'\'this\'\'.\'\'playDelay\'\'=\'\'config\'\'&\'\'&\'\'config\'\'.\'\'playDelay\'\'?\'\'config\'\'.\'\'playDelay\'\':\'\'5000\'\';\'\'this\'\'.\'\'playImageSrc\'\'=\'\'config\'\'?\'\'config\'\'.\'\'playImageSrc\'\':\'\'undefined\'\';\'\'this\'\'.\'\'playPauseButtonId\'\'=\'\'config\'\'?\'\'config\'\'.\'\'playPauseButtonId\'\':\'\'undefined\'\';\'\'this\'\'.\'\'previousButtonId\'\'=\'\'config\'\'?\'\'config\'\'.\'\'previousButtonId\'\':\'\'undefined\'\';\'\'this\'\'.\'\'wrap\'\'=\'\'config\'\'&\'\'&\'\'config\'\'.\'\'wrap\'\'?\'\'config\'\'.\'\'wrap\'\':\'\'false\'\';\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'onDOMReady\'\'(\'\'this\'\'.\'\'init\'\',\'\'this\'\',\'\'true\'\')\'\';\'\'}\'\';\'\'/\'\'*\'\'*\'\'clearPlayTimeout\'\'(\'\')\'\'Clears\'\'the\'\'timeout\'\'to\'\'move\'\'to\'\'the\'\'next\'\'slide\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'clearPlayTimeout\'\'=\'\'function\'\'(\'\')\'\'{\'\'clearTimeout\'\'(\'\'this\'\'.\'\'playTimeout\'\')\'\';\'\'this\'\'.\'\'playTimeout\'\'=\'\'undefined\'\';\'\'}\'\'/\'\'*\'\'*\'\'doPlayTick\'\'(\'\'self\'\')\'\'Performs\'\'the\'\'action\'\'to\'\'move\'\'to\'\'the\'\'next\'\'slide\'\'and\'\'start\'\'a\'\'new\'\'timeout\'\'.\'\'self\'\'is\'\'a\'\'new\'\'reference\'\'to\'\'the\'\'object\'\'to\'\'get\'\'around\'\'the\'\'scoping\'\'issues\'\'with\'\'setTimeout\'\'(\'\')\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'doPlayTick\'\'=\'\'function\'\'(\'\'self\'\')\'\'{\'\'self\'\'.\'\'showNext\'\'(\'\')\'\';\'\'self\'\'.\'\'setPlayTimeout\'\'(\'\')\'\';\'\'}\'\'/\'\'*\'\'*\'\'getSlideshowContainer\'\'(\'\')\'\'Returns\'\'the\'\'HTMLElement\'\'for\'\'the\'\'Slideshow\'\'container\'\'.\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'getSlideshowContainer\'\'=\'\'function\'\'(\'\')\'\'{\'\'return\'\'document\'\'.\'\'getElementById\'\'(\'\'this\'\'.\'\'containerId\'\')\'\';\'\'}\'\';\'\'/\'\'*\'\'*\'\'getSlideshowItems\'\'(\'\')\'\'Returns\'\'an\'\'array\'\'of\'\'HTMLElements\'\'for\'\'the\'\'Slideshow\'\'\'\'\'s\'\'items\'\'.\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'getSlideshowItems\'\'=\'\'function\'\'(\'\')\'\'{\'\'var\'\'items\'\'=\'\'YAHOO\'\'.\'\'util\'\'.\'\'Dom\'\'.\'\'getElementsByClassName\'\'(\'\'this\'\'.\'\'itemClassName\'\',\'\'undefined\'\',\'\'this\'\'.\'\'getSlideshowContainer\'\'(\'\')\'\')\'\';\'\'return\'\'items\'\';\'\'}\'\';\'\'/\'\'*\'\'*\'\'init\'\'(\'\')\'\'Initialize\'\'the\'\'slideshow\'\'.\'\'Performed\'\'after\'\'the\'\'DOM\'\'is\'\'ready\'\'.\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'init\'\'=\'\'function\'\'(\'\')\'\'{\'\'/\'\'/\'\'Add\'\'handlers\'\'to\'\'buttons\'\'if\'\'(\'\'this\'\'.\'\'playPauseButtonId\'\')\'\'{\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'this\'\'.\'\'playPauseButtonId\'\',\'\'\"\'\'click\'\'\"\'\',\'\'this\'\'.\'\'togglePlay\'\',\'\'this\'\',\'\'true\'\')\'\';\'\'}\'\'if\'\'(\'\'this\'\'.\'\'nextButtonId\'\')\'\'{\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'this\'\'.\'\'nextButtonId\'\',\'\'\"\'\'click\'\'\"\'\',\'\'this\'\'.\'\'next\'\',\'\'this\'\',\'\'true\'\')\'\';\'\'}\'\'if\'\'(\'\'this\'\'.\'\'previousButtonId\'\')\'\'{\'\'YAHOO\'\'.\'\'util\'\'.\'\'Event\'\'.\'\'addListener\'\'(\'\'this\'\'.\'\'previousButtonId\'\',\'\'\"\'\'click\'\'\"\'\',\'\'this\'\'.\'\'previous\'\',\'\'this\'\',\'\'true\'\')\'\';\'\'}\'\'/\'\'/\'\'Hide\'\'all\'\'but\'\'the\'\'currentIndex\'\'var\'\'items\'\'=\'\'this\'\'.\'\'getSlideshowItems\'\'(\'\')\'\';\'\'for\'\'(\'\'var\'\'i\'\'=\'\'0\'\';\'\'i\'\'<\'\'items\'\'.\'\'length\'\';\'\'i\'\'+\'\'+\'\')\'\'{\'\'if\'\'(\'\'i\'\'!\'\'=\'\'this\'\'.\'\'currentIndex\'\')\'\'{\'\'items[\'\'i\'\']\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'none\'\'\"\'\';\'\'}\'\'else\'\'{\'\'items[\'\'i\'\']\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'block\'\'\"\'\';\'\'}\'\'}\'\'/\'\'/\'\'Start\'\'it\'\'off\'\'if\'\'necessary\'\'if\'\'(\'\'this\'\'.\'\'isPlaying\'\')\'\'{\'\'this\'\'.\'\'setPlayTimeout\'\'(\'\')\'\';\'\'this\'\'.\'\'updatePlayPauseButton\'\'(\'\')\'\';\'\'}\'\'}\'\';\'\'/\'\'*\'\'*\'\'next\'\'(\'\')\'\'Pause\'\'the\'\'slideshow\'\'and\'\'go\'\'to\'\'the\'\'next\'\'slide\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'next\'\'=\'\'function\'\'(\'\')\'\'{\'\'this\'\'.\'\'pause\'\'(\'\')\'\';\'\'this\'\'.\'\'showNext\'\'(\'\')\'\';\'\'}\'\'/\'\'*\'\'*\'\'play\'\'(\'\')\'\'Start\'\'the\'\'slideshow\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'play\'\'=\'\'function\'\'(\'\')\'\'{\'\'if\'\'(\'\'!\'\'this\'\'.\'\'isPlaying\'\')\'\'{\'\'this\'\'.\'\'isPlaying\'\'=\'\'true\'\';\'\'this\'\'.\'\'setPlayTimeout\'\'(\'\')\'\';\'\'this\'\'.\'\'updatePlayPauseButton\'\'(\'\')\'\';\'\'}\'\'}\'\'/\'\'*\'\'*\'\'previous\'\'(\'\')\'\'Pause\'\'the\'\'slideshow\'\'and\'\'show\'\'the\'\'previous\'\'slide\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'previous\'\'=\'\'function\'\'(\'\')\'\'{\'\'this\'\'.\'\'pause\'\'(\'\')\'\';\'\'this\'\'.\'\'showPrevious\'\'(\'\')\'\';\'\'}\'\'/\'\'*\'\'*\'\'pause\'\'(\'\')\'\'Pause\'\'the\'\'slideshow\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'pause\'\'=\'\'function\'\'(\'\')\'\'{\'\'if\'\'(\'\'this\'\'.\'\'isPlaying\'\')\'\'{\'\'this\'\'.\'\'isPlaying\'\'=\'\'false\'\';\'\'this\'\'.\'\'clearPlayTimeout\'\'(\'\')\'\';\'\'this\'\'.\'\'updatePlayPauseButton\'\'(\'\')\'\';\'\'}\'\'}\'\'/\'\'*\'\'*\'\'setPlayTimeout\'\'(\'\')\'\'Sets\'\'the\'\'timeout\'\'to\'\'move\'\'to\'\'the\'\'next\'\'slide\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'setPlayTimeout\'\'=\'\'function\'\'(\'\')\'\'{\'\'var\'\'self\'\'=\'\'this\'\';\'\'this\'\'.\'\'playTimeout\'\'=\'\'setTimeout\'\'(\'\'function\'\'(\'\')\'\'{\'\'self\'\'.\'\'doPlayTick\'\'(\'\'self\'\')\'\'}\'\',\'\'this\'\'.\'\'playDelay\'\')\'\';\'\'}\'\'/\'\'*\'\'*\'\'showNext\'\'(\'\')\'\'Show\'\'the\'\'next\'\'slide\'\'.\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'showNext\'\'=\'\'function\'\'(\'\')\'\'{\'\'var\'\'items\'\'=\'\'this\'\'.\'\'getSlideshowItems\'\'(\'\')\'\';\'\'var\'\'hideIndex\'\'=\'\'this\'\'.\'\'currentIndex\'\';\'\'var\'\'showIndex\'\'=\'\'this\'\'.\'\'currentIndex\'\'+\'\'1\'\';\'\'/\'\'/\'\'Wrap\'\'around\'\'if\'\'(\'\'this\'\'.\'\'wrap\'\'&\'\'&\'\'showIndex\'\'>\'\'=\'\'items\'\'.\'\'length\'\')\'\'{\'\'showIndex\'\'=\'\'0\'\';\'\'}\'\'/\'\'/\'\'Don\'\'\'\'\'t\'\'allow\'\'going\'\'past\'\'the\'\'last\'\'item\'\'else\'\'if\'\'(\'\'showIndex\'\'>\'\'=\'\'items\'\'.\'\'length\'\')\'\'{\'\'return\'\';\'\'}\'\'/\'\'/\'\'Do\'\'the\'\'switch\'\'if\'\'(\'\'items[\'\'hideIndex\'\']\'\')\'\'items[\'\'hideIndex\'\']\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'none\'\'\"\'\';\'\'if\'\'(\'\'items[\'\'showIndex\'\']\'\')\'\'{\'\'items[\'\'showIndex\'\']\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'block\'\'\"\'\';\'\'this\'\'.\'\'currentIndex\'\'=\'\'showIndex\'\';\'\'}\'\'}\'\';\'\'/\'\'*\'\'*\'\'showPrevious\'\'(\'\')\'\'Show\'\'the\'\'previous\'\'slide\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'showPrevious\'\'=\'\'function\'\'(\'\')\'\'{\'\'var\'\'items\'\'=\'\'this\'\'.\'\'getSlideshowItems\'\'(\'\')\'\';\'\'var\'\'hideIndex\'\'=\'\'this\'\'.\'\'currentIndex\'\';\'\'var\'\'showIndex\'\'=\'\'this\'\'.\'\'currentIndex\'\'-\'\'1\'\';\'\'/\'\'/\'\'Wrap\'\'around\'\'if\'\'(\'\'this\'\'.\'\'wrap\'\'&\'\'&\'\'showIndex\'\'<\'\'0\'\')\'\'{\'\'showIndex\'\'=\'\'items\'\'.\'\'length\'\'-\'\'1\'\';\'\'}\'\'/\'\'/\'\'Don\'\'\'\'\'t\'\'allow\'\'going\'\'past\'\'the\'\'last\'\'item\'\'else\'\'if\'\'(\'\'showIndex\'\'<\'\'0\'\')\'\'{\'\'return\'\';\'\'}\'\'/\'\'/\'\'Do\'\'the\'\'switch\'\'items[\'\'hideIndex\'\']\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'none\'\'\"\'\';\'\'items[\'\'showIndex\'\']\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\"\'\'block\'\'\"\'\';\'\'this\'\'.\'\'currentIndex\'\'=\'\'showIndex\'\';\'\'}\'\';\'\'/\'\'*\'\'*\'\'togglePlay\'\'(\'\')\'\'If\'\'it\'\'\'\'\'s\'\'paused\'\',\'\'play\'\'it\'\'.\'\'If\'\'it\'\'\'\'\'s\'\'playing\'\',\'\'pause\'\'it\'\'.\'\'Return\'\'true\'\'if\'\'the\'\'slideshow\'\'is\'\'now\'\'playing\'\'.\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'togglePlay\'\'=\'\'function\'\'(\'\')\'\'{\'\'if\'\'(\'\'this\'\'.\'\'isPlaying\'\'=\'\'=\'\'false\'\')\'\'{\'\'this\'\'.\'\'play\'\'(\'\')\'\';\'\'return\'\'true\'\';\'\'}\'\'else\'\'{\'\'this\'\'.\'\'pause\'\'(\'\')\'\';\'\'}\'\'}\'\';\'\'/\'\'*\'\'*\'\'updatePlayPauseButton\'\'(\'\')\'\'Update\'\'the\'\'Play\'\'/\'\'Pause\'\'button\'\'to\'\'have\'\'the\'\'correct\'\'image\'\'*\'\'/\'\'WebGUI\'\'.\'\'Slideshow\'\'.\'\'prototype\'\'.\'\'updatePlayPauseButton\'\'=\'\'function\'\'(\'\')\'\'{\'\'if\'\'(\'\'this\'\'.\'\'playPauseButtonId\'\')\'\'{\'\'if\'\'(\'\'this\'\'.\'\'isPlaying\'\'&\'\'&\'\'this\'\'.\'\'playImageSrc\'\')\'\'{\'\'document\'\'.\'\'getElementById\'\'(\'\'this\'\'.\'\'playPauseButtonId\'\')\'\'.\'\'src\'\'=\'\'this\'\'.\'\'pauseImageSrc\'\';\'\'}\'\'else\'\'if\'\'(\'\'this\'\'.\'\'pauseImageSrc\'\')\'\'{\'\'document\'\'.\'\'getElementById\'\'(\'\'this\'\'.\'\'playPauseButtonId\'\')\'\'.\'\'src\'\'=\'\'this\'\'.\'\'playImageSrc\'\';\'\'}\'\'}\'\'}\'\';','000001000001000013000023'),('3qiVYhNTXMVC5hfsumVHgg','browserdetect.js','browserdetect.js browserdetect.js  root import gallery templates browserdetect.js ','root/import/gallery-templates/browserdetect.js',1206743306,1206743306,'3','7','3','WebGUI::Asset::Snippet',1,'browserdetect\'\'.\'\'js\'\'browserdetect\'\'.\'\'js\'\'root\'\'import\'\'gallery\'\'templates\'\'browserdetect\'\'.\'\'js var\'\'BrowserDetect\'\'=\'\'{\'\'init\'\':\'\'function\'\'(\'\')\'\'{\'\'this\'\'.\'\'browser\'\'=\'\'this\'\'.\'\'searchString\'\'(\'\'this\'\'.\'\'dataBrowser\'\')\'\'||\'\'\"\'\'An\'\'unknown\'\'browser\'\'\"\'\';\'\'this\'\'.\'\'version\'\'=\'\'this\'\'.\'\'searchVersion\'\'(\'\'navigator\'\'.\'\'userAgent\'\')\'\'||\'\'this\'\'.\'\'searchVersion\'\'(\'\'navigator\'\'.\'\'appVersion\'\')\'\'||\'\'\"\'\'an\'\'unknown\'\'version\'\'\"\'\';\'\'this\'\'.\'\'OS\'\'=\'\'this\'\'.\'\'searchString\'\'(\'\'this\'\'.\'\'dataOS\'\')\'\'||\'\'\"\'\'an\'\'unknown\'\'OS\'\'\"\'\';\'\'}\'\',\'\'searchString\'\':\'\'function\'\'(\'\'data\'\')\'\'{\'\'for\'\'(\'\'var\'\'i\'\'=\'\'0\'\';\'\'i','000001000001000013000024'),('usuxw9V3jN4d4pujRiEYxg','css03-ie.css','css03-ie.css css03-ie.css  style3 css03 ie.css ','style3/css03-ie.css',1209494150,1209494150,'3','7','12','WebGUI::Asset::Snippet',1,'css03\'\'-\'\'ie\'\'.\'\'css\'\'css03\'\'-\'\'ie\'\'.\'\'css\'\'style3\'\'css03\'\'ie\'\'.\'\'css #\'\'contentArea\'\'{\'\'height\'\':\'\'500px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'300px\'\';\'\'}','000001000001000047000023'),('POVcY79vIqAHR8OfGt36aw','pagination_button.jpg','pagination_button.jpg pagination_button.jpg  root import gallery templates images pagination button.jpg ','root/import/gallery-templates/images/pagination_button.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'pagination_button\'\'.\'\'jpg\'\'pagination_button\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'pagination\'\'button\'\'.\'\'jpg','000001000001000013000017000007'),('hIB-z34r8Xl-vYVYCkKr-w','bar-btn-r.jpg','bar-btn-r.jpg bar-btn-r.jpg  root import gallery templates images bar btn r.jpg ','root/import/gallery-templates/images/bar-btn-r.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'bar\'\'-\'\'btn\'\'-\'\'r\'\'.\'\'jpg\'\'bar\'\'-\'\'btn\'\'-\'\'r\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'bar\'\'btn\'\'r\'\'.\'\'jpg','000001000001000013000017000008'),('-mPUoFlYcjqjPUPRLAlxNQ','search-field-r.jpg','search-field-r.jpg search-field-r.jpg  root import gallery templates images search field r.jpg ','root/import/gallery-templates/images/search-field-r.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'search\'\'-\'\'field\'\'-\'\'r\'\'.\'\'jpg\'\'search\'\'-\'\'field\'\'-\'\'r\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'search\'\'field\'\'r\'\'.\'\'jpg','000001000001000013000017000009'),('MDpUOR-N8KMyt1J7Hh_h4w','bar-btn.jpg','bar-btn.jpg bar-btn.jpg  root import gallery templates images bar btn.jpg ','root/import/gallery-templates/images/bar-btn.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'bar\'\'-\'\'btn\'\'.\'\'jpg\'\'bar\'\'-\'\'btn\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'bar\'\'btn\'\'.\'\'jpg','000001000001000013000017000010'),('YfXKByTwDZVituMc4h13Dg','pagination_bg.jpg','pagination_bg.jpg pagination_bg.jpg  root import gallery templates images pagination bg.jpg ','root/import/gallery-templates/images/pagination_bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'pagination_bg\'\'.\'\'jpg\'\'pagination_bg\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'pagination\'\'bg\'\'.\'\'jpg','000001000001000013000017000011'),('esko_HSU0Gh-uJZ1h3xRmQ','search-field-l.jpg','search-field-l.jpg search-field-l.jpg  root import gallery templates images search field l.jpg ','root/import/gallery-templates/images/search-field-l.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'search\'\'-\'\'field\'\'-\'\'l\'\'.\'\'jpg\'\'search\'\'-\'\'field\'\'-\'\'l\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'search\'\'field\'\'l\'\'.\'\'jpg','000001000001000013000017000012'),('oSqpGswzpBG_ErdfYwIO8A','top_bg.jpg','top_bg.jpg top_bg.jpg  root import gallery templates images top bg.jpg ','root/import/gallery-templates/images/top_bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'top_bg\'\'.\'\'jpg\'\'top_bg\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'top\'\'bg\'\'.\'\'jpg','000001000001000013000017000013'),('MXJklShZvLLB_DSnZQmXrQ','title_bg.jpg','title_bg.jpg title_bg.jpg  root import gallery templates images title bg.jpg ','root/import/gallery-templates/images/title_bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'title_bg\'\'.\'\'jpg\'\'title_bg\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'title\'\'bg\'\'.\'\'jpg','000001000001000013000017000014'),('BthxD5oJ0idmsyI3ioA2FA','bar-btn-l.jpg','bar-btn-l.jpg bar-btn-l.jpg  root import gallery templates images bar btn l.jpg ','root/import/gallery-templates/images/bar-btn-l.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'bar\'\'-\'\'btn\'\'-\'\'l\'\'.\'\'jpg\'\'bar\'\'-\'\'btn\'\'-\'\'l\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'bar\'\'btn\'\'l\'\'.\'\'jpg','000001000001000013000017000015'),('aZ-1HYQamkRHYXvzAra8WQ','search-field.jpg','search-field.jpg search-field.jpg  root import gallery templates images search field.jpg ','root/import/gallery-templates/images/search-field.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'search\'\'-\'\'field\'\'.\'\'jpg\'\'search\'\'-\'\'field\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'search\'\'field\'\'.\'\'jpg','000001000001000013000017000016'),('eRkb94OYcS5AdcrrerOP5Q','rss.gif','rss.gif rss.gif  root import gallery templates images rss2.gif ','root/import/gallery-templates/images/rss2.gif',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'rss\'\'.\'\'gif\'\'rss\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'rss2\'\'.\'\'gif','000001000001000013000017000017'),('TbnkjAJQEASORXIpYqDkcA','blank-image.jpg','blank-image.jpg blank-image.jpg  root import gallery templates images blank image.jpg ','root/import/gallery-templates/images/blank-image.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'blank\'\'-\'\'image\'\'.\'\'jpg\'\'blank\'\'-\'\'image\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'blank\'\'image\'\'.\'\'jpg','000001000001000013000017000018'),('er-3faBjY-hhlDcc5aKqdQ','top_bg.jpg','top_bg.jpg top_bg.jpg  root import gallery templates images top bg2.jpg ','root/import/gallery-templates/images/top_bg2.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'top_bg\'\'.\'\'jpg\'\'top_bg\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'top\'\'bg2\'\'.\'\'jpg','000001000001000013000017000019'),('8bFsu2FJUqHRUiHcozcVFw','sub-btn-l.jpg','sub-btn-l.jpg sub-btn-l.jpg  root import gallery templates images sub btn l.jpg ','root/import/gallery-templates/images/sub-btn-l.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'sub\'\'-\'\'btn\'\'-\'\'l\'\'.\'\'jpg\'\'sub\'\'-\'\'btn\'\'-\'\'l\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'sub\'\'btn\'\'l\'\'.\'\'jpg','000001000001000013000017000020'),('34Aayx5eA320D8VfhdfDBw','sub-btn-r.jpg','sub-btn-r.jpg sub-btn-r.jpg  root import gallery templates images sub btn r.jpg ','root/import/gallery-templates/images/sub-btn-r.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'sub\'\'-\'\'btn\'\'-\'\'r\'\'.\'\'jpg\'\'sub\'\'-\'\'btn\'\'-\'\'r\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'sub\'\'btn\'\'r\'\'.\'\'jpg','000001000001000013000017000021'),('TlhKOVmWblZOsAdqmhEpeg','sub-btn.jpg','sub-btn.jpg sub-btn.jpg  root import gallery templates images sub btn.jpg ','root/import/gallery-templates/images/sub-btn.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'sub\'\'-\'\'btn\'\'.\'\'jpg\'\'sub\'\'-\'\'btn\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'sub\'\'btn\'\'.\'\'jpg','000001000001000013000017000022'),('Nx0ypjO3cN6QdZUBUEE0lA','pic-title-bg.jpg','pic-title-bg.jpg pic-title-bg.jpg  root import gallery templates images pic title bg.jpg ','root/import/gallery-templates/images/pic-title-bg.jpg',1209499189,1209499189,'3','7','12','WebGUI::Asset::File::Image',1,'pic\'\'-\'\'title\'\'-\'\'bg\'\'.\'\'jpg\'\'pic\'\'-\'\'title\'\'-\'\'bg\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'pic\'\'title\'\'bg\'\'.\'\'jpg','000001000001000013000017000023'),('CmFZLN7iPS7XXvUEsxKPKA','row-2.jpg','row-2.jpg row-2.jpg  root import gallery templates images row 2.jpg ','root/import/gallery-templates/images/row-2.jpg',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'row\'\'-\'\'2\'\'.\'\'jpg\'\'row\'\'-\'\'2\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'row\'\'2\'\'.\'\'jpg','000001000001000013000017000024'),('v_XBgwwZqgW1D5s4y05qfg','addtl-info.gif','addtl-info.gif addtl-info.gif  root import gallery templates images addtl info.gif ','root/import/gallery-templates/images/addtl-info.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'addtl\'\'-\'\'info\'\'.\'\'gif\'\'addtl\'\'-\'\'info\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'addtl\'\'info\'\'.\'\'gif','000001000001000013000017000025'),('4TdAkKoQbSCvI7QWcW889A','row-1.jpg','row-1.jpg row-1.jpg  root import gallery templates images row 1.jpg ','root/import/gallery-templates/images/row-1.jpg',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'row\'\'-\'\'1\'\'.\'\'jpg\'\'row\'\'-\'\'1\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'row\'\'1\'\'.\'\'jpg','000001000001000013000017000026'),('SAgK6eDPCG1cgkJ59WapHQ','prev-btn.gif','prev-btn.gif prev-btn.gif  root import gallery templates images prev btn.gif ','root/import/gallery-templates/images/prev-btn.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'prev\'\'-\'\'btn\'\'.\'\'gif\'\'prev\'\'-\'\'btn\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'prev\'\'btn\'\'.\'\'gif','000001000001000013000017000027'),('XJYLuvGy9ubF7JNKyINtpA','play-btn.gif','play-btn.gif play-btn.gif  root import gallery templates images play btn.gif ','root/import/gallery-templates/images/play-btn.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'play\'\'-\'\'btn\'\'.\'\'gif\'\'play\'\'-\'\'btn\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'play\'\'btn\'\'.\'\'gif','000001000001000013000017000028'),('RWj7hyv2SpZuXxwj1Wocug','next-btn.gif','next-btn.gif next-btn.gif  root import gallery templates images next btn.gif ','root/import/gallery-templates/images/next-btn.gif',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'next\'\'-\'\'btn\'\'.\'\'gif\'\'next\'\'-\'\'btn\'\'.\'\'gif\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'next\'\'btn\'\'.\'\'gif','000001000001000013000017000029'),('aq8QElnlm3YufAoxRz9Pcg','data-bg.jpg','data-bg.jpg data-bg.jpg  root import gallery templates images data bg.jpg ','root/import/gallery-templates/images/data-bg.jpg',1209499190,1209499190,'3','7','12','WebGUI::Asset::File::Image',1,'data\'\'-\'\'bg\'\'.\'\'jpg\'\'data\'\'-\'\'bg\'\'.\'\'jpg\'\'root\'\'import\'\'gallery\'\'templates\'\'images\'\'data\'\'bg\'\'.\'\'jpg','000001000001000013000017000030'),('6D4Z-oruXPS6OlH_Kx8pBg','images','images images  root import thingy templates images ','root/import/thingy-templates/images',1209509389,1209509389,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images\'\'images\'\'root\'\'import\'\'thingy\'\'templates\'\'images','000001000001000041000005'),('hQ7z33_jOYkQ8WNX5xy9Sw','style-button.gif','style-button.gif style-button.gif  root import thingy templates images style button.gif ','root/import/thingy-templates/images/style-button.gif',1209509455,1209509455,'3','7','12','WebGUI::Asset::File::Image',1,'style\'\'-\'\'button\'\'.\'\'gif\'\'style\'\'-\'\'button\'\'.\'\'gif\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'style\'\'button\'\'.\'\'gif','000001000001000041000005000001'),('vWW_DcHiYSrKZOkkIfEfcQ','row-2.jpg','row-2.jpg row-2.jpg  root import thingy templates images row 2.jpg ','root/import/thingy-templates/images/row-2.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'row\'\'-\'\'2\'\'.\'\'jpg\'\'row\'\'-\'\'2\'\'.\'\'jpg\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'row\'\'2\'\'.\'\'jpg','000001000001000041000005000002'),('_bPYzRA87NTAUIKlfrJMHg','row-1.jpg','row-1.jpg row-1.jpg  root import thingy templates images row 1.jpg ','root/import/thingy-templates/images/row-1.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'row\'\'-\'\'1\'\'.\'\'jpg\'\'row\'\'-\'\'1\'\'.\'\'jpg\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'row\'\'1\'\'.\'\'jpg','000001000001000041000005000003'),('nJjZHRwdDs5MAZYsAyioHw','title-bg.jpg','title-bg.jpg title-bg.jpg  root import thingy templates images title bg.jpg ','root/import/thingy-templates/images/title-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'title\'\'-\'\'bg\'\'.\'\'jpg\'\'title\'\'-\'\'bg\'\'.\'\'jpg\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'title\'\'bg\'\'.\'\'jpg','000001000001000041000005000004'),('8hxfkrJPeFVRWF5piCNJ1A','field-bg.jpg','field-bg.jpg field-bg.jpg  root import thingy templates images field bg.jpg ','root/import/thingy-templates/images/field-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'field\'\'-\'\'bg\'\'.\'\'jpg\'\'field\'\'-\'\'bg\'\'.\'\'jpg\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'field\'\'bg\'\'.\'\'jpg','000001000001000041000005000005'),('Osx7WN52iIKHZFT4vqUBHQ','search-btn.gif','search-btn.gif search-btn.gif  root import thingy templates images search btn.gif ','root/import/thingy-templates/images/search-btn.gif',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'search\'\'-\'\'btn\'\'.\'\'gif\'\'search\'\'-\'\'btn\'\'.\'\'gif\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'search\'\'btn\'\'.\'\'gif','000001000001000041000005000006'),('oWff8fGzRdHPyq5VNREe9Q','top-bg.jpg','top-bg.jpg top-bg.jpg  root import thingy templates images top bg.jpg ','root/import/thingy-templates/images/top-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'top\'\'-\'\'bg\'\'.\'\'jpg\'\'top\'\'-\'\'bg\'\'.\'\'jpg\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'top\'\'bg\'\'.\'\'jpg','000001000001000041000005000007'),('uqbkvb1b9443VvfkyRz95w','save-button.gif','save-button.gif save-button.gif  root import thingy templates images save button.gif ','root/import/thingy-templates/images/save-button.gif',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'save\'\'-\'\'button\'\'.\'\'gif\'\'save\'\'-\'\'button\'\'.\'\'gif\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'save\'\'button\'\'.\'\'gif','000001000001000041000005000008'),('8YiMkcz32xalkAn3WBLpag','go-btn.gif','go-btn.gif go-btn.gif  root import thingy templates images go btn.gif ','root/import/thingy-templates/images/go-btn.gif',1210181860,1210181860,'3','7','12','WebGUI::Asset::File::Image',1,'go\'\'-\'\'btn\'\'.\'\'gif\'\'go\'\'-\'\'btn\'\'.\'\'gif\'\'root\'\'import\'\'thingy\'\'templates\'\'images\'\'go\'\'btn\'\'.\'\'gif','000001000001000041000005000009'),('3n3H85BsdeRQ0I08WmvlOg','thingy.css','thingy.css thingy.css  root import thingy templates thingy.css ','root/import/thingy-templates/thingy.css',1212091492,1216227244,'3','7','12','WebGUI::Asset::Snippet',1,'thingy\'\'.\'\'css\'\'thingy\'\'.\'\'css\'\'root\'\'import\'\'thingy\'\'templates\'\'thingy\'\'.\'\'css .\'\'wgThingy\'\'{\'\'margin\'\':\'\'5px\'\';\'\'}\'\'.\'\'wgThingy\'\'*\'\'.\'\'styleButton\'\'{\'\'color\'\':\'\'black\'\';\'\'margin\'\':\'\'0px\'\'5px\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgThingy\'\'*\'\'.\'\'spacerOne\'\'{\'\'padding\'\'-\'\'left\'\':\'\'15px\'\';\'\'}\'\'.\'\'wgThingy\'\'*\'\'.\'\'rowOne\'\',\'\'.\'\'wgThingy\'\'*\'\'tr\'\'.\'\'rowOne\'\'td\'\'{\'\'background\'\':\'\'#\'\'EEEEEE\'\';\'\'margin\'\':\'\'1px\'\';\'\'border\'\':\'\'solid\'\'#\'\'CDCDCD\'\'1px\'\';\'\'color\'\':\'\'#\'\'000\'\';\'\'padding\'\':\'\'2px\'\';\'\'}\'\'.\'\'wgThingy\'\'*\'\'.\'\'rowTwo\'\',\'\'.\'\'wgThingy\'\'*\'\'tr\'\'.\'\'rowTwo\'\'td\'\'{\'\'background\'\':\'\'#\'\'DBDBDB\'\';\'\'margin\'\':\'\'1px\'\';\'\'border\'\':\'\'solid\'\'#\'\'DDDDDD\'\'1px\'\';\'\'color\'\':\'\'#\'\'000\'\';\'\'padding\'\':\'\'2px\'\';\'\'}\'\'.\'\'wgThingsWrapper\'\'img\'\'{\'\'display\'\':\'\'block\'\';\'\'vertical\'\'-\'\'align\'\':\'\'center\'\';\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgThingsWrapper\'\'.\'\'label\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\'-\'\'left\'\':\'\'15px\'\';\'\'}\'\'.\'\'wgThingy\'\'h2\'\'.\'\'title\'\'{\'\'background\'\':\'\'#\'\'000\'\';\'\'height\'\':\'\'42px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'18px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'1px\'\';\'\'line\'\'-\'\'height\'\':\'\'42px\'\';\'\'padding\'\'-\'\'left\'\':\'\'15px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'}\'\'.\'\'wgThingy\'\'*\'\'span\'\'.\'\'smaller\'\'{\'\'font\'\'-\'\'size\'\':\'\'13px\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'.\'\'wgThingy\'\'.\'\'controls\'\'{\'\'line\'\'-\'\'height\'\':\'\'35px\'\';\'\'height\'\':\'\'35px\'\';\'\'background\'\':\'\'#\'\'f1f1f1\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'padding\'\':\'\'0px\'\';\'\'}\'\'.\'\'wgThingy\'\'*\'\'.\'\'label\'\'{\'\'background\'\':\'\'black\'\';\'\'color\'\':\'\'white\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'vertical\'\'-\'\'align\'\':\'\'middle\'\';\'\'}\'\'.\'\'wgThingy\'\'.\'\'label\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'}\'\'.\'\'searchTable\'\'*\'\'input\'\',\'\'.\'\'editThing\'\'*\'\'input\'\'{\'\'background\'\':\'\'white\'\';\'\'border\'\':\'\'solid\'\'#\'\'555\'\'1px\'\';\'\'}\'\'.\'\'editThing\'\'{\'\'margin\'\'-\'\'top\'\':\'\'15px\'\';\'\'}\'\'#\'\'thingyList\'\',\'\'#\'\'thingyList\'\'*\'\'{\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'}\'\'#\'\'thingyList\'\'{\'\'position\'\':\'\'relative\'\';\'\'float\'\':\'\'left\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'goButton\'\':\'\'link\'\',\'\'#\'\'thingyList\'\'.\'\'goButton\'\':\'\'visited\'\'{\'\'padding\'\':\'\'2px\'\'25px\'\'2px\'\'2px\'\';\'\'background\'\':\'\'#\'\'F1F1F1\'\'url\'\'(\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'root\'\'/\'\'import\'\'/\'\'thingy\'\'-\'\'templates\'\'/\'\'images\'\'/\'\'go\'\'-\'\'btn\'\'.\'\'gif\'\')\'\';\'\')\'\'no\'\'-\'\'repeat\'\'right\'\';\'\'line\'\'-\'\'height\'\':\'\'20px\'\';\'\'border\'\':\'\'solid\'\'#\'\'a2a2a2\'\'1px\'\';\'\'color\'\':\'\'#\'\'a2a2a2\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\',\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'margin\'\'-\'\'left\'\':\'\'20px\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'0px\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'goButton\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'things\'\'{\'\'padding\'\':\'\'0px\'\';\'\'margin\'\':\'\'0px\'\';\'\'width\'\':\'\'300px\'\';\'\'z\'\'-\'\'index\'\':\'\'5000\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'27px\'\';\'\'left\'\':\'\'20px\'\';\'\'border\'\':\'\'solid\'\'#\'\'a2a2a2\'\'1px\'\';\'\'border\'\'-\'\'top\'\'-\'\'style\'\':\'\'none\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'things\'\'a\'\':\'\'link\'\',\'\'#\'\'thingyList\'\'.\'\'things\'\'a\'\':\'\'visited\'\'{\'\'display\'\':\'\'block\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'a2a2a2\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'727272\'\'1px\'\';\'\'line\'\'-\'\'height\'\':\'\'12px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'height\'\':\'\'12px\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'color\'\':\'\'#\'\'a2a2a2\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'things\'\'a\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'}','000001000001000041000006'),('5m5I7__l40C4hhv4ydqAHQ','thingy-ie.css','thingy-ie.css thingy-ie.css  root import thingy templates thingy ie.css ','root/import/thingy-templates/thingy-ie.css',1210181698,1216227786,'3','7','12','WebGUI::Asset::Snippet',1,'thingy\'\'-\'\'ie\'\'.\'\'css\'\'thingy\'\'-\'\'ie\'\'.\'\'css\'\'root\'\'import\'\'thingy\'\'templates\'\'thingy\'\'ie\'\'.\'\'css #\'\'thingyList\'\'.\'\'things\'\'{\'\'padding\'\':\'\'0px\'\';\'\'margin\'\':\'\'0px\'\';\'\'width\'\':\'\'200px\'\';\'\'z\'\'-\'\'index\'\':\'\'5000\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'27px\'\';\'\'left\'\':\'\'20px\'\';\'\'border\'\':\'\'solid\'\'#\'\'a2a2a2\'\'1px\'\';\'\'border\'\'-\'\'top\'\'-\'\'style\'\':\'\'none\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'things\'\'a\'\':\'\'link\'\',\'\'#\'\'thingyList\'\'.\'\'things\'\'a\'\':\'\'visited\'\'{\'\'display\'\':\'\'block\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'a2a2a2\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'727272\'\'1px\'\';\'\'line\'\'-\'\'height\'\':\'\'12px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'height\'\':\'\'12px\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'color\'\':\'\'#\'\'a2a2a2\'\';\'\'width\'\':\'\'190px\'\';\'\'}\'\'#\'\'thingyList\'\'.\'\'things\'\'a\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'}','000001000001000041000007'),('4qh0kIsFUdd4Ox-Iu1JZgg','EMS','  ','root/import/ems',1208725439,1208725439,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EMS\'\'EMS\'\'root\'\'import\'\'ems','000001000001000010'),('2rC4ErZ3c77OJzJm7O5s3w','EMS Badge Listing (default)','EMS Badge Listing (default) EMS Badge Listing (default)  root import ems ems badge listing default ','root/import/ems/ems-badge-listing-default',1208721232,1224723218,'3','7','12','WebGUI::Asset::Template',1,'EMS\'\'Badge\'\'Listing\'\'(\'\'default\'\')\'\'EMS\'\'Badge\'\'Listing\'\'(\'\'default\'\')\'\'root\'\'import\'\'ems\'\'ems\'\'badge\'\'listing\'\'default EMS','000001000001000010000003'),('PsFn7dJt4wMwBa8hiE3hOA','Print Badge (Default)','Print Badge (Default) Print Badge (Default)  root import ems print badge default ','root/import/ems/print-badge-default',1208558071,1208558071,'3','7','12','WebGUI::Asset::Template',1,'Print\'\'Badge\'\'(\'\'Default\'\')\'\'Print\'\'Badge\'\'(\'\'Default\'\')\'\'root\'\'import\'\'ems\'\'print\'\'badge\'\'default EMS\'\'/\'\'PrintBadge','000001000001000010000004'),('yBwydfooiLvhEFawJb0VTQ','Print Ticket (Default)','Print Ticket (Default) Print Ticket (Default)  root import ems print ticket default ','root/import/ems/print-ticket-default',1208629936,1208629936,'3','7','12','WebGUI::Asset::Template',1,'Print\'\'Ticket\'\'(\'\'Default\'\')\'\'Print\'\'Ticket\'\'(\'\'Default\'\')\'\'root\'\'import\'\'ems\'\'print\'\'ticket\'\'default EMS\'\'/\'\'PrintTicket','000001000001000010000005'),('63ix2-hU0FchXGIWkG3tow','Flat Discount (Default)','Flat Discount (Default) Flat Discount (Default)  root import flat discount default ','root/import/flat-discount-default',1209588387,1216169693,'3','7','12','WebGUI::Asset::Template',1,'Flat\'\'Discount\'\'(\'\'Default\'\')\'\'Flat\'\'Discount\'\'(\'\'Default\'\')\'\'root\'\'import\'\'flat\'\'discount\'\'default FlatDiscount','000001000001000034000011'),('gbnRhcWNk1iQe32LFEB5eQ','Shelf','Shelf Shelf  root import shelf2 ','root/import/shelf2',1210779723,1212086102,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shelf\'\'Shelf\'\'root\'\'import\'\'shelf2','000001000001000033'),('1XOJDcg_ITRYwVM-QnIcPw','shelf.css','shelf.css shelf.css  root import shelf2 shelf.css ','root/import/shelf2/shelf.css',1210779441,1219175575,'3','7','12','WebGUI::Asset::Snippet',1,'shelf\'\'.\'\'css\'\'shelf\'\'.\'\'css\'\'root\'\'import\'\'shelf2\'\'shelf\'\'.\'\'css .\'\'wgShelf\'\'{\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\',\'\'verdana\'\';\'\'margin\'\':\'\'15px\'\'0px\'\';\'\'}\'\'.\'\'wgShelf\'\'h2\'\'{\'\'background\'\':\'\'black\'\';\'\'padding\'\':\'\'5px\'\';\'\'padding\'\'-\'\'left\'\':\'\'15px\'\';\'\'line\'\'-\'\'height\'\':\'\'32px\'\';\'\'color\'\':\'\'white\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'32px\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'wgShelves\'\'{\'\'background\'\':\'\'#\'\'F1F1F1\'\';\'\'height\'\':\'\'29px\'\';\'\'padding\'\':\'\'3px\'\';\'\'line\'\'-\'\'height\'\':\'\'29px\'\';\'\'padding\'\'-\'\'left\'\':\'\'30px\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'{\'\'margin\'\':\'\'15px\'\';\'\'margin\'\'-\'\'left\'\':\'\'0px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\':\'\'solid\'\'#\'\'e1e1e1\'\'1px\'\';\'\'width\'\':\'\'200px\'\';\'\'display\'\':\'\'-\'\'moz\'\'-\'\'inline\'\'-\'\'box\'\';\'\'/\'\'*\'\'Moz\'\'*\'\'/\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'/\'\'*\'\'Op\'\',\'\'Saf\'\',\'\'IE\'\'\\\'\'*\'\'/\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'/\'\'*\'\'IE\'\'Mac\'\'non\'\'capisce\'\'e\'\'a\'\'volte\'\'crea\'\'extra\'\'v\'\'space\'\'*\'\'/\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'thumbnail\'\'{\'\'display\'\':\'\'block\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'margin\'\':\'\'3px\'\';\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'link\'\'{\'\'background\'\':\'\'#\'\'e1e1e1\'\';\'\'height\'\':\'\'30px\'\';\'\'padding\'\':\'\'3px\'\';\'\'line\'\'-\'\'height\'\':\'\'24px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'link\'\'a\'\':\'\'link\'\',\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'link\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'#\'\'000\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'link\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'underline\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'price\'\'{\'\'display\'\':\'\'block\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'font\'\'-\'\'size\'\':\'\'18px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}','000001000001000033000003'),('C5fPz-Wg85vkYRvCdl-Xqw','UserList','UserList UserList  root import userlist ','root/import/userlist',1212160830,1212160830,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'UserList\'\'UserList\'\'root\'\'import\'\'userlist','000001000001000043'),('aNmgn0cd6tldmC1FpW4KbA','Shop','Shop Shop  shopping cart collateral items ','shopping-cart-collateral-items',1213122695,1213122695,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Shop\'\'Shop\'\'shopping\'\'cart\'\'collateral\'\'items','000001000001000034'),('2q5fxatSFLgIhXaUX-oSvg','bottom-left.jpg','bottom-left.jpg bottom-left.jpg  shopping cart collateral items bottom left.jpg ','shopping-cart-collateral-items/bottom-left.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'bottom\'\'-\'\'left\'\'.\'\'jpg\'\'bottom\'\'-\'\'left\'\'.\'\'jpg\'\'shopping\'\'cart\'\'collateral\'\'items\'\'bottom\'\'left\'\'.\'\'jpg','000001000001000034000001'),('_d5WTkKjnwct-_Dk7gZHvQ','bottom-right.jpg','bottom-right.jpg bottom-right.jpg  shopping cart collateral items bottom right.jpg ','shopping-cart-collateral-items/bottom-right.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'bottom\'\'-\'\'right\'\'.\'\'jpg\'\'bottom\'\'-\'\'right\'\'.\'\'jpg\'\'shopping\'\'cart\'\'collateral\'\'items\'\'bottom\'\'right\'\'.\'\'jpg','000001000001000034000002'),('Iz2mUR3jCPKyemwAea4b2g','input_bg.jpg','input_bg.jpg input_bg.jpg  shopping cart collateral items input bg.jpg ','shopping-cart-collateral-items/input_bg.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'input_bg\'\'.\'\'jpg\'\'input_bg\'\'.\'\'jpg\'\'shopping\'\'cart\'\'collateral\'\'items\'\'input\'\'bg\'\'.\'\'jpg','000001000001000034000003'),('JU9bjsLRoWj7GVHs__prig','top-left.jpg','top-left.jpg top-left.jpg  shopping cart collateral items top left.jpg ','shopping-cart-collateral-items/top-left.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'top\'\'-\'\'left\'\'.\'\'jpg\'\'top\'\'-\'\'left\'\'.\'\'jpg\'\'shopping\'\'cart\'\'collateral\'\'items\'\'top\'\'left\'\'.\'\'jpg','000001000001000034000004'),('noOlnjQGexHg8c4bGVUo9g','top-right.jpg','top-right.jpg top-right.jpg  shopping cart collateral items top right.jpg ','shopping-cart-collateral-items/top-right.jpg',1204149033,1204149033,'3','7','3','WebGUI::Asset::File::Image',1,'top\'\'-\'\'right\'\'.\'\'jpg\'\'top\'\'-\'\'right\'\'.\'\'jpg\'\'shopping\'\'cart\'\'collateral\'\'items\'\'top\'\'right\'\'.\'\'jpg','000001000001000034000005'),('aIpCmr9Hi__vgdZnDTz1jw','Cart (Default)','Cart (Default) Cart (Default)  default shopping cart template ','default-shopping-cart-template',1209921197,1227539574,'3','7','3','WebGUI::Asset::Template',1,'Cart\'\'(\'\'Default\'\')\'\'Cart\'\'(\'\'Default\'\')\'\'default\'\'shopping\'\'cart\'\'template Shop\'\'/\'\'Cart','000001000001000034000006'),('4e-_rNs6mSWedZhQ_V5kJA','shelf-ie.css','shelf-ie.css shelf-ie.css  root import shelf2 shelf ie.css ','root/import/shelf2/shelf-ie.css',1210779672,1210779672,'3','7','12','WebGUI::Asset::Snippet',1,'shelf\'\'-\'\'ie\'\'.\'\'css\'\'shelf\'\'-\'\'ie\'\'.\'\'css\'\'root\'\'import\'\'shelf2\'\'shelf\'\'ie\'\'.\'\'css .\'\'wgShelf\'\'.\'\'product\'\'{\'\'margin\'\':\'\'15px\'\';\'\'margin\'\'-\'\'left\'\':\'\'0px\'\';\'\'float\'\':\'\'left\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\':\'\'solid\'\'#\'\'e1e1e1\'\'1px\'\';\'\'min\'\'-\'\'height\'\':\'\'100px\'\';\'\'min\'\'-\'\'width\'\':\'\'200px\'\';\'\'width\'\':\'\'200px\'\';\'\'height\'\':\'\'100px\'\';\'\'}\'\'.\'\'wgShelf\'\'.\'\'product\'\'.\'\'link\'\'{\'\'background\'\':\'\'url\'\'(\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'root\'\'/\'\'import\'\'/\'\'shelf2\'\'/\'\'images\'\'/\'\'shelf\'\'-\'\'titles\'\'.\'\'jpg\'\')\'\';\'\')\'\'no\'\'-\'\'repeat\'\'top\'\'right\'\';\'\'height\'\':\'\'30px\'\';\'\'padding\'\':\'\'3px\'\';\'\'line\'\'-\'\'height\'\':\'\'24px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'display\'\':\'\'block\'\';\'\'}','000001000001000033000004'),('2gtFt7c0qAFNU3BG_uvNvg','My Purchases (Default)','My Purchases (Default) My Purchases (Default)  shopping cart collateral items my purchases default ','shopping-cart-collateral-items/my-purchases-default',1211824430,1222574694,'3','7','3','WebGUI::Asset::Template',1,'My\'\'Purchases\'\'(\'\'Default\'\')\'\'My\'\'Purchases\'\'(\'\'Default\'\')\'\'shopping\'\'cart\'\'collateral\'\'items\'\'my\'\'purchases\'\'default Shop\'\'/\'\'MyPurchases','000001000001000034000008'),('bPz1yk6Y9uwMDMBcmMsSCg','Email Receipt (Default)','Email Receipt (Default) Email Receipt (Default)  shopping cart collateral items email receipt default ','shopping-cart-collateral-items/email-receipt-default',1211829604,1211829604,'3','7','3','WebGUI::Asset::Template',1,'Email\'\'Receipt\'\'(\'\'Default\'\')\'\'Email\'\'Receipt\'\'(\'\'Default\'\')\'\'shopping\'\'cart\'\'collateral\'\'items\'\'email\'\'receipt\'\'default Shop\'\'/\'\'EmailReceipt','000001000001000034000009'),('EBlxJpZQ9o-8VBOaGQbChA','MiniCart','MiniCart MiniCart  shopping cart collateral items minicart ','shopping-cart-collateral-items/minicart',1212093746,1212093746,'3','7','3','WebGUI::Asset::Template',1,'MiniCart\'\'MiniCart\'\'shopping\'\'cart\'\'collateral\'\'items\'\'minicart Shop\'\'/\'\'MiniCart','000001000001000034000014'),('PBtmpl0000000000000053','Subscription code redemption','Subscription code redemption Subscription code redemption  subscription code redemption ','subscription_code_redemption',1124395696,1154535074,'3','7','12','WebGUI::Asset::Template',1,'Subscription\'\'code\'\'redemption\'\'Subscription\'\'code\'\'redemption\'\'subscription\'\'code\'\'redemption Operation\'\'/\'\'RedeemSubscription','000001000001000034000017'),('6tK47xsaIH-ELw0IBo0uRQ','images','images images  root import shelf2 images ','root/import/shelf2/images',1210777115,1210777115,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images\'\'images\'\'root\'\'import\'\'shelf2\'\'images','000001000001000033000001'),('XNd7a_g_cTvJVYrVHcx2Mw','Address (Default)','Address (Default) Address (Default)  shopping cart collateral items address default ','shopping-cart-collateral-items/address-default',1212099009,1224606020,'3','7','3','WebGUI::Asset::Template',1,'Address\'\'(\'\'Default\'\')\'\'Address\'\'(\'\'Default\'\')\'\'shopping\'\'cart\'\'collateral\'\'items\'\'address\'\'default Shop\'\'/\'\'Address','000001000001000034000007'),('_bZJ9LA_KNekZiFPaP2SeQ','shelf-titles.jpg','shelf-titles.jpg shelf-titles.jpg  root import shelf2 images shelf titles.jpg ','root/import/shelf2/images/shelf-titles.jpg',1210777868,1210777868,'3','7','12','WebGUI::Asset::File::Image',1,'shelf\'\'-\'\'titles\'\'.\'\'jpg\'\'shelf\'\'-\'\'titles\'\'.\'\'jpg\'\'root\'\'import\'\'shelf2\'\'images\'\'shelf\'\'titles\'\'.\'\'jpg','000001000001000033000001000001'),('nFen0xjkZn8WkpM93C9ceQ','Shelf (Default)','Shelf (Default) Shelf (Default)  root import shelf default ','root/import/shelf-default',1210779326,1229117831,'3','7','12','WebGUI::Asset::Template',1,'Shelf\'\'(\'\'Default\'\')\'\'Shelf\'\'(\'\'Default\'\')\'\'root\'\'import\'\'shelf\'\'default Shelf','000001000001000033000002'),('mTOiwwk3q4k9g5-XykXhPA','Documentation','With any large system, having the right documentation to get you started is mandatory. The good news is that WebGUI has abundant documentation. ','documentation',1215717999,1218149728,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Documentation\'\'Documentation\'\'documentation\'\'With\'\'any\'\'large\'\'system\'\',\'\'having\'\'the\'\'right\'\'documentation\'\'to\'\'get\'\'you\'\'started\'\'is\'\'mandatory\'\'.\'\'The\'\'good\'\'news\'\'is\'\'that\'\'WebGUI\'\'has\'\'abundant\'\'documentation\'\'.','000001000002000005'),('j_1qEqM6iLfQLiR6VKy0aA','Free Documentation','There are hundreds of pages of free documentation available for WebGUI, provided by both Plain Black and the community at large. The following list is by no means comprehensive, but it should get you started in the right direction. \n\n\n\nPrimer - A download','documentation/free-documentation',1215718151,1215718151,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Free\'\'Documentation\'\'Free\'\'Documentation\'\'documentation\'\'free\'\'documentation\'\'There\'\'are\'\'hundreds\'\'of\'\'pages\'\'of\'\'free\'\'documentation\'\'available\'\'for\'\'WebGUI\'\',\'\'provided\'\'by\'\'both\'\'Plain\'\'Black\'\'and\'\'the\'\'community\'\'at\'\'large\'\'.\'\'The\'\'following\'\'list\'\'is\'\'by\'\'no\'\'means\'\'comprehensive\'\',\'\'but\'\'it\'\'should\'\'get\'\'you\'\'started\'\'in\'\'the\'\'right\'\'direction\'\'.\'\'Primer\'\'-\'\'A\'\'downloadable\'\'PDF\'\'that\'\'shows\'\'you\'\'the\'\'basics\'\'of\'\'publishing\'\'content\'\'in\'\'WebGUI\'\'.\'\'Wiki\'\'-\'\'Hundreds\'\'of\'\'pages\'\'of\'\'WebGUI\'\'community\'\'contributed\'\'content\'\'featuring\'\'a\'\'variety\'\'of\'\'tutorials\'\'.\'\'Worldwide\'\'-\'\'A\'\'collection\'\'of\'\'WebGUI\'\'related\'\'web\'\'sites\'\'from\'\'all\'\'over\'\'the\'\'world\'\'that\'\'have\'\'documentation\'\'and\'\'other\'\'resources\'\'for\'\'WebGUI\'\'.\'\'API\'\'Docs\'\'-\'\'The\'\'documentation\'\'of\'\'all\'\'of\'\'the\'\'WebGUI\'\'source\'\'code\'\'.\'\'Template\'\'Help\'\'-\'\'The\'\'documentation\'\'of\'\'all\'\'of\'\'WebGUI\'\'\'\'\'s\'\'template\'\'variables\'\'.  ','000001000002000005000001'),('o_pq_e4vRyhMOKFzs61eag','book-covers.jpg','book-covers.jpg book-covers.jpg  documentation book covers.jpg ','documentation/book-covers.jpg',1215714957,1215714957,'3','7','3','WebGUI::Asset::File::Image',1,'book\'\'-\'\'covers\'\'.\'\'jpg\'\'book\'\'-\'\'covers\'\'.\'\'jpg\'\'documentation\'\'book\'\'covers\'\'.\'\'jpg','000001000002000005000002'),('diZvW4bSgZWwyyGP3qXi1g','Commercial Documentation','Plain Black has created a whole line of commercial books which total over 1500 pages of detailed documentation about WebGUI. Both black and white and full color editions of these books are available, and they are updated frequently to keep you on top of t','documentation/commercial-documentation',1215717972,1215717972,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Commercial\'\'Documentation\'\'Commercial\'\'Documentation\'\'documentation\'\'commercial\'\'documentation\'\'Plain\'\'Black\'\'has\'\'created\'\'a\'\'whole\'\'line\'\'of\'\'commercial\'\'books\'\'which\'\'total\'\'over\'\'1500\'\'pages\'\'of\'\'detailed\'\'documentation\'\'about\'\'WebGUI\'\'.\'\'Both\'\'black\'\'and\'\'white\'\'and\'\'full\'\'color\'\'editions\'\'of\'\'these\'\'books\'\'are\'\'available\'\',\'\'and\'\'they\'\'are\'\'updated\'\'frequently\'\'to\'\'keep\'\'you\'\'on\'\'top\'\'of\'\'the\'\'latest\'\'WebGUI\'\'features\'\'.\'\'Visit\'\'the\'\'book\'\'store\'\'today\'\'to\'\'stock\'\'your\'\'WebGUI\'\'library\'\'.\'\'Other\'\'than\'\'hands\'\'on\'\'training\'\',\'\'there\'\'is\'\'no\'\'better\'\'way\'\'to\'\'hone\'\'your\'\'WebGUI\'\'skills\'\'.\'\'No\'\'matter\'\'what\'\'your\'\'need\'\',\'\'Plain\'\'Black\'\'has\'\'created\'\'a\'\'book\'\'that\'\'\'\'\'s\'\'right\'\'for\'\'you\'\'and\'\'is\'\'creating\'\'new\'\'books\'\'each\'\'year\'\'.  ','000001000002000005000003'),('PBEmsBadgeTemplate0000','Default EMS Badge Template','Default EMS Badge Template Default EMS Badge Template  default emsbadge ','default_emsbadge',1221077977,1221692339,'3','7','4','WebGUI::Asset::Template',1,'Default\'\'EMS\'\'Badge\'\'Template\'\'Default\'\'EMS\'\'Badge\'\'Template\'\'default\'\'emsbadge EMSBadge','000001000001000010000006'),('9A-mg2gwWmaYi9o_1C7ArQ','dashboard','dashboard dashboard  root import projectmanager dashboard ','root/import/projectmanager/dashboard',1147642478,1222803338,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'dashboard\'\'dashboard\'\'root\'\'import\'\'projectmanager\'\'dashboard','000001000001000027000001'),('yD1SMHelczihzjEmx6eXBA','editTask','editTask editTask  root import projectmanager edittask ','root/import/projectmanager/edittask',1147642478,1222803342,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'editTask\'\'editTask\'\'root\'\'import\'\'projectmanager\'\'edittask','000001000001000027000002'),('pV7GnZdpjR3XpZaSINIoeg','gantt','gantt gantt  root import projectmanager gantt ','root/import/projectmanager/gantt',1147642478,1222803347,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'gantt\'\'gantt\'\'root\'\'import\'\'projectmanager\'\'gantt','000001000001000027000003'),('71e17KeduiXgODLMlUxiow','project','project project  root import projectmanager project ','root/import/projectmanager/project',1147642479,1222803352,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'project\'\'project\'\'root\'\'import\'\'projectmanager\'\'project','000001000001000027000004'),('vTymIDYL2YqEh6PV50F7ew','manager','manager manager  root import timetracking manager ','root/import/timetracking/manager',1147642482,1222803302,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'manager\'\'manager\'\'root\'\'import\'\'timetracking\'\'manager','000001000001000042000001'),('lo1ac3BsoJx3ijGQ3gR-bQ','row','row row  root import timetracking row ','root/import/timetracking/row',1147642482,1222803309,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'row\'\'row\'\'root\'\'import\'\'timetracking\'\'row','000001000001000042000002'),('huASapWvFDzqwOSbcN-JFQ','user','user user  root import timetracking user ','root/import/timetracking/user',1147642483,1222803313,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'user\'\'user\'\'root\'\'import\'\'timetracking\'\'user','000001000001000042000003'),('xSmREZO3GNzK3M5PaueOOQ','LDAP/Account','LDAP/Account LDAP/Account  root import auth ldap account ','root/import/auth/ldap/account',1147642466,1222803378,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP\'\'/\'\'Account\'\'LDAP\'\'/\'\'Account\'\'root\'\'import\'\'auth\'\'ldap\'\'account','000001000001000004000001'),('0bx-xoL8TSXXubFuqKAoVQ','LDAP/Create','LDAP/Create LDAP/Create  root import auth ldap create ','root/import/auth/ldap/create',1147642466,1222803383,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP\'\'/\'\'Create\'\'LDAP\'\'/\'\'Create\'\'root\'\'import\'\'auth\'\'ldap\'\'create','000001000001000004000002'),('taX2UYkFF21ALpFZY2rhMw','LDAP/Login','LDAP/Login LDAP/Login  root import auth ldap login ','root/import/auth/ldap/login',1147642466,1222803387,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP\'\'/\'\'Login\'\'LDAP\'\'/\'\'Login\'\'root\'\'import\'\'auth\'\'ldap\'\'login','000001000001000004000003'),('K0q_N885Httqev1VCqUWxg','WebGUI/Account','WebGUI/Account WebGUI/Account  root import auth webgui account ','root/import/auth/webgui/account',1147642466,1222803391,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'/\'\'Account\'\'WebGUI\'\'/\'\'Account\'\'root\'\'import\'\'auth\'\'webgui\'\'account','000001000001000004000004'),('fq1ZkYhH24R5tb96kuT10Q','WebGUI/Create','WebGUI/Create WebGUI/Create  root import auth webgui create ','root/import/auth/webgui/create',1147642466,1222803395,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'/\'\'Create\'\'WebGUI\'\'/\'\'Create\'\'root\'\'import\'\'auth\'\'webgui\'\'create','000001000001000004000005'),('oHk7fAFhEEkB7dHzi0QOQA','WebGUI/Expired','WebGUI/Expired WebGUI/Expired  root import auth webgui expired ','root/import/auth/webgui/expired',1147642466,1222803399,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'/\'\'Expired\'\'WebGUI\'\'/\'\'Expired\'\'root\'\'import\'\'auth\'\'webgui\'\'expired','000001000001000004000006'),('9M-lrlPQWeeNWfvnDnK_Xg','WebGUI/Login','WebGUI/Login WebGUI/Login  root import auth webgui login ','root/import/auth/webgui/login',1147642466,1222803405,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'/\'\'Login\'\'WebGUI\'\'/\'\'Login\'\'root\'\'import\'\'auth\'\'webgui\'\'login','000001000001000004000007'),('_gBYAdTcbkiyamnqi2Xskg','WebGUI/Recovery','WebGUI/Recovery WebGUI/Recovery  root import auth webgui recovery ','root/import/auth/webgui/recovery',1147642466,1222803409,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI\'\'/\'\'Recovery\'\'WebGUI\'\'/\'\'Recovery\'\'root\'\'import\'\'auth\'\'webgui\'\'recovery','000001000001000004000008'),('tBL7BWiQRZFed2Y-Zjo9tQ','AdminToggle','AdminToggle AdminToggle  root import macro admintoggle ','root/import/macro/admintoggle',1147642471,1222803200,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminToggle\'\'AdminToggle\'\'root\'\'import\'\'macro\'\'admintoggle','000001000001000018000001'),('GdkQpvjRtJqtzOUbwIIQRA','a_account','a_account a_account  root import macro a account ','root/import/macro/a_account',1147642471,1222803205,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'a_account\'\'a_account\'\'root\'\'import\'\'macro\'\'a\'\'account','000001000001000018000002'),('tnc5iYyynX2hfdEs9D3P8w','EditableToggle','EditableToggle EditableToggle  root import macro editabletoggle ','root/import/macro/editabletoggle',1147642472,1222803213,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EditableToggle\'\'EditableToggle\'\'root\'\'import\'\'macro\'\'editabletoggle','000001000001000018000003'),('vgXdBcFTqU7h4wBG1ewdBw','File','File File  root import macro file ','root/import/macro/file',1147642472,1222803217,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'File\'\'File\'\'root\'\'import\'\'macro\'\'file','000001000001000018000004'),('hcFlqnXlsmC1ujN6Id0F0A','GroupAdd','GroupAdd GroupAdd  root import macro groupadd ','root/import/macro/groupadd',1147642473,1222803234,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'GroupAdd\'\'GroupAdd\'\'root\'\'import\'\'macro\'\'groupadd','000001000001000018000005'),('eRJR52fvlaxfetv3DQkQYw','GroupDelete','GroupDelete GroupDelete  root import macro groupdelete ','root/import/macro/groupdelete',1147642473,1222803238,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'GroupDelete\'\'GroupDelete\'\'root\'\'import\'\'macro\'\'groupdelete','000001000001000018000006'),('5HIDHq5lAWHV5gpYGS0zLg','H_homeLink','H_homeLink H_homeLink  root import macro h homelink ','root/import/macro/h_homelink',1147642473,1222803244,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'H_homeLink\'\'H_homeLink\'\'root\'\'import\'\'macro\'\'h\'\'homelink','000001000001000018000007'),('rYEFwXXo0tkGhQTcbDibvg','LoginToggle','LoginToggle LoginToggle  root import macro logintoggle ','root/import/macro/logintoggle',1147642473,1222803249,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LoginToggle\'\'LoginToggle\'\'root\'\'import\'\'macro\'\'logintoggle','000001000001000018000008'),('V3l5S5TtI7wMm1WpIMhvOA','L_loginBox','L_loginBox L_loginBox  root import macro l loginbox ','root/import/macro/l_loginbox',1147642473,1222803253,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'L_loginBox\'\'L_loginBox\'\'root\'\'import\'\'macro\'\'l\'\'loginbox','000001000001000018000009'),('nqNbSUAhk9Vd1zda2SCz9A','RandomThread','RandomThread RandomThread  root import macro randomthread ','root/import/macro/randomthread',1147642474,1222803258,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RandomThread\'\'RandomThread\'\'root\'\'import\'\'macro\'\'randomthread','000001000001000018000010'),('y8XkRdxIperLKkJ3bL5sSQ','r_printable','r_printable r_printable  root import macro r printable ','root/import/macro/r_printable',1147642474,1222803264,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'r_printable\'\'r_printable\'\'root\'\'import\'\'macro\'\'r\'\'printable','000001000001000018000011'),('UserListTmpl0000000002','UserList with search field selection','UserList with search field selection UserList with search field selection  root import userlist userlist with search field selection ','root/import/userlist/userlist-with-search-field-selection',1212000800,1228125752,'3','7','12','WebGUI::Asset::Template',1,'UserList\'\'with\'\'search\'\'field\'\'selection\'\'UserList\'\'with\'\'search\'\'field\'\'selection\'\'root\'\'import\'\'userlist\'\'userlist\'\'with\'\'search\'\'field\'\'selection UserList','000001000001000043000002'),('UserListTmpl0000000003','UserList with multiple search keywords','UserList with multiple search keywords UserList with multiple search keywords  root import userlist userlist with multiple search keywords ','root/import/userlist/userlist-with-multiple-search-keywords',1212001437,1228125758,'3','7','12','WebGUI::Asset::Template',1,'UserList\'\'with\'\'multiple\'\'search\'\'keywords\'\'UserList\'\'with\'\'multiple\'\'search\'\'keywords\'\'root\'\'import\'\'userlist\'\'userlist\'\'with\'\'multiple\'\'search\'\'keywords UserList','000001000001000043000003'),('UserListTmpl0000000001','Default UserList','Default UserList Default UserList  root import userlist default userlist ','root/import/userlist/default-userlist',1212159641,1228125743,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'UserList\'\'Default\'\'UserList\'\'root\'\'import\'\'userlist\'\'default\'\'userlist UserList','000001000001000043000001'),('BMybD3cEnmXVk2wQ_qEsRQ','Badge Builder (Default)','Badge Builder (Default) Badge Builder (Default)  root import ems badge builder default ','root/import/ems/badge-builder-default',1208530113,1242239790,'3','7','12','WebGUI::Asset::Template',1,'Badge\'\'Builder\'\'(\'\'Default\'\')\'\'Badge\'\'Builder\'\'(\'\'Default\'\')\'\'root\'\'import\'\'ems\'\'badge\'\'builder\'\'default EMS\'\'/\'\'BadgeBuilder','000001000001000010000001'),('OOyMH33plAy6oCj_QWrxtg','Lookup Registrant (Default)','Lookup Registrant (Default) Lookup Registrant (Default)  root import ems lookup registrant default ','root/import/ems/lookup-registrant-default',1207951375,1224724790,'3','7','12','WebGUI::Asset::Template',1,'Lookup\'\'Registrant\'\'(\'\'Default\'\')\'\'Lookup\'\'Registrant\'\'(\'\'Default\'\')\'\'root\'\'import\'\'ems\'\'lookup\'\'registrant\'\'default EMS\'\'/\'\'LookupRegistrant','000001000001000010000002'),('stevecoolmenu000000001','Site Nav','Site Nav Site Nav  webgui7 style3 hierarchical top nav ','webgui7/style3/hierarchical-top-nav',1147642505,1224116942,'3','7','12','WebGUI::Asset::Template',1,'Site\'\'Nav\'\'Site\'\'Nav\'\'webgui7\'\'style3\'\'hierarchical\'\'top\'\'nav Navigation','000001000001000047000001'),('7-0-style0000000000051','css03.css','css03.css css03.css  style3 css03.css ','style3/css03.css',1147642505,1224117026,'3','7','12','WebGUI::Asset::Snippet',1,'css03\'\'.\'\'css\'\'css03\'\'.\'\'css\'\'style3\'\'css03\'\'.\'\'css body\'\',\'\'html\'\'{\'\'margin\'\':\'\'0px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'b53018\'\';\'\'padding\'\':\'\'0px\'\';\'\'}\'\'body\'\'a\'\'{\'\'color\'\':\'\'#\'\'EE963E\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'1px\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'main\'\'{\'\'width\'\':\'\'98\'\'%\'\';\'\'/\'\'*\'\'min\'\'-\'\'width\'\':\'\'790px\'\';\'\'*\'\'/\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'padding\'\'-\'\'top\'\':\'\'20px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'#\'\'header\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'header_bg\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'115px\'\';\'\'}\'\'#\'\'headerTitle\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'header_left\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'left\'\'top\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'#\'\'headerRight\'\'{\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'header_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'right\'\'top\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'#\'\'headerRight\'\'#\'\'title\'\'{\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'25px\'\';\'\'left\'\':\'\'20px\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'#\'\'title\'\'h1\'\'{\'\'text\'\'-\'\'transform\'\':\'\'uppercase\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'font\'\'-\'\'size\'\':\'\'26pt\'\';\'\'margin\'\'-\'\'top\'\':\'\'0px\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'#\'\'title\'\'h1\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'size\'\':\'\'26pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'}\'\'#\'\'title\'\'h2\'\'{\'\'margin\'\':\'\'0px\'\';\'\'font\'\'-\'\'size\'\':\'\'12pt\'\';\'\'color\'\':\'\'#\'\'bebebe\'\';\'\'padding\'\'-\'\'left\'\':\'\'20px\'\';\'\'}\'\'#\'\'title\'\'img\'\'{\'\'z\'\'-\'\'index\'\':\'\'5\'\';\'\'}\'\'#\'\'login\'\'{\'\'position\'\':\'\'absolute\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'top\'\':\'\'45\'\'%\'\';\'\'right\'\':\'\'150px\'\';\'\'color\'\':\'\'white\'\';\'\'z\'\'-\'\'index\'\':\'\'6\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'}\'\'#\'\'login\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'letter\'\'-\'\'spacing\'\':\'\'0px\'\';\'\'}\'\'.\'\'loginBox\'\'{\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'margin\'\':\'\'0px\'\';\'\'display\'\':\'\'inline\'\';\'\'}\'\'.\'\'loginBox\'\'input\'\'{\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'mainBody\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'margin\'\':\'\'0px\'\';\'\'height\'\':\'\'500px\'\';\'\'background\'\':\'\'#\'\'fff\'\';\'\'position\'\':\'\'relative\'\';\'\'z\'\'-\'\'index\'\':\'\'0\'\';\'\'}\'\'#\'\'main\'\'>\'\'#\'\'mainBody\'\'{\'\'height\'\':\'\'auto\'\';\'\'min\'\'-\'\'height\'\':\'\'500px\'\';\'\'}\'\'#\'\'contentArea\'\'{\'\'z\'\'-\'\'index\'\':\'\'2\'\';\'\'position\'\':\'\'relative\'\';\'\'padding\'\'-\'\'top\'\':\'\'10px\'\';\'\'padding\'\'-\'\'left\'\':\'\'10px\'\';\'\'padding\'\'-\'\'right\'\':\'\'20px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'min\'\'-\'\'height\'\':\'\'500px\'\';\'\'}\'\'html\'\'#\'\'main\'\'#\'\'mainBody\'\'#\'\'contentArea\'\'{\'\'height\'\':\'\'1\'\'%\'\';\'\'}\'\'#\'\'topCorner\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'214px\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'0px\'\';\'\'left\'\':\'\'0px\'\';\'\'background\'\':\'\'url\'\'(\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'/\'\'style3\'\'/\'\'main_top\'\'.\'\'jpg\'\')\'\';\'\')\'\'no\'\'-\'\'repeat\'\';\'\'z\'\'-\'\'index\'\':\'\'1\'\';\'\'}\'\'#\'\'bottomCorner\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'211px\'\';\'\'position\'\':\'\'absolute\'\';\'\'bottom\'\':\'\'59px\'\';\'\'right\'\':\'\'0px\'\';\'\'background\'\':\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'main_bottom\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'right\'\';\'\'z\'\'-\'\'index\'\':\'\'1\'\';\'\'}\'\'*\'\'html\'\'#\'\'bottomCorner\'\'{\'\'bottom\'\':\'\'58px\'\';\'\'}\'\'#\'\'footer\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'margin\'\':\'\'0px\'\';\'\'background\'\':\'\'#\'\'000\'\'url\'\'(\'\'\'\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'style3\'\'/\'\'footer_right\'\'.\'\'jpg\'\')\'\';\'\'\'\'\')\'\'no\'\'-\'\'repeat\'\'right\'\'top\'\';\'\'height\'\':\'\'57px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'B53018\'\'2px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'position\'\':\'\'relative\'\';\'\'z\'\'-\'\'index\'\':\'\'0\'\';\'\'}\'\'#\'\'footer\'\'#\'\'copyright\'\'{\'\'color\'\':\'\'#\'\'3b3b3b\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'20px\'\';\'\'left\'\':\'\'30px\'\';\'\'font\'\'-\'\'size\'\':\'\'8pt\'\';\'\'}\'\'#\'\'main\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'{\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'}','000001000001000047000002'),('stevestyle000000000003','Style 03','Style 03 Style 03  style 03 ','style_03',1147642510,1224795533,'3','7','12','WebGUI::Asset::Template',1,'Style\'\'03\'\'Style\'\'03\'\'style\'\'03 style','000001000001000047000020'),('jVKLVakT_iA2010_oEuAwg','Style3 Coolmenu','Style3 Coolmenu Style3 Coolmenu  department nav ','department_nav',1224116526,1224116526,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3\'\'Coolmenu\'\'Style3\'\'Coolmenu\'\'department\'\'nav','000001000001000047000024'),('UL-ItI4L1Z6-WSuhuXVvsQ','DataTable','DataTable DataTable  root import datatable ','root/import/datatable',1225139673,1225139673,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'DataTable\'\'DataTable\'\'root\'\'import\'\'datatable','000001000001000009'),('3rjnBVJRO6ZSkxlFkYh_ug','Default DataTable Template (YUI)','Default DataTable Template (YUI) Default DataTable Template (YUI)  root import datatable default datatable template yui ','root/import/datatable/default-datatable-template-yui',1225139643,1233861835,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'DataTable\'\'Template\'\'(\'\'YUI\'\')\'\'Default\'\'DataTable\'\'Template\'\'(\'\'YUI\'\')\'\'root\'\'import\'\'datatable\'\'default\'\'datatable\'\'template\'\'yui DataTable','000001000001000009000001'),('TuYPpHx7TUyk08639Pc8Bg','Default DataTable Template (HTML)','Default DataTable Template (HTML) Default DataTable Template (HTML)  root import datatable default datatable template html ','root/import/datatable/default-datatable-template-html',1225139643,1233861621,'3','7','3','WebGUI::Asset::Template',1,'Default\'\'DataTable\'\'Template\'\'(\'\'HTML\'\')\'\'Default\'\'DataTable\'\'Template\'\'(\'\'HTML\'\')\'\'root\'\'import\'\'datatable\'\'default\'\'datatable\'\'template\'\'html DataTable','000001000001000009000002'),('FJbUTvZ2nUTn65LpW6gjsA','Profile Account Layout','Profile Account Layout Profile Account Layout  root import account profile profile account layout ','root/import/account/profile/profile-account-layout',1227070381,1232735095,'3','7','12','WebGUI::Asset::Template',1,'Profile\'\'Account\'\'Layout\'\'Profile\'\'Account\'\'Layout\'\'root\'\'import\'\'account\'\'profile\'\'profile\'\'account\'\'layout Account\'\'/\'\'Layout','000001000001000001000001000001'),('75CmQgpcCSkdsL-oawdn3Q','Default Edit Profile Template','Default Edit Profile Template Default Edit Profile Template  root import account profile default edit profile template ','root/import/account/profile/default-edit-profile-template',1227052575,1232561177,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Edit\'\'Profile\'\'Template\'\'Default\'\'Edit\'\'Profile\'\'Template\'\'root\'\'import\'\'account\'\'profile\'\'default\'\'edit\'\'profile\'\'template Account\'\'/\'\'Profile\'\'/\'\'Edit','000001000001000001000001000002'),('2CS-BErrjMmESOtGT90qOg','Default View Profile Template','Default View Profile Template Default View Profile Template  root import account profile default view profile template ','root/import/account/profile/default-view-profile-template',1227070888,1244053736,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'View\'\'Profile\'\'Template\'\'Default\'\'View\'\'Profile\'\'Template\'\'root\'\'import\'\'account\'\'profile\'\'default\'\'view\'\'profile\'\'template Account\'\'/\'\'Profile\'\'/\'\'View','000001000001000001000001000003'),('MBmWlA_YEA2I6D29OMGtRg','Default Profile Error Template','Default Profile Error Template Default Profile Error Template  root import account profile default profile error template ','root/import/account/profile/default-profile-error-template',1226542675,1228753307,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Profile\'\'Error\'\'Template\'\'Default\'\'Profile\'\'Error\'\'Template\'\'root\'\'import\'\'account\'\'profile\'\'default\'\'profile\'\'error\'\'template Account\'\'/\'\'Profile\'\'/\'\'Error','000001000001000001000001000004'),('IZkrow_zwvbf4FCH-taVTQ','Inbox','Inbox Inbox  root import account inbox ','root/import/account/inbox',1226011853,1226011853,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Inbox\'\'Inbox\'\'root\'\'import\'\'account\'\'inbox','000001000001000001000002'),('gfZOwaTWYjbSoVaQtHBBEw','Inbox Account Layout','Inbox Account Layout Inbox Account Layout  root import account inbox account layout ','root/import/account/inbox-account-layout',1226974679,1232735116,'3','7','12','WebGUI::Asset::Template',1,'Inbox\'\'Account\'\'Layout\'\'Inbox\'\'Account\'\'Layout\'\'root\'\'import\'\'account\'\'inbox\'\'account\'\'layout Account\'\'/\'\'Layout','000001000001000001000002000001'),('c8xrwVuu5QE0XtF9DiVzLw','Default Inbox View Template','Default Inbox View Template Default Inbox View Template  root import account inbox default inbox view template ','root/import/account/inbox/default-inbox-view-template',1226894351,1244345626,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Inbox\'\'View\'\'Template\'\'Default\'\'Inbox\'\'View\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'inbox\'\'view\'\'template Account\'\'/\'\'Inbox\'\'/\'\'View','000001000001000001000002000002'),('0n4HtbXaWa_XJHkFjetnLQ','Default Inbox View Message Template','Default Inbox View Message Template Default Inbox View Message Template  root import account inbox default inbox view message template ','root/import/account/inbox/default-inbox-view-message-template',1226894994,1233168324,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Inbox\'\'View\'\'Message\'\'Template\'\'Default\'\'Inbox\'\'View\'\'Message\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'inbox\'\'view\'\'message\'\'template Account\'\'/\'\'Inbox\'\'/\'\'ViewMessage','000001000001000001000002000003'),('ErEzulFiEKDkaCDVmxUavw','Default Inbox Error Template','Default Inbox Error Template Default Inbox Error Template  root import account inbox default inbox error template ','root/import/account/inbox/default-inbox-error-template',1226895484,1227566394,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Inbox\'\'Error\'\'Template\'\'Default\'\'Inbox\'\'Error\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'inbox\'\'error\'\'template Account\'\'/\'\'Inbox\'\'/\'\'Error','000001000001000001000002000004'),('6uQEULvXFgCYlRWnYzZsuA','Default Inbox Send Message Template','Default Inbox Send Message Template Default Inbox Send Message Template  root import account inbox default inbox send message template ','root/import/account/inbox/default-inbox-send-message-template',1226896682,1233874321,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Inbox\'\'Send\'\'Message\'\'Template\'\'Default\'\'Inbox\'\'Send\'\'Message\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'inbox\'\'send\'\'message\'\'template Account\'\'/\'\'Inbox\'\'/\'\'SendMessage','000001000001000001000002000005'),('DUoxlTBXhVS-Zl3CFDpt9g','Default Message Confirm Template','Default Message Confirm Template Default Message Confirm Template  root import account inbox default message confirm template ','root/import/account/inbox/default-message-confirm-template',1226896802,1226896802,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Message\'\'Confirm\'\'Template\'\'Default\'\'Message\'\'Confirm\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'message\'\'confirm\'\'template Account\'\'/\'\'Inbox\'\'/\'\'Confirm','000001000001000001000002000006'),('1Q4Je3hKCJzeo0ZBB5YB8g','Default Manage Invitations Template','Default Manage Invitations Template Default Manage Invitations Template  root import account inbox default manage invitations template ','root/import/account/inbox/default-manage-invitations-template',1226898445,1232753312,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Manage\'\'Invitations\'\'Template\'\'Default\'\'Manage\'\'Invitations\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'manage\'\'invitations\'\'template Account\'\'/\'\'Inbox\'\'/\'\'ManageInvitations','000001000001000001000002000007'),('5A8Hd9zXvByTDy4x-H28qw','Default Invitation Confirmation Template','Default Invitation Confirmation Template Default Invitation Confirmation Template  root import account inbox default invitation confirmation template ','root/import/account/inbox/default-invitation-confirmation-template',1226899462,1227566395,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Invitation\'\'Confirmation\'\'Template\'\'Default\'\'Invitation\'\'Confirmation\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'invitation\'\'confirmation\'\'template Account\'\'/\'\'Inbox\'\'/\'\'Confirm','000001000001000001000002000008'),('VBkY05f-E3WJS50WpdKd1Q','Default View Invitation Template','Default View Invitation Template Default View Invitation Template  root import account inbox default view invitation template ','root/import/account/inbox/default-view-invitation-template',1226899241,1233168685,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'View\'\'Invitation\'\'Template\'\'Default\'\'View\'\'Invitation\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'view\'\'invitation\'\'template Account\'\'/\'\'Inbox\'\'/\'\'ViewInvitation','000001000001000001000002000009'),('XgcsoDrbC0duVla7N7JAdw','Default Invite User Email Template','Default Invite User Email Template Default Invite User Email Template  root import account inbox default invite user email template ','root/import/account/inbox/default-invite-user-email-template',1226973330,1227566394,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Invite\'\'User\'\'Email\'\'Template\'\'Default\'\'Invite\'\'User\'\'Email\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'invite\'\'user\'\'email\'\'template Account\'\'/\'\'Inbox\'\'/\'\'InviteUserMessage','000001000001000001000002000010'),('cR0UFm7I1qUI2Wbpj--08Q','Default Invite User Form Template','Default Invite User Form Template Default Invite User Form Template  root import account inbox default invite user form template ','root/import/account/inbox/default-invite-user-form-template',1226964738,1232464762,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Invite\'\'User\'\'Form\'\'Template\'\'Default\'\'Invite\'\'User\'\'Form\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'invite\'\'user\'\'form\'\'template Account\'\'/\'\'Inbox\'\'/\'\'InviteUser','000001000001000001000002000011'),('SVIhz68689hwUGgcDM-gWw','Default Invite User Confirm Template','Default Invite User Confirm Template Default Invite User Confirm Template  root import account inbox default invite user confirm template ','root/import/account/inbox/default-invite-user-confirm-template',1226973314,1226973314,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Invite\'\'User\'\'Confirm\'\'Template\'\'Default\'\'Invite\'\'User\'\'Confirm\'\'Template\'\'root\'\'import\'\'account\'\'inbox\'\'default\'\'invite\'\'user\'\'confirm\'\'template Account\'\'/\'\'Inbox\'\'/\'\'InviteUserConfirm','000001000001000001000002000012'),('K0YjxqOqr7RupSo6sIdcAg','Friends','Friends Friends  root import account friends ','root/import/account/friends',1227074310,1227074310,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Friends\'\'Friends\'\'root\'\'import\'\'account\'\'friends','000001000001000001000003'),('zrNpGbT3odfIkg6nFSUy8Q','Friends Layout Template','Friends Layout Template Friends Layout Template  root import account friends friends layout template ','root/import/account/friends/friends-layout-template',1226994016,1232735138,'3','7','12','WebGUI::Asset::Template',1,'Friends\'\'Layout\'\'Template\'\'Friends\'\'Layout\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'friends\'\'layout\'\'template Account\'\'/\'\'Layout','000001000001000001000003000001'),('1Yn_zE_dSiNuaBGNLPbxtw','Default Friends View Template','Default Friends View Template Default Friends View Template  root import account friends default friends view template ','root/import/account/friends/default-friends-view-template',1226994422,1232952380,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Friends\'\'View\'\'Template\'\'Default\'\'Friends\'\'View\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'default\'\'friends\'\'view\'\'template Account\'\'/\'\'Friends\'\'/\'\'View','000001000001000001000003000002'),('AZFU33p0jpPJ-E6qLSWZng','Default Friends Edit Template','Default Friends Edit Template Default Friends Edit Template  root import account friends default friends edit template ','root/import/account/friends/default-friends-edit-template',1226994865,1244523565,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Friends\'\'Edit\'\'Template\'\'Default\'\'Friends\'\'Edit\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'default\'\'friends\'\'edit\'\'template Account\'\'/\'\'Friends\'\'/\'\'Edit','000001000001000001000003000003'),('AGJBGviWGAwjnwziiPjvDg','Default Send Request Template','Default Send Request Template Default Send Request Template  root import account friends default send request template ','root/import/account/friends/default-send-request-template',1226995497,1232569232,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Send\'\'Request\'\'Template\'\'Default\'\'Send\'\'Request\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'default\'\'send\'\'request\'\'template Account\'\'/\'\'Friends\'\'/\'\'SendRequest','000001000001000001000003000004'),('7Ijdd8SW32lVgg2H8R-Aqw','Default Friends Error Template','Default Friends Error Template Default Friends Error Template  root import account friends default friends error template ','root/import/account/friends/default-friends-error-template',1226995714,1226995714,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Friends\'\'Error\'\'Template\'\'Default\'\'Friends\'\'Error\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'default\'\'friends\'\'error\'\'template Account\'\'/\'\'Friends\'\'/\'\'Error','000001000001000001000003000005'),('K8F0j_cq_jgo8dvWY_26Ag','Default Friends Confirmation Template','Default Friends Confirmation Template Default Friends Confirmation Template  root import account friends default friends confirmation template ','root/import/account/friends/default-friends-confirmation-template',1226995643,1226995643,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Friends\'\'Confirmation\'\'Template\'\'Default\'\'Friends\'\'Confirmation\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'default\'\'friends\'\'confirmation\'\'template Account\'\'/\'\'Friends\'\'/\'\'Confirm','000001000001000001000003000006'),('G5V6neXIDiFXN05oL-U3AQ','Default Remove Friends Confirmation Template','Default Remove Friends Confirmation Template Default Remove Friends Confirmation Template  root import account friends default remove friends confirmation template ','root/import/account/friends/default-remove-friends-confirmation-template',1226995768,1226995768,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Remove\'\'Friends\'\'Confirmation\'\'Template\'\'Default\'\'Remove\'\'Friends\'\'Confirmation\'\'Template\'\'root\'\'import\'\'account\'\'friends\'\'default\'\'remove\'\'friends\'\'confirmation\'\'template Account\'\'/\'\'Friends\'\'/\'\'Confirm','000001000001000001000003000007'),('_ilRXNR3s8F2vGJ_k9ePcg','User','User User  root import account user ','root/import/account/user',1226643205,1226643205,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'User\'\'User\'\'root\'\'import\'\'account\'\'user','000001000001000001000004'),('9ThW278DWLV0-Svf68ljFQ','Account Layout','Account Layout Account Layout  root import account user account layout ','root/import/account/user/account-layout',1226647187,1232735163,'3','7','12','WebGUI::Asset::Template',1,'Account\'\'Layout\'\'Account\'\'Layout\'\'root\'\'import\'\'account\'\'user\'\'account\'\'layout Account\'\'/\'\'Layout','000001000001000001000004000001'),('AOjPG2NHgfL9Cq6dDJ7mew','Shop','Shop Shop  root import account shop ','root/import/account/shop',1226659753,1226659753,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shop\'\'Shop\'\'root\'\'import\'\'account\'\'shop','000001000001000001000005'),('aUDsJ-vB9RgP-AYvPOy8FQ','Shop Account Layout','Shop Account Layout Shop Account Layout  root import account shop shop account layout ','root/import/account/shop/shop-account-layout',1226660439,1232735191,'3','7','12','WebGUI::Asset::Template',1,'Shop\'\'Account\'\'Layout\'\'Shop\'\'Account\'\'Layout\'\'root\'\'import\'\'account\'\'shop\'\'shop\'\'account\'\'layout Account\'\'/\'\'Layout','000001000001000001000005000001'),('qaVcU0FFzzraMX_bzELqzw','Contributions','Contributions Contributions  root import account contributions ','root/import/account/contributions',1227074362,1227074362,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Contributions\'\'Contributions\'\'root\'\'import\'\'account\'\'contributions','000001000001000001000006'),('b4n3VyUIsAHyIvT-W-jziA','Contributions Layout','Contributions Layout Contributions Layout  root import account contributions contributions layout ','root/import/account/contributions/contributions-layout',1227074747,1232735307,'3','7','12','WebGUI::Asset::Template',1,'Contributions\'\'Layout\'\'Contributions\'\'Layout\'\'root\'\'import\'\'account\'\'contributions\'\'contributions\'\'layout Account\'\'/\'\'Layout','000001000001000001000006000001'),('1IzRpX0tgW7iuCfaU2Kk0A','Default Contributions View','Default Contributions View Default Contributions View  root import account contributions default contributions view ','root/import/account/contributions/default-contributions-view',1227079721,1234924646,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Contributions\'\'View\'\'Default\'\'Contributions\'\'View\'\'root\'\'import\'\'account\'\'contributions\'\'default\'\'contributions\'\'view Account\'\'/\'\'Contrib\'\'/\'\'View','000001000001000001000006000002'),('N716tpSna0iIQTKxS4gTWA','Default Account Layout','Default Account Layout Default Account Layout  root import account default account layout2 ','root/import/account/default-account-layout2',1226604666,1232734726,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Account\'\'Layout\'\'Default\'\'Account\'\'Layout\'\'root\'\'import\'\'account\'\'default\'\'account\'\'layout2 Account\'\'/\'\'Layout','000001000001000001000007'),('matrixtmpl000000000004','Matrix Default Edit Listing','Matrix Default Edit Listing Matrix Default Edit Listing  default matrix edit listing template ','default-matrix-edit-listing-template',1133743239,1228834590,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Edit\'\'Listing\'\'Matrix\'\'Default\'\'Edit\'\'Listing\'\'default\'\'matrix\'\'edit\'\'listing\'\'template Matrix\'\'/\'\'EditListing','000001000001000019000004'),('_9_eiaPgxzF_x_upt6-PNQ','gallery.css','gallery.css gallery.css  root import gallery templates gallery.css ','root/import/gallery-templates/gallery.css',1197988920,1230702602,'3','7','3','WebGUI::Asset::Snippet',1,'gallery\'\'.\'\'css\'\'gallery\'\'.\'\'css\'\'root\'\'import\'\'gallery\'\'templates\'\'gallery\'\'.\'\'css /\'\'*\'\'FIXES\'\'FLOAT\'\'ISSUES\'\'.\'\'WITHOUT\'\'THIS\'\',\'\'FLOATS\'\'GET\'\'ALL\'\'NUTSY\'\'ESPECIALLY\'\'IN\'\'OPERA\'\'AND\'\'SAFARI\'\'*\'\'/\'\'.\'\'clearfix\'\':\'\'after\'\'{\'\'content\'\':\'\'\"\'\'.\'\'\"\'\';\'\'display\'\':\'\'block\'\';\'\'height\'\':\'\'0\'\';\'\'clear\'\':\'\'both\'\';\'\'visibility\'\':\'\'hidden\'\';\'\'}\'\'.\'\'clearfix\'\'{\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'}\'\'/\'\'*\'\'END\'\'FLOAT\'\'FIX\'\'*\'\'/\'\'.\'\'wgGallery\'\'{\'\'font\'\'-\'\'family\'\':\'\'verdana\'\',\'\'arial\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'.\'\'firstBar\'\'{\'\'background\'\':\'\'black\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'18px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'firstBar\'\'.\'\'title\'\'{\'\'margin\'\'-\'\'left\'\':\'\'20px\'\';\'\'line\'\'-\'\'height\'\':\'\'42px\'\';\'\'}\'\'.\'\'firstBar\'\'.\'\'title\'\'a\'\'{\'\'font\'\'-\'\'size\'\':\'\'18px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'.\'\'firstBar\'\'.\'\'buttons\'\'{\'\'float\'\':\'\'right\'\';\'\'}\'\'.\'\'firstBar\'\'.\'\'buttons\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'height\'\':\'\'42px\'\';\'\'line\'\'-\'\'height\'\':\'\'42px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'padding\'\':\'\'0px\'\'5px\'\';\'\'}\'\'.\'\'firstBar\'\'.\'\'buttons\'\'.\'\'rss\'\'{\'\'display\'\':\'\'block\'\';\'\'height\'\':\'\'29px\'\';\'\'position\'\':\'\'relative\'\';\'\'background\'\':\'\'transparent\'\';\'\'padding\'\'-\'\'top\'\':\'\'13px\'\';\'\'}\'\'.\'\'secondBar\'\'{\'\'background\'\':\'\'#\'\'F1F1F1\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'8B8B8B\'\'5px\'\';\'\'color\'\':\'\'black\'\';\'\'overflow\'\':\'\'hidden\'\';\'\'}\'\'.\'\'secondBar\'\'.\'\'author\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'}\'\'.\'\'secondBar\'\'.\'\'desc\'\'p\'\'{\'\'margin\'\'-\'\'left\'\':\'\'20px\'\';\'\'margin\'\'-\'\'top\'\':\'\'0\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'pictures\'\'{\'\'}\'\'.\'\'searchArea\'\'{\'\'float\'\':\'\'right\'\';\'\'}\'\'.\'\'searchArea\'\'*\'\'{\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'searchArea\'\'input\'\'.\'\'searchText\'\'{\'\'border\'\':\'\'solid\'\'black\'\'1px\'\';\'\'width\'\':\'\'100px\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'2px\'\';\'\'margin\'\'-\'\'top\'\':\'\'5px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'height\'\':\'\'15px\'\';\'\'margin\'\'-\'\'right\'\':\'\'10px\'\';\'\'}\'\'.\'\'searchArea\'\'input\'\'.\'\'searchBtn\'\'{\'\'border\'\':\'\'solid\'\'black\'\'1px\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'3px\'\';\'\'margin\'\'-\'\'top\'\':\'\'5px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'vertical\'\'-\'\'align\'\':\'\'center\'\';\'\'cursor\'\':\'\'pointer\'\';\'\'height\'\':\'\'21px\'\';\'\'}\'\'.\'\'searchArea\'\'a\'\':\'\'link\'\',\'\'.\'\'searchArea\'\'a\'\':\'\'visited\'\',\'\'.\'\'secondBar\'\'.\'\'author\'\'a\'\':\'\'link\'\',\'\'.\'\'secondBar\'\'.\'\'author\'\'a\'\':\'\'visited\'\'{\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'searchArea\'\'.\'\'current\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'transform\'\':\'\'uppercase\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'}\'\'.\'\'wgAlbum\'\'{\'\'display\'\':\'\'-\'\'moz\'\'-\'\'inline\'\'-\'\'box\'\';\'\'/\'\'*\'\'Moz\'\'*\'\'/\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'/\'\'*\'\'Op\'\',\'\'Saf\'\',\'\'IE\'\'\\\'\'*\'\'/\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'/\'\'*\'\'IE\'\'Mac\'\'non\'\'capisce\'\'e\'\'a\'\'volte\'\'crea\'\'extra\'\'v\'\'space\'\'*\'\'/\'\'width\'\':\'\'250px\'\';\'\'margin\'\':\'\'10px\'\';\'\'}\'\'.\'\'wgAlbum\'\'.\'\'albumTitle\'\'{\'\'background\'\':\'\'black\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\':\'\'10px\'\';\'\'padding\'\'-\'\'right\'\':\'\'50px\'\';\'\'border\'\':\'\'solid\'\'#\'\'475f6f\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'8B8B8B\'\'5px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'wgAlbum\'\'.\'\'albumImage\'\'{\'\'background\'\':\'\'#\'\'F1F1F1\'\';\'\'border\'\'-\'\'left\'\':\'\'solid\'\'black\'\'1px\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'black\'\'1px\'\';\'\'padding\'\'-\'\'top\'\':\'\'15px\'\';\'\'height\'\':\'\'135px\'\';\'\'}\'\'.\'\'wgAlbum\'\'.\'\'albumImage\'\'a\'\'{\'\'height\'\':\'\'135px\'\';\'\'width\'\':\'\'200px\'\';\'\'overflow\'\':\'\'hidden\'\';\'\'display\'\':\'\'block\'\';\'\'margin\'\':\'\'0px\'\'23px\'\';\'\'}\'\'.\'\'wgAlbum\'\'.\'\'albumImage\'\'img\'\'{\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'display\'\':\'\'block\'\';\'\'width\'\':\'\'200px\'\';\'\'height\'\':\'\'auto\'\';\'\'border\'\':\'\'solid\'\'black\'\'1px\'\';\'\'}\'\'.\'\'wgAlbum\'\'.\'\'albumDesc\'\'{\'\'background\'\':\'\'#\'\'F1F1F1\'\';\'\'border\'\'-\'\'left\'\':\'\'solid\'\'black\'\'1px\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'black\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'black\'\'1px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'padding\'\':\'\'5px\'\'23px\'\';\'\'}\'\'.\'\'wgAlbum\'\'.\'\'description\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'height\'\':\'\'40px\'\';\'\'overflow\'\':\'\'auto\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'border\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'padding\'\':\'\'5px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'fff\'\';\'\'color\'\':\'\'#\'\'222\'\';\'\'}\'\'.\'\'albumDesc\'\'.\'\'description\'\'*\'\'{\'\'margin\'\':\'\'2px\'\'0px\'\';\'\'}\'\'/\'\'*\'\'PAGINATION\'\'STYLES\'\'*\'\'/\'\'.\'\'wgGallery\'\'.\'\'paginationContainer\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'background\'\':\'\'black\'\';\'\'height\'\':\'\'42px\'\';\'\'}\'\'.\'\'wgGallery\'\'.\'\'container\'\'{\'\'clear\'\':\'\'both\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'wgGallery\'\'.\'\'pagination\'\'{\'\'margin\'\':\'\'0px\'\'auto\'\'20px\'\'auto\'\';\'\'display\'\':\'\'table\'\';\'\'list\'\'-\'\'style\'\'-\'\'type\'\':\'\'none\'\';\'\'white\'\'-\'\'space\'\':\'\'nowrap\'\';\'\'padding\'\':\'\'0px\'\';\'\'height\'\':\'\'42px\'\';\'\'}\'\'.\'\'wgGallery\'\'.\'\'pagination\'\'li\'\'{\'\'display\'\':\'\'table\'\'-\'\'cell\'\';\'\'}\'\'.\'\'wgGallery\'\'.\'\'pagination\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'width\'\':\'\'50px\'\';\'\'line\'\'-\'\'height\'\':\'\'42px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'wgPicture\'\'a\'\':\'\'link\'\',\'\'.\'\'wgPicture\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'wgPicture\'\'{\'\'width\'\':\'\'250px\'\';\'\'margin\'\':\'\'10px\'\';\'\'display\'\':\'\'-\'\'moz\'\'-\'\'inline\'\'-\'\'box\'\';\'\'/\'\'*\'\'Moz\'\'*\'\'/\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'/\'\'*\'\'Op\'\',\'\'Saf\'\',\'\'IE\'\'\\\'\'*\'\'/\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'/\'\'*\'\'IE\'\'Mac\'\'non\'\'capisce\'\'e\'\'a\'\'volte\'\'crea\'\'extra\'\'v\'\'space\'\'*\'\'/\'\'}\'\'.\'\'wgPicture\'\'.\'\'title\'\'{\'\'background\'\':\'\'#\'\'e0e0e0\'\';\'\'display\'\':\'\'block\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'border\'\':\'\'solid\'\'black\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'8B8B8B\'\'4px\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'thumbnail\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'background\'\':\'\'#\'\'F1F1F1\'\';\'\'padding\'\':\'\'15px\'\'23px\'\'15px\'\'23px\'\';\'\'margin\'\':\'\'0px\'\';\'\'border\'\'-\'\'left\'\':\'\'solid\'\'black\'\'1px\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'black\'\'1px\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'thumbnail\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'width\'\':\'\'200px\'\';\'\'height\'\':\'\'120px\'\';\'\'overflow\'\':\'\'hidden\'\';\'\'border\'\':\'\'solid\'\'black\'\'1px\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'thumbnail\'\'img\'\'{\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'width\'\':\'\'200px\'\';\'\'height\'\':\'\'auto\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'pictureDesc\'\'{\'\'padding\'\':\'\'0px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'e1e1e1\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'gray\'\'1px\'\';\'\'border\'\'-\'\'left\'\':\'\'solid\'\'black\'\'1px\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'black\'\'1px\'\';\'\'background\'\':\'\'#\'\'F1F1F1\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'pictureDesc\'\'.\'\'description\'\'{\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'5px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'details\'\'{\'\'background\'\':\'\'#\'\'e0e0e0\'\';\'\'border\'\':\'\'solid\'\'#\'\'999\'\'1px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'aaa\'\'1px\'\';\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'padding\'\':\'\'1px\'\'3px\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'details\'\'.\'\'date\'\'{\'\'float\'\':\'\'right\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'details\'\'.\'\'comments\'\'{\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'wgPicture\'\'.\'\'details\'\'a\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'}\'\'/\'\'*\'\'*\'\'-\'\'-\'\'BEGIN\'\'STYLES\'\'FOR\'\'PHOTO\'\'VIEW\'\'-\'\'-\'\'*\'\'The\'\'Photo\'\'view\'\'uses\'\'some\'\'/\'\'all\'\'of\'\'the\'\'above\'\'classes\'\',\'\'plus\'\'those\'\'in\'\'this\'\'section\'\'.\'\'*\'\'/\'\'.\'\'wgSnapshot\'\'{\'\'float\'\':\'\'left\'\';\'\'margin\'\':\'\'10px\'\';\'\'max\'\'-\'\'width\'\':\'\'250px\'\';\'\'width\'\':\'\'25\'\'%\'\';\'\'}\'\'.\'\'wgSnapshot\'\'fieldset\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'fefefe\'\';\'\'border\'\':\'\'solid\'\'#\'\'555\'\'2px\'\';\'\'padding\'\':\'\'10px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f9f9f9\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'wgSnapshot\'\'p\'\'{\'\'max\'\'-\'\'width\'\':\'\'230px\'\';\'\'}\'\'.\'\'wgSnapshot\'\'legend\'\'{\'\'color\'\':\'\'#\'\'333\'\';\'\'font\'\'-\'\'size\'\':\'\'15px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'max\'\'-\'\'width\'\':\'\'250px\'\';\'\'}\'\'.\'\'wgSnapshot\'\'a\'\'.\'\'thumbnail\'\'img\'\'{\'\'width\'\':\'\'200px\'\';\'\'height\'\':\'\'auto\'\';\'\'border\'\':\'\'solid\'\'#\'\'555\'\'2px\'\';\'\'}\'\'.\'\'wgSnapshot\'\'.\'\'description\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'border\'\':\'\'solid\'\'#\'\'555555\'\'2px\'\';\'\'padding\'\':\'\'5px\'\';\'\'width\'\':\'\'190px\'\';\'\'margin\'\':\'\'0px\'\'auto\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'fff\'\';\'\'height\'\':\'\'50px\'\';\'\'overflow\'\':\'\'auto\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'overflow\'\':\'\'auto\'\';\'\'}\'\'.\'\'wgSnapshot\'\'a\'\'.\'\'fullSize\'\'{\'\'margin\'\':\'\'0px\'\'auto\'\';\'\'}\'\'.\'\'wgPictureDetails\'\'{\'\'float\'\':\'\'left\'\';\'\'width\'\':\'\'70\'\'%\'\';\'\'margin\'\':\'\'10px\'\';\'\'}\'\'.\'\'wgPictureDetails\'\'a\'\':\'\'link\'\',\'\'.\'\'wgPictureDetails\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'wgPictureDetails\'\'fieldset\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'fefefe\'\';\'\'border\'\':\'\'solid\'\'#\'\'555\'\'2px\'\';\'\'padding\'\':\'\'10px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f9f9f9\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'10px\'\';\'\'}\'\'.\'\'wgPictureDetails\'\'legend\'\'{\'\'color\'\':\'\'#\'\'333\'\';\'\'font\'\'-\'\'size\'\':\'\'15px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'rowOne\'\'{\'\'background\'\':\'\'#\'\'EFEFEF\'\';\'\'margin\'\':\'\'1px\'\';\'\'border\'\':\'\'solid\'\'#\'\'CDCDCD\'\'1px\'\';\'\'color\'\':\'\'black\'\';\'\'padding\'\':\'\'3px\'\';\'\'}\'\'.\'\'rowTwo\'\'{\'\'background\'\':\'\'#\'\'DCDCDC\'\';\'\'margin\'\':\'\'1px\'\';\'\'border\'\':\'\'solid\'\'#\'\'DDDDDD\'\'1px\'\';\'\'color\'\':\'\'black\'\';\'\'padding\'\':\'\'3px\'\';\'\'}\'\'.\'\'rowOne\'\'.\'\'label\'\',\'\'.\'\'rowTwo\'\'.\'\'label\'\'{\'\'margin\'\'-\'\'left\'\':\'\'15px\'\';\'\'display\'\':\'\'inline\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'}\'\'.\'\'rowOne\'\'.\'\'data\'\',\'\'.\'\'rowTwo\'\'.\'\'data\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'margin\'\'-\'\'left\'\':\'\'5px\'\';\'\'display\'\':\'\'inline\'\';\'\'}\'\'a\'\'.\'\'fullSize\'\':\'\'link\'\',\'\'a\'\'.\'\'fullSize\'\':\'\'visited\'\'{\'\'color\'\':\'\'black\'\';\'\'display\'\':\'\'block\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'}\'\'.\'\'wgComments\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'margin\'\':\'\'10px\'\';\'\'width\'\':\'\'90\'\'%\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'title\'\'{\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'color\'\':\'\'#\'\'333\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'555555\'\'2px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'2px\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'title\'\'a\'\'{\'\'color\'\':\'\'navy\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'comment\'\',\'\'.\'\'wgComments\'\'.\'\'commentAlt\'\'{\'\'position\'\':\'\'relative\'\';\'\'padding\'\':\'\'5px\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'comment\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'e1e1e1\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'F7F7F7\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'C9C9C9\'\'1px\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'commentAlt\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f0f0f0\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'CDCDCD\'\'1px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'FBFBFB\'\'1px\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'number\'\'{\'\'float\'\':\'\'left\'\';\'\'font\'\'-\'\'size\'\':\'\'30px\'\';\'\'color\'\':\'\'silver\'\';\'\'margin\'\':\'\'5px\'\'10px\'\'5px\'\'5px\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'posted\'\'{\'\'font\'\'-\'\'style\'\':\'\'italic\'\';\'\'padding\'\'-\'\'top\'\':\'\'3px\'\';\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'color\'\':\'\'gray\'\';\'\'}\'\'.\'\'wgComments\'\'.\'\'posted\'\'a\'\'{\'\'color\'\':\'\'navy\'\';\'\'text\'\'-\'\'decoration\'\':\'\'underline\'\';\'\'}\'\'/\'\'*\'\'*\'\'-\'\'-\'\'BEGIN\'\'STYLES\'\'FOR\'\'THUMBNAIL\'\'VIEW\'\'-\'\'-\'\'*\'\'The\'\'Thumbnail\'\'view\'\'uses\'\'some\'\'/\'\'all\'\'of\'\'the\'\'above\'\'classes\'\',\'\'plus\'\'those\'\'in\'\'this\'\'section\'\'.\'\'*\'\'/\'\'.\'\'thumbView\'\'{\'\'width\'\':\'\'400px\'\';\'\'height\'\':\'\'auto\'\';\'\'}\'\'.\'\'thumbView\'\'.\'\'thumbnail\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'width\'\':\'\'350px\'\';\'\'height\'\':\'\'auto\'\';\'\'border\'\':\'\'solid\'\'black\'\'1px\'\';\'\'}\'\'.\'\'thumbView\'\'.\'\'thumbnail\'\'img\'\'{\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'width\'\':\'\'350px\'\';\'\'height\'\':\'\'auto\'\';\'\'}\'\'.\'\'thumb\'\'{\'\'width\'\':\'\'100px\'\';\'\'height\'\':\'\'65px\'\';\'\'overflow\'\':\'\'hidden\'\';\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'border\'\':\'\'solid\'\'black\'\'2px\'\';\'\'margin\'\':\'\'10px\'\';\'\'}\'\'.\'\'thumb\'\'img\'\'{\'\'width\'\':\'\'100px\'\';\'\'height\'\':\'\'auto\'\';\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'}\'\'.\'\'thumb\'\'-\'\'popup\'\'{\'\'border\'\':\'\'solid\'\'#\'\'555\'\'1px\'\';\'\'padding\'\':\'\'2px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'4px\'\';\'\'padding\'\'-\'\'right\'\':\'\'4px\'\';\'\'background\'\'-\'\'color\'\':\'\'silver\'\';\'\'}\'\'.\'\'thumb\'\'-\'\'popup\'\'img\'\'{\'\'border\'\':\'\'solid\'\'#\'\'555\'\'1px\'\';\'\'}\'\'.\'\'thumb\'\'-\'\'popup\'\'.\'\'caption\'\'{\'\'background\'\'-\'\'color\'\':\'\'black\'\';\'\'color\'\':\'\'white\'\';\'\'padding\'\':\'\'4px\'\';\'\'border\'\':\'\'solid\'\'#\'\'555\'\'2px\'\';\'\'}\'\'/\'\'*\'\'*\'\'-\'\'-\'\'BEGIN\'\'STYLES\'\'FOR\'\'SLIDESHOW\'\'VIEW\'\'-\'\'-\'\'*\'\'The\'\'Slideshow\'\'view\'\'uses\'\'some\'\'/\'\'all\'\'of\'\'the\'\'above\'\'classes\'\',\'\'plus\'\'those\'\'in\'\'this\'\'section\'\'.\'\'*\'\'/\'\'.\'\'wgSlideshow\'\'.\'\'controls\'\'{\'\'background\'\':\'\'url\'\'(\'\'&\'\'#\'\'94\'\';\'\'FileUrl\'\'(\'\'root\'\'/\'\'import\'\'/\'\'gallery\'\'-\'\'templates\'\'/\'\'images\'\'/\'\'pagination_bg\'\'.\'\'jpg\'\')\'\';\'\')\'\'repeat\'\'-\'\'x\'\';\'\'width\'\':\'\'500px\'\';\'\'height\'\':\'\'42px\'\';\'\'margin\'\':\'\'0px\'\'auto\'\';\'\'border\'\':\'\'solid\'\'black\'\'2px\'\';\'\'}\'\'.\'\'wgSlideshow\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'#\'\'slideshow\'\'-\'\'container\'\'{\'\'width\'\':\'\'500px\'\';\'\'height\'\':\'\'auto\'\';\'\'margin\'\':\'\'0px\'\'auto\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'border\'\':\'\'solid\'\'black\'\'2px\'\';\'\'position\'\':\'\'relative\'\';\'\'z\'\'-\'\'index\'\':\'\'0\'\';\'\'}\'\'#\'\'slideshow\'\'-\'\'container\'\'.\'\'slideshow\'\'-\'\'item\'\'img\'\'{\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'auto\'\';\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'#\'\'slideshow\'\'-\'\'container\'\'.\'\'slideshow\'\'-\'\'item\'\'.\'\'title\'\'{\'\'background\'\'-\'\'color\'\':\'\'black\'\';\'\'padding\'\':\'\'3px\'\';\'\'color\'\':\'\'white\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'white\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'white\'\'1px\'\';\'\'}\'\'#\'\'slideshow\'\'-\'\'container\'\'.\'\'slideshow\'\'-\'\'item\'\'.\'\'title\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'slideshow\'\'-\'\'container\'\'.\'\'slideshow\'\'-\'\'item\'\'.\'\'counter\'\'{\'\'background\'\'-\'\'color\'\':\'\'black\'\';\'\'padding\'\':\'\'3px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'slideshow\'\'-\'\'container\'\'.\'\'slideshow\'\'-\'\'item\'\'.\'\'synopsis\'\'{\'\'width\'\':\'\'494px\'\';\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'padding\'\':\'\'3px\'\';\'\'color\'\':\'\'black\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'black\'\'1px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'/\'\'*\'\'*\'\'-\'\'-\'\'BEGIN\'\'STYLES\'\'FOR\'\'SEARCH\'\'VIEW\'\'-\'\'-\'\'*\'\'The\'\'Search\'\'view\'\'uses\'\'some\'\'/\'\'all\'\'of\'\'the\'\'above\'\'classes\'\',\'\'plus\'\'those\'\'in\'\'this\'\'section\'\'.\'\'*\'\'/\'\'#\'\'adminWrapper\'\'{\'\'margin\'\'-\'\'top\'\':\'\'20px\'\';\'\'}\'\'#\'\'adminWrapper\'\'.\'\'label\'\'{\'\'background\'\':\'\'black\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'#\'\'adminWrapper\'\'td\'\'.\'\'data\'\'input\'\'{\'\'background\'\':\'\'#\'\'f1f1f1\'\';\'\'vertical\'\'-\'\'align\'\':\'\'middle\'\';\'\'}\'\'#\'\'adminWrapper\'\'td\'\'.\'\'radio\'\'input\'\'{\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'background\'\':\'\'none\'\';\'\'}\'\'#\'\'adminWrapper\'\'.\'\'forwardButton\'\'{\'\'cursor\'\':\'\'pointer\'\';\'\'float\'\':\'\'rigbt\'\';\'\'}\'\'#\'\'adminWrapper\'\'.\'\'forwardButton\'\':\'\'hover\'\'{\'\'color\'\':\'\'gold\'\';\'\'}','000001000001000013000016'),('kJf77eCr9GAMiEzWrzsBTA','matrix-ie.css','matrix-ie.css matrix-ie.css  new matrix matrix ie.css ','new-matrix/matrix-ie.css',1229639255,1229639255,'3','7','12','WebGUI::Asset::Snippet',1,'matrix\'\'-\'\'ie\'\'.\'\'css\'\'matrix\'\'-\'\'ie\'\'.\'\'css\'\'new\'\'matrix\'\'matrix\'\'ie\'\'.\'\'css .\'\'matrixLeft\'\'.\'\'buttons\'\'span\'\',\'\'.\'\'matrixRight\'\'.\'\'buttons\'\'span\'\'{\'\'padding\'\':\'\'0px\'\'0px\'\'0px\'\'0px\'\';\'\'}\'\'.\'\'matrixLeft\'\'.\'\'buttons\'\'button\'\',\'\'.\'\'matrixRight\'\'.\'\'buttons\'\'a\'\'{\'\'top\'\':\'\'-\'\'3px\'\';\'\'left\'\':\'\'-\'\'2px\'\';\'\'height\'\':\'\'22px\'\';\'\'}\'\'.\'\'matrixRight\'\'.\'\'buttons\'\'a\'\'{\'\'color\'\':\'\'black\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'padding\'\':\'\'1px\'\'3px\'\';\'\'}','000001000001000019000007'),('4LQT4-bGW4FkiEQLSY5gvQ','show-hide.js','show-hide.js show-hide.js  new matrix show hide.js ','new-matrix/show-hide.js',1232400287,1232400287,'3','7','12','WebGUI::Asset::Snippet',1,'show\'\'-\'\'hide\'\'.\'\'js\'\'show\'\'-\'\'hide\'\'.\'\'js\'\'new\'\'matrix\'\'show\'\'hide\'\'.\'\'js function\'\'showHide\'\'(\'\'theLink\'\',\'\'theId\'\')\'\'{\'\'var\'\'theId\'\'=\'\'document\'\'.\'\'getElementById\'\'(\'\'theId\'\')\'\';\'\'var\'\'theLink\'\'=\'\'document\'\'.\'\'getElementById\'\'(\'\'theLink\'\')\'\';\'\'if\'\'(\'\'theId\'\'.\'\'style\'\'.\'\'display\'\'=\'\'=\'\'\'\'\'block\'\'\'\'\')\'\'{\'\'theId\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\'\'\'none\'\'\'\'\';\'\'theLink\'\'.\'\'innerHTML\'\'=\'\'\"\'\'Send\'\'Creator\'\'a\'\'Message\'\'\"\'\';\'\'theLink\'\'.\'\'className\'\'=\'\'\"\'\'showLink\'\'\"\'\'}\'\'else\'\'{\'\'theId\'\'.\'\'style\'\'.\'\'display\'\'=\'\'\'\'\'block\'\'\'\'\';\'\'theLink\'\'.\'\'innerHTML\'\'=\'\'\"\'\'Hide\'\'\"\'\';\'\'theLink\'\'.\'\'className\'\'=\'\'\"\'\'hideLink\'\'\"\'\'}\'\'}','000001000001000019000008'),('alraubvBu-YJJ614jAHD5w','matrix-nav-tmpl','matrix-nav-tmpl matrix-nav-tmpl  new matrix matrix nav tmpl ','new-matrix/matrix-nav-tmpl',1232664015,1235706026,'3','7','12','WebGUI::Asset::Template',1,'matrix\'\'-\'\'nav\'\'-\'\'tmpl\'\'matrix\'\'-\'\'nav\'\'-\'\'tmpl\'\'new\'\'matrix\'\'matrix\'\'nav\'\'tmpl Navigation','000001000001000019000009'),('Vch1Ww7G_JpBhOhXX07RDg','matrx-nav','matrx-nav matrix-nav  new matrix matrix nav ','new-matrix/matrix-nav',1232664082,1235705952,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'matrx\'\'-\'\'nav\'\'matrix\'\'-\'\'nav\'\'new\'\'matrix\'\'matrix\'\'nav','000001000001000019000010'),('PBtmpl0000000000000063','Default Overview Report','Default Overview Report Default Overview Report  root import survey default overview report ','root/import/survey/default_overview_report',1124395696,1233156264,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Overview\'\'Report\'\'Default\'\'Overview\'\'Report\'\'root\'\'import\'\'survey\'\'default\'\'overview\'\'report Survey\'\'/\'\'Overview','000001000001000039000001'),('PBtmpl0000000000000062','Default Gradebook Report','Default Gradebook Report Default Gradebook Report  root import survey default gradebook report ','root/import/survey/default_gradebook_report',1124395696,1232981641,'3','7','12','WebGUI::Asset::Template',1,'Default\'\'Gradebook\'\'Report\'\'Default\'\'Gradebook\'\'Report\'\'root\'\'import\'\'survey\'\'default\'\'gradebook\'\'report Survey\'\'/\'\'Gradebook','000001000001000039000002'),('HW-sPoDDZR8wBZ0YgFgPtg','images','images images  root import account images ','root/import/account/images',1227634350,1227634350,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images\'\'images\'\'root\'\'import\'\'account\'\'images','000001000001000001000009'),('hBpisL-_URyZnh9clR5ohA','no_photo.gif','no_photo.gif no_photo.gif  root import account images no photo.gif ','root/import/account/images/no_photo.gif',1227634417,1227634417,'3','7','12','WebGUI::Asset::File::Image',1,'no_photo\'\'.\'\'gif\'\'no_photo\'\'.\'\'gif\'\'root\'\'import\'\'account\'\'images\'\'no\'\'photo\'\'.\'\'gif','000001000001000001000009000001'),('FOBV6KkifreXa4GmEAUU4A','no_photo_sm.gif','no_photo_sm.gif no_photo_sm.gif  root import account images no photo sm.gif ','root/import/account/images/no_photo_sm.gif',1227634447,1227634447,'3','7','12','WebGUI::Asset::File::Image',1,'no_photo_sm\'\'.\'\'gif\'\'no_photo_sm\'\'.\'\'gif\'\'root\'\'import\'\'account\'\'images\'\'no\'\'photo\'\'sm\'\'.\'\'gif','000001000001000001000009000002'),('_XfvgNH__bY1ykMiKYSobQ','account.css','account.css account.css  root import account account.css ','root/import/account/account.css',1233168041,1234924781,'3','7','12','WebGUI::Asset::Snippet',1,'account\'\'.\'\'css\'\'account\'\'.\'\'css\'\'root\'\'import\'\'account\'\'account\'\'.\'\'css /\'\'*\'\'general\'\'*\'\'/\'\'body\'\'{\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'font\'\':\'\'11px\'\'Verdana\'\';\'\'}\'\'a\'\'{\'\'cursor\'\':\'\'pointer\'\';\'\'}\'\'button\'\'{\'\'cursor\'\':\'\'pointer\'\';\'\'}\'\'img\'\'{\'\'border\'\':\'\'none\'\';\'\'}\'\'.\'\'WGbutton\'\'{\'\'float\'\':\'\'right\'\';\'\'padding\'\'-\'\'right\'\':\'\'10px\'\';\'\'}\'\'.\'\'centered\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGaccount_message\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'border\'\':\'\'solid\'\'#\'\'BECEF8\'\'1px\'\';\'\'height\'\':\'\'300px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'10px\'\';\'\'margin\'\'-\'\'left\'\':\'\'60px\'\';\'\'margin\'\'-\'\'top\'\':\'\'20px\'\';\'\'overflow\'\':\'\'-\'\'moz\'\'-\'\'scrollbars\'\'-\'\'vertical\'\';\'\'overflow\'\'-\'\'x\'\':\'\'hidden\'\';\'\'overflow\'\'-\'\'y\'\':\'\'scroll\'\';\'\'padding\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'width\'\':\'\'90\'\'%\'\';\'\'}\'\'.\'\'WGprofileMember\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'margin\'\'-\'\'right\'\':\'\'20px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'}\'\'.\'\'WGmember\'\'{\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\':\'\'9px\'\'Verdana\'\',\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGphotostyle\'\'{\'\'border\'\':\'\'solid\'\'#\'\'3e4f77\'\'2px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'margin\'\'-\'\'top\'\':\'\'5px\'\'}\'\'#\'\'rightalign\'\'{\'\'float\'\':\'\'right\'\';\'\'}\'\'/\'\'*\'\'.\'\'WGsend\'\'{\'\'float\'\':\'\'right\'\';\'\'padding\'\'-\'\'right\'\':\'\'75px\'\';\'\'}\'\'*\'\'/\'\'/\'\'*\'\'bio\'\',\'\'addtonetwork\'\',\'\'network\'\'*\'\'/\'\'.\'\'WGbordered\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'dashed\'\'#\'\'BECEF8\'\'2px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'10px\'\';\'\'}\'\'.\'\'WGfriendpic\'\'{\'\'border\'\':\'\'solid\'\'#\'\'BECEF8\'\'1px\'\';\'\'}\'\'.\'\'WGinvitemsg\'\'{\'\'width\'\':\'\'600px\'\';\'\'height\'\':\'\'150px\'\';\'\'}\'\'ol\'\'.\'\'WGProfile_interests\'\'{\'\'color\'\':\'\'#\'\'0B2259\'\';\'\'font\'\'-\'\'size\'\':\'\'15px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'list\'\'-\'\'style\'\'-\'\'type\'\':\'\'none\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'padding\'\':\'\'5px\'\'5px\'\';\'\'}\'\'ol\'\'.\'\'WGProfile_interests\'\'li\'\'{\'\'margin\'\'-\'\'bottom\'\':\'\'15px\'\';\'\'}\'\'ol\'\'.\'\'WGProfile_interests\'\'span\'\'{\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'WGpBio\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'DDE6FB\'\'1px\'\';\'\'margin\'\':\'\'0px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'}\'\'.\'\'WGpBio\'\'div\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'DDE6FB\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'2px\'\';\'\'}\'\'.\'\'WGprogram\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'}\'\'/\'\'*\'\'contributions\'\'*\'\'/\'\'.\'\'WGContribCount\'\'{\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'padding\'\':\'\'3px\'\'}\'\'.\'\'WGContribTitle\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'0B2259\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'3px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'text\'\'-\'\'decoration\'\':\'\'underline\'\';\'\'}\'\'.\'\'WGContribTitleLeft\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'0B2259\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'3px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'text\'\'-\'\'decoration\'\':\'\'underline\'\';\'\'}\'\'.\'\'WGContribEntry\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'padding\'\':\'\'3px\'\';\'\'}\'\'.\'\'WGContribEntryLeft\'\'{\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'padding\'\':\'\'3px\'\';\'\'}\'\'/\'\'*\'\'edit\'\'box\'\'*\'\'/\'\'.\'\'WGeditBox\'\'{\'\'/\'\'*\'\'background\'\':\'\'white\'\'url\'\'(\'\'images\'\'/\'\'edit_box_bg\'\'.\'\'jpg\'\')\'\'no\'\'-\'\'repeat\'\'bottom\'\'left\'\';\'\'*\'\'/\'\'border\'\':\'\'solid\'\'#\'\'8DABF1\'\'2px\'\';\'\'display\'\':\'\'block\'\';\'\'font\'\'-\'\'family\'\':\'\'verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'left\'\':\'\'100px\'\';\'\'-\'\'moz\'\'-\'\'box\'\'-\'\'sizing\'\':\'\'border\'\'-\'\'box\'\';\'\'padding\'\':\'\'5px\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'100px\'\';\'\'width\'\':\'\'590px\'\';\'\'z\'\'-\'\'index\'\':\'\'100\'\';\'\'}\'\'.\'\'WGeditBox\'\'input\'\',\'\'.\'\'WGeditBox\'\'select\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'}\'\'/\'\'*\'\'friends\'\'*\'\'/\'\'.\'\'WGfriends_name\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'width\'\':\'\'90\'\'%\'\';\'\'}\'\'.\'\'WGfriends_photo\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'width\'\':\'\'10\'\'%\'\';\'\'}\'\'.\'\'WGfriends_photo\'\'img\'\'{\'\'height\'\':\'\'50px\'\';\'\'width\'\':\'\'50px\'\';\'\'}\'\'.\'\'WGfriends_private\'\'{\'\'float\'\':\'\'right\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'width\'\':\'\'50\'\'%\'\';\'\'}\'\'.\'\'WGfriends_ninety\'\'{\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'width\'\':\'\'90\'\'%\'\';\'\'}\'\'.\'\'WGfriends_seventy\'\'{\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'width\'\':\'\'70\'\'%\'\';\'\'}\'\'.\'\'WGfriends_ten\'\'{\'\'width\'\':\'\'10\'\'%\'\';\'\'}\'\'.\'\'WGfriends_ten\'\'img\'\'{\'\'height\'\':\'\'50px\'\';\'\'width\'\':\'\'50px\'\';\'\'}\'\'.\'\'WGfriends_twenty\'\'{\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGaccepts\'\'{\'\'padding\'\'-\'\'bottom\'\':\'\'5px\'\';\'\'}\'\'/\'\'*\'\'inbox\'\'*\'\'/\'\'.\'\'WGProfile_msgcontainer\'\'{\'\'padding\'\':\'\'2px\'\';\'\'}\'\'.\'\'WGinbox_count\'\'{\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\':\'\'3px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'.\'\'WGinbox_errors\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'color\'\':\'\'red\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WG_inbox_InviteLabel\'\'{\'\'width\'\':\'\'50px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'}\'\'.\'\'WG_inbox_InviteLabelView\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'width\'\':\'\'120px\'\';\'\'}\'\'.\'\'WGmsgcontainer\'\'{\'\'padding\'\':\'\'6px\'\';\'\'display\'\':\'\'block\'\';\'\'margin\'\'-\'\'bottom\'\':\'\'6px\'\';\'\'}\'\'/\'\'*\'\'inbox\'\'contacts\'\'*\'\'/\'\'.\'\'WGdatacells\'\'{\'\'border\'\'-\'\'bottom\'\':\'\'dashed\'\'#\'\'BECEF8\'\'1px\'\';\'\'}\'\'.\'\'WGinbox_contactsTbl\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'EEF2FD\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'#\'\'contacts\'\'{\'\'height\'\':\'\'275px\'\';\'\'overflow\'\':\'\'auto\'\';\'\'}\'\'/\'\'*\'\'inbox\'\'forms\'\'*\'\'/\'\'.\'\'WGbuttons_left\'\'{\'\'float\'\':\'\'left\'\';\'\'}\'\'.\'\'WGbuttons_right\'\'{\'\'float\'\':\'\'right\'\';\'\'}\'\'.\'\'WGinbox_from\'\'{\'\'color\'\':\'\'black\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'WGinbox_subject\'\'{\'\'width\'\':\'\'530px\'\';\'\'}\'\'.\'\'WGinbox_messageTo\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'border\'\':\'\'solid\'\'#\'\'BECEF8\'\'1px\'\';\'\'height\'\':\'\'50px\'\';\'\'overflow\'\':\'\'-\'\'moz\'\'-\'\'scrollbars\'\'-\'\'vertical\'\';\'\'overflow\'\'-\'\'x\'\':\'\'hidden\'\';\'\'overflow\'\'-\'\'y\'\':\'\'scroll\'\';\'\'width\'\':\'\'530px\'\';\'\'}\'\'/\'\'*\'\'inbox\'\'pagination\'\'*\'\'/\'\'.\'\'WGinbox_buttons\'\'{\'\'display\'\':\'\'inline\'\';\'\'float\'\':\'\'left\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'width\'\':\'\'70\'\'%\'\';\'\'}\'\'.\'\'WGinbox_pagination\'\'{\'\'display\'\':\'\'inline\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGinbox_messagerpp\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'display\'\':\'\'inline\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGmessage\'\'{\'\'display\'\':\'\'inline\'\';\'\'float\'\':\'\'left\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'width\'\':\'\'70\'\'%\'\';\'\'}\'\'.\'\'WGmessagerpp\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'display\'\':\'\'inline\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'float\'\':\'\'right\'\';\'\'}\'\'.\'\'WG\'\'-\'\'previous\'\'-\'\'next\'\'{\'\'float\'\':\'\'right\'\';\'\'}\'\'/\'\'*\'\'inbox\'\'threads\'\'*\'\'/\'\'.\'\'WGevenThread\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'e1e8fb\'\';\'\'border\'\'-\'\'bottom\'\':\'\'1px\'\'solid\'\'#\'\'bfcef9\'\';\'\'padding\'\':\'\'8px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGoddThread\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'eef2fd\'\';\'\'border\'\'-\'\'bottom\'\':\'\'1px\'\'solid\'\'#\'\'bfcef9\'\';\'\'padding\'\':\'\'8px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'/\'\'*\'\'pagination\'\'*\'\'/\'\'.\'\'WGProfile_pagination\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGProfile_messagerpp\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'display\'\':\'\'inline\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGProfile_paginationLeft\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGProfile_paginationCenter\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'width\'\':\'\'20\'\'%\'\';\'\'}\'\'.\'\'WGProfile_pagination\'\'a\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'bfc8dc\'\'1px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\':\'\'1px\'\'5px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'WGProfile_pagination\'\'a\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'d8dee8\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'.\'\'WGProfile_pagination\'\'.\'\'prevNext\'\'{\'\'background\'\'-\'\'color\'\':\'\'transparent\'\';\'\'border\'\':\'\'none\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'WGProfile_pagination\'\'.\'\'prevNext\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'transparent\'\';\'\'border\'\':\'\'none\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'WGProfile_pagination\'\'.\'\'active\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'d8dee8\'\';\'\'border\'\':\'\'solid\'\'#\'\'bfc8dc\'\'1px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\':\'\'1px\'\'5px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'WGProfile_pagination\'\'img\'\'{\'\'vertical\'\'-\'\'align\'\':\'\'middle\'\';\'\'margin\'\'-\'\'top\'\':\'\'2px\'\';\'\'border\'\':\'\'none\'\';\'\'}\'\'/\'\'*\'\'profile\'\'*\'\'/\'\'.\'\'WGProfile_registration\'\'{\'\'background\'\':\'\'none\'\';\'\'border\'\':\'\'none\'\';\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'font\'\'-\'\'family\'\':\'\'arial\'\';\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'header\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'818997\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'header\'\'a\'\'{\'\'color\'\':\'\'white\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'help\'\'a\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'inputText\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'margin\'\'-\'\'right\'\':\'\'1px\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'label\'\'{\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'white\'\'-\'\'space\'\':\'\'nowrap\'\';\'\'width\'\':\'\'1\'\'%\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'labelLeft\'\'{\'\'font\'\'-\'\'size\'\':\'\'9pt\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'white\'\'-\'\'space\'\':\'\'nowrap\'\';\'\'width\'\':\'\'1\'\'%\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'smallLabel\'\'{\'\'font\'\'-\'\'size\'\':\'\'8px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'smallText\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'}\'\'.\'\'WGinboxTbl\'\'{\'\'display\'\':\'\'block\'\';\'\'margin\'\':\'\'4px\'\';\'\'padding\'\':\'\'2px\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'bar\'\',\'\'.\'\'WGProfile_registration\'\'.\'\'barRight\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'margin\'\':\'\'10px\'\'0px\'\'10px\'\'0px\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'4px\'\'4px\'\'0px\'\'4px\'\';\'\'vertical\'\'-\'\'align\'\':\'\'middle\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'bar\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'barRight\'\'{\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'bar\'\'a\'\'{\'\'color\'\':\'\'#\'\'0B2259\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'barFive\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'margin\'\'-\'\'right\'\':\'\'3px\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'2px\'\';\'\'width\'\':\'\'4\'\'.\'\'3\'\'%\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'barTen\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'2px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'width\'\':\'\'7\'\'.\'\'2\'\'%\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'barFifteen\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'margin\'\'-\'\'right\'\':\'\'3px\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'2px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'width\'\':\'\'15\'\'%\'\';\'\'}\'\'.\'\'WGProfile_registration\'\'.\'\'barFifty\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'margin\'\'-\'\'right\'\':\'\'3px\'\';\'\'min\'\'-\'\'height\'\':\'\'25px\'\';\'\'padding\'\':\'\'2px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'width\'\':\'\'50\'\'%\'\';\'\'}\'\'.\'\'WGbarContainer\'\'{\'\'display\'\':\'\'block\'\';\'\'margin\'\':\'\'10px\'\'0px\'\'10px\'\'0px\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'/\'\'*\'\'profile\'\'edit\'\'*\'\'/\'\'.\'\'WGfields\'\'{\'\'padding\'\':\'\'2px\'\';\'\'}\'\'.\'\'WGfields_left\'\'{\'\'padding\'\':\'\'2px\'\';\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'width\'\':\'\'15\'\'%\'\';\'\'}\'\'.\'\'WGfields_right\'\'{\'\'display\'\':\'\'inline\'\'float\'\':\'\'right\'\';\'\'padding\'\':\'\'2px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'width\'\':\'\'80\'\'%\'\';\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'}\'\'.\'\'WGProfile\'\'{\'\'display\'\':\'\'table\'\';\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'.\'\'WGProfileFields\'\'{\'\'border\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'margin\'\':\'\'0\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'.\'\'WGProfileFields\'\'ol\'\'{\'\'display\'\':\'\'inline\'\';\'\'list\'\'-\'\'style\'\'-\'\'type\'\':\'\'none\'\';\'\'}\'\'.\'\'WGProfileFields\'\'ul\'\'{\'\'list\'\'-\'\'style\'\'-\'\'type\'\':\'\'none\'\';\'\'display\'\':\'\'inline\'\';\'\'}\'\'.\'\'WGProfileFields\'\'ul\'\'li\'\'{\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'*\'\'display\'\':\'\'inline\'\';\'\'zoom\'\':\'\'1\'\';\'\'}\'\'/\'\'*\'\'profile\'\'view\'\'*\'\'/\'\'.\'\'WGProfile_accepts\'\'{\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'background\'\'-\'\'color\'\':\'\'gray\'\';\'\'padding\'\':\'\'4px\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'.\'\'WGviewContainer\'\'{\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'width\'\':\'\'90\'\'%\'\';\'\'}\'\'.\'\'WGinternational\'\'{\'\'background\'\'-\'\'color\'\':\'\'red\'\';\'\'color\'\':\'\'white\'\';\'\'display\'\':\'\'inline\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\':\'\'4px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGcategoryLabel\'\'{\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'width\'\':\'\'90\'\'%\'\';\'\'}\'\'.\'\'WGprivateMessage\'\'{\'\'background\'\'-\'\'color\'\':\'\'gray\'\';\'\'padding\'\':\'\'4px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'}\'\'.\'\'WGprofileAlert\'\'{\'\'background\'\'-\'\'color\'\':\'\'red\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'padding\'\':\'\'4px\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'}\'\'WGprofilePhoto\'\'{\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'}\'\'/\'\'*\'\'profile\'\'errors\'\'*\'\'/\'\'#\'\'WGprofileErrors\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'ff0000\'\';\'\'color\'\':\'\'#\'\'ffffff\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'.\'\'WGprofilefield_required_off\'\'{\'\'}\'\'.\'\'WGprofilefield_required\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'ffd6bb\'\';\'\'}\'\'.\'\'WGprofilefield_error\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'FF9494\'\';\'\'}\'\'.\'\'WGerrorMsg\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'color\'\':\'\'red\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'}\'\'/\'\'*\'\'user\'\'*\'\'/\'\'.\'\'WGuserInvite_subject\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'border\'\':\'\'solid\'\'#\'\'BECEF8\'\'1px\'\';\'\'height\'\':\'\'25px\'\';\'\'text\'\'-\'\'align\'\':\'\'left\'\';\'\'width\'\':\'\'500px\'\';\'\'/\'\'*\'\'margin\'\'-\'\'left\'\':\'\'50px\'\';\'\'*\'\'/\'\'/\'\'*\'\'margin\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'*\'\'/\'\'/\'\'*\'\'overflow\'\':\'\'-\'\'moz\'\'-\'\'scrollbars\'\'-\'\'vertical\'\';\'\'overflow\'\'-\'\'x\'\':\'\'hidden\'\';\'\'overflow\'\'-\'\'y\'\':\'\'scroll\'\';\'\'*\'\'/\'\'}\'\'/\'\'*\'\'view\'\'profile\'\'*\'\'/\'\'.\'\'WGprofile_canEdit\'\'{\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'background\'\'-\'\'color\'\':\'\'red\'\';\'\'padding\'\':\'\'4px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'WGprofile_fieldLabel\'\'{\'\'background\'\':\'\'#\'\'DDE6FB\'\';\'\'padding\'\':\'\'2px\'\';\'\'width\'\':\'\'200px\'\';\'\'}\'\'.\'\'WGprofile_fieldData\'\'{\'\'margin\'\'-\'\'left\'\':\'\'5px\'\';\'\'}\'\'.\'\'WGprofile_fieldStatus\'\'{\'\'padding\'\':\'\'4px\'\';\'\'color\'\':\'\'white\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\'}\'\'/\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'/\'\'/\'\'*\'\'TABS\'\'*\'\'/\'\'/\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'*\'\'/\'\'/\'\'*\'\'TABS\'\'-\'\'outer\'\'*\'\'/\'\'.\'\'WGbottombutton\'\'{\'\'float\'\':\'\'right\'\';\'\'padding\'\'-\'\'right\'\':\'\'2px\'\';\'\'padding\'\'-\'\'top\'\':\'\'2px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'.\'\'WGcontent\'\'{\'\'padding\'\':\'\'10px\'\';\'\'}\'\'.\'\'WGcleartab\'\'{\'\'clear\'\':\'\'both\'\';\'\'height\'\':\'\'0\'\';\'\'}\'\'.\'\'WGsubContent\'\'{\'\'/\'\'*\'\'color\'\'setting\'\'for\'\'border\'\'under\'\'outer\'\'tabs\'\'that\'\'surrounds\'\'inner\'\'tabs\'\'*\'\'/\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'6px\'\';\'\'}\'\'.\'\'WGtopbutton\'\'{\'\'float\'\':\'\'right\'\';\'\'clear\'\':\'\'both\'\';\'\'padding\'\'-\'\'right\'\':\'\'2px\'\';\'\'padding\'\'-\'\'top\'\':\'\'2px\'\';\'\'position\'\':\'\'relative\'\';\'\'}\'\'ul\'\'.\'\'WGtopTabs\'\',\'\'ul\'\'.\'\'WGtopTabs\'\'li\'\'{\'\'list\'\'-\'\'style\'\'-\'\'type\'\':\'\'none\'\';\'\'margin\'\':\'\'10px\'\'0px\'\'0px\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'position\'\':\'\'relative\'\';\'\'width\'\':\'\'auto\'\';\'\'Xposition\'\':\'\'relative\'\';\'\'zoom\'\':\'\'1\'\';\'\'}\'\'ul\'\'.\'\'WGtopTabs\'\'li\'\'{\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'margin\'\'-\'\'right\'\':\'\'3px\'\';\'\'}\'\'ul\'\'.\'\'WGtopTabs\'\'li\'\'b\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'eef2fd\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'display\'\':\'\'block\'\';\'\'padding\'\':\'\'4px\'\'8px\'\';\'\'position\'\':\'\'relative\'\';\'\'top\'\':\'\'-\'\'1px\'\';\'\'}\'\'ul\'\'.\'\'WGtopTabs\'\'a\'\'{\'\'/\'\'*\'\'non\'\'-\'\'selected\'\'tabs\'\'color\'\'settings\'\'*\'\'/\'\'display\'\':\'\'block\'\';\'\'color\'\':\'\'#\'\'9ea0bb\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'family\'\':\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f2f5fa\'\';\'\'border\'\'-\'\'left\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'#\'\'d8dee8\'\'1px\'\';\'\'}\'\'ul\'\'.\'\'WGtopTabs\'\'a\'\':\'\'hover\'\',\'\'ul\'\'.\'\'WGtopTabs\'\'a\'\':\'\'hover\'\'b\'\',\'\'ul\'\'.\'\'WGtopTabs\'\'a\'\'.\'\'selected\'\',\'\'ul\'\'.\'\'WGtopTabs\'\'a\'\'.\'\'selected\'\'b\'\'{\'\'/\'\'*\'\'selected\'\'tab\'\'color\'\'settings\'\'*\'\'/\'\'background\'\'-\'\'color\'\':\'\'#\'\'d8dee8\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'}\'\'/\'\'*\'\'TABS\'\'-\'\'YUI\'\'*\'\'/\'\'.\'\'WGcleardiv\'\'{\'\'clear\'\':\'\'both\'\';\'\'margin\'\':\'\'0px\'\'0px\'\'0px\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'}\'\'.\'\'WGview\'\'{\'\'border\'\':\'\'none\'\';\'\'font\'\':\'\'bold\'\'10px\'\'Verdana\'\';\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'position\'\':\'\'absolute\'\';\'\'right\'\':\'\'4px\'\';\'\'top\'\':\'\'4px\'\';\'\'}\'\'.\'\'WGprofile_displayView\'\'{\'\'-\'\'x\'\'-\'\'system\'\'-\'\'font\'\':\'\'none\'\';\'\'border\'\':\'\'medium\'\'none\'\';\'\'color\'\':\'\'#\'\'0B2258\'\';\'\'display\'\':\'\'inline\'\';\'\'float\'\':\'\'right\'\';\'\'font\'\'-\'\'family\'\':\'\'Verdana\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'font\'\'-\'\'size\'\'-\'\'adjust\'\':\'\'none\'\';\'\'font\'\'-\'\'stretch\'\':\'\'normal\'\';\'\'font\'\'-\'\'style\'\':\'\'normal\'\';\'\'font\'\'-\'\'variant\'\':\'\'normal\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'line\'\'-\'\'height\'\':\'\'normal\'\';\'\'padding\'\'-\'\'right\'\':\'\'8px\'\';\'\'padding\'\'-\'\'top\'\':\'\'3px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'.\'\'WGprofile_displaySubContent\'\'{\'\'/\'\'*\'\'border\'\'around\'\'friends\'\'tab\'\'content\'\'*\'\'/\'\'border\'\':\'\'solid\'\'#\'\'d8dee8\'\'6px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'d8dee8\'\'18px\'\';\'\'}\'\'/\'\'*\'\'Copyright\'\'(\'\'c\'\')\'\'2008\'\',\'\'Yahoo\'\'!\'\'Inc\'\'.\'\'All\'\'rights\'\'reserved\'\'.\'\'Code\'\'licensed\'\'under\'\'the\'\'BSD\'\'License\'\':\'\'http\'\':\'\'/\'\'/\'\'developer\'\'.\'\'yahoo\'\'.\'\'net\'\'/\'\'yui\'\'/\'\'license\'\'.\'\'txt\'\'version\'\':\'\'2\'\'.\'\'6\'\'.\'\'0\'\'*\'\'/\'\'/\'\'*\'\'yui\'\'tabs\'\'color\'\'settings\'\'below\'\'*\'\'/\'\'/\'\'*\'\'.\'\'yui\'\'-\'\'navset\'\'defaults\'\'to\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'*\'\'/\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'/\'\'*\'\'protect\'\'nested\'\'tabviews\'\'from\'\'other\'\'orientations\'\'*\'\'/\'\'border\'\':\'\'solid\'\'#\'\'eef2fd\'\';\'\'/\'\'*\'\'color\'\'between\'\'tab\'\'list\'\'and\'\'content\'\'*\'\'/\'\'border\'\'-\'\'width\'\':\'\'0\'\'0\'\'5px\'\';\'\'Xposition\'\':\'\'relative\'\';\'\'zoom\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'{\'\'background\'\':\'\'#\'\'ffffff\'\';\'\'/\'\'*\'\'tab\'\'background\'\'*\'\'/\'\'border\'\':\'\'solid\'\'#\'\'ffffff\'\';\'\'border\'\'-\'\'width\'\':\'\'0\'\'1px\'\';\'\'color\'\':\'\'#\'\'bfccdd\'\';\'\'position\'\':\'\'relative\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'family\'\':\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\'{\'\'border\'\':\'\'solid\'\'#\'\'eef2fd\'\';\'\'border\'\'-\'\'width\'\':\'\'1px\'\'0\'\'0\'\';\'\'cursor\'\':\'\'hand\'\';\'\'padding\'\':\'\'0\'\'.\'\'25em\'\'.\'\'75em\'\';\'\'left\'\':\'\'0\'\';\'\'right\'\':\'\'0\'\';\'\'bottom\'\':\'\'0\'\';\'\'/\'\'*\'\'protect\'\'from\'\'other\'\'orientations\'\'*\'\'/\'\'top\'\':\'\'-\'\'1px\'\';\'\'/\'\'*\'\'for\'\'1px\'\'rounded\'\'corners\'\'*\'\'/\'\'position\'\':\'\'relative\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\':\'\'focus\'\',\'\'/\'\'*\'\'no\'\'focus\'\'effect\'\'for\'\'selected\'\'*\'\'/\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\':\'\'hover\'\'{\'\'/\'\'*\'\'no\'\'hover\'\'effect\'\'for\'\'selected\'\'*\'\'/\'\'background\'\':\'\'#\'\'eef2fd\'\';\'\'/\'\'*\'\'selected\'\'tab\'\'background\'\'*\'\'/\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'family\'\':\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\'em\'\'{\'\'border\'\'-\'\'color\'\':\'\'#\'\'eef2fd\'\';\'\'/\'\'*\'\'selected\'\'tab\'\'border\'\'color\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'focus\'\'{\'\'background\'\':\'\'#\'\'eef2fd\'\';\'\'/\'\'*\'\'hover\'\'tab\'\'background\'\'*\'\'/\'\'color\'\':\'\'#\'\'3e4f77\'\';\'\'outline\'\':\'\'0\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'font\'\'-\'\'family\'\':\'\'Arial\'\',\'\'Helvetica\'\',\'\'sans\'\'-\'\'serif\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'content\'\'{\'\'background\'\':\'\'#\'\'eef2fd\'\';\'\'/\'\'*\'\'content\'\'background\'\'color\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'content\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'content\'\'{\'\'border\'\':\'\'5px\'\'solid\'\'#\'\'eef2fd\'\';\'\'/\'\'*\'\'content\'\'border\'\'*\'\'/\'\'padding\'\':\'\'0\'\'.\'\'75em\'\'1em\'\';\'\'/\'\'*\'\'content\'\'padding\'\'*\'\'/\'\'}\'\'/\'\'*\'\'left\'\'and\'\'right\'\'orientations\'\'*\'\'/\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'5px\'\'0\'\'0\'\';\'\'Xposition\'\':\'\'absolute\'\';\'\'/\'\'*\'\'from\'\'tabview\'\'-\'\'core\'\';\'\'have\'\'to\'\'reiterate\'\'for\'\'skin\'\'-\'\'sam\'\'due\'\'to\'\'pos\'\':\'\'rel\'\'on\'\'skin\'\'-\'\'sam\'\'yui\'\'-\'\'nav\'\'*\'\'/\'\'top\'\':\'\'0\'\';\'\'bottom\'\':\'\'0\'\';\'\'/\'\'*\'\'stretch\'\'to\'\'fill\'\'content\'\'height\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'0\'\'0\'\'5px\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'margin\'\':\'\'0\'\'0\'\'0\'\'.\'\'3em\'\';\'\'/\'\'*\'\'space\'\'between\'\'tabs\'\'*\'\'/\'\'padding\'\':\'\'0\'\'0\'\'0\'\'1px\'\';\'\'/\'\'*\'\'gecko\'\':\'\'make\'\'room\'\'for\'\'overflow\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'padding\'\':\'\'0\'\'1px\'\'0\'\'0\'\';\'\'/\'\'*\'\'gecko\'\':\'\'make\'\'room\'\'for\'\'overflow\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'{\'\'margin\'\':\'\'0\'\'-\'\'1px\'\'0\'\'.\'\'16em\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'{\'\'margin\'\':\'\'0\'\'0\'\'0\'\'.\'\'16em\'\'-\'\'1px\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'{\'\'border\'\'-\'\'width\'\':\'\'1px\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'0\'\'0\'\'1px\'\';\'\'padding\'\':\'\'0\'\'.\'\'2em\'\'.\'\'75em\'\';\'\'top\'\':\'\'auto\'\';\'\'left\'\':\'\'-\'\'1px\'\';\'\'/\'\'*\'\'for\'\'1px\'\'rounded\'\'corners\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'1px\'\'0\'\'0\'\';\'\'left\'\':\'\'auto\'\';\'\'right\'\':\'\'-\'\'1px\'\';\'\'/\'\'*\'\'for\'\'1px\'\'rounded\'\'corners\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\'{\'\'background\'\'-\'\'image\'\':\'\'none\'\';\'\'/\'\'*\'\'no\'\'left\'\'-\'\'right\'\'or\'\'bottom\'\'-\'\'top\'\'gradient\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'content\'\'{\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'d8dee8\'\';\'\'/\'\'*\'\'content\'\'border\'\'*\'\'/\'\'}\'\'/\'\'*\'\'bottom\'\'orientation\'\'*\'\'/\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'border\'\'-\'\'width\'\':\'\'5px\'\'0\'\'0\'\';\'\'/\'\'*\'\'color\'\'between\'\'tab\'\'list\'\'and\'\'content\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'{\'\'margin\'\':\'\'-\'\'1px\'\'0\'\'.\'\'3em\'\'0\'\'0\'\';\'\'/\'\'*\'\'for\'\'overlap\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'padding\'\':\'\'0\'\'0\'\'1px\'\'0\'\';\'\'/\'\'*\'\'gecko\'\':\'\'make\'\'room\'\'for\'\'overflow\'\'*\'\'/\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'{\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'0\'\'1px\'\';\'\'top\'\':\'\'auto\'\';\'\'bottom\'\':\'\'-\'\'1px\'\';\'\'/\'\'*\'\'for\'\'1px\'\'rounded\'\'corners\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'content\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'content\'\'{\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'f2f5fa\'\';\'\'/\'\'*\'\'content\'\'border\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'d8dee8\'\';\'\'padding\'\':\'\'10px\'\'5\'\'5\'\'5px\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'/\'\'*\'\'yui\'\'tab\'\'placement\'\'settings\'\'below\'\'*\'\'/\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'margin\'\':\'\'0\'\'0\'\'.\'\'3em\'\'0\'\'0\'\';\'\'/\'\'*\'\'space\'\'between\'\'tabs\'\'*\'\'/\'\'padding\'\':\'\'5px\'\'0\'\'0\'\';\'\'/\'\'*\'\'gecko\'\':\'\'make\'\'room\'\'for\'\'overflow\'\'*\'\'/\'\'zoom\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'{\'\'margin\'\':\'\'0\'\'0\'\'.\'\'3em\'\'-\'\'1px\'\'0\'\';\'\'/\'\'*\'\'for\'\'overlap\'\'*\'\'/\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'margin\'\':\'\'0\'\'0\'\'.\'\'5em\'\'0\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'margin\'\':\'\'0\'\'0\'\'0\'\'.\'\'5em\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'content\'\'.\'\'yui\'\'-\'\'hidden\'\'{\'\'display\'\':\'\'none\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'width\'\':\'\'6em\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'width\'\':\'\'auto\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'{\'\'padding\'\':\'\'0\'\'0\'\'0\'\'6em\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'{\'\'padding\'\':\'\'0\'\'6em\'\'0\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'{\'\'padding\'\':\'\'auto\'\';\'\'}\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'list\'\'-\'\'style\'\':\'\'none\'\';\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'li\'\'em\'\'{\'\'font\'\'-\'\'style\'\':\'\'normal\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'{\'\'position\'\':\'\'relative\'\';\'\'zoom\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'content\'\'{\'\'zoom\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'display\'\':\'\'-\'\'moz\'\'-\'\'inline\'\'-\'\'stack\'\';\'\'*\'\'display\'\':\'\'inline\'\';\'\'vertical\'\'-\'\'align\'\':\'\'bottom\'\';\'\'cursor\'\':\'\'pointer\'\';\'\'zoom\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'{\'\'position\'\':\'\'relative\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'display\'\':\'\'inline\'\'-\'\'block\'\';\'\'vertical\'\'-\'\'align\'\':\'\'bottom\'\';\'\'zoom\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'{\'\'vertical\'\'-\'\'align\'\':\'\'text\'\'-\'\'top\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'a\'\'em\'\'{\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'position\'\':\'\'absolute\'\';\'\'z\'\'-\'\'index\'\':\'\'1\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'top\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'position\'\':\'\'static\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'left\'\':\'\'0\'\';\'\'right\'\':\'\'auto\'\';\'\'}\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'left\'\':\'\'auto\'\';\'\'right\'\':\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\'em\'\'{\'\'padding\'\':\'\'0\'\'.\'\'35em\'\'0\'\'.\'\'75em\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'5px\'\'0\'\'0\'\';\'\'bottom\'\':\'\'0\'\';\'\'top\'\':\'\'0\'\';\'\'Xposition\'\':\'\'absolute\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'0\'\'0\'\'5px\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'margin\'\':\'\'0\'\'0\'\'0\'\'.\'\'16em\'\';\'\'padding\'\':\'\'0\'\'0\'\'0\'\'1px\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'padding\'\':\'\'0\'\'1px\'\'0\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'{\'\'border\'\'-\'\'width\'\':\'\'1px\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'0\'\'0\'\'1px\'\';\'\'left\'\':\'\'-\'\'1px\'\';\'\'padding\'\':\'\'0\'\'.\'\'2em\'\'.\'\'75em\'\';\'\'top\'\':\'\'auto\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\'em\'\'{\'\'border\'\'-\'\'width\'\':\'\'0\'\'1px\'\'0\'\'0\'\';\'\'left\'\':\'\'auto\'\';\'\'right\'\':\'\'-\'\'1px\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'left\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'right\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'a\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'a\'\':\'\'hover\'\'{\'\'background\'\'-\'\'image\'\':\'\'none\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'.\'\'selected\'\'{\'\'margin\'\':\'\'-\'\'1px\'\'0\'\'.\'\'16em\'\'0\'\'0\'\';\'\'}\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\',\'\'.\'\'yui\'\'-\'\'skin\'\'-\'\'sam\'\'.\'\'yui\'\'-\'\'navset\'\'-\'\'bottom\'\'.\'\'yui\'\'-\'\'nav\'\'li\'\'{\'\'padding\'\':\'\'0\'\'0\'\'1px\'\'0\'\';\'\'vertical\'\'-\'\'align\'\':\'\'top\'\';\'\'}','000001000001000001000008'),('hkj6WeChxFyqfP85UlRP8w','matrix.css','matrix.css matrix.css  new matrix matrix.css ','new-matrix/matrix.css',1232664229,1239898573,'3','7','12','WebGUI::Asset::Snippet',1,'matrix\'\'.\'\'css\'\'matrix\'\'.\'\'css\'\'new\'\'matrix\'\'matrix\'\'.\'\'css .\'\'wg\'\'-\'\'clear\'\'{\'\'display\'\':\'\'inline\'\';\'\'clear\'\':\'\'both\'\';\'\'font\'\'-\'\'size\'\':\'\'0px\'\';\'\'line\'\'-\'\'height\'\':\'\'0px\'\';\'\'}\'\'/\'\'*\'\'COLUMN\'\'STYLES\'\'*\'\'/\'\'#\'\'matrixLeft\'\'{\'\'float\'\':\'\'left\'\';\'\'width\'\':\'\'65\'\'%\'\';\'\'padding\'\':\'\'1\'\'%\'\';\'\'min\'\'-\'\'height\'\':\'\'1\'\'%\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'d2d2d2\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'}\'\'#\'\'matrixRight\'\'{\'\'float\'\':\'\'left\'\';\'\'width\'\':\'\'25\'\'%\'\';\'\'padding\'\':\'\'0px\'\';\'\'min\'\'-\'\'height\'\':\'\'1\'\'%\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'border\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'margin\'\'-\'\'left\'\':\'\'5px\'\';\'\'}\'\'/\'\'*\'\'DROPSHADOW\'\'BUTTONS\'\'*\'\'/\'\'#\'\'matrixLeft\'\'.\'\'buttons\'\'span\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'888\'\';\'\'position\'\':\'\'relative\'\';\'\'padding\'\':\'\'5px\'\'0px\'\'0px\'\'0px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'buttons\'\'button\'\',\'\'#\'\'matrixLeft\'\'.\'\'buttons\'\'a\'\'#\'\'return\'\'{\'\'border\'\':\'\'solid\'\'#\'\'2f495e\'\'2px\'\';\'\'position\'\':\'\'relative\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'e1e1e1\'\';\'\'padding\'\':\'\'auto\'\'3px\'\';\'\'margin\'\':\'\'0px\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'line\'\'-\'\'height\'\':\'\'13px\'\';\'\'position\'\':\'\'relative\'\';\'\'top\'\':\'\'-\'\'6px\'\';\'\'left\'\':\'\'-\'\'2px\'\';\'\'height\'\':\'\'22px\'\';\'\'cursor\'\':\'\'pointer\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'color\'\':\'\'#\'\'333\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'buttons\'\'a\'\'#\'\'return\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'padding\'\':\'\'3px\'\'10px\'\'2px\'\'10px\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'buttons\'\'button\'\':\'\'hover\'\',\'\'#\'\'matrixLeft\'\'.\'\'buttons\'\'a\'\'#\'\'return\'\':\'\'hover\'\'{\'\'border\'\'-\'\'color\'\':\'\'black\'\';\'\'color\'\':\'\'white\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'444\'\';\'\'}\'\'/\'\'*\'\'WHITE\'\'AREA\'\'FOR\'\'THE\'\'LISTING\'\'OF\'\'OBJECTS\'\'TO\'\'COMPARE\'\'*\'\'/\'\'#\'\'matrixLeft\'\'.\'\'matrixListing\'\'{\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'_height\'\':\'\'300px\'\';\'\'min\'\'-\'\'height\'\':\'\'300px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'margin\'\':\'\'10px\'\'2px\'\'20px\'\'2px\'\';\'\'padding\'\':\'\'auto\'\'10px\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'matrixListing\'\'table\'\'{\'\'border\'\'-\'\'collapse\'\':\'\'collapse\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'matrixListing\'\'table\'\'a\'\':\'\'link\'\'{\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'color\'\':\'\'#\'\'111\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'matrixListing\'\'table\'\'a\'\':\'\'visited\'\'{\'\'color\'\':\'\'#\'\'333\'\';\'\'font\'\'-\'\'size\'\':\'\'12px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'matrixLeft\'\'.\'\'matrixListing\'\'table\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'/\'\'*\'\'GRAY\'\'BAR\'\'THAT\'\'HOLDS\'\'THE\'\'SORT\'\'BUTTONS\'\'*\'\'/\'\'#\'\'matrixLeft\'\'.\'\'matrixListing\'\'.\'\'sortButtons\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'4px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topRight\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topRight\'\':\'\'4px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'#\'\'D2D2D2\'\'2px\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'/\'\'*\'\'STYLES\'\'TO\'\'OVERRIDE\'\'THE\'\'SORT\'\'BUTTON\'\'CSS\'\'BUILT\'\'INTO\'\'THE\'\'PERL\'\'CODE\'\'*\'\'/\'\'#\'\'sortByViews\'\'-\'\'button\'\',\'\'#\'\'sortByCompares\'\'-\'\'button\'\',\'\'#\'\'sortByUpdated\'\'-\'\'button\'\',\'\'#\'\'sortByClicks\'\'-\'\'button\'\'{\'\'background\'\':\'\'none\'\';\'\'white\'\'-\'\'space\'\':\'\'nowrap\'\';\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'cursor\'\':\'\'pointer\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'4px\'\';\'\'border\'\'-\'\'style\'\':\'\'none\'\';\'\'background\'\'-\'\'color\'\':\'\'transparent\'\';\'\'border\'\'-\'\'right\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'color\'\':\'\'#\'\'555\'\';\'\'}\'\'#\'\'sortByViews\'\'-\'\'button\'\':\'\'hover\'\',\'\'#\'\'sortByCompares\'\'-\'\'button\'\':\'\'hover\'\',\'\'#\'\'sortByUpdated\'\'-\'\'button\'\':\'\'hover\'\',\'\'#\'\'sortByClicks\'\'-\'\'button\'\':\'\'hover\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'/\'\'*\'\'MATRIX\'\'STATISTICS\'\'*\'\'/\'\'#\'\'matrixRight\'\'.\'\'mainTitle\'\'{\'\'font\'\'-\'\'size\'\':\'\'20px\'\';\'\'padding\'\':\'\'5px\'\'10px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'gray\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'d2d2d2\'\';\'\'}\'\'#\'\'matrixRight\'\'.\'\'textBox\'\'{\'\'border\'\'-\'\'top\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'padding\'\':\'\'10px\'\'5px\'\';\'\'}\'\'.\'\'matrixStatistics\'\'{\'\'padding\'\':\'\'10px\'\';\'\'}\'\'.\'\'matrixStatistics\'\'.\'\'title\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'border\'\':\'\'solid\'\'#\'\'d2d2d2\'\'1px\'\';\'\'}\'\'.\'\'matrixStatistics\'\'.\'\'statistics\'\'{\'\'margin\'\'-\'\'bottom\'\':\'\'15px\'\';\'\'}\'\'.\'\'matrixStatistics\'\'.\'\'label\'\'{\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'width\'\':\'\'100px\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'}\'\'.\'\'matrixStatistics\'\'.\'\'data\'\'{\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'}\'\'.\'\'matrixStatistics\'\'.\'\'data\'\'a\'\'{\'\'color\'\':\'\'#\'\'111\'\';\'\'}\'\'.\'\'matrixStatistics\'\'.\'\'data\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'/\'\'*\'\'LINKS\'\'TO\'\'CONTROL\'\'ADMIN\'\'FUNCTIONS\'\'*\'\'/\'\'.\'\'adminLinks\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'}\'\'.\'\'adminLinks\'\'a\'\':\'\'link\'\',\'\'.\'\'adminLinks\'\'a\'\':\'\'visited\'\'{\'\'display\'\':\'\'block\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'color\'\':\'\'#\'\'555\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'}\'\'.\'\'adminLinks\'\'a\'\':\'\'hover\'\'{\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'adminLinks\'\'a\'\'.\'\'newLink\'\':\'\'link\'\',\'\'.\'\'adminLinks\'\'a\'\'.\'\'newLink\'\':\'\'visited\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'3498d1\'\';\'\'color\'\':\'\'white\'\';\'\'display\'\':\'\'block\'\';\'\'}\'\'.\'\'adminLinks\'\'a\'\'.\'\'newLink\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'39a6e5\'\';\'\'}\'\'/\'\'*\'\'STYLE\'\'FOR\'\'THE\'\'DETAILED\'\'LISTING\'\'*\'\'/\'\'#\'\'matrixDetail\'\'{\'\'min\'\'-\'\'width\'\':\'\'1000px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'editBtns\'\'{\'\'font\'\'-\'\'size\'\':\'\'9px\'\';\'\'line\'\'-\'\'height\'\':\'\'11px\'\';\'\'vertical\'\'-\'\'align\'\':\'\'middle\'\';\'\'font\'\'-\'\'weight\'\':\'\'normal\'\';\'\'margin\'\'-\'\'left\'\':\'\'10px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'editBtns\'\'a\'\'{\'\'color\'\':\'\'black\'\';\'\'text\'\'-\'\'decoration\'\':\'\'underline\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'editBtns\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'stats\'\'.\'\'screenshot\'\'{\'\'float\'\':\'\'left\'\';\'\'margin\'\'-\'\'right\'\':\'\'20px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'commentsMail\'\'strong\'\'.\'\'title\'\'{\'\'margin\'\'-\'\'bottom\'\':\'\'0px\'\';\'\'margin\'\'-\'\'top\'\':\'\'20px\'\';\'\'display\'\':\'\'block\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'d2d2d2\'\';\'\'padding\'\':\'\'2px\'\'10px\'\';\'\'border\'\':\'\'solid\'\'1px\'\'gray\'\';\'\'border\'\'-\'\'bottom\'\'-\'\'color\'\':\'\'silver\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'4px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topRight\'\':\'\'4px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'assetAspectComments\'\'{\'\'margin\'\':\'\'0px\'\'0px\'\'20px\'\'0px\'\';\'\'border\'\':\'\'solid\'\'gray\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'bottomLeft\'\':\'\'4px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'bottomRight\'\':\'\'4px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'assetAspectComments\'\'.\'\'assetAspectComment\'\'{\'\'border\'\'-\'\'top\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'gray\'\'1px\'\';\'\'padding\'\':\'\'3px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f5f5f5\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'assetAspectComments\'\'.\'\'assetAspectCommentForm\'\'{\'\'border\'\'-\'\'top\'\':\'\'solid\'\'#\'\'d2d2d2\'\'5px\'\';\'\'padding\'\':\'\'20px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'stats\'\'ul\'\',\'\'#\'\'matrixDetail\'\'.\'\'stats\'\'ul\'\'li\'\'{\'\'list\'\'-\'\'style\'\'-\'\'type\'\':\'\'none\'\';\'\'margin\'\':\'\'0px\'\';\'\'padding\'\':\'\'0px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'stats\'\'ul\'\'li\'\'{\'\'display\'\':\'\'block\'\';\'\'line\'\'-\'\'height\'\':\'\'20px\'\';\'\'margin\'\':\'\'4px\'\'0px\'\';\'\'}\'\'#\'\'matrixDetail\'\'.\'\'stats\'\'ul\'\'li\'\'strong\'\'{\'\'display\'\':\'\'block\'\';\'\'float\'\':\'\'left\'\';\'\'width\'\':\'\'130px\'\';\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'padding\'\'-\'\'right\'\':\'\'5px\'\';\'\'margin\'\'-\'\'right\'\':\'\'5px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'3px\'\';\'\'font\'\'-\'\'size\'\':\'\'11px\'\';\'\'border\'\':\'\'solid\'\'#\'\'d2d2d2\'\'1px\'\';\'\'}\'\'.\'\'showLink\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'e1e1e1\'\';\'\'border\'\':\'\'2px\'\'solid\'\'#\'\'2F495E\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'padding\'\':\'\'3px\'\'10px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'.\'\'showLink\'\':\'\'hover\'\',\'\'.\'\'hideLink\'\':\'\'hover\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'555\'\';\'\'color\'\':\'\'white\'\';\'\'}\'\'.\'\'hideLink\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\':\'\'2px\'\'solid\'\'#\'\'2F495E\'\';\'\'border\'\'-\'\'bottom\'\'-\'\'style\'\':\'\'none\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'4px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topRight\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topRight\'\':\'\'4px\'\';\'\'padding\'\':\'\'3px\'\'10px\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'color\'\':\'\'black\'\';\'\'}\'\'#\'\'matrixMail\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'padding\'\':\'\'15px\'\';\'\'border\'\':\'\'2px\'\'solid\'\'#\'\'2F495E\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'0px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\'-\'\'topLeft\'\':\'\'0px\'\';\'\'margin\'\'-\'\'top\'\':\'\'1px\'\';\'\'}\'\'#\'\'matrixMail\'\'*\'\'.\'\'tableData\'\'{\'\'padding\'\':\'\'5px\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'#\'\'matrixMail\'\'*\'\'input\'\'{\'\'padding\'\':\'\'0px\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'#\'\'matrixMail\'\'*\'\'.\'\'formDescription\'\'{\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'vertical\'\'-\'\'align\'\':\'\'middle\'\';\'\'padding\'\'-\'\'right\'\':\'\'10px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'}\'\'#\'\'matrixMail\'\'form\'\'*\'\'img\'\'{\'\'margin\'\'-\'\'top\'\':\'\'-\'\'18px\'\';\'\'}\'\'#\'\'matrixMail\'\'#\'\'verify_formId\'\'{\'\'height\'\':\'\'45px\'\';\'\'line\'\'-\'\'height\'\':\'\'45px\'\';\'\'font\'\'-\'\'size\'\':\'\'35px\'\';\'\'padding\'\':\'\'0px\'\';\'\'margin\'\':\'\'0px\'\';\'\'margin\'\'-\'\'right\'\':\'\'20px\'\';\'\'}\'\'#\'\'matrixRatings\'\'{\'\'width\'\':\'\'264px\'\';\'\'position\'\':\'\'relative\'\';\'\'left\'\':\'\'-\'\'2px\'\';\'\'top\'\':\'\'12px\'\';\'\'}\'\'#\'\'matrixRatings\'\'table\'\'{\'\'margin\'\'-\'\'left\'\':\'\'0px\'\';\'\'}\'\'#\'\'matrixRatings\'\'td\'\'{\'\'overflow\'\':\'\'hidden\'\';\'\'}\'\'#\'\'matrixRatings\'\'.\'\'formDescription\'\'{\'\'text\'\'-\'\'align\'\':\'\'right\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'97BCD1\'\';\'\'border\'\':\'\'solid\'\'#\'\'4D606B\'\'1px\'\';\'\'padding\'\':\'\'2px\'\'5px\'\';\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'size\'\':\'\'10x\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'color\'\':\'\'#\'\'333\'\';\'\'}\'\'#\'\'matrixRatings\'\'.\'\'formDescription\'\'a\'\':\'\'before\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'matrixRatings\'\'.\'\'formDescription\'\'a\'\'{\'\'display\'\':\'\'block\'\';\'\'color\'\':\'\'red\'\';\'\'text\'\'-\'\'decoration\'\':\'\'none\'\';\'\'}\'\'#\'\'matrixRatings\'\'.\'\'formDescription\'\'a\'\':\'\'hover\'\'{\'\'text\'\'-\'\'decoration\'\':\'\'underline\'\';\'\'}\'\'#\'\'matrixAttributes\'\'{\'\'float\'\':\'\'left\'\';\'\'_width\'\':\'\'40\'\'%\'\';\'\'min\'\'-\'\'width\'\':\'\'20\'\'%\'\';\'\'max\'\'-\'\'width\'\':\'\'45\'\'%\'\';\'\'margin\'\'-\'\'right\'\':\'\'20px\'\';\'\'}\'\'#\'\'rightDetails\'\'{\'\'float\'\':\'\'left\'\';\'\'_width\'\':\'\'20\'\'%\'\';\'\'min\'\'-\'\'width\'\':\'\'20\'\'%\'\';\'\'max\'\'-\'\'width\'\':\'\'45\'\'%\'\';\'\'}\'\'#\'\'attributes\'\'{\'\'border\'\':\'\'solid\'\'#\'\'d2d2d2\'\'1px\'\';\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'margin\'\'-\'\'top\'\':\'\'10px\'\';\'\'-\'\'moz\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'-\'\'webkit\'\'-\'\'border\'\'-\'\'radius\'\':\'\'4px\'\';\'\'padding\'\':\'\'10px\'\';\'\'}\'\'#\'\'attributes\'\'table\'\'{\'\'border\'\'-\'\'collapse\'\':\'\'collapse\'\';\'\'padding\'\':\'\'0px\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'#\'\'attributes\'\'table\'\'*\'\'td\'\'{\'\'padding\'\':\'\'2px\'\';\'\'margin\'\':\'\'0px\'\';\'\'}\'\'.\'\'yui\'\'-\'\'dt0\'\'-\'\'col\'\'-\'\'value\'\'{\'\'font\'\'-\'\'weight\'\':\'\'bold\'\';\'\'font\'\'-\'\'size\'\':\'\'14px\'\';\'\'padding\'\':\'\'3px\'\';\'\'white\'\'-\'\'space\'\':\'\'no\'\'-\'\'wrap\'\';\'\'}\'\'/\'\'*\'\'COMPARISON\'\'STYLES\'\'*\'\'/\'\'#\'\'compareList\'\'table\'\'{\'\'border\'\'-\'\'collapse\'\':\'\'collapse\'\';\'\'border\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'margin\'\'-\'\'top\'\':\'\'5px\'\';\'\'}\'\'#\'\'compareList\'\'table\'\'*\'\'th\'\'a\'\'{\'\'color\'\':\'\'black\'\';\'\'padding\'\':\'\'1px\'\'5px\'\';\'\'}\'\'#\'\'compareList\'\'table\'\'*\'\'td\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'f1f1f1\'\';\'\'border\'\'-\'\'top\'\':\'\'solid\'\'gray\'\'1px\'\';\'\'border\'\'-\'\'bottom\'\':\'\'solid\'\'silver\'\'1px\'\';\'\'}\'\'#\'\'compareList\'\'.\'\'yui\'\'-\'\'dt\'\'-\'\'liner\'\'{\'\'color\'\':\'\'#\'\'39A6E5\'\';\'\'}\'\'#\'\'compareList\'\'.\'\'yui\'\'-\'\'dt\'\'-\'\'col\'\'-\'\'name\'\'.\'\'yui\'\'-\'\'dt\'\'-\'\'liner\'\'{\'\'font\'\'-\'\'style\'\':\'\'italic\'\';\'\'font\'\'-\'\'size\'\':\'\'10px\'\';\'\'color\'\':\'\'#\'\'555\'\';\'\'}\'\'#\'\'compareList\'\'.\'\'yui\'\'-\'\'dt\'\'-\'\'col\'\'-\'\'name\'\'.\'\'yui\'\'-\'\'dt\'\'-\'\'liner\'\'b\'\'{\'\'font\'\'-\'\'size\'\':\'\'15px\'\';\'\'font\'\'-\'\'style\'\':\'\'normal\'\';\'\'padding\'\'-\'\'right\'\':\'\'25px\'\';\'\'color\'\':\'\'black\'\';\'\'}','000001000001000019000006'),('wrq7hMxb1ewQqZ46xmd8Gg','equal-cols.js','equal-cols.js equal-cols.js  matrix equal cols.js ','matrix/equal-cols.js',1235706620,1235706620,'3','7','12','WebGUI::Asset::Snippet',1,'equal\'\'-\'\'cols\'\'.\'\'js\'\'equal\'\'-\'\'cols\'\'.\'\'js\'\'matrix\'\'equal\'\'cols\'\'.\'\'js function\'\'equalCol\'\'(\'\')\'\'{\'\'var\'\'colOne\'\'=\'\'document\'\'.\'\'getElementById\'\'(\'\'\'\'\'compareForm\'\'\'\'\')\'\';\'\'var\'\'colTwo\'\'=\'\'document\'\'.\'\'getElementById\'\'(\'\'\'\'\'matrixRight\'\'\'\'\')\'\';\'\'var\'\'colOneH\'\'=\'\'colOne\'\'.\'\'offsetHeight\'\';\'\'var\'\'colTwoH\'\'=\'\'colTwo\'\'.\'\'offsetHeight\'\';\'\'/\'\'/\'\'alert\'\'(\'\'colOneH\'\'+\'\'\"\'\',\'\'\"\'\'+\'\'colTwoH\'\')\'\';\'\'colOne\'\'.\'\'style\'\'.\'\'overflow\'\'=\'\'\"\'\'scroll\'\'\"\'\';\'\'colOne\'\'.\'\'style\'\'.\'\'height\'\'=\'\'(\'\'colTwoH\'\'-\'\'150\'\')\'\'+\'\'\"\'\'px\'\'\"\'\';\'\'}','000001000001000050'),('matrixtmpl000000000007','Matrix Default Screenshots Config','Matrix Default Screenshots Config Matrix Default Screenshots Config  matrix default screenshots config ','matrix-default-screenshots-config',1236594030,1242662148,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Screenshots\'\'Config\'\'Matrix\'\'Default\'\'Screenshots\'\'Config\'\'matrix\'\'default\'\'screenshots\'\'config Matrix\'\'/\'\'ScreenshotsConfig','000001000001000051'),('matrixtmpl000000000006','Matrix Default Screenshots','Matrix Default Screenshots Matrix Default Screenshots  matrix default screenshots ','matrix-default-screenshots',1236713222,1236713222,'3','7','12','WebGUI::Asset::Template',1,'Matrix\'\'Default\'\'Screenshots\'\'Matrix\'\'Default\'\'Screenshots\'\'matrix\'\'default\'\'screenshots Matrix\'\'/\'\'Screenshots','000001000001000052'),('F2CZVJtKtTs67DWwqDI96g','surveyedit.css','surveyedit.css surveyedit.css  root import survey surveyedit.css ','root/import/survey/surveyedit.css',1244584987,1244584987,'3','7','12','WebGUI::Asset::Snippet',1,'surveyedit\'\'.\'\'css\'\'surveyedit\'\'.\'\'css\'\'root\'\'import\'\'survey\'\'surveyedit\'\'.\'\'css #\'\'loading\'\'-\'\'mask\'\'{\'\'position\'\':\'\'absolute\'\';\'\'left\'\':\'\'0\'\';\'\'top\'\':\'\'0\'\';\'\'width\'\':\'\'100\'\'%\'\';\'\'height\'\':\'\'100\'\'%\'\';\'\'z\'\'-\'\'index\'\':\'\'20000\'\';\'\'background\'\'-\'\'color\'\':\'\'white\'\';\'\'opacity\'\':\'\'0\'\'.\'\'6\'\';\'\'filter\'\':\'\'alpha\'\'(\'\'opacity\'\'=\'\'60\'\')\'\';\'\'}\'\'#\'\'loading\'\'{\'\'position\'\':\'\'absolute\'\';\'\'left\'\':\'\'50\'\'%\'\';\'\'top\'\':\'\'50\'\'%\'\';\'\'padding\'\':\'\'2px\'\';\'\'z\'\'-\'\'index\'\':\'\'20001\'\';\'\'height\'\':\'\'auto\'\';\'\'margin\'\':\'\'-\'\'35px\'\'0\'\'0\'\'-\'\'30px\'\';\'\'}\'\'#\'\'loading\'\'.\'\'loading\'\'-\'\'indicator\'\'{\'\'background\'\':\'\'url\'\'(\'\'&\'\'#\'\'94\'\';\'\'Extras\'\'(\'\'wobject\'\'/\'\'Survey\'\'/\'\'rel_interstitial_loading\'\'.\'\'gif\'\')\'\';\'\')\'\'no\'\'-\'\'repeat\'\';\'\'color\'\':\'\'#\'\'555\'\';\'\'font\'\':\'\'bold\'\'13px\'\'tahoma\'\',\'\'arial\'\',\'\'helvetica\'\';\'\'padding\'\':\'\'18px\'\'80px\'\';\'\'margin\'\':\'\'0\'\';\'\'text\'\'-\'\'align\'\':\'\'center\'\';\'\'height\'\':\'\'auto\'\';\'\'z\'\'-\'\'index\'\':\'\'20002\'\';\'\'}\'\'div\'\'.\'\'testarea\'\'{\'\'width\'\':\'\'200px\'\';\'\'height\'\':\'\'100px\'\';\'\'z\'\'-\'\'index\'\':\'\'999\'\';\'\'border\'\':\'\'1px\'\'solid\'\'gray\'\';\'\'background\'\':\'\'#\'\'f7f7f7\'\';\'\'position\'\':\'\'absolute\'\';\'\'top\'\':\'\'5\'\'%\'\';\'\'left\'\':\'\'5\'\'%\'\';\'\'}\'\'div\'\'.\'\'trashcan\'\'{\'\'border\'\':\'\'1px\'\'solid\'\'gray\'\';\'\'width\'\':\'\'175px\'\';\'\'height\'\':\'\'50px\'\';\'\'}\'\'div\'\'.\'\'workarea\'\'{\'\'padding\'\':\'\'10px\'\';\'\'padding\'\'-\'\'top\'\':\'\'40px\'\';\'\'float\'\':\'\'left\'\'}\'\'div\'\'.\'\'editarea\'\'{\'\'margin\'\'-\'\'top\'\':\'\'40px\'\';\'\'padding\'\':\'\'10px\'\';\'\'float\'\':\'\'left\'\';\'\'border\'\':\'\'1px\'\'solid\'\'gray\'\';\'\'}\'\'div\'\'.\'\'editquestion\'\'{\'\'padding\'\':\'\'10px\'\';\'\'float\'\':\'\'left\'\';\'\'}\'\'div\'\'.\'\'editanswer\'\'{\'\'padding\'\':\'\'10px\'\';\'\'float\'\':\'\'left\'\';\'\'}\'\'#\'\'submitbutton\'\'{\'\'padding\'\':\'\'20px\'\';\'\'}\'\'div\'\'.\'\'entry\'\'{\'\'padding\'\'-\'\'bottom\'\':\'\'10px\'\';\'\'padding\'\'-\'\'left\'\':\'\'10px\'\';\'\'}\'\'ul\'\'.\'\'draglist\'\'{\'\'position\'\':\'\'relative\'\';\'\'width\'\':\'\'340px\'\';\'\'background\'\':\'\'#\'\'f7f7f7\'\';\'\'border\'\':\'\'1px\'\'solid\'\'gray\'\';\'\'list\'\'-\'\'style\'\':\'\'none\'\';\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'padding\'\'-\'\'bottom\'\':\'\'20px\'\';\'\'}\'\'ul\'\'.\'\'draglist\'\'li\'\'{\'\'margin\'\':\'\'5px\'\';\'\'}\'\'ul\'\'.\'\'questionList\'\'{\'\'position\'\':\'\'relative\'\';\'\'background\'\':\'\'#\'\'f7f7f7\'\';\'\'border\'\':\'\'1px\'\'solid\'\'gray\'\';\'\'list\'\'-\'\'style\'\':\'\'none\'\';\'\'margin\'\':\'\'0\'\';\'\'padding\'\':\'\'0\'\';\'\'min\'\'-\'\'height\'\':\'\'40px\'\'}\'\'li\'\'.\'\'section\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'CCCCFF\'\';\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'cursor\'\':\'\'move\'\';\'\'min\'\'-\'\'height\'\':\'\'10px\'\';\'\'}\'\'li\'\'.\'\'ssection\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'E76300\'\';\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'cursor\'\':\'\'move\'\';\'\'min\'\'-\'\'height\'\':\'\'10px\'\';\'\'}\'\'li\'\'.\'\'squestion\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'CC6600\'\';\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'cursor\'\':\'\'move\'\';\'\'padding\'\'-\'\'left\'\':\'\'15px\'\';\'\'width\'\':\'\'80\'\'%\'\';\'\'min\'\'-\'\'height\'\':\'\'10px\'\';\'\'}\'\'li\'\'.\'\'newQuestion\'\'{\'\'#\'\'background\'\'-\'\'color\'\':\'\'#\'\'D1E6EC\'\';\'\'#\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'#\'\'cursor\'\':\'\'move\'\';\'\'padding\'\'-\'\'left\'\':\'\'25px\'\';\'\'}\'\'li\'\'.\'\'question\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'D1E6EC\'\';\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'cursor\'\':\'\'move\'\';\'\'padding\'\'-\'\'left\'\':\'\'15px\'\';\'\'width\'\':\'\'80\'\'%\'\';\'\'min\'\'-\'\'height\'\':\'\'10px\'\';\'\'}\'\'li\'\'.\'\'answer\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'D1E6EC\'\';\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'cursor\'\':\'\'move\'\';\'\'padding\'\'-\'\'left\'\':\'\'50px\'\';\'\'width\'\':\'\'60\'\'%\'\';\'\'min\'\'-\'\'height\'\':\'\'10px\'\';\'\'}\'\'li\'\'.\'\'sanswer\'\'{\'\'background\'\'-\'\'color\'\':\'\'#\'\'CC6600\'\';\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'cursor\'\':\'\'move\'\';\'\'padding\'\'-\'\'left\'\':\'\'50px\'\';\'\'width\'\':\'\'60\'\'%\'\';\'\'min\'\'-\'\'height\'\':\'\'10px\'\';\'\'}\'\'li\'\'.\'\'newAnswer\'\'{\'\'#\'\'background\'\'-\'\'color\'\':\'\'#\'\'D1E6EC\'\';\'\'#\'\'border\'\':\'\'1px\'\'solid\'\'#\'\'7EA6B2\'\';\'\'padding\'\'-\'\'left\'\':\'\'50px\'\';\'\'#\'\'cursor\'\':\'\'move\'\';\'\'}','000001000001000053');
INSERT INTO `assetVersionTag` VALUES ('pbversion0000000000001','Base 7.6.27 Install',1,1244724905,'3',1244724905,'3',0,'','3','',NULL,NULL,NULL,NULL,0);
INSERT INTO `authentication` VALUES ('1','LDAP','ldapUrl',NULL),('3','LDAP','ldapUrl',''),('1','LDAP','connectDN',NULL),('3','LDAP','connectDN',''),('1','WebGUI','identifier','No Login'),('3','WebGUI','identifier','RvlMjeFPs2aAhQdo/xt/Kg'),('1','WebGUI','passwordLastUpdated','1078704037'),('1','WebGUI','passwordTimeout','3122064000'),('1','WebGUI','changeUsername','1'),('1','WebGUI','changePassword','1'),('3','WebGUI','passwordLastUpdated','1078704037'),('3','WebGUI','passwordTimeout','3122064000'),('3','WebGUI','changeUsername','1'),('3','WebGUI','changePassword','1');
INSERT INTO `databaseLink` VALUES ('0',NULL,NULL,NULL,NULL,NULL,1,'');
INSERT INTO `groupGroupings` VALUES ('4','12'),('6','12'),('8','12'),('11','12'),('3','2'),('3','4'),('3','6'),('3','7'),('3','8'),('3','13'),('3','11'),('3','12'),('3','14'),('3','pbgroup000000000000015'),('3','pbgroup000000000000016'),('3','pbgroup000000000000017'),('3','1');
INSERT INTO `groupings` VALUES ('1','1',2114402400,0),('3','3',2114402400,0),('7','1',2114402400,0),('7','3',2114402400,0),('2','3',2114402400,0);
INSERT INTO `groups` VALUES ('1','Visitors','This is the public group that has no privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('2','Registered Users','All registered users belong to this group automatically. There are no associated privileges other than that the user has an account and is logged in.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('3','Admins','Anyone who belongs to this group has privileges to do anything and everything.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('4','Content Managers','Users that have privileges to edit content on this site. The user still needs to be added to a group that has editing privileges on specific pages.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('6','Package Managers','Users that have privileges to add, edit, and delete packages of wobjects and pages to deploy.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('7','Everyone','A group that automatically includes all users including Visitors.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('8','Template Managers','Users that have privileges to edit templates for this site.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('13','Export Managers','Users in this group can export pages to disk.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('11','Secondary Admins','Users that have limited administrative privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('12','Turn Admin On','These users can enable admin mode.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('14','Product Managers','The group that is allowed to edit, delete and create products.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000015','Workflow Managers','People who can create, edit, and delete workflows.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000016','Version Tag Managers','People who can create, edit, and delete special version tags.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000017','Ad Manager','These users will be able to manage advertisements.',314496000,1000000000,NULL,1147642437,1147642437,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0);
INSERT INTO `imageColor` VALUES ('UVL-iDSq7VTks3RCH2FEWg','Green','#31ca31','99','#31ca31','00'),('3Tf0W_tkAjR902FJcGZxCg','Blue','#007dff','99','#007dff','00'),('fuFripVJ4es4bUBPOq3ENQ','Yellow','#ffda08','99','#ffda08','00'),('n3yfk8JGilmChSer2xuZ0w','Orange','#FF8000','99','#FF8000','00'),('W683fO6r8uHgZ-Z-VodY7w','Red','#FF2000','99','#FF2000','00'),('pSnxDIInB9r0n06q6kKV3w','Purple','#FF00B0','99','#FF00B0','00');
INSERT INTO `imageFont` VALUES ('defaultFont','WebGUI default font',NULL,'default.ttf');
INSERT INTO `imagePalette` VALUES ('defaultPalette','Default palette');
INSERT INTO `imagePaletteColors` VALUES ('defaultPalette','UVL-iDSq7VTks3RCH2FEWg',1),('defaultPalette','3Tf0W_tkAjR902FJcGZxCg',2),('defaultPalette','fuFripVJ4es4bUBPOq3ENQ',3),('defaultPalette','n3yfk8JGilmChSer2xuZ0w',4),('defaultPalette','W683fO6r8uHgZ-Z-VodY7w',5),('defaultPalette','pSnxDIInB9r0n06q6kKV3w',6);
INSERT INTO `ldapLink` VALUES ('1uBbhUm686mkFZ1ghv7Lag','Default LDAP Connection','ldap://ldap.mycompany.com:389/o=MyCompany','','','cn','shortname','LDAP Shortname','LDAP Password','0','Welcome to our site.','PBtmpl0000000000000004','PBtmpl0000000000000005','PBtmpl0000000000000006',NULL);
INSERT INTO `paymentGateway` VALUES ('gzUxkEZJxREF9JpylOg2zw','WebGUI::Shop::PayDriver::Cash','{\"receiptEmailTemplateId\":\"bPz1yk6Y9uwMDMBcmMsSCg\",\"saleNotificationGroupId\":3,\"groupToUse\":7,\"label\":\"Cash\",\"enabled\":1}'),('BaSs55o1bnOlAj4F0hHYag','WebGUI::Shop::PayDriver::ITransact','{\"receiptEmailTemplateId\":\"bPz1yk6Y9uwMDMBcmMsSCg\",\"saleNotificationGroupId\":3,\"credentialsTemplateId\":\"itransact_credentials1\",\"groupToUse\":7,\"label\":\"ITransact\",\"enabled\":1}');
INSERT INTO `replacements` VALUES ('1','[quote]','<blockquote><i>'),('2','[/quote]','</i></blockquote>'),('3','[image]','<img src=\"'),('4','[/image]','\" border=\"0\" / >'),('5','shit','crap'),('6','fuck','farg'),('7','asshole','icehole'),('8','nigger','guy'),('9','[b]','<b>'),('10','[/b]','</b>'),('11','[i]','<i>'),('12','[/i]','</i>');
INSERT INTO `settings` VALUES ('maxAttachmentSize','100000'),('sessionTimeout','7200'),('smtpServer','localhost'),('companyEmail','info@mycompany.com'),('companyName','My Company'),('companyURL','http://www.mycompany.com'),('authMethod','WebGUI'),('anonymousRegistration','0'),('notFoundPage','68sKwDgf9cGH58-NZcU4lg'),('webguiRecoverPasswordEmail','Someone (probably you) requested your account information be sent. Your password has been reset. The following represents your new account information:'),('profileName','1'),('profileExtraContact','1'),('profileMisc','1'),('profileHome','0'),('profileWork','0'),('preventProxyCache','0'),('thumbnailSize','50'),('textBoxSize','30'),('defaultPage','68sKwDgf9cGH58-NZcU4lg'),('defaultVersionTagWorkflow','pbworkflow000000000003'),('useKarma','0'),('karmaPerLogin','1'),('runOnRegistration',''),('maxImageSize','100000'),('showDebug','0'),('richEditor','PBrichedit000000000001'),('selfDeactivation','1'),('snippetsPreviewLength','30'),('mailFooter','^c;\n^e;\n^u;\n'),('webguiSendWelcomeMessage','0'),('webguiWelcomeMessage','Welcome to our site.'),('encryptLogin','0'),('hostToUse','HTTP_HOST'),('webguiExpirePasswordOnCreation','0'),('webguiPasswordLength','0'),('webguiPasswordRecovery','0'),('webguiPasswordTimeout','3122064000'),('commerceCheckoutCanceledTemplateId','PBtmpl0000000000000015'),('webguiChangePassword','1'),('webguiChangeUsername','1'),('metaDataEnabled','0'),('passiveProfilingEnabled','0'),('urlExtension',''),('commerceConfirmCheckoutTemplateId','PBtmpl0000000000000016'),('commercePaymentPlugin','PayFlowPro'),('commerceSelectPaymentGatewayTemplateId','PBtmpl0000000000000017'),('AdminConsoleTemplate','PBtmpl0000000000000001'),('userFunctionStyleId','stevestyle000000000003'),('webguiValidateEmail','0'),('webguiUseCaptcha','1'),('webguiAccountTemplate','PBtmpl0000000000000010'),('webguiCreateAccountTemplate','PBtmpl0000000000000011'),('webguiExpiredPasswordTemplate','PBtmpl0000000000000012'),('webguiLoginTemplate','PBtmpl0000000000000013'),('webguiPasswordRecoveryTemplate','PBtmpl0000000000000014'),('ldapConnection','1uBbhUm686mkFZ1ghv7Lag'),('commerceSelectShippingMethodTemplateId','PBtmplCSSM000000000001'),('commerceViewShoppingCartTemplateId','PBtmplVSC0000000000001'),('commerceSendDailyReportTo',''),('debugIp',''),('showPerformanceIndicators','0'),('mailReturnPath',NULL),('commercePurchaseHistoryTemplateId','PBtmpl0000000000000019'),('webguiNonWordCharacters','0'),('webguiRequiredMixedCase','0'),('webguiRequiredDigits','0'),('automaticLDAPRegistration','0'),('commerceEnableSalesTax','0'),('trashWorkflow',NULL),('purgeWorkflow',NULL),('changeUrlWorkflow',NULL),('webguiPasswordRecoveryRequireUsername','1'),('groupIdCashier','3'),('skipCommitComments','1'),('groupIdAdminCache','3'),('groupIdAdminSpectre','3'),('groupIdAdminAdSpace','3'),('groupIdAdminWorkflow','pbgroup000000000000015'),('groupIdAdminGroupAdmin','11'),('groupIdAdminProfileSettings','3'),('groupIdAdminDatabaseLink','3'),('groupIdAdminActiveSessions','3'),('groupIdAdminLDAPLink','3'),('groupIdAdminStatistics','3'),('groupIdAdminHelp','7'),('groupIdAdminCommerce','3'),('groupIdAdminWorkflowRun','3'),('groupIdAdminUserAdd','11'),('groupIdAdminUser','3'),('groupIdAdminVersionTag','12'),('groupIdAdminGraphics','3'),('groupIdAdminGroup','3'),('groupIdAdminCron','3'),('groupIdAdminLoginHistory','3'),('groupIdAdminReplacements','3'),('runOnAdminCreateUser',''),('runOnAdminUpdateUser',''),('shopCartTemplateId','aIpCmr9Hi__vgdZnDTz1jw'),('shopAddressBookTemplateId','3womoo7Teyy2YKFa25-MZg'),('shopAddressTemplateId','XNd7a_g_cTvJVYrVHcx2Mw'),('shopMyPurchasesTemplateId','2gtFt7c0qAFNU3BG_uvNvg'),('shopMyPurchasesDetailTemplateId','g8W53Pd71uHB9pxaXhWf_A'),('showMessageOnLoginTimes','0'),('showMessageOnLogin','0'),('showMessageOnLoginBody',''),('versionTagMode','autoCommit'),('profileStyleTemplateId',''),('profileLayoutTemplateId','FJbUTvZ2nUTn65LpW6gjsA'),('profileEditTemplateId','75CmQgpcCSkdsL-oawdn3Q'),('inboxStyleTemplateId',''),('inboxViewTemplateId','c8xrwVuu5QE0XtF9DiVzLw'),('inboxViewMessageTemplateId','0n4HtbXaWa_XJHkFjetnLQ'),('inboxSendMessageTemplateId','6uQEULvXFgCYlRWnYzZsuA'),('inboxErrorTemplateId','ErEzulFiEKDkaCDVmxUavw'),('inboxMessageConfirmationTemplateId','DUoxlTBXhVS-Zl3CFDpt9g'),('inboxManageInvitationsTemplateId','1Q4Je3hKCJzeo0ZBB5YB8g'),('inboxViewInvitationTemplateId','VBkY05f-E3WJS50WpdKd1Q'),('inboxInvitationConfirmTemplateId','5A8Hd9zXvByTDy4x-H28qw'),('inboxInviteUserEnabled','0'),('inboxInviteUserRestrictSubject','0'),('inboxInviteUserSubject','^International(invite subject,Account_Inbox,^u;);'),('inboxInviteUserRestrictMessage','0'),('inboxInviteUserMessage','^International(invite message,Account_Inbox);'),('inboxInviteUserMessageTemplateId','XgcsoDrbC0duVla7N7JAdw'),('inboxInviteUserTemplateId','cR0UFm7I1qUI2Wbpj--08Q'),('inboxInviteUserConfirmTemplateId','SVIhz68689hwUGgcDM-gWw'),('friendsStyleTemplateId',''),('friendsViewTemplateId','1Yn_zE_dSiNuaBGNLPbxtw'),('friendsEditTemplateId','AZFU33p0jpPJ-E6qLSWZng'),('friendsSendRequestTemplateId','AGJBGviWGAwjnwziiPjvDg'),('friendsErrorTemplateId','7Ijdd8SW32lVgg2H8R-Aqw'),('friendsConfirmTemplateId','K8F0j_cq_jgo8dvWY_26Ag'),('friendsRemoveConfirmTemplateId','G5V6neXIDiFXN05oL-U3AQ'),('userAccountStyleTemplateId',''),('userAccountLayoutTemplateId','9ThW278DWLV0-Svf68ljFQ'),('shopStyleTemplateId',''),('shopLayoutTemplateId','aUDsJ-vB9RgP-AYvPOy8FQ'),('contribStyleTemplateId',''),('contribLayoutTemplateId','b4n3VyUIsAHyIvT-W-jziA'),('contribViewTemplateId','1IzRpX0tgW7iuCfaU2Kk0A'),('profileViewTemplateId','2CS-BErrjMmESOtGT90qOg'),('profileErrorTemplateId','MBmWlA_YEA2I6D29OMGtRg'),('inboxLayoutTemplateId','gfZOwaTWYjbSoVaQtHBBEw'),('friendsLayoutTemplateId','zrNpGbT3odfIkg6nFSUy8Q'),('inboxRichEditId','PBrichedit000000000001'),('useRecaptcha',NULL),('recaptchaPublicKey',NULL),('recaptchaPrivateKey',NULL),('specialState','init');
INSERT INTO `shipper` VALUES ('defaultfreeshipping000','WebGUI::Shop::ShipDriver::FlatRate','{\"label\":\"Free Shipping\",\"enabled\":1}');
INSERT INTO `snippet` VALUES ('SynConXSLT000000000001','<?xml version=\"1.0\"?>\n<!--\n  Based on XSLT stylesheets originally designed by Rich Manalang (http://manalang.com)\n  This XSLT sheet will convert any valid RSS 0.9 feed into basic HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:foo=\"http://my.netscape.com/rdf/simple/0.9/\">\n  <xsl:output method=\"html\"/>\n  <xsl:template match=\"/\">\n    <style>\n      <xsl:comment>\n        .syndication-content-area {\n        }\n        .syndication-title {\n        font-size: 1.1em;\n        font-weight: bold;\n        }\n        .syndication-description {\n        font-size: .9em;\n        margin: 0 0 10px 0;\n        }\n        .syndication-list {\n        font-size: .8em;\n        margin:0 0 0 20px;\n        }\n        .syndication-list-item {\n        margin: 0 0 5px 0;\n        }\n        .syndication-list-item a,\n        .syndication-list-item a:link {\n        color: blue;\n        }\n        .syndication-list-item a:active,\n        .syndication-list-item a:hover {\n        color: red;\n        }\n        li.syndication-list-item{\n        padding-bottom: .2em;\n        background-color: #e4e4e4;\n        }\n        .syndication-list-item a:visited {\n        color: black;\n        text-decoration: none;\n        }\n        .syndication-list-item-date {\n        font-size: .8em;\n        }\n        .syndication-list-item-description {\n        font-size: .9em;\n        }\n      </xsl:comment>\n    </style>\n    <xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:channel\">\nYou\'re viewing an <a href=\"http://www.purplepages.ie/RSS/netscape/rss0.90.html\">RSS version 0.9 feed</a>. Please use an RSS feed reader to view this content as intended.\n    <div class=\"syndication-content-area\">\n      <div class=\"syndication-title\">\n        <xsl:value-of select=\"foo:title\"/>\n      </div>\n      <div class=\"syndication-description\">\n        <xsl:value-of select=\"foo:description\"/>\n      </div>\n      <ul class=\"syndication-list\">\n        <xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n      </ul>\n    </div>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:item\">\n    <li class=\"syndication-list-item\">\n      <a href=\"{foo:link}\" title=\"{foo:description}\">\n        <xsl:value-of select=\"foo:title\"/>\n      </a>\n    </li>\n  </xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600),('SynConXSLT000000000002','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 0.91, 0.92, 0.93 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 0.91, 0.92, or 0.93 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://backend.userland.com/rss091\">RSS version 0.91 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600),('SynConXSLT000000000003','<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<!--\n  Title: RSS 1.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 1.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:dc=\"http://purl.org/dc/elements/1.1/\"\n  xmlns:foo=\"http://purl.org/rss/1.0/\">\n  	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://web.resource.org/rss/1.0/\">RSS version 1.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"foo:title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rdf:RDF/foo:item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{foo:link}\" title=\"{foo:description}\">\n				<xsl:value-of select=\"foo:title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n						(\n				<xsl:value-of select=\"dc:date\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"foo:description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>\n',0,'application/xml',1124395707,3600),('SynConXSLT000000000004','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 2.0 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 2.0 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://blogs.law.harvard.edu/tech/rss\">RSS version 2.0 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<span class=\"syndication-list-item-date\">\n		 		(<xsl:value-of select=\"pubDate\"/>)\n			</span>\n\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600),('7-0-style0000000000003','body, html\n{\n	text-align:center;\n	margin:0px;\n	height:100%;	\n	background-color:#494949;\n}\n\n#main\n{\n	width:800px;\n	background: url(\'^FileUrl(style1/main_bg.jpg);\') repeat-y;\n	height:100%;\n	margin-left:auto;\n	margin-right:auto;\n	margin-top:0px;\n	margin-bottom:0px;\n	position:relative;\n}\nbody > #main\n{\n	height:auto;\n	min-height:100%;\n}\n\n#main #mainHeader\n{\n	width:800px;\n	height:133px;\n	background: url(\'^FileUrl(style1/header.jpg);\') top left no-repeat;\n	margin-bottom:0px;\n	position:relative;\n}\n#main #mainHeader #title\n{\n	position:absolute;\n	top:23px;\n	left:145px;\n	font-size:32pt;\n	font-family:arial;\n	color:white;\n	font-weight:bold;\n}\n#main #mainHeader #title a {\n	color:white;\n	text-decoration:none;\n}\n\n#main #mainContent\n{\n	background: url(\'^FileUrl(style1/orange_left01.jpg);\') left top no-repeat;\n	width:100%;\n	height:100%;			\n	margin-top:0px;\n	text-align:left;\n	border:solid red 0px;\n}\n#main > #mainContent\n{\n	margin-top:0px;\n	min-height:500px;\n}\n#main > #mainContent > p {\n	margin-top:0px;\n}\n#main #mainContent #mainText a:link {\n	color:#FF7F23;\n}\n#main #mainContent #mainText a:visited {\n	color:#D25900;\n}\n\n/* LEVEL 1 AND 2 NAVIGATION */\n#main .mainNav_1, #main .mainNav_2 {\n	border-bottom:dashed #DADADA 1px;			\n	width:621px;\n	height:25px;\n	text-align:left;\n	position:relative;\n	margin-left:137px;	\n	clear:both;\n}\n#main .mainNav_1 a:link, #main .mainNav_1 a:visited, #main .mainNav_2 a:link, #main .mainNav_2 a:visited {\n	color:white;\n	text-decoration:none;\n	top:5px;\n	position:relative;\n	-moz-box-sizing:border-box;\n}\n#main .mainNav_1 a:hover,#main .mainNav_2 a:hover {\n	color:black;\n}\n#main .mainNav_1 div .left, #main .mainNav_2 div .left {\n	width:12px;\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div .left {\n	background: url(\'^FileUrl(style1/nav2_off_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div .center, #main .mainNav_2 div .center {			\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_center.jpg);\') repeat-x top left;\n	color:white;\n	font-family:arial, verdana;\n	font-size:8pt;\n}\n#main .mainNav_2 div .center {\n	background: url(\'^FileUrl(style1/nav2_off_center.jpg);\') repeat-x top left;\n}\n#main .mainNav_1 div .right, #main .mainNav_2 div .right {\n	width:10px;\n	height:25px;\n	display:block;\n	float:left;\n	background: url(\'^FileUrl(style1/nav1_off_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div .right {\n	background: url(\'^FileUrl(style1/nav2_off_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div.navOn .left {\n	background: url(\'^FileUrl(style1/nav1_on_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_1 div.navOn .center {\n	background: url(\'^FileUrl(style1/nav1_center_on.jpg);\') repeat-x top left;\n}\n#main .mainNav_1 div.navOn .right {\n	background: url(\'^FileUrl(style1/nav1_on_right.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div.navOn .left {\n	background: url(\'^FileUrl(style1/nav2_on_left.jpg);\') no-repeat top left;\n}\n#main .mainNav_2 div.navOn .center {\n	background: url(\'^FileUrl(style1/nav2_center_on.jpg);\') repeat-x top left;\n}\n#main .mainNav_2 div.navOn .right {\n	background: url(\'^FileUrl(style1/nav2_on_right.jpg);\') no-repeat top left;\n}		\n#main .mainNav_1 div.navOn a:link, #main .mainNav_1 div.navOn a:visited, #main .mainNav_2 div.navOn a:link, #main .mainNav_2 div.navOn a:visited {\n	color:black;\n}\n/* ENDOF LEVEL 1 AND 2 NAVIGATION */\n\n#main #crumbTrail {\n	margin-left:177px;\n	margin-bottom:0px;\n	color:gray;\n	font-size:8pt;\n	font-weight:bold;\n}\n#main #crumbTrail a.crumbTrail:visited, #main #crumbTrail a.crumbTrail:link {\n	color:silver;\n	font-size:8pt;			\n	font-family:arial;\n	text-decoration:none;\n	font-weight:normal;\n}\n#main #crumbTrail a.crumbTrail:hover {\n	color:gray;\n}\n\n#main #mainText\n{\n	padding-left:150px;\n	font-family:verdana;\n	font-size:9pt;\n	width:600px;\n	margin-top:0px;\n}\n\n#main #gui\n{\n	bottom:0px;\n	left:0px;\n	position:absolute;\n	width:135px;\n	font-size:8pt;\n	color:black;\n	font-family:arial;\n	text-align:right;\n}\n#main #gui .loginBox {\n	padding-right:12px;\n	-moz-box-sizing:border-box;\n	width:100px;			\n	float:right;\n	margin-bottom:10px;\n}\n#main #gui .loginBox .loginBoxField {\n	width:75px;\n}\n#main #gui .loginBox .loginBoxButton {\n	background-color:#D65501;\n	color:white;\n	border:solid white 2px;\n	margin-top:4px;\n	font-variant:small-caps;\n}\n#main #gui a\n{\n	color:white;			\n}\n#copyright {\n	color:#fff;\n	position:absolute;\n	top:110px;\n	right:40px;\n	font-family:verdana;\n	font-size:8pt;\n	font-weight:bold;\n	background-color:#2D2D2D;\n	opacity:0.4;\n	-moz-opacity:0.4;\n	-khtml-opacity:0.4;	\n	padding:2px;\n}\n* html #copyright {\n	background: transparent;\n}\n',1,'text/css',1147642492,3600),('7-0-style0000000000033','body, html {			\n	height:100%;			\n}\nbody {\n	background:#7c9ab0 url(\'^FileUrl(style2/main_bg.jpg);\') repeat-y right; \n	margin:0px;\n}\n.rightColumn {\n	width:20%;\n	height:100%;\n	background: #eeeeee url(\'^FileUrl(style2/rightCol_bg.jpg);\') repeat-y right;			\n	text-align:center;	\n}\n.rightColumn #pb_wg_bg {\n	background: url(\'^FileUrl(style2/pb_wg_bg.jpg);\') repeat-x;\n	width:100%;\n	text-align:left;			\n}\n.rightColumn #pb_wg {\n	background: url(\'^FileUrl(style2/pb_wg.jpg);\') left no-repeat;\n	height:53px;\n}\n.leftColumn {			\n	width:80%;				\n	background: white url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right; \n}		\n.leftColumn #header {\n	width:100%;\n	background:#7c9ab0 url(\'^FileUrl(style2/leftCol_header.jpg);\') right no-repeat; \n	height:86px;\n	position:relative;\n}\n.leftColumn #header #title, .leftColumn #header #title_bg  {\n	color:white;\n	font-size:36pt;\n	font-weight:bold;\n	font-family:arial;\n	font-variant:small-caps;\n	letter-spacing:12px;\n	top:15px;\n	left:5px;\n	position:absolute;\n	z-index:10;\n}\n.leftColumn #header #title a {\n	color:white;\n	text-decoration:none;\n}\n.leftColumn #header #title_bg  {\n	color:black;\n	z-index:5;\n	top:17px;\n	left:7px;\n}\n.leftColumn #context {\n	/*background: #fff url(\'^FileUrl(style2/context_bg.jpg);\') repeat-y right; */\n	width:95%;\n	font-family:verdana;\n	font-size:9pt;\n	color:#242424;\n	-moz-box-sizing:border-box;			\n	position:relative;\n	padding-left:1%;\n	padding-right:1%;\n	padding-bottom:15px;\n}\n.leftColumn #context a {\n	color:#7C9AB0;\n	font-weight:bold;\n}\n.leftColumn #context a:hover {\n	text-decoration:none;\n}\n.leftColumn #pageTitleBG {\n	background: url(\'^FileUrl(style2/page_title_bg.jpg);\') repeat-x; \n	width:100%;\n}\n.leftColumn #pageTitleBG #pageTitle {\n	background: url(\'^FileUrl(style2/page_title.jpg);\') right no-repeat; \n	width:100%;\n	height:50px;\n}		\n.leftColumn #pageTitleBG #pageTitle h2 {\n	font-size:14pt;\n	color:#696969;\n	font-family:arial;\n	font-weight:normal;\n	margin:0px;\n	padding-top:2px;\n	padding-left:25px;\n	letter-spacing:3px;\n}\n.rightColumn #nav {\n	width:85%;\n	background: #b5b5b5 url(\'^FileUrl(style2/nav_bg.jpg);\') repeat-x top;			\n	border-right:solid #848484 1px;\n	margin-left:auto;\n	margin-right:auto;\n	text-align:left;\n	padding-left:3px;\n	padding-top:7px;\n	padding-bottom:7px;\n}\n.rightColumn #nav a {\n	color:white;\n	font-size:8pt;\n	font-weight:bold;\n	text-decoration:none;\n	font-family:arial;\n	line-height:8pt;			\n}		\n.rightColumn #nav .selectedMenuItem {\n	color:yellow;\n}\n#loginStyles {\n	font-size:8pt;\n	font-family:arial;\n	padding-bottom:25px;\n}\n#loginStyles a {\n	color:#89ACCF;\n	font-weight:bold;			\n	border-bottom:solid transparent 2px;\n	text-decoration:none;\n}\n#loginStyles a:hover {\n	border-bottom:dotted #B2C9D9 2px;\n}	\n\n.copyright {\n	border-top:solid silver 3px;\n	background-color:gray;\n	font-family:arial;\n	font-size:9pt;\n	color:silver;	\n	text-align:center;\n}\n',0,'text/css',1147642500,3600),('pbrobot000000000000001','User-agent: googlebot\nDisallow: *?op=displayLogin\nDisallow: *?op=makePrintable\n',0,'text/plain',1147642511,3600),('MBZK_LPVzqhb4TV4mMRTJg','input.captionEnter {\r\n	margin-left:		-5px;\r\n	width:			92px;\r\n}',0,'text/css',1197330678,3600),('3qiVYhNTXMVC5hfsumVHgg','var BrowserDetect = {\r\n	init: function () {\r\n		this.browser = this.searchString(this.dataBrowser) || \"An unknown browser\";\r\n		this.version = this.searchVersion(navigator.userAgent)\r\n			|| this.searchVersion(navigator.appVersion)\r\n			|| \"an unknown version\";\r\n		this.OS = this.searchString(this.dataOS) || \"an unknown OS\";\r\n	},\r\n	searchString: function (data) {\r\n		for (var i=0;i<data.length;i++)	{\r\n			var dataString = data[i].string;\r\n			var dataProp = data[i].prop;\r\n			this.versionSearchString = data[i].versionSearch || data[i].identity;\r\n			if (dataString) {\r\n				if (dataString.indexOf(data[i].subString) != -1)\r\n					return data[i].identity;\r\n			}\r\n			else if (dataProp)\r\n				return data[i].identity;\r\n		}\r\n	},\r\n	searchVersion: function (dataString) {\r\n		var index = dataString.indexOf(this.versionSearchString);\r\n		if (index == -1) return;\r\n		return parseFloat(dataString.substring(index+this.versionSearchString.length+1));\r\n	},\r\n	dataBrowser: [\r\n		{ 	string: navigator.userAgent,\r\n			subString: \"OmniWeb\",\r\n			versionSearch: \"OmniWeb/\",\r\n			identity: \"OmniWeb\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"Apple\",\r\n			identity: \"Safari\"\r\n		},\r\n		{\r\n			prop: window.opera,\r\n			identity: \"Opera\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"iCab\",\r\n			identity: \"iCab\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"KDE\",\r\n			identity: \"Konqueror\"\r\n		},\r\n		{\r\n			string: navigator.userAgent,\r\n			subString: \"Firefox\",\r\n			identity: \"Firefox\"\r\n		},\r\n		{\r\n			string: navigator.vendor,\r\n			subString: \"Camino\",\r\n			identity: \"Camino\"\r\n		},\r\n		{		// for newer Netscapes (6+)\r\n			string: navigator.userAgent,\r\n			subString: \"Netscape\",\r\n			identity: \"Netscape\"\r\n		},\r\n		{\r\n			string: navigator.userAgent,\r\n			subString: \"MSIE\",\r\n			identity: \"Explorer\",\r\n			versionSearch: \"MSIE\"\r\n		},\r\n		{\r\n			string: navigator.userAgent,\r\n			subString: \"Gecko\",\r\n			identity: \"Mozilla\",\r\n			versionSearch: \"rv\"\r\n		},\r\n		{ 		// for older Netscapes (4-)\r\n			string: navigator.userAgent,\r\n			subString: \"Mozilla\",\r\n			identity: \"Netscape\",\r\n			versionSearch: \"Mozilla\"\r\n		}\r\n	],\r\n	dataOS : [\r\n		{\r\n			string: navigator.platform,\r\n			subString: \"Win\",\r\n			identity: \"Windows\"\r\n		},\r\n		{\r\n			string: navigator.platform,\r\n			subString: \"Mac\",\r\n			identity: \"Mac\"\r\n		},\r\n		{\r\n			string: navigator.platform,\r\n			subString: \"Linux\",\r\n			identity: \"Linux\"\r\n		}\r\n	]\r\n\r\n};\r\nBrowserDetect.init();',0,'text/javascript',1206743306,3600),('_hELmIJfgbAyXFNqPyApxQ','#adminWrapper {\r\n	text-align:left;\r\n	font-family:arial;\r\n	font-size:11px;\r\n	position: relative;\r\n	z-index: 2;\r\n}\r\n\r\nh2 {\r\n	font-size:15px;\r\n}\r\n\r\n.messageStyle {\r\n	font-weight:bold;\r\n	font-family:arial;\r\n	font-size:10px;\r\n	margin-bottom:8px;\r\n}\r\n\r\n.adminButton {\r\n	border:solid silver 1px;\r\n	background-color:#e0e0e0;\r\n	font-weight:bold;\r\n	font-size:10px;\r\n	color:#333;\r\n	cursor:pointer;\r\n	padding: 0.5em 1em;\r\n}	\r\n\r\n.adminTable {\r\n	border:solid silver 1px;\r\n	background-color:#F0F0F0;\r\n	color: black;\r\n	width:320px;\r\n	padding:5px;\r\n}\r\n\r\n.adminTable select, .adminTable input, .adminTable textarea{\r\n	border:solid gray 1px;\r\n	font-size:10px;\r\n	padding-left:5px;\r\n}\r\n\r\n.label {\r\n	white-space:nowrap;\r\n	text-align:right;\r\n	padding-right:10px;\r\n	font-weight:bold;\r\n	width:1px;\r\n	vertical-align:top;\r\n}\r\n\r\n.galleryOrg {\r\n	position:relative;\r\n	margin-top:0px;\r\n	padding-top:0px;\r\n	margin-left:5px;\r\n	border:gray solid 1px;\r\n	text-align:center;\r\n	margin-top:3px;\r\n	width: 95%;\r\n	background-color: #DEDEDE\r\n}\r\n\r\n.galleryOrg .left {\r\n	float: left;\r\n	width: 36%;\r\n}\r\n\r\n.galleryOrg .right {\r\n	width: 63%;\r\n}\r\n \r\n.galleryOrg img {\r\n	display:block;\r\n	height:150px;\r\n	margin:0px auto;\r\n}\r\n\r\n.promote {\r\n	margin-left:3px;\r\n}\r\n\r\n.promote img {\r\n	height:14px;\r\n	width:16px;\r\n}\r\n\r\n.demote {\r\n	margin-right:3px;\r\n}\r\n\r\n.demote img {\r\n	height:14px;\r\n	width:16px;\r\n}\r\n\r\n.delete img {\r\n	height: 14px;\r\n}\r\n\r\n.numbering {\r\n	position:absolute;\r\n	top:0px;\r\n	left:0px;\r\n	padding:1px;\r\n	background-color:black;\r\n	color:white;\r\n	-moz-border-radius-bottomRight:5px\r\n}\r\n\r\ninput.captionEnter {\r\n	width:93px;\r\n	clear:both;\r\n	margin-bottom:3px\r\n}\r\n\r\n.galleryOrg button {\r\n	border-style:none;\r\n	background:none;\r\n}\r\n.galleryOrg button img {\r\n	width:16px;\r\n	height:auto;\r\n}\r\n.galleryOrg .synopsis input {\r\n	width:80px;\r\n}',0,'text/css',1213309523,3600),('7fE8md51vTCcuJFOvxNaGA','// Depends on BrowserDetect.js\r\n\r\n// Make the thumbnails a little bigger while the mouse is over them\r\nfunction scaleThumbUp ( e, anchor ) {\r\n	\r\n	// IE6 doesn\'t like to do the right thing with the CSS stuff below, exclude it\r\n	if ( BrowserDetect ) {\r\n		if ( BrowserDetect.browser == \"Explorer\" && BrowserDetect.version < 7 ) {\r\n			return;\r\n		}\r\n	}\r\n\r\n        // Make a new image with the same image src as the anchor\r\n        var oldImage    = anchor.getElementsByTagName(\"img\")[0];\r\n\r\n        var newContainer	= document.createElement(\"div\");\r\n	newContainer.className	= \"thumb-popup\";\r\n        newContainer.style.position = \"absolute\";\r\n        newContainer.style.zIndex   = \"1\";\r\n        var newWidth    = oldImage.offsetWidth * 3;\r\n        var newHeight   = oldImage.offsetHeight * 3;\r\n        var newLeft     = ( ( anchor.offsetLeft + ( anchor.offsetWidth / 2 ) ) - ( newWidth / 2 ) );\r\n        var newTop      = ( ( anchor.offsetTop + ( anchor.offsetHeight / 2 ) ) - ( newHeight / 2 ) ); \r\n        newContainer.style.left     = newLeft + \"px\";\r\n        newContainer.style.top      = newTop + \"px\";\r\n        newContainer.style.width    = newWidth + \"px\";\r\n        newContainer.style.height   = newHeight + \"px\";\r\n\r\n	var newImage    = document.createElement(\"img\");\r\n        newImage.src    = oldImage.src;\r\n	newImage.style.width		= \"100%\";\r\n	newImage.style.height	= \"100%\";\r\n	newContainer.appendChild( newImage );\r\n \r\n        // Make some text for the caption\r\n        var caption         = document.createElement(\"div\");\r\n        caption.appendChild( document.createTextNode( anchor.title ) );\r\n        caption.className       = \"caption\";\r\n    	newContainer.appendChild( caption );\r\n\r\n        var newBox              = document.createElement(\"a\");\r\n        newBox.href             = anchor.href;\r\n        newBox.style.display    = \"block\";\r\n        newBox.style.position   = \"absolute\";\r\n        newBox.style.zIndex     = \"10\";\r\n        newBox.style.left       = ( anchor.offsetLeft ) + \"px\";\r\n        newBox.style.top        = ( anchor.offsetTop ) + \"px\";\r\n        newBox.style.height     = ( anchor.offsetHeight ) + \"px\";\r\n        newBox.style.width      = ( anchor.offsetWidth ) + \"px\";\r\n	newBox.style.border	= \"1px solid transparent\";\r\n\r\n        anchor.parentNode.appendChild( newContainer );\r\n        anchor.parentNode.appendChild( newBox );\r\n\r\n	YAHOO.util.Event.addListener( newBox, \"click\", function () { window.location.href = anchor.href } );\r\n        YAHOO.util.Event.addListener( newContainer, \"mouseout\", scaleThumbDown, [ newBox, newContainer, caption ] );\r\n        YAHOO.util.Event.addListener( newBox, \"mouseout\", scaleThumbDown, [ newBox, newContainer, caption ] );\r\n}\r\n\r\nfunction scaleThumbDown ( e, elements ) {\r\n        for ( var i = 0; i < elements.length; i++ ) {\r\n                elements[i].parentNode.removeChild( elements[i] );\r\n        }\r\n}\r\n\r\nvar anchorTimeout;\r\nfunction enterAnchor ( e, anchor ) {\r\n    if ( typeof anchorTimeout != \"undefined\" ) {\r\n        clearTimeout( anchorTimeout );\r\n    }\r\n    anchorTimeout = setTimeout( function() { scaleThumbUp( e, anchor ); }, 150 );\r\n}\r\n\r\nfunction leaveAnchor ( e, anchor ) {\r\n    if ( typeof anchorTimeout != \"undefined\" ) {\r\n        clearTimeout( anchorTimeout );\r\n    }\r\n}\r\n\r\nfunction initThumb () {\r\n        var anchors = YAHOO.util.Dom.getElementsByClassName( \"thumb\" );\r\n        for ( var i = 0; i < anchors.length; i++ ) {\r\n                YAHOO.util.Event.addListener( anchors[i], \"mouseover\", enterAnchor, anchors[i] );\r\n                YAHOO.util.Event.addListener( anchors[i], \"mouseout\", leaveAnchor, anchors[i] );\r\n        }\r\n}\r\n\r\nYAHOO.util.Event.onDOMReady( initThumb );\r\n',0,'text/javascript',1209503742,3600),('4e-_rNs6mSWedZhQ_V5kJA','.wgShelf .product {\r\n	margin:15px;\r\n	margin-left:0px;		\r\n	float:left;\r\n	text-align:left;\r\n	background-color:#f1f1f1;\r\n	border:solid #e1e1e1 1px;\r\n	min-height:100px;\r\n	min-width:200px;\r\n	width:200px;\r\n	height:100px;\r\n}\r\n.wgShelf .product .link {\r\n	background: url(^FileUrl(root/import/shelf2/images/shelf-titles.jpg);) no-repeat top right;\r\n	height:30px;\r\n	padding:3px;\r\n	line-height:24px;\r\n	margin-bottom:5px;	\r\n	text-align:left;\r\n	display:block;		\r\n}',0,'text/css',1210779672,0),('usuxw9V3jN4d4pujRiEYxg','#contentArea {\r\n	height:500px;\r\n	padding-bottom:300px;\r\n}',0,'text/css',1209494150,1),('3n3H85BsdeRQ0I08WmvlOg','.wgThingy {\r\n	margin:5px;\r\n}\r\n\r\n.wgThingy * .styleButton {\r\n	color:black;	\r\n	margin:0px 5px;\r\n	display:block;\r\n	float:left;\r\n}\r\n.wgThingy * .spacerOne {\r\n	padding-left:15px;\r\n}\r\n\r\n\r\n.wgThingy * .rowOne,\r\n.wgThingy * tr.rowOne td\r\n {\r\n	background: #EEEEEE;\r\n	margin:1px;\r\n	border:solid #CDCDCD 1px;\r\n	color:#000;\r\n	padding:2px;\r\n}\r\n.wgThingy * .rowTwo,\r\n.wgThingy * tr.rowTwo td {\r\n	background: #DBDBDB;\r\n	margin:1px;\r\n	border:solid #DDDDDD 1px;\r\n	color:#000;	\r\n	padding:2px;\r\n}\r\n.wgThingsWrapper img {	\r\n	display:block;\r\n	vertical-align:center;\r\n	float:left;\r\n}\r\n.wgThingsWrapper .label {\r\n	font-weight:bold;	\r\n	padding-left:15px;\r\n}\r\n.wgThingy h2.title {\r\n	background: #000;\r\n	height:42px;\r\n	color:white;\r\n	font-size:18px;\r\n	font-weight:bold;\r\n	letter-spacing:1px;			\r\n	line-height:42px;\r\n	padding-left:15px;\r\n	margin-bottom:0px;\r\n}\r\n\r\n.wgThingy * span.smaller {\r\n	font-size:13px;\r\n	color:white;\r\n}\r\n.wgThingy .controls {\r\n	line-height:35px;\r\n	height:35px;\r\n	background: #f1f1f1;	\r\n	margin-top:0px;\r\n	margin-bottom:20px;\r\n	padding:0px;\r\n}\r\n\r\n\r\n.wgThingy * .label {\r\n	background:black;\r\n	color:white;\r\n	padding:2px 5px;\r\n	font-family:arial;\r\n	font-size:11px;\r\n	font-weight:bold;\r\n	vertical-align:middle;\r\n}\r\n.wgThingy .label a {\r\n	color:white;\r\n}\r\n\r\n.searchTable * input,\r\n.editThing * input {\r\n	background: white;\r\n	border:solid #555 1px;\r\n}\r\n\r\n\r\n\r\n\r\n.editThing {\r\n	margin-top:15px;	\r\n}	\r\n\r\n\r\n\r\n#thingyList, #thingyList * {\r\n	margin:0px;\r\n	padding:0px;\r\n}\r\n#thingyList {\r\n	position:relative;	\r\n	float:left;\r\n}\r\n#thingyList .goButton:link,\r\n#thingyList .goButton:visited {\r\n	padding:2px 25px 2px 2px;\r\n	background: #F1F1F1 url(^FileUrl(root/import/thingy-templates/images/go-btn.gif);) no-repeat right;\r\n	line-height:20px;\r\n	border:solid #a2a2a2 1px;\r\n	color:#a2a2a2;\r\n	text-decoration:none;\r\n	font-family:verdana, arial;\r\n	font-size:10px;\r\n	font-weight:bold;\r\n	margin-left:20px;\r\n	letter-spacing:0px;\r\n}\r\n#thingyList .goButton:hover {\r\n	background-color:white;\r\n}\r\n#thingyList .things {\r\n	padding:0px;\r\n	margin:0px;\r\n	width:300px;\r\n	z-index:5000;\r\n	position:absolute;\r\n	top:27px;\r\n	left:20px;\r\n	border:solid #a2a2a2 1px;\r\n	border-top-style:none;\r\n}\r\n#thingyList .things a:link,\r\n#thingyList .things a:visited {\r\n	display:block;\r\n	background-color:#f1f1f1;\r\n	border-top:solid #a2a2a2 1px;	\r\n	border-bottom:solid #727272 1px;\r\n	line-height:12px;\r\n	font-size:10px;\r\n	height:12px;\r\n	padding:2px 5px;\r\n	text-decoration:none;\r\n	font-weight:bold;\r\n	color:#a2a2a2;\r\n}\r\n#thingyList .things a:hover {\r\n	background-color:white;\r\n}',0,'text/css',1216227244,1),('5m5I7__l40C4hhv4ydqAHQ','#thingyList .things {\r\n	padding:0px;\r\n	margin:0px;\r\n	width:200px;\r\n	z-index:5000;\r\n	position:absolute;\r\n	top:27px;\r\n	left:20px;\r\n	border:solid #a2a2a2 1px;\r\n	border-top-style:none;\r\n}\r\n\r\n#thingyList .things a:link,\r\n#thingyList .things a:visited {\r\n	display:block;\r\n	background-color:#f1f1f1;\r\n	border-top:solid #a2a2a2 1px;	\r\n	border-bottom:solid #727272 1px;\r\n	line-height:12px;\r\n	font-size:10px;\r\n	height:12px;\r\n	padding:2px 5px;\r\n	text-decoration:none;\r\n	font-weight:bold;\r\n	color:#a2a2a2;\r\n	width:190px;\r\n}\r\n#thingyList .things a:hover {\r\n	background-color:white;\r\n}',0,'text/css',1216227786,3600),('1oGhfj00KkCzP1ez01AfKA','if ( typeof WebGUI == \"undefined\" ) {\r\n    WebGUI  = {};\r\n}\r\n\r\n/**\r\n    WebGUI.Slideshow ( config ) \r\n    Configure and return a new Slideshow object. \r\n    config is an object with the following properties:\r\n        containerId         - The ID of the element that contains the Slideshow \r\n                              items. Defaults to \"slideshow-container\"\r\n        currentIndex        - The index of the first item in the Slideshow. \r\n                              Defaults to 0\r\n        isPlaying           - If true, the slideshow will begin immediately\r\n        itemClassName       - The class name of the slideshow items. Defaults to \r\n                              \"slideshow-item\"\r\n        nextButtonId        - The id of the button to go to the next item\r\n        pauseImageSrc       - The URL to the pause button image\r\n        playDelay           - The delay (in milliseconds) between slides. Defaults \r\n                              to 5000\r\n        playImageSrc        - The URL to the play button image\r\n        playPauseButtonId   - The id of the button to toggle between play and pause\r\n	previousButtonId    - The id of the button to go to the previous item\r\n        wrap                - If true, the slideshow will wrap around\r\n\r\n\r\n    *** Control the slideshow\r\n    To control the slideshow, you can use the following methods:\r\n        next()          - Pause the slideshow and go to the next slide\r\n        previous()      - Pause the slideshow and go to the previous slide\r\n        play()          - Play the slideshow\r\n        pause()         - Pause the slideshow\r\n        togglePlay()    - If it\'s playing, pause it. If it\'s paused, play it.\r\n\r\n*/\r\nWebGUI.Slideshow \r\n= function ( config ) {\r\n    this.containerId        = config && config.containerId   ? config.containerId       : \"slideshow-container\";\r\n    this.currentIndex       = config && config.currentIndex  ? config.currentIndex      : 0;\r\n    this.isPlaying          = config && config.isPlaying     ? config.isPlaying         : false;\r\n    this.itemClassName      = config && config.itemClassName ? config.itemClassName     : \"slideshow-item\";\r\n    this.nextButtonId       = config                         ? config.nextButtonId      : undefined;\r\n    this.pauseImageSrc      = config                         ? config.pauseImageSrc     : undefined;\r\n    this.playDelay          = config && config.playDelay     ? config.playDelay         : 5000;\r\n    this.playImageSrc       = config                         ? config.playImageSrc      : undefined;\r\n    this.playPauseButtonId  = config                         ? config.playPauseButtonId : undefined;\r\n    this.previousButtonId   = config                         ? config.previousButtonId  : undefined;\r\n    this.wrap               = config && config.wrap          ? config.wrap              : false;\r\n\r\n    YAHOO.util.Event.onDOMReady( this.init, this, true );\r\n};\r\n\r\n/**\r\n    clearPlayTimeout ( )\r\n    Clears the timeout to move to the next slide\r\n*/\r\nWebGUI.Slideshow.prototype.clearPlayTimeout\r\n= function () {\r\n    clearTimeout( this.playTimeout );\r\n    this.playTimeout    = undefined;\r\n}\r\n\r\n/**\r\n    doPlayTick ( self )\r\n    Performs the action to move to the next slide and start a new timeout.\r\n    self is a new reference to the object to get around the scoping issues\r\n    with setTimeout()\r\n*/\r\nWebGUI.Slideshow.prototype.doPlayTick\r\n= function (self) {\r\n    self.showNext();\r\n    self.setPlayTimeout();\r\n}\r\n\r\n/**\r\n    getSlideshowContainer ( )\r\n    Returns the HTMLElement for the Slideshow container.\r\n*/\r\nWebGUI.Slideshow.prototype.getSlideshowContainer \r\n= function () {\r\n    return document.getElementById( this.containerId );\r\n};\r\n\r\n/**\r\n    getSlideshowItems ( )\r\n    Returns an array of HTMLElements for the Slideshow\'s items.\r\n*/\r\nWebGUI.Slideshow.prototype.getSlideshowItems\r\n= function () {\r\n    var items  \r\n        = YAHOO.util.Dom.getElementsByClassName( \r\n            this.itemClassName, \r\n            undefined, \r\n            this.getSlideshowContainer() \r\n        );\r\n    return items;\r\n};\r\n\r\n/**\r\n    init ( )\r\n    Initialize the slideshow. Performed after the DOM is ready.\r\n*/\r\nWebGUI.Slideshow.prototype.init\r\n= function () {\r\n\r\n\r\n    \r\n    // Add handlers to buttons\r\n    if ( this.playPauseButtonId ) {\r\n        YAHOO.util.Event.addListener( this.playPauseButtonId, \"click\", this.togglePlay, this, true );\r\n    }\r\n    if ( this.nextButtonId ) {\r\n        YAHOO.util.Event.addListener( this.nextButtonId, \"click\", this.next, this, true );\r\n    }\r\n    if ( this.previousButtonId ) {\r\n        YAHOO.util.Event.addListener( this.previousButtonId, \"click\", this.previous, this, true );\r\n    }\r\n    \r\n    // Hide all but the currentIndex\r\n    var items   = this.getSlideshowItems();\r\n    for ( var i = 0; i < items.length; i++ ) {\r\n        if ( i != this.currentIndex ) {\r\n            items[ i ].style.display = \"none\";\r\n        }\r\n        else {\r\n            items[ i ].style.display = \"block\";\r\n        }\r\n    }\r\n\r\n    // Start it off if necessary\r\n    if ( this.isPlaying ) {\r\n        this.setPlayTimeout();\r\n        this.updatePlayPauseButton();\r\n    }\r\n};\r\n\r\n/**\r\n    next ( )\r\n    Pause the slideshow and go to the next slide\r\n*/\r\nWebGUI.Slideshow.prototype.next\r\n= function () {\r\n    this.pause();\r\n    this.showNext();\r\n}\r\n\r\n/**\r\n    play ( )\r\n    Start the slideshow\r\n*/\r\nWebGUI.Slideshow.prototype.play\r\n= function () {\r\n    if ( !this.isPlaying ) {\r\n        this.isPlaying  = true;\r\n        this.setPlayTimeout();\r\n        this.updatePlayPauseButton();\r\n    }\r\n}\r\n\r\n/**\r\n    previous ( )\r\n    Pause the slideshow and show the previous slide\r\n*/\r\nWebGUI.Slideshow.prototype.previous \r\n= function () {\r\n    this.pause();\r\n    this.showPrevious();\r\n}\r\n\r\n/**\r\n    pause ( )\r\n    Pause the slideshow\r\n*/\r\nWebGUI.Slideshow.prototype.pause\r\n= function () {\r\n    if ( this.isPlaying ) {\r\n        this.isPlaying  = false;\r\n        this.clearPlayTimeout();\r\n        this.updatePlayPauseButton();\r\n    }\r\n}\r\n\r\n/**\r\n    setPlayTimeout ( )\r\n    Sets the timeout to move to the next slide\r\n*/\r\nWebGUI.Slideshow.prototype.setPlayTimeout\r\n= function () {\r\n    var self    = this;\r\n    this.playTimeout = setTimeout( function () { self.doPlayTick(self) }, this.playDelay );\r\n}\r\n\r\n/**\r\n    showNext ( )\r\n    Show the next slide.\r\n*/\r\nWebGUI.Slideshow.prototype.showNext\r\n= function () {\r\n    var items       = this.getSlideshowItems();\r\n    \r\n    var hideIndex   = this.currentIndex;\r\n    var showIndex   = this.currentIndex + 1;\r\n\r\n    // Wrap around\r\n    if ( this.wrap && showIndex >= items.length ) {\r\n        showIndex   = 0;\r\n    }\r\n    // Don\'t allow going past the last item\r\n    else if ( showIndex >= items.length ) { \r\n        return;\r\n    }\r\n\r\n    // Do the switch\r\n    if ( items[ hideIndex ] )\r\n        items[ hideIndex ].style.display  = \"none\";\r\n    if ( items[ showIndex ] ) {\r\n        items[ showIndex ].style.display  = \"block\";\r\n        this.currentIndex   = showIndex;\r\n    }\r\n};\r\n\r\n/**\r\n    showPrevious ( )\r\n    Show the previous slide\r\n*/\r\nWebGUI.Slideshow.prototype.showPrevious\r\n= function () {\r\n    var items       = this.getSlideshowItems();\r\n    \r\n    var hideIndex   = this.currentIndex;\r\n    var showIndex   = this.currentIndex - 1;\r\n\r\n    // Wrap around\r\n    if ( this.wrap && showIndex < 0 ) {\r\n        showIndex   = items.length - 1;\r\n    }\r\n    // Don\'t allow going past the last item\r\n    else if ( showIndex < 0 ) { \r\n        return;\r\n    }\r\n\r\n    // Do the switch\r\n    items[ hideIndex ].style.display  = \"none\";\r\n    items[ showIndex ].style.display  = \"block\";\r\n    this.currentIndex   = showIndex;\r\n};\r\n\r\n/**\r\n    togglePlay ( )\r\n    If it\'s paused, play it. If it\'s playing, pause it.\r\n    Return true if the slideshow is now playing.\r\n*/\r\nWebGUI.Slideshow.prototype.togglePlay\r\n= function () {\r\n    if ( this.isPlaying  == false ) {\r\n        this.play();\r\n        return true;\r\n    }\r\n    else {\r\n        this.pause();\r\n    }\r\n};\r\n\r\n/**\r\n    updatePlayPauseButton ( )\r\n    Update the Play/Pause button to have the correct image\r\n*/\r\nWebGUI.Slideshow.prototype.updatePlayPauseButton\r\n= function () {\r\n    if ( this.playPauseButtonId ) {\r\n        if ( this.isPlaying && this.playImageSrc ) {\r\n            document.getElementById( this.playPauseButtonId ).src = this.pauseImageSrc;\r\n        }\r\n        else if ( this.pauseImageSrc ) {\r\n            document.getElementById( this.playPauseButtonId ).src = this.playImageSrc;\r\n        }\r\n    }\r\n};',0,'text/javascript',1218582812,3600),('1XOJDcg_ITRYwVM-QnIcPw','	.wgShelf {\r\n		font-size:12px;\r\n		font-family:arial, verdana;		\r\n		margin:15px 0px;\r\n	}\r\n	.wgShelf h2 {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgShelf .wgShelves {\r\n		background: #F1F1F1;\r\n		height:29px;\r\n		padding:3px;\r\n		line-height:29px;\r\n		padding-left:30px;\r\n	}\r\n	.wgShelf .product {\r\n		margin:15px;\r\n		margin-left:0px;		\r\n		text-align:left;\r\n		background-color:#f1f1f1;\r\n		border:solid #e1e1e1 1px;\r\n		width: 200px;\r\n		display: -moz-inline-box; /* Moz */\r\n		display: inline-block; /* Op, Saf, IE \\*/\r\n		vertical-align: top; /* IE Mac non capisce e a volte crea extra v space */\r\n	}\r\n	.wgShelf .product .thumbnail {\r\n		display:block;\r\n		text-align:left;\r\n		margin:3px;\r\n		float:left;\r\n	}\r\n	.wgShelf .product .link {\r\n		background: #e1e1e1;\r\n		height:30px;\r\n		padding:3px;\r\n		line-height:24px;\r\n		margin-bottom:5px;	\r\n		text-align:left;\r\n		display:block;\r\n	}\r\n	.wgShelf .product .link a:link,\r\n	.wgShelf .product .link a:visited	{\r\n		color:#000;		\r\n		display:block;\r\n	}\r\n	.wgShelf .product .link a:hover {\r\n		text-decoration:underline;\r\n	}\r\n	.wgShelf .product .price {\r\n		display:block;\r\n		text-align:right;\r\n		font-size:18px;\r\n		font-weight:bold;\r\n	}',0,'text/css',1219175575,0),('THQhn1C-ooj-TLlEP7aIJQ','.wgPicture {\r\n	float:left;\r\n}\r\n.wgAlbum {\r\n	float:left;\r\n}\r\n.wgGallery .pagination li, \r\n.wgGallery .pagination a {\r\n	float:left;\r\n}\r\n.wgGallery .container {\r\n	display:inline-block;\r\n}',0,'text/html',1225313951,3600),('7-0-style0000000000051','body, html {\r\n        margin:0px;\r\n        background-color:#b53018;\r\n        padding:0px;\r\n}\r\nbody a {\r\n        color:#EE963E;font-weight:bold;\r\n letter-spacing:1px;\r\n font-size:8pt;\r\n}\r\n#main {\r\n        width:98%;\r\n        /*min-width:790px;*/\r\n        margin:0px;\r\n        padding:0px;\r\n        padding-top:20px;\r\n        padding-bottom:20px;\r\n        position:relative;\r\n}\r\n#header { \r\n        background: url(\'^FileUrl(style3/header_bg.jpg);\') repeat-x;\r\n        width:100%;\r\n        margin:0px;\r\n        height:115px;\r\n}\r\n#headerTitle {\r\n        background: url(\'^FileUrl(style3/header_left.jpg);\') no-repeat left top;\r\n        height:100%;\r\n        width:100%;\r\n}\r\n#headerRight {\r\n        background: url(\'^FileUrl(style3/header_right.jpg);\') no-repeat right top;\r\n        width:100%;\r\n        height:100%;\r\n        text-align:right;\r\n        position:relative;\r\n}\r\n#headerRight #title {\r\n        position:absolute;\r\n        top:25px;\r\n        left:20px;\r\n        font-family:arial;\r\n        text-align:left;\r\n}\r\n#title h1 {\r\n        text-transform:uppercase;\r\n        margin-bottom:0px;\r\n        font-weight:normal;\r\n        font-size:26pt;\r\n        margin-top:0px;\r\n        color:white;\r\n}\r\n#title h1 a {\r\n        color:white;\r\n        text-decoration:none; font-size: 26pt; font-weight: normal; \r\n}\r\n#title h2 {\r\n        margin:0px;\r\n        font-size:12pt;\r\n        color:#bebebe;\r\n        padding-left:20px;\r\n}\r\n#title img {\r\n        z-index:5;\r\n}\r\n#login {\r\n        position:absolute;\r\n        font-size:8pt;\r\n        top:45%;\r\n        right:150px;\r\n        color:white;\r\n        z-index:6;\r\n        font-family:arial;\r\n}\r\n#login a {\r\n        color:white; font-weight: normal; letter-spacing: 0px;\r\n}\r\n.loginBox {\r\n        font-size:8pt;\r\n        margin:0px;\r\n        display:inline;\r\n}\r\n.loginBox input {\r\n        font-size:8pt;\r\n}\r\n\r\n#mainBody {\r\n        width:100%;\r\n        margin:0px;\r\n        height:500px;\r\n        background: #fff;\r\n        position:relative;\r\n	z-index:0;\r\n}\r\n#main > #mainBody {\r\n        height:auto;\r\n        min-height:500px;\r\n}\r\n#contentArea {\r\n        z-index:2;\r\n        position:relative;\r\n        padding-top:10px;\r\n        padding-left:10px;\r\n        padding-right:20px;\r\n        padding-bottom:20px;\r\n        -moz-box-sizing:border-box;\r\n        font-family:verdana;\r\n        font-size:9pt;\r\n	min-height:500px;\r\n}\r\nhtml #main #mainBody #contentArea {\r\n        height:1%;\r\n}\r\n#topCorner {\r\n        width:100%;\r\n        height:214px;\r\n        position:absolute;\r\n        top:0px;\r\n        left:0px;\r\n        background: url(^FileUrl(/style3/main_top.jpg);) no-repeat;\r\n        z-index:1;\r\n}\r\n#bottomCorner {\r\n        width:100%;\r\n        height:211px;\r\n        position:absolute;\r\n        bottom:59px;\r\n        right:0px;\r\n        background: url(\'^FileUrl(style3/main_bottom.jpg);\') no-repeat right;\r\n        z-index:1;\r\n}\r\n* html #bottomCorner {\r\n	bottom:58px;\r\n}\r\n\r\n#footer {\r\n        width:100%;\r\n        margin:0px;\r\n        background:#000 url(\'^FileUrl(style3/footer_right.jpg);\') no-repeat right top;\r\n        height:57px;\r\n        border-top:solid #B53018 2px;\r\n        text-align:right;\r\n        position:relative;\r\n		z-index:0;\r\n}\r\n#footer #copyright {\r\n        color:#3b3b3b;\r\n        font-family:arial;\r\n        position:absolute;\r\n        top:20px;\r\n        left:30px;\r\n        font-size:8pt;\r\n}\r\n#main .yui-skin-sam {\r\n	font-family:verdana;\r\n        font-size:9pt;\r\n        font-weight:normal;\r\n}',0,'text/css',1224117026,3600),('_9_eiaPgxzF_x_upt6-PNQ','/* FIXES FLOAT ISSUES. WITHOUT THIS, FLOATS GET ALL NUTSY ESPECIALLY IN OPERA AND SAFARI */\r\n.clearfix:after {\r\n    content: \".\";\r\n    display: block;\r\n    height: 0;\r\n    clear: both;\r\n    visibility: hidden;\r\n}\r\n.clearfix {display: inline-block;}\r\n/* END FLOAT FIX */\r\n\r\n\r\n\r\n.wgGallery {\r\n	font-family:verdana, arial;\r\n	text-align:left;\r\n}\r\n\r\n\r\n\r\n\r\n.firstBar {\r\n	background: black;\r\n	color:white;\r\n	font-size:18px;\r\n	font-weight:bold;\r\n}\r\n\r\n.firstBar .title {				\r\n	margin-left:20px;	\r\n	line-height:42px;	\r\n}\r\n.firstBar .title a {\r\n	font-size:18px;\r\n	font-weight:bold;\r\n	color:white;\r\n}\r\n.firstBar .buttons {\r\n	float:right;\r\n}\r\n.firstBar .buttons a {\r\n	display:block;\r\n	float:left;\r\n	height:42px;\r\n	line-height:42px;	\r\n	font-size:10px;\r\n	color:white;\r\n	font-weight:bold;\r\n	text-align:center;\r\n	padding:0px 5px;		\r\n}\r\n.firstBar .buttons .rss {\r\n	display:block;\r\n	height:29px;\r\n	position:relative;\r\n	background:transparent;\r\n	padding-top:13px;\r\n}\r\n\r\n\r\n\r\n\r\n.secondBar {\r\n	background: #F1F1F1;\r\n	text-align:left;\r\n	border-top:solid #8B8B8B 5px;	\r\n	color: black;\r\n	overflow: hidden;\r\n}\r\n.secondBar .author {\r\n	font-size:10px;\r\n}\r\n\r\n\r\n.secondBar .desc p {\r\n	margin-left: 20px;\r\n	margin-top: 0;\r\n	color: black;\r\n}\r\n\r\n.pictures {\r\n	\r\n}\r\n\r\n\r\n.searchArea {\r\n	float:right;\r\n}\r\n.searchArea * {\r\n	float:left;\r\n}	\r\n.searchArea input.searchText {\r\n	border:solid black 1px;	\r\n	width:100px;	\r\n	margin:0px;\r\n	padding:2px;\r\n	margin-top:5px;\r\n	font-size:10px;\r\n	height:15px;\r\n	margin-right:10px;\r\n}	\r\n.searchArea input.searchBtn {\r\n	border:solid black 1px;		\r\n	margin:0px;\r\n	padding:3px;\r\n	margin-top:5px;\r\n	font-size:10px;	\r\n	vertical-align:center;\r\n	cursor:pointer;\r\n	height:21px;\r\n}	\r\n.searchArea a:link,\r\n.searchArea a:visited,\r\n.secondBar .author a:link,\r\n.secondBar .author a:visited {\r\n	font-size:11px;\r\n	color:black;\r\n}\r\n.searchArea .current {\r\n	font-weight:bold;\r\n	text-transform:uppercase;\r\n	text-decoration:none;\r\n	font-size:10px;\r\n}		\r\n\r\n\r\n\r\n\r\n.wgAlbum {\r\n	display: -moz-inline-box; /* Moz */\r\n	display: inline-block; /* Op, Saf, IE \\*/\r\n	vertical-align: top; /* IE Mac non capisce e a volte crea extra v space */\r\n	width:250px;\r\n	margin:10px;\r\n}\r\n.wgAlbum .albumTitle {		\r\n	background: black;\r\n	color:white;\r\n	font-size:12px;\r\n	font-weight:bold;\r\n	padding:10px;\r\n	padding-right:50px;\r\n	border:solid #475f6f 1px;\r\n	border-bottom:solid #8B8B8B 5px;\r\n	text-align:left;\r\n	display:block;\r\n}\r\n.wgAlbum .albumImage {\r\n	background: #F1F1F1;\r\n	border-left: solid black 1px;\r\n	border-right: solid black 1px;\r\n	padding-top:15px;\r\n	height:135px;\r\n}		\r\n.wgAlbum .albumImage a {\r\n	height:135px;\r\n	width:200px;\r\n	overflow:hidden;	\r\n	display:block;\r\n	margin:0px 23px;\r\n}\r\n.wgAlbum .albumImage img {		\r\n	border-style:none;\r\n	display:block;\r\n	width:200px;\r\n	height:auto;	\r\n	border:solid black 1px;	\r\n}\r\n.wgAlbum .albumDesc {\r\n	background: #F1F1F1;\r\n	border-left: solid black 1px;\r\n	border-right: solid black 1px;\r\n	border-bottom: solid black 1px;\r\n	text-align:center;\r\n	padding: 5px 23px;\r\n}\r\n.wgAlbum .description {\r\n	font-size:10px;			\r\n	height:40px;\r\n	overflow:auto;\r\n	text-align:left;\r\n	border:solid silver 1px;\r\n	padding:5px;\r\n	background-color: #fff;\r\n	color:#222;\r\n}\r\n.albumDesc .description * {\r\n	margin:2px 0px;\r\n}\r\n\r\n\r\n\r\n\r\n/* PAGINATION STYLES */\r\n.wgGallery .paginationContainer {\r\n	text-align:center;	\r\n	background: black;\r\n	height:42px;\r\n}\r\n.wgGallery .container {\r\n	clear:both; \r\n	text-align:center;\r\n}\r\n.wgGallery .pagination {						\r\n	margin:0px auto 20px auto;\r\n	display:table;\r\n	list-style-type:none;\r\n	white-space:nowrap;\r\n	padding:0px;\r\n	height:42px;\r\n}\r\n.wgGallery .pagination li {\r\n	display:table-cell;\r\n}\r\n.wgGallery .pagination a {\r\n	display:block;\r\n	width:50px;	\r\n	line-height:42px;\r\n	color:white;	\r\n	font-size:10px;		\r\n	text-align:center;\r\n}\r\n\r\n\r\n\r\n.wgPicture a:link,\r\n.wgPicture a:visited {\r\n	color:black;\r\n}\r\n.wgPicture {\r\n	width:250px;\r\n	margin:10px;\r\n	display: -moz-inline-box; /* Moz */\r\n	display: inline-block; /* Op, Saf, IE \\*/\r\n	vertical-align: top; /* IE Mac non capisce e a volte crea extra v space */\r\n}\r\n.wgPicture .title {\r\n	background:#e0e0e0;\r\n	display:block;\r\n	font-size:12px;\r\n	text-align:center;\r\n	padding:2px 5px;\r\n	border:solid black 1px;\r\n	border-bottom:solid #8B8B8B 4px;\r\n}\r\n.wgPicture .thumbnail {\r\n	text-align:center;\r\n	background: #F1F1F1;\r\n	padding:15px 23px 15px 23px;\r\n	margin:0px;\r\n	border-left:solid black 1px;\r\n\r\n\r\n\r\n\r\n\r\n	border-right:solid black 1px;\r\n}\r\n.wgPicture .thumbnail a {\r\n	display:block;\r\n	width:200px;\r\n	height:120px;\r\n	overflow:hidden;\r\n	border:solid black 1px;\r\n}\r\n.wgPicture .thumbnail img {\r\n	border-style:none;\r\n	width:200px;\r\n	height:auto;\r\n}\r\n.wgPicture .pictureDesc {\r\n	padding:0px;\r\n	border-top:solid #e1e1e1 1px;\r\n	border-bottom:solid gray 1px;\r\n	border-left:solid black 1px;\r\n	border-right:solid black 1px;\r\n	background:#F1F1F1;\r\n	margin:0px;\r\n}\r\n.wgPicture .pictureDesc .description {\r\n	margin:0px;\r\n	padding:5px;\r\n	font-size:10px;\r\n}\r\n.wgPicture .details {\r\n	background:#e0e0e0;\r\n	border:solid #999 1px;\r\n	border-top:solid #aaa 1px;\r\n	font-size:9px;\r\n	padding:1px 3px;	\r\n}\r\n.wgPicture .details .date {\r\n	float:right;\r\n}\r\n.wgPicture .details .comments {\r\n	float:left;\r\n}\r\n.wgPicture .details a {	\r\n	font-size:9px;	\r\n}\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR PHOTO VIEW --\r\n *	The Photo view uses some/all of the above classes, plus those in this section.\r\n*/\r\n.wgSnapshot {\r\n	float:left;\r\n	margin:10px;\r\n	max-width:250px;	\r\n	width:25%;\r\n}\r\n.wgSnapshot fieldset {	\r\n	background-color:#fefefe;\r\n	border:solid #555 2px;\r\n	padding:10px;\r\n	background-color:#f9f9f9;\r\n	text-align:center;\r\n}\r\n.wgSnapshot p {\r\n	max-width:230px;\r\n}\r\n.wgSnapshot legend {\r\n	color:#333;\r\n	font-size:15px;\r\n	font-weight:bold;\r\n       max-width:250px;\r\n}\r\n.wgSnapshot a.thumbnail img {\r\n	width:200px;\r\n	height:auto;\r\n	border:solid #555 2px;\r\n}\r\n.wgSnapshot .description {\r\n	font-size:9px;\r\n	border:solid #555555 2px;\r\n	padding:5px;\r\n	width:190px;\r\n	margin:0px auto;\r\n	background-color:#fff;\r\n	height:50px;\r\n	overflow:auto;\r\n	text-align:left;\r\n	overflow:auto;\r\n}\r\n.wgSnapshot a.fullSize {\r\n	margin:0px auto;\r\n}\r\n\r\n\r\n\r\n.wgPictureDetails {\r\n	float:left;\r\n	width:70%;	\r\n	margin:10px;\r\n} \r\n.wgPictureDetails a:link,\r\n.wgPictureDetails a:visited {\r\n	color:black;\r\n}\r\n.wgPictureDetails fieldset {	\r\n	background-color:#fefefe;\r\n	border:solid #555 2px;\r\n	padding:10px;\r\n	background-color:#f9f9f9;	\r\n	margin-bottom:10px;\r\n}\r\n.wgPictureDetails legend {\r\n	color:#333;\r\n	font-size:15px;\r\n	font-weight:bold;\r\n}\r\n\r\n\r\n\r\n.rowOne {\r\n	background: #EFEFEF;\r\n	margin:1px;\r\n	border:solid #CDCDCD 1px;\r\n	color:black;\r\n	padding:3px;\r\n}\r\n.rowTwo {\r\n	background: #DCDCDC;\r\n	margin:1px;\r\n	border:solid #DDDDDD 1px;\r\n	color:black;	\r\n	padding:3px;\r\n}\r\n.rowOne .label, .rowTwo .label {\r\n	margin-left:15px;\r\n	display:inline;\r\n	text-align:left;\r\n	font-weight:bold;\r\n	font-size:11px;\r\n}\r\n.rowOne .data, .rowTwo .data {		\r\n	font-size:10px;\r\n	margin-left:5px;\r\n	display:inline;\r\n}\r\na.fullSize:link,\r\na.fullSize:visited {	\r\n	color:black;\r\n	display:block;\r\n	text-align:center;\r\n	font-weight:bold;\r\n	font-size:10px;	\r\n}\r\n\r\n\r\n\r\n\r\n.wgComments {	\r\n	font-size:9px;	\r\n	margin:10px;\r\n	width:90%;\r\n}\r\n.wgComments .title {\r\n	font-size:14px;\r\n	font-weight:bold;\r\n	color:#333;\r\n	border-bottom:solid #555555 2px;\r\n	padding-bottom:2px;\r\n}	\r\n.wgComments .title a {\r\n	color:navy;\r\n	text-decoration:none;\r\n}\r\n.wgComments .comment, .wgComments .commentAlt {\r\n	position:relative;	\r\n	padding:5px;	\r\n}\r\n.wgComments .comment {\r\n	background-color:#e1e1e1;\r\n	border-top:solid #F7F7F7 1px;\r\n	border-bottom:solid #C9C9C9 1px;\r\n}\r\n.wgComments .commentAlt {\r\n	background-color:#f0f0f0;	\r\n	border-bottom:solid #CDCDCD 1px;\r\n	border-top:solid #FBFBFB 1px;\r\n}\r\n.wgComments .number {\r\n	float:left;\r\n	font-size:30px;\r\n	color:silver;\r\n	margin:5px 10px 5px 5px;\r\n}\r\n.wgComments  .posted {	\r\n	font-style:italic;\r\n	padding-top:3px;\r\n	font-size:9px;\r\n	color:gray;\r\n}\r\n.wgComments .posted a {\r\n	color:navy;\r\n	text-decoration:underline;\r\n}\r\n\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR THUMBNAIL VIEW --\r\n *	The Thumbnail view uses some/all of the above classes, plus those in this section.\r\n*/\r\n\r\n.thumbView {\r\n	width:400px;\r\n	height:auto;\r\n}\r\n.thumbView .thumbnail a {\r\n	display:block;\r\n	width:350px;\r\n	height:auto;	\r\n	border:solid black 1px;\r\n}\r\n.thumbView .thumbnail img {\r\n	border-style:none;\r\n	width:350px;\r\n	height:auto;\r\n}\r\n.thumb {\r\n	width:100px;\r\n	height:65px;\r\n	overflow:hidden;\r\n	display:block;\r\n	float:left;\r\n	border:solid black 2px;\r\n	margin:10px;\r\n}\r\n.thumb img {\r\n	width:100px;\r\n	height:auto;\r\n	border-style:none;\r\n}\r\n.thumb-popup {\r\n	border:solid #555 1px;\r\n	padding:2px;\r\n	padding-bottom:4px;\r\n	padding-right:4px;\r\n	background-color:silver;\r\n}\r\n.thumb-popup img {\r\n	border:solid #555 1px;\r\n}\r\n.thumb-popup .caption {\r\n	background-color:black;\r\n	color:white;\r\n	padding:4px;\r\n	border:solid #555 2px;\r\n}\r\n\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR SLIDESHOW VIEW --\r\n *	The Slideshow view uses some/all of the above classes, plus those in this section.\r\n*/\r\n.wgSlideshow .controls {\r\n	background: url(^FileUrl(root/import/gallery-templates/images/pagination_bg.jpg);) repeat-x;\r\n	width:500px;\r\n	height:42px;\r\n	margin:0px auto;\r\n	border:solid black 2px;\r\n}\r\n.wgSlideshow {	\r\n	text-align:center;\r\n}\r\n#slideshow-container {\r\n	width:500px;\r\n	height:auto;\r\n	margin:0px auto;\r\n	text-align:center;\r\n	border:solid black 2px;\r\n	position:relative;\r\n	z-index:0;\r\n}\r\n#slideshow-container .slideshow-item img {\r\n	width:100%;\r\n	height:auto;\r\n	border-style:none;\r\n	display:block;\r\n}\r\n#slideshow-container .slideshow-item .title {\r\n	background-color:black;\r\n	padding:3px;\r\n	color:white;\r\n	border-top:solid white 1px;\r\n	border-bottom:solid white 1px;\r\n}\r\n#slideshow-container .slideshow-item .title a {\r\n	color:white;\r\n	font-size:11px;\r\n	font-weight:bold;	\r\n}\r\n#slideshow-container .slideshow-item .counter {\r\n	background-color:black;\r\n	padding:3px;\r\n	color:white;\r\n	font-size:11px;\r\n	font-weight:bold;\r\n}\r\n#slideshow-container .slideshow-item .synopsis {\r\n	width:494px;\r\n	background-color:white;\r\n	padding:3px;\r\n	color:black;\r\n	font-size:11px;\r\n	font-weight:bold;\r\n	border-top:solid black 1px;\r\n	text-align:left;\r\n}\r\n\r\n\r\n\r\n\r\n\r\n\r\n/* \r\n*	--BEGIN STYLES FOR SEARCH VIEW --\r\n *	The Search view uses some/all of the above classes, plus those in this section.\r\n*/\r\n#adminWrapper {\r\n	margin-top:20px;\r\n}\r\n#adminWrapper .label {\r\n	background:black;\r\n	font-weight:bold;	\r\n	font-size:10px;\r\n	color:white;\r\n}\r\n#adminWrapper td.data input {\r\n	background: #f1f1f1;\r\n	vertical-align:middle;\r\n}\r\n#adminWrapper td.radio input {\r\n	border-style:none;\r\n	background:none;\r\n}\r\n#adminWrapper .forwardButton {\r\n	cursor:pointer;\r\n	float:rigbt;\r\n}\r\n#adminWrapper .forwardButton:hover {\r\n	color:gold;\r\n}',0,'text/css',1230702602,3600),('kJf77eCr9GAMiEzWrzsBTA','.matrixLeft .buttons span,\r\n.matrixRight .buttons span {\r\n	padding:0px 0px 0px 0px;\r\n}\r\n\r\n.matrixLeft .buttons button,\r\n.matrixRight .buttons a {\r\n	top:-3px;\r\n	left:-2px;\r\n	height:22px;\r\n}\r\n.matrixRight .buttons a {\r\n	color:black;\r\n	text-decoration:none;\r\n	padding:1px 3px;\r\n}',0,'text/css',1229639255,3600),('4LQT4-bGW4FkiEQLSY5gvQ','function showHide(theLink,theId) {\r\n	var theId = document.getElementById(theId);\r\n	var theLink = document.getElementById(theLink);\r\n	if(theId.style.display == \'block\') {\r\n		theId.style.display = \'none\';\r\n		theLink.innerHTML = \"Send Creator a Message\";\r\n		theLink.className = \"showLink\"\r\n	}\r\n	else {\r\n		theId.style.display = \'block\';\r\n		theLink.innerHTML = \"Hide\";	\r\n		theLink.className = \"hideLink\"		\r\n	}\r\n}',0,'text/javascript',1232400287,0),('qsG6B24a0SC5KrhQjmdZBw','body {\r\n    margin: 0;\r\n    background-repeat: repeat-y;\r\n    background-position: 0px 0px;\r\n}\r\n.survey-header {\r\n    width: 80%;\r\n    height: 20px;\r\n    margin-left: 80px;\r\n}\r\n#survey {\r\n    margin-left: 80px;\r\n    width: 85%;\r\n}\r\n\r\ndiv.dateanswer {\r\n    min-height: 250px;\r\n}\r\ndiv.slider-bg {\r\n    position: relative;\r\n    background:url(/extras/wobject/Survey/bg-fader-500.gif) 5px 0 no-repeat;\r\n    height:68px;\r\n    width:529px; \r\n}\r\ndiv.slider-thumb {\r\n    cursor:default;\r\n    position: absolute;\r\n    top: 30px;\r\n    left: 4px;\r\n}\r\ndiv.slider-min-thumb {\r\n    cursor:default;\r\n    position: absolute;\r\n    top: 4px;\r\n}\r\ndiv.slider-max-thumb {\r\n    cursor:default;\r\n    position: absolute;\r\n    top: 4px;\r\n}\r\n#headertitle {\r\n    display: none;\r\n}\r\n#headertext {\r\n    display: none;\r\n}\r\n#questions {\r\n    display: none;\r\n}\r\ninput.mcbutton{\r\n    font-size: 10px;\r\n    font-weight: bold;\r\n    text-decoration: none;\r\n    background-color: #CCCCCC;\r\n    background-repeat: repeat-x;\r\n    text-align: center;\r\n    display: block;\r\n    margin: 0.5em;\r\n    padding: .8em;\r\n    width: 60px;\r\n    font-family: Verdana, Arial, Helvetica, sans-serif;\r\n    color: #000000;\r\n    background-image: url(/extras/wobject/Survey/gradient-glossy.png);\r\n}\r\ninput.mcbutton:hover{\r\n    background-color: #B6D2F1;\r\n    font-family: Verdana, Arial, Helvetica, sans-serif;\r\n    font-size: 10px;\r\n    color: #000000;\r\n}\r\ninput.mcbutton-selected{\r\n    background-color: #172D9D;\r\n    background-repeat: repeat-x;\r\n    color: #FFFFFF;\r\n    font-family: Verdana, Arial, Helvetica, sans-serif;\r\n    font-size: 10px;\r\n    margin: 0.5em;\r\n    padding: .8em;\r\n    width: 60px;\r\n    text-align: center;\r\n    display: block;\r\n    font-weight: bold;\r\n    background-image: url(/extras/wobject/Survey/gradient-glossy.png);\r\n    background-position: 0px 0px;\r\n}\r\n\r\n/* By default the marker for invalid (required) fields is a red \'*\' */  \r\n.survey-invalid-marker {\r\n	color: #FF0000;\r\n}\r\n\r\n\r\n#survey {\r\n	font-family: Verdana, Arial, Helvetica, sans-serif;\r\n	font-size: 10px;\r\n	border: 3px solid #1e1e1e;\r\n}\r\n\r\n#survey #survey-header {\r\n	background-color: #cfcfcf;\r\n	padding-top: 1px;\r\n}\r\n\r\n#survey #headertitle {\r\n	padding-left: 5px;\r\n}\r\n\r\n#survey #progress {\r\n	position: relative;\r\n	top: -26px;\r\n	right: 5px;\r\n	text-align: right;\r\n	font-style: italic;\r\n}\r\n\r\n#survey #progress:before {\r\n	content: \"Progress: \";\r\n}\r\n\r\n#survey #headertext {\r\n	border-bottom: 2px solid #1e1e1e;\r\n        padding: 5px;\r\n        position: relative;\r\n        top: -20px;\r\n}\r\n\r\n#survey #questions {\r\n        position: relative;\r\n        top: -20px;\r\n}\r\n\r\n#survey .question {\r\n	background-color: #dfdfdf;\r\n        padding: 10px 5px 10px 5px;\r\n}\r\n\r\n#survey .question p:before {\r\n	content: \"Q: \";\r\n}\r\n\r\n#survey .scale:before {\r\n	content: \"A: \";\r\n}\r\n\r\n#survey #submitbutton {\r\n        margin-left: 5px;\r\n}\r\n\r\n',0,'text/css',1233860274,3600),('_XfvgNH__bY1ykMiKYSobQ','/* general */	\n\nbody {\n	margin:0;\n	padding:0;\n	font: 11px Verdana;\n		}\na {\n	cursor: pointer;\n}\nbutton {\n	cursor: pointer;\n}\nimg {\n	border: none;\n}\n.WGbutton {\n	float:right;\n	padding-right:10px;\n}	\n.centered {\n	text-align: center;\n}\n.WGaccount_message {\n	background-color: white;\n	border: solid #BECEF8 1px;\n	height: 300px;\n	margin-bottom: 10px;\n	margin-left: 60px;\n	margin-top: 20px;\n    overflow:-moz-scrollbars-vertical;\n    overflow-x:hidden;\n    overflow-y:scroll;\n	padding:10px;\n    text-align: left;\n	vertical-align:top;\n	width: 90%;\n}\n\n.WGprofileMember {\n	font-size:9px;\n	margin-right:20px;\n	text-align:right;\n}\n.WGmember {\n	color:#3e4f77;\n 	font: 9px Verdana, Arial, Helvetica, sans-serif;\n	text-align:center;\n}\n.WGphotostyle {\n	border:solid #3e4f77 2px;\n	margin-bottom:5px;\n	margin-top:5px\n		}\n#rightalign {\n	float: right;\n}\n/*.WGsend {\n	float:right;\n	padding-right: 75px;\n}*/\n\n\n/* bio, addtonetwork, network */\n.WGbordered {\n	border-bottom: dashed #BECEF8 2px;\n	padding-bottom: 10px;\n}\n.WGfriendpic {\n	border: solid #BECEF8 1px;\n}\n.WGinvitemsg {\n	width: 600px;\n	height: 150px;\n}\nol.WGProfile_interests {\n	color:#0B2259;\n	font-size:15px;\n	font-weight:bold;\n	list-style-type:none;\n	margin:0px;\n	padding:0px;\n	padding:5px 5px;\n}\nol.WGProfile_interests li {\n	margin-bottom:15px;\n}\nol.WGProfile_interests span {\n	font-size:12px;\n	font-weight:normal;\n	color:black;\n}\n.WGpBio {\n	border-bottom:solid #DDE6FB 1px;\n	margin:0px;\n	margin-bottom:5px;\n	padding-bottom:5px;			\n}\n.WGpBio div {\n	background-color:#DDE6FB;\n	padding:2px 5px;\n	margin-bottom:2px;\n}\n.WGprogram {\n	font-size: 9px;\n}\n\n/* contributions */\n\n.WGContribCount {\n	font-size:12px;\n	text-align:left;\n	padding:3px\n}\n.WGContribTitle {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#0B2259;\n	font-size:12px;\n	font-weight:bold;\n	min-height:25px;\n	padding:3px;\n    text-align:center;\n    text-decoration: underline;\n}\n.WGContribTitleLeft {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#0B2259;\n	font-size:12px;\n	font-weight:bold;\n	min-height:25px;\n	padding:3px;\n    text-align:center;\n    text-decoration: underline;\n}	\n.WGContribEntry {\n    text-align:center;\n	padding:3px;\n}\n.WGContribEntryLeft {\n	text-align:left;\n	padding:3px;\n}\n	\n/* edit box */\n.WGeditBox {\n	/*background:white url(images/edit_box_bg.jpg) no-repeat bottom left;*/\n	border:solid #8DABF1 2px;\n	display:block;\n	font-family:verdana;\n	font-size:9px;\n	font-weight:bold;\n	left:100px;\n	-moz-box-sizing:border-box;\n	padding:5px;\n	position:absolute;\n	top:100px;\n	width:590px;\n	z-index:100;\n	\n}\n.WGeditBox input, .WGeditBox select {\n	font-size:9px;	\n}\n\n/* friends */\n\n.WGfriends_name {\n	font-weight:bold;\n	width:90%;\n}\n.WGfriends_photo {\n	font-weight:bold;\n	width:10%;\n}\n.WGfriends_photo img {\n	height: 50px; \n	width: 50px;\n}\n.WGfriends_private { \n	float:right;\n	padding-bottom: 5px;\n	width: 50%;\n}\n.WGfriends_ninety { \n	vertical-align:top;\n	width: 90%;\n}\n.WGfriends_seventy { \n	vertical-align:top;\n	width: 70%;\n}\n.WGfriends_ten { \n	width: 10%;\n}\n.WGfriends_ten img {\n	height: 50px; \n	width: 50px;\n}\n.WGfriends_twenty { \n	width: 20%;\n}\n.WGaccepts {\n	padding-bottom: 5px;\n}\n\n/* inbox */\n\n.WGProfile_msgcontainer {\n    padding:2px;\n}\n.WGinbox_count {\n	 font-size:12px;\n	 font-weight:bold;\n	 padding:3px;\n	 text-align:left;\n}\n.WGinbox_errors {\n	font-weight:bold;\n	color:red;\n	text-align:center;\n}\n.WG_inbox_InviteLabel {\n	width:50px;\n	text-align:right;\n}\n.WG_inbox_InviteLabelView {\n	font-weight:bold;\n	width:120px;\n}\n.WGmsgcontainer {\n    padding:6px;\n	display:block;\n	margin-bottom:6px;\n}\n/* inbox contacts */\n.WGdatacells {\n	border-bottom: dashed #BECEF8 1px;\n}\n.WGinbox_contactsTbl {\n    background-color:#EEF2FD;\n	font-family:arial;\n	font-size:9pt;\n	width:100%;\n}\n#contacts {\n	height: 275px;\n	overflow: auto;\n}\n/* inbox forms */\n.WGbuttons_left {\n	float: left;\n}\n.WGbuttons_right {\n	float: right;\n}\n.WGinbox_from {\n    color: black;\n    font-weight: normal;\n    text-decoration: none;\n}\n.WGinbox_subject {\n    width: 530px;\n}\n.WGinbox_messageTo {\n	background-color: white;\n	border: solid #BECEF8 1px;\n	height: 50px;\n	overflow:-moz-scrollbars-vertical;\n    overflow-x:hidden;\n    overflow-y:scroll;\n    width: 530px;\n}\n/* inbox pagination */\n.WGinbox_buttons {\n	display:inline;\n	float:left;\n	font-size:10px;\n	text-align:left;\n	width:70%;	\n}\n.WGinbox_pagination {\n	display:inline;\n	text-align:right;\n	width:20%;\n}\n.WGinbox_messagerpp {\n	font-size:10px;\n	display:inline;\n	text-align:right;\n	width:20%;\n}\n.WGmessage {\n	display:inline;\n	float:left;\n	font-size:10px;\n	text-align:left;\n	width:70%;\n}\n\n.WGmessagerpp {\n	font-size:10px;\n	display:inline;\n	text-align:right;\n	float: right;\n}\n\n.WG-previous-next {\n	float: right;\n}\n\n/* inbox threads */\n\n.WGevenThread {\n	background-color: #e1e8fb;\n    border-bottom: 1px solid #bfcef9;\n    padding: 8px;\n    text-align:center;\n}\n.WGoddThread {\n	background-color: #eef2fd;\n    border-bottom: 1px solid #bfcef9;\n    padding: 8px;\n    text-align: center;\n}\n\n/* pagination */\n.WGProfile_pagination {\n	font-size:10px;\n	text-align:right;\n    width:20%;\n}\n.WGProfile_messagerpp {\n	font-size:10px;\n	display:inline;\n	text-align:right;\n	width:20%;\n}\n.WGProfile_paginationLeft {\n	font-size:10px;\n	text-align:left;\n	width:20%;\n}\n.WGProfile_paginationCenter {\n	font-size:10px;\n	text-align:center;\n	width:20%;\n}\n.WGProfile_pagination a {\n	background-color:#f2f5fa;\n	border:solid #bfc8dc 1px;\n	font-size:10px;\n	font-weight:bold;\n	padding:1px 5px;\n	text-decoration:none;\n}\n.WGProfile_pagination a:hover {\n	background-color:#d8dee8;\n	color:white;\n}\n.WGProfile_pagination .prevNext {\n    background-color: transparent;\n	border: none;\n    color: black;\n}\n.WGProfile_pagination .prevNext:hover {\n    background-color: transparent;\n	border: none;\n    color: black;\n}\n.WGProfile_pagination .active {\n    background-color:#d8dee8;\n	border:solid #bfc8dc 1px;\n	color:white; \n	font-size:10px;\n	font-weight:bold;\n	padding:1px 5px;\n	text-decoration:none;\n}\n.WGProfile_pagination img {\n	vertical-align:middle;\n	margin-top:2px;\n	border:none;\n}\n/* profile */\n.WGProfile_registration {\n	background:none;\n	border:none;\n	font-size:9pt;\n	font-family:arial;\n	margin:0;\n	padding:0;\n	width:100%;\n}\n.WGProfile_registration .header {\n	background-color:#818997;\n	color:#3e4f77;\n	font-size:10px;\n	font-weight:bold;\n	text-align:left;		\n}\n.WGProfile_registration .header a {\n	color:white;\n	text-decoration:none;			\n}\n.WGProfile_registration .help a {\n	font-weight:bold;\n	text-decoration:none;\n}\n.WGProfile_registration .inputText {\n	font-size:10px;\n	margin-right:1px;\n}\n.WGProfile_registration .label {\n	font-size:9pt;\n	font-weight:bold;\n	text-align:right;\n	white-space:nowrap;\n	width:1%;\n}	\n.WGProfile_registration .labelLeft {\n	font-size:9pt;\n	font-weight:bold;\n	white-space:nowrap;\n	width:1%;\n	text-align: left;\n	vertical-align: top;\n}\n.WGProfile_registration .smallLabel {\n	font-size:8px;\n	text-align:center;\n}\n.WGProfile_registration .smallText {\n	font-size:9px;\n}\n\n.WGinboxTbl {\n	display:block;\n	margin: 4px;\n	padding: 2px;\n}\n\n.WGProfile_registration .bar, .WGProfile_registration .barRight {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	margin:10px 0px 10px 0px;\n	min-height:25px;\n	padding:4px 4px 0px 4px;\n	vertical-align:middle;\n}\n.WGProfile_registration .bar {\n    text-align: center;\n}\n.WGProfile_registration .barRight {\n    text-align: right;\n}\n.WGProfile_registration .bar a {\n    color:#0B2259;\n    font-size:10px;\n	font-weight:bold;\n}\n.WGProfile_registration .barFive {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	text-align:center;\n	margin-right:3px;\n	min-height:25px;\n	padding:2px;\n	width:4.3%;\n}\n.WGProfile_registration .barTen {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	min-height:25px;\n	padding:2px;\n	text-align:center;\n	width:7.2%;\n}\n.WGProfile_registration .barFifteen {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	margin-right:3px;\n	min-height:25px;\n	padding:2px;\n	text-align:center;\n	width:15%;\n}\n.WGProfile_registration .barFifty {\n	background-color:#f2f5fa;\n	border: solid #d8dee8 1px;\n	color:#3e4f77;\n	font-size:14px;\n	font-weight:bold;\n	margin-right:3px;\n	min-height:25px;\n	padding:2px;\n	text-align:center;\n	width:50%;	\n}\n.WGbarContainer {\n	display:block;\n	margin:10px 0px 10px 0px;	\n	width:100%;\n\n}\n\n/* profile edit */\n\n.WGfields {\n	padding: 2px;\n\n}\n.WGfields_left {\n	padding:2px;\n	vertical-align:top;\n	width: 15%;\n}\n.WGfields_right {\n	display:inline\n	float:right;\n	padding:2px;\n	text-align:right;\n	width:80%;\n	vertical-align: top;\n}\n.WGProfile {\n	display:table;\n	margin: 0;\n	padding: 0;\n	width:100%;\n}\n.WGProfileFields {\n	border:0;\n	padding: 0;\n	margin:0;\n	width: 100%;\n	\n}\n.WGProfileFields ol {\n	display: inline;\n	list-style-type: none;\n	\n}\n.WGProfileFields ul {\n	list-style-type: none;\n	display: inline;\n}\n.WGProfileFields ul li {\n	display: inline-block;\n	*display: inline;\n	zoom: 1;\n}\n/* profile view */\n.WGProfile_accepts {\n	text-align:right;\n	background-color:gray;\n	padding:4px;\n	width:100%;\n}\n.WGviewContainer {\n	margin:0;\n	padding:0;\n	width:90%;\n}\n.WGinternational {\n	background-color:red;\n	color:white;\n	display:inline;\n	font-weight:bold;\n	padding:4px;\n	text-align:center;\n}\n\n.WGcategoryLabel {\n	vertical-align:top; \n	width:90%;\n}\n\n.WGprivateMessage {\n	background-color:gray;\n	padding:4px;\n	text-align:right;\n}\n\n.WGprofileAlert {\n	background-color:red;\n	color:white;\n	font-weight:bold;\n	padding:4px;\n	text-align:center;\n	width:100%;\n}\nWGprofilePhoto {\n	vertical-align:top;\n}\n\n/* profile errors */\n#WGprofileErrors {\n    background-color: #ff0000;\n	color: #ffffff;\n    font-weight: bold;\n    text-align: center;\n}\n.WGprofilefield_required_off {\n}\n.WGprofilefield_required {\n    background-color: #ffd6bb;\n}\n.WGprofilefield_error {\n    background-color: #FF9494;\n}\n.WGerrorMsg {\n	font-weight:bold;\n	color:red;\n	text-align:center;\n}\n/* user */\n.WGuserInvite_subject {\n 	background-color: white;\n	border: solid #BECEF8 1px;\n    height: 25px;\n    text-align: left;\n	width: 500px;\n    /*margin-left: 50px;*/\n    /*margin-bottom: 20px;*/\n    /*overflow:-moz-scrollbars-vertical;\n    overflow-x:hidden;\n	overflow-y:scroll;*/\n}\n/* view profile */\n\n.WGprofile_canEdit {\n	text-align:center;\n	background-color:red;\n	padding:4px;\n	color:white;\n	font-weight:bold;\n}\n.WGprofile_fieldLabel {\n	background: #DDE6FB;\n	padding:2px;\n	width:200px;\n}\n.WGprofile_fieldData {\n	margin-left: 5px;\n}\n.WGprofile_fieldStatus {\n	padding:4px;\n	color:white;\n	font-weight:bold\n}\n\n/**********************************************************************/\n/*                             TABS                                   */\n/**********************************************************************/\n\n/* TABS - outer */\n\n.WGbottombutton {\n    float:right;\n    padding-right:2px;\n    padding-top: 2px;\n    position: relative;\n} \n.WGcontent {\n	padding:10px;\n\n}\n.WGcleartab {\n	clear: both; \n	height:0;\n}\n.WGsubContent { /* color setting for border under outer tabs that surrounds inner tabs */\n	border: solid #d8dee8 6px;\n}\n.WGtopbutton {\n    float:right;\n    clear:both;\n    padding-right:2px;\n    padding-top: 2px;\n    position: relative;\n}\n\n\nul.WGtopTabs,\nul.WGtopTabs li {\n	list-style-type:none;\n	margin:10px 0px 0px 0px;\n	padding:0px;\n	position:relative;\n	width:auto;\n	Xposition:relative;\n	zoom:1;\n}\nul.WGtopTabs li {\n	display:block;\n	float:left;\n	margin-right: 3px;\n}\nul.WGtopTabs li b { \n	background-color: #eef2fd;\n	border-top:solid #d8dee8 1px;\n	display:block;\n	padding:4px 8px;\n	position:relative;\n	top:-1px;	\n}\nul.WGtopTabs a { /* non-selected tabs color settings */\n	display:block;\n	color:#9ea0bb;\n	font-size:12px;\n	font-family: Arial, Helvetica, sans-serif;\n	text-decoration:none;\n	background-color:#f2f5fa;\n	border-left: solid #d8dee8 1px;\n	border-right: solid #d8dee8 1px;	\n}\n\nul.WGtopTabs a:hover,\nul.WGtopTabs a:hover b,\nul.WGtopTabs a.selected,\nul.WGtopTabs a.selected b { /* selected tab color settings */\n	background-color:#d8dee8;\n	color:#3e4f77;\n}\n\n/* TABS - YUI */\n\n.WGcleardiv {\n    clear: both;\n    margin: 0px 0px 0px 0px;\n    padding: 0px;\n}\n\n.WGview {\n    border: none;\n    font: bold 10px Verdana;\n    color: #3e4f77;\n    text-decoration:none;\n    position: absolute;\n    right: 4px;\n    top:4px;\n}\n\n.WGprofile_displayView {\n    -x-system-font:none;\n    border:medium none;\n    color:#0B2258;\n    display:inline;\n    float:right;\n    font-family:Verdana;\n    font-size:10px;\n    font-size-adjust:none;\n    font-stretch:normal;\n    font-style:normal;\n    font-variant:normal;\n    font-weight:bold;\n    line-height:normal;\n    padding-right:8px;\n    padding-top:3px;\n    text-decoration: none;\n}\n\n.WGprofile_displaySubContent { /* border around friends tab content */\n	border: solid #d8dee8 6px;\n    border-top: solid #d8dee8 18px;\n}\n\n\n /*\nCopyright (c) 2008, Yahoo! Inc. All rights reserved.\nCode licensed under the BSD License:\nhttp://developer.yahoo.net/yui/license.txt\nversion: 2.6.0\n*/\n\n/* yui tabs color settings below */\n\n/* .yui-navset defaults to .yui-navset-top */\n.yui-skin-sam .yui-navset .yui-nav,\n.yui-skin-sam .yui-navset .yui-navset-top .yui-nav { /* protect nested tabviews from other orientations */\n    border:solid #eef2fd; /* color between tab list and content */\n    border-width:0 0 5px;\n    Xposition:relative;\n    zoom:1;\n}\n.yui-skin-sam .yui-navset .yui-nav a,\n.yui-skin-sam .yui-navset .yui-navset-top .yui-nav a {\n    	background:#ffffff;  /* tab background */\n    	border:solid #ffffff;\n    	border-width:0 1px;\n    	color:#bfccdd;\n    	position:relative;\n    	text-decoration:none;\n    	font-size:12px;\n		font-family: Arial, Helvetica, sans-serif;\n		font-weight: bold;\n}\n\n.yui-skin-sam .yui-navset .yui-nav a em,\n.yui-skin-sam .yui-navset .yui-navset-top .yui-nav a em {\n    border:solid #eef2fd;\n    border-width:1px 0 0;\n    cursor:hand;\n    padding:0.25em .75em;\n    left:0; right: 0; bottom: 0; /* protect from other orientations */\n    top:-1px; /* for 1px rounded corners */\n    position:relative;\n}\n\n.yui-skin-sam .yui-navset .yui-nav .selected a,\n.yui-skin-sam .yui-navset .yui-nav .selected a:focus, /* no focus effect for selected */\n.yui-skin-sam .yui-navset .yui-nav .selected a:hover { /* no hover effect for selected */\n    	background: #eef2fd; /* selected tab background */\n    	color: #3e4f77;\n    	font-size:12px;\n		font-family: Arial, Helvetica, sans-serif;\n		text-decoration:none;\n		font-weight: bold;\n}\n.yui-skin-sam .yui-navset .yui-nav .selected a,\n.yui-skin-sam .yui-navset .yui-nav .selected a em {\n    border-color:#eef2fd; /* selected tab border color */\n}\n\n.yui-skin-sam .yui-navset .yui-nav a:hover,\n.yui-skin-sam .yui-navset .yui-nav a:focus {\n    	background: #eef2fd; /* hover tab background */\n    	color: #3e4f77;\n    	outline:0;\n    	font-size:12px;\n		font-family: Arial, Helvetica, sans-serif;\n		text-decoration:none;\n		font-weight: bold;\n\n}\n.yui-skin-sam .yui-navset .yui-content {\n    background: #eef2fd; /* content background color */\n}\n\n.yui-skin-sam .yui-navset .yui-content,\n.yui-skin-sam .yui-navset .yui-navset-top .yui-content {\n    border:5px solid #eef2fd; /* content border */\n    padding:0.75em 1em; /* content padding */\n}\n\n/* left and right orientations */\n.yui-skin-sam .yui-navset-left .yui-nav,\n.yui-skin-sam .yui-navset .yui-navset-left .yui-nav,\n.yui-skin-sam .yui-navset .yui-navset-right .yui-nav,\n.yui-skin-sam .yui-navset-right .yui-nav {\n    border-width:0 5px 0 0;\n    Xposition:absolute; /* from tabview-core; have to reiterate for skin-sam due to pos:rel on skin-sam yui-nav */\n    top:0; bottom:0; /* stretch to fill content height */\n}\n\n.yui-skin-sam .yui-navset .yui-navset-right .yui-nav,\n.yui-skin-sam .yui-navset-right .yui-nav {\n    border-width:0 0 0 5px;\n}\n\n.yui-skin-sam .yui-navset-left .yui-nav li,\n.yui-skin-sam .yui-navset .yui-navset-left .yui-nav li,\n.yui-skin-sam .yui-navset-right .yui-nav li {\n    margin:0 0 0.3em; /* space between tabs */\n    padding:0 0 0 1px; /* gecko: make room for overflow */\n}\n\n.yui-skin-sam .yui-navset-right .yui-nav li {\n    padding:0 1px 0 0; /* gecko: make room for overflow */\n}\n\n.yui-skin-sam .yui-navset-left .yui-nav .selected,\n.yui-skin-sam .yui-navset .yui-navset-left .yui-nav .selected { \n    margin:0 -1px 0.16em 0;\n}\n\n.yui-skin-sam .yui-navset-right .yui-nav .selected { \n    margin:0 0 0.16em -1px;\n}\n\n.yui-skin-sam .yui-navset-left .yui-nav a,\n.yui-skin-sam .yui-navset-right .yui-nav a {\n    border-width:1px 0;\n}\n\n.yui-skin-sam .yui-navset-left .yui-nav a em,\n.yui-skin-sam .yui-navset .yui-navset-left .yui-nav a em,\n.yui-skin-sam .yui-navset-right .yui-nav a em {\n    border-width:0 0 0 1px;\n    padding:0.2em .75em;\n    top:auto;\n    left:-1px; /* for 1px rounded corners */\n}\n\n.yui-skin-sam .yui-navset-right .yui-nav a em {\n    border-width:0 1px 0 0;\n    left:auto;\n    right:-1px; /* for 1px rounded corners */\n}\n.yui-skin-sam .yui-navset-left .yui-nav a,\n.yui-skin-sam .yui-navset-left .yui-nav .selected a,\n.yui-skin-sam .yui-navset-left .yui-nav a:hover,\n.yui-skin-sam .yui-navset-right .yui-nav a,\n.yui-skin-sam .yui-navset-right .yui-nav .selected a,\n.yui-skin-sam .yui-navset-right .yui-nav a:hover,\n.yui-skin-sam .yui-navset-bottom .yui-nav a,\n.yui-skin-sam .yui-navset-bottom .yui-nav .selected a,\n.yui-skin-sam .yui-navset-bottom .yui-nav a:hover {\n    background-image:none; /* no left-right or bottom-top gradient */\n}\n.yui-skin-sam .yui-navset-left .yui-content {\n    border:1px solid #d8dee8; /* content border */\n}\n/* bottom orientation */\n.yui-skin-sam .yui-navset-bottom .yui-nav,\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav {\n    border-width:5px 0 0; /* color between tab list and content */\n}\n\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav .selected,\n.yui-skin-sam .yui-navset-bottom .yui-nav .selected { \n    margin:-1px 0.3em 0 0; /* for overlap */\n}\n\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li,\n.yui-skin-sam .yui-navset-bottom .yui-nav li { \n    padding:0 0 1px 0; /* gecko: make room for overflow */\n    vertical-align:top;\n}\n\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li a,\n.yui-skin-sam .yui-navset-bottom .yui-nav li a { \n}\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav a em,\n.yui-skin-sam .yui-navset-bottom .yui-nav a em {\n    border-width:0 0 1px;\n    top:auto;\n    bottom:-1px; /* for 1px rounded corners */\n}\n.yui-skin-sam .yui-navset-bottom .yui-content,\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-content {\n    border:1px solid #f2f5fa; /* content border */\n}\n.yui-skin-sam {\n	background-color: #d8dee8;\n	padding: 10px 5 5 5px;\n	display:block;\n}\n\n/* yui tab placement settings below */\n\n.yui-skin-sam .yui-navset .yui-nav li,\n.yui-skin-sam .yui-navset .yui-navset-top .yui-nav li {\n    margin:0 0.3em 0 0; /* space between tabs */\n    padding:5px 0 0; /* gecko: make room for overflow */\n    zoom:1;\n}\n\n.yui-skin-sam .yui-navset .yui-nav .selected,\n.yui-skin-sam .yui-navset .yui-navset-top .yui-nav .selected { \n    margin:0 0.3em -1px 0; /* for overlap */\n}\n\n.yui-navset .yui-nav li,.yui-navset .yui-navset-top .yui-nav li,\n.yui-navset .yui-navset-bottom .yui-nav li {\n	margin:0 0.5em 0 0;\n}\n.yui-navset-left .yui-nav li,.yui-navset-right .yui-nav li {\n	margin:0 0 0.5em;\n}\n.yui-navset .yui-content .yui-hidden {\n	display:none;\n}\n.yui-navset .yui-navset-left .yui-nav,.yui-navset .yui-navset-right .yui-nav,\n.yui-navset-left .yui-nav,.yui-navset-right .yui-nav {\n	width:6em;\n}\n.yui-navset-top .yui-nav,.yui-navset-bottom .yui-nav {\n	width:auto;\n}\n.yui-navset .yui-navset-left,.yui-navset-left {\n	padding:0 0 0 6em;\n}\n.yui-navset-right {\n	padding:0 6em 0 0;\n}\n.yui-navset-top,.yui-navset-bottom {\n	padding:auto;\n}\n.yui-nav,.yui-nav li {\n	list-style:none;\n	margin:0;\n	padding:0;	\n}\n.yui-navset li em {\n	font-style:normal;\n}\n.yui-navset {\n	position:relative;\n	zoom:1;\n}\n.yui-navset .yui-content {\n	zoom:1;\n}\n.yui-navset .yui-nav li,.yui-navset .yui-navset-top .yui-nav li,\n.yui-navset .yui-navset-bottom .yui-nav li {\n	display:inline-block;\n	display:-moz-inline-stack;\n	*display:inline;\n	vertical-align:bottom;\n	cursor:pointer;\n	zoom:1;\n}\n.yui-navset-left .yui-nav li,.yui-navset-right .yui-nav li {\n	display:block;\n}\n.yui-navset .yui-nav a {\n	position:relative;\n}\n.yui-navset .yui-nav li a,.yui-navset-top .yui-nav li a,\n.yui-navset-bottom .yui-nav li a {\n	display:block;\n	display:inline-block;\n	vertical-align:bottom;\n	zoom:1;\n}\n.yui-navset-left .yui-nav li a,.yui-navset-right .yui-nav li a {\n	display:block;\n}\n.yui-navset-bottom .yui-nav li a {\n	vertical-align:text-top;\n}\n.yui-navset .yui-nav li a em,.yui-navset-top .yui-nav li a em,\n.yui-navset-bottom .yui-nav li a em {\n	display:block;\n}\n.yui-navset .yui-navset-left .yui-nav,.yui-navset .yui-navset-right .yui-nav,\n.yui-navset-left .yui-nav,.yui-navset-right .yui-nav {\n	position:absolute;\n	z-index:1;\n}\n.yui-navset-top .yui-nav,.yui-navset-bottom .yui-nav {\n	position:static;\n}\n.yui-navset .yui-navset-left .yui-nav,.yui-navset-left .yui-nav {\n	left:0;\n	right:auto;\n}\n.yui-navset .yui-navset-right .yui-nav,.yui-navset-right .yui-nav {\n	left:auto;\n	right:0;\n}\n.yui-skin-sam .yui-navset .yui-nav .selected a em {\n	padding:0.35em 0.75em;\n}\n.yui-skin-sam .yui-navset-left .yui-nav,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav,\n.yui-skin-sam .yui-navset .yui-navset-right .yui-nav,.yui-skin-sam .yui-navset-right .yui-nav {\n	border-width:0 5px 0 0;\n	bottom:0;\n	top:0;\n	Xposition:absolute;\n}\n.yui-skin-sam .yui-navset .yui-navset-right .yui-nav,.yui-skin-sam .yui-navset-right .yui-nav {\n	border-width:0 0 0 5px;\n}\n.yui-skin-sam .yui-navset-left .yui-nav li,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav li,\n.yui-skin-sam .yui-navset-right .yui-nav li {\n	margin:0 0 0.16em;\n	padding:0 0 0 1px;\n}\n.yui-skin-sam .yui-navset-right .yui-nav li {\n	padding:0 1px 0 0;\n}\n.yui-skin-sam .yui-navset-left .yui-nav a,.yui-skin-sam .yui-navset-right .yui-nav a {\n	border-width:1px 0;\n}\n.yui-skin-sam .yui-navset-left .yui-nav a em,.yui-skin-sam .yui-navset .yui-navset-left .yui-nav a em,.yui-skin-sam .yui-navset-right .yui-nav a em {\n	border-width:0 0 0 1px;\n	left:-1px;\n	padding:0.2em .75em;\n	top:auto;\n}\n.yui-skin-sam .yui-navset-right .yui-nav a em {\n	border-width:0 1px 0 0;\n	left:auto;\n	right:-1px;\n}\n\n.yui-skin-sam .yui-navset-left .yui-nav a,.yui-skin-sam .yui-navset-left .yui-nav .selected a,.yui-skin-sam .yui-navset-left .yui-nav a:hover,\n.yui-skin-sam .yui-navset-right .yui-nav a,.yui-skin-sam .yui-navset-right .yui-nav .selected a,.yui-skin-sam .yui-navset-right .yui-nav a:hover,\n.yui-skin-sam .yui-navset-bottom .yui-nav a,.yui-skin-sam .yui-navset-bottom .yui-nav .selected a,\n.yui-skin-sam .yui-navset-bottom .yui-nav a:hover {\n	background-image:none;\n}\n\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav .selected,\n.yui-skin-sam .yui-navset-bottom .yui-nav .selected {\n	margin:-1px 0.16em 0 0;\n}\n\n.yui-skin-sam .yui-navset .yui-navset-bottom .yui-nav li,\n.yui-skin-sam .yui-navset-bottom .yui-nav li {\n	padding:0 0 1px 0;\n	vertical-align:top;\n}\n',0,'text/css',1234924781,3600),('wrq7hMxb1ewQqZ46xmd8Gg','function equalCol() {\r\n	var colOne = document.getElementById(\'compareForm\');\r\n	var colTwo = document.getElementById(\'matrixRight\');	\r\n	var colOneH = colOne.offsetHeight;\r\n	var colTwoH = colTwo.offsetHeight;	\r\n	\r\n	//alert(colOneH + \", \" + colTwoH);\r\n	colOne.style.overflow = \"scroll\";\r\n	colOne.style.height = (colTwoH - 150) + \"px\";\r\n}',0,'text/javascript',1235706620,3600),('hkj6WeChxFyqfP85UlRP8w','.wg-clear {\r\n	display: inline;\r\n	clear: both;\r\n	font-size:0px;\r\n	line-height:0px;\r\n}\r\n\r\n/* COLUMN STYLES */\r\n#matrixLeft {\r\n	float:left;\r\n	width:65%;\r\n	padding:1%;\r\n	min-height:1%;\r\n	background-color:#d2d2d2;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;	\r\n}\r\n#matrixRight {\r\n	float:left;\r\n	width:25%;\r\n	padding:0px;\r\n	min-height:1%;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;\r\n	border: solid silver 1px;\r\n	background-color:white;	\r\n	margin-left:5px;\r\n}\r\n\r\n\r\n\r\n/* DROPSHADOW BUTTONS */\r\n#matrixLeft .buttons span {\r\n	background-color:#888;\r\n	position:relative;\r\n	padding:5px 0px 0px 0px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;\r\n\r\n}\r\n#matrixLeft .buttons button,\r\n#matrixLeft .buttons a#return {\r\n	border:solid #2f495e 2px;\r\n	position:relative;\r\n	background-color:#e1e1e1;\r\n	padding:auto 3px;\r\n	margin:0px;\r\n	font-size:11px;\r\n	line-height:13px;\r\n	position:relative;\r\n	top:-6px;\r\n	left:-2px;\r\n	height:22px;\r\n	cursor:pointer;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;	\r\n	font-weight:bold;\r\n	text-decoration:none;\r\n	color:#333;\r\n}\r\n#matrixLeft .buttons a#return {\r\n	font-size:10px;\r\n	padding:3px 10px 2px 10px;\r\n}\r\n#matrixLeft .buttons button:hover,\r\n#matrixLeft .buttons a#return:hover {\r\n	border-color:black;\r\n	color:white;\r\n	background-color:#444;\r\n}\r\n\r\n\r\n\r\n/* WHITE AREA FOR THE LISTING OF OBJECTS TO COMPARE */\r\n#matrixLeft .matrixListing {\r\n	background-color:white;\r\n	_height:300px;\r\n	min-height:300px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius: 4px;	\r\n	margin:10px 2px 20px 2px;\r\n	padding:auto 10px;\r\n}\r\n#matrixLeft .matrixListing table {\r\n	border-collapse:collapse;\r\n	margin:0px;\r\n	padding:0px;\r\n	display:block;\r\n}\r\n#matrixLeft .matrixListing table a:link {\r\n	font-size:12px;\r\n	color:#111;\r\n}\r\n#matrixLeft .matrixListing table a:visited {\r\n	color:#333;\r\n	font-size:12px;\r\n	text-decoration:none;\r\n}\r\n#matrixLeft .matrixListing table a:hover {\r\n	text-decoration:none;\r\n}\r\n\r\n\r\n\r\n/* GRAY BAR THAT HOLDS THE SORT BUTTONS */\r\n#matrixLeft .matrixListing .sortButtons {\r\n	background-color:#f1f1f1;\r\n	border:solid silver 1px;\r\n	-moz-border-radius-topLeft:4px;\r\n	-moz-border-radius-topRight:4px;\r\n	-webkit-border-radius-topLeft: 4px;\r\n	-webkit-border-radius-topRight: 4px;	\r\n	border-bottom:solid #D2D2D2 2px;\r\n	display:block;\r\n}\r\n\r\n\r\n\r\n/* STYLES TO OVERRIDE THE SORT BUTTON CSS BUILT INTO THE PERL CODE */\r\n#sortByViews-button,\r\n#sortByCompares-button,\r\n#sortByUpdated-button,\r\n#sortByClicks-button {\r\n	background: none;\r\n	white-space:nowrap;\r\n	border-style:none;\r\n	cursor:pointer;\r\n	padding-bottom:4px;\r\n	border-style:none;\r\n	background-color:transparent;\r\n	border-right:solid silver 1px;\r\n	color:#555;\r\n}\r\n#sortByViews-button:hover,\r\n#sortByCompares-button:hover,\r\n#sortByUpdated-button:hover,\r\n#sortByClicks-button:hover {\r\n	color:black;\r\n}\r\n\r\n\r\n\r\n/* MATRIX STATISTICS */\r\n#matrixRight .mainTitle {\r\n	font-size:20px;\r\n	padding:5px 10px;\r\n	border-bottom: solid gray 1px;\r\n	background-color:#d2d2d2;\r\n}\r\n#matrixRight .textBox {\r\n	border-top:solid silver 1px;\r\n	padding:10px 5px;\r\n}\r\n.matrixStatistics {\r\n	padding:10px;\r\n}\r\n.matrixStatistics .title {\r\n	font-weight:bold;\r\n	background-color:#f1f1f1;\r\n	padding:2px 5px;\r\n	font-size:11px;\r\n	-moz-border-radius:4px;\r\n	border:solid #d2d2d2 1px;\r\n}\r\n.matrixStatistics .statistics {\r\n	margin-bottom:15px;\r\n}\r\n.matrixStatistics .label {\r\n	text-align:right;\r\n	width:100px;\r\n	font-size:10px;\r\n}\r\n.matrixStatistics .data {\r\n	font-size:10px;\r\n}\r\n.matrixStatistics .data a {\r\n	color:#111;\r\n}\r\n.matrixStatistics .data a:hover {\r\n	text-decoration:none;\r\n}\r\n\r\n\r\n\r\n/* LINKS TO CONTROL ADMIN FUNCTIONS */\r\n.adminLinks {\r\n	background-color:#f1f1f1;\r\n}\r\n.adminLinks a:link,\r\n.adminLinks a:visited {\r\n	display:block;\r\n	text-align:center;\r\n	text-decoration:none;\r\n	color:#555;\r\n	font-weight:normal;\r\n	font-size:10px;\r\n	padding:2px 5px;\r\n	border-top:solid silver 1px;\r\n}\r\n.adminLinks a:hover {\r\n	color:black;\r\n}\r\n.adminLinks a.newLink:link,\r\n.adminLinks a.newLink:visited {\r\n	background-color:#3498d1;\r\n	color:white;\r\n	display:block;\r\n}\r\n.adminLinks a.newLink:hover {\r\n	background-color:#39a6e5;\r\n}\r\n\r\n\r\n\r\n/* STYLE FOR THE DETAILED LISTING */\r\n#matrixDetail {\r\n	min-width:1000px;\r\n}\r\n#matrixDetail .editBtns  {\r\n	font-size:9px;\r\n	line-height:11px;\r\n	vertical-align:middle;\r\n	font-weight:normal;\r\n	margin-left:10px;\r\n}\r\n#matrixDetail .editBtns a {\r\n	color:black;\r\n	text-decoration:underline;\r\n}\r\n#matrixDetail .editBtns a:hover {\r\n	text-decoration:none;\r\n}\r\n\r\n#matrixDetail .stats .screenshot {\r\n	float:left;\r\n	margin-right:20px;\r\n}\r\n\r\n#matrixDetail .commentsMail strong.title {\r\n	margin-bottom:0px;\r\n	margin-top:20px;\r\n	display:block;\r\n	background-color:#d2d2d2;\r\n	padding:2px 10px;\r\n	border:solid 1px gray;\r\n	border-bottom-color:silver;\r\n	-moz-border-radius-topLeft:4px;\r\n	-moz-border-radius-topRight:4px;\r\n}\r\n\r\n#matrixDetail .assetAspectComments {\r\n	margin:0px 0px 20px 0px;\r\n	border:solid gray 1px;\r\n	background-color:#f1f1f1;\r\n	-moz-border-radius-bottomLeft:4px;\r\n	-moz-border-radius-bottomRight:4px;\r\n}\r\n#matrixDetail .assetAspectComments .assetAspectComment {\r\n	border-top:solid silver 1px;\r\n	border-bottom:solid gray 1px;\r\n	padding:3px;\r\n	background-color:#f5f5f5;\r\n}\r\n#matrixDetail .assetAspectComments .assetAspectCommentForm {\r\n	border-top:solid #d2d2d2 5px;\r\n	padding:20px;\r\n}\r\n\r\n\r\n\r\n#matrixDetail .stats ul, #matrixDetail .stats ul li {\r\n	list-style-type:none;\r\n	margin:0px;\r\n	padding:0px;\r\n}\r\n#matrixDetail .stats ul li {\r\n	display:block;\r\n	line-height:20px;\r\n	margin:4px 0px;\r\n}\r\n#matrixDetail .stats ul li strong {\r\n	display:block;\r\n	float:left;\r\n	width:130px;\r\n	text-align:right;\r\n	background-color:#f1f1f1;\r\n	padding-right:5px;\r\n	margin-right:5px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:3px;\r\n	font-size:11px;\r\n	border:solid #d2d2d2 1px;\r\n}\r\n\r\n\r\n.showLink {\r\n	background-color:#e1e1e1;\r\n	border:2px solid #2F495E;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:4px;\r\n	padding:3px 10px;\r\n	text-decoration:none;\r\n	color:black;\r\n}\r\n.showLink:hover,\r\n.hideLink:hover {\r\n	background-color:#555;\r\n	color:white;\r\n}\r\n.hideLink {\r\n	background-color:#f1f1f1;\r\n	border:2px solid #2F495E;\r\n	border-bottom-style:none;\r\n	-moz-border-radius-topLeft:4px;\r\n	-moz-border-radius-topRight:4px;\r\n	-webkit-border-radius-topLeft:4px;\r\n	-webkit-border-radius-topRight:4px;\r\n	padding:3px 10px;\r\n	text-decoration:none;\r\n	color:black;\r\n}\r\n\r\n#matrixMail {\r\n	background-color:#f1f1f1;\r\n	padding:15px;\r\n	border:2px solid #2F495E;\r\n	-moz-border-radius:4px;\r\n	-moz-border-radius-topLeft:0px;\r\n	-webkit-border-radius:4px;\r\n	-webkit-border-radius-topLeft:0px;\r\n	margin-top:1px;\r\n}\r\n#matrixMail * .tableData {\r\n	padding:5px;\r\n	margin:0px;\r\n}\r\n#matrixMail * input {\r\n	padding:0px;\r\n	margin:0px;\r\n}\r\n#matrixMail * .formDescription {\r\n	text-align:right;\r\n	vertical-align:middle;\r\n	padding-right:10px;\r\n	font-weight:bold;\r\n}\r\n#matrixMail form * img {\r\n	margin-top:-18px;\r\n}\r\n#matrixMail #verify_formId {\r\n	height:45px;\r\n	line-height:45px;\r\n	font-size:35px;\r\n	padding:0px;\r\n	margin:0px;\r\n	margin-right:20px;\r\n}\r\n\r\n#matrixRatings {\r\n	width:264px;\r\n	position:relative;\r\n	left:-2px;\r\n	top:12px;\r\n}\r\n#matrixRatings table {\r\n	margin-left:0px;\r\n}\r\n#matrixRatings td {\r\n	overflow:hidden;\r\n}\r\n#matrixRatings .formDescription {\r\n	text-align:right;\r\n	background-color:#97BCD1;\r\n	border:solid #4D606B 1px;\r\n	padding:2px 5px;\r\n	font-weight:bold;\r\n	font-size:10x;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:4px;\r\n	color:#333;\r\n}\r\n#matrixRatings .formDescription a:before {\r\n	text-decoration:none;\r\n}\r\n#matrixRatings .formDescription a {\r\n	display:block;\r\n	color:red;\r\n	text-decoration:none;\r\n}\r\n#matrixRatings .formDescription a:hover {\r\n	text-decoration:underline;\r\n}\r\n\r\n\r\n\r\n\r\n#matrixAttributes {\r\n	float:left;\r\n	_width:40%;\r\n	min-width:20%;\r\n	max-width:45%;\r\n	margin-right:20px;\r\n}\r\n#rightDetails {\r\n	float:left;\r\n	_width:20%;\r\n	min-width:20%;\r\n	max-width:45%;\r\n}\r\n\r\n\r\n\r\n#attributes {\r\n	border:solid #d2d2d2 1px;\r\n	background-color:#f1f1f1;\r\n	margin-top:10px;\r\n	-moz-border-radius:4px;\r\n	-webkit-border-radius:4px;\r\n	padding:10px;\r\n}\r\n#attributes table {\r\n	border-collapse:collapse;\r\n	padding:0px;\r\n	margin:0px;\r\n}\r\n#attributes table * td {\r\n	padding:2px;\r\n	margin:0px;\r\n}\r\n\r\n\r\n.yui-dt0-col-value {\r\n	font-weight:bold;\r\n	font-size:14px;\r\n	padding:3px;\r\n	white-space:no-wrap;\r\n}\r\n\r\n\r\n\r\n/* COMPARISON STYLES */\r\n#compareList table {\r\n	border-collapse:collapse;\r\n	border:solid silver 1px;\r\n	margin-top:5px;\r\n}\r\n#compareList table * th a {\r\n	color:black;\r\n	padding:1px 5px;\r\n}\r\n#compareList table * td {\r\n	background-color:#f1f1f1;\r\n	border-top:solid gray 1px;\r\n	border-bottom:solid silver 1px;\r\n}\r\n\r\n#compareList .yui-dt-liner {\r\n	color:#39A6E5;\r\n}\r\n\r\n#compareList .yui-dt-col-name .yui-dt-liner {\r\n	font-style:italic;\r\n	font-size:10px;\r\n	color:#555;\r\n}\r\n#compareList .yui-dt-col-name .yui-dt-liner b {\r\n	font-size:15px;\r\n	font-style:normal;\r\n	padding-right:25px;\r\n	color:black;\r\n}',0,'text/css',1239898573,0),('F2CZVJtKtTs67DWwqDI96g','#loading-mask {\r\n  position: absolute;\r\n  left:     0;\r\n  top:      0;\r\n  width:    100%;\r\n  height:   100%;\r\n  z-index:  20000;\r\n  background-color: white;\r\n  opacity:0.6;\r\n  filter:alpha(opacity=60);\r\n}\r\n\r\n#loading {\r\n  position: absolute;\r\n  left:     50%;\r\n  top:      50%;\r\n  padding:  2px;\r\n  z-index:  20001;\r\n  height:   auto;\r\n  margin:   -35px 0 0 -30px;\r\n}\r\n\r\n#loading .loading-indicator {\r\n  background: url(^Extras(wobject/Survey/rel_interstitial_loading.gif);) no-repeat;\r\n  color:      #555;\r\n  font:       bold 13px tahoma,arial,helvetica;\r\n  padding:    18px 80px;\r\n  margin:     0;\r\n  text-align: center;\r\n  height:     auto;\r\n  z-index:  20002;\r\n}\r\n\r\ndiv.testarea {\r\n    width: 200px;\r\n    height: 100px;\r\n    z-index: 999;\r\n    border: 1px solid gray;\r\n    background: #f7f7f7;\r\n    position: absolute;\r\n    top: 5%;\r\n    left:5%;\r\n}\r\n\r\ndiv.trashcan { \r\n    border: 1px solid gray;\r\n    width: 175px; \r\n    height: 50px; \r\n}\r\ndiv.workarea { \r\n	padding:10px; \r\n	padding-top:40px; \r\n	float:left \r\n}\r\n\r\ndiv.editarea { \r\n	margin-top:40px;\r\n    padding:10px; \r\n    float:left;\r\n    border: 1px solid gray;\r\n}\r\n\r\ndiv.editquestion { \r\n	padding:10px; \r\n	float:left; \r\n}\r\ndiv.editanswer { \r\n	padding:10px; \r\n	float:left; \r\n}\r\n\r\n#submitbutton { padding:20px; }\r\n\r\ndiv.entry { \r\n    padding-bottom:10px;\r\n    padding-left:10px;\r\n}\r\n\r\nul.draglist { \r\n    position: relative;\r\n    width: 340px; \r\n    background: #f7f7f7;\r\n    border: 1px solid gray;\r\n    list-style: none;\r\n    margin:0;\r\n    padding:0;\r\n    padding-bottom:20px;\r\n}\r\n\r\nul.draglist li {\r\n    margin: 5px;\r\n}\r\n\r\nul.questionList {\r\n    position: relative;\r\n    background: #f7f7f7;\r\n    border: 1px solid gray;\r\n    list-style: none;\r\n    margin:0;\r\n    padding:0;\r\n    min-height: 40px\r\n}\r\n\r\nli.section {\r\n    background-color: #CCCCFF;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n    min-height: 10px;\r\n}\r\n\r\nli.ssection {\r\n    background-color: #E76300;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n    min-height: 10px;\r\n}\r\n\r\nli.squestion {\r\n    background-color: #CC6600;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n	padding-left:15px; \r\n    width: 80%;\r\n    min-height: 10px;\r\n}\r\nli.newQuestion {\r\n#    background-color: #D1E6EC;\r\n#    border:1px solid #7EA6B2;\r\n#    cursor: move; \r\n	padding-left:25px; \r\n}\r\n\r\nli.question {\r\n    background-color: #D1E6EC;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n	padding-left:15px; \r\n    width:80%;\r\n    min-height: 10px;\r\n}\r\n\r\nli.answer {\r\n    background-color: #D1E6EC;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n	padding-left:50px; \r\n    width:60%;\r\n    min-height: 10px;\r\n}\r\nli.sanswer {\r\n    background-color: #CC6600;\r\n    border:1px solid #7EA6B2;\r\n    cursor: move; \r\n	padding-left:50px; \r\n    width:60%;\r\n    min-height: 10px;\r\n}\r\nli.newAnswer {\r\n#    background-color: #D1E6EC;\r\n#    border:1px solid #7EA6B2;\r\n    padding-left:50px;    \r\n#    cursor: move; \r\n}\r\n\r\n',1,'text/html',1244584987,3600);
INSERT INTO `template` VALUES ('<a href=\"<tmpl_var toggle.url>\"><tmpl_var toggle.text></a>','Macro/AdminToggle',1,1,'PBtmpl0000000000000036',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a class=\"myAccountLink\" href=\"<tmpl_var account.url>\"><tmpl_var account.text></a>','Macro/a_account',1,1,'PBtmpl0000000000000037',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a href=\"<tmpl_var toggle.url>\"><tmpl_var toggle.text></a>','Macro/EditableToggle',1,1,'PBtmpl0000000000000038',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a href=\"<tmpl_var group.url>\"><tmpl_var group.text></a>','Macro/GroupAdd',1,1,'PBtmpl0000000000000040',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a href=\"<tmpl_var group.url>\"><tmpl_var group.text></a>','Macro/GroupDelete',1,1,'PBtmpl0000000000000041',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a class=\"homeLink\" href=\"<tmpl_var homeLink.url>\"><tmpl_var homeLink.text></a>','Macro/H_homeLink',1,1,'PBtmpl0000000000000042',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a class=\"loginToggleLink\" href=\"<tmpl_var toggle.url>\"><tmpl_var toggle.text></a>','Macro/LoginToggle',1,1,'PBtmpl0000000000000043',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a class=\"makePrintableLink\" href=\"<tmpl_var printable.url>\"><tmpl_var printable.text></a>','Macro/r_printable',1,1,'PBtmpl0000000000000045',1129049186,'WebGUI::Asset::Template::HTMLTemplate',1),('<a href=\"<tmpl_var file.url>\"><tmpl_var file.name></a>','Macro/File',1,1,'PBtmpl0000000000000091',1129049189,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_var body.content>','style',0,0,'PBtmpl0000000000000132',1129049190,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n	<div style=\"width: 100%; border: 1px groove black;\">\n		<div style=\"width: 100%; background-image: url(<tmpl_var session.config.extrasURL>/opaque.gif);\">\n			<div style=\"text-align: center; font-weight: bold;\"><a href=\"<tmpl_var originalURL>\"><tmpl_var shortcut.label></a></div>\n		</div>\n</tmpl_if>\n<tmpl_var shortcut.content>\n<tmpl_if session.var.adminOn>\n		<div style=\"width: 100%; background-image: url(<tmpl_var session.config.extrasURL>/opaque.gif);\">\n			<div style=\"text-align: center; font-weight: bold;\"><a href=\"<tmpl_var originalURL>\"><tmpl_var shortcut.label></a></div>\n		</div>\n	</div>\n</tmpl_if>\n','Shortcut',1,1,'PBtmpl0000000000000140',1129573244,'WebGUI::Asset::Template::HTMLTemplate',1),('<p><tmpl_var body></p>\n\n<tmpl_if fields>\n<dl>\n	<tmpl_loop fields>\n   		<dt><tmpl_var title></dt>\n	        <dd><tmpl_var description>\n			<tmpl_if uiLevel> <br /><i><tmpl_var uiLevelLabel>:</i><tmpl_var uiLevel><br /> </tmpl_if>\n		</dd>\n        </tmpl_loop>\n</dl>\n</tmpl_if>\n\n<tmpl_if variable_loop1>\n	<dl> <tmpl_loop variable_loop1>\n		<dt><tmpl_var title></dt>\n		<dd><tmpl_var description>\n		<tmpl_if variable_loop2>\n			<dl> <tmpl_loop variable_loop2>\n				<dt><tmpl_var title></dt>\n				<dd><tmpl_var description>\n				<tmpl_if variable_loop3>\n					<dl> <tmpl_loop variable_loop3>\n						<dt><tmpl_var title></dt>\n						<dd><tmpl_var description>\n						<tmpl_if variable_loop4>\n							<dl> <tmpl_loop variable_loop4>\n								<dt><tmpl_var title></dt>\n								<dd><tmpl_var description></dd>\n							</tmpl_loop> </dl>\n						</tmpl_if></dd>\n					</tmpl_loop> </dl>\n				</tmpl_if></dd>\n			</tmpl_loop> </dl>\n		</tmpl_if></dd>\n	</tmpl_loop> </dl>\n</tmpl_if>\n\n','AdminConsole',1,1,'PBtmplHelp000000000001',1147642410,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.title.url>\"><tmpl_var subject.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.username.url>\"><tmpl_var user.label></a></td>\n<tmpl_if karmaIsEnabled>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.karmaRank.url>\"><tmpl_var karmaRank.label></a></td>\n</tmpl_if karmaIsEnabled>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.rating.url>\"><tmpl_var rating.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<tmpl_if displayLastReply>\n		<td class=\"forumHead\"><a href=\"<tmpl_var sortby.lastreply.url>\"><tmpl_var lastReply.label></a></td>\n	</tmpl_if>\n</tr>\n<tmpl_loop post_loop>\n<tr>\n\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a></td>\n	<tmpl_if user.isVisitor>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n	<tmpl_else>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n	</tmpl_if>\n<tmpl_if karmaIsEnabled>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var karmaRank></td>\n</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var rating></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateSubmitted.human> @ <tmpl_var timeSubmitted.human></td>\n	<tmpl_if displayLastReply>\n		<td  class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" style=\"font-size: 11px;\">\n			<a href=\"<tmpl_var lastReply.url>\"><tmpl_var lastReply.title></a>\n			by\n			<tmpl_if lastReply.user.isVisitor>\n				<tmpl_var lastReply.username>\n			<tmpl_else>\n				<a href=\"<tmpl_var lastReply.userProfile.url>\"><tmpl_var lastReply.username></a>\n			</tmpl_if>\n			on <tmpl_var lastReply.dateSubmitted.human> @ <tmpl_var lastReply.timeSubmitted.human>\n		</td>\n	</tmpl_if>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n','Collaboration',1,1,'PBtmpl0000000000000208',1147642410,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n\n<br />\n\n<tmpl_loop post_loop>\n	<div class=\"ad\">\n		<div style=\"text-align: center;\">\n			<b><a href=\"<tmpl_var url>\"><tmpl_var title></a></b><br />\n			<tmpl_if user.isPoster>(<tmpl_var status>)</tmpl_if>\n			<tmpl_if thumbnail>\n				<div style=\"margin: 3px;\">\n					<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" alt=\"<tmpl_var thumbnail>\" border=\"0\" /></a>\n				</div>\n			</tmpl_if>\n		</div>\n		<tmpl_var synopsis>\n	</div>\n</tmpl_loop>\n\n<div style=\"clear: both;\"></div>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000128',1147642411,'WebGUI::Asset::Template::HTMLTemplate',1),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<span class=\"crumbTrail\">\n<tmpl_loop page_loop>\n<a class=\"crumbTrail\" \n    <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n   <tmpl_unless \"__last__\"> &gt; </tmpl_unless>\n</tmpl_loop>\n</span>','Navigation',1,1,'PBtmpl0000000000000093',1147642412,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<div class=\"acknowledgement\">\n	<tmpl_var acknowledgement>\n</div>\n\n<table border=\"0\" class=\"acknowledgement\">\n<tmpl_loop field_loop>\n<tmpl_unless field.isMailField><tmpl_unless field.isHidden>\n	<tr><td class=\"tableHeader\"><tmpl_var field.label></td>\n	<td class=\"tableData\"><tmpl_var field.value></td></tr>\n</tmpl_unless></tmpl_unless>\n</tmpl_loop>\n</table>\n<p />\n<a href=\"<tmpl_var back.url>\" class=\"backLabel\"><tmpl_var back.label></a>\n\n\n','DataForm',1,1,'PBtmpl0000000000000104',1147642412,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if><tmpl_var form.header>\n\n<h2><tmpl_var search.label></h2>\n<tmpl_var query.form><tmpl_var form.search>\n<tmpl_var form.footer>\n<tmpl_if doit>\n	<table width=\"100%\" cellspacing=\"0\" cellpadding=\"3\" border=\"0\" class=\"searchResults\">\n	<tr>\n		<td class=\"tableHeader\"><tmpl_var title.label></td>\n		<td class=\"tableHeader\"><tmpl_var user.label></td>\n		<td class=\"tableHeader\"><tmpl_var date.label></td>\n	</tr>\n	<tmpl_loop post_loop>\n		<tr>\n			<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><a href=\"<tmpl_var url>\"><tmpl_var title></a></td>\n			<tmpl_if user.isVisitor>\n				<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><tmpl_var username></td>\n			<tmpl_else>\n				<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n			</tmpl_if>\n			<td <tmpl_if __ODD__>class=\"odd\"</tmpl_if>><tmpl_var dateSubmitted.human> @ <tmpl_var timeSubmitted.human></td>\n		</tr>\n	</tmpl_loop>\n	</table>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n\n\n','Collaboration/Search',1,1,'PBtmpl0000000000000031',1147642413,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>\n   <tmpl_var title>\n</h2>\n<tmpl_if login.message>\n   <tmpl_var login.message>\n</tmpl_if>\n\n<tmpl_var login.form.header>\n<table >\n<tmpl_var login.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.username.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.username></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.password.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.password></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\"><tmpl_var login.form.submit></td>\n</tr>\n</table>\n<tmpl_var login.form.footer>\n\n<div class=\"accountOptions\">\n   <ul>\n             <tmpl_if anonymousRegistration.isAllowed>\n	     <li><a href=\"<tmpl_var createAccount.url>\"><tmpl_var createAccount.label></a></li>\n	  </tmpl_if>\n\n   </ul>\n</div>','Auth/LDAP/Login',1,1,'PBtmpl0000000000000006',1147642414,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<tmpl_if session.var.adminOn>\n	<a href=\"<tmpl_var forum.add.url>\"><tmpl_var forum.add.label></a>\n	<p />\n</tmpl_if>\n\n<tmpl_if areMultipleForums>\n	<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"defaultMessageBoard\">\n		<tr>\n			<tmpl_if session.var.adminOn>\n				<td></td>\n			</tmpl_if>\n			<td class=\"tableHeader\"><tmpl_var title.label></td>\n			<td class=\"tableHeader\"><tmpl_var views.label></td>\n			<td class=\"tableHeader\"><tmpl_var rating.label></td>\n			<td class=\"tableHeader\"><tmpl_var threads.label></td>\n			<td class=\"tableHeader\"><tmpl_var replies.label></td>\n			<td class=\"tableHeader\"><tmpl_var lastpost.label></td>\n		</tr>\n		<tmpl_loop forum_loop>			\n			<tr>\n				<tmpl_if session.var.adminOn>\n					<td><tmpl_var forum.controls></td>\n				</tmpl_if>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if>>\n					<a href=\"<tmpl_var forum.url>\"><tmpl_var forum.title></a><br />\n					<span style=\"font-size: 10px;\"><tmpl_var forum.description></span>\n				</td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.views></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.rating></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.threads></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if> align=\"center\"><tmpl_var forum.replies></td>\n				<td<tmpl_if __ODD__> class=\"even\"</tmpl_if>><span style=\"font-size: 10px;\">\n					<a href=\"<tmpl_var forum.lastpost.url>\"><tmpl_var forum.lastpost.subject></a>\n					by\n					<tmpl_if forum.lastpost.user.isVisitor>\n						<tmpl_var forum.lastpost.user.name>\n					<tmpl_else>\n						<a href=\"<tmpl_var forum.lastpost.user.profile>\"><tmpl_var forum.lastpost.user.name></a>\n					</tmpl_if>\n					on <tmpl_var forum.lastpost.date> @ <tmpl_var forum.lastpost.time>\n				</span></td>\n			</tr>\n		</tmpl_loop>\n	</table>\n<tmpl_else>\n	<h2><tmpl_var default.title></h2>\n	<tmpl_if session.var.adminOn>\n		<tmpl_var default.controls><br />\n	</tmpl_if>\n	<tmpl_var default.description>\n	<p />\n	<tmpl_var default.listing>\n</tmpl_if>\n\n\n','MessageBoard',1,1,'PBtmpl0000000000000047',1147642414,'WebGUI::Asset::Template::HTMLTemplate',1),('\nThis is the Manager\'s View\n\n','TimeTracking_manager',1,1,'TimeTrackingTMPL000002',1147642417,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.title.url>\"><tmpl_var title.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.username.url>\"><tmpl_var by.label></a></td>\n</tr>\n<tmpl_loop post_loop>\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n	</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a><tmpl_if user.isPoster> (<tmpl_var status>)</tmpl_if></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateUpdated.human></td>\n	<tmpl_if user.isVisitor>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n	<tmpl_else>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n	</tmpl_if>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000066',1147642417,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>\n   <tmpl_var title>\n</h2>\n\n<tmpl_if login.message>\n   <tmpl_var login.message>\n</tmpl_if>\n\n<tmpl_var login.form.header>\n<table >\n<tmpl_var login.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.username.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.username></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"><tmpl_var login.form.password.label></td>\n   <td class=\"tableData\"><tmpl_var login.form.password></td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\"><tmpl_var login.form.submit></td>\n</tr>\n</table>\n<tmpl_var login.form.footer>\n\n<div class=\"accountOptions\">\n   <ul>\n     <tmpl_if recoverPassword.isAllowed>\n	     <li><a href=\"<tmpl_var recoverPassword.url>\"><tmpl_var recoverPassword.label></a></li>\n	  </tmpl_if>\n           <tmpl_if anonymousRegistration.isAllowed>\n	     <li><a href=\"<tmpl_var createAccount.url>\"><tmpl_var createAccount.label></a></li>\n	  </tmpl_if>\n   </ul>\n</div>','Auth/WebGUI/Login',1,1,'PBtmpl0000000000000013',1147642418,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>\n   <tmpl_var title>\n</h2>\n\n<tmpl_if expired.message>\n   <tmpl_var expired.message>\n</tmpl_if>\n\n<tmpl_var expired.form.header>\n<table >\n<tmpl_var expired.form.hidden>\n<tr>\n   <td class=\"formDescription\" valign=\"top\">\n      <tmpl_var expired.form.oldPassword.label>\n   </td>\n   <td class=\"tableData\">\n      <tmpl_var expired.form.oldPassword>\n   </td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\">\n      <tmpl_var expired.form.password.label>\n   </td>\n   <td class=\"tableData\">\n      <tmpl_var expired.form.password>\n   </td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\">\n  <tmpl_var expired.form.passwordConfirm.label>\n   </td>\n   <td class=\"tableData\">\n   <tmpl_var expired.form.passwordConfirm>\n   </td>\n</tr>\n<tr>\n   <td class=\"formDescription\" valign=\"top\"></td>\n   <td class=\"tableData\">\n   <tmpl_var expired.form.submit>\n   </td>\n</tr>\n</table>\n<tmpl_var expired.form.footer>','Auth/WebGUI/Expired',1,1,'PBtmpl0000000000000012',1147642418,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2><tmpl_var title></h2>\n\n<p>\n<tmpl_var question>\n</p>\n\n<div style=\"text-align:center\">\n\n<a href=\"<tmpl_var yes.url>\"><tmpl_var yes.label></a>\n\n&nbsp;  &nbsp; &nbsp; &nbsp; &nbsp; \n\n<a href=\"<tmpl_var no.url>\"><tmpl_var no.label></a>\n\n</div>\n','prompt',1,1,'PBtmpl0000000000000057',1147642418,'WebGUI::Asset::Template::HTMLTemplate',1),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<title>^Page(\"title\"); - WebGUI</title>\n	<tmpl_var head.tags>\n</head>\n<body>\n	^AdminBar;\n	<div class=\"topwrapper\">\n\n	<div class=\"menu\">\n		^AssetProxy(flexmenu);\n	</div>\n\n	<div class=\"contentArea\">\n		<tmpl_var body.content>\n		<br />\n		<br />\n		<hr />\n		^LoginToggle; &nbsp; ^a(^@;); &nbsp; ^H; &nbsp; ^AdminToggle;\n	</div>\n\n	</div>\n\n</body>\n</html>\n','style',0,1,'PBtmpl0000000000000060',1147642419,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if><a href=\"<tmpl_var fileUrl>\"><img src=\"<tmpl_var fileIcon>\" alt=\"<tmpl_var title>\" style=\"border-style:none;\" /><tmpl_var filename></a>','FileAsset',1,1,'PBtmpl0000000000000024',1147642420,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn> <p><tmpl_var controls></p> </tmpl_if>\n	\n<tmpl_if displayTitle> <h2><tmpl_var title></h2> </tmpl_if>\n		\n<tmpl_if description> <tmpl_var description> </tmpl_if>\n			\n<tmpl_if session.var.adminOn> <p><a href=\"<tmpl_var addFile.url>\"><tmpl_var addFile.label></a></p> </tmpl_if>\n				\n<table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"content\"> \n<tmpl_loop subfolder_loop> \n\n <tr>\n <td class=\"tableData\" valign=\"top\">\n<tmpl_if canView>\n	<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /></a>\n	<a href=\"<tmpl_var url>\"><tmpl_var title></a>\n<tmpl_else>\n	<img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /><tmpl_var title>\n</tmpl_if>\n </td>\n <td class=\"tableData\" valign=\"top\" colspan=\"3\">\n <tmpl_var synopsis>\n </td>\n </tr>\n</tmpl_loop>\n				    								\n<tmpl_loop file_loop>\n <tr>\n <td valign=\"top\" class=\"tableData\">\n <tmpl_if session.var.adminOn>\n  <tmpl_if canEdit>\n   <tmpl_var controls>\n  </tmpl_if>\n </tmpl_if>\n<tmpl_if canView>\n <a href=\"<tmpl_if isFile><tmpl_var file.url><tmpl_else><tmpl_var url></tmpl_if>\"><img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /></a>\n <a href=\"<tmpl_if isFile><tmpl_var file.url><tmpl_else><tmpl_var url></tmpl_if>\"><tmpl_var title></a>\n<tmpl_else>\n <img src=\"<tmpl_var icon.small>\" border=\"0\" alt=\"<tmpl_var title>\" /><tmpl_var title>\n</tmpl_if>\n</td> <td class=\"tableData\" valign=\"top\">\n <tmpl_var synopsis></td><td class=\"tableData\" valign=\"top\">^D(\"%z %Z\",<tmpl_var date.epoch>);</td>\n <td class=\"tableData\" valign=\"top\"><tmpl_var size></td></tr>\n</tmpl_loop>\n</table>\n','Folder',1,1,'PBtmpl0000000000000078',1147642420,'WebGUI::Asset::Template::HTMLTemplate',1),('<a href=\"<tmpl_var file.url>\"><img src=\"<tmpl_var file.icon>\" alt=\"<tmpl_var file.icon>\" style=\"border-style:none;vertical-align:middle;\" /><tmpl_var file.name></a>(<tmpl_var file.size>)','Macro/File',1,1,'PBtmpl0000000000000107',1147642420,'WebGUI::Asset::Template::HTMLTemplate',1),('<p><tmpl_var message></p>\r\n<p><tmpl_var url></p>\n','Account/Inbox/InviteUserMessage',1,1,'XgcsoDrbC0duVla7N7JAdw',1227566394,'WebGUI::Asset::Template::HTMLTemplate',1),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<span class=\"horizontalMenu\">\n<tmpl_loop page_loop>\n<a class=\"horizontalMenu\" <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n   <tmpl_unless \"__last__\"> &middot; </tmpl_unless>\n</tmpl_loop>\n</span>','Navigation',1,1,'PBtmpl0000000000000108',1147642421,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if><img src=\"<tmpl_var fileUrl>\" <tmpl_var parameters> />','ImageAsset',1,1,'PBtmpl0000000000000088',1147642421,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displaytitle>\n	<tmpl_if linkurl><a href=\"<tmpl_var linkurl>\"></tmpl_if><span class=\"itemTitle\"><tmpl_var title></span><tmpl_if linkurl></a></tmpl_if>\n</tmpl_if>\n\n<tmpl_if attachment.name>\n	<tmpl_if displaytitle> - </tmpl_if>\n	<p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /></a></p>\n</tmpl_if>\n\n<tmpl_if description>\n  - <tmpl_var description>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000123',1147642421,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displaytitle>\n	<tmpl_if linkurl><a href=\"#\" onclick=\"window.open(\'<tmpl_var linkurl>\');\"></tmpl_if><span class=\"itemTitle\"><tmpl_var title></span><tmpl_if linkurl></a></tmpl_if>\n</tmpl_if>\n\n<tmpl_if attachment.name>\n	<tmpl_if displaytitle> - </tmpl_if>\n	<p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /></a></p>\n</tmpl_if>\n\n<tmpl_if description>\n  - <tmpl_var description>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000129',1147642422,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><tmpl_var job.title.label></td>\n	<td class=\"forumHead\"><tmpl_var location.label></td>\n	<td class=\"forumHead\"><tmpl_var compensation.label></td>\n	<td class=\"forumHead\"><tmpl_var date.label></td>\n</tr>\n\n<tmpl_loop post_loop>\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n	</tmpl_if>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a><tmpl_if user.isPoster> (<tmpl_var status>)</tmpl_if></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var userDefined2></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var userDefined1></td>\n	<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateSubmitted.human></td>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000077',1147642422,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>RandomThread macro debug output:</h2>\n<dl>\n<dt>approve.url:</dt> <dd><tmpl_var approve.url></dd>\n<dt>assetId:</dt> <dd><tmpl_var assetId></dd>\n<dt>assetSize:</dt> <dd><tmpl_var assetSize></dd>\n\n<dt>&lt;tmpl_loop attachment_loop&gt;:</dt>\n<dd><tmpl_loop attachment_loop>\n<dt>filename:</dt> <dd><tmpl_var filename></dd>\n<dt>icon:</dt> <dd><tmpl_var icon></dd>\n<dt>isImage:</dt> <dd><tmpl_var isImage></dd>\n<dt>thumbnail:</dt> <dd><tmpl_var thumbnail></dd>\n<dt>url:</dt> <dd><tmpl_var url></dd>\n</tmpl_loop>&lt;/tmpl_loop&gt;\n</dd>\n\n<dt>attachment.icon:</dt> <dd><tmpl_var attachment.icon></dd>\n<dt>attachment.thumbnail:</dt> <dd><tmpl_var attachment.thumbnail></dd>\n<dt>attachment.url:</dt> <dd><tmpl_var attachment.url></dd>\n<dt>className:</dt> <dd><tmpl_var className></dd>\n<dt>content:</dt> <dd><tmpl_var content></dd>\n<dt>contentType:</dt> <dd><tmpl_var contentType></dd>\n<dt>createdBy:</dt> <dd><tmpl_var createdBy></dd>\n<dt>creationDate:</dt> <dd><tmpl_var creationDate></dd>\n<dt>dateSubmitted:</dt> <dd><tmpl_var dateSubmitted></dd>\n<dt>dateSubmitted.human:</dt> <dd><tmpl_var dateSubmitted.human></dd>\n<dt>dateUpdated:</dt> <dd><tmpl_var dateUpdated></dd>\n<dt>dateUpdated.human:</dt> <dd><tmpl_var dateUpdated.human></dd>\n<dt>delete.url:</dt> <dd><tmpl_var delete.url></dd>\n<dt>deny.url:</dt> <dd><tmpl_var deny.url></dd>\n<dt>edit.url:</dt> <dd><tmpl_var edit.url></dd>\n<dt>encryptPage:</dt> <dd><tmpl_var encryptPage></dd>\n<dt>endDate:</dt> <dd><tmpl_var endDate></dd>\n<dt>extraHeadTags:</dt> <dd><tmpl_var extraHeadTags></dd>\n<dt>groupIdEdit:</dt> <dd><tmpl_var groupIdEdit></dd>\n<dt>groupIdView:</dt> <dd><tmpl_var groupIdView></dd>\n<dt>hasRated:</dt> <dd><tmpl_var hasRated></dd>\n<dt>image.url</dt> <dd><tmpl_var image.url></dd>\n<dt>image.thumbnail</dt> <dd><tmpl_var image.thumbnail></dd>\n<dt>isHidden:</dt> <dd><tmpl_var isHidden></dd>\n<dt>isLocked:</dt> <dd><tmpl_var isLocked></dd>\n<dt>isLockedBy:</dt> <dd><tmpl_var isLockedBy></dd>\n<dt>isMarkedRead:</dt> <dd><tmpl_var isMarkedRead></dd>\n<dt>isPackage:</dt> <dd><tmpl_var isPackage></dd>\n<dt>isPrototype:</dt> <dd><tmpl_var isPrototype></dd>\n<dt>isSticky:</dt> <dd><tmpl_var isSticky></dd>\n<dt>isSystem:</dt> <dd><tmpl_var isSystem></dd>\n<dt>lastPostDate:</dt> <dd><tmpl_var lastPostDate></dd>\n<dt>lastPostId:</dt> <dd><tmpl_var lastPostId></dd>\n<dt>lineage:</dt> <dd><tmpl_var lineage></dd>\n<dt>menuTitle:</dt> <dd><tmpl_var menuTitle></dd>\n<dt>newWindow:</dt> <dd><tmpl_var newWindow></dd>\n<dt>ownerUserId:</dt> <dd><tmpl_var ownerUserId></dd>\n<dt>parentId:</dt> <dd><tmpl_var parentId></dd>\n<dt>rate.url.1:</dt> <dd><tmpl_var rate.url.1></dd>\n<dt>rate.url.2:</dt> <dd><tmpl_var rate.url.2></dd>\n<dt>rate.url.3:</dt> <dd><tmpl_var rate.url.3></dd>\n<dt>rate.url.4:</dt> <dd><tmpl_var rate.url.4></dd>\n<dt>rate.url.5:</dt> <dd><tmpl_var rate.url.5></dd>\n<dt>rating:</dt> <dd><tmpl_var rating></dd>\n<dt>rating.value:</dt> <dd><tmpl_var rating.value></dd>\n<dt>replies:</dt> <dd><tmpl_var replies></dd>\n<dt>reply.url:</dt> <dd><tmpl_var reply.url></dd>\n<dt>reply.withquote.url:</dt> <dd><tmpl_var reply.withquote.url></dd>\n<dt>revisedBy:</dt> <dd><tmpl_var revisedBy></dd>\n<dt>revisionDate:</dt> <dd><tmpl_var revisionDate></dd>\n<dt>startDate:</dt> <dd><tmpl_var startDate></dd>\n<dt>state:</dt> <dd><tmpl_var state></dd>\n<dt>stateChanged:</dt> <dd><tmpl_var stateChanged></dd>\n<dt>stateChangedBy:</dt> <dd><tmpl_var stateChangedBy></dd>\n<dt>status:</dt> <dd><tmpl_var status></dd>\n<dt>storageId:</dt> <dd><tmpl_var storageId></dd>\n<dt>subscriptionGroupId:</dt> <dd><tmpl_var subscriptionGroupId></dd>\n<dt>synopsis:</dt> <dd><tmpl_var synopsis></dd>\n<dt>tagId:</dt> <dd><tmpl_var tagId></dd>\n<dt>threadId:</dt> <dd><tmpl_var threadId></dd>\n<dt>title:</dt> <dd><tmpl_var title></dd>\n<dt>title.short:</dt> <dd><tmpl_var title.short></dd>\n<dt>url:</dt> <dd><tmpl_var url></dd>\n<dt>user.canEdit:</dt> <dd><tmpl_var user.canEdit></dd>\n<dt>user.isPoster:</dt> <dd><tmpl_var user.isPoster></dd>\n<dt>userDefined1:</dt> <dd><tmpl_var userDefined1></dd>\n<dt>userDefined2:</dt> <dd><tmpl_var userDefined2></dd>\n<dt>userDefined3:</dt> <dd><tmpl_var userDefined3></dd>\n<dt>userDefined4:</dt> <dd><tmpl_var userDefined4></dd>\n<dt>userDefined5:</dt> <dd><tmpl_var userDefined5></dd>\n<dt>userId:</dt> <dd><tmpl_var userId></dd>\n<dt>userProfile.url:</dt> <dd><tmpl_var userProfile.url></dd>\n<dt>username:</dt> <dd><tmpl_var username></dd>\n<dt>views:</dt> <dd><tmpl_var views></dd>\n</dl>\n','Macro/RandomThread',1,1,'WVtmpl0000000000000001',1147642426,'WebGUI::Asset::Template::HTMLTemplate',1),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<div class=\"synopsis\">\n<tmpl_loop page_loop>\n   <div class=\"synopsis_title\">\n      <a href=\"<tmpl_var page.url>\"><tmpl_var page.menuTitle></a>\n   </div>\n   <tmpl_if page.indent>\n      <div class=\"synopsis_sub\">\n         <tmpl_var page.synopsis>\n      </div>\n   <tmpl_else>\n      <div class=\"synopsis_summary\">\n         <tmpl_var page.synopsis>\n      </div>\n   </tmpl_if>\n</tmpl_loop>\n</div>','Navigation',1,1,'PBtmpl0000000000000136',1147642428,'WebGUI::Asset::Template::HTMLTemplate',1),('		<tmpl_if displayTitle>\n		<h2><tmpl_var title></h2>\n		</tmpl_if>\n		<tmpl_if description>\n			<p><tmpl_var description></p>\n		</tmpl_if>\n		<tmpl_if session.var.adminOn>\n<tmpl_var controls>\n</tmpl_if>\n<tmpl_loop page_loop>\n   <tmpl_if page.isCurrent>\n      <span class=\"rootTabOn\">\n   <tmpl_else>\n      <span class=\"rootTabOff\">\n   </tmpl_if>\n   <a  <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n   </span>\n</tmpl_loop>','Navigation',1,1,'PBtmpl0000000000000124',1147642429,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n<tmpl_if session.var.adminOn>\n<tmpl_var controls><br />\n</tmpl_if>\n<span class=\"verticalMenu\">\n<tmpl_loop page_loop>\n<tmpl_var page.indent>\n	<a <tmpl_if page.isCurrent>class=\"selectedMenuItem\"</tmpl_if> <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n	<br />		\n</tmpl_loop>\n</span>\n','Navigation',1,1,'PBtmpl0000000000000048',1147642431,'WebGUI::Asset::Template::HTMLTemplate',1),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head>\n	<title>^Page(title); - <tmpl_var session.setting.companyName></title>\n	<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n	<link rel=\"shortcut icon\" href=\"^Extras(favicon.ico);\" />\n	<tmpl_var head.tags>\n<style type=\"text/css\">\nbody {\n	margin: 0;\n	padding: 0;\n}\n</style>\n</head>\n<body>\n^AdminBar(\"PBtmpl0000000000000090\");\n<tmpl_var body.content>\n\n<p>\n^AdminToggle();\n</p>\n</body>\n</html>\n','style',1,1,'PBtmplBlankStyle000001',1147642431,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>^International(error label,Account_Inbox);</h2>\r\n<p><strong><tmpl_var error_message></strong></p>\r\n<p><a href=\"<tmpl_var back_url>\">^International(back label,Account_Inbox);</a></p>\n','Account/Inbox/Error',1,1,'ErEzulFiEKDkaCDVmxUavw',1227566394,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>^International(invitation confirm label,Account_Inbox);</h2>\r\n<p>^International(invitation confirm message,Account_Inbox);</p>\r\n<table cellpadding=\"3\" cellspacing=\"0\" border=\"0\">\r\n    <tbody>\r\n        <tmpl_loop friends_loop>\r\n        <tr><td><tmpl_if is_denied>^International(\'you have not been added\',\'Friends\',<tmpl_var friend_name>);<tmpl_else>^International(\'you have been added\',\'Friends\',<tmpl_var friend_name>);</tmpl_if></td></tr>\r\n        </tmpl_loop>\r\n    </tbody>\r\n</table>\r\n<p><a href=\"<tmpl_var view_invitations_url>\">^International(invitations back label,Account_Inbox);</a></p>\n','Account/Inbox/Confirm',1,1,'5A8Hd9zXvByTDy4x-H28qw',1227566395,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<tmpl_if session.var.adminOn><tmpl_if controls><p><tmpl_var controls></p></tmpl_if></tmpl_if>\n<p><object classid=\"clsid:d27cdb6e-ae6d-11cf-96b8-444553540000\" codebase=\"http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0\" width=\"800\" height=\"600\" align=\"middle\">\n<param name=\"allowScriptAccess\" value=\"sameDomain\" />\n<param name=\"movie\" value=\"<tmpl_var fileUrl>\" /><param name=\"quality\" value=\"high\" /><embed src=\"<tmpl_var fileUrl>\" quality=\"high\" width=\"800\" height=\"600\" align=\"middle\" allowScriptAccess=\"sameDomain\" type=\"application/x-shockwave-flash\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" />\n</object></p>\n		','FileAsset',1,1,'pbtmpl0000000000000221',1147642465,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>			\n		\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n		\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>		\n		\n	<span style=\"float:left\">&#160;&#160;&#160;&#160;&#160;&#160;</span>\n	<tmpl_loop page_loop>	\n	<div<tmpl_if page.isCurrent> class=\"navOn\"</tmpl_if><tmpl_if page.isAncestor> class=\"navOn\"</tmpl_if>>\n		<span class=\"left\">&#160;</span>\n		<span class=\"center\">\n			<a <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n		</span>\n		<span class=\"right\">&#160;</span>\n	</div>	\n	</tmpl_loop>\n\n<div style=\"clear:both;\"></div>\n','Navigation',1,1,'stevenav00000000000001',1147642499,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>			\n		\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n		\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>		\n		\n	<span style=\"float:left\">&#160;&#160;&#160;&#160;&#160;&#160;</span>\n	<tmpl_loop page_loop>	\n		<tmpl_unless page.depthIs3>\n	<div<tmpl_if page.isCurrent> class=\"navOn\"</tmpl_if><tmpl_if page.isAncestor> class=\"navOn\"</tmpl_if>>\n		<span class=\"left\">&#160;</span>\n		<span class=\"center\">\n			<a <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n		</span>\n		<span class=\"right\">&#160;</span>\n	</div>	\n		</tmpl_unless>\n	</tmpl_loop>\n','Navigation',1,1,'PBnav000000style01lvl2',1147642499,'WebGUI::Asset::Template::HTMLTemplate',1),('<div class=\"loginBox\">\n<tmpl_if user.isVisitor>\n	<tmpl_var form.header>\n             <label for=\"username_formId\"><tmpl_var username.label></label><br />\n             <tmpl_var username.form><br />\n             <label for=\"identifier_formId\"><tmpl_var password.label></label><br />\n             <tmpl_var password.form><br />\n             <tmpl_var form.login>\n	<tmpl_var form.footer>\n	<tmpl_if session.setting.anonymousRegistration>\n                        <p><a href=\"<tmpl_var account.create.url>\"><tmpl_var account.create.label></a></p>\n	</tmpl_if>	\n<tmpl_else>\n	<tmpl_unless customText>\n		<tmpl_var hello.label> <a href=\"<tmpl_var account.display.url>\"><tmpl_var session.user.username></a>.\n                          <a href=\"<tmpl_var logout.url>\"><tmpl_var logout.label></a>\n	<tmpl_else>\n		<tmpl_var customText>\n	</tmpl_unless>\n</tmpl_if>\n</div>\n\n','Macro/L_loginBox',1,1,'PBtmpl0000000000000044',1148579524,'WebGUI::Asset::Template::HTMLTemplate',1),('<div class=\"loginBox\">\n<tmpl_if user.isVisitor>\n	<tmpl_var form.header>\n	<table border=\"0\" cellpadding=\"1\" cellspacing=\"0\">\n	<tr>\n		<td><tmpl_var username.form></td>\n		<td><tmpl_var password.form></td>\n		<td><tmpl_var form.login></td>\n	</tr>\n	<tr>\n		<td><label for=\"username_formId\"><tmpl_var username.label></label></td>\n		<td><label for=\"identifier_formId\"><tmpl_var password.label></label></td>\n		<td></td>\n	</tr>\n	</table>             	<tmpl_if session.setting.anonymousRegistration>\n                        <a href=\"<tmpl_var account.create.url>\"><tmpl_var account.create.label></a>\n	</tmpl_if>		<tmpl_var form.footer> \n<tmpl_else>\n	<tmpl_unless customText>\n		<tmpl_var hello.label> <a href=\"<tmpl_var account.display.url>\"><tmpl_var session.user.username></a>.\n                          <a href=\"<tmpl_var logout.url>\"><tmpl_var logout.label></a>\n	<tmpl_else>\n		<br /><tmpl_var customText>\n	</tmpl_unless>\n</tmpl_if>\n</div>\n\n','Macro/L_loginBox',1,1,'PBtmpl0000000000000092',1148579524,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if session.var.adminOn>\n<tmpl_var controls><br />\n</tmpl_if>\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n\n<tmpl_loop page_loop>\n<tmpl_if __FIRST__>\n	<ul class=\"bulletList\">\n</tmpl_if>\n\n\n<tmpl_loop page.depthDiff_loop>\n   </ul></li>\n</tmpl_loop>\n\n<li class=\"level<tmpl_var page.relDepth>\"><a <tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n<tmpl_if page.hasViewableChildren>\n	<ul>\n<tmpl_else>\n	</li>\n</tmpl_if>\n\n<tmpl_if __LAST__> \n	<tmpl_loop page.indent_loop>\n		<tmpl_unless __first__></li></tmpl_unless>\n       		</ul>\n 	</tmpl_loop>\n	</li></ul>\n</tmpl_if>\n</tmpl_loop>\n','Navigation',1,1,'PBnav00000000000bullet',1148579524,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if session.var.adminOn>\n	<tmpl_if controls>\n		<p><tmpl_var controls></p>\n	</tmpl_if>\n</tmpl_if>\n\n\n<div>\n	<object type=\"application/x-shockwave-flash\" data=\"<tmpl_var fileUrl>\" style=\"height:auto;min-height:100px;width:100%;display:block;\">\n		<param name=\"movie\" value=\"<tmpl_var fileUrl>\" />		\n	</object>\n</div>','FileAsset',1,1,'pbtmpl0000000000000220',1148579525,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a> &bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		<tmpl_if pagination.pageCount.isMultiple>\n			&bull;\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n\n<div><b>On <tmpl_var dateSubmitted.human> <a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a> from <a href=\"<tmpl_var url>\">the \'<tmpl_var title>\' department</a> wrote</b></div>\n<div><i><tmpl_var synopsis></i></div>\n<div><a href=\"<tmpl_var url>\"><tmpl_var readmore.label></a></div>\n<p />\n\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000133',1149286278,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a> &bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		<tmpl_if pagination.pageCount.isMultiple>\n			&bull;\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]&nbsp;\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n	</tmpl_if>\n	<p>\n		<tmpl_if userDefined1><a href=\"<tmpl_var userDefined1>\"	<tmpl_if userDefined2>target=\"_blank\"</tmpl_if>></tmpl_if><tmpl_var title><tmpl_if userDefined1></a></tmpl_if>\n		<tmpl_if content>\n				  - <tmpl_var content>\n		</tmpl_if>\n	</p>\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000083',1149286278,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a> &bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		<tmpl_if pagination.pageCount.isMultiple>\n			&bull;\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n	</tmpl_if>\n</p>\n\n<ol>\n	<tmpl_loop post_loop>\n		<li>\n			<tmpl_if user.isPoster>\n				<tmpl_unless session.var.adminOn>\n					[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n				</tmpl_unless>\n			</tmpl_if>\n			<tmpl_if user.isModerator>\n				<tmpl_if session.var.adminOn>\n					<tmpl_var controls>\n				<tmpl_else>\n					<tmpl_unless user.isPoster>\n						<tmpl_unless session.var.adminOn>\n							[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n						</tmpl_unless>\n					</tmpl_unless>\n				</tmpl_if>\n				(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n			</tmpl_if>\n			<tmpl_if userDefined1><a href=\"<tmpl_var userDefined1>\"	<tmpl_if userDefined2>target=\"_blank\"</tmpl_if>></tmpl_if><tmpl_var title><tmpl_if userDefined1></a></tmpl_if>\n			<tmpl_if content>\n					  - <tmpl_var content>\n			</tmpl_if>\n		</li>\n	</tmpl_loop>\n</ol>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000101',1149286278,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&#149;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&#149;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<br />\n\n<tmpl_loop post_loop>\n	<div class=\"picture\">\n		<div style=\"text-align: center;\">\n			<tmpl_if user.isPoster><div>(<tmpl_var status>)</div></tmpl_if>\n			<div><a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" alt=\"<tmpl_var title>\" /></a></div>\n			<div><a href=\"<tmpl_var url>\"><tmpl_var title></a></div>\n		</div>\n	</div>\n</tmpl_loop>\n\n<div style=\"clear: both;\"></div>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000121',1149286279,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"postControls\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a> &bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		&nbsp;[<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>]\n	</tmpl_if>\n</p>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a> &bull;\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n	</tmpl_if><br />\n	<h2 class=\"topicsTitle\"><tmpl_var title></h2>\n	<span class=\"topicContent\"><tmpl_var content></span>\n	<p />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000079',1149286279,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"pagination\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		\n		<tmpl_if pagination.pageCount.isMultiple>\n			&bull;\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n	</tmpl_if>\n</p>\n\n<ul class=\"unorderedList\">\n	<tmpl_loop post_loop>\n		<li>\n			<tmpl_if user.isPoster>\n				<tmpl_unless session.var.adminOn>\n					[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n				</tmpl_unless>\n			</tmpl_if>\n			<tmpl_if user.isModerator>\n				<tmpl_if session.var.adminOn>\n					<tmpl_var controls>\n				<tmpl_else>\n					<tmpl_unless user.isPoster>\n						<tmpl_unless session.var.adminOn>\n							[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n						</tmpl_unless>\n					</tmpl_unless>\n				</tmpl_if>\n				(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n			</tmpl_if>\n			<tmpl_if userDefined1><a href=\"<tmpl_var userDefined1>\"	<tmpl_if userDefined2>target=\"_blank\"</tmpl_if>></tmpl_if><tmpl_var title><tmpl_if userDefined1></a></tmpl_if>\n			<tmpl_if content>\n					  - <tmpl_var content>\n			</tmpl_if>\n		</li>\n	</tmpl_loop>\n</ul>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000082',1149286279,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"pagination\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<p />\n\n<tmpl_loop post_loop>\n	<div class=\"weblogTitleBar\">\n		<tmpl_var title>\n	</div>\n	<fieldset class=\"weblogSynopsis\">\n		<legend class=\"weblogLegend\" align=\"left\">\n			<tmpl_var by.label> <a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a>\n			-\n			<tmpl_var dateSubmitted.human>\n			<tmpl_if replies>\n				- <tmpl_var replies> <tmpl_var replies.label>\n			</tmpl_if>\n			<tmpl_if user.isPoster>\n				 - <tmpl_var status>\n			<tmpl_else>\n				<tmpl_if user.isModerator>\n					- <tmpl_var status>\n				</tmpl_if>\n			</tmpl_if>\n		</legend>\n		<tmpl_if thumbnail>\n			<a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var title>\" align=\"right\" /></a>\n		</tmpl_if>\n		<tmpl_var synopsis>\n		<div class=\"weblogReadMore\">\n			<a href=\"<tmpl_var url>\"><tmpl_var readmore.label></a>\n		</div>\n	</fieldset>\n	<p />\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &bull; <tmpl_var pagination.pageList.upTo10> &bull; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000112',1149286279,'WebGUI::Asset::Template::HTMLTemplate',1),('<a href=\"<tmpl_var file.url>\"><img src=\"<tmpl_var file.icon>\" style=\"border-style:none;vertical-align:middle;\" alt=\"<tmpl_var file.name>\" /><tmpl_var file.name></a>\n','Macro/File',1,1,'PBtmpl0000000000000039',1154535073,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<div class=\"fontSettings\">\n<tmpl_if description>\n	<tmpl_var description>\n	<p />\n</tmpl_if>\n\n<span class=\"pollQuestion\"><tmpl_var question></span><br />\n\n<tmpl_if canVote>\n	<tmpl_var form.start>\n	<tmpl_loop answer_loop>\n		<tmpl_var answer.form> <tmpl_var answer.text><br />\n	</tmpl_loop>\n	<p />\n	<tmpl_var form.submit>\n	<tmpl_var form.end>\n<tmpl_else>\n	<tmpl_if hasImageGraph>\n		<img src=\"<tmpl_var graphUrl>\" alt=\"graph\" />\n	<tmpl_else>\n		<tmpl_loop answer_loop>\n			<span class=\"pollAnswer\"><tmpl_var answer.text><br /></span>\n			<table cellpadding=0 cellspacing=0 border=0>\n			<tr>\n				<td width=\"<tmpl_var answer.graphWidth>\" class=\"pollColor\">^Spacer(1,1);</td>\n				<td class=\"pollAnswer\">&nbsp;&nbsp;<tmpl_var answer.percent>% (<tmpl_var answer.total>)</td>\n			</tr>\n			</table>\n		</tmpl_loop>\n		<span class=\"pollAnswer\"><hr size=\"1\"><b><tmpl_var responses.label>:</b> <tmpl_var responses.total></span>\n	</tmpl_if>\n</tmpl_if>\n</div>\n\n\n','Poll',1,1,'PBtmpl0000000000000055',1154535073,'WebGUI::Asset::Template::HTMLTemplate',1),('<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n<html>\n<head>\n<title>^Page(title); - <tmpl_var session.setting.companyName></title>\n<link rel=\"icon\" href=\"^Extras(favicon.png);\" type=\"image/png\" />\n<link rel=\"shortcut icon\" href=\"^Extras(favicon.ico);\" />\n<tmpl_var head.tags>\n<style type=\"text/css\">\n.content {\n	background-color: #ffffff;\n	color: #000000;\n	font-family: helvetica, arial;\n	font-size: 10pt;\n	padding: 10pt;\n}\nh1 {\n	font-family: helvetica, arial;\n	font-size: 16pt;\n}\na {\n	color: #EF4200;\n}\n.pagination {\n	font-family: helvetica, arial;\n	font-size: 8pt;\n	text-align: center;\n}\n.formDescription {\n	font-family: helvetica, arial;\n	font-size: 10pt;\n	font-weight: bold;\n}\n.formSubtext {\n	font-family: helvetica, arial;\n	font-size: 8pt;\n}\n.highlight {\n	background-color: #dddddd;\n}\n.tableMenu {\n	background-color: #cccccc;\n	font-size: 8pt;\n	font-family: Helvetica, Arial;\n}\n.tableMenu a {\n	text-decoration: none;\n}\n.tableHeader {\n	background-color: #cccccc;\n	font-size: 10pt;\n	font-family: Helvetica, Arial;\n}\n.tableData {\n	font-size: 10pt;\n	font-family: Helvetica, Arial;\n}\n\n.pollAnswer {\n	font-family: Helvetica, Arial;\n	font-size: 8pt;\n}\n\n.pollColor {\n	background-color: #444444;\n}\n\n.pollQuestion {\n	font-face: Helvetica, Arial;\n	font-weight: bold;\n}\n\n.faqQuestion {\n	font-size: 12pt;\n	font-weight: bold;\n	color: #000000;\n}\n</style>\n</head>\n<body onload=\"window.print()\">\n\n^AdminBar(\"\");\n\n<div style=\"text-align:center;\"><a href=\"^PageUrl;\"><img src=\"^Extras(plainblack.gif);\" style=\"border-style:none;\" alt=\"plainblack\" /></a></div>\n\n<div>\n	<tmpl_var body.content>\n</div>\n\n<div style=\"text-align:center;\">&copy; 2001-2004 Plain Black LLC</div>\n\n</body>\n</html>\n','style',1,1,'PBtmpl0000000000000111',1154535074,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if batchDescription>\nBatch: <tmpl_var batchDescription>\n</tmpl_if>\n\n<tmpl_var message><br />\n<tmpl_var codeForm>\n','Operation/RedeemSubscription',1,1,'PBtmpl0000000000000053',1154535074,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p class=\"pagination\">\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n		&bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		&bull;\n	</tmpl_unless>\n	<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n	<tmpl_if user.isModerator>\n		<td class=\"forumHead\"><tmpl_var status.label></td>\n	</tmpl_if>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.title.url>\"><tmpl_var title.label></a></td>\n	<td class=\"forumHead\"><tmpl_var thumbnail.label></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n	<td class=\"forumHead\"><a href=\"<tmpl_var sortby.username.url>\"><tmpl_var by.label></a></td>\n</tr>\n<tmpl_loop post_loop>\n	<tr>\n		<tmpl_if user.isModerator>\n			<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n		</tmpl_if>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a><tmpl_if user.isPoster> (<tmpl_var status>)</tmpl_if></td>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" style=\"text-align: center;\">\n			<tmpl_if thumbnail>\n				 <a href=\"<tmpl_var url>\"><img src=\"<tmpl_var thumbnail>\" border=\"0\" alt=\"<tmpl_var title>\" /></a>\n			<tmpl_else>\n				 &nbsp;\n			</tmpl_if>\n		</td>\n		<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateUpdated.human></td>\n		<tmpl_if user.isVisitor>\n			<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n		<tmpl_else>\n			<td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n		</tmpl_if>\n	</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<br />\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage> &middot; <tmpl_var pagination.pageList.upTo10> &middot; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000097',1154535074,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n		\n<tmpl_if description>\n	<p><tmpl_var description></p>\n</tmpl_if>\n		\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n		\n<div class=\"mainNav\">\n	<tmpl_loop page_loop>\n		<div class=\"level<tmpl_var page.relDepth>\">\n			<a <tmpl_if page.isCurrent> class=\"navOn\"</tmpl_if><tmpl_if page.isAncestor> class=\"anAncestor\" </tmpl_if><tmpl_if page.newWindow>onclick=\"window.open(\'<tmpl_var page.url>\')\" href=\"#\" <tmpl_else>href=\"<tmpl_var page.url>\"</tmpl_if>><tmpl_var page.menuTitle></a>\n		</div>\n	</tmpl_loop>\n</div>\n','Navigation',1,1,'PBnav00000000indentnav',1154535074,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">\n<tmpl_loop resourceLoop>\n  <tr <tmpl_if odd>class=\"odd\"</tmpl_if>>\n    <td><img src=\"<tmpl_var assetExtras>/<tmpl_var resourceIcon>\"></td>\n    <td><tmpl_if hiddenFields>\n          <input type=\"hidden\" class=\"taskEdit_resourceList_hidden\"\n                 name=\"resources\" value=\"<tmpl_var resourceKind> <tmpl_var resourceId>\" />\n        </tmpl_if><tmpl_var resourceName></td>\n    <td><tmpl_if opCallbackJs>\n          <a href=\"javascript:<tmpl_var opCallbackJs>(\'<tmpl_var resourceKind>\', \'<tmpl_var resourceId>\')\"><img src=\"<tmpl_var assetExtras>/<tmpl_var opIcon>\" style=\"border-style:none;\" alt=\"<tmpl_var opTitle>\" title=\"<tmpl_var opTitle>\" /></a>\n        </tmpl_if></td>\n  </tr>\n</tmpl_loop>\n</table>\n','ProjectManager_resourceList',1,1,'ProjectManagerTMPL0006',1157679165,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	<table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td class=\"content\">\n	<img src=\"<tmpl_var image.url>\" align=\"right\" border=\"0\" alt=\"<tmpl_var image.url>\" />\n</tmpl_if>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<tmpl_if pagination.isLastPage>\n	<tmpl_if linkUrl>\n	<tmpl_if linkTitle>\n		<p />\n		<a href=\"<tmpl_var linkUrl>\"><tmpl_var linkTitle></a>\n	</tmpl_if>\n	</tmpl_if>\n	<tmpl_if attachment.name><p><p style=\"display:inline;vertical-align:middle;\"><a href=\"<tmpl_var attachment.url>\"><img src=\"<tmpl_var attachment.icon>\" style=\"vertical-align:middle;border: 0px;\" alt=\"<tmpl_var attachment.name>\" /> <tmpl_var attachment.name></a></p></p></tmpl_if>\n</tmpl_if>\n\n<tmpl_if pagination.pageCount.isMultiple>\n<tmpl_var pagination.previousPage>\n&#183;\n<tmpl_var pagination.pageList.upTo20>\n&#183;\n<tmpl_var pagination.nextPage>\n</tmpl_if>\n\n<tmpl_if pagination.isFirstPage>\n<tmpl_if image.url>\n	</td></tr></table>\n</tmpl_if>\n</tmpl_if>\n','Article',1,1,'PBtmpl0000000000000002',1159989349,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<script type=\"text/javascript\">\n	taskArray=<tmpl_var project.task.array>;\n</script>\n<div class=\"barPositions\">\n	<tmpl_loop task.div.loop>\n	<tmpl_if task.isUntimed>      \n		<div class=\"milestone\" style=\"left:<tmpl_var task.div.left>px;top:<tmpl_var task.div.top>px;\">&diams;</div>\n	</tmpl_if><tmpl_if task.hasDuration>\n		<div class=\"projectBar\" style=\"left:<tmpl_var task.div.left>px;top:<tmpl_var task.div.top>px;width:<tmpl_var task.div.width>px;background-color:<tmpl_var task.div.color>\">\n		<div class=\"statusBar\" style=\"width:<tmpl_var task.div.percentComplete>%;\"></div>\n		<tmpl_if task.hasPredecessor>   \n			<div class=\"projectLineH\" style=\"top:4px;left:50px;width:75px;height:28px;\"><div class=\"projectLineV\"></div></div>\n	        </tmpl_if>\n	        <tmpl_if task.hasResource>\n			<div class=\"projectLabel\" style=\"left:<tmpl_var task.div.label.left>px;top:3px;margin-top:-3px;\"><tmpl_var task.resource.name></div>\n	        </tmpl_if> \n		</div>\n	</tmpl_if>\n   </tmpl_loop>\n   <a name=\"<tmpl_var project.table.width>\" id=\"projectTableWidth\"></a>\n   <a name=\"<tmpl_var project.scroll.percentWidth>\" id=\"projectScrollPercentWidth\"></a>\n   <table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:<tmpl_var scrollWidth>px;z-index:1;\">\n      <tr class=\"monthNames\">\n	     <tmpl_loop months.loop>\n		    <td colspan=\"<tmpl_var month.colspan>\" class=\"monthName\" style=\"height:20px;\"><tmpl_var month.name></td>\n		 </tmpl_loop>\n	  </tr>	\n	  <tr class=\"dates\">\n	     <tmpl_loop days.loop>\n		    <td  align=\"center\" style=\"width:23px\"><tmpl_var day.number></td>\n		 </tmpl_loop>\n	  </tr>\n	  <tmpl_loop task.count.loop>\n	     <tr>\n		    <td colspan=\"<tmpl_var total.colspan>\" class=\"empty\" style=\"height:21px;\">&nbsp;</td>\n	     </tr>\n	  </tmpl_loop>\n   </table>\n   <br />\n</div>\n\n','ProjectManager_gantt',1,1,'ProjectManagerTMPL0003',1159989349,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<ul>\n<tmpl_loop pageHistoryEntries>\n	<li><tmpl_var toolbar> <tmpl_var actionTaken> at <tmpl_var date> (<tmpl_var interval>) by <tmpl_var username></li>\n</tmpl_loop>\n</ul>\n','WikiPage_pageHistory',1,1,'WikiPHTmpl000000000001',1165460175,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2><tmpl_var title></h2>\n\n<ol><tmpl_loop mostPopular>\n<li><a href=\"<tmpl_var url>\"><tmpl_var title></a></li>\n</tmpl_loop></ol>\n\n<div style=\"padding: 8px;\"><a href=\"<tmpl_var searchUrl>\"><tmpl_var searchLabel></a> | <a href=\"<tmpl_var recentChangesUrl>\"><tmpl_var recentChangesLabel></a> | <a href=\"<tmpl_var wikiHomeUrl>\"><tmpl_var wikiHomeLabel></a></div>\n\n','WikiMaster_mostPopular',1,1,'WikiMPTmpl000000000001',1165460175,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2><tmpl_var reportTitle></h2>\n<div class=\"iob\">\n   <tmpl_var form><br />\n   <tmpl_if showReport>\n   <table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\">\n   <tr>\n   <th><tmpl_var username.label></th>\n   <th><tmpl_var status.label></th>\n   <th><tmpl_var date.label></th>\n   <th><tmpl_var message.label></th>\n   <th><tmpl_var updatedBy.label></th>\n   </tr>\n   <tmpl_loop rows_loop>\n   <tmpl_if deptHasChanged>\n   <tr><td colspan=\"5\"><b><tmpl_var department></b></td></tr>\n   </tmpl_if>\n   <tr>\n   <td><tmpl_var username></td>\n   <td><tmpl_var status></td>\n   <td><tmpl_var dateStamp></td>\n   <td><tmpl_var message></td>\n   <td><tmpl_var createdBy></td>\n   </tr>\n   </tmpl_loop>\n   <tr><td colspan=\"5\"><tmpl_var paginateBar></td></tr>\n   </table>\n   </tmpl_if>\n</div>\n\n\n\n','InOutBoard/Report',1,1,'IOB0000000000000000002',1166019641,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<tmpl_if displayTitle><h2><tmpl_var searchLabel></h2></tmpl_if>\n\n\n<tmpl_var searchFormHeader><tmpl_var searchQuery><tmpl_var searchSubmit><tmpl_var searchFormFooter>\n<tmpl_if performSearch>\n	<h3><tmpl_var resultsLabel></h3>\n	<tmpl_if searchResults>\n		<ul><tmpl_loop searchResults><li><a href=\"<tmpl_var url>\"><tmpl_var title></a></li></tmpl_loop></ul>\n		<tmpl_if pagination.pageCount.isMultiple>\n		<div class=\"pagination\">\n			<tmpl_var pagination.previousPage> &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n		</div>\n		</tmpl_if>\n	<p><tmpl_var notWhatYouWanted></p>\n		<p><a href=\"<tmpl_var addPageUrl>\"><tmpl_var addPageLabel></a></p>\n	<tmpl_else>\n		<p><tmpl_var nothingFoundLabel></p>\n		<tmpl_if canAddPages><p><a href=\"<tmpl_var addPageUrl>\"><tmpl_var addPageLabel></a></p></tmpl_if>\n	</tmpl_if>\n</tmpl_if>\n<div style=\"padding: 8px;\"><a href=\"<tmpl_var mostPopularUrl>\"><tmpl_var mostPopularLabel></a> | <a href=\"<tmpl_var recentChangesUrl>\"><tmpl_var recentChangesLabel></a> | <a href=\"<tmpl_var wikiHomeUrl>\"><tmpl_var wikiHomeLabel></a></div>\n','WikiMaster_search',1,1,'WikiSearchTmpl00000001',1168480840,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2><tmpl_var title></h2>\n\n<ul><tmpl_loop recentChanges>\n	<li>\n		<tmpl_if isAvailable>\n			<a href=\"<tmpl_var url>\"><tmpl_var title></a> - <tmpl_var actionTaken> on <tmpl_var date> by <tmpl_var username>\n		<tmpl_else>\n			<tmpl_var title> - <tmpl_var actionTaken> on <tmpl_var date> by <tmpl_var username> \n			<tmpl_if canAdminister>\n				( <a href=\"<tmpl_var restoreUrl>\"><tmpl_var restoreLabel></a> )\n			</tmpl_if>\n		</tmpl_if>\n	</li>\n</tmpl_loop></ul>\n\n<div style=\"padding: 8px;\"><a href=\"<tmpl_var searchUrl>\"><tmpl_var searchLabel></a> | <a href=\"<tmpl_var mostPopularUrl>\"><tmpl_var mostPopularLabel></a> | <a href=\"<tmpl_var wikiHomeUrl>\"><tmpl_var wikiHomeLabel></a></div>\n\n\n','WikiMaster_recentChanges',1,1,'WikiRCTmpl000000000001',1169092823,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<tmpl_if session.var.adminOn>\n   <tmpl_if controls>\n      <p><tmpl_var controls></p>\n   </tmpl_if>\n</tmpl_if>\n\n<tmpl_if error>\n<ul>\n  <li><tmpl_var error></li>\n</ul>\n</tmpl_if>\n\n<tmpl_if fileUrl>\n   <a href=\"<tmpl_var fileUrl>\"><tmpl_var title></a>\n<tmpl_else>\n  <tmpl_if pageError>\n      <tmpl_var noInitialPage>\n  <tmpl_else>\n      <tmpl_var noFileSpecified>\n  </tmpl_if>\n</tmpl_if>	\n','ZipArchiveAsset',1,1,'ZipArchiveTMPL00000001',1169738426,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n<tmpl_if session.var.adminOn>\n   <p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle> \n   <h2><tmpl_var title></h2> \n</tmpl_if> \n\n<div class=\"fontSettings\">\n	<tmpl_var description>\n	<br /><br />\n</div>\n\n<div class=\"pagination\">\n<tmpl_if selectDelegatesURL>\n   <a href=\"<tmpl_var selectDelegatesURL>\"><tmpl_var selectDelegatesLabel></a>\n</tmpl_if>\n<tmpl_if canViewReport>\n   <tmpl_if selectDelegatesURL>\n      &nbsp;&middot;&nbsp;\n   </tmpl_if>\n   <a href=\"<tmpl_var viewReportURL>\"><tmpl_var viewReportLabel></a>\n</tmpl_if>\n</div>\n\n<tmpl_if displayForm>	\n	<div class=\"fontSettings\">\n		<tmpl_var form>\n	</div>	\n</tmpl_if>\n   \n   <table width=\"100%\" cellpadding=\"3\" cellspacing=\"0\" class=\"iob\">\n   <tmpl_loop rows_loop>\n   <tmpl_if deptHasChanged>\n   <tr><td colspan=\"4\" class=\"noBorder\"><br /><b><tmpl_var department></b></td></tr>\n   </tmpl_if>\n   <tr>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var username></td>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var status></td>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var dateStamp></td>\n   <td<tmpl_if __ODD__> class=\"odd\"</tmpl_if>><tmpl_var message></td>\n   </tr>\n   </tmpl_loop>\n   <tr><td colspan=\"4\"><tmpl_var paginateBar></td></tr>\n   </table>\n   \n   \n\n','InOutBoard',1,1,'IOB0000000000000000001',1169795123,'WebGUI::Asset::Template::HTMLTemplate',1),('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rss version=\"2.0\">\n<channel>\n<title><tmpl_var title></title>\n<link><tmpl_var link></link>\n<description><tmpl_var description></description>\n<tmpl_loop item_loop>\n<item>\n<title><tmpl_var title></title>\n<link><tmpl_var link></link>\n<description><tmpl_var description></description>\n<guid isPermaLink=\"true\"><tmpl_var guid></guid>\n<pubDate><tmpl_var pubDate></pubDate>\n</item>\n</tmpl_loop>\n</channel>\n</rss>\n','RSSCapable/RSS',1,1,'PBtmpl0000000000000142',1171466654,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n	<tmpl_var controls>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<tmpl_var description>\n</tmpl_if>\n\n<p>\n	<tmpl_if user.canPost>\n		<a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a> &bull;\n	</tmpl_if>\n	<tmpl_unless user.isVisitor>\n		<tmpl_if user.isSubscribed>\n			<a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n		<tmpl_else>\n			<a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n		</tmpl_if>\n		<tmpl_if pagination.pageCount.isMultiple>\n			&bull;\n		</tmpl_if>\n	</tmpl_unless>\n	<tmpl_if pagination.pageCount.isMultiple>\n		<a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n	</tmpl_if>\n</p>\n\n<ul>\n	<tmpl_loop post_loop>\n	   <li><a href=\"#id<tmpl_var assetId>\"><span class=\"faqQuestion\"><tmpl_var title></span></a></li>\n	</tmpl_loop>\n</ul>\n\n<tmpl_loop post_loop>\n	<tmpl_if user.isPoster>\n		<tmpl_unless session.var.adminOn>\n			<div>[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]</div>\n		</tmpl_unless>\n	</tmpl_if>\n	<tmpl_if user.isModerator>\n		<div>\n			<tmpl_if session.var.adminOn>\n				<tmpl_var controls>\n			<tmpl_else>\n				<tmpl_unless user.isPoster>\n					<tmpl_unless session.var.adminOn>\n						[<a href=\"<tmpl_var edit.url>\"><tmpl_var edit.label></a>]\n					</tmpl_unless>\n				</tmpl_unless>\n			</tmpl_if>\n			(<a href=\"<tmpl_var url>\"><tmpl_var status></a>)\n		</div>\n	</tmpl_if>\n	<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a><span class=\"faqQuestion\"><tmpl_var title></span><br />\n	<tmpl_var content>\n	<p><a href=\"#id<tmpl_var collaborationAssetId>\">[top]</a></p>\n</tmpl_loop>\n\n<tmpl_if pagination.pageCount.isMultiple>\n	<div class=\"pagination\">\n		<tmpl_var pagination.previousPage>  &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n	</div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000080',1171466654,'WebGUI::Asset::Template::HTMLTemplate',1),('<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n<tr>\n<tmpl_loop columns_loop>\n	<td class=\"tableHeader\"><tmpl_var column.name></td>\n</tmpl_loop>\n</tr>\n<tmpl_loop rows_loop>\n	<tr>\n	<tmpl_loop row.field_loop>\n		<td class=\"tableData\"><tmpl_var field.value></td>\n	</tmpl_loop>\n	</tr>\n	<!-- Handle nested query2 -->\n	<tmpl_if hasNest>\n		<tr>\n		<td colspan=\"<tmpl_var columns.count>\">\n		<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n		<tr>\n		<td width=\"20\">&nbsp;</td>\n		<td>\n		<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n		<tr>\n		<tmpl_loop query2.columns_loop>\n			<td class=\"tableHeader\"><tmpl_var column.name></td>\n		</tmpl_loop>\n		</tr>\n		<tmpl_loop query2.rows_loop>\n			<tr>\n			<tmpl_loop query2.row.field_loop>\n				<td class=\"tableData\"><tmpl_var field.value></td>\n			</tmpl_loop>\n			</tr>\n			<!-- Handle nested query3 -->\n			<tmpl_if query2.hasNest>\n				<tr>\n				<td colspan=\"<tmpl_var query2.columns.count>\">\n				<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n				<tr>\n				<td style=\"width:20px;\">&nbsp;</td>\n				<td>\n				<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n				<tr>\n				<tmpl_loop query3.columns_loop>\n					<td class=\"tableHeader\"><tmpl_var column.name></td>\n				</tmpl_loop>\n				</tr>\n				<tmpl_loop query3.rows_loop>\n					<tr>\n					<tmpl_loop query3.row.field_loop>\n						<td class=\"tableData\"><tmpl_var field.value></td>\n					</tmpl_loop>\n					</tr>\n		   			<!-- Handle nested query4 -->\n					<tmpl_if query3.hasNest>\n						<tr>\n						<td colspan=\"<tmpl_var query3.columns.count>\">\n						<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n						<tr>\n						<td style=\"width:20px;\">&nbsp;</td>\n						<td>\n						<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n						<tr>\n						<tmpl_loop query4.columns_loop>\n							<td class=\"tableHeader\"><tmpl_var column.name></td>\n						</tmpl_loop>\n						</tr>\n						<tmpl_loop query4.rows_loop>\n							<tr>\n							<tmpl_loop query4.row.field_loop>\n								<td class=\"tableData\"><tmpl_var field.value></td>\n							</tmpl_loop>\n				   			<!-- Handle nested query5 -->\n							<tmpl_if query4.hasNest>\n								<tr>\n								<td colspan=\"<tmpl_var query4.columns.count>\">\n								<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\">\n								<tr>\n								<td style=\"width:20px;\">&nbsp;</td>\n								<td>\n								<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border: 1px solid black;\">\n								<tr>\n								<tmpl_loop query5.columns_loop>\n									<td class=\"tableHeader\"><tmpl_var column.name></td>\n								</tmpl_loop>\n								</tr>\n								<tmpl_loop query5.rows_loop>\n									<tr>\n									<tmpl_loop query5.row.field_loop>\n										<td class=\"tableData\"><tmpl_var field.value></td>\n									</tmpl_loop>\n									</tr>\n								</tmpl_loop>\n								</table>\n								</td>\n								</tr>\n								</table>\n						        	</td>\n				        			</tr>\n							</tmpl_if>\n							</tr>\n						</tmpl_loop>\n						</table>\n						</td>\n						</tr>\n						</table>\n				        	</td>\n				        	</tr>\n					</tmpl_if>\n				</tmpl_loop>\n				</table>\n				</td>\n				</tr>\n				</table>\n			        </td>\n			        </tr>\n			</tmpl_if>\n		</tmpl_loop>\n		</table>\n		</td>\n		</tr>\n		</table>\n		</td>\n		</tr>\n	</tmpl_if>\n</tmpl_loop>\n</table>\n','SQLReport/Download',1,1,'SQLReportDownload00001',1171466654,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<p><tmpl_var header></p>\n\n<tmpl_loop thread_loop>\n<p>\n    <a href=\"<tmpl_var url>\"><tmpl_var title></a><br />\n    <p><tmpl_var synopsis></p>\n</p>\n</tmpl_loop>\n\n<p><tmpl_var footer></p>\n\n','newsletter',1,1,'newsletter000000000001',1185754569,'WebGUI::Asset::Template::HTMLTemplate',1),('<a name=\"id<tmpl_var assetId>\" id=\"id<tmpl_var assetId>\"></a>\n\n<tmpl_if session.var.adminOn>\n        <p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n        <h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n        <tmpl_var description>\n</tmpl_if>\n\n<p>\n        <tmpl_if user.canStartThread>\n                <a href=\"<tmpl_var add.url>\"><tmpl_var add.label></a>\n                &#149;\n        </tmpl_if>\n        <tmpl_unless user.isVisitor>\n                <tmpl_if user.isSubscribed>\n                        <a href=\"<tmpl_var unsubscribe.url>\"><tmpl_var unsubscribe.label></a>\n                <tmpl_else>\n                        <a href=\"<tmpl_var subscribe.url>\"><tmpl_var subscribe.label></a>\n                </tmpl_if>\n                &#149;\n        </tmpl_unless>\n        <a href=\"<tmpl_var search.url>\"><tmpl_var search.label></a>\n</p>\n\n<table width=\"100%\">\n<tr>\n        <tmpl_if user.isModerator>\n                <td class=\"forumHead\"><tmpl_var status.label></td>\n        </tmpl_if>\n        <td class=\"forumHead\"><tmpl_var subject.label></td>\n        <td class=\"forumHead\"><tmpl_var user.label></td>\n        <td class=\"forumHead\"><a href=\"<tmpl_var sortby.views.url>\"><tmpl_var views.label></a></td>\n        <td class=\"forumHead\"><a href=\"<tmpl_var sortby.replies.url>\"><tmpl_var replies.label></a></td>\n        <td class=\"forumHead\"><a href=\"<tmpl_var sortby.rating.url>\"><tmpl_var rating.label></a></td>\n        <td class=\"forumHead\"><a href=\"<tmpl_var sortby.date.url>\"><tmpl_var date.label></a></td>\n        <tmpl_if displayLastReply>\n                <td class=\"forumHead\"><a href=\"<tmpl_var sortby.lastreply.url>\"><tmpl_var lastReply.label></a></td>\n        </tmpl_if>\n</tr>\n<tmpl_loop post_loop>\n<tr>\n        <tmpl_if user.isModerator>\n                <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var status></td>\n        </tmpl_if>\n        <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var url>\"><tmpl_var title></a></td>\n        <tmpl_if user.isVisitor>\n                <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var username></td>\n        <tmpl_else>\n                <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><a href=\"<tmpl_var userProfile.url>\"><tmpl_var username></a></td>\n        </tmpl_if>\n        <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var views></td>\n        <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var replies></td>\n        <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" align=\"center\"><tmpl_var rating></td>\n        <td class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\"><tmpl_var dateSubmitted.human> @ <tmpl_var timeSubmitted.human></td>\n        <tmpl_if displayLastReply>\n                <td  class=\"<tmpl_if __ODD__>oddThread<tmpl_else>evenThread</tmpl_if>\" style=\"font-size: 11px;\">\n                        <a href=\"<tmpl_var lastReply.url>\"><tmpl_var lastReply.title></a>\n                        by\n                        <tmpl_if lastReply.user.isVisitor>\n                                <tmpl_var lastReply.username>\n                        <tmpl_else>\n                                <a href=\"<tmpl_var lastReply.userProfile.url>\"><tmpl_var lastReply.username></a>\n                        </tmpl_if>\n                        on <tmpl_var lastReply.dateSubmitted.human> @ <tmpl_var lastReply.timeSubmitted.human>\n                </td>\n        </tmpl_if>\n</tr>\n</tmpl_loop>\n</table>\n\n<tmpl_if pagination.pageCount.isMultiple>\n        <div class=\"pagination\">\n                <tmpl_var pagination.previousPage>  &#183; <tmpl_var pagination.pageList.upTo10> &#183; <tmpl_var pagination.nextPage>\n        </div>\n</tmpl_if>\n','Collaboration',1,1,'PBtmpl0000000000000026',1185754569,'WebGUI::Asset::Template::HTMLTemplate',1),('<h2>\r\n	<tmpl_var title>\r\n</h2>\r\n\r\n<tmpl_var account.message>\r\n<tmpl_if account.form.karma>\r\n<br /><br />\r\n<table>\r\n<tr>\r\n	<td class=\"formDescription\">\r\n		<tmpl_var account.form.karma.label>\r\n	</td>\r\n	<td class=\"tableData\">\r\n	 	<tmpl_var account.form.karma>\r\n	</td>\r\n</tr>\r\n</table>\r\n</tmpl_if>\r\n\r\n<div class=\"accountOptions\">\r\n    <ul>\r\n        ^If(^AdminToggle;,<li>%s</li>,);\r\n        <li>^LoginToggle;</li>\r\n	^If(^DeactivateAccount;,<li>%s</li>,);\r\n	<li><a href=\"^BackToSite;\">^International(493,WebGUI);</a></li>\r\n    </ul>\r\n</div>','Auth/LDAP/Account',1,1,'PBtmpl0000000000000004',1227026214,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<h1><tmpl_var keyword></h1>\n\n<ul>\n<tmpl_loop pagesLoop>\n    <li><a href=\"<tmpl_var url>\"><tmpl_var title></a></li>\n</tmpl_loop>\n</ul>\n\n','WikiMaster_byKeyword',1,1,'WikiKeyword00000000001',1185754571,'WebGUI::Asset::Template::HTMLTemplate',1),('<tmpl_if session.var.adminOn><p><tmpl_var controls></p></tmpl_if>\n<tmpl_if displayTitle><h2><tmpl_var title></h2></tmpl_if>\n\n<tmpl_var description>\n<h3><tmpl_var searchLabel></h3>\n<tmpl_var searchFormHeader><tmpl_var searchQuery><tmpl_var searchSubmit><tmpl_var searchFormFooter>\n<br />\n\n<div style=\"float: left; width: 50%;\">\n    <h3><a href=\"<tmpl_var recentChangesUrl>\"><tmpl_var recentChangesLabel></a></h3>\n    <ul><tmpl_loop recentChanges>\n        <li>\n            <tmpl_if isAvailable>\n                <a href=\"<tmpl_var url>\"><tmpl_var title></a>\n            <tmpl_else>\n                <tmpl_var title> (<tmpl_var actionTaken>)\n            </tmpl_if>\n        </li>\n    </tmpl_loop></ul>\n</div>\n<div style=\"float: left;\">\n    <h3><a href=\"<tmpl_var mostPopularUrl>\"><tmpl_var mostPopularLabel></a></h3>\n    <ol><tmpl_loop mostPopular>\n        <li><a href=\"<tmpl_var url>\"><tmpl_var title></a></li>\n    </tmpl_loop></ol>\n\n</div>\n<div style=\"clear: both;\"></div>\n\n<div><tmpl_var keywordCloud></div>\n\n\n','WikiMaster_front',1,1,'WikiFrontTmpl000000001',1185754572,'WebGUI::Asset::Template::HTMLTemplate',1),('\n<tmpl_if session.var.adminOn>\n	<p><tmpl_var controls></p>\n</tmpl_if>\n\n<tmpl_if displayTitle>\n	<h2><tmpl_var title></h2>\n</tmpl_if>\n\n<tmpl_if description>\n	<div class=\"fontSettings\">\n		<tmpl_var description>\n	</div>\n</tmpl_if>\n\n<script language=\"JavaScript\">\n   var nextRowNum   = <tmpl_var time.report.rows.total>;\n   var projectTasks = <tmpl_var project.task.array>  //Do not put a semi colon at the end of this.  The app does it\n   \n   //-----------------------------------------------------------------------------------\n   function changeOptions(proj,task) {\n      var projId = proj.value;\n	  //Remove all options from task list except first one\n	  var optLen = task.options.length;\n	  while (task.options.length > 1) {\n		 var elem = task.options[1];\n		 task.removeChild(elem);\n	  }\n	  \n	  if(projId != \"\") {\n	     //Add new options\n	     var array = projectTasks[projId];\n         for (var word in array) {\n            var opt = document.createElement(\"option\");\n	        opt.setAttribute(\"value\",word);\n	        opt.appendChild(document.createTextNode(array[word]));\n            task.appendChild(opt);\n         }\n      }\n	  \n	  //Fix IE Bug which causes dymamic repopulation to fail\n	  var newtask = task;\n	  var col = task.parentNode;\n	  col.removeChild(task);\n	  col.appendChild(newtask);\n	  \n   }\n   \n   //-----------------------------------------------------------------------------------\n   function recalcHours() {\n	   var newHours = 0;\n	   var rows = document.getElementById(\"ttbody\");\n	   var rowLen = rows.childNodes.length;\n	   \n	   for(var i = 0; i <= rowLen; i++) {\n	      var row = rows.childNodes[i];\n		  if(row && row.id && row.id.indexOf(\"row\") > -1) {\n		     var rowId = row.id;\n		     var idPart = rowId.split(\"_\");\n		     var rowNum = idPart[1];\n		     var hourElem = document.getElementById(\"hours_\"+rowNum+\"_formId\");\n		     if (hourElem) {\n		        newHours += parseFloat(hourElem.value);\n	         }\n	      }\n	   }\n	   document.getElementById(\'totalHours\').innerHTML = newHours;\n   }\n\n   //-----------------------------------------------------------------------------------   \n   function getTarget(e) {\n      var targ;\n      if (!e) e = window.event || window.Event;\n      if (e.target) targ = e.target;\n      else if (e.srcElement) targ = e.srcElement;\n      if (targ.nodeType == 3) // defeat Safari bug\n         targ = targ.parentNode;\n      return targ\n   }  \n\n   //-----------------------------------------------------------------------------------    \n   function removeRow(e) {\n      if(!e) e = window.event || window.Event;\n	  var eleId = e;\n      if(typeof(e) == \"object\") {\n	    var targ = getTarget(e);\n		eleId = targ.parentNode.parentNode.id;\n	  } \n	  var row = document.getElementById(eleId);\n	  var ttbody = document.getElementById(\"ttbody\");\n      var timeRowCount = getTimeRowCount();\n	  if(timeRowCount > 1) {\n	     ttbody.removeChild(row);\n	     recalcHours();\n		 return;\n	  }\n	  alert(\"<tmpl_var js.alert.removeRow.error>\");\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function getTimeRowCount() {\n      var rows = document.getElementById(\"ttbody\");\n      var rowLen = rows.childNodes.length;\n	  var count = 0;\n	  \n	  for(var i = 0; i <= rowLen; i++) {\n	     var row = rows.childNodes[i];\n		 //Skip Text and Attribute Nodes\n		 if(row && row.id && row.id.indexOf(\"row\") > -1) count++;\n	  }\n	  return count;\n   }\n   \n   //-----------------------------------------------------------------------------------  \n   function countRows(ttbody) {  \n      var tbLen = ttbody.childNodes.length;\n	  var rowCount = 0;\n	  for (var i = (tbLen - 1); i >= 0; i--) {\n	     if(ttbody.childNodes[i].nodeType != 1) continue;\n		 rowCount++;\n	  }\n	  return rowCount;\n   }\n      \n   //-----------------------------------------------------------------------------------  \n   function addRow() {\n      var rowx = document.getElementById(\'row_x\');\n	  \n	  var ttbody = document.getElementById(\'ttbody\');\n	  //Insert row into the right place\n	  var rowCount = countRows(ttbody); 	  //Count actual rows for firefox b/c it\'s stupid\n	  var row = ttbody.insertRow((rowCount-2));\n	  \n	  row.id=\'row_\'+nextRowNum;\n	  //Task Entry Id\n	  var rowLen = rowx.childNodes.length;\n	  \n	  for ( var i = 0; i < rowLen; i++) {\n	     if(rowx.childNodes[i].nodeType != 1) continue;\n	     // create the cell\n         var clonetd = rowx.childNodes[i].cloneNode(true);\n		 \n		 var td = row.appendChild(clonetd);\n	     var colLen = td.childNodes.length;\n		 for ( var j = 0; j < colLen; j++) {\n		    var node = td.childNodes[j];\n//			alert(node + \" \" + node.nodeType);\n			//Skip Text and Attirbute Node Types\n			if(node.nodeType != 1) continue;\n			//alert(node + \" \" + node.tagName);\n			var nodeName = node.name;\n				\n			//Handle Image Node\n			if(node.tagName == \"IMG\") {\n			   var newImg = document.createElement(\'img\');\n			   newImg.setAttribute(\"style\",\"cursor:pointer\");\n			   newImg.src = \"<tmpl_var extras>/delete.gif\";\n			   newImg.onclick = removeRow;\n			   \n			   childLen = node.childNodes.length;\n			  // alert(\"removing this node\");\n			   td.removeChild(node);\n			   \n			  // alert(\"appending new node: \" + newImg);\n			   td.appendChild(newImg);\n			   continue;\n			}\n			\n			//Skip Nodes that have no names\n			if(nodeName == \"\") continue;\n			var nameParts = nodeName.split(\"_\");\n			var colName = nameParts[0];\n			//Set New Node Name\n			node.name = colName + \"_\" + nextRowNum;\n			//Set New Node ID\n			node.id = colName + \"_\" + nextRowNum + \"_formId\";\n			\n			if(colName == \"projectId\") {\n			   node.onchange = new Function(\'changeOptions(this,document.getElementById(\"taskId_\'+nextRowNum+\'_formId\"));\'); \n			} \n		 }   \n	  \n	  }\n	  nextRowNum++;\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function validateForm(form) {\n      //Set Row Total\n      form.rowTotal.value = (nextRowNum - 1);\n	  if(parseFloat(document.getElementById(\'totalHours\').innerHTML) > 168) {\n	     alert(\"<tmpl_var js.alert.validate.hours.error>\");\n		 return false;\n	  }\n	  \n	  var rows = document.getElementById(\"ttbody\");\n      var rowLen = rows.childNodes.length;\n	  var isValid = true;\n	  	  \n	  for(var i = 0; i <= rowLen; i++) {\n	     var row = rows.childNodes[i];\n		 if(row && row.id && row.id.indexOf(\"row\") > -1) {\n		    var rowId = row.id;\n		    var idPart = rowId.split(\"_\");\n		    var rowNum = idPart[1];\n		    var taskDateElem = document.getElementById(\"taskDate_\"+rowNum+\"_formId\");\n			taskDateElem.style.background=\'#FFFFFF\';\n			var projectElem = document.getElementById(\"projectId_\"+rowNum+\"_formId\");\n			projectElem.style.background=\'#FFFFFF\';\n			var taskElem = document.getElementById(\"taskId_\"+rowNum+\"_formId\");\n			taskElem.style.background=\'#FFFFFF\';\n			var hourElem = document.getElementById(\"hours_\"+rowNum+\"_formId\");\n			hourElem.style.background=\'#FFFFFF\';\n			//Uncomment below if you wish comments to be required\n			//var comments = document.getElementById(\"hours_\"+rowNum+\"_formId\");\n			//comments.style.background=\'#FFFFFF\';\n			\n			//Uncomment below if you wish comments to be required\n			//if(taskDateElem.value != \"\" || projectElem.value != \"\" || taskElem.value != \"\" || hourElem.value != \"\" || comments.value != \"\" ) {\n			//Comment below if you wish comments to be required\n			if(taskDateElem.value != \"\" || projectElem.value != \"\" || taskElem.value != \"\" || (hourElem.value != \"\" && hourElem.value != \"0\")) {\n			   if(taskDateElem.value == \"\") {\n				  taskDateElem.style.background=\'#FFFF99\';\n			      isValid = false;\n			   } \n			   \n			   if(projectElem.value == \"\") {\n			      projectElem.style.background=\'#FFFF99\';\n			      isValid = false;\n			   } \n			   \n			   if(taskElem.value == \"\") {\n			      taskElem.style.background=\'#FFFF99\';\n				  isValid = false;\n			   } \n			   \n			   if(hourElem.value == \"\" || hourElem.value == 0) {\n			      hourElem.style.background=\'#FFFF99\';\n				  isValid = false;\n			   }\n			   \n			   //Uncomment below if you wish comments to be required\n			   /*if(comments.value == \"\") {\n			      commnts.style.background=\'#FFFF99\';\n				  isValid = false;\n			   }*/\n			}\n		 }\n	  }\n	  \n	  if(!isValid) {\n	     alert(\"<tmpl_var js.alert.validate.incomplete.error>\");\n		 return false;\n	  }\n	  \n	  return true;\n   }\n   \n</script>\n\n<p><tmpl_if project.manage.url><a href=\"<tmpl_var project.manage.url>\"><tmpl_var project.manage.label></a></tmpl_if></p>\n<tmpl_var form.header>\n<tmpl_var form.timetracker>\n<tmpl_var form.footer>\n\n','TimeTracking_user',1,1,'TimeTrackingTMPL000001',1201205738,'WebGUI::Asset::Template::HTMLTemplate',1),('<br /><br />\r\n<tmpl_loop field_loop>\r\n<table cellpadding=\"3\" cellspacing=\"2\" border=\"0\" width=\"80%\">\r\n	<tmpl_unless field.isMailField>\r\n	<tr>\r\n		<td width=\"23%\" align=\"right\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\"><b><tmpl_var field.label> :</b></td>		\r\n		<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var field.value></td>\r\n	</tr>\r\n	</tmpl_unless>\r\n</table>\r\n</tmpl_loop>\r\n\r\n<tmpl_loop tab_loop>\r\n<h2><tmpl_var tab.label></h2>\r\n<tmpl_loop tab.field_loop>\r\n<table cellpadding=\"3\" cellspacing=\"2\" border=\"0\" width=\"80%\">\r\n	<tmpl_unless tab.field.isMailField>\r\n	<tr>\r\n		<td width=\"23%\" align=\"right\" bgcolor=\"#DFDFDF\" style=\"background-color:#DFDFDF;\"><b><tmpl_var tab.field.label> :</b></td>		\r\n		<td width=\"75%\" bgcolor=\"#F0F0F0\" style=\"background-color:#F0F0F0;\"><tmpl_var tab.field.value></td>\r\n	</tr>\r\n	</tmpl_unless>\r\n</table>\r\n</tmpl_loop>\r\n</tmpl_loop>','DataForm',1,1,'PBtmpl0000000000000085',1202884864,'WebGUI::Asset::Template::HTMLTemplate',1