<?php
/**************************************************************************
* This file is part of the WebIssues Server program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

function wi_db_connect( $host, $database, $user, $password )
{
    global $db_link;

    $port = '';
    $socket = '';

    $parts = explode( ':', $host );
    if ( isset( $parts[ 1 ] ) ) {
        $host = $parts[ 0 ];
        if ( is_numeric( $parts[ 1 ] ) )
            $port = $parts[ 1 ];
        else
            $socket = $parts[ 1 ];
    }

    if ( $host == '' )
        $host = 'localhost';

    if ( $socket != '' )
        $db_link = mysqli_connect( $host, $user, $password, $database, null, $socket );
    else if ( $port != '' )
        $db_link = mysqli_connect( $host, $user, $password, $database, $port );
    else
        $db_link = mysqli_connect( $host, $user, $password, $database );

    if ( !$db_link )
        return false;

    mysqli_query( $db_link, "SET NAMES 'utf8'" );

    return true;
}

function wi_db_escape_arg( $arg, $type )
{
    global $db_link;

    switch( $type ) {
        case 'd':
            return (int)$arg;
        case 's':
        case 'b':
            return "'" . mysqli_escape_string( $db_link, $arg ) . "'";
    }
}

function wi_db_query( $query )
{
    global $db_link;

    $log = wi_log_open( 'sql' );
    if ( $log )
        fwrite( $log, "> $query\n" );

    $rs = mysqli_query( $db_link, $query );

    if ( !$rs ) {
        $error = mysqli_error( $db_link );
        trigger_error( 'mysqli_query(): ' . $error, E_USER_WARNING );
        if ( $log )
            fwrite( $log, "ERROR: $error\n" );
        return false;
    }

    if ( $log ) {
        if ( $rs === true ) {
            $num = mysqli_affected_rows( $db_link );
            fwrite( $log, "($num rows affected)\n" );
        } else {
            $num = mysqli_num_rows( $rs );
            fwrite( $log, "($num rows returned)\n" );
        }
    }

    return $rs;
}

function wi_db_fetch_assoc( $rs )
{
    return mysqli_fetch_assoc( $rs );
}

function wi_db_unescape_blob( $data )
{
    return $data;
}

function wi_db_insert_id( $table, $column )
{
    global $db_link;

    return mysqli_insert_id( $db_link );
}

function wi_db_table_exists( $table )
{
    global $db_link;

    $query = "SHOW TABLES LIKE '$table'";
    $rs = mysqli_query( $db_link, $query );
    return mysqli_num_rows( $rs ) > 0;
}
