/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "configdata.h"

#include <QSettings>
#if defined( Q_WS_WIN )
#include <QApplication>
#include <QDir>
#endif

using namespace WebIssues;

ConfigData* WebIssues::configData = NULL;

ConfigData::ConfigData()
{
    m_settings = new QSettings( "WebIssues", "WebIssues" );

    loadSettings();
}

ConfigData::~ConfigData()
{
    delete m_settings;
}

void ConfigData::loadSettings()
{
    m_settings->beginGroup( "GeneralSettings" );
    m_dockWindow = m_settings->value( "DockWindow", false ).toBool();
    m_showAtStartup = (RestoreOption)m_settings->value( "ShowAtStartup", (RestoreOption)RestoreAuto ).toInt();
    QVariant reconnect = m_settings->value( "ReconnectAtStartup" );
    if ( reconnect.toString() == "true" )
        m_reconnectAtStartup = RestoreAuto;
    else
        m_reconnectAtStartup = (RestoreOption)reconnect.toInt();
    m_settings->endGroup();

    m_settings->beginGroup( "AdvancedSettings" );
    m_updateInterval = m_settings->value( "UpdateInterval", 5 ).toInt();
    m_defaultAttachmentAction = (AttachmentAction)m_settings->value( "DefaultAttachmentAction", (int)ActionAsk ).toInt();
    m_attachmentsCacheSize = m_settings->value( "AttachmentsCacheSize", 10 ).toInt();
    m_warnAttachmentSize = m_settings->value( "WarnAttachmentSize", 2 ).toInt();
    m_settings->endGroup();
}

void ConfigData::saveSettings()
{
    m_settings->beginGroup( "GeneralSettings" );
    m_settings->setValue( "DockWindow", m_dockWindow );
    m_settings->setValue( "ShowAtStartup", (int)m_showAtStartup );
    m_settings->setValue( "ReconnectAtStartup", (int)m_reconnectAtStartup );
    m_settings->endGroup();

    m_settings->beginGroup( "AdvancedSettings" );
    m_settings->setValue( "UpdateInterval", m_updateInterval );
    m_settings->setValue( "DefaultAttachmentAction", (int)m_defaultAttachmentAction );
    m_settings->setValue( "AttachmentsCacheSize", m_attachmentsCacheSize );
    m_settings->setValue( "WarnAttachmentSize", m_warnAttachmentSize );
    m_settings->endGroup();

    emit settingsChanged();
}

#if defined( Q_WS_WIN )

bool ConfigData::checkAutoStart()
{
    QSettings autoStart( "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run", QSettings::NativeFormat );
    return autoStart.contains( "WebIssues" );
}

void ConfigData::setAutoStart( bool start )
{
    QSettings autoStart( "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Run", QSettings::NativeFormat );
    if ( start )
        autoStart.setValue( "WebIssues", '"' + QDir::toNativeSeparators( QApplication::applicationFilePath() ) + '"' );
    else
        autoStart.remove( "WebIssues" );
}

#endif

#include "configdata.moc"
