/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef COLUMNCONDITIONHELPER_H
#define COLUMNCONDITIONHELPER_H

#include <QList>

#include "columncondition.h"

class QObject;
class QWidget;

namespace WebIssues
{

class DefinitionInfo;
class AbstractValueEditor;

/**
* Functions for managing filter conditions.
*/
class ColumnConditionHelper
{
public:
    /**
    * Return the definition of the given system or user column.
    *
    * @param column The column identifier.
    *
    * @return The attribute definition for a user column or a definition of a system column.
    */
    static DefinitionInfo columnDefinition( Column column );

    /**
    * Get available conditions for a column.
    *
    * @param info Definition of a column.
    *
    * @return List of available conditions types for that column.
    */
    static QList<ColumnCondition::Condition> availableConditions( const DefinitionInfo& info );

    /**
    * Create a delegate for editing the value of a column operand.
    *
    * @param info Column definition.
    *
    * @param condition Type of the condition.
    *
    * @param projectId Optional project identifier for attribute value context.
    *
    * @param parent Parent object of the editor delegate.
    *
    * @param parentWidget Parent widget of the editor widget.
    *
    * @return The created object or @c NULL if the condition has no operand.
    */
    static AbstractValueEditor* createValueEditor( const DefinitionInfo& info, ColumnCondition::Condition condition,
                                                   int projectId, QObject* parent, QWidget* parentWidget );
};

}

#endif
