/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef FOLDERVIEW_H
#define FOLDERVIEW_H

#include "view.h"

class QTreeView;
class QModelIndex;
class QComboBox;

namespace WebIssues
{

class TableItemModel;
class IssueRowFilter;
class SearchEditBox;
class ColumnCondition;

/**
* View for displaying issues in a folder.
*/
class FolderView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    FolderView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~FolderView();

public: // overrides
    void initialUpdate();

protected: // overrides
    void enableView();
    void disableView();

    void updateEvent( UpdateEvent* e );

    void viewEvent( ViewEvent* e );

private slots:
    void updateActions();
    void updateSummary();

    void updateFolder();
    void openIssue();
    void addIssue();
    void changeFilter();
    void saveFilterAs();
    void renameFilter();
    void deleteFilter();
    void configureColumns();

    void headerContextMenu( const QPoint& pos );
    void listContextMenu( const QPoint& pos );

    void doubleClicked( const QModelIndex& index );

    void quickSearchChanged( const QString& text );
    void filterActivated( int index );

    void applyColumns();
    void applyFilter();

private:
    Access checkDataAccess();

    void updateCaption();

    void updateColumnList();
    void updateFilters();

    void loadCurrentFilter();

    QModelIndex selectedIndex();

private:
    enum FilterType
    {
        NoFilter,
        SettingsFilter,
        NewFilter
    };

private:
    QTreeView* m_list;
    TableItemModel* m_model;

    IssueRowFilter* m_filter;

    QComboBox* m_filterCombo;
    SearchEditBox* m_searchBox;

    FilterType m_filterType;
    QString m_filterName;

    QList<ColumnCondition> m_newConditions;

    int m_typeId;
    int m_projectId;

    int m_selectedIssueId;
};

}

#endif
