/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "datarows.h"

ProjectRow::ProjectRow( int projectId, const QString& name ) :
    m_projectId( projectId ),
    m_name( name )
{
}

ProjectRow::~ProjectRow()
{
}

FolderRow::FolderRow( int folderId, int projectId, const QString& name, int typeId, int stamp ) :
    m_folderId( folderId ),
    m_projectId( projectId ),
    m_name( name ),
    m_typeId( typeId ),
    m_stamp( stamp )
{
}

FolderRow::~FolderRow()
{
}

UserRow::UserRow( int userId, const QString& login, const QString& name, Access access ) :
    m_userId( userId ),
    m_login( login ),
    m_name( name ),
    m_access( access )
{
}

UserRow::~UserRow()
{
}

MemberRow::MemberRow( int userId, int projectId, Access access ) :
    m_userId( userId ),
    m_projectId( projectId ),
    m_access( access )
{
}

MemberRow::~MemberRow()
{
}

TypeRow::TypeRow( int typeId, const QString& name ) :
    m_typeId( typeId ),
    m_name( name )
{
}

TypeRow::~TypeRow()
{
}

AttributeRow::AttributeRow( int attributeId, int typeId, const QString& name, const QString& definition ) :
    m_attributeId( attributeId ),
    m_typeId( typeId ),
    m_name( name ),
    m_definition( definition )
{
}

AttributeRow::~AttributeRow()
{
}

IssueRow::IssueRow( int issueId, int folderId, const QString& name, int stamp, const QDateTime& createdDate,
        int createdUser, const QDateTime& modifiedDate, int modifiedUser ) :
    m_issueId( issueId ),
    m_folderId( folderId ),
    m_name( name ),
    m_stamp( stamp ),
    m_createdDate( createdDate ),
    m_createdUser( createdUser ),
    m_modifiedDate( modifiedDate ),
    m_modifiedUser( modifiedUser )
{
}

IssueRow::~IssueRow()
{
}

ValueRow::ValueRow( int attributeId, int issueId, const QString& value ) :
    m_attributeId( attributeId ),
    m_issueId( issueId ),
    m_value( value )
{
}

ValueRow::~ValueRow()
{
}

CommentRow::CommentRow( int commentId, int issueId, const QDateTime& createdDate, int createdUser,
        const QString& text ) :
    m_commentId( commentId ),
    m_issueId( issueId ),
    m_createdDate( createdDate ),
    m_createdUser( createdUser ),
    m_text( text )
{
}

CommentRow::~CommentRow()
{
}

AttachmentRow::AttachmentRow( int attachmentId, int issueId, const QString& name, const QDateTime& createdDate,
        int createdUser, int size, const QString& description ) :
    m_attachmentId( attachmentId ),
    m_issueId( issueId ),
    m_name( name ),
    m_createdDate( createdDate ),
    m_createdUser( createdUser ),
    m_size( size ),
    m_description( description )
{
}

AttachmentRow::~AttachmentRow()
{
}

ChangeRow::ChangeRow( int changeId, int issueId, const QDateTime& modifiedDate, int modifiedUser,
        int attributeId, const QString& oldValue, const QString& newValue ) :
    m_changeId( changeId ),
    m_issueId( issueId ),
    m_modifiedDate( modifiedDate ),
    m_modifiedUser( modifiedUser ),
    m_attributeId( attributeId ),
    m_oldValue( oldValue ),
    m_newValue( newValue )
{
}

ChangeRow::~ChangeRow()
{
}
