/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "savefilterdialog.h"

#include <QLayout>
#include <QLabel>
#include <QComboBox>
#include <QDialogButtonBox>
#include <QPushButton>
#include <QMessageBox>

SaveFilterDialog::SaveFilterDialog( QWidget* parent ) : QDialog( parent )
{
    setWindowTitle( tr( "Save Filter" ) );

    QVBoxLayout* layout = new QVBoxLayout( this );

    QHBoxLayout* nameLayout = new QHBoxLayout();
    layout->addLayout( nameLayout );

    QLabel* nameLabel = new QLabel( tr( "&Name:" ), this );
    nameLayout->addWidget( nameLabel );

    m_nameCombo = new QComboBox( this );
    m_nameCombo->setEditable( true );
    m_nameCombo->setMinimumWidth( 200 );
    nameLayout->addWidget( m_nameCombo, 1 );

    nameLabel->setBuddy( m_nameCombo );

    connect( m_nameCombo, SIGNAL( editTextChanged( const QString& ) ), this, SLOT( nameChanged( const QString& ) ) );

    m_buttonBox = new QDialogButtonBox( QDialogButtonBox::Ok | QDialogButtonBox::Cancel,
        Qt::Horizontal, this );
    layout->addWidget( m_buttonBox );

    m_buttonBox->button( QDialogButtonBox::Ok )->setText( tr( "&OK" ) );
    m_buttonBox->button( QDialogButtonBox::Cancel )->setText( tr( "&Cancel" ) );

    connect( m_buttonBox, SIGNAL( accepted() ), this, SLOT( accept() ) );
    connect( m_buttonBox, SIGNAL( rejected() ), this, SLOT( reject() ) );

    m_nameCombo->setEditText( tr( "New Filter" ) );

    setMaximumHeight( sizeHint().height() );
}

SaveFilterDialog::~SaveFilterDialog()
{
}

void SaveFilterDialog::setFilterName( const QString& name )
{
    m_oldName = name;

    m_nameCombo->setEditText( name );
}

QString SaveFilterDialog::filterName() const
{
    return m_nameCombo->currentText();
}

void SaveFilterDialog::setExistingFilters( const QStringList& filters )
{
    m_existingFilters = filters;
    m_existingFilters.sort();

    QString name = m_nameCombo->currentText();

    m_nameCombo->clear();
    m_nameCombo->addItems( m_existingFilters );

    m_nameCombo->setEditText( name );
}

void SaveFilterDialog::accept()
{
    QString name = m_nameCombo->currentText();

    if ( name != m_oldName && m_existingFilters.contains( name ) ) {
        if ( QMessageBox::warning( this, tr( "Warning" ),
            tr( "<qt>Do you want to overwrite the existing filter <b>%1</b>?</qt>" ).arg( name ),
            QMessageBox::Yes | QMessageBox::No ) == QMessageBox::No )
            return;
    }

    QDialog::accept();
}

void SaveFilterDialog::nameChanged( const QString& name )
{
    m_buttonBox->button( QDialogButtonBox::Ok )->setEnabled( !name.isEmpty() );
}
