/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#if defined( HAVE_OPENSSL )

#include "sslerrorsdialog.h"

#include <QLayout>
#include <QLabel>
#include <QPushButton>
#include <QListWidget>
#include <QDialogButtonBox>

#include "attributes/datetimehelper.h"
#include "dialogs/sslcertificatesdialog.h"
#include "widgets/gradientwidget.h"
#include "iconloader.h"

SslErrorsDialog::SslErrorsDialog( QWidget* parent ) : QDialog( parent )
{
    setWindowTitle( tr( "Secure Connection Error" ) );

    QVBoxLayout* topLayout = new QVBoxLayout( this );
    topLayout->setMargin( 0 );
    topLayout->setSpacing( 0 );

    QWidget* promptWidget = new GradientWidget( this );
    topLayout->addWidget( promptWidget );

    QHBoxLayout* promptLayout = new QHBoxLayout( promptWidget );
    promptLayout->setSpacing( 10 );

    QLabel* promptPixmap = new QLabel( promptWidget );
    promptPixmap->setPixmap( IconLoader::pixmap( "edit-access", 22 ) );
    promptLayout->addWidget( promptPixmap, 0 );

    QLabel* promptLabel = new QLabel( promptWidget );
    promptLabel->setWordWrap( true );
    promptLabel->setMinimumWidth( 300 );
    promptLabel->setText( tr( "The connection could not be validated" ) );
    promptLayout->addWidget( promptLabel, 1 );

    QFrame* separator = new QFrame( this );
    separator->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    topLayout->addWidget( separator );

    QVBoxLayout* mainLayout = new QVBoxLayout();
    mainLayout->setMargin( 9 );
    mainLayout->setSpacing( 6 );
    topLayout->addLayout( mainLayout );

    QLabel* messageLabel = new QLabel( this );
    messageLabel->setWordWrap( true );
    messageLabel->setMinimumWidth( 400 );
    messageLabel->setText( tr( "The authenticity of the host you are connecting to cannot be validated."
        " Please review the list of errors below and click Ignore to continue or Cancel to abort." ) );
    mainLayout->addWidget( messageLabel );

    m_list = new QListWidget( this );
    m_list->setSelectionMode( QListWidget::NoSelection );
    m_list->setFixedHeight( 100 );
    mainLayout->addWidget( m_list );

    QHBoxLayout* buttonsLayout = new QHBoxLayout();
    mainLayout->addLayout( buttonsLayout );

    m_certificatesButton = new QPushButton( tr( "View Certificate" ), this );
    m_certificatesButton->setEnabled( false );
    buttonsLayout->addWidget( m_certificatesButton );

    connect( m_certificatesButton, SIGNAL( clicked() ), this, SLOT( showCertificates() ) );

    QDialogButtonBox* buttonBox = new QDialogButtonBox( QDialogButtonBox::Ignore | QDialogButtonBox::Cancel,
        Qt::Horizontal, this );
    buttonsLayout->addWidget( buttonBox );

    buttonBox->button( QDialogButtonBox::Ignore )->setText( tr( "&Ignore" ) );
    buttonBox->button( QDialogButtonBox::Cancel )->setText( tr( "&Cancel" ) );

    connect( buttonBox, SIGNAL( accepted() ), this, SLOT( accept() ) );
    connect( buttonBox, SIGNAL( rejected() ), this, SLOT( reject() ) );

    messageLabel->setFixedHeight( messageLabel->heightForWidth( messageLabel->minimumWidth() ) );

    setFixedSize( sizeHint() );
}

SslErrorsDialog::~SslErrorsDialog()
{
}

void SslErrorsDialog::setErrors( const QList<QSslError>& errors )
{
    m_list->clear();

    for ( int i = 0; i < errors.count(); i++ ) {
        QListWidgetItem* item = new QListWidgetItem( m_list );
        item->setText( errors.at( i ).errorString() );
    }
}

void SslErrorsDialog::setCertificates( const QList<QSslCertificate>& certificates )
{
    m_certificates = certificates;

    m_certificatesButton->setEnabled( !certificates.isEmpty() );
}

void SslErrorsDialog::showCertificates()
{
    SslCertificatesDialog dialog( this );
    dialog.setCertificates( m_certificates );
    dialog.exec();
}

#endif // defined( HAVE_OPENSSL )
