/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "csvreportgenerator.h"

#include "data/datamanager.h"
#include "csvreportwriter.h"
#include "tablemodels.h"
#include "treeviewsettings.h"

CsvReportGenerator::CsvReportGenerator() :
    m_folderId( 0 ),
    m_table( NoTable ),
    m_writer( NULL )
{
}

CsvReportGenerator::~CsvReportGenerator()
{
}

void CsvReportGenerator::setFolder( int folderId, const QList<int>& issues )
{
    m_folderId = folderId;
    m_issues = issues;
}

void CsvReportGenerator::setTable( Table table )
{
    m_table = table;
}

void CsvReportGenerator::write( CsvReportWriter* writer )
{
    m_writer = writer;

    const FolderRow* folder = dataManager->folders()->find( m_folderId );
    if ( folder ) {
        TreeViewSettings settings;
        settings.openIssuesList( folder->typeId() );

        if ( m_table == CurrentTable )
            writeIssuesTable( settings.loadColumns() );
        else if ( m_table == FullTable )
            writeIssuesTable( settings.availableColumns() );
    }
}

void CsvReportGenerator::writeIssuesTable( const QList<int>& columns )
{
    IssuesTableModel model( m_folderId, NULL );

    QStringList cells;
    for ( int i = 0; i < columns.count(); i++ ) {
        int column = columns.at( i );
        QString name = model.columnName( column );
        cells.append( m_writer->field( name ) );
    }
    m_writer->writeRow( cells );

    for ( int i = 0; i < m_issues.count(); i++ ) {
        int issueId = m_issues.at( i );
        cells.clear();
        for ( int j = 0; j < columns.count(); j++ ) {
            int column = columns.at( j );
            QString text = model.text( issueId, column );
            cells.append( m_writer->field( text ) );
        }
        m_writer->writeRow( cells );
    }
}
