/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "folderwatchwriter.h"

#include <QUrl>

#include "linklocator.h"

FolderWatchWriter::FolderWatchWriter()
{
}

FolderWatchWriter::~FolderWatchWriter()
{
}

void FolderWatchWriter::begin()
{
    m_lines.append( "<table width=\"100%\" cellpadding=\"3\" cellspacing=\"5\">" );
}

void FolderWatchWriter::end()
{
    m_lines.append( "</table>" );
}

void FolderWatchWriter::writeProjectHeader( const QString& name )
{
    m_lines.append( QString( "<tr><th colspan=\"4\" bgcolor=\"#cccccc\">%1</th></tr>" ).arg( name ) );
}

void FolderWatchWriter::writeFolderHeader( const QString& name )
{
    m_lines.append( QString( "<tr><td colspan=\"4\" bgcolor=\"#dddddd\">%1</td></tr>" ).arg( name ) );
}

void FolderWatchWriter::writeWatchRow( const QString& linkCell, const QString& totalCell, const QString& newCell, const QString& updatedCell )
{
    m_lines.append( QString( "<tr>%1%2%3%4</tr>" ).arg( linkCell, totalCell, newCell, updatedCell ) );
}

QString FolderWatchWriter::name( const QString& text )
{
    return QString ( "<strong>%1</strong>" ).arg( LinkLocator::escape( text ) );
}

QString FolderWatchWriter::linkCell( int folderId, const QString& watch, const QString& name )
{
    QString encoded = QUrl::toPercentEncoding( watch );
    QString url = QString( "watch://%1/%2" ).arg( folderId ).arg( encoded );

    return QString( "<td width=\"40%\" bgcolor=\"#eeeeee\"><a href=\"%1\">%2</a></td>" ).arg( url, LinkLocator::escape( name ) );
}

QString FolderWatchWriter::watchCell( const QString& text, WatchState state, int count )
{
    QString color;
    if ( state == WatchUpdated && count > 0 )
        color = "#99ff99";
    else if ( state == WatchNew && count > 0 )
        color = "#ffff88";
    else
        color = "#eeeeee";

    return QString( "<td width=\"20%\" bgcolor=\"%1\">%2: %3</td>" ).arg( color, text ).arg( count );
}

QString FolderWatchWriter::result() const
{
    return m_lines.join( "\r\n" );
}
