/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "issueviewsettings.h"

#include <QSettings>
#include <QStringList>

#include "data/datamanager.h"
#include "data/datarows.h"
#include "rdb/utilities.h"
#include "connectionmanager.h"

IssueViewSettings::IssueViewSettings() :
    m_typeId( 0 )
{
}

IssueViewSettings::~IssueViewSettings()
{
}

void IssueViewSettings::openIssueView( int typeId )
{
    m_typeId = typeId;
}

QList<int> IssueViewSettings::loadAttributes()
{
    QSettings* settings = connectionManager->serverSettings();

    settings->beginGroup( "Attributes" );

    QStringList list = settings->value( QString( "Type%1" ).arg( m_typeId ) ).toStringList();
    QList<int> loaded = deserializeAttributes( list );

    settings->endGroup();

    RDB::ForeignConstIterator<AttributeRow> it( dataManager->attributes()->parentIndex(), m_typeId );
    QList<const AttributeRow*> attributes = localeAwareSortRows( it, &AttributeRow::name );

    QList<int> available;
    for ( int i = 0; i < attributes.count(); i++ )
        available.append( attributes.at( i )->attributeId() );

    QList<int> merged;

    for ( int i = 0; i < loaded.count(); i++ ) {
        int attributeId = loaded.at( i );
        int index = available.indexOf( attributeId );
        if ( index >= 0 ) {
            merged.append( attributeId );
            available.removeAt( index );
        }
    }

    merged += available;

    return merged;
}

void IssueViewSettings::saveAttributes( const QList<int>& attributes )
{
    QSettings* settings = connectionManager->serverSettings();

    settings->beginGroup( "Attributes" );

    settings->setValue( QString( "Type%1" ).arg( m_typeId ), serializeAttributes( attributes ) );

    settings->endGroup();
}

QStringList IssueViewSettings::serializeAttributes( const QList<int>& attributes )
{
    QStringList list;

    for ( int i = 0; i < attributes.count(); i++ )
        list.append( QString::number( attributes.at( i ) ) );

    return list;
}

QList<int> IssueViewSettings::deserializeAttributes( const QStringList& list )
{
    QList<int> attributes;

    for ( int i = 0; i < list.count(); i++ ) {
        int attributeId = list.at( i ).toInt();
        attributes.append( attributeId );
    }

    return attributes;
}
