/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ROWFILTERS_H
#define ROWFILTERS_H

#include <QList>

#include "rdb/abstractrowfilter.h"
#include "columncondition.h"

class IssueRow;

/**
* Filter for issue rows using a list of conditions.
*
* Issue rows can be filtered using a list of conditions for column values
* and a quick search string. Either of them can be empty.
*/
class IssueRowFilter : public RDB::AbstractRowFilter
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    */
    IssueRowFilter( QObject* parent );

    /**
    * Destructor.
    */
    ~IssueRowFilter();

public:
    /**
    * Set the list of column conditions to use for filtering.
    */
    void setConditions( const QList<ColumnCondition>& conditions );

    /**
    * Return the list of column conditions used for filtering.
    */
    const QList<ColumnCondition>& conditions() const { return m_conditions; }

    /**
    * Set the string to search in given column.
    */
    void setQuickSearch( int column, const QString& text );

    /**
    * Return the quick search column.
    */
    int searchColumn() const { return m_searchColumn; }

    /**
    * Return the quick search text.
    */
    const QString& searchText() const { return m_searchText; }

public: // overrides
    bool filterRow( int id );

private:
    QString extractValue( const IssueRow* row, int column );

private:
    QList<ColumnCondition> m_conditions;

    int m_searchColumn;
    QString m_searchText;
};

#endif
