include( ../config.pri )

TEMPLATE = app
TARGET   = webissues

CONFIG  += qt
QT      += network xml

HEADERS += application.h \
           configdata.h \
           connectionmanager.h \
           iconloader.h \
           mainwindow.h \
           viewerwindow.h \
           viewmanager.h

SOURCES += application.cpp \
           configdata.cpp \
           connectionmanager.cpp \
           iconloader.cpp \
           main.cpp \
           mainwindow.cpp \
           viewerwindow.cpp \
           viewmanager.cpp

win32 {
    HEADERS += windowsmodernstyle.h
    SOURCES += windowsmodernstyle.cpp
}

include( attributes/attributes.pri )
include( commands/commands.pri )
include( data/data.pri )
include( dialogs/dialogs.pri )
include( icons/icons.pri )
include( models/models.pri )
include( rdb/rdb.pri )
include( resources/resources.pri )
include( views/views.pri )
include( widgets/widgets.pri )
include( xmlui/xmlui.pri )

INCLUDEPATH += .

contains( QT_CONFIG, openssl ) {
    DEFINES += HAVE_OPENSSL
}

PRECOMPILED_HEADER = precompiled.h

TRANSLATIONS += \
           ../translations/webissues_untranslated.ts \
           ../translations/webissues_de.ts \
           ../translations/webissues_es.ts \
           ../translations/webissues_pl.ts \
           ../translations/webissues_ru.ts

win32 {
    RC_FILE = webissues.rc
    LIBS += -lshell32
}

win32-msvc* {
    QMAKE_CXXFLAGS += -Fd\$(IntDir)
    CONFIG -= flat
}

MOC_DIR = ../tmp
RCC_DIR = ../tmp
UI_DIR = ../tmp
CONFIG( debug, debug|release ) {
    OBJECTS_DIR = ../tmp/debug
    DESTDIR = ../debug
} else {
    OBJECTS_DIR = ../tmp/release
    DESTDIR = ../release
}

target.path = $${DESTINATION}$$PREFIX/bin
INSTALLS += target

unix {
    desktop.files = webissues.desktop
    desktop.path = $${DESTINATION}$$PREFIX/share/applications
    INSTALLS += desktop

    ICON_SIZES = 16 22 32 48
    for( size, ICON_SIZES ) {
        path = $${DESTINATION}$$PREFIX/share/icons/hicolor/$${size}x$${size}/apps
        file = $(INSTALL_ROOT)$$path/webissues.png
        eval( icon-$${size}.path = $$path )
        eval( icon-$${size}.commands = -$(INSTALL_FILE) $$IN_PWD/icons/webissues-$${size}.png $$file )
        eval( icon-$${size}.uninstall = -$(DEL_FILE) $$file )
        INSTALLS += icon-$${size}
    }

    man.files = webissues.1
    man.path = $${DESTINATION}$$PREFIX/share/man/man1
    INSTALLS += man
}
