/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef VIEWEVENT_H
#define VIEWEVENT_H

#include <QEvent>

/**
* Event for communication between views.
*
* This event can be sent to all views of a given class
* using the view manager.
*/
class ViewEvent : public QEvent
{
public:
    /**
    * Type of the action.
    */
    enum Action
    {
        /**
        * Reload column settings.
        *
        * Used by the FolderView. The id() is the folder's issue type.
        */
        UpdateColumnList,

        /**
        * Reload filter settings and watch settings.
        *
        * Used by the FolderView. The id() is the folder's issue type.
        */
        UpdateFilters,

        /**
        * Reload attributes settings.
        *
        * Used by the IssueView. The id() is the issue type.
        */
        UpdateAttributes,

        /**
        * Reload all settings.
        */
        UpdateSettings,

        /**
        * Update issues watch state and recalculate watches for a folder.
        *
        * Used by the DashboardView and FolderView. The id() is the folder.
        */
        RecalculateWatches,

        /**
        * Update the watch state of a folder.
        *
        * Used by ProjectsView. The id() is the folder.
        */
        UpdateWatches
    };

    /**
    * Type of the event returned by QCustomEvent::type().
    */
    static const int Type = QEvent::User + 2;

public:
    /**
    * Constructor.
    *
    * @param action The action to execute.
    *
    * @param id An additional identifier.
    */
    ViewEvent( Action action, int id );

    /**
    * Destructor.
    */
    ~ViewEvent();

public:
    /**
    * Return the action to execute.
    */
    Action action() const { return m_action; }

    /**
    * Return the additional identifier.
    */
    int id() const { return m_id; }

private:
    Action m_action;
    int m_id;
};

#endif
