/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "viewfactory.h"

#include <QMetaObject>

#include "usersview.h"
#include "membersview.h"
#include "typesview.h"
#include "folderview.h"
#include "issueview.h"
#include "commentview.h"

View* ViewFactory::createView( const char* className, QObject* parent, QWidget* parentWidget )
{
    if ( !qstrcmp( className, UsersView::staticMetaObject.className() ) )
        return new UsersView( parent, parentWidget );
    if ( !qstrcmp( className, MembersView::staticMetaObject.className() ) )
        return new MembersView( parent, parentWidget );
    if ( !qstrcmp( className, TypesView::staticMetaObject.className() ) )
        return new TypesView( parent, parentWidget );
    if ( !qstrcmp( className, FolderView::staticMetaObject.className() ) )
        return new FolderView( parent, parentWidget );
    if ( !qstrcmp( className, IssueView::staticMetaObject.className() ) )
        return new IssueView( parent, parentWidget );
    if ( !qstrcmp( className, CommentView::staticMetaObject.className() ) )
        return new CommentView( parent, parentWidget );
    return NULL;
}
