/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "gradientwidget.h"

#include <QPainter>
#include <QStyleOption>

#if defined( Q_WS_WIN )
#include "windowsmodernstyle.h"
#endif

GradientWidget::GradientWidget( QWidget* parent ) : QWidget( parent )
{
#if defined( Q_WS_WIN ) && !defined( NO_STYLE_WINDOWSMODERN )
    if ( !qobject_cast<WindowsModernStyle*>( style() ) ) {
#else
    if ( true ) {
#endif
        setPalette( QPalette( QColor( 255, 255, 255 ) ) );
        setAutoFillBackground( true );
    }
}

GradientWidget::~GradientWidget()
{
}

void GradientWidget::paintEvent( QPaintEvent* /*e*/ )
{
#if defined( Q_WS_WIN ) && !defined( NO_STYLE_WINDOWSMODERN )
    if ( qobject_cast<WindowsModernStyle*>( style() ) ) {
        QPainter painter( this );
        QStyleOption option;
        option.initFrom( this );
        style()->drawPrimitive( (QStyle::PrimitiveElement)WindowsModernStyle::PE_WindowGradient, &option, &painter, this );
    }
#endif
}
