/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef POPEDITBOX_H
#define POPEDITBOX_H

#include <QFrame>

class QLabel;
class QPushButton;

class PopEditBrowser;

/**
* A read-only edit box with an edit button.
*
* The text is reach text and may contain links.
*/
class PopEditBox : public QFrame
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent widget.
    */
    PopEditBox( QWidget* parent );

    /**
    * Constructor.
    *
    * @param text The text displayed in the box.
    *
    * @param parent The parent widget.
    */
    PopEditBox( const QString& text, QWidget* parent );

    /**
    * Destructor.
    */
    ~PopEditBox();

public:
    /**
    * Set the text displayed in the box.
    */
    void setText( const QString& text );

    /**
    * Return the text displayed in the box.
    */
    QString text() const;

    /**
    * Clear the text in the box.
    */
    void clear();

    /**
    * Return the edit button.
    */
    QPushButton* button() { return m_button; }

signals:
    /**
    * Emitted when a link was clicked.
    *
    * @param link The URL of the link.
    */
    void linkClicked( const QString& link );

    /**
    * Emitted when a context menu for a link is needed.
    *
    * @param link The URL of the link.
    *
    * @param pos The position to display the context menu.
    */
    void linkContextMenu( const QString& link, const QPoint& pos );

    /**
    * Emitted when the edit button was clicked.
    */
    void buttonClicked();

private slots:
    void labelLinkHovered( const QString& link );
    void labelContextMenu( const QPoint& pos );

private:
    void initialize();

private:
    QLabel* m_label;
    QPushButton* m_button;

    QString m_link;
};

#endif
