/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "definitionbuilder.h"

#include <QStringList>

DefinitionBuilder::DefinitionBuilder()
{
}

DefinitionBuilder::~DefinitionBuilder()
{
}

void DefinitionBuilder::setType( const QString& type )
{
    m_result = type;
}

void DefinitionBuilder::addMetadata( const QString& key, const QVariant& value )
{
    QString formatted;
    if ( value.type() == QVariant::StringList )
        formatted = buildStringArray( value.toStringList() );
    else if ( value.type() == QVariant::String )
        formatted = buildString( value.toString() );
    else
        formatted = value.toString();
    m_result += QString( " %1=%2" ).arg( key, formatted );
}

QString DefinitionBuilder::buildStringArray( const QStringList& array )
{
    QString result = "{";
    for ( QStringList::const_iterator it = array.begin(); it != array.end(); ++it ) {
        if ( it != array.begin() )
            result += QLatin1String( "," );
        result += buildString( *it );
    }
    result += QLatin1String( "}" );
    return result;
}

QString DefinitionBuilder::buildString( const QString& string )
{
    QString result = string;
    result.replace( '\\', "\\\\" );
    result.replace( '\"', "\\\"" );
    return QString( "\"%1\"" ).arg( result );
}
