/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef DEFINITIONBUILDER_H
#define DEFINITIONBUILDER_H

#include <QVariant>

/**
* Attribute definition builder.
*
* This class creates a definition string according to the WebIssues protocol.
*
* Definition consists of a type keyword and zero or more metadata
* separated by single spaces. Each metadata consists of a name and value
* separated by the equals sign.
*
* Metadata names start with lowercase letters and may contain lowercase
* letters and hyphens.
*
* Metadata values can be one of the following:
*
* <dl>
* <dt>integer</dt>
* <dd>optional minus sign followed by one or more decimal digits</dd>
*
* <dt>string</dt>
* <dd>a sequence of characters enclosed in double qoutes, with double quote and backslash
* characters escaped as \" and \\ respectively</dd>
*
* <dt>array of strings</dt>
* <dd>zero or more strings separated by commas and enclosed in curly braces</dd>
* </dl>
*
* @see DefinitionParser
*/
class DefinitionBuilder
{
public:
    /**
    * Default constructor.
    */
    DefinitionBuilder();

    /**
    * Destructor.
    */
    ~DefinitionBuilder();

public:
    /**
    * Set the type string.
    */
    void setType( const QString& type );

    /**
    * Append a metadata value.
    */
    void addMetadata( const QString& key, const QVariant& value );

    /**
    * Return the formatted string.
    */
    const QString& result() const { return m_result; }

private:
    QString buildStringArray( const QStringList& array );
    QString buildString( const QString& string );

private:
    QString m_result;
};

#endif
