/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "preferenceshelper.h"

#include <QRegExp>

QString PreferencesHelper::formatTimeZone( int zone )
{
    char sign = ( zone < 0 ) ? '-' : '+';
    if ( zone < 0 )
        zone = -zone;
    int hours = zone / 3600;
    int minutes = ( zone / 60 ) % 60;
    return QString().sprintf( "%c%02d%02d", sign, hours, minutes );
}

int PreferencesHelper::parseTimeZone( const QString& text )
{
    int zone = 0;
    if ( text.length() == 5 ) {
        int hours = text.mid( 1, 2 ).toInt();
        int minutes = text.mid( 3, 2 ).toInt();
        zone = ( hours * 60 + minutes ) * 60;
        if ( text.at( 0 ) == QLatin1Char( '-' ) )
            zone = -zone;
    }
    return zone;
}

bool PreferencesHelper::isValidEmail( const QString& email )
{
    QRegExp emailRegExp(
        "[a-zA-Z0-9_\\-\\.\\+\\^!#\\$%&*+\\/\\=\\?\\`\\|\\{\\}~\\']+" // user
        "@("
        "(?:(?:[a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.?)+" // domain
        "|(\\[("
        "[0-9]{1,3}(\\.[0-9]{1,3}){3}" // IPv4
        "|"
        "[0-9a-fA-F]{1,4}(\\:[0-9a-fA-F]{1,4}){7}" // IPv6
        ")\\]))" );

    return emailRegExp.exactMatch( email );
}
