/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef FOLDERWATCHWRITER_H
#define FOLDERWATCHWRITER_H

#include <QStringList>

#include "data/staterows.h"

/**
* Class for writing the watches dashboard in HTML format.
*
* This class is responsible for adding HTML markup and writing the watches
* dashboard into an HTML table.
*/
class FolderWatchWriter
{
public:
    /**
    * Default constructor.
    */
    FolderWatchWriter();

    /**
    * Destructor.
    */
    ~FolderWatchWriter();

public:
    /**
    * Begin the document.
    */
    void begin();

    /**
    * End the document.
    */
    void end();

    /**
    * Write a project header.
    */
    void writeProjectHeader( const QString& name );

    /**
    * Write a folder header.
    */
    void writeFolderHeader( const QString& name );

    /**
    * Write a table row with watch status.
    */
    void writeWatchRow( const QString& linkCell, const QString& totalCell, const QString& newCell, const QString& updatedCell );

    /**
    * Add HTML markup to a project or folder name.
    */
    QString name( const QString& text );

    /**
    * Format a cell with link to a folder watch.
    */
    QString linkCell( int folderId, const QString& watch, const QString& name );

    /**
    * Format a cell with watch status.
    */
    QString watchCell( const QString& text, WatchState state, int count );

    /**
    * Return the generated HTML table.
    */
    QString result() const;

private:
    QStringList m_lines;
};

#endif
