/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef SEARCHEDITBOX_H
#define SEARCHEDITBOX_H

#include <QLineEdit>

class QToolButton;

/**
* An edit box with a clear button.
*
* The clear button is only enabled if the text is not empty.
*/
class SearchEditBox : public QLineEdit
{
    Q_OBJECT
public:
    /**
    * Conctructor.
    *
    * @param parent The parent widget.
    */
    SearchEditBox( QWidget* parent );

    /**
    * Destructor.
    */
    ~SearchEditBox();

    /**
    * Set the text displayed when control is empty and has no focus.
    */
    void setPromptText( const QString& text );

    /**
    * Set the menu displayed when user clicks the options button.
    */
    void setOptionsMenu( QMenu* menu );

protected:
    void resizeEvent( QResizeEvent* e );

    void focusInEvent( QFocusEvent* e );
    void focusOutEvent( QFocusEvent* e );

    void paintEvent( QPaintEvent* e );

private slots:
    void updateCloseButton( const QString& text );

private:
    void showPrompt( bool on );

private:
    QToolButton* m_optionsButton;
    QToolButton* m_clearButton;

    bool m_showPrompt;
    QString m_promptText;
};

#endif
