/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "loginbatch.h"

#include "commands/command.h"
#include "commands/commandmanager.h"

LoginBatch::LoginBatch( const QString& login, const QString& password ) : AbstractBatch( 127 )
{
    Job job1( &LoginBatch::helloJob );
    m_queue.addJob( job1 );

    Job job2( &LoginBatch::loginJob );
    job2.addArg( login );
    job2.addArg( password );
    m_queue.addJob( job2 );

    Job job3( &LoginBatch::featuresJob );
    m_queue.addJob( job3 );
}

LoginBatch::~LoginBatch()
{
}

ConnectionInfo* LoginBatch::connectionInfo()
{
    if ( m_userId != 0 )
        return new ConnectionInfo( *this );
    return NULL;
}

Command* LoginBatch::fetchNext()
{
    if ( m_queue.moreJobs() )
        return m_queue.callJob( this );

    return NULL;
}

Command* LoginBatch::helloJob( const Job& /*job*/ )
{
    Command* command = new Command();

    command->setKeyword( "HELLO" );

    command->addRule( "SERVER ss", ReplyRule::One );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( helloReply( const Reply& ) ) );

    return command;
}

Command* LoginBatch::loginJob( const Job& job )
{
    Command* command = new Command();

    command->setKeyword( "LOGIN" );
    command->addArg( job.argString( 0 ) );
    command->addArg( job.argString( 1 ) );

    command->addRule( "USER ii", ReplyRule::One );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( loginReply( const Reply& ) ) );

    return command;
}

Command* LoginBatch::featuresJob( const Job& /*job*/ )
{
    if ( !checkVersion( "0.8.4" ) )
        return NULL;

    Command* command = new Command();

    command->setKeyword( "LIST FEATURES" );

    command->setAcceptNullReply( true );
    command->addRule( "F s", ReplyRule::ZeroOrMore );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( featuresReply( const Reply& ) ) );

    return command;
}

void LoginBatch::helloReply( const Reply& reply )
{
    ReplyLine line = reply.lines().at( 0 );

    m_serverName = line.argString( 0 );
    m_serverUuid = line.argString( 1 );

    m_serverVersion = commandManager->serverVersion();
}

void LoginBatch::loginReply( const Reply& reply )
{
    ReplyLine line = reply.lines().at( 0 );

    m_userId = line.argInt( 0 );
    m_access = (Access)line.argInt( 1 );
}

void LoginBatch::featuresReply( const Reply& reply )
{
    for ( int i = 0; i < reply.lines().count(); i++ )
        m_features.append( reply.lines().at( i ).argString( 0 ) );
}
