/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef LOGINBATCH_H
#define LOGINBATCH_H

#include "commands/abstractbatch.h"
#include "connectioninfo.h"
#include "batchjob.h"

class Reply;

/**
* Batch for logging in to the server.
*
* This batch sends a <tt>HELLO</tt> command for identifying the server
* and a <tt>LOGIN</tt> command for logging in as the given user.
*/
class LoginBatch : public AbstractBatch, private ConnectionInfo
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param login The user's login.
    *
    * @param password The user's password.
    */
    LoginBatch( const QString& login, const QString& password );

    /**
    * Destructor.
    */
    ~LoginBatch();

public:
    /**
    * Return the information about the server and the logged in user.
    *
    * @return A new ConnectionInfo object or @c NULL if logging in failed.
    */
    ConnectionInfo* connectionInfo();

public: // overrides
    Command* fetchNext();

private:
    typedef BatchJob<LoginBatch> Job;
    typedef BatchJobQueue<LoginBatch> JobQueue;

private:
    Command* helloJob( const Job& job );
    Command* loginJob( const Job& job );
    Command* featuresJob( const Job& job );

private slots:
    void helloReply( const Reply& reply );
    void loginReply( const Reply& reply );
    void featuresReply( const Reply& reply );

private:
    JobQueue m_queue;
};

#endif
