/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "notifydialog.h"

#include <QMessageBox>

#include "data/datamanager.h"
#include "data/notifybatch.h"
#include "iconloader.h"

NotifyDialog::NotifyDialog( QWidget* parent ) : CommandDialog( parent )
{
    setWindowTitle( tr( "Change Notification" ) );
    setPrompt( tr( "Changing the state of the notification" ) );
    setPromptPixmap( IconLoader::pixmap( "notify", 22 ) );

    setContentLayout( NULL, true );
}

NotifyDialog::~NotifyDialog()
{
}

bool NotifyDialog::notifyFolder( int folderId, bool notify )
{
    if ( notify && !checkPreferences( parentWidget() ) )
        return false;

    NotifyBatch* batch = new NotifyBatch();
    batch->notifyFolder( folderId, notify );

    executeBatch( batch );

    return true;
}

bool NotifyDialog::notifyIssue( int issueId, bool notify )
{
    if ( notify && !checkPreferences( parentWidget() ) )
        return false;

    NotifyBatch* batch = new NotifyBatch();
    batch->notifyIssue( issueId, notify );

    executeBatch( batch );

    return true;
}

void NotifyDialog::accept()
{
}

bool NotifyDialog::checkPreferences( QWidget* parent )
{
    const PreferencesData* preferences = dataManager->preferences();

    if ( preferences->value( "notify-frequency" ).isEmpty() ) {
        if ( QMessageBox::warning( parent, tr( "Warning" ),
            tr( "Notifications will not be sent until enable them in your preferences. Do you want to continue?" ),
            QMessageBox::Ok | QMessageBox::Cancel ) != QMessageBox::Ok )
                return false;
    } else if ( preferences->value( "email" ).isEmpty() ) {
        if ( QMessageBox::warning( parent, tr( "Warning" ),
            tr( "Notifications will not be sent until you enter an email address in your preferences. Do you want to continue?" ),
            QMessageBox::Ok | QMessageBox::Cancel ) != QMessageBox::Ok )
                return false;
    }

    return true;
}
