#!/usr/local/bin/perl
# Show all scheduled cluster copy jobs

require './cluster-copy-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", "intro", 0, 1);

@jobs = &list_copies();
if (@jobs) {
	print "<a href='edit.cgi?new=1'>$text{'index_add'}</a><br>\n";
	print &ui_columns_start([ $text{'index_files'},
				  $text{'index_servers'},
				  $text{'index_sched'},
				  $text{'index_act'} ], "100");
	foreach $j (@jobs) {
		@servers = map {
			$_ eq "*" ? $text{'edit_this'} :
			$_ =~ /^group_(.*)$/ ? &text('edit_group', "$1") : $_
				} split(/\s+/, $j->{'servers'});
		if (@servers > 3) {
			$servers = join(", ", @servers[0 .. 1]).", ".
                              &text('index_more', @servers-2);
			}
		else {
			$servers = join(", ", @servers);
			}
		@files = split(/\t+/, $j->{'files'});
		if (@files > 3) {
			$files = join(", ", @files[0 .. 1]).", ".
                              &text('index_more', @files-2);
			}
		else {
			$files = join(", ", @files);
			}
		print &ui_columns_row(
			[ "<a href='edit.cgi?id=$j->{'id'}'>$files</a>",
			  $servers,
			  $j->{'sched'} ?
				&text('index_when', &cron::when_text($j)) :
				$text{'no'},
			  "<a href='exec.cgi?id=$j->{'id'}'>$text{'index_exec'}</a>",
			]);
		}
	print &ui_columns_end();
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<a href='edit.cgi?new=1'>$text{'index_add'}</a><p>\n";

&ui_print_footer("/", $text{'index'});

