#!/usr/local/bin/perl
# list_mailers.cgi
# Display a list of mailertable domains

require './sendmail-lib.pl';
require './mailers-lib.pl';

$access{'mailers'} || &error($text{'mailers_cannot'});
&header($text{'mailers_title'}, "");
print "<hr>\n";

$conf = &get_sendmailcf();
$mfile = &mailers_file($conf);
($mdbm, $mdbmtype) = &mailers_dbm($conf);
if (!$mdbm) {
	# No Kmailertable directive in sendmail.cf
	print "<p><b>",&text('mailers_efeature', 'list_features.cgi'),"</b><p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
if (!-r $mfile) {
	# Text file not found
	print "<p><b>",&text('mailers_efile', "<tt>$mfile</tt>",
	      "<tt>$mdbm</tt>", "$gconfig{'webprefix'}/config.cgi?$module_name"),"</b> <p>\n";
	print "<b>",&text('virtusers_createfile',
		    	  'create_file.cgi?mode=mailers'),"</b><p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
@mailers = &list_mailers($mfile);

&mailer_form();
if (@mailers) {
	# sort if needed
	if ($config{'sort_mode'} == 1) {
		@mailers = sort { $a->{'domain'} cmp $b->{'domain'} } @mailers;
		}

	# render table of mailers
	$mid = int((@mailers+1)/2);
	print "<table width=100%> <tr><td width=50% valign=top>\n";
	&mailers_table(@mailers[0..$mid-1]);
	print "</td><td width=50% valign=top>\n";
	if ($mid < @mailers) { &mailers_table(@mailers[$mid..$#mailers]); }
	print "</td></tr> </table><br>\n";
	}
print "<a href='edit_file.cgi?mode=mailers'>",
	&text('file_edit', "<tt>$mfile</tt>"),"</a><p>\n"
	if ($access{'manual'});
print $text{'mailers_desc1'},"<p>\n";
print &text('mailers_desc2', 'list_cws.cgi')," ",
      &text('mailers_desc3', 'list_relay.cgi'),"<br>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

sub mailers_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'mailers_for'}</b></td> ",
      "<td><b>$text{'mailers_delivery'}</b></td> ",
      "<td><b>$text{'mailers_to'}</b></td> </tr>\n";
foreach $m (@_) {
	print "<tr $cb>\n";
	print "<td><a href=\"edit_mailer.cgi?num=$m->{'num'}\">",
	      &html_escape($m->{'domain'}),"</a></td>\n";
	$md = $mailer_desc{$m->{'mailer'}};
	print "<td>",$md ? $md : $m->{'mailer'},"</td>\n";
	print "<td>",&html_escape($m->{'dest'}),"</td> </tr>\n";
	}
print "</table>\n";
}

