# virtusers-lib.pl
# Functions for the virtusers table

# virtusers_dbm(&config)
# Returns the filename and type of the virtusers database, or undef if none
sub virtusers_dbm
{
foreach $f (&find_type("K", $_[0])) {
        if ($f->{'value'} =~ /^virtuser\s+(\S+)[^\/]+(\S+)$/) {
		return ($2, $1);
                }
	}
return undef;
}

# virtusers_file(&config)
# Returns the filename of the text virtusers file, or undef if none
sub virtusers_file
{
return &find_textfile($config{'virtusers_file'}, &virtusers_dbm($_[0]));
}

# list_virtusers(textfile)
sub list_virtusers
{
if (!defined(@list_virtusers_cache)) {
	@list_virtusers_cache = ( );
	local $lnum = 0;
	open(VIRT, $_[0]);
	while(<VIRT>) {
		s/\r|\n//g;     # remove newlines
		s/#.*$//g;	# remove comments
		if (/^(\S+)\s+(.*)/) {
			local(%virt);
			$virt{'from'} = $1;
			$virt{'to'} = $2;
			$virt{'line'} = $lnum;
			$virt{'file'} = $_[0];
			$virt{'num'} = scalar(@list_virtusers_cache);
			push(@list_virtusers_cache, \%virt);
			}
		$lnum++;
		}
	close(VIRT);
	}
return @list_virtusers_cache;
}

# create_virtuser(&details, textfile, dbmfile, dbmtype)
# Create a new virtuser mapping
sub create_virtuser
{
&list_virtusers($_[1]);	# force cache init
local(%virt);
local $lref = &read_file_lines($_[1]);
push(@$lref, "$_[0]->{'from'}\t$_[0]->{'to'}");
&flush_file_lines();
if ($_[3] eq "dbm") {
	dbmopen(%virt, $_[2], 0644);
	$virt{$_[0]->{'from'}} = $_[0]->{'to'};
	dbmclose(%virt);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }

$_[0]->{'line'} = @$lref-1;
$_[0]->{'num'} = scalar(@list_virtusers_cache);
push(@list_virtusers_cache, $_[0]);
}

# delete_virtuser(&details, textfile, dbmfile, dbmtype)
# Delete an existing virtuser mapping
sub delete_virtuser
{
local %virt;
local $lref = &read_file_lines($_[1]);
splice(@$lref, $_[0]->{'line'}, 1);
&flush_file_lines();
if ($_[3] eq "dbm") {
	dbmopen(%virt, $_[2], 0644);
	delete($virt{$_[0]->{'from'}});
	dbmclose(%virt);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }

local $idx = &indexof($_[0], @list_virtusers_cache);
splice(@list_virtusers_cache, $idx, 1) if ($idx != -1);
&renumber_list(\@list_virtusers_cache, $_[0], -1);
}

# modify_virtuser(&old, &details, textfile, dbmfile, dbmtype)
# Change an existing virtuser
sub modify_virtuser
{
local %virt;
local $lref = &read_file_lines($_[2]);
$lref->[$_[0]->{'line'}] = "$_[1]->{'from'}\t$_[1]->{'to'}";
&flush_file_lines();
if ($_[4] eq "dbm") {
	dbmopen(%virt, $_[3], 0644);
	delete($virt{$_[0]->{'from'}});
	$virt{$_[1]->{'from'}} = $_[1]->{'to'};
	dbmclose(%virt);
	}
else { &run_makemap($_[2], $_[3], $_[4]); }

local $idx = &indexof($_[0], @list_virtusers_cache);
$_[1]->{'line'} = $_[0]->{'line'};
$list_virtusers_cache[$idx] = $_[1] if ($idx != -1);
}

# virtuser_form([&details])
sub virtuser_form
{
local($v, $mode, $addr);
$v = $_[0];
print "<form action=save_virtuser.cgi>\n";
if ($_[0]) { print "<input type=hidden name=num value=$v->{'num'}>\n"; }
else { print "<input type=hidden name=new value=1>\n"; }
print "<table border>\n";
print "<tr $tb> <td><b>",$v ? $text{'vform_edit'} : $text{'vform_create'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

$addr = !$_[0] || $v->{'from'} =~ /^(\S+)\@(\S+)$/;
print "<tr> <td><b>$text{'vform_for'}</b></td>\n";
printf "<td><input type=radio name=from_type value=0 %s> %s</td>\n",
	$addr ? "checked" : "", $text{'vform_address'};
printf "<td><input name=from_addr size=20 value=\"%s\"></td> </tr>\n",
	$addr ? $v->{'from'} : "";
print "<tr> <td></td>\n";
printf "<td><input type=radio name=from_type value=1 %s> %s</td>\n",
	$addr ? "" : "checked", $text{'vform_domain'};
printf "<td><input name=from_dom size=15 value=\"%s\"></td> </tr>\n",
	$addr ? "" : substr($v->{'from'}, 1);

$mode = $v->{'to'} =~ /^error:(\S+)\s*(.*)$/ ? 0 :
	$v->{'to'} =~ /^\%1\@(\S+)$/ ? 1 :
	$v->{'to'} =~ /^(.*)$/ ? 2 : 2;
local $tt = "<b>$text{'vform_to'}</b>";
if ($access{'vedit_2'}) {
	print "<tr> <td>$tt</td>\n";
	printf "<td><input type=radio name=to_type value=2 %s> %s</td>\n",
		$mode == 2 ? "checked" : "", $text{'vform_address'};
	printf "<td><input name=to_addr size=20 value=\"%s\"></td> </tr>\n",
		$mode == 2 ? $1 : "";
	$tt = undef;
	}
if ($access{'vedit_1'}) {
	print "<tr> <td>$tt</td>\n";
	printf "<td><input type=radio name=to_type value=1 %s> %s</td>\n",
		$mode == 1 ? "checked" : "", $text{'vform_domain'};
	printf "<td><input name=to_dom size=15 value=\"%s\"></td> </tr>\n",
		$mode == 1 ? $1 : "";
	$tt = undef;
	}
if ($access{'vedit_0'}) {
	print "<tr> <td>$tt</td>\n";
	printf "<td><input type=radio name=to_type value=0 %s> %s</td>\n",
		$mode == 0 ? "checked" : "", $text{'vform_error'};
	print "<td><select name=to_code>\n";
	foreach $ecode ($text{'vform_err_nouser'}, $text{'vform_err_nohost'},
			$text{'vform_err_unav'}, $text{'vform_err_temp'},
			$text{'vform_err_proto'}) {
		printf "<option %s>$ecode\n", $1 eq $ecode ? "selected" : "";
		}
	print "</select> $text{'vform_msg'}\n";
	printf "<input name=to_error size=15 value=\"%s\"></td> </tr>\n",
		$mode == 0 ? $2 : "";
	$tt = undef;
	}

print "<tr> <td colspan=3 align=right>\n";
if ($_[0]) {
        print "<input type=submit value=\"$text{'save'}\">\n";
        print "<input type=submit name=delete value=\"$text{'delete'}\">\n";
        }
else { print "<input type=submit value=\"$text{'create'}\">\n"; }
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";
}

# virt_type(string)
# Return the type and destination of some virtuser target
sub virt_type
{
local @rv;
if ($_[0] =~ /^error:(.*)$/) {
	@rv = (0, $1);
	}
elsif ($_[0] =~ /^\%1\@(\S+)$/) {
	@rv = (1, $1);
	}
else {
	@rv = (2, $_[0]);
	}
return wantarray ? @rv : $rv[0];
}

1;

