#!/usr/local/bin/perl
# Delete a bunch of zones, after asking for confirmation

require './bind8-lib.pl';
&ReadParse();
$conf = &get_config();

# Get the zones
foreach $d (split(/\0/, $in{'d'})) {
	($idx, $viewidx) = split(/\s+/, $d);
	if ($viewidx ne '') {
		$view = $conf->[$viewidx];
		$zconf = $view->{'members'}->[$idx];
		}
	else {
		$zconf = $conf->[$idx];
		}
	&can_edit_zone($zconf, $view) ||
		&error($text{'master_edelete'});
	push(@zones, [ $zconf, $view ]);
	push(@znames, $zconf->{'value'});
	}
$access{'ro'} && &error($text{'master_ero'});
$access{'delete'} || &error($text{'master_edeletecannot'});

if (!$in{'confirm'}) {
	# Ask the user if he is sure
	&ui_print_header(undef, $text{'massdelete_title'}, "");

	print &ui_form_start("mass_delete.cgi", "post");
	foreach $d (split(/\0/, $in{'d'})) {
		print &ui_hidden("d", $d),"\n";
		}
	print "<center>",&text('massdelete_rusure', scalar(@zones),
			       join(", ", @znames)),"<p>\n";
	print &ui_submit($text{'massdelete_ok'}, "confirm"),"<p>\n";
	@servers = &list_slave_servers();
	if (@servers && $access{'remote'}) {
		print $text{'delete_onslave'},"\n";
		print &ui_yesno_radio("onslave", 1),"<br>\n";
		}
	print "</center>\n";
	print &ui_form_end();

	&ui_print_footer("", $text{'index_return'});
	}
else {
	# Do it!
	&ui_print_unbuffered_header(undef, $text{'massdelete_title'}, "");

	foreach $zi (@zones) {
		$zconf = $zi->[0];
		$view = $zi->[1];
		$type = &find_value("type", $zconf->{'members'});
		print &text('massdelete_zone', $zconf->{'value'}),"<br>\n";

		# delete the records file
		$f = &find("file", $zconf->{'members'});
		if ($f && $type ne 'hint') {
			&lock_file(&make_chroot(&absolute_path($f->{'value'})));
			unlink(&make_chroot(&absolute_path($f->{'value'})));
			}

		# remove the zone directive
		&lock_file(&make_chroot($zconf->{'file'}));
		&save_directive($view || &get_config_parent($zconf->{'file'}),
				[ $zconf ], [ ]);
		print $text{'massdelete_done'},"<p>\n";

		# Also delete from slave servers
		if ($in{'onslave'} && $access{'remote'}) {
			print &text('massdelete_slaves',
				    $zconf->{'value'}),"<br>\n";
			@slaveerrs = &delete_on_slaves($zconf->{'value'});
			if (@slaveerrs) {
				print $text{'massdelete_failed'},"<br>\n";
				foreach $s (@slaveerrs) {
					print "$s->[0]->{'host'} : $s->[1]<br>\n";
					}
				print "<p>\n";
				}
			else {
				print $text{'massdelete_done'},"<p>\n";
				}
			}
		}
	&flush_file_lines();
	&unlock_all_files();

	&ui_print_footer("", $text{'index_return'});
	}

