#!/usr/bin/perl -w
#
# $Id: Config.pm 2921 2005-02-18 23:18:43Z andreas $
#

package DebianEdu::Webmin::Config;

use strict;

use vars qw(%config %gconfig $module_name $module_config_directory $tb $cb
  $scriptname $remote_user $base_remote_user $current_theme $root_directory
  $module_root_directory %module_info);

BEGIN {

    use Exporter   ();
    our ($VERSION, @ISA, @EXPORT, @EXPORT_OK, %EXPORT_TAGS);
    
    # if using RCS/CVS, this may be preferred
    $VERSION = sprintf "%d.%03d", q$Revision: 1.1 $ =~ /(\d+)/g;
    
    @ISA         = qw(Exporter);

    require '/usr/share/webmin/web-lib.pl';

    init_config();                              # fills in %config
    read_file( "/etc/adduser.conf", \%config ); # puts adduser config into %config
    get_miniserv_config( \%config );            # pulls in miniserv config 
                                                #       for cookie settings

    @EXPORT = qw(%config %gconfig %text $module_config_directory
		    $module_name $tb $cb $scriptname $remote_user
		    $base_remote_user $current_theme $root_directory
		    $module_root_directory %module_info
		    get_webmin_version get_system_hostname text unique);


}



1;

