#!/usr/bin/perl -w
#
# $Id: Exam.pm 2921 2005-02-18 23:18:43Z andreas $
#

package DebianEdu::Exam;

use strict;
use Carp;
use DebianEdu::Webmin::Config; # gives me %config

require '/usr/share/webmin/ldap-users/ldap-users.pl';

sub new {
    my $class           = shift;
    my $exam_users_file = shift || croak "no file with users specified"; 
    my $passwd          = shift || croak "no user given to bind to ldap with $!";
    my $user            = shift || "root";
    my $exam_dir        = shift || "/skole/tjener/exam";
    my $common_group    = shift || "everyone";
    my $exam_group      = shift || "exam";
    

    my @exam_users      = parse_file($exam_users_file);
    
    my %priv_dat = ( users        => \@exam_users,
		     exam_dir     => $exam_dir,
		     common_group => $common_group,
		     exam_group   => $exam_group,
		     user         => $user,
		     passwd       => $passwd,
		     );
    my $obj = bless \%priv_dat, $class;


    # this must go into the ldap-user.pm and be run automatically at module load
    ldap_connect(             # Connect to the ldap server.
        $config{'server'}, $user, $passwd,
        $config{'basedn'}, $config{'FIRST_UID'} || 10000,
        $config{'LAST_UID'} || 29999,
    );

}


sub move_to {
    my $self  = shift;
    my @users = @{$self->{users}};   
    
    for my $user ( @users ) {
	if ( exam_dir_exists( $user ) ) {
	    croak "User $user already has a home directory in /skole/tjener/exam/$user";
	    goto error_exit;
	}
#	if ldap_
    }
    
  error_exit:
    return; # return the error message somehow.
}

sub move_from {
    
}

sub exam_dir_exists {
    my ( $self, $user ) = @_;
    my $exam_dir = $self->{exam_dir};

    return "exists" if (-d "$exam_dir/$user" );
    return undef;
}

# reads the "users" file 
sub parse_file {
    
    unless ( -f $exam_users_file ) {
	croak "file $exam_users_file not found!"; 
    }
    
    open USERS,   "<  $exam_users_file"  or 
	croak "can't open $exam_users_file: $!";
    
    my $INPUT_RECORD_SEPARATOR_orig = $INPUT_RECORD_SEPARATOR;
    $INPUT_RECORD_SEPARATOR = undef;
    my $whole_file =  <USERS>; # sluuuurp
    $INPUT_RECORD_SEPARATOR = $INPUT_RECORD_SEPARATOR_orig;

    close USERS;

    my @users = split(/\s/, $whole_file);
    
    return @users;
}


1;  
