#!/usr/bin/perl -w

package DB;

use strict;
use DBD::SQLite;
use Net::LDAP::LDIF;

use Data::Dumper;

sub new {
    my $class      = shift;
    my $path       = shift || "../";
    my $db_file    = shift || "testdb.db";
    my $sql_struct = shift || "testdb-struct.sql";
    my $sql_data   = shift || "testdb-data.sql";
    my $run_init   = "1" unless ( -e "$path$db_file" );
    my $dbh        = DBI->connect("dbi:SQLite:dbname=$path$db_file",
				  "username",
				  "password", 
				  {RaiseError => 0} ) 
	|| die "Database connection not made: $DBI::errstr\n";
    my %priv_dat = ( handle     => $dbh,
		     path       => $path,
		     sql_struct => $sql_struct,
		     sql_data   => $sql_data,);
    my $obj = bless \%priv_dat, $class;
    if ($run_init) {
	print STDERR "init\n";
	$obj->init(); 
    }
    return $obj;
}


sub init { 
    my $self = shift;
    my $h    = $self->{handle};

    for my $file ( "$self->{path}$self->{sql_struct}", 
		   "$self->{path}$self->{sql_data}" ) {
	read_sql_file($h, $file);
    }
    
#    my $ary_ref  = $h->selectall_arrayref("select * from e_group_type;" );
#    print STDERR Dumper $ary_ref;
}

sub add {
    my ($self, $hash_ref ) = @_;
    my $h    = $self->{handle};
    my %data = %$hash_ref;

    if ( $data{login} ) { # we got some user data
	my $col = "u_login";
	my $val = "\'$data{login}\'";
	if ( $data{name} ) {
	    $col .= ",u_name";
	    $val .= ",\'$data{name}\'";
	}
	my $sql = "INSERT INTO e_user ($col) VALUES ($val);";
	$h->do( $sql) || die "Could not add: $DBI::errstr\n";
	if ( $data{password} ) {
	    $sql = "INSERT INTO e_password (p_uid,p_pwd) 
                    VALUES ((SELECT u_id FROM e_user WHERE u_login=\'$data{login}\'),
                             \'$data{password}\');";
#	    print STDERR "$sql\n";
	    $h->do( $sql) || die "Could not add: $DBI::errstr\n";
	}
    } 
    elsif ( $data{type} and $data{name} ) { # add a group
 	my $sql = "INSERT INTO e_group (g_name,g_type) 
                   VALUES (\'$data{name}\',
                          (SELECT t_id FROM e_group_type WHERE t_name = \'$data{type}\'));";
	$h->do( $sql) || die "Could not add: $DBI::errstr\n";

	#
	# does the group have members?
	#
	if ( $data{members} ) {
	    my $prep_h = $h->prepare("INSERT INTO r_is_group_member (m_uid,m_gid) 
                                      VALUES ((SELECT u_id FROM e_user WHERE u_login=?),
                                              (SELECT g_id FROM e_group where g_name=\'$data{name}\'));"); 
	    for my $member ( @{$data{members}} ) {
		$h->execute($member) 
		    || die "Could not add group member: $DBI::errstr\n";
	    }
	}
    }
}

sub del { 
    my ($self, $name, $mode) = @_;
    my $h    = $self->{handle};
    # because groups and users cant have the same name/login
    # (because of user-private groups) the name 
    # of an entry is enough to describe it fully.
    # No need to specify if it is a group or user.
        
    my $row_href = $h->selectrow_hashref("SELECT 'group' AS user_or_group, g_id AS id 
                                          FROM e_group WHERE g_name=\'$name\' 
                                    UNION SELECT 'user' AS  user_or_group, u_id AS id 
                                          FROM e_user WHERE u_login=\'$name\';")
	|| die "No such user or group $name: $DBI::errstr\n";

    my %row = %$row_href;
    return;
    if ($row{user_or_group} eq "user") {
	$h->do("DELETE FROM e_user 
                WHERE u_id = $row{id};");
	$h->do("DELETE FROM r_is_group_member 
                WHERE m_uid = $row{id};");
    }
    elsif ($row{user_or_group} eq "group") {
	$h->do("DELETE FROM e_user 
                WHERE u_id IN 
               (SELECT m_uid FROM r_is_group_member 
                WHERE m_gid = $row{id});") 
	    if ($mode and $mode eq "with users");
	$h->do("DELETE FROM e_group 
                WHERE g_id =  $row{id};");
	$h->do("DELETE FROM r_is_group_member 
                WHERE m_gid = $row{id};");
    }
    else {
	print STDERR "no such group or user: $name\n";
    }    
}


sub mod {
    my ($self, $name, $data_href )= @_;
    my $h    = $self->{handle};
    my %data = %$data_href;


    # are we operating on a group or a user? the $name tells us.
    my $row_href = $h->selectrow_hashref("SELECT 'group' AS user_or_group, g_id AS id 
                                          FROM e_group WHERE g_name=\'$name\' 
                                    UNION SELECT 'user' AS  user_or_group, u_id AS id 
                                          FROM e_user WHERE u_login=\'$name\';")
	|| die "No such user or group $name: $DBI::errstr\n";

    my %row = %$row_href;
    
    if ($row{user_or_group} eq "user") {
	# we modify a user
	# modifieable attributes about a user are u_name and p_pwd
	$h->do("UPDATE e_user set u_name = $data{name} 
                WHERE u_id = $row{id};") 
	    if $data{name};
	if( $data{password} ) {
	    # perhaps the password for this user was not even known before
	    $h->do("DELETE FROM e_password 
                    WHERE p_uid = $row{id};"); 
	    $h->do("INSERT INTO e_password (p_uid,p_pwd) 
                    VALUES ($row{id},\'$data{password}\');");
	}
    }
    if ($row{user_or_group} eq "group") {
	# we modify a group
	# only group membership can be changed
	if ($data{del}) {
	    my $sth = $h->prepare("DELETE FROM r_is_group_member 
                                   WHERE m_gid = $row{id} and m_uid = 
                                 ( SELECT u_id FROM e_user 
                                   WHERE u_login = ? );");
	    for my $member ( @{ $data{del} } ) {
		next unless $member;
		$sth->execute($member)
		    || die "Could not remove group member: $DBI::errstr\n";
	    }
	}
	if ($data{add}) {
	    my$sth = $h->prepare("INSERT INTO r_is_group_member (m_uid,m_gid) 
                                  VALUES ( (SELECT u_id FROM e_user 
                                            WHERE u_login=? ),
                                            $row{id} );"); 
	    for my $member ( @{$data{members}} ) {
		$h->execute($member) 
		    || die "Could not add group member: $DBI::errstr\n";
	    }
	}
    }
    else {
	print STDERR "no such group or user: $name\n";
    }    
}


# to be called like ->depends( user     => undef, # we want a user, not a group, 
#                                                 # name does not matter
#                              password => undef, # password must be there, 
#                                                 # but content does not matter
#                              groups   => [ teachers, football ] # member in these groups
#                              );
# or                ->depends( group    => school_class, # we want a group, not a user
#                              users_count  => 3, # hm, should it also understand 
#    #not implemented now:     users  => [ klaus, hinnack, lotte ]?
#                              users_count_min => 3,
#                              )


# FIXME: provide not only one but N data sets as returns.
sub depends {
    my ($self, $deps_href) = @_;
    my $h    = $self->{handle};
    my %deps = %$deps_href;
    

    my ($num, @conditions, $sql) = (" ");
    if ( exists $deps{user} ) {
	 $sql = "SELECT u_name AS 'name',u_login AS 'user',p_pwd AS 'password'
                 FROM            e_user            AS u 
                 LEFT OUTER JOIN r_is_group_member AS m ON u.u_id = m.m_uid 
                 LEFT OUTER JOIN e_group           AS g ON g.g_id = m.m_gid
                 LEFT OUTER JOIN e_group_type      AS t ON t.t_id = g.g_type
                 LEFT OUTER JOIN e_password        AS p ON u.u_id = p.p_uid ";

	#
        # check for specific or generic user
	#
	if ( $deps{user} ) { # some specific user is wanted.
	    $deps{user} =~ s/\*/%/g;
	    push @conditions, "u_login LIKE \'$deps{user}\'";
	}
	elsif ( exists $deps{user} ) { # user can be 
	    push @conditions, "u_login IS NOT NULL"; # this is not really valuable info..
	}
	
	#
	# user with known password?
	#
	if( $deps{password}) {
	    # now who would want to query for a specific password?!?
	    $deps{password} =~ s/\*/%/g;
	    push @conditions, "p_pwd LIKE \'$deps{password}\'";
	}
	elsif ( exists $deps{password} ){
	    push @conditions, "p_pwd IS NOT NULL"; 
	}   
	
	#
	# find combinations of group names
	#
	if( $deps{groups} ) {
	    my @groups;
	    for my $group ( @{ $deps{groups} } ){
		$group =~ s/\*/%/g;
		push @groups, "g_name LIKE \'$group\'";		
	    }
	    my $group_cond = "(" . join(" OR ", @groups) . ")";
	    push @conditions, $group_cond;
	}
	elsif ( exists $deps{groups} ){
	    push @conditions, "g_name IS NOT NULL"; 
	}   	
    } # end of "if ($deps{user})"
 
    elsif (exists $deps{group}) {
	$sql = "SELECT g_name AS 'group', t_name AS 'type',u_login AS 'user' 
                FROM            e_group           AS g
                LEFT OUTER JOIN r_is_group_member AS m ON g.g_id = m.m_gid 
                LEFT OUTER JOIN e_user            AS u ON u.u_id = m.m_uid
                LEFT OUTER JOIN e_group_type      AS t ON t.t_id = g.g_type
                LEFT OUTER JOIN e_password        AS p ON u.u_id = p.p_uid ";
	
        #
        # check for specific or generic group
	#
	if ( $deps{group} ) { # some specific group is wanted.
	    $deps{group} =~ s/\*/%/g;
	    push @conditions, "g_name LIKE \'$deps{group}\' ";
	}
	elsif ( exists $deps{group} ) { # user can be 
	    push @conditions, "g_name IS NOT NULL"; # this is not really valuable info..
	}
	
        #
        # check for specific or generic user
	#
	if( $deps{users}) {
	    my @users;
	    for my $user ( @{ $deps{users} } ){
		$user =~ s/\*/%/g;
		push @users, "u_login LIKE \'$user\'";		
	    }
	    my $user_cond = "(" . join(" OR ", @users) . ")";
	    push @conditions, $user_cond;
	}
	elsif ( exists $deps{users} ){
	    push @conditions, "u_login IS NOT NULL"; 
	}   	

        #
        # check for numers of users
 	#
	if ( exists $deps{users_count} ) { # number of users in group
	    $num = "GROUP BY m_gid HAVING 
                    COUNT(m_uid) = $deps{users_count}";
	}
	elsif ( exists $deps{users_min_count} and exists $deps{users_max_count} ) {  
	    $num = "GROUP BY m_gid HAVING 
                    COUNT(m_uid) >= $deps{users_min_count}
                    AND
                    COUNT(m_uid) <= $deps{users_max_count}";
	}
	elsif ( exists $deps{users_min_count} ) {
	    $num = "GROUP BY m_gid HAVING 
                    COUNT(m_uid) >= $deps{users_min_count}";
	}
	elsif ( exists $deps{users_max_count} ) {
	    $num = "GROUP BY m_gid HAVING 
                    COUNT(m_uid) <= $deps{users_max_count}";
	} 
     }
    else {
	die "unknown type of dependency!" . Dumper \%deps . "\n";
    }
    $sql .= "WHERE " .join(" AND ", @conditions) . " $num;" if @conditions;
#    print STDERR "$sql\n";
    return $h->selectrow_hashref($sql);
}

sub populate {
    my ($self, $file) = @_;
    my $h    = $self->{handle};

    my @groups;

    # prepare queries
    
    # insert groups
    my $gh = $h->prepare("INSERT INTO e_group (g_type,g_name) VALUES ((SELECT t_id FROM e_group_type WHERE t_name=?),?);");
    # insert members
    my $mh = $h->prepare("INSERT INTO r_is_group_member (m_uid,m_gid) VALUES ((SELECT u_id FROM e_user WHERE u_login=?),(SELECT g_id FROM e_group WHERE g_name=?));"); 
    # insert users
    my $uh = $h->prepare("INSERT INTO e_user (u_login,u_name) VALUES (?,?);");

    # reads in ldifs
    my $ldif = Net::LDAP::LDIF->new($file, "r") or die $!;
    while ( !$ldif->eof ) {
	my $entry = $ldif->read_entry();
	
	if ($ldif->error()) { # skip entry in case of error
	    print "Error msd: ", $ldif->error() . "\n";
	    print "Error lines:\n", $ldif->error_lines(),"\n";
	    next;
	}
	
	# deal only with users and groups
	my $type = $entry->get_value("grouptype");
	if ($type and $type ne "private") {
	    # only store the groups for now, untill we added all users
	    push @groups, $entry;
	}
	if ( $entry->get_value("mailmessagestore")) { # i dont want the machine accounts
	    # we have a user account
	    my $dn = $entry->dn();
	    next if ($dn =~ /,ou=Attic,/);  # no deleted users
	    $uh->execute($entry->get_value("uid"), $entry->get_value("cn"));
	}
    }
    $ldif->done();
    for my $entry ( @groups ) {
	my $group_name = $entry->get_value("cn");
	$gh->execute( $entry->get_value("grouptype"),$group_name);
	my @members = $entry->get_value("memberUid");
	for my $member ( @members) {
	    $mh->execute( $member, $group_name) || print STDERR "$member, $group_name\n";
	}
    }
}

sub end {
    my $self = shift;
    my $h    = $self->{handle};
    $h->disconnect;
}

sub read_sql_file {
    my ($h, $file) = @_;
    
    open SQL,   "<  $file"  or die "can't open $file: $!";

    my $seperator = $/; # save the seperator since it is non-standard
    undef $/;
    my $whole_file =  <SQL>; # sluuuurp
    $whole_file =~ s/\n(?!\n)\s+/ /g; # merge logical lines
    $/= $seperator; # restore the original line seperator;

    my @whole_file = split (/\n/, $whole_file);


    while ( @whole_file ) {
	$_ = shift @whole_file;
	chomp;
	s/\#.*//;
	s/^\s+//;
	s/\s+$//;
	next unless length;
	print STDERR "$_\n";
	$h->do($_);
    }
    
    close SQL;
}

1;
