#!/usr/local/bin/perl
# reconfig_form.cgi
# Displays a list of supported modules, and allows the user to pick which
# ones are installed in apache

require './apache-lib.pl';
&ReadParse();
$access{'global'}==1 || &error($text{'reconfig_ecannot'});
if ($in{'vol'}) {
	&header($text{'reconfig_title'}, "");
	}
else {
	&header($text{'reconfig_title'}, "", undef, 1, 1);
	}
print "<hr>\n";

# build list of modules compiled into apache
($ver, $mods) = &httpd_info($httpd = &find_httpd());
if (!$ver) {
	print &text('reconfig_ever', "<tt>$httpd</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
foreach $m (@$mods) {
	if (-r "$m.pl") { $inst{$m}++; }
	}

# build list of dynamically loaded modules
$conf = &get_config();
foreach $l (&find_directive_struct("LoadModule", $conf)) {
	if ($l->{'words'}->[1] =~ /(mod_\S+)\.(so|dll)/ && -r "$1.pl") {
		$inst{$1}++;
		}
	# nodo50 v0.1 - Change 000002 - Bug fixed: Apache-ssl module detected as mod_ssl. Now Apache-ssl module included as mod_apachessl
	# nodo50 v0.1 - Change 000002 - Bug corregido: El modulo Apache-ssl se detecta como mod_ssl. Ahora Apache-ssl se incluye como mod_apachessl
	# Add apache-ssl libssl.so as mod_apachessl module
	elsif ($l->{'words'}->[1] =~ /libssl\.so/ &&
	       -r "mod_apachessl.pl") {
		$inst{"mod_apachessl"}++;
		}
	# Add others lib* like as mod_ modules
	# nodo50 v0.1 - Change 000002 - End
	elsif ($l->{'words'}->[1] =~ /lib([^\/\s]+)\.(so|dll)/ &&
	       -r "mod_$1.pl") {
		$inst{"mod_$1"}++;
		}
	}

# build list of supported modules
push(@mods, "core");
opendir(DIR, ".");
foreach $f (readdir(DIR)) {
	if ($f =~ /^(mod_\S+|prefork|worker|perchild|mpm_\S+)\.pl$/) { push(@mods, $1); }
	}
closedir(DIR);
@mods = sort { $a cmp $b } @mods;

if (!$in{'vol'}) {
	print "$text{'reconfig_desc1'}<p>\n";
	print "$text{'reconfig_desc3'}\n";
	}
else {
	print "$text{'reconfig_desc2'}\n";;
	}
print "<p> <form action=reconfig.cgi>\n";
print "<input type=hidden name=size value=$in{'size'}>\n";
print "<input type=hidden name=ver value=\"$ver\">\n";
print "<table width=100%>\n";
for($i=0; $i<@mods; $i++) {
	if ($i%4 == 0) { print "<tr>\n"; }
	print "<td><input type=checkbox name=mods value=$mods[$i] ",
	      ($inst{$mods[$i]} ? "checked" : ""),"> $mods[$i]</td>\n";
	if ($i%4 == 3) { print "</tr>\n"; }
	}
print "</table>\n";
print "<input type=submit value=\"$text{'reconfig_ok'}\"></form>\n";

print "<hr>\n";
if ($in{'vol'}) { &footer("", $text{'index_return'}); }
else { &footer("/", $text{'index'}); }

