#!/usr/local/bin/perl
# restart.cgi
# Send a SIGHUP to apache

require './apache-lib.pl';
&ReadParse();
&error_setup($text{'restart_err'});

$access{'apply'} || &error($text{'restart_ecannot'});
$conf = &get_config();
$pidfile = &get_pid_file();

if ($config{'test_config'}) {
	$err = &test_config();
	&error("<pre>$err</pre>") if ($err);
	}
if ($config{'apply_cmd'}) {
	# use the configured start command
	$out = &backquote_logged("($config{'apply_cmd'}) 2>&1");
	if ($?) {
		&error("<pre>$out</pre>");
		}
	}
elsif (-x $config{'apachectl_path'}) {
	# use apachectl to restart
	if ($httpd_modules{'core'} >= 2) {
		# Do a graceful restart
		$out = &backquote_logged("$config{'apachectl_path'} graceful 2>&1");
		if ($?) {
			&error("<pre>$out</pre>");
			}
		}
	else {
		$out = &backquote_logged("$config{'apachectl_path'} restart 2>&1");
		if ($out !~ /httpd restarted/) {
			&error("<pre>$out</pre>");
			}
		}
	}
else {
	# send SIGHUP directly
	open(PID, $pidfile) || &error(&text('restart_epid', $pidfile));
	<PID> =~ /(\d+)/ || &error(&text('restart_epid2', $pidfile));
	close(PID);
	&kill_logged('HUP', $1) || &error(&text('restart_esig', $1));
	}

# Check if restart was successful.. some config file error may have caused it
# to silently fail
sleep(1);
if (!open(PID, $pidfile) || <PID> !~ /(\d+)/ || !kill(0, $1)) {
	# Not running..  find out why
	$errorlogstr = &find_directive_struct("ErrorLog", $conf);
	$errorlog = $errorlogstr ? $errorlogstr->{'words'}->[0]
				 : "logs/error_log";
	if ($errorlog eq 'syslog' || $errorlog =~ /^\|/) {
		&error($text{'restart_eunknown'});
		}
	else {
		$errorlog = &server_root($errorlog, $conf);
		$out = `tail -5 $errorlog`;
		&error("<pre>$out</pre>");
		}
	}
&webmin_log("apply");
&redirect($in{'redir'});

