#!/usr/local/bin/perl
# backup.pl
# Called by cron to backup a database

$no_acl_check++;
require './mysql-lib.pl';

$db = $ARGV[0];
$db || die "Missing database parameter";
$file = &date_subs($config{'backup_'.$db});
if (!$file) {
	print STDERR "No backup file set for database $db\n";
	exit(1);
	}
$drop = $config{'backup_drop_'.$db} ? "--add-drop-table" : "";
$where = $config{'backup_where_'.$db} ?
	"\"--where=".$config{'backup_where_'.$db}."\"" : "";
if (&supports_quoting()) {
	$quoting = " --quote-names";
	}

&execute_before($db, STDOUT, 0, $file);
unlink($file);
$out = &backquote_logged("$config{'mysqldump'} $authstr $drop $where $quoting ".quotemeta($db)." 2>&1 >$file");
if ($? || $out) {
	print "Backup of database $db to file $file failed:\n";
	print $out;
	$ex = 1;
	}
else {
	$ex = 0;
	}
&execute_after($db, STDOUT, 0, $file);
exit($ex);

