#!/usr/local/bin/perl
# backup_form.cgi
# Display a form for backing up this database

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
$access{'edonly'} && &error($text{'dbase_ecannot'});
$access{'buser'} || &error($text{'dbase_ecannot'});
&header($text{'backup_title'}, "", "backup_form");
print "<hr>\n";

if (!-x $config{'mysqldump'}) {
	print "<p>",&text('backup_edump', "<tt>$config{'mysqldump'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'});
	exit;
	}

$cron = !$module_info{'usermin'} && $access{'buser'} eq 'root' &&
	!$access{'user'} && &foreign_installed("cron");
print &text('backup_desc', "<tt>$in{'db'}</tt>"),"\n";
if ($cron) {
	print "$text{'backup_desc2'}\n";
	}
print "<p>\n";
%c = $module_info{'usermin'} ? %userconfig : %config;

print "<form action=backup_db.cgi>\n";
print "<input type=hidden name=db value='$in{'db'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'backup_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'backup_file'}</td>\n";
printf "<td><input name=file size=40 value='%s'> %s</td> </tr>\n",
	$c{'backup_'.$in{'db'}}, &file_chooser_button("file");

$w = $c{'backup_where_'.$in{'db'}};
print "<tr> <td><b>$text{'backup_where'}</b></td>\n";
printf "<td><input type=radio name=where_def value=1 %s> %s\n",
	$w ? "" : "checked", $text{'backup_none'};
printf "<input type=radio name=where_def value=0 %s>\n",
	$w ? "checked" : "";
printf "<input name=where size=30 value='%s'></td> </tr>\n", $w;

$d = $c{'backup_drop_'.$in{'db'}};
print "<tr> <td><b>$text{'backup_drop'}</b></td>\n";
printf "<td><input type=radio name=drop value=1 %s> %s\n",
	$d ? "checked" : "", $text{'yes'};
printf "<input type=radio name=drop value=0 %s> %s</td> </tr>\n",
	$d ? "" : "checked", $text{'no'};

if ($cron) {
	$b = $c{'backup_before_'.$in{'db'}};
	print "<tr> <td><b>$text{'backup_before'}</b></td>\n";
	printf "<td><input name=before size=50 value='%s'></td> </tr>\n", $b;

	$a = $c{'backup_after_'.$in{'db'}};
	print "<tr> <td><b>$text{'backup_after'}</b></td>\n";
	printf "<td><input name=after size=50 value='%s'></td> </tr>\n", $a;

	&foreign_require("cron", "cron-lib.pl");
	@jobs = &cron::list_cron_jobs();
	($job) = grep { $_->{'command'} eq "$cron_cmd $in{'db'}" } @jobs;

	print "<tr> <td><b>$text{'backup_sched'}</b></td>\n";
	printf "<td><input type=radio name=sched value=0 %s> %s\n",
		$job ? "" : "checked", $text{'no'};
	printf "<input type=radio name=sched value=1 %s> %s</td> </tr>\n",
		$job ? "checked" : "", $text{'backup_sched1'};

	print "<tr> <td colspan=2><table border width=100%>\n";
	$job ||= { 'mins' => 0,
		   'hours' => 0,
		   'days' => '*',
		   'months' => '*',
		   'weekdays' => '*' };
	&cron::show_times_input($job);
	print "</table></td> </tr>\n";
	}

print "<tr> <td colspan=2 align=right>\n";
if ($cron) {
	print "<input type=submit name=backup value='$text{'backup_ok1'}'>\n";
	print "<input type=submit name=save value='$text{'backup_ok2'}'>\n";
	}
else {
	print "<input type=submit name=backup value='$text{'backup_ok'}'>\n";
	}
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";

print "<hr>\n";
&footer("edit_dbase.cgi?db=$in{'db'}", $text{'dbase_return'},
	"", $text{'index_return'});

