#!/usr/local/bin/perl
# download.cgi
# Output the contents of a blob field

require './mysql-lib.pl';
&ReadParse();
&can_edit_db($in{'db'}) || &error($text{'dbase_ecannot'});
@str = &table_structure($in{'db'}, $in{'table'});

# Get the rows in question
if ($in{'field'}) {
	$search = "where ".&quotestr($in{'field'})." ".
		($in{'match'} == 0 ? "like \"%$in{'for'}%\"" :
		 $in{'match'} == 1 ? "like \"$in{'for'}\"" :
		 $in{'match'} == 2 ? "not like \"%$in{'for'}%\"" :
		 $in{'match'} == 3 ? "not like \"$in{'for'}\"" : " = \"\"");
	}
$d = &execute_sql($in{'db'},
	"select * from ".&quotestr($in{'table'})." $search limit ".
	$in{'start'}.",".$config{'perpage'});

# Work out the MIME type based on the data
$data = $d->{'data'}->[$in{'row'}]->[$in{'col'}];
if ($data =~ /^\s*(<!doctype|<html|<head|<title)/i) {
	$type = "text/html";
	}
elsif ($data =~ /^GIF89/) {
	$type = "image/gif";
	}
elsif ($data =~ /^\377\330\377\340/) {
	$type = "image/jpeg";
	}
elsif ($data =~ /^%PDF/) {
	$type = "application/pdf";
	}
elsif ($data =~ /^[\040-\176\r\n\t]+$/) {
	$type = "text/plain";
	}
else {
	$type = "application/octet-stream";
	}
print "Content-type: $type\n\n";
print $data;

