#!/usr/local/bin/perl
# group_filesys.cgi
# List all filesystems for which some group has quotas

require './quota-lib.pl';
&ReadParse();
$u = $in{'group'};
&can_edit_group($u) ||
	&error(&text('gfilesys_ecannot', $u));
&header($text{'gfilesys_title'}, "", "group_filesys");
print "<hr>\n";

foreach $f (&list_filesystems()) {
	if ($f->[4] > 1 && $f->[5] && &can_edit_filesys($f->[0])) {
		push(@fslist, $f->[0]);
		$fslist{$f->[0]}++;
		}
	}

# Make sure all block sizes are the same
$n = &group_filesystems($u);
for($i=0; $i<$n; $i++) {
	$bsize = &block_size($filesys{$i,'filesys'});
	if ($last_bsize && $last_bsize != $bsize) {
		$variable_bsize++;
		}
	}

if ($n) {
	print "<h3>",&text('gfilesys_all', &html_escape($u)),"</h3>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td></td>\n";
	if (!$variable_bsize) {
		print "<td colspan=3 align=center><b>$text{'gfilesys_kbs'}</b></td>\n";
		}
	else {
		print "<td colspan=3 align=center><b>$text{'gfilesys_blocks'}</b></td>\n";
		}
	print "<td colspan=3 align=center><b>$text{'gfilesys_files'}</b></td> </tr>\n";
	print "<tr $tb> <td><b>$text{'gfilesys_fs'}</b></td>\n";
	print "<td><b>$text{'gfilesys_used'}</b></td> <td><b>$text{'gfilesys_soft'}</b></td>\n";
	print "<td><b>$text{'gfilesys_hard'}</b></td>\n";
	print "<td><b>$text{'gfilesys_used'}</b></td> <td><b>$text{'gfilesys_soft'}</b></td>\n";
	print "<td><b>$text{'gfilesys_hard'}</b></td> </tr>\n";
	for($i=0; $i<$n; $i++) {
		$f = $filesys{$i,'filesys'};
		$bsize = &block_size($f);
		print "<tr $cb>\n";
		if ($fslist{$f} && !$access{'ro'}) {
			print "<td><a href=\"edit_group_quota.cgi?filesys=$f&group=$u&source=1\">$f</a></td>\n";
			}
		else { print "<td>$f</td>\n"; }
		if ($bsize) {
			print "<td>",int($filesys{$i,'ublocks'}*$bsize/1024),"</td>\n";
			}
		else {
			print "<td>$filesys{$i,'ublocks'}</td>\n";
			}
		&print_limit($filesys{$i,'sblocks'});
		&print_limit($filesys{$i,'hblocks'});
		print "<td>$filesys{$i,'ufiles'}</td>\n";
		&print_limit($filesys{$i,'sfiles'});
		&print_limit($filesys{$i,'hfiles'});
		print "</tr>\n";
		}
	print "</table><br>\n";
	}
else {
	print "<b>",&text('gfilesys_nogquota', $u),"</b><br>\n";
	}

if (!$access{'ro'}) {
	print "<table width=100%><tr>\n";
	print "<form action=edit_group_quota.cgi>\n";
	print "<input type=hidden name=group value=\"$u\">\n";
	print "<input type=hidden name=source value=1>\n";
	print "<td align=left><input type=submit value=\"$text{'gfilesys_edit'}\">\n";
	print "<select name=filesys>\n";
	foreach $f (@fslist) { print "<option>$f\n"; }
	print "</select></td></form>\n";

	if ($access{'filesys'} eq "*") {
		print "<form action=copy_group_form.cgi>\n";
		print "<input type=hidden name=group value=\"$u\">\n";
		print "<td align=right><input type=submit value=\"$text{'gfilesys_copy'}\">\n";
		print "</td></form>\n";
		}
	print "</tr></table>\n";
	}

print "<hr>\n";
&footer("", $text{'gfilesys_return'});

sub print_limit
{
if ($_[0] == 0) { print "<td>$text{'quota_unlimited'}</td>\n"; }
elsif ($bsize) { print "<td>",int($_[0]*$bsize/1024),"</td>"; }
else { print "<td>$_[0]</td>\n"; }
}

