#!/usr/local/bin/perl
# list_groups.cgi
# Lists all the groups with quotas on some filesystem

require './quota-lib.pl';
&ReadParse();
$f = $in{'dir'};
$whatfailed = $text{'lgroups_failed'};
&can_edit_filesys($f) ||
	&error($text{'lgroups_eallow'});
$form = 0;

# List quotas
&header($text{'lgroups_title'}, "", "list_groups");
print "<hr>\n";

$n = &filesystem_groups($f);
if ($n > $config{'display_max'} && !$access{'ro'}) {
	print "<b>",&text('lgroups_toomany', $f),"</b><br>\n";
	}
elsif ($n) {
	print "<h3>",&text('lgroups_quotas', $f),"</h3>\n";
	&show_buttons();
	print "<table border width=100%>\n";
	print "<tr $tb> <td></td>\n";

	$bsize = &block_size($f);
	($binfo, $finfo) = &filesystem_info($f, \%group, $n, $bsize);
	print "<td colspan=3 align=center>\n";
	if ($access{'diskspace'}) {
		print "<b>",$bsize ? $text{'lgroups_kbs'} :
				     $text{'lgroups_blocks'},
		      "</b> ($binfo)\n";
		}
	print "</td> <td colspan=3 align=center>\n";
	if ($access{'diskspace'}) {
		print "<b>$text{'lgroups_files'}</b> ($finfo)\n"
		}
	print "</td> </tr>\n";
	print "<tr $tb> <td><b>$text{'lgroups_group'}</b></td>\n";
	print "<td><b>$text{'lgroups_used'}</b></td> <td><b>$text{'lgroups_soft'}</b></td>\n";
	print "<td><b>$text{'lgroups_hard'}</b></td>\n";
	print "<td><b>$text{'lgroups_used'}</b></td> <td><b>$text{'lgroups_soft'}</b></td>\n";
	print "<td><b>$text{'lgroups_hard'}</b></td> </tr>\n";
	@order = (0 .. $n-1);
	if ($config{'sort_mode'} == 0) {
		@order = sort { $group{$b,'ublocks'} <=> $group{$a,'ublocks'} }
			      @order;
		}
	elsif ($config{'sort_mode'} == 2) {
		@order = sort { $group{$a,'group'} cmp $group{$b,'group'} }
			      @order;
		}
	foreach $i (@order) {
		next if (!&can_edit_group($group{$i,'group'}));
		print "<tr $cb>\n";
		if ($access{'ro'}) {
			print "<td>$group{$i,'group'}</td>\n";
			}
		else {
			print "<td><a href=\"edit_group_quota.cgi?group=",
				&urlize($group{$i,'group'}),"&filesys=",
				&urlize($f),"&source=0\">",
				"$group{$i,'group'}</a></td>\n";
			}
		local $ublocks = $group{$i,'ublocks'};
		if ($bsize) {
			$ublocks = int($ublocks*$bsize/1024);
			}
		if ($group{$i,'hblocks'} &&
		    $group{$i,'ublocks'} > $group{$i,'hblocks'}) {
			print "<td><font color=#ff0000>",
				&html_escape($ublocks),"</font></td>\n";
			}
		elsif ($group{$i,'sblocks'} &&
		       $group{$i,'ublocks'} > $group{$i,'sblocks'}) {
			print "<td><font color=#ff7700>",
				&html_escape($ublocks),"</font></td>\n";
			}
		else {
			print "<td>",&html_escape($ublocks),"</td>\n";
			}
		&print_limit($group{$i,'sblocks'});
		&print_limit($group{$i,'hblocks'});
		print "<td>$group{$i,'ufiles'}</td>\n";
		&print_limit($group{$i,'sfiles'});
		&print_limit($group{$i,'hfiles'});
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>",&text('lgroups_noquota', $f),"</b><br>\n";
	}
&show_buttons();

if ($access{'default'}) {
	print "<hr>\n";
	print &text('lgroups_info', $text{'lusers_useradmin'});
	print "<p>\n";

	@dquot = split(/\s+/, $config{"gsync_$f"});
	print "<form action=save_gsync.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<table width=100% border> <tr $tb>\n";
	print "<td colspan=2><b>$text{'lgroups_newgroup'}</b></td> </tr> <tr $cb>\n";

	print "<td width=50%><table><tr>\n";
	print "<td><b>$text{'lusers_sblimit'}</b></td> <td>\n";
	&quota_input("sblocks", $dquot[0]);
	print "</td> </tr><tr> <td><b>$text{'lusers_hblimit'}</b></td> <td>\n";
	&quota_input("hblocks", $dquot[1]);
	print "</td> </tr></table></td>\n";

	print "<td width=50%><table><tr>\n";
	print "<td><b>$text{'lusers_sflimit'}</b></td> <td>\n";
	&quota_input("sfiles", $dquot[2]);
	print "</td> </tr><tr> <td><b>$text{'lusers_hflimit'}</b></td> <td>\n";
	&quota_input("hfiles", $dquot[3]);
	print "</td> </tr></table></td>\n";
	print "</tr> </table>\n";
	print "<input type=submit value=$text{'lusers_apply'}></form>\n";
	}


print "<hr>\n";
&footer("", $text{'lgroups_return'});

sub print_limit
{
if ($_[0] == 0) { print "<td>$text{'quota_unlimited'}</td>\n"; }
elsif ($bsize) { print "<td>",int($_[0]*$bsize/1024),"</td>"; }
else { print "<td>$_[0]</td>\n"; }
}

sub show_buttons
{
print "<table width=100%><tr>\n";
if (!$access{'ro'}) {
	print "<form action=edit_group_quota.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<input type=hidden name=source value=0>\n";
	print "<td align=left width=33%>\n";
	print "<input type=submit value=\"$text{'lgroups_equota'}\">\n";
	print "<input name=group size=8> ",
	      &group_chooser_button("group", 0, $form),"</td></form>\n";
	$form++;
	}
else { print "<td width=33%></td>\n"; }

if ($access{'ggrace'}) {
	print "<form action=group_grace_form.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<td align=center width=33%>\n";
	print "<input type=submit value=\"$text{'lgroups_grace'}\">\n";
	print "</td></form>\n";
	$form++;
	}
else { print "<td width=33%></td>\n"; }

print "<form action=check_quotas.cgi>\n";
print "<input type=hidden name=filesys value=\"$f\">\n";
print "<input type=hidden name=source value=group>\n";
print "<td align=right width=33%><input type=submit value=\"$text{'lgroups_check'}\">\n";
print "</td></form> </tr></table>\n";
$form++;
}

