#!/usr/local/bin/perl
# yum_find.cgi
# Show a list of all packages from YUM

require './software-lib.pl';
&ReadParse();

&header();
print <<EOF;
<script>
function sel(m)
{
window.opener.ifield.value = m;
window.close();
return false;
}
</script>
EOF

# Build the list of all packages
open(PKG, "yum list |");
while(<PKG>) {
	if (/^(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s*$/) {
		push(@list, [ $1, $2, $3, $4 ]);
		}
	}
close(PKG);
@list = sort { lc($a->[0]) cmp lc($b->[0]) } @list;

# Show them all ..
print "<table width=100% cellpadding=1 cellspacing=1>\n";
print "<tr> <td><b>$text{'yum_package'}</b></td> ",
      "<td><b>$text{'yum_version'}</b></td> ",
      "<td><b>$text{'yum_arch'}</b></td> ",
      "<td><b>$text{'yum_source'}</b></td> </tr>\n";
foreach $p (@list) {
	print "<tr>\n";
	print "<td><a href='' onClick='sel(\"$p->[0]\")'>",
	      "$p->[0]</td>\n";
	print "<td>$p->[2]</td>\n";
	print "<td>$p->[1]</td>\n";
	print "<td>$p->[3]</td>\n";
	print "</tr>\n";
	}
print "</table>\n";

&footer();

