#!/usr/local/bin/perl
# save_sched.cgi
# Save scheduled monitoring options

require './status-lib.pl';
$access{'sched'} || &error($text{'sched_ecannot'});
&ReadParse();
&error_setup($text{'sched_err'});

# Parse and save inputs
$in{'email_def'} || $in{'email'} =~ /\S/ || &error($text{'sched_eemail'});
$config{'sched_email'} = $in{'email_def'} ? '' : $in{'email'};
$config{'sched_pager'} = $in{'pager_def'} ? '' : $in{'pager'};
if ($in{'from_def'}) {
	delete($config{'sched_from'});
	}
else {
	$in{'from'} =~ /^\S+$/ || &error($text{'sched_efrom'});
	$config{'sched_from'} = $in{'from'};
	}
if ($in{'smtp_def'}) {
	local %sconfig = &foreign_config("sendmail");
	$sconfig{'sendmail_path'} =~ /^(\S+)/ && &has_command("$1") ||
	    &error(&text('sched_eprog', "<tt>$sconfig{'sendmail_path'}</tt>"));
	delete($config{'sched_smtp'});
	}
else {
	gethostbyname($in{'smtp'}) || &check_ipaddress($in{'smtp'}) ||
		&error($text{'sched_esmtp'});
	$config{'sched_smtp'} = $in{'smtp'};
	}
$config{'sched_mode'} = $in{'mode'};
$in{'int'} =~ /^\d+$/ || &error($text{'sched_eint'});
$config{'sched_int'} = $in{'int'};
$config{'sched_period'} = $in{'period'};
$in{'offset'} =~ /^\d+$/ || &error($text{'sched_eoffset'});
$config{'sched_offset'} = $in{'offset'};
$config{'sched_warn'} = $in{'warn'};
$config{'sched_single'} = $in{'single'};
@hours = split(/\0/, $in{'hours'});
@hours || &error($text{'sched_ehours'});
$config{'sched_hours'} = @hours == 24 ? '' : join(" ", @hours);
@days = split(/\0/, $in{'days'});
@days || &error($text{'sched_edays'});
$config{'sched_days'} = @days == 7 ? '' : join(" ", @days);
&lock_file("$module_config_directory/config");
&write_file("$module_config_directory/config", \%config);
&unlock_file("$module_config_directory/config");

# Setup or remove the cron job
$cron_cmd = "$module_config_directory/monitor.pl";
&lock_file($cron_cmd);
&foreign_require("cron", "cron-lib.pl");
foreach $j (&foreign_call("cron", "list_cron_jobs")) {
	$job = $j if ($j->{'user'} eq 'root' && $j->{'command'} eq $cron_cmd);
	}
if ($job) {
	&foreign_call("cron", "delete_cron_job", $job);
	unlink($cron_cmd);
	}
if ($config{'sched_mode'}) {
	# Create the program that cron calls
	&cron::create_wrapper($cron_cmd, $module_name, "monitor.pl");

	# Setup the actual cron job
	$njob = { 'user' => 'root', 'active' => 1,
		  'hours' => '*', 'days' => '*',
		  'months' => '*', 'weekdays' => '*',
		  'command' => $cron_cmd };
	if ($config{'sched_period'} == 0) {
		$njob->{'mins'} = &make_interval(60);
		}
	elsif ($config{'sched_period'} == 1) {
		$njob->{'hours'} = &make_interval(24);
		$njob->{'mins'} = 0;
		}
	elsif ($config{'sched_period'} == 2) {
		$njob->{'days'} = &make_interval(31, 1);
		$njob->{'hours'} = $njob->{'mins'} = 0;
		}
	elsif ($config{'sched_period'} == 3) {
		$njob->{'months'} = &make_interval(12, 1);
		$njob->{'days'} = 1;
		$njob->{'hours'} = $njob->{'mins'} = 0;
		}
	&foreign_call("cron", "create_cron_job", $njob);
	}
&unlock_file($cron_cmd);
&webmin_log("sched");
&redirect("");

# make_interval(length, offset2)
sub make_interval
{
local (@rv, $i);
for($i=$config{'sched_offset'}+$_[1]; $i<$_[0]; $i+=$config{'sched_int'}) {
	push(@rv,$i);
	}
return join(",", @rv);
}

