#!/usr/local/bin/perl
# index.cgi
# Display all existing databases

require './postgresql-lib.pl';

# Check for PostgreSQL program
if (!-x $config{'psql'} || -d $config{'psql'}) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	print &text('index_esql', "<tt>$config{'psql'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Check for the config file
if (!-r $config{'hba_conf'}) {
	&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("postgresql", "man", "doc", "google"));
	if ($config{'setup_cmd'}) {
		# Offer to setup DB for first time
		print &text('index_setup', "<tt>$config{'hba_conf'}</tt>",
				  "<tt>$config{'setup_cmd'}</tt>"),"<p>\n";
		print "<form action=setup.cgi><center>\n";
		print "<input type=submit value='$text{'index_setupok'}'>\n";
		print "</center></form><p>\n";
		}
	else {
		# Config file wasn't found
		print &text('index_ehba', "<tt>$config{'hba_conf'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		}
	&ui_print_footer("/", $text{'index'});
	exit;
	}

$r = &is_postgresql_running();
if ($r == 0) {
	# Not running .. need to start it
	&main_header();
	print "<b>$text{'index_notrun'}</b> <p>\n";

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=start.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_start'}\"></td>\n";
		print "<td>",&text('index_startmsg',
		      "<tt>$config{'start_cmd'}</tt>"),"</td> </tr></table>\n";
		print "</form>\n";
		}
	}
elsif ($r == -1 && $access{'user'} && 0) {
	# Running, but the user's password is wrong
	&main_header();
	print "<p> <b>",&text('index_nouser', "<tt>$access{'user'}</tt>"),
	      "</b><p>\n";
	}
elsif ($r == -1) {
	# Running, but webmin doesn't know the login/password
	&main_header();
	print "<p> <b>$text{'index_nopass'}</b> <p>\n";
	print "<form action=login.cgi method=post>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'index_ltitle'}</b></td> </tr>\n";
	print "<tr $cb> <td><table cellpadding=2>\n";

	print "<tr> <td><b>$text{'index_login'}</b></td>\n";
	printf "<td><input name=login size=20 value='%s'></td> </tr>\n",
		$access{'user'} || $config{'login'};

	if (!$access{'user'}) {
		print "<tr> <td></td>\n";
		printf "<td><input type=checkbox name=sameunix value=1 %s> %s</td> </tr>\n",
			$config{'sameunix'} ? "checked" : "", $text{'index_sameunix'};
		}

	print "<tr> <td><b>$text{'index_pass'}</b></td>\n";
	print "<td><input name=pass size=20 type=password></td> </tr>\n";


	print "</table></td></tr></table>\n";
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=reset value='$text{'index_clear'}'>\n";
	print "</center></form>\n";
	}
elsif ($r == -2) {
	# Looks like a shared library problem
	&main_header();
	print &text('index_elibrary', "<tt>$config{'psql'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print &text('index_ldpath', "<tt>$ENV{$gconfig{'ld_env'}}</tt>",
		  "<tt>$config{'psql'}</tt>"),"<br>\n";
	print "<pre>$out</pre>\n";
	&ui_print_footer("/", $text{'index'});
	exit;
	}
else {
	# Running .. check version
	$postgresql_version = &get_postgresql_version();
	if (!$postgresql_version) {
		&main_header();
	        print &text('index_superuser',"$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
		&ui_print_footer("/", $text{'index'});
		exit;
		}
	if ($postgresql_version < 6.5) {
		&main_header();
		print &text('index_eversion', $postgresql_version, 6.5),
		      "<p>\n";
		&ui_print_footer("/", $text{'index'});
		exit;
		}

	# Check if we can re-direct to a single DB's page
	@alldbs = &list_databases();
	@titles = grep { &can_edit_db($_) } @alldbs;
	$can_all = (@alldbs == @titles);
	if (@titles == 1 && $access{'dbs'} ne '*' && !$access{'users'} &&
	    !$access{'create'} && !$access{'stop'}) {
		# Only one DB, so go direct to it!
		&redirect("edit_dbase.cgi?db=$titles[0]");
		exit;
		}

	# List the databases
	&main_header();
	print &ui_subheading($text{'index_dbs'});
	$can_create = $access{'create'} == 1 ||
		      $access{'create'} == 2 && @titles < $access{'max'};
	if (!@titles) {
		print "<b>$text{'index_nodbs'}</b> <p>\n";
		}
	else {
		@icons = map { "images/db.gif" } @titles;
		@links = map { "edit_dbase.cgi?db=$_" } @titles;
		@titles = map { &html_escape($_) } @titles;
		print "<a href=newdb_form.cgi>$text{'index_add'}</a><br>\n"
			if ($can_create);
		&icons_table(\@links, \@titles, \@icons, 5);
		}
	print "<a href=newdb_form.cgi>$text{'index_add'}</a><p>\n"
		if ($can_create);

	if ($access{'users'}) {
		print "<hr>\n";
		print &ui_subheading($text{'index_users'});
		@links = ( 'list_users.cgi', 'list_groups.cgi',
			   'list_hosts.cgi', 'list_grants.cgi' );
		@titles = ( $text{'user_title'}, $text{'group_title'},
			    $text{'host_title'}, $text{'grant_title'} );
		@images = ( 'images/users.gif', 'images/groups.gif',
			    'images/hosts.gif', 'images/grants.gif' );
		&icons_table(\@links, \@titles, \@images, 5);
		}

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=stop.cgi>\n";
		print "<table width=100%><tr><td width=25%>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_stop'}\"></td>\n";
		print "<td>$text{'index_stopmsg'}</td> </tr></table>\n";
		print "</form>\n";
		}

	# Show backup all button
	if ($can_all && $access{'backup'}) {
		print "<hr>\n" if (!$access{'stop'});
		print "<form action=backup_form.cgi>\n";
		print "<input type=hidden name=all value=1>\n";
		print "<table width=100%><tr><td width=25%>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_backup'}\"></td>\n";
		print "<td>$text{'index_backupmsg'}</td> </tr></table>\n";
		print "</form>\n";
		}

	# Check if the optional perl modules are installed
	&read_acl(\%acl, undef);
	if ($acl{$base_remote_user, 'cpan'}) {
		eval "use DBI";
		push(@needs, "DBI") if ($@);
		$nodbi++ if ($@);
		eval "use DBD::Pg";
		push(@needs, "DBD::Pg") if ($@);
		if (@needs) {
			$needs = &urlize(join(" ", @needs));
			print "<center><b>",&text(@needs == 2 ? 'index_nomods' : 'index_nomod', @needs,
				"/cpan/download.cgi?source=3&cpan=$needs&mode=2&return=/$module_name/&returndesc=".&urlize($text{'index_return'})),
				"</b></center>\n";
			}
		}
	}

&ui_print_footer("/", "index");

sub main_header
{
&ui_print_header(undef, $text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("postgresql", "man", "doc", "google"),
	undef, undef, $postgresql_version ?
	   &text('index_version', $postgresql_version).
	   (&supports_schemas($config{'basedb'}) ? " $text{'index_sch'}" : "") :
	   undef);
}

