#!/usr/local/bin/perl
# list_secrets.cgi
# Displays a list of all PAP secrets

require './pptp-server-lib.pl';
$access{'secrets'} || &error($text{'secrets_ecannot'});
&ui_print_header(undef, $text{'secrets_title'}, "", "secrets");

if (!-r $config{'pap_file'}) {
	print "<p>", &text('secrets_enopfile', $config{'pap_file'},
			   "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	&ui_print_footer("/", $text{'secrets_return'});
	exit;
	}

# Get the system's hostname for selecting PPP accounts
$host = &get_ppp_hostname();

print &text('secrets_desc', "<tt>$config{'pap_file'}</tt>", "<tt>$host</tt>",
	   $config{'pap_file'} =~ /pap-secrets/ ? "PAP" : "CHAP"),"<p>\n";

@sec = grep { $_->{'server'} eq $host } &list_secrets();
if (@sec) {
	print "<a href=edit_secret.cgi>$text{'secrets_create'}</a><br>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>",&text('secrets_table', "<tt>$hostname</tt>"),
	      "</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	print "<tr> <td width=25%><b>", $text{'secrets_user'}, "</b></td> ",
	      "<td width=25%><b>", $text{'secrets_ips'}, "</b></td> ",
	      "<td width=25%><b>", $text{'secrets_user'}, "</b></td> ",
	      "<td width=25%><b>", $text{'secrets_ips'}, "</b></td> </tr>\n";
	for($i=0; $i<@sec; $i++) {
		if ($i%2 == 0) { print "<tr>\n"; }
		$s = $sec[$i];
		printf "<td width=25%%>".
		       "<a href='edit_secret.cgi?$s->{'index'}'>%s</a></td>\n",
			$s->{'client'} ? &html_escape($s->{'client'})
				       : $text{'secrets_uany'};
		@i = @{$s->{'ips'}};
		printf "<td width=25%%>%s</td>\n",
			$i[0] eq "*" || $i[0] eq "" ? $text{'edit_secret_aany'}:
			$i[0] eq "-" ? $text{'edit_secret_anone'} :
				       &html_escape(join(" ", @i));
		if ($i%2 == 1) { print "</tr>\n"; }
		}
	print "</table></td></tr></table>\n";
	}
else {
	print "<b>$text{'secrets_none'}</b><p>\n";
	}
print "<a href=edit_secret.cgi>$text{'secrets_create'}</a><p>\n";

&ui_print_footer("", $text{'secrets_return'});

