#!/usr/local/bin/perl
# list_users.cgi
# Lists all the users with quotas on some filesystem

require './quota-lib.pl';
&ReadParse();
$f = $in{'dir'};
$whatfailed = $text{'lusers_failed'};
&can_edit_filesys($f) ||
	&error($text{'lusers_eallow'});
$form = 0;

# List quotas
&ui_print_header(undef, $text{'lusers_title'}, "", "list_users");

$n = &filesystem_users($f);
if ($n > $config{'display_max'} && !$access{'ro'}) {
	print "<b>", &text('lusers_toomany', $f), "</b><br>\n";
	}
elsif ($n) {
	$bsize = &block_size($f);
	$fsbsize = &block_size($f, 1);
	# no threshold (default) if <= 0% and >=101%
	my $threshold_pc = $config{'threshold_pc'} || 101;
	$threshold_pc = 101 if $threshold_pc < 1 or $threshold_pc > 101;
	print &ui_subheading(&text('lusers_qoutas', $f));
	&show_buttons();
	print "<table border width=100%>\n";
	print "<tr $tb> <td><br></td>\n";

	($binfo, $finfo) = &filesystem_info($f, \%user, $n, $fsbsize);
	$cols1 = 3 + ($threshold_pc != 101 ? 1 : 0) +
		     ($config{'show_grace'} ? 1 : 0);
	$cols2 = 3 + ($config{'show_grace'} ? 1 : 0);
	print "<td colspan=$cols1 align=center>\n";
	if ($access{'diskspace'}) {
		print "<b>",$bsize ? $text{'lusers_space'} :
				     $text{'lusers_blocks'},
		      "</b> ($binfo)\n";
		}
	print "</td> <td colspan=$cols2 align=center>\n";
	if ($access{'diskspace'}) {
		print "<b>$text{'lusers_files'}</b> ($finfo)\n"
		}

	print "</td> </tr>\n";
	print "<tr $tb> <td><b>$text{'lusers_user'}</b></td>\n";
	if ($threshold_pc != 101) {
		print "<td><b>$text{'lusers_pc_hblocks'}</b></td>";
		}
	print "<td><b>$text{'lusers_used'}</b></td> <td><b>$text{'lusers_soft'}</b></td>\n";
	print "<td><b>$text{'lusers_hard'}</b></td>\n";
	print "<td><b>$text{'lusers_grace'}</b></td>\n"
		if ($config{'show_grace'});
	print "<td><b>$text{'lusers_used'}</b></td> <td><b>$text{'lusers_soft'}</b></td>\n";
	print "<td><b>$text{'lusers_hard'}</b></td>\n";
	print "<td><b>$text{'lusers_grace'}</b></td>\n"
		if ($config{'show_grace'});
	print "</tr>\n";
	@order = (0 .. $n-1);
	if ($config{'sort_mode'} == 0) {
		@order = sort { $user{$b,'ublocks'} <=> $user{$a,'ublocks'} }
			      @order;
		}
	elsif ($config{'sort_mode'} == 2) {
		@order = sort { $user{$a,'user'} cmp $user{$b,'user'} }
			      @order;
		}
	foreach $i (@order) {
		next if (!&can_edit_user($user{$i,'user'}));
		print "<tr $cb>\n";
		if ($access{'ro'}) {
			print "<td>$user{$i,'user'}</td>\n";
			}
		else {
			print "<td><a href=\"edit_user_quota.cgi?user=",
				&urlize($user{$i,'user'}),"&filesys=",
				&urlize($f),"&source=0\">$user{$i,'user'}",
				"</a></td>\n";
			}
                my $pc_hblocks=0;
                if($user{$i,'hblocks'}) {
                        $pc_hblocks = 100 * $user{$i,'ublocks'};
                        $pc_hblocks/= $user{$i,'hblocks'};
                        $pc_hblocks = int($pc_hblocks);
                }
		if ($threshold_pc != 101) {
			if ($pc_hblocks > $threshold_pc) {
				print "<td><font color=#ff0000>",
					&html_escape($pc_hblocks),"%</font></td>\n";
			} else {
				print "<td>",&html_escape($pc_hblocks),"%</td>\n";
			}
		}
		local $ublocks = $user{$i,'ublocks'}; 
		if ($bsize) {
			$ublocks = &nice_size($ublocks*$bsize);
			}
		if ($user{$i,'hblocks'} &&
		    $user{$i,'ublocks'} > $user{$i,'hblocks'}) {
			print "<td><font color=#ff0000>",
				&html_escape($ublocks),"</font></td>\n";
			}
		elsif ($user{$i,'sblocks'} &&
		       $user{$i,'ublocks'} > $user{$i,'sblocks'}) {
			print "<td><font color=#ff7700>",
				&html_escape($ublocks),"</font></td>\n";
			}
		else {
			print "<td>",&html_escape($ublocks),"</td>\n";
			}
		&print_limit($user{$i,'sblocks'}, 0);
		&print_limit($user{$i,'hblocks'}, 0);
		&print_grace($user{$i,'gblocks'}) if ($config{'show_grace'});
		print "<td>$user{$i,'ufiles'}</td>\n";
		&print_limit($user{$i,'sfiles'}, 1);
		&print_limit($user{$i,'hfiles'}, 1);
		&print_grace($user{$i,'gfiles'}) if ($config{'show_grace'});
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>",&text('lusers_noquota', $f),"</b><br>\n";
	}
&show_buttons();

# Show form for setting default quotas for new users
if ($access{'default'}) {
	print "<hr>\n";
	print &text('lusers_info', $text{'lusers_useradmin'});
	print "<p>\n";

	@dquot = split(/\s+/, $config{"sync_$f"});
	print "<form action=save_sync.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<table width=100% border> <tr $tb>\n";
	print "<td colspan=2><b>$text{'lusers_newuser'}</b></td> </tr> <tr $cb>\n";

	print "<td width=50%><table><tr>\n";
	print "<td><b>$text{'lusers_sblimit'}</b></td> <td>\n";
	&quota_input("sblocks", $dquot[0]);
	print "</td> </tr><tr> <td><b>$text{'lusers_hblimit'}</b></td> <td>\n";
	&quota_input("hblocks", $dquot[1]);
	print "</td> </tr></table></td>\n";

	print "<td width=50%><table><tr>\n";
	print "<td><b>$text{'lusers_sflimit'}</b></td> <td>\n";
	&quota_input("sfiles", $dquot[2]);
	print "</td> </tr><tr> <td><b>$text{'lusers_hflimit'}</b></td> <td>\n";
	&quota_input("hfiles", $dquot[3]);
	print "</td> </tr></table></td>\n";
	print "</tr> </table>\n";
	print "<input type=submit value=$text{'lusers_apply'}></form>\n";
	}

# Show form for email notifications
if ($access{'email'} && &foreign_check("cron") && &foreign_check("mailboxes")) {
	print "<hr>\n";
	print &ui_form_start("save_email.cgi");
	print &ui_hidden("filesys", $f);
	print &ui_table_start($text{'lusers_emailheader'}, "width=100%", 4);

	print &ui_table_row($text{'lusers_email'},
		    &ui_radio("email", $config{"email_$f"} ? 1 : 0,
			      [ [ 1, $text{'yes'} ], [ 0, $text{'no'} ] ]));

	print &ui_table_row($text{'lusers_interval'},
		    &ui_textbox("interval", $config{"email_interval_$f"}, 5).
		    " ".$text{'lusers_hours'});

	print &ui_table_row($text{'lusers_ltype'},
		    &ui_radio("type", $config{"email_type_$f"} ? 1 : 0,
			      [ [ 1, $text{'lusers_hard'} ],
				[ 0, $text{'lusers_soft'} ] ]));

	print &ui_table_row($text{'lusers_percent'},
		    &ui_textbox("percent", $config{"email_percent_$f"}, 5).
		    " %");

	print &ui_table_row($text{'lusers_domain'},
		    &ui_textbox("domain", $config{"email_domain_$f"} ||
					  &get_system_hostname(), 20));

	print &ui_table_row($text{'lusers_from'},
		    &ui_textbox("from", $config{"email_from_$f"} ||
					  'webmin@'.&get_system_hostname(), 20));

	print &ui_table_end();
	print &ui_form_end([ [ 'save', $text{'lusers_apply'} ] ]);
	}

&ui_print_footer("", $text{'lusers_return'});

# show_buttons(form)
sub show_buttons
{
print "<table width=100%><tr>\n";
if (!$access{'ro'}) {
	print "<form action=edit_user_quota.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<input type=hidden name=source value=0>\n";
	print "<td align=left width=33%>\n";
	print "<input type=submit value=\"$text{'lusers_equota'}\">\n";
	print "<input name=user size=8> ",
	      &user_chooser_button("user", 0, $form),"</td></form>\n";
	$form++;
	}
else { print "<td width=33%></td>\n"; }

if ($access{'ugrace'}) {
	print "<form action=user_grace_form.cgi>\n";
	print "<input type=hidden name=filesys value=\"$f\">\n";
	print "<td align=center width=33%>\n";
	print "<input type=submit value=\"$text{'lusers_egrace'}\">\n";
	print "</td></form>\n";
	$form++;
	}
else { print "<td width=33%></td>\n"; }

print "<form action=check_quotas.cgi>\n";
print "<input type=hidden name=filesys value=\"$f\">\n";
print "<input type=hidden name=source value=user>\n";
print "<td align=right width=33%><input type=submit value=\"$text{'lusers_check'}\">\n";
print "</td></form> </tr></table>\n";
$form++;
}

