#!/usr/local/bin/perl
# Change the procmail rule that delivers spam

require './spam-lib.pl';
&error_setup($text{'procmail_err'});
&can_use_check("procmail");
&ReadParse();

# Validate inputs
if ($in{'to'} == 0) {
	$file = "/dev/null";
	}
elsif ($in{'to'} == 1) {
	$in{'file'} =~ /^\S+$/ || &error($text{'setup_efile'});
	$file = $in{'file'};
	}
elsif ($in{'to'} == 2) {
	$in{'maildir'} =~ /^\S+$/ || &error($text{'setup_emaildir'});
	$file = "$in{'maildir'}/";
	}
elsif ($in{'to'} == 3) {
	$in{'mhdir'} =~ /^\S+$/ || &error($text{'setup_emhdir'});
	$file = "$in{'mhdir'}/.";
	}

# Find the existing recipe
&foreign_require("procmail", "procmail-lib.pl");
@pmrcs = &get_procmailrc();
$pmrc = $pmrcs[$#pmrcs];
@recipes = &procmail::parse_procmail_file($pmrc);
$spamrec = &find_file_recipe(\@recipes);

&lock_file($pmrc);
if ($file) {
	if ($spamrec) {
		# Update the recipe
		$spamrec->{'action'} = $file;
		&procmail::modify_recipe($spamrec);
		}
	else {
		# Add a new recipe
		$spamrec = { 'flags' => [ ],
			     'conds' => [ [ '', '^X-Spam-Status: Yes' ] ],
			     'action' => $file };
		&procmail::create_recipe($spamrec, $pmrc);
		}
	}
elsif ($spamrec) {
	# Remove the recipe, to fall back to default delivery
	&procmail::delete_recipe($spamrec);
	}
&unlock_file($pmrc);

# All done!
&webmin_log("procmail");
&redirect("");

